/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Coord;
import cds.fits.Fits;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedFast;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Context;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ThreadBuilderTile;

public class ThreadBuilderTileColor
extends ThreadBuilderTile {
    public ThreadBuilderTileColor(Context context, BuilderRunner builder) {
        super(context, builder);
    }

    @Override
    Fits buildHealpix1(BuilderRunner bt, BuilderRunner.AddrThread cell, ThreadBuilderTile.SrcFile[] downFiles, int deb, int fin, double[] tileWeight, double maxExpTime) throws Exception {
        boolean empty = true;
        double[] radec = new double[2];
        Coord coo = new Coord();
        ThreadBuilderTile.SrcFile file = null;
        Fits out = null;
        int bitpix = this.bitpix;
        int tileSide = this.context.getTileSide();
        try {
            long min = cell.npix * (long)tileSide * (long)tileSide;
            out = new Fits(tileSide, tileSide, bitpix);
            if (this.context.targetColorMode == 0) {
                for (int i = 0; i < out.rgb.length; ++i) {
                    out.rgb[i] = -16777216;
                }
            }
            int overlay = fin - deb;
            double[] pixcoef = new double[overlay];
            double[] pixvalR = new double[overlay];
            double[] pixvalG = new double[overlay];
            double[] pixvalB = new double[overlay];
            boolean gal2ICRS = this.context.getFrame() != 0;
            int orderPix = cell.order + this.context.getTileOrder();
            HealpixNestedFast hn = Healpix.getNestedFast(orderPix);
            for (int y = 0; y < out.height; ++y) {
                for (int x = 0; x < out.width; ++x) {
                    int nbPix = 0;
                    double totalCoef = 0.0;
                    int removed = 0;
                    long index = min + (long)this.context.xy2hpx[y * out.width + x];
                    this.computeCoo(coo, hn, index, radec, gal2ICRS);
                    for (int i = deb; i < fin; ++i) {
                        try {
                            int pix;
                            file = downFiles[i];
                            if (file.flagRemoved) continue;
                            if (!this.open(file, 0)) {
                                if (++removed < fin - deb) continue;
                                return null;
                            }
                            try {
                                file.fitsfile.getCalib().GetXY(coo, false);
                            }
                            catch (Exception e) {
                                System.err.println("Problem on calib: " + file.name + " => exception " + e.getMessage() + " tile=" + cell);
                                ThreadBuilderTileColor threadBuilderTileColor = this;
                                if (threadBuilderTileColor.context.getVerbose() < 3) continue;
                                e.printStackTrace();
                                continue;
                            }
                            coo.y = (double)file.fitsfile.height - coo.y - 1.0;
                            coo.x -= 1.0;
                            if (!this.isIn(file, coo) || (pix = this.getBilinearPixelRGB(file, coo)) == 0) continue;
                            pixvalR[nbPix] = 0xFF & pix >> 16;
                            pixvalG[nbPix] = 0xFF & pix >> 8;
                            pixvalB[nbPix] = 0xFF & pix;
                            pixcoef[nbPix] = this.getCoef(file, coo, this.modeCoadd, maxExpTime);
                            totalCoef += pixcoef[nbPix];
                            if (!this.reachMaxProgenitors(++nbPix)) continue;
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    int pixelFinal = 0;
                    if (nbPix != 0) {
                        int i;
                        double b;
                        double g;
                        if (totalCoef == 0.0) {
                            pixelFinal = 0xFF000000 | ((int)pixvalR[0] & 0xFF) << 16 | ((int)pixvalG[0] & 0xFF) << 8 | (int)pixvalB[0] & 0xFF;
                        } else if (this.modeCoadd == ModeOverlay.overlayAdd) {
                            double r = 0.0;
                            g = 0.0;
                            b = 0.0;
                            for (i = 0; i < nbPix; ++i) {
                                r += pixvalR[i];
                                g += pixvalG[i];
                                b += pixvalB[i];
                            }
                            if (r > 255.0) {
                                r = 255.0;
                            }
                            if (g > 255.0) {
                                g = 255.0;
                            }
                            if (b > 255.0) {
                                b = 255.0;
                            }
                            pixelFinal = 0xFF000000 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
                        } else {
                            double r = 0.0;
                            g = 0.0;
                            b = 0.0;
                            for (i = 0; i < nbPix; ++i) {
                                r += pixvalR[i] * pixcoef[i] / totalCoef;
                                g += pixvalG[i] * pixcoef[i] / totalCoef;
                                b += pixvalB[i] * pixcoef[i] / totalCoef;
                            }
                            if (r > 255.0) {
                                r = 255.0;
                            } else if (r < 0.0) {
                                r = 0.0;
                            }
                            if (g > 255.0) {
                                g = 255.0;
                            } else if (g < 0.0) {
                                g = 0.0;
                            }
                            if (b > 255.0) {
                                b = 255.0;
                            } else if (b < 0.0) {
                                b = 0.0;
                            }
                            pixelFinal = 0xFF000000 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
                        }
                        empty = false;
                    }
                    out.setPixelRGBJPG(x, y, pixelFinal);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            empty = true;
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        return !empty ? out : null;
    }

    @Override
    protected boolean open(ThreadBuilderTile.SrcFile file, int z) throws Exception {
        try {
            file.open(z);
        }
        catch (Exception e) {
            ThreadBuilderTileColor threadBuilderTileColor = this;
            if (threadBuilderTileColor.context.getVerbose() >= 3) {
                e.printStackTrace();
            }
            String f1 = this.context.addFileRemoveList(file.name);
            this.context.warning("Problem on open => file ignored [" + f1 + "]");
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("space") >= 0) {
                this.context.taskAbort();
                throw e;
            }
            file.flagRemoved = true;
            return false;
        }
        return true;
    }

    protected final int getBilinearPixelRGB(ThreadBuilderTile.SrcFile srcFile, Coord coo) {
        boolean c3;
        Fits f = srcFile.fitsfile;
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int ox1 = x1;
        int oy1 = y1;
        int ox2 = x2;
        int oy2 = y2;
        if (x2 < f.xCell || y2 < f.yCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell) {
            return 0;
        }
        if (ox1 == f.xCell - 1) {
            ++ox1;
        }
        if (oy1 == f.yCell - 1) {
            ++oy1;
        }
        if (ox2 == f.xCell + f.widthCell) {
            --ox2;
        }
        if (oy2 == f.yCell + f.heightCell) {
            --oy2;
        }
        int b0 = f.getPixelRGBJPG(ox1, oy1);
        int b1 = f.getPixelRGBJPG(ox2, oy1);
        int b2 = f.getPixelRGBJPG(ox1, oy2);
        int b3 = f.getPixelRGBJPG(ox2, oy2);
        boolean c0 = (b0 & 0xFF000000) == 0;
        boolean c1 = (b1 & 0xFF000000) == 0;
        boolean c2 = (b2 & 0xFF000000) == 0;
        boolean bl = c3 = (b3 & 0xFF000000) == 0;
        if (c0 && c1 && c2 && c3) {
            return 0;
        }
        if (c0 || c1 || c2 || c3) {
            int a;
            int n = !c0 ? b0 : (!c1 ? b1 : (a = !c2 ? b2 : b3));
            if (c0) {
                b0 = a;
            }
            if (c1) {
                b1 = a;
            }
            if (c2) {
                b2 = a;
            }
            if (c3) {
                b3 = a;
            }
        }
        int pix = 255;
        for (int i = 16; i >= 0; i -= 8) {
            double a0 = 0xFF & b0 >> i;
            double a1 = 0xFF & b1 >> i;
            double a2 = 0xFF & b2 >> i;
            double a3 = 0xFF & b3 >> i;
            int p = (int)(this.bilineaire(x1, y1, x2, y2, x, y, a0, a1, a2, a3) + 0.5);
            if (p < 0) {
                p = 0;
            } else if (p > 255) {
                p = 255;
            }
            pix = pix << 8 | p;
        }
        return pix;
    }
}

