/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.fits.Fits;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedFast;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Context;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ThreadBuilderTile;
import cds.tools.pixtools.CDSHealpix;

public class ThreadBuilderTile3D
extends ThreadBuilderTile {
    public ThreadBuilderTile3D(Context context, BuilderRunner builder) {
        super(context, builder);
    }

    @Override
    Fits buildHealpix1(BuilderRunner bt, BuilderRunner.AddrThread addr, ThreadBuilderTile.SrcFile[] downFiles, int deb, int fin, double[] tileWeight, double maxExpTime) throws Exception {
        double dataMax;
        double dataMin;
        double bZero;
        double bScale;
        Fits out;
        boolean empty;
        long t0;
        block40: {
            t0 = System.currentTimeMillis();
            empty = true;
            double[] radec = new double[2];
            Coord coo = new Coord();
            ThreadBuilderTile.SrcFile file = null;
            out = null;
            int bitpix = this.bitpix;
            double blank = this.blank;
            bScale = this.bScale;
            bZero = this.bZero;
            dataMin = Double.NaN;
            dataMax = Double.NaN;
            int tileSide = this.context.getTileSide();
            int tileDepth = this.context.getTileDepth();
            try {
                long min = addr.npix * (long)tileSide * (long)tileSide;
                boolean flagModifBitpix = this.modifBitPix();
                if (flagModifBitpix && tileWeight != null) {
                    bitpix = this.context.getBitpixOrig();
                    blank = bitpix < 0 ? Double.NaN : this.blankOrig;
                    flagModifBitpix = false;
                }
                out = new Fits(tileSide, tileSide, tileDepth, bitpix);
                int xa = out.width;
                int ya = out.height;
                int za = out.depth;
                int xb = -1;
                int yb = -1;
                int zb = -1;
                out.setBlank(blank);
                out.setBzero(bZero);
                out.setBscale(bScale);
                int overlay = fin - deb;
                double[][] pixval = new double[overlay][tileDepth];
                double[][] pixcoef = new double[overlay][tileDepth];
                int[] nbPix = new int[tileDepth];
                double[] totalCoef = new double[tileDepth];
                boolean gal2ICRS = this.context.getFrame() != 0;
                int orderPix = addr.order + this.context.getTileOrder();
                int forderTile = (int)CDSHealpix.log2(tileDepth);
                HealpixNestedFast hn = Healpix.getNestedFast(orderPix);
                int zmin = 0;
                int zmax = out.depth;
                int nbOverlayMax = 0;
                for (int y = 0; y < out.height; ++y) {
                    for (int x = 0; x < out.width; ++x) {
                        long index = min + (long)this.context.xy2hpx[y * out.width + x];
                        this.computeCoo(coo, hn, index, radec, gal2ICRS);
                        for (int z = 0; z < tileDepth; ++z) {
                            nbPix[z] = 0;
                            totalCoef[z] = 0.0;
                        }
                        int removed = 0;
                        for (int i = deb; i < fin; ++i) {
                            try {
                                file = downFiles[i];
                                if (file.flagRemoved) continue;
                                if (!this.open(file, 0)) {
                                    if (++removed < fin - deb) continue;
                                    return null;
                                }
                                try {
                                    file.fitsfile.getCalib().GetXY(coo, false);
                                }
                                catch (Exception e) {
                                    System.err.println("Problem on calib: " + file.name + " => exception " + e.getMessage() + " tile=" + addr);
                                    ThreadBuilderTile3D threadBuilderTile3D = this;
                                    if (threadBuilderTile3D.context.getVerbose() < 3) continue;
                                    e.printStackTrace();
                                    continue;
                                }
                                coo.y = (double)file.fitsfile.height - coo.y - 1.0;
                                coo.x -= 1.0;
                                if (!this.isIn(file, coo)) continue;
                                try {
                                    CalibFreq cf = file.fitsfile.getCalibFreq();
                                    int orderZfull = addr.orderZ + forderTile;
                                    for (int z = 0; z < out.depth; ++z) {
                                        pixval[nbPix[z]][z] = blank;
                                        if (z < zmin || z >= zmax) continue;
                                        if (this.modeCoadd == ModeOverlay.overlayMeanMax && nbPix[z] >= ModeOverlay.OVERLAYMEAN_MAX) {
                                            ++nbOverlayMax;
                                            continue;
                                        }
                                        double freq = CalibFreq.pix2freq(orderZfull, addr.npixZ * (long)tileDepth + (long)z);
                                        double channel = cf.getChannel(freq);
                                        double pix = this.getBilinearVoxel(file, coo, channel, file.blank);
                                        if (Double.isNaN(pix)) continue;
                                        pixval[nbPix[z]][z] = pix;
                                        int n = z;
                                        double d = this.getCoef(file, coo, z, this.modeCoadd, maxExpTime);
                                        pixcoef[nbPix[z]][z] = d;
                                        totalCoef[n] = totalCoef[n] + d;
                                        int n2 = z;
                                        nbPix[n2] = nbPix[n2] + 1;
                                    }
                                }
                                catch (Exception e) {
                                    System.err.println("Problem on calib.freq: " + file.name + " => exception " + e.getMessage() + " tile=" + addr);
                                    ThreadBuilderTile3D threadBuilderTile3D = this;
                                    if (threadBuilderTile3D.context.getVerbose() < 3) continue;
                                    e.printStackTrace();
                                    continue;
                                }
                                if (this.modeCoadd != ModeOverlay.overlayNone) continue;
                                break;
                            }
                            catch (Exception e) {
                                ThreadBuilderTile3D threadBuilderTile3D = this;
                                if (threadBuilderTile3D.context.getVerbose() < 3) continue;
                                e.printStackTrace();
                            }
                        }
                        for (int z = 0; z < tileDepth; ++z) {
                            double pixelFinal;
                            if (nbPix[z] == 0) {
                                pixelFinal = blank;
                            } else {
                                pixelFinal = 0.0;
                                if (this.modeCoadd == ModeOverlay.overlayAdd) {
                                    empty = false;
                                    for (int i = 0; i < nbPix[z]; ++i) {
                                        double d;
                                        double a = pixval[i][z] * pixcoef[i][z];
                                        if (pixelFinal / 2.0 + d / 2.0 > this.maxDemi) {
                                            pixelFinal = this.max;
                                            break;
                                        }
                                        pixelFinal += a;
                                    }
                                } else if (totalCoef[z] == 0.0) {
                                    empty = false;
                                    pixelFinal = pixval[0][z];
                                } else {
                                    empty = false;
                                    for (int i = 0; i < nbPix[z]; ++i) {
                                        pixelFinal += pixval[i][z] * pixcoef[i][z] / totalCoef[z];
                                    }
                                }
                                pixelFinal = this.modifBitpix(pixelFinal, flagModifBitpix);
                            }
                            if (this.context.trim && !out.isBlankPixel(pixelFinal)) {
                                if (x < xa) {
                                    xa = x;
                                }
                                if (x > xb) {
                                    xb = x;
                                }
                                if (y < ya) {
                                    ya = y;
                                }
                                if (y > yb) {
                                    yb = y;
                                }
                                if (z < za) {
                                    za = z;
                                }
                                if (z > zb) {
                                    zb = z;
                                }
                            }
                            out.setPixelDouble(x, y, z, pixelFinal);
                            if (tileWeight != null) {
                                tileWeight[z * tileSide * tileSide + y * tileSide + x] = totalCoef[z];
                            }
                            if (Double.isNaN(dataMin) || pixelFinal < dataMin) {
                                dataMin = pixelFinal;
                            }
                            if (!Double.isNaN(dataMax) && !(pixelFinal > dataMax)) continue;
                            dataMax = pixelFinal;
                        }
                    }
                }
                if (this.modeCoadd == ModeOverlay.overlayMeanMax && nbOverlayMax == out.width * out.height * out.depth) {
                    out.hipsTileDone = 1;
                }
                if (!this.context.trim || empty) break block40;
                out.setBorder(new int[]{xa, xb, ya, yb, za, zb});
            }
            catch (Exception e) {
                e.printStackTrace();
                empty = true;
                if (tileWeight == null) break block40;
                for (int i = 0; i < tileWeight.length; ++i) {
                    tileWeight[i] = 0.0;
                }
            }
        }
        if (!empty && !Double.isNaN(dataMin)) {
            out.setDataMinMax(dataMin * bScale + bZero, dataMax * bScale + bZero);
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        tleaf += System.currentTimeMillis() - t0;
        return !empty ? out : null;
    }

    protected double getCoef(ThreadBuilderTile.SrcFile file, Coord coo, double z, ModeOverlay mode, double maxExpTime) {
        double coef1 = this.getCoef(file.fitsfile, coo, z, mode);
        if (maxExpTime <= 0.0) {
            return coef1;
        }
        double coef2 = file.weight / maxExpTime;
        return coef1 * coef2;
    }

    private double getCoef(Fits f, Coord coo, double z, ModeOverlay mode) {
        int x1 = (int)coo.x;
        int y1 = (int)coo.y;
        int z1 = (int)z;
        double div = 1.0;
        if (x1 > 0 && x1 < f.width - 1 && (coo.x <= (double)f.xCell || coo.x >= (double)(f.xCell + f.widthCell - 1))) {
            div *= 2.0;
        }
        if (y1 > 0 && y1 < f.height - 1 && (coo.y <= (double)f.yCell || coo.y >= (double)(f.yCell + f.heightCell - 1))) {
            div *= 2.0;
        }
        if (z1 > 0 && z1 < f.depth - 1 && (z <= (double)f.zCell || z >= (double)(f.zCell + f.depthCell - 1))) {
            div *= 2.0;
        }
        double c = mode != ModeOverlay.overlayFading ? 1.0 : this.getCoefFading(f, coo);
        return c / div;
    }

    private final double getBilinearVoxel(ThreadBuilderTile.SrcFile srcFile, Coord coo, double z, double myBlank) {
        boolean b1;
        Fits f = srcFile.fitsfile;
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int z1 = (int)z;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        if (x2 < f.xCell || y2 < f.yCell || z2 < f.zCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell || z1 >= f.zCell + f.depthCell) {
            return Double.NaN;
        }
        int oz1 = z1;
        int oz2 = z2;
        if (oz1 > 0 && oz1 == f.zCell - 1 || oz2 + f.depthCell < f.depth - 1 && oz2 == f.zCell + f.depthCell) {
            return Double.NaN;
        }
        if (oz1 == f.zCell - 1) {
            ++oz1;
        }
        if (oz2 == f.zCell + f.depthCell) {
            --oz2;
        }
        double a0 = this.getBilinearPixel(srcFile, coo, oz1, myBlank, false);
        if (oz1 == oz2) {
            return a0;
        }
        double a1 = this.getBilinearPixel(srcFile, coo, oz2, myBlank, false);
        boolean b0 = Double.isNaN(a0) || a0 == myBlank;
        boolean bl = b1 = Double.isNaN(a1) || a1 == myBlank;
        if (b0 && b1) {
            return Double.NaN;
        }
        if (b1) {
            return a0;
        }
        if (b0) {
            return a1;
        }
        return this.lineaire(oz1, oz2, z, a0, a1);
    }

    private final double lineaire(int z1, int z2, double z, double a0, double a1) {
        if (z == (double)z1) {
            return a0;
        }
        if (z == (double)z2) {
            return a1;
        }
        double d0 = 1.0 / (z - (double)z1);
        double d1 = 1.0 / ((double)z2 - z);
        return (a0 * d0 + a1 * d1) / (d0 + d1);
    }
}

