/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedFast;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Constante;
import cds.hipsgen.Context;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.MyInputStreamCached;
import cds.hipsgen.MyInputStreamCachedException;
import cds.tools.pixtools.Util;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ThreadBuilderTile {
    protected Context context;
    protected BuilderRunner builderTiles;
    protected BuilderRunner.ThreadBuilder threadBuilder;
    protected int bitpix;
    protected ModeOverlay modeCoadd;
    protected double max;
    protected double maxDemi;
    private boolean hasAlternateBlank;
    protected double blankOrig;
    protected double blank;
    private boolean flagColor;
    protected double bScale;
    protected double bZero;
    protected boolean fading;
    protected String hpxFinderPath = null;
    protected double[] cutOrig;
    protected double[] cut;
    private int[] borderSize;
    private Shape globalShape;
    private int tileSide;
    private int tileDepth;
    protected static int nbThreadsToStop = 0;
    protected static HashMap<File, Shape> hasShape = null;
    private Object objRel = new Object();
    private static final boolean TRACEMEM = true;
    static boolean DEBUG = false;
    static long statOnePass = 0L;
    static long statMultiPass = 0L;
    static int statMaxOverlays = 0;
    protected static final double toDeg = 57.29577951308232;
    protected static final double PI2 = 1.5707963267948966;
    public static int I = 0;
    public static long tleaf = 0L;
    private static final double OVERLAY_PROPORTION = 0.16666666666666666;
    int n = 0;

    public ThreadBuilderTile(Context context) {
        this.context = context;
        this.max = Fits.getMax(context.getBitpixOrig());
        this.maxDemi = this.max / 2.0;
        this.flagColor = context.isColor();
        if (!this.flagColor) {
            this.bZero = context.getBZero();
            this.bScale = context.getBScale();
            try {
                this.cutOrig = context.getCutOrig();
                this.cut = context.getCut();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.blankOrig = context.getBlankOrig();
            this.hasAlternateBlank = context.hasAlternateBlank();
            this.blank = context.getBlank();
        } else {
            this.blank = 0.0;
        }
        this.borderSize = context.getBorderSize();
        if (this.borderSize[0] < 1) {
            this.borderSize[0] = 1;
        }
        if (this.borderSize[1] < 1) {
            this.borderSize[1] = 1;
        }
        this.globalShape = context.globalShape;
        this.tileSide = context.getTileSide();
        this.tileDepth = context.getTileDepth();
    }

    public ThreadBuilderTile(Context context, BuilderRunner builder) {
        this(context);
        this.builderTiles = builder;
        this.hpxFinderPath = builder.getHpxFinderPath();
        this.modeCoadd = builder.getModeOverlay();
        this.bitpix = builder.getBitpix();
        this.fading = builder.getFading();
    }

    private boolean needMem(long rqMem) {
        long mem = CacheFits.getFreeMem();
        return mem - 0x2800000L < rqMem;
    }

    protected boolean requiredMem(long nbProgen, int nbThreads) throws Exception {
        int[] maxProgenCell = this.context.getProgenMaxCell();
        if (maxProgenCell == null) {
            maxProgenCell = new int[]{Constante.ORIGCELLWIDTH, Constante.ORIGCELLWIDTH, this.context.depth > 1 ? Constante.ORIGCELLDEPTH : 1, (int)nbProgen};
        }
        long rqMem = Math.min(8, maxProgenCell[3]) * maxProgenCell[0] * maxProgenCell[1] * maxProgenCell[2] * this.context.getNpixOrig();
        boolean res = this.needMem((long)nbThreads * (rqMem += (long)(this.tileSide * this.tileSide * this.tileDepth * this.context.getNpix())));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMem(int nbProgen, long rqMem, boolean monopass) throws Exception {
        rqMem += (long)this.tileSide * (long)this.tileSide * (long)this.tileDepth * (long)this.context.getNpix();
        if (nbProgen > 8) {
            rqMem += (long)(this.tileSide * this.tileSide * this.tileDepth * 8);
        }
        if (!this.needMem(rqMem)) {
            return;
        }
        Object object = this.objRel;
        synchronized (object) {
            if (!this.needMem(rqMem)) {
                return;
            }
            long sizeReleaseBitmap = this.builderTiles.releaseBitmap();
            if (sizeReleaseBitmap > 0L) {
                this.context.info("Need more RAM: output Fits bitmap temporary released => " + cds.tools.Util.getUnitDisk(sizeReleaseBitmap));
                if (this.builderTiles.getNbThreadRunning() > this.builderTiles.nbThread / 2) {
                    this.builderTiles.removeThreadBuilderHpx(1);
                    this.context.cacheFits.reduceMaxMem(10.0);
                }
                System.gc();
                cds.tools.Util.pause(100);
                if (!this.needMem(rqMem)) {
                    return;
                }
            }
            if (this.builderTiles.getNbThreadRunning() <= 1) {
                this.context.cacheFits.forceClean();
                this.context.warning(Thread.currentThread().getName() + " needs " + cds.tools.Util.getUnitDisk(rqMem) + " but can not stop (last thread running) !");
                return;
            }
            try {
                if (!this.builderTiles.arret(this, "Need more RAM => thread temporary suspended by ThreadBuilder.checkMem(nbProgen=" + nbProgen + ",rqMem=" + cds.tools.Util.getUnitDisk(rqMem) + ",monopass=" + monopass + ")")) {
                    this.context.warning(Thread.currentThread().getName() + " needs " + cds.tools.Util.getUnitDisk(rqMem) + " but can not stop (sub thread) !");
                    return;
                }
                this.context.info(Thread.currentThread().getName() + " suspended (as is)");
                while (this.needMem(rqMem)) {
                    block19: {
                        try {
                            this.context.info(Thread.currentThread().getName() + " is waiting more memory (need " + cds.tools.Util.getUnitDisk(rqMem) + ")...");
                            cds.tools.Util.pause((int)(1000.0 * (1.0 + Math.random() * 5.0)));
                            this.context.cacheFits.forceClean();
                            if (this.builderTiles.getNbThreadRunning() > 0) break block19;
                            this.context.warning(Thread.currentThread().getName() + " resumes (last thread)");
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.context.isTaskAborting()) continue;
                    throw new Exception("Task abort !");
                }
            }
            finally {
                if (this.builderTiles.reprise(this)) {
                    this.context.info(Thread.currentThread().getName() + " resumed");
                }
            }
        }
    }

    protected long getReqMem(SrcFile[] downFiles, int deb, int n) {
        long mem = 0L;
        for (int i = 0; i < n && deb < downFiles.length; ++i, ++deb) {
            SrcFile file = downFiles[deb];
            mem += file.cellMem;
        }
        return mem;
    }

    private double getMaxExpTime(SrcFile[] downFiles) {
        double maxExpTime = 0.0;
        boolean flagLimit20 = this.modeCoadd == ModeOverlay.overlayMeanMax;
        for (SrcFile sf : downFiles) {
            if (sf.flagRemoved) continue;
            double weight = 0.0;
            if (sf.isOpened != -2) {
                weight = sf.weight;
            } else {
                try {
                    Fits fitsfile = this.context.cacheFits.getFits(sf.name, 0, false, true);
                    weight = sf.weight = fitsfile.headerFits.getDoubleFromHeader(this.context.expTimeName);
                }
                catch (Exception e) {
                    sf.flagRemoved = true;
                    String f1 = this.context.addFileRemoveList(sf.name);
                    this.context.warning("Missing " + this.context.expTimeName + " FITS keyword => image ignored [" + f1 + "]");
                }
            }
            if (!(weight > maxExpTime)) continue;
            maxExpTime = weight;
        }
        if (flagLimit20) {
            Arrays.sort(downFiles);
        }
        return maxExpTime;
    }

    Fits buildHealpix(BuilderRunner bt, String path, BuilderRunner.AddrThread addr) throws Exception {
        Fits out;
        SrcFile[] downFiles;
        block27: {
            int order = addr.order;
            long npix = addr.npix;
            int z = addr.z;
            downFiles = null;
            out = null;
            try {
                downFiles = this.askLocalFinder(bt, this.hpxFinderPath, addr);
                if (downFiles == null) {
                    return null;
                }
                int nbProg = downFiles.length;
                if (nbProg > statMaxOverlays) {
                    statMaxOverlays = nbProg;
                }
                double maxExpTime = 0.0;
                if (!this.flagColor && this.context.expTimeName != null) {
                    maxExpTime = this.getMaxExpTime(downFiles);
                }
                if (!(this.context.live || this.modeCoadd != ModeOverlay.overlayNone && nbProg >= 8 && this.requiredMem(this.modeCoadd == ModeOverlay.overlayNone ? 1L : (long)nbProg, 1))) {
                    ++statOnePass;
                    long mem = this.getReqMem(downFiles, 0, nbProg);
                    if (DEBUG) {
                        System.out.println("Mem requise = " + cds.tools.Util.getUnitDisk(mem));
                    }
                    this.checkMem(this.modeCoadd == ModeOverlay.overlayNone ? 1 : nbProg, mem, true);
                    this.threadBuilder.setInfo("createLeavveHpx onepass memOk " + addr + "...");
                    out = this.buildHealpix1(bt, addr, downFiles, 0, nbProg, null, maxExpTime);
                    if (DEBUG) {
                        System.out.println("Out = " + out);
                    }
                    break block27;
                }
                ++statMultiPass;
                double[] weight = null;
                double[] fWeight = this.modeCoadd == ModeOverlay.overlayAdd ? null : new double[this.tileSide * this.tileSide * this.tileDepth];
                for (int deb = 0; deb < nbProg; deb += 8) {
                    int fin = deb + 8;
                    if (fin >= nbProg) {
                        fin = nbProg;
                    }
                    long mem = this.getReqMem(downFiles, deb, fin);
                    this.checkMem(fin - deb, mem, false);
                    this.threadBuilder.setInfo("createLeavveHpx multipass memOk " + order + "/" + npix + "...");
                    Fits f = this.buildHealpix1(bt, addr, downFiles, deb, fin, fWeight, maxExpTime);
                    if (f != null) {
                        if (out == null) {
                            out = f;
                            weight = fWeight;
                            fWeight = this.modeCoadd == ModeOverlay.overlayAdd ? null : new double[this.tileSide * this.tileSide * this.tileDepth];
                        } else if (this.modeCoadd == ModeOverlay.overlayAdd) {
                            out.coadd(f, 1);
                        } else {
                            out.coadd(f, weight, fWeight);
                        }
                    }
                    for (int i = deb; i < fin; ++i) {
                        SrcFile f1 = downFiles[i];
                        try {
                            if (f1 != null) {
                                f1.release();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        downFiles[i] = null;
                    }
                    if (f == null || f.hipsTileDone != 1) continue;
                    ThreadBuilderTile threadBuilderTile = this;
                    if (threadBuilderTile.context.getVerbose() < 4) break;
                    this.context.info("Tile " + addr + " done (maxProg reached for all pixels)");
                    break;
                }
                if (out != null && this.bitpix != this.context.getBitpixOrig()) {
                    Fits out1 = new Fits(out.width, out.height, this.bitpix);
                    out1.setBlank(this.blank);
                    out1.setBzero(this.bZero);
                    out1.setBscale(this.bScale);
                    for (int y = 0; y < out.height; ++y) {
                        for (int x = 0; x < out.width; ++x) {
                            double pixelFinal = out.getPixelDouble(x, y);
                            pixelFinal = Double.isNaN(pixelFinal) ? this.blank : (this.bitpix < 0 ? pixelFinal * this.context.bScaleOrig + this.context.bZeroOrig : (pixelFinal <= this.cutOrig[2] ? this.cut[2] : (pixelFinal >= this.cutOrig[3] ? this.cut[3] : (pixelFinal - this.cutOrig[2]) * this.context.coef + this.cut[2])));
                            out1.setPixelDouble(x, y, pixelFinal);
                        }
                    }
                    out = out1;
                    out1 = null;
                }
                if (out != null && this.context.live) {
                    String file = Util.getFilePath(path, addr);
                    bt.writeWeight(file, weight, this.tileSide, this.tileDepth, addr, out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (SrcFile f1 : downFiles) {
            try {
                if (f1 == null) continue;
                f1.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        this.threadBuilder.setInfo("createLeavveHpx done " + path + "...");
        return out;
    }

    protected boolean modifBitPix() {
        return this.bitpix != this.context.getBitpixOrig();
    }

    protected boolean reachMaxProgenitors(int nbPix) {
        if (this.modeCoadd == ModeOverlay.overlayNone) {
            return true;
        }
        return this.modeCoadd == ModeOverlay.overlayMeanMax && nbPix >= ModeOverlay.OVERLAYMEAN_MAX;
    }

    Fits buildHealpix1(BuilderRunner bt, BuilderRunner.AddrThread addr, SrcFile[] downFiles, int deb, int fin, double[] tileWeight, double maxExpTime) throws Exception {
        double dataMax;
        double dataMin;
        double bZero;
        double bScale;
        Fits out;
        boolean empty;
        long t0;
        block32: {
            t0 = System.currentTimeMillis();
            empty = true;
            double[] radec = new double[2];
            Coord coo = new Coord();
            SrcFile file = null;
            out = null;
            int bitpix = this.bitpix;
            double blank = this.blank;
            bScale = this.bScale;
            bZero = this.bZero;
            dataMin = Double.NaN;
            dataMax = Double.NaN;
            int tileSide = this.context.getTileSide();
            int nbOverlayMax = 0;
            try {
                long min = addr.npix * (long)tileSide * (long)tileSide;
                boolean flagModifBitpix = this.modifBitPix();
                if (flagModifBitpix && tileWeight != null) {
                    bitpix = this.context.getBitpixOrig();
                    blank = bitpix < 0 ? Double.NaN : this.blankOrig;
                    flagModifBitpix = false;
                }
                out = new Fits(tileSide, tileSide, bitpix);
                int xa = out.width;
                int ya = out.height;
                int za = out.depth;
                int xb = -1;
                int yb = -1;
                int zb = -1;
                out.setBlank(blank);
                out.setBzero(bZero);
                out.setBscale(bScale);
                int overlay = fin - deb;
                double[] pixval = new double[overlay];
                double[] pixcoef = new double[overlay];
                boolean gal2ICRS = this.context.getFrame() != 0;
                int orderPix = addr.order + this.context.getTileOrder();
                HealpixNestedFast hn = Healpix.getNestedFast(orderPix);
                for (int y = 0; y < out.height; ++y) {
                    for (int x = 0; x < out.width; ++x) {
                        double pixelFinal;
                        int nbPix = 0;
                        double totalCoef = 0.0;
                        int removed = 0;
                        long index = min + (long)this.context.xy2hpx[y * out.width + x];
                        this.computeCoo(coo, hn, index, radec, gal2ICRS);
                        for (int i = deb; i < fin; ++i) {
                            try {
                                double pix;
                                file = downFiles[i];
                                if (file.flagRemoved) continue;
                                if (!this.open(file, 0)) {
                                    if (++removed < fin - deb) continue;
                                    return null;
                                }
                                try {
                                    file.fitsfile.getCalib().GetXY(coo, false);
                                }
                                catch (Exception e) {
                                    System.err.println("Problem on calib: " + file.name + " => exception " + e.getMessage() + " tile=" + addr);
                                    ThreadBuilderTile threadBuilderTile = this;
                                    if (threadBuilderTile.context.getVerbose() < 3) continue;
                                    e.printStackTrace();
                                    continue;
                                }
                                coo.y = (double)file.fitsfile.height - coo.y - 1.0;
                                coo.x -= 1.0;
                                if (!this.isIn(file, coo) || Double.isNaN(pix = this.getBilinearPixel(file, coo, file.blank))) continue;
                                pixval[nbPix] = pix;
                                pixcoef[nbPix] = this.getCoef(file, coo, this.modeCoadd, maxExpTime);
                                totalCoef += pixcoef[nbPix];
                                if (!this.reachMaxProgenitors(++nbPix)) continue;
                                ++nbOverlayMax;
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (nbPix == 0) {
                            pixelFinal = blank;
                        } else {
                            pixelFinal = 0.0;
                            if (this.modeCoadd == ModeOverlay.overlayAdd) {
                                empty = false;
                                for (int i = 0; i < nbPix; ++i) {
                                    double d;
                                    double a = pixval[i] * pixcoef[i];
                                    if (pixelFinal / 2.0 + d / 2.0 > this.maxDemi) {
                                        pixelFinal = this.max;
                                        break;
                                    }
                                    pixelFinal += a;
                                }
                            } else if (totalCoef == 0.0) {
                                empty = false;
                                pixelFinal = pixval[0];
                            } else {
                                empty = false;
                                for (int i = 0; i < nbPix; ++i) {
                                    if (out.isBlankPixel(pixval[i])) continue;
                                    pixelFinal += pixval[i] * pixcoef[i] / totalCoef;
                                }
                            }
                            pixelFinal = this.modifBitpix(pixelFinal, flagModifBitpix);
                        }
                        if (this.context.trim && !out.isBlankPixel(pixelFinal)) {
                            if (x < xa) {
                                xa = x;
                            }
                            if (x > xb) {
                                xb = x;
                            }
                            if (y < ya) {
                                ya = y;
                            }
                            if (y > yb) {
                                yb = y;
                            }
                        }
                        out.setPixelDouble(x, y, pixelFinal);
                        if (tileWeight != null) {
                            tileWeight[y * tileSide + x] = totalCoef;
                        }
                        if (Double.isNaN(dataMin) || pixelFinal < dataMin) {
                            dataMin = pixelFinal;
                        }
                        if (!Double.isNaN(dataMax) && !(pixelFinal > dataMax)) continue;
                        dataMax = pixelFinal;
                    }
                }
                if (this.modeCoadd == ModeOverlay.overlayMeanMax && nbOverlayMax == out.width * out.height) {
                    out.hipsTileDone = 1;
                }
                if (!this.context.trim || empty) break block32;
                out.setBorder(new int[]{xa, xb, ya, yb, za, zb});
            }
            catch (Exception e) {
                e.printStackTrace();
                empty = true;
                if (tileWeight == null) break block32;
                for (int i = 0; i < tileWeight.length; ++i) {
                    tileWeight[i] = 0.0;
                }
            }
        }
        if (!empty && !Double.isNaN(dataMin)) {
            out.setDataMinMax(dataMin * bScale + bZero, dataMax * bScale + bZero);
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        tleaf += System.currentTimeMillis() - t0;
        return !empty ? out : null;
    }

    protected void computeCoo(Coord coo, HealpixNestedFast hn, long index, double[] radec, boolean gal2ICRS) {
        hn.center(index, radec);
        if (gal2ICRS) {
            radec[0] = radec[0] * 57.29577951308232;
            radec[1] = radec[1] * 57.29577951308232;
            radec = this.context.gal2ICRSIfRequired(radec);
            coo.al = radec[0];
            coo.del = radec[1];
        } else {
            coo.al = radec[0] * 57.29577951308232;
            coo.del = radec[1] * 57.29577951308232;
        }
    }

    protected boolean open(SrcFile file, int z) throws Exception {
        try {
            file.open(z);
        }
        catch (Exception e) {
            ThreadBuilderTile threadBuilderTile = this;
            if (threadBuilderTile.context.getVerbose() >= 3) {
                e.printStackTrace();
            }
            String f1 = this.context.addFileRemoveList(file.name);
            this.context.warning("Problem on open => file ignored [" + f1 + "]");
            file.flagRemoved = true;
            return false;
        }
        return true;
    }

    protected double modifBitpix(double pixelFinal, boolean flagModifBitpix) {
        if (flagModifBitpix && !this.context.cutByImage) {
            double d = Double.isNaN(pixelFinal) ? this.blank : (this.bitpix < 0 ? pixelFinal * this.context.bScaleOrig + this.context.bZeroOrig : (pixelFinal <= this.cutOrig[2] ? this.cut[2] : (pixelFinal = pixelFinal >= this.cutOrig[3] ? this.cut[3] : (pixelFinal - this.cutOrig[2]) * this.context.coef + this.cut[2])));
            if (this.bitpix > 0 && (double)((long)pixelFinal) == this.blank && pixelFinal != this.blank) {
                pixelFinal += 0.5;
            }
        } else if (Double.isNaN(pixelFinal)) {
            pixelFinal = this.blank;
        }
        return pixelFinal;
    }

    protected boolean isIn(SrcFile srcFile, Coord coo) {
        Fits f = srcFile.fitsfile;
        if (coo.x < (double)this.borderSize[1] - 1.5 || coo.x > (double)(f.width - this.borderSize[3])) {
            return false;
        }
        if (coo.y < (double)this.borderSize[0] - 1.5 || coo.y > (double)(f.height - this.borderSize[2])) {
            return false;
        }
        if (this.context.scanFov) {
            if (this.globalShape != null && !this.globalShape.contains(coo.x, coo.y)) {
                return false;
            }
            if (srcFile.shape != null && !srcFile.shape.contains(coo.x, coo.y)) {
                return false;
            }
        }
        return true;
    }

    protected double getCoef(SrcFile file, Coord coo, ModeOverlay mode, double maxExpTime) {
        double coef1 = this.getCoef(file.fitsfile, coo, mode);
        if (maxExpTime <= 0.0) {
            return coef1;
        }
        double coef2 = file.weight / maxExpTime;
        return coef1 * coef2;
    }

    private double getCoef(Fits f, Coord coo, ModeOverlay mode) {
        int x1 = (int)coo.x;
        int y1 = (int)coo.y;
        double div = 1.0;
        if (x1 > 0 && x1 < f.width - 1 && (coo.x <= (double)f.xCell || coo.x >= (double)(f.xCell + f.widthCell - 1))) {
            div *= 2.0;
        }
        if (y1 > 0 && y1 < f.height - 1 && (coo.y <= (double)f.yCell || coo.y >= (double)(f.yCell + f.heightCell - 1))) {
            div *= 2.0;
        }
        double c = mode != ModeOverlay.overlayFading ? 1.0 : this.getCoefFading(f, coo);
        return c / div;
    }

    protected double getCoefFading(Fits f, Coord coo) {
        double c = 0.0;
        try {
            double width = f.width - (this.borderSize[1] + this.borderSize[3]);
            double height = f.height - (this.borderSize[0] + this.borderSize[2]);
            double mx = width * 0.16666666666666666;
            double my = height * 0.16666666666666666;
            double x2 = coo.x - (double)this.borderSize[1];
            double y2 = coo.y - (double)this.borderSize[0];
            double coefx = 1.0;
            double coefy = 1.0;
            if (x2 < mx) {
                coefx = x2 / mx;
            } else if (x2 > width - mx) {
                coefx = (width - x2) / mx;
            }
            if (y2 < my) {
                coefy = y2 / my;
            } else if (y2 > height - my) {
                coefy = (height - y2) / my;
            }
            c = coefx * coefy;
        }
        catch (Exception e) {
            c = 0.0;
        }
        return c;
    }

    private double getBilinearPixel(SrcFile srcFile, Coord coo, double myBlank) {
        return this.getBilinearPixel(srcFile, coo, 0, myBlank, true);
    }

    protected double getBilinearPixel(SrcFile srcFile, Coord coo, int z, double myBlank, boolean checkOut) {
        boolean b3;
        Fits f = srcFile.fitsfile;
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int ox1 = x1;
        int oy1 = y1;
        int ox2 = x2;
        int oy2 = y2;
        if (checkOut && (x2 < f.xCell || y2 < f.yCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell)) {
            return Double.NaN;
        }
        if (ox1 == f.xCell - 1) {
            ++ox1;
        }
        if (oy1 == f.yCell - 1) {
            ++oy1;
        }
        if (ox2 == f.xCell + f.widthCell) {
            --ox2;
        }
        if (oy2 == f.yCell + f.heightCell) {
            --oy2;
        }
        double a0 = f.getPixelDouble(ox1, oy1, z);
        double a1 = f.getPixelDouble(ox2, oy1, z);
        double a2 = f.getPixelDouble(ox1, oy2, z);
        double a3 = f.getPixelDouble(ox2, oy2, z);
        boolean b0 = Double.isNaN(a0) || a0 == myBlank;
        boolean b1 = Double.isNaN(a1) || a1 == myBlank;
        boolean b2 = Double.isNaN(a2) || a2 == myBlank;
        boolean bl = b3 = Double.isNaN(a3) || a3 == myBlank;
        if (b0 && b1 && b2 && b3) {
            return Double.NaN;
        }
        if (b0 || b1 || b2 || b3) {
            double a;
            double d = !b0 ? a0 : (!b1 ? a1 : (a = !b2 ? a2 : a3));
            if (b0) {
                a0 = a;
            }
            if (b1) {
                a1 = a;
            }
            if (b2) {
                a2 = a;
            }
            if (b3) {
                a3 = a;
            }
        }
        return this.bilineaire(x1, y1, x2, y2, x, y, a0, a1, a2, a3);
    }

    protected final double bilineaire(int x1, int y1, int x2, int y2, double x, double y, double a0, double a1, double a2, double a3) {
        double d3;
        double d2;
        double d1;
        double d0;
        if (x == (double)x1) {
            d0 = 1.0;
            d1 = 0.0;
        } else if (x == (double)x2) {
            d0 = 0.0;
            d1 = 1.0;
        } else {
            d0 = 1.0 / (x - (double)x1);
            d1 = 1.0 / ((double)x2 - x);
        }
        if (y == (double)y1) {
            d2 = 1.0;
            d3 = 0.0;
        } else if (y == (double)y2) {
            d2 = 0.0;
            d3 = 1.0;
        } else {
            d2 = 1.0 / (y - (double)y1);
            d3 = 1.0 / ((double)y2 - y);
        }
        double pA = (a0 * d0 + a1 * d1) / (d0 + d1);
        double pB = (a2 * d0 + a3 * d1) / (d0 + d1);
        return (pA * d2 + pB * d3) / (d2 + d3);
    }

    public void get(String theUrl, String filename) throws IOException {
        try {
            String inputLine;
            URL gotoUrl = new URL(theUrl);
            InputStreamReader isr = new InputStreamReader(gotoUrl.openStream());
            BufferedReader in = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine + "\r\n");
            }
            ThreadBuilderTile.createAFile(filename, sb.toString());
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    private static void createAFile(String outfile, String content) throws IOException {
        FileOutputStream fileoutputstream = new FileOutputStream(outfile);
        DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);
        dataoutputstream.writeBytes(content);
        dataoutputstream.flush();
        dataoutputstream.close();
    }

    private String getPath(String s) throws Exception {
        if (s.charAt(0) != '{') {
            return s;
        }
        int o = s.indexOf("path");
        int o1 = s.indexOf(58, o);
        int o2 = s.indexOf(34, o1 + 1);
        int o3 = s.indexOf(34, o2 + 1);
        return s.substring(o2 + 1, o3);
    }

    private long getCellMem(String s) throws Exception {
        int o = s.indexOf("cellmem");
        if (s.charAt(0) == '{' && o > -1) {
            int o1 = s.indexOf(58, o);
            int o2 = s.indexOf(34, o1 + 1);
            int o3 = s.indexOf(34, o2 + 1);
            try {
                return Integer.parseInt(s.substring(o2 + 1, o3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int bloc = this.context.isPartitioning() ? this.context.getPartitioning() : Constante.ORIGCELLWIDTH;
        return bloc * bloc * (this.context.bitpixOrig == 0 ? 32 : Math.abs(this.context.bitpixOrig) / 8);
    }

    private boolean matchZ(Fits fits, int z) throws Exception {
        return fits.depthCell == -1 || z >= fits.zCell && z < fits.zCell + fits.depthCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrcFile[] askLocalFinder(BuilderRunner bt, String path, BuilderRunner.AddrThread cell) {
        ArrayList<SrcFile> downFiles = new ArrayList<SrcFile>(16);
        String hpxfilename = this.context.isHips3D ? path + cds.tools.Util.FS + Util.getFilePath("", cell.order, cell.npix, cell.orderZ, cell.npixZ) : path + cds.tools.Util.FS + Util.getFilePath("", cell.order, cell.npix);
        File f = new File(hpxfilename);
        String line = null;
        String fitsfilename = null;
        if (f.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(f));
                int n = 0;
                while ((line = reader.readLine()) != null) {
                    block19: {
                        fitsfilename = this.getPath(line);
                        long cellMem = this.getCellMem(line);
                        if (!this.context.isFileRemovedList(fitsfilename)) {
                            try {
                                Fits fitsfile = new Fits();
                                fitsfile.setFilename(fitsfilename);
                                fitsfile.setCunit(this.context.getCUnit());
                                fitsfile.setDefaultRestFreq(this.context.getDefaultRestFreq());
                                if (!this.context.isHips3D) {
                                    fitsfile.parseCell(fitsfilename);
                                    if (!this.matchZ(fitsfile, cell.z)) break block19;
                                }
                                SrcFile file = new SrcFile(fitsfilename, cellMem);
                                file.fitsfile = fitsfile;
                                downFiles.add(file);
                            }
                            catch (Exception e) {
                                System.err.println("Erreur de chargement de : " + fitsfilename);
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                SrcFile[] srcFileArray = null;
                return srcFileArray;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            SrcFile[] result = new SrcFile[downFiles.size()];
            downFiles.toArray(result);
            return result;
        }
        return null;
    }

    private double getWeight(Fits fits) {
        double weight = 0.0;
        try {
            weight = fits.headerFits.getDoubleFromHeader(this.context.expTimeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return weight;
    }

    private Shape getShape(Fits fits) {
        Shape sh = null;
        try {
            File parent = new File(this.context.getInputPath()).getParentFile();
            String last = parent == null ? null : parent.getCanonicalPath();
            for (File dir = new File(fits.getFilename()); sh == null && dir != null && !dir.getCanonicalPath().equals(last); dir = dir.getParentFile()) {
                sh = this.getShape(dir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape getShape(File dir) {
        Shape sh = null;
        if (hasShape.containsKey(dir)) {
            return hasShape.get(dir);
        }
        HashMap<File, Shape> hashMap = hasShape;
        synchronized (hashMap) {
            File f;
            String file;
            if (hasShape.containsKey(dir)) {
                return hasShape.get(dir);
            }
            if (dir.isDirectory()) {
                file = dir.getAbsoluteFile() + ".fov";
            } else {
                String parent;
                String name = dir.getName();
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    name = name.substring(0, dot);
                }
                file = (parent = dir.getParent()) == null ? null : parent + Util.FS + name + ".fov";
            }
            File file2 = f = file == null ? null : new File(file);
            if (f != null && f.isFile()) {
                FileInputStream fr = null;
                try {
                    String s;
                    fr = new FileInputStream(f);
                    InputStreamReader in = new InputStreamReader(fr);
                    BufferedReader dis = new BufferedReader(in);
                    StringBuilder res = new StringBuilder();
                    while ((s = dis.readLine()) != null) {
                        if (res.length() > 0) {
                            res.append(' ');
                        }
                        res.append(s.trim());
                    }
                    dis.close();
                    in.close();
                    sh = Context.createFov(res.toString());
                    if (sh != null) {
                        this.context.info("FoV detected: " + f.getName() + " => " + this.shape2String(sh));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            hasShape.put(dir, sh);
            return sh;
        }
    }

    private String shape2String(Shape shape) {
        StringBuilder rep = new StringBuilder();
        if (shape instanceof Polygon) {
            int i;
            Polygon pol = (Polygon)shape;
            for (i = 0; i < pol.npoints && i < 5; ++i) {
                if (i > 0) {
                    rep.append(' ');
                }
                rep.append(pol.xpoints[i] + "," + pol.ypoints[i]);
            }
            if (i < pol.npoints) {
                rep.append("...");
            }
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ell = (Ellipse2D)shape;
            rep.append("circle(" + ell.getCenterX() + "," + ell.getCenterY() + "," + ell.getWidth() / 2.0 + ")");
        }
        return rep.toString();
    }

    class SrcFile
    implements Comparable {
        Fits fitsfile;
        long cellMem;
        int isOpened = -1;
        String name = null;
        double blank;
        Shape shape = null;
        double weight = Double.NaN;
        boolean flagRemoved = false;

        SrcFile(String name, long cellMem) {
            this.name = name;
            this.cellMem = cellMem;
        }

        public String toString() {
            return this.fitsfile.getFilename();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void open(int z) throws Exception {
            if (this.isOpened == z) {
                return;
            }
            if (this.flagRemoved) {
                return;
            }
            SrcFile srcFile = this;
            synchronized (srcFile) {
                double restFreq;
                int mode;
                if (this.isOpened != -1) {
                    this.fitsfile.rmUser();
                }
                int n = this.name.endsWith(".hhh") || this.name.indexOf(".hhh[") > 0 ? 4 : (this.name.endsWith(".jpg") || this.name.indexOf(".jpg[") > 0 ? 1 : (mode = this.name.endsWith(".png") || this.name.indexOf(".png[") > 0 ? 2 : 0));
                if (mode == 0 && ThreadBuilderTile.this.bitpix == 0) {
                    this.fitsfile.loadFITS(this.name, true, true, true);
                } else {
                    try {
                        this.fitsfile = ThreadBuilderTile.this.context.cacheFits.getFits(this.name, mode, true, true);
                    }
                    catch (MyInputStreamCachedException e) {
                        ThreadBuilderTile.this.context.taskAbort();
                        throw new Exception();
                    }
                }
                if (ThreadBuilderTile.this.context.expTimeName != null) {
                    this.weight = ThreadBuilderTile.this.getWeight(this.fitsfile);
                }
                if (ThreadBuilderTile.this.context.scanFov) {
                    this.shape = ThreadBuilderTile.this.getShape(this.fitsfile);
                }
                this.fitsfile.addUser();
                MyInputStreamCached.incActiveFile(this.name);
                if (ThreadBuilderTile.this.context.isHips3D && this.fitsfile.getCalibFreq() == null && !Double.isNaN(restFreq = ThreadBuilderTile.this.context.getDefaultRestFreq())) {
                    CalibFreq cf = new CalibFreq(this.fitsfile.headerFits, ThreadBuilderTile.this.context.getCUnit(), restFreq, true);
                    this.fitsfile.setCalibFreq(cf);
                }
                this.blank = !ThreadBuilderTile.this.hasAlternateBlank ? this.fitsfile.blank : ThreadBuilderTile.this.blankOrig;
                this.isOpened = z;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void release() {
            if (this.isOpened == -1) {
                return;
            }
            SrcFile srcFile = this;
            synchronized (srcFile) {
                this.fitsfile.rmUser();
                MyInputStreamCached.decActiveFile(this.name);
                this.isOpened = -1;
            }
        }

        public int compareTo(Object o) {
            SrcFile s = (SrcFile)o;
            if (Double.isNaN(s.weight) && Double.isNaN(this.weight)) {
                return 0;
            }
            if (Double.isNaN(s.weight)) {
                return 1;
            }
            if (Double.isNaN(this.weight)) {
                return -1;
            }
            double delta = this.weight - ((SrcFile)o).weight;
            return delta == 0.0 ? 0 : (delta < 0.0 ? 1 : -1);
        }
    }
}

