/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Coord;
import cds.fits.Fits;
import cds.hipsgen.BuilderCount;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Context;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ThreadBuilderTile;

public class ThreadBuilderCount
extends ThreadBuilderTile {
    private ModeOverlay modeCoaddOrig;

    public ThreadBuilderCount(Context context, BuilderRunner builder) {
        super(context, builder);
        this.modeCoaddOrig = ((BuilderCount)builder).mc.modeOverlay;
    }

    @Override
    Fits buildHealpix1(BuilderRunner bt, BuilderRunner.AddrThread addr, ThreadBuilderTile.SrcFile[] downFiles, int deb, int fin, double[] tileWeight, double maxExpTime) throws Exception {
        return super.buildHealpix1(bt, addr, downFiles, deb, fin, tileWeight, maxExpTime);
    }

    @Override
    protected boolean modifBitPix() {
        return false;
    }

    @Override
    protected boolean reachMaxProgenitors(int nbPix) {
        if (this.modeCoaddOrig == ModeOverlay.overlayNone) {
            return true;
        }
        return this.modeCoaddOrig == ModeOverlay.overlayMeanMax && nbPix >= ModeOverlay.OVERLAYMEAN_MAX;
    }

    @Override
    protected double getBilinearPixel(ThreadBuilderTile.SrcFile srcFile, Coord coo, int z, double myBlank, boolean checkOut) {
        boolean b3;
        Fits f = srcFile.fitsfile;
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int ox1 = x1;
        int oy1 = y1;
        int ox2 = x2;
        int oy2 = y2;
        if (checkOut && (x2 < f.xCell || y2 < f.yCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell)) {
            return Double.NaN;
        }
        if (ox1 == f.xCell - 1) {
            ++ox1;
        }
        if (oy1 == f.yCell - 1) {
            ++oy1;
        }
        if (ox2 == f.xCell + f.widthCell) {
            --ox2;
        }
        if (oy2 == f.yCell + f.heightCell) {
            --oy2;
        }
        double a0 = f.getPixelDouble(ox1, oy1, z);
        double a1 = f.getPixelDouble(ox2, oy1, z);
        double a2 = f.getPixelDouble(ox1, oy2, z);
        double a3 = f.getPixelDouble(ox2, oy2, z);
        boolean b0 = Double.isNaN(a0) || a0 == myBlank;
        boolean b1 = Double.isNaN(a1) || a1 == myBlank;
        boolean b2 = Double.isNaN(a2) || a2 == myBlank;
        boolean bl = b3 = Double.isNaN(a3) || a3 == myBlank;
        if (b0 && b1 && b2 && b3) {
            return 0.0;
        }
        return 1.0;
    }
}

