/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.hipsgen.Action;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ModeTree;
import cds.hipsgen.ParamObsolete;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public enum Param {
    in("dir", "Source directory", "Indicates the directory that contains the source images (FITS, PNG, JPEG (+ HHH)). If there is only one image, the directory name can be replaced by the file name. The source images can be directly localized in the directory or in one of its subdirectories. In the case of MIRROR, MAP, CONCAT actions, indicate the source HiPS.", 0L),
    out("dir", "Ouput directory", "Specifies the output directory. If not specified, it will be created at the same level as the source directory using the HiPS identifier as directory name (see id parameter).", 0L),
    order("nn", "HiPS order", "Specifies the HiPS order. By default, the HiPS order is calculated to obtain a resolution equivalent to, or slightly better than, the original images (based on the reference image - see img parameter). Altering the default value is intended to oversample, or undersample, the output HiPS. Note that each additional order quadruples the size of the resulting HiPS.", 34864L),
    minOrder("nn", "HiPS min order", "Specifies the minimum order of the HiPS. The default is 0. Altering this setting is not recommended unless you want to generate a partial HiPS and then rebuild the tree afterwards (see action TREE).", 40992L),
    frame("equatorial|galactic|ecliptic", "HiPS coordinate frame", "Indicates the coordinate system of the HiPS. By default a HiPS is equatorial (ICRS) and it is recommended to keep this value except in the case where the HiPS is generated directly from a HEALPix map which is not equatorial.", 16L),
    tileWidth("nn", "HiPS tile width", "Specifies the size of HiPS tiles by indicating the number of pixels on one side (necessarily a power of 2). The default is 512 (x 512) pixels. This value can be reduced to limit null edges, especially for very \"fragmented\" HiPS (e.g. 128). On the contrary, it can be increased to reduce the number of tiles (e.g. 1024).", 32816L),
    orderFreq("nn", "HiPS frequential order", "Specifies the HiPS frequential order. By default, the HiPS frequential order is calculated to obtain a resolution equivalent to, or slightly better than, the third dimension of the original cubes (based on the reference cube - see img parameter). Altering the default value is intended to oversample, or undersample, the third dimension of the output HiPS. Note that each additional order double the size of the resulting HiPS.", 34864L),
    bitpix("8|16|32|64|-32|-64", "HiPS bitpix", "Specifies the pixel encoding of the HiPS. Follows the FITS convention: 8, 16, 32, 64 for 8, 16, 32 or 64 bit integer encoding, -32 or -64 for 32 (float) or 64 (double) bit real encoding. By default, uses the same encoding as the original images (standard image - see img parameter). Reducing the number of bits mechanically reduces the size of the final HiPS. But it also reduces the number of possible values and introduces rounding phenomena. In this situation, it is recommended to check the range of values selected, and if necessary modify it (cf. dataRange parameter).", 32L),
    dataRange("min max", "Original pixel range", "Specifies the range of pixel values to be considered when performing a pixel encoding conversion (see bitpix parameter). All values below or above will be considered equal to the smallest or largest value respectively. By default, this value range is automatically determined from the reference image taken from the source images (see img parameter). The specified values are to be considered as physical pixel values (i.e. taking into account a possible linear bzero/bscale operation on the encoded pixel values)", 32L),
    pixelCut("[min[%] max[%]] [byRegion[/size]] [fct]", "8 bits pixel mapping method", "Specifies the range of pixel values and how these pixels will be rendered in the HiPS preview 8 bits tiles (PNG or JPG). The pixel values between min and max (or min% and max% of the pixel histogram) distributed over the 255 (resp. 256) possible values using by default a linear mapping, or one of the possible transfer functions (log, sqrt, asinh, pow2). The specified values are to be considered as physical pixel values (i.e. taking into account a possible linear bzero/bscale operation on the encoded pixel values). By default, these 2 thresholds are automatically evaluated based on the reference image (see img parameter). In the case of pointed observation survey, the alternative `byRegion` indicates to Hipsgen to automatically evaluate the min% and max% thresholds of the pixel distribution according to each observed region and no longer globally (based on 'size' pixels of each region - default '1Mpix'). This evaluation by regions will be done if required by the CUT action, before generating the PNG, JPEG or RGB tiles)", 18208L),
    img("filename", "Reference image for default initializations", "Indicates the file name of the source image used as a reference. This image determines the parameters of the final HiPS: order, pixel encoding, value ranges, etc. By default, the first image in the source directory will be used. If it is not representative, an alternative image is recommended.", 816L),
    hdu("n1,n2-n3,...|all", "List of FITS HDU numbers (original images)", "Specifies the extension numbers of the original FITS images to be considered for HiPS generation. By default, only the first FITS extension containing a valid image is taken into account. The first extension has the number 0.", 48L),
    blank("nn|key", "Alternative BLANK value (or alternate BLANK fits keyword)", "Specifies an alternative pixel value to be considered null. This value would normally have been specified directly in the FITS image header using the BLANK keyword. The indicated value is to be considered at the FITS coding level, i.e. without taking into account a possible linear bzero/bscale change.", 33568L),
    cunit("unit", "Default cube unit if the CUNIT key is missing", 56L),
    restfreq("freq", "Default rest freq. (Hz) if the RESTFRQ (or equiv.) key is missing", 48L),
    validRange("min max", "Range of valid pixels", "Specifies the range of valid pixels. All other values are considered null (see `" + (Object)((Object)blank) + "` parameter). Note that, unlike the blank parameter, the min and max values are to be considered as physical pixel values (for which a linear bzero/bscale change will already have been applied). \nThis parameter should not be confused with `" + (Object)((Object)dataRange) + "` (describes the range of values retained for a pixel coding conversion). In the first case, values outside the range correspond to a transparent (or non-existent) pixel, in the second case, the pixel is reduced to the smallest, respectively largest possible pixel value.", 32L),
    skyVal("key|auto|%info|%min %max", "Background removal method", "Sky background removal method. Specifies either the FITS keyword to be used to find out the sky background value or the values to be applied for the automatic method. In the second case, 1 value represents the percentage of the histogram of detected pixel values to be retained; 2 values represent the min and max of the histogram to be retained (central ex 99, or min max ex 0.3 99.7)", 32L),
    expTime("key", "Method of adjusting the exposure time", "Indicates the FITS keyword associated with the exposure time of the original images. Activates the division of the original pixels by this exposure time.", 32800L),
    maxRatio("nn", "Image source pixel ratio test", "Security filtering of source images. Specifies the maximum tolerated ratio of the angular size of a pixel in longitude and latitude to consider a source image as correct. By default, a ratio greater than 3 causes the image to be rejected. ", 16L),
    fov("true|x1,y1..", "Masks on the original images.", "Mask activation by polygon or circle allowing to define a field of view, or any sub-area in the original image. These masks are provided in the form of a file with the same name as the image to which it is associated, but with the extension `.fov'. This file contains the cartesian coordinates of the mask: one pair of X Y coordinates (FITS convention) per line describing the polygon in a counter-clockwise direction, or a single `X Y radius` triplet in the case of a circle. The `.fov` file associated to a directory is applied to all the images in the directory and its sub-directories, except for images having their own `.fov` file. When the mask is constant for all images, it can be directly provided as a parameter value. \nSee the `border` parameter for basic edge masking.", 32800L),
    border("nn|N W S E", "Edge removal", "Remove the edges of original images. This masking is constant for all images. It is expressed either as a single value indicating the number of pixels to be ignored on the 4 edges, or as a quadruplet N W S E indicating the number of pixels to be ignored respectively at the top, left, bottom and right of the images. For more advanced masking, see the `fov` parameter.", 32800L),
    shape("rectangle|ellipse", "Image FoV", "Indicates the shape of the field of view of the original images. Activates the autodetection of the pixels to be taken into account according to this shape.", 32800L),
    mode("m1,m2..", "Coadd pixel modes", "Pixel coaddition modes. Concerns overlays of original images (" + (Object)((Object)ModeOverlay.overlayMean) + ", " + (Object)((Object)ModeOverlay.overlayMeanMax) + " ," + (Object)((Object)ModeOverlay.overlayAdd) + ", " + (Object)((Object)ModeOverlay.overlayNone) + ", " + (Object)((Object)ModeOverlay.overlayFading) + "), tile merges for HiPS updates (" + (Object)((Object)ModeMerge.mergeOverwrite) + ", " + (Object)((Object)ModeMerge.mergeKeep) + ", " + (Object)((Object)ModeMerge.mergeMean) + ", " + (Object)((Object)ModeMerge.mergeAdd) + ", " + (Object)((Object)ModeMerge.mergeSub) + ", " + (Object)((Object)ModeMerge.mergeMul) + ", " + (Object)((Object)ModeMerge.mergeDiv) + ", " + (Object)((Object)ModeMerge.mergeKeepTile) + ", " + (Object)((Object)ModeMerge.mergeOverwriteTile) + "), HiPS hierarchy pixel aggregations (" + (Object)((Object)ModeTree.treeMean) + ", " + (Object)((Object)ModeTree.treeMedian) + ", " + (Object)((Object)ModeTree.treeMiddle) + ", " + (Object)((Object)ModeTree.treeFirst) + "). The use of a common suffix is valid for all associated modes (e.g. mode=add is equivalent to mode=" + (Object)((Object)ModeOverlay.overlayAdd) + "," + (Object)((Object)ModeMerge.mergeAdd) + ").", 4L),
    incremental("false|true", "Incremental HiPS", "Activates the memorization of the weights assigned to each HiPS pixel in order to be able to add new images afterwards, or concatenate two HiPS while keeping a weighting proportional to the number of source images that contributed to the calculation of each pixel. By default, this option is disabled because it doubles the final size of the HiPS (generates weight tiles).", 32L),
    region("inline moc|moc.fits", "Working region", "Reduces the working region. The syntax may be an inline ASCII MOC, ex: `orderA/npix1 npix2-npix3 ... orderB/npix`. It indicates the HEALPix indices of the area concerned. It can also be a file name containing a binary MOC (.fits extension).Without this parameter, the whole sphere is processed.", 4L),
    partitioning("false|nnn", "Splitting large original images into blocks", "By default, the original images are processed in blocks of 4096 x 4096 pixels. This partitioning mechanism can be removed (value: `false`) or modified (value: block width). Small blocks save RAM but slow down processing.", 32816L),
    maxThread("nn", "CPU thread limitation", "By default, all available CPU cores are used in order to operate as fast as possible. Limiting the number of cores allows the machine to keep power for other tasks.", 4L),
    fastCheck("true|false", "Mirror check method", "Specifies how previously copied tiles will be checked in the particular context of a duplicate copy (`MIRROR` action). By default, the check is fast, and is based only on a reasonable size of the tile, with no exchange with the server providing the original HiPS. By forcing this parameter to `false`, the check will be more complete to ensure that the size and date is consistent, but much slower, especially when the HiPS was almost copied entirely. Note that the `MIRROR` action will do a CHECK action anyway if the HiPS to be copied provides these digital keys.", 2048L),
    fitsKeys("key1,key2...", "FITS keywords for image characteristics extraction", "The INDEX and DETAILS actions respectively record and provide the characteristics of the original images (observation date, exposure time, etc). A list of common keywords is used by default to enumerate these characteristics and store them in the HpxFinder spatial index tiles. This parameter allows to substitute the default list with specific keywords.", 16L),
    id("AUTH/P/...", "HiPS identifier", "Conforms to the IVOA syntax `AUTHORITY/P/...` (e.g. CDS/P/DSS/E). The assignment of a unique identifier is strongly recommended, and is essential when the HiPS is distributed. The authority is usually an acronym of the institution, the separator `/P/` is specific to `P`ixel HiPS, and the end of the identifier describes the HiPS, usually the name of the mission, and its main feature(s) (slash `/` is recommended as a separator rather than underscore `_`).", 2L),
    title("title", "HiPS title", "The title of the HiPS should describe it in a few words (e.g. ZTF DR7 g). Assigning a title is strongly recommended and will by default be built from the identifier (see `id` parameter).", 2L),
    creator("name", "HiPS creator", "Name of the person and/or institute that generated the HiPS.", 2L),
    target("ra dec [radius [freq]]", "Default HiPS target", "Default RA DEC [FREQ] display position (format: real real real real (ICRS frame, unit: degrees & hertz) .If not specified, central position of the first image (reference image).", 2L),
    targetRadius("radius", "Default HiPS target radius", "Default display size (format: real, unit: degrees).", 1L),
    status("private|public [clonable|clonableOnce|unclonable]", "HiPS status", "Status of HiPS. The default is `public` for free browsing, and `clonableOnce` to allow duplication but only from this instance. Can be changed to `private` to restrict browsing, and `clonable` or `unclonable` to change duplication rights.", 2L),
    color("jpeg|png", "Tile format of a colour HiPS", "In case the original images are jpeg or png colour files, or with the RGB action, specify the HiPS colour format. By default, keeps the original image format.", 1056L),
    inRed("hipspath", "Red HiPS path", "Indicates the path of the original HiPS when using an `RGB` action to calculate the red component.", 1024L),
    inGreen("hipspath", "Green HiPS path", "Indicates the path of the original HiPS when using an `RGB` action to calculate the green component.", 1024L),
    inBlue("hipspath", "Blue HiPS path", "Indicates the path of the original HiPS when using an `RGB` action to calculate the blue component.", 1024L),
    cmRed("min [mid] max [fct]", "Red color mapping", "Method to convert the red component pixels for an `RGB` action. Specifies the range of original pixel values and the conversion function used (log, sqrt, linear (default), asinh, pow2) to map them to the 256 possible colour channel values.", 1024L),
    cmGreen("min [mid] max [fct]", "Green color mapping", "Method to convert the green component pixels for an `RGB` action. Specifies the range of original pixel values and the conversion function used (log, sqrt, linear (default), asinh, pow2) to map them to the 256 possible colour channel values.", 1024L),
    cmBlue("min [mid] max [fct]", "Blue color mapping", "Method to convert  the blue component pixels for an `RGB` action. Specifies the range of original pixel values and the conversion function used (log, sqrt, linear (default), asinh, pow2) to map them to the 256 possible colour channel values.", 1024L),
    luptonQ("x", "Q coef Lupton RGB builder", 1024L),
    luptonS("x/x/x", "Scale coefs Lupton RGB builder", 1024L),
    luptonM("x/x/x", "M coefs Lupton RGB builder", 1024L),
    cache("dir", "Alternative cache directory", "Specifies a directory buffer instead of the one provided by the operating system. This buffer is used for decompressing the original images when necessary. See parameters cacheSize and cacheRemoveOnExit.", 32816L),
    cacheSize("nnMB", "Alternative cache size limit", "Indicates the maximum size of the buffer (see cache parameter). By default, the buffer is half a TB or less if the buffer partition does not allow it. The expected unit is MB.", 32816L),
    cacheRemoveOnExit("true|false", "Removing cache disk control", "Indicates that the contents of the buffer should be preserved (or not) from one session to the next. This allows a session to be restarted without having to decompress images unnecessarily.", 32816L),
    mocOrder("nn [<nnMB]", "Specifical MOC order an/or size limit", "Specifies the resolution and/or size of the MOC associated with the HiPS (file `Moc.fits`, resp. `STMoc.fits`). By default the resolution of the MOC depends on the spatial distribution of the HiPS. If this coverage results in an overly large MOC, its resolution will automatically be degraded (but not below the order of the HiPS itself). This parameter allows to explicitly specify an order for the MOC, and/or a volume limit.", 32992L),
    mapNside("nn", "HEALPix map NSIDE", "Dedicated to the MAP action. Allows you to specify a particular NSIDE value (default 1024). For this resolution to be identical to the original HiPS it should correspond to the formula: nside = tileWidth x 2^order. ", 4096L),
    format("fmt1 fmt2 ...", "Tile formats to process", "Dedicated to the MIRROR and PACK/UNPACK actions. Specifies the list of tile formats to be processed (e.g. `fits jpeg` - by default all formats).", 198656L),
    mirrorSplit("size;altPath ...", "Multi disk partition split", "Dedicated to the MIRROR action. Indicate one or more alternative directories needed for the copy if the default directory does not have the required size. For example `10g;/data/hips-ext1 200g;/data/hips-ext2` will cause the first 10GB to be copied into the default directory `out`, then 200GB into the alternative directory /data/hips-ext1, and all the rest into /data/hips-ext2", 2048L),
    pilot("nn", "Pilot HiPS for testing", "Dedicated to generating a `pilot' HIPS for testing. Indicates the number of original images to be considered.", 32816L),
    verbose("nn", "Debug information", 1L),
    skyvalues("x1 x2 x3 x4", "4 skyvalues", 33L);

    String info;
    String synopsis;
    String description = null;
    long m;

    private static Action getFromMask(long mask) {
        return mask == 16L ? Action.INDEX : (mask == 32L ? Action.TILES : (mask == 64L ? Action.MOC : (mask == 512L ? Action.PNG : (mask == 1024L ? Action.RGB : (mask == 2048L ? Action.MIRROR : (mask == 256L ? Action.JPEG : (mask == 128L ? Action.STMOC : (mask == 4096L ? Action.MAP : (mask == 8192L ? Action.DETAILS : (mask == 16384L ? Action.CUT : (mask == 32768L ? Action.COUNT : (mask == 65536L ? Action.PACK : (mask == 131072L ? Action.UNPACK : null)))))))))))));
    }

    private Param(String synopsis, String info, long m) {
        this.synopsis = synopsis;
        this.info = info;
        this.m = m;
    }

    private Param(String synopsis, String info, String description, long m) {
        this.synopsis = synopsis;
        this.info = info;
        this.description = description;
        this.m = m;
    }

    String info() {
        return this.info;
    }

    String synopsis() {
        return this.synopsis;
    }

    String description() {
        return Action.fold(this.description);
    }

    /*
     * WARNING - void declaration
     */
    String fullHelp(String launcher, int mode) {
        boolean html = (mode & 2) != 0;
        StringBuilder s = new StringBuilder();
        if (html) {
            ArrayList<Action> b;
            s.append("<B>PARAMETER  <FONT COLOR=green SIZE=+1>" + (Object)((Object)this) + "</FONT></B> - " + this.info);
            String[] a = ParamObsolete.aliases(this.toString());
            s.append("\n<P><B>SYNOPSIS</B>   <PRE>     " + (Object)((Object)this) + "=" + Param.htmlEncode(this.synopsis) + "</PRE>");
            if (a != null) {
                void var8_14;
                s.append("\n<P><B>ALIAS</B>");
                String[] stringArray = a;
                int n = stringArray.length;
                boolean bl = false;
                while (var8_14 < n) {
                    String s1 = stringArray[var8_14];
                    s.append(" " + s1);
                    ++var8_14;
                }
            }
            if ((b = this.listOfActions()) != null) {
                s.append("\n<P><B>ACTIONS</B><UL>");
                for (Action action : b) {
                    s.append("\n<LI>   " + (Object)((Object)action) + " - " + action.info());
                }
                s.append("\n</UL>");
            }
            if (this.description != null) {
                s.append("\n<P><B>DESCRIPTION</B><P>   " + this.description());
            }
        } else {
            String[] b;
            s.append("PARAMETER\n   " + (Object)((Object)this) + " - " + this.info);
            String[] a = ParamObsolete.aliases(this.toString());
            s.append("\n\nSYNOPSIS\n   " + (Object)((Object)this) + "=" + this.synopsis);
            if (a != null) {
                void var8_17;
                s.append("\n\nALIAS");
                b = a;
                int n = b.length;
                boolean bl = false;
                while (var8_17 < n) {
                    String s1 = b[var8_17];
                    s.append("\n   " + s1);
                    ++var8_17;
                }
            }
            if ((b = this.listOfActions()) != null) {
                s.append("\n\nACTIONS");
                for (Action action : b) {
                    s.append("\n   " + (Object)((Object)action) + " - " + action.info());
                }
            }
            if (this.description != null) {
                s.append("\n\nDESCRIPTION\n   " + this.description());
            }
        }
        return s.toString();
    }

    boolean equals(String s) {
        if (s == null) {
            return false;
        }
        return this.toString().toLowerCase().equals(s.toLowerCase());
    }

    boolean checkActions(Vector<Action> a) {
        if (this.m < 16L) {
            return true;
        }
        for (long mask = 16L; mask <= 262144L; mask <<= 1) {
            Action b;
            if ((this.m & mask) == 0L || (b = Param.getFromMask(mask)) == null) continue;
            if (b.noCheck()) {
                return true;
            }
            Iterator<Action> it = a.iterator();
            while (it.hasNext()) {
                if (b != it.next()) continue;
                return true;
            }
        }
        return false;
    }

    ArrayList<Action> listOfActions() {
        if (this.m < 16L) {
            return null;
        }
        ArrayList<Action> res = null;
        for (long mask = 16L; mask <= 262144L; mask <<= 1) {
            Action b;
            if ((this.m & mask) == 0L || (b = Param.getFromMask(mask)) == null) continue;
            if (res == null) {
                res = new ArrayList<Action>();
            }
            res.add(b);
        }
        return res;
    }

    static Param get(String param) throws Exception {
        for (Param p : Param.values()) {
            if (!p.equals(param)) continue;
            return p;
        }
        throw new Exception("Param unknown");
    }

    static String help(String launcher, int mode) {
        boolean full = (mode & 1) != 0;
        boolean html = (mode & 2) != 0;
        StringBuilder s = new StringBuilder();
        for (Param a : Param.values()) {
            String s1;
            if ((a.m & 9L) != 0L) continue;
            if (html) {
                if (full) {
                    s.append("\n<HR>\n" + a.fullHelp(launcher, mode));
                    continue;
                }
                s1 = String.format("%-20s: ", (Object)((Object)a) + "=" + a.synopsis);
                s.append("   " + s1 + a.info + "<BR>");
                continue;
            }
            if (full) {
                s.append("\n\n" + Action.LINE + a.fullHelp(launcher, mode));
                continue;
            }
            s1 = String.format("%-20s: ", (Object)((Object)a) + "=" + a.synopsis);
            s.append("   " + s1 + a.info + "\n");
        }
        if (full) {
            if (html) {
                s.append("\n<HR>\n");
            } else {
                s.append("\n\n" + Action.LINE);
            }
        }
        return s.toString();
    }

    private static final String htmlEncode(String s) {
        return s.replace("<", "&lt;");
    }

    class A {
        static final long UNDOC = 1L;
        static final long META = 2L;
        static final long CTRL = 4L;
        static final long TEST = 8L;
        static final long INDEX = 16L;
        static final long TILES = 32L;
        static final long MOC = 64L;
        static final long STMOC = 128L;
        static final long JPEG = 256L;
        static final long PNG = 512L;
        static final long RGB = 1024L;
        static final long MIRROR = 2048L;
        static final long MAP = 4096L;
        static final long DETAILS = 8192L;
        static final long CUT = 16384L;
        static final long COUNT = 32768L;
        static final long PACK = 65536L;
        static final long UNPACK = 131072L;
        static final long MAX = 262144L;

        A() {
        }
    }
}

