/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

public enum ModeOverlay {
    overlayNone,
    overlayMean,
    overlayFading,
    overlayAdd,
    overlayMeanMax;

    public static int OVERLAYMEAN_MAX;

    public static ModeOverlay getDefault() {
        return overlayMean;
    }

    public void setOverlayMeanMax(int max) {
        OVERLAYMEAN_MAX = max;
    }

    public static String contains(String test) {
        if (test == null) {
            return null;
        }
        test = test.toUpperCase();
        for (ModeOverlay c : ModeOverlay.values()) {
            if (!c.name().toUpperCase().endsWith(test)) continue;
            return c.name();
        }
        return null;
    }

    public static String list() {
        StringBuilder s = new StringBuilder();
        for (ModeOverlay m : ModeOverlay.values()) {
            if (s.length() > 0) {
                s.append('|');
            }
            s.append(m.toString());
        }
        return s.toString();
    }

    public static String getExplanation(ModeOverlay m) {
        if (m == overlayNone) {
            return (Object)((Object)m) + ": Take only one progenitor pixel value";
        }
        if (m == overlayMean) {
            return (Object)((Object)m) + ": Mean of the progenitor pixel values";
        }
        if (m == overlayMeanMax) {
            return (Object)((Object)m) + ": Mean of the progenitor pixel values (first " + OVERLAYMEAN_MAX + " max)";
        }
        if (m == overlayFading) {
            return (Object)((Object)m) + ": Mean of the progenitor pixel values + fading effect";
        }
        if (m == overlayAdd) {
            return (Object)((Object)m) + ": Addition of the progenitor pixel values";
        }
        return "";
    }

    static {
        OVERLAYMEAN_MAX = 20;
    }
}

