/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

public enum ModeMerge {
    mergeKeep,
    mergeOverwrite,
    mergeMean,
    mergeAdd,
    mergeSub,
    mergeMul,
    mergeDiv,
    mergeOverwriteTile,
    mergeKeepTile,
    link,
    copy;


    public static ModeMerge getDefault(int bitpix) {
        return bitpix == 0 ? mergeOverwriteTile : mergeOverwrite;
    }

    public static String contains(String test) {
        if (test == null) {
            return null;
        }
        test = test.toUpperCase();
        for (ModeMerge c : ModeMerge.values()) {
            if (!c.name().toUpperCase().endsWith(test)) continue;
            return c.name();
        }
        return null;
    }

    public static String list() {
        StringBuilder s = new StringBuilder();
        for (ModeMerge m : ModeMerge.values()) {
            if (s.length() > 0) {
                s.append('|');
            }
            s.append(m.toString());
        }
        return s.toString();
    }

    public static String getExplanation(ModeMerge m) {
        if (m == mergeKeep) {
            return (Object)((Object)m) + ": Replace pixel values only for pixels not yet computed or BLANK";
        }
        if (m == mergeOverwrite) {
            return (Object)((Object)m) + ": Replace existing pixel values if the new value is not BLANK";
        }
        if (m == mergeMean) {
            return (Object)((Object)m) + ": Compute the weighted average value based on the new pixel value and the existing one";
        }
        if (m == mergeAdd) {
            return (Object)((Object)m) + ": Add pixels values";
        }
        if (m == mergeSub) {
            return (Object)((Object)m) + ": Substraction only for existing values";
        }
        if (m == mergeMul) {
            return (Object)((Object)m) + ": Multiplication only for existing values";
        }
        if (m == mergeDiv) {
            return (Object)((Object)m) + ": Division only for existing values";
        }
        if (m == mergeOverwriteTile) {
            return (Object)((Object)m) + ": Add new tiles, and if necessary, replace existing tiles";
        }
        if (m == mergeKeepTile) {
            return (Object)((Object)m) + ": Add new tiles but only for those not yet computed";
        }
        if (m == link) {
            return (Object)((Object)m) + ": Composite cube tiles based on symbolic links on original tiles";
        }
        if (m == copy) {
            return (Object)((Object)m) + ": Composite cube tiles are copies of original tiles";
        }
        return "";
    }
}

