/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.hipsgen.Context;
import cds.moc.Healpix;
import cds.moc.SMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;

public class MocGen {
    Healpix hpx = new Healpix();
    private String in = null;
    private String out = null;
    private String previous = null;
    private int order = 10;
    private double blank = Double.NaN;
    private int fmt = 0;
    public boolean verbose = false;
    public boolean debug = false;
    private boolean strict = false;
    private boolean recursive = false;
    private boolean multWrite = false;
    private int[] hdu = null;
    private ArrayList<Prop> prop;
    private SMoc moc;
    private boolean ready;
    private boolean error;
    private String serror;
    private boolean abort;
    private String scanningDir = null;
    private int nbImg;
    private long tStart = 0L;
    private long t1 = 0L;
    private long t2 = 0L;
    private int dot = 0;
    private boolean needNL = false;

    public MocGen(String[] args) {
        this.prop = new ArrayList();
        this.execute(args);
    }

    public MocGen(String in, int order, boolean recursive, boolean strict, double blank, int[] hdu) throws Exception {
        this.strict = strict;
        this.blank = blank;
        this.in = in;
        this.recursive = recursive;
        this.order = order;
        this.hdu = hdu;
        this.prop = new ArrayList();
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isError() {
        return this.error;
    }

    public String getError() {
        return this.serror;
    }

    public SMoc getMoc() throws Exception {
        if (this.error) {
            throw new Exception("MOC error => " + this.serror);
        }
        if (!this.ready) {
            throw new Exception("MOC not yet ready");
        }
        return this.moc;
    }

    public void abort() {
        this.abort = true;
    }

    public String getScanningDir() {
        return this.scanningDir;
    }

    public int getNbImages() {
        return this.nbImg;
    }

    public void start() {
        new Thread(){

            @Override
            public void run() {
                try {
                    MocGen.this.serror = null;
                    MocGen.this.error = (MocGen.this.abort = (MocGen.this.ready = false));
                    MocGen.this.nbImg = 0;
                    MocGen.this.moc = new SMoc();
                    MocGen.this.moc.setMocOrder(MocGen.this.order);
                    MocGen.this.moc.bufferOn();
                    MocGen.this.scanAndDo(MocGen.this.moc, new File(MocGen.this.in), MocGen.this.order);
                    MocGen.this.moc.bufferOff();
                    MocGen.this.ready = true;
                }
                catch (Exception e) {
                    MocGen.this.moc = null;
                    MocGen.this.serror = e.getMessage();
                    MocGen.this.error = true;
                    MocGen.this.ready = true;
                }
            }
        }.start();
    }

    private boolean addInMocPixel(SMoc moc, File file, int order) throws Exception {
        boolean rep = false;
        String currentfile = file.getPath();
        Fits f = new Fits();
        boolean flagDefaultHDU = this.hdu == null;
        boolean flagAllHDU = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
        int cellSize = 2048;
        int firstDepth = 0;
        for (int i = 0; flagAllHDU || flagDefaultHDU || i < this.hdu.length; ++i) {
            block11: {
                int ext = flagDefaultHDU ? 0 : (flagAllHDU ? i : this.hdu[i]);
                try {
                    int code = f.loadHeaderFITS(currentfile + (ext == 0 ? "" : "[" + ext + "]"), true);
                    if (flagAllHDU && (code & 0x10) != 0 || f.getCalib() == null) continue;
                    if (firstDepth == 0) {
                        firstDepth = f.depth;
                    } else if (f.depth != firstDepth) continue;
                    try {
                        int width = f.width;
                        int height = f.height;
                        int heightSize = 0x40000000 / (f.height * Math.abs(f.bitpix));
                        if (heightSize < 1) {
                            heightSize = 1;
                        } else if (heightSize > height) {
                            heightSize = height;
                        }
                        for (int y = 0; y < height; y += heightSize) {
                            f.widthCell = width;
                            f.heightCell = y + heightSize > height ? height - y : heightSize;
                            f.depth = 1;
                            f.depthCell = 1;
                            f.xCell = 0;
                            f.yCell = y;
                            f.zCell = 0;
                            f.ext = ext;
                            String currentCell = f.getCellSuffix();
                            rep |= this.addInMocPixel1(f, moc, currentfile, currentCell, order);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break;
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    Aladin.trace(3, e.getMessage() + " " + currentfile);
                }
                break;
            }
            if (flagDefaultHDU) break;
        }
        return rep;
    }

    private boolean addInMocPixel1(Fits f, SMoc moc, String currentfile, String currentCell, int order) throws Exception {
        boolean rep = false;
        int localOrder = 0;
        Calib c = f.getCalib();
        if (c == null) {
            if (this.debug) {
                System.out.println(currentfile + currentCell + " ignored (no calibration) => " + currentfile);
            }
            return rep;
        }
        f.loadFITS(currentfile + currentCell);
        Coord coo = new Coord();
        double gap = 1.0;
        try {
            double resImage = Math.min(c.GetResol()[0], c.GetResol()[1]);
            localOrder = order;
            while (CDSHealpix.pixRes(localOrder) / 3600.0 <= resImage) {
                --localOrder;
            }
            if (gap < 1.0) {
                gap = 1.0;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (this.verbose) {
            System.out.println("Adding pixel coverage of " + currentfile + currentCell + "...");
        }
        if (!Double.isNaN(this.blank)) {
            f.setBlank(this.blank);
        }
        int n = 0;
        int n1 = 0;
        long oNpix = -1L;
        for (int y = f.yCell; y < f.yCell + f.heightCell; ++y) {
            for (int x = f.xCell; x < f.xCell + f.widthCell; ++x) {
                try {
                    double pix = f.getPixelDouble(x, y);
                    if (f.isBlankPixel(pix)) continue;
                    coo.x = x;
                    coo.y = f.height - y - 1;
                    c.GetCoord(coo);
                    long npix = 0L;
                    npix = this.hpx.ang2pix(localOrder, coo.al, coo.del);
                    if (npix == oNpix) {
                        ++n1;
                        continue;
                    }
                    moc.add(localOrder, npix);
                    oNpix = npix;
                    if (++n > 100000) {
                        n = 0;
                        this.updateMoc(moc, this.out, this.fmt);
                    }
                    rep = true;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return rep;
    }

    private boolean addInMocBox(Fits f, SMoc moc, int order) throws Exception {
        boolean res = true;
        Coord coo = new Coord();
        ArrayList<double[]> cooList = new ArrayList<double[]>(10);
        Calib c = f.getCalib();
        Dimension dim = c.getImgSize();
        for (int i = 0; i < 4; ++i) {
            coo.x = i == 0 || i == 3 ? 0 : dim.width;
            coo.y = i < 2 ? 0 : dim.height;
            c.GetCoord(coo);
            cooList.add(new double[]{coo.al, coo.del});
        }
        SMoc m1 = CDSHealpix.createSMoc(cooList, order);
        moc.add(m1);
        return res;
    }

    private boolean addInMocBox(SMoc moc, File file, int order) throws Exception {
        boolean rep = false;
        boolean flagFirstHdu = this.hdu == null;
        boolean flagAllHdu = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
        for (int i = 0; flagAllHdu || flagFirstHdu || i < this.hdu.length; ++i) {
            int ext = flagFirstHdu ? 0 : (flagAllHdu ? i : this.hdu[i]);
            Fits f = new Fits();
            f.setSkipHDU0(flagFirstHdu);
            try {
                f.loadHeaderFITS(file.getAbsolutePath() + "[" + ext + "]", true);
            }
            catch (Exception e) {
                return rep;
            }
            Calib c = f.getCalib();
            if (c == null) continue;
            if (this.verbose) {
                System.out.println("Adding footprint of " + file.getName() + f.getCellSuffix() + "...");
            }
            if (!Double.isNaN(this.blank)) {
                f.setBlank(this.blank);
            }
            rep |= this.addInMocBox(f, moc, order);
            if (flagFirstHdu) break;
        }
        return rep;
    }

    private boolean addInMoc(SMoc moc, File file, int order, boolean strict) throws Exception {
        if (!strict) {
            return this.addInMocBox(moc, file, order);
        }
        return this.addInMocPixel(moc, file, order);
    }

    private void scanAndDo(SMoc moc, File rep, int order) throws Exception {
        this.scanningDir = rep.getCanonicalPath();
        File[] list = rep.isFile() ? new File[]{rep} : rep.listFiles();
        for (File f : list) {
            if (this.debug) {
                System.out.println("Scanning " + f);
            }
            if (this.abort) {
                throw new Exception("MOC aborted");
            }
            if (!f.isFile()) continue;
            if (this.addInMoc(moc, f, order, this.strict)) {
                ++this.nbImg;
            }
            if (this.nbImg <= 0 || this.nbImg % 100 != 0) continue;
            this.updateMoc(moc, this.out, this.fmt);
        }
        if (this.recursive) {
            for (File f : list) {
                if (!f.isDirectory()) continue;
                this.scanAndDo(moc, f, order);
            }
        }
    }

    private boolean updateMoc(SMoc moc, String out, int fmt) throws Exception {
        long t = System.currentTimeMillis();
        if (t - this.t1 < 6000L) {
            return false;
        }
        this.t1 = t;
        if (!this.verbose) {
            System.out.print(".");
            this.needNL = true;
            ++this.dot;
            if (this.dot > 10) {
                this.dot = 0;
                System.out.println();
                this.needNL = false;
            }
        }
        if (this.t2 > 0L && t - this.t2 > 60000L) {
            if (this.needNL) {
                System.out.println();
            }
            String s = this.nbImg + 1 > 1 ? "s" : "";
            System.out.println(this.nbImg + 1 + " image" + s + " in progress (MOC size=" + Util.getUnitDisk(moc.getMem()) + " in " + Util.getTemps((t - this.tStart) * 1000L) + ")...");
            this.needNL = false;
            this.t2 = t;
        }
        if (!this.multWrite || moc.isEmpty()) {
            return false;
        }
        if (this.verbose) {
            System.out.println("Updating output MOC [" + out + "]...");
        }
        moc.flush();
        moc.write(out, fmt);
        return true;
    }

    private boolean scanArgs(String[] args) {
        for (String s : args) {
            int x = s.indexOf("=") + 1;
            if (s.startsWith("in=")) {
                this.in = s.substring(x);
                if (new File(this.in).exists()) continue;
                System.out.println("Unavailable directory or file [" + this.in + "]");
                return false;
            }
            if (s.startsWith("out=")) {
                this.out = s.substring(x);
                if (!new File(this.out).exists() || new File(this.out).canWrite()) continue;
                System.out.println("Unavailable output file [" + this.out + "]");
                return false;
            }
            if (s.startsWith("previous=")) {
                this.previous = s.substring(x);
                if (new File(this.previous).exists()) continue;
                System.out.println("Unavailable previous MOC file [" + this.previous + "]");
                return false;
            }
            if (s.startsWith("hdu=")) {
                try {
                    this.hdu = Context.parseHDU(s.substring(x));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Unavailable HDU numbers [" + s.substring(x) + "]");
                    return false;
                }
            }
            if (s.startsWith("addprop=")) {
                try {
                    this.prop.add(new Prop(s.substring(x)));
                }
                catch (Exception e) {
                    System.out.println("Unavailable addprop syntax => ignored [" + s.substring(x) + "]");
                }
                continue;
            }
            if (s.equals("-v") || s.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (s.equals("-d")) {
                this.verbose = true;
                this.debug = true;
                continue;
            }
            if (s.equals("-r")) {
                this.recursive = true;
                continue;
            }
            if (s.equals("-o")) {
                this.multWrite = true;
                continue;
            }
            if (s.equals("-strict")) {
                this.strict = true;
                continue;
            }
            if (s.equalsIgnoreCase("-pixfoot") || s.equalsIgnoreCase("-mocgen")) continue;
            if (s.startsWith("mocfmt=")) {
                String a = s.substring(x);
                if (a.equalsIgnoreCase("fits")) {
                    this.fmt = 0;
                    continue;
                }
                if (a.equalsIgnoreCase("json") || a.equalsIgnoreCase("ascii")) {
                    this.fmt = 2;
                    continue;
                }
                System.out.println("Unkown MOC format [" + a + "]");
                return false;
            }
            if (s.startsWith("blank=")) {
                try {
                    this.blank = Double.parseDouble(s.substring(x));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Wrong blank value [" + s.substring(x) + "]");
                    return false;
                }
            }
            if (s.startsWith("order=")) {
                try {
                    this.order = Integer.parseInt(s.substring(x));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Wrong order value [" + s.substring(x) + "]");
                    return false;
                }
            }
            System.out.println("Unkown parameter [" + s + "]");
            return false;
        }
        if (this.out == null) {
            System.out.println("Missing parameters !");
            return false;
        }
        if (this.strict) {
            System.out.println("MOC generation based on *pixel* coverage:");
        } else {
            System.out.println("MOC generation based on *image* coverage:");
        }
        System.out.println(".in=" + (this.in == null ? "null => assuming stdin WCS headers stream (blank line separator)" : this.in));
        if (this.recursive && this.in != null && new File(this.in).isDirectory()) {
            System.out.println(".recursive directory scanning");
        }
        System.out.println(".out=" + this.out);
        if (this.previous != null) {
            System.out.println(".previous=" + this.previous);
        }
        System.out.println(".order=" + this.order);
        if (this.hdu != null) {
            System.out.print(".hdu=");
            if (this.hdu.length > 0 && this.hdu[0] == -1) {
                System.out.println("all");
            } else {
                for (int i = 0; i < this.hdu.length; ++i) {
                    System.out.print((i == 0 ? "" : ",") + this.hdu[i]);
                }
                System.out.println();
            }
        }
        System.out.println(".mocfmt=" + (this.fmt == 0 ? "fits" : "ascii"));
        if (this.strict) {
            System.out.println(".blank=NaN" + (Double.isNaN(this.blank) ? "" : "|" + this.blank));
        }
        return true;
    }

    private void usage() {
        System.out.println("Usage: java -jar Aladin.jar -mocgen ... in=inputDirOrFile out=MocFile\n-h                 : This help\n[-v]               : Verbose\n[-strict]          : Scan pixel values instead of using WCS image coverage\n[blank=value]      : Alternate BLANK value (-strict only)\n[order=nn]         : MOC resolution (default 10 => 3.345')\n[mocfmt=fits|json] : MOC output format (default Fits)\n[previous=moc.fits]: Previous MOC (if additions)\n[hdu=n1,n2-n3|all] : List of concerned Fits extensions\n[addprop=\"cle=value[ / comment]\" : Additionnal property stored in the target MOC file header fits file\n[-r]               : Recursive directory scanning\n[-o]               : Output MOC updated continuously rather than generated at the end\nin=fileOrDir       : Directory of images/headers collection\n[out=outMoc.fits]  : Output MOC file\n[-d]               : Debug trace\n\nGenerate the MOC corresponding to a collection of images or WCS headers.\nA MOC is a a coverage map based on HEALPix sky tesselation.\n\nThe supported formats are : FITS files, MEF files, jpeg or png files\n(WCS header in the comment segment), .hhh file (FITS header files without pixels)\nand .txt simple ASCII file (FITS header as keyword = value basic ASCII lines).\n\nVersion: 1.6 - based on Aladin v12.646 - May 2020 - P.Fernique [CDS]");
    }

    private void execute(String[] args) {
        if (args.length > 0 && (args[0].equals("-h") || args[0].equals("-help")) || !this.scanArgs(args)) {
            this.usage();
            return;
        }
        boolean n = false;
        try {
            this.serror = null;
            this.ready = false;
            this.abort = false;
            this.error = false;
            this.nbImg = 0;
            this.moc = new SMoc();
            if (this.previous != null) {
                this.moc.read(this.previous);
            }
            for (Prop p : this.prop) {
                this.moc.setProperty(p.key, p.value, p.comment);
            }
            this.moc.setMocOrder(this.order);
            this.tStart = System.currentTimeMillis();
            this.moc.bufferOn();
            this.scanAndDo(this.moc, new File(this.in), this.order);
            this.moc.bufferOff();
            long ms = System.currentTimeMillis() - this.tStart;
            if (this.needNL) {
                System.out.println();
            }
            if (this.verbose) {
                String s = this.nbImg > 1 ? "s" : "";
                System.out.println(this.nbImg + " image" + s + " added in the MOC in " + Util.getTemps(ms * 1000L));
            }
            this.moc.write(this.out, this.fmt);
            System.out.println("MOC achieved in " + Util.getTemps(ms * 1000L) + " => " + this.out);
            this.ready = true;
        }
        catch (Exception e) {
            this.moc = null;
            this.serror = e.getMessage();
            this.error = true;
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new MocGen(args);
    }

    private class Prop {
        String key;
        String value;
        String comment;

        Prop(String s) throws Exception {
            HeaderFits h = new HeaderFits();
            h.readFreeHeader(s);
            this.key = h.getKeys().nextElement();
            if (this.key == null) {
                throw new Exception("addprop error => ignored [" + s + "]");
            }
            this.value = h.getStringFromHeader(this.key);
            this.comment = h.getDescriptionFromHeader(this.key);
        }
    }
}

