/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.PlanHips;
import cds.fits.Fits;
import cds.hipsgen.BuilderIndex;
import cds.hipsgen.BuilderMapTiles;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Constante;
import cds.hipsgen.ContextGui;
import cds.hipsgen.TabBuild;
import cds.hipsgen.TabDesc;
import cds.hipsgen.TabJpg;
import cds.hipsgen.TabPub;
import cds.hipsgen.TabRgb;
import cds.tools.pixtools.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MainPanel
extends JPanel
implements ActionListener {
    protected Aladin aladin;
    protected ContextGui context;
    private JTabbedPane pTab;
    protected TabDesc tabDesc;
    protected TabBuild tabBuild = null;
    protected TabJpg tabJpg;
    protected TabPub tabPub;
    protected TabRgb tabRgb;
    PlanHips planPreview;
    private String lastPath = null;

    public MainPanel(Aladin aladin, ContextGui context) {
        this.aladin = aladin;
        this.context = context;
        context.setMainPanel(this);
        this.createPanel();
        BuilderRunner.DEBUG = Aladin.levelTrace > 0;
    }

    protected JProgressBar getProgressBarTile() {
        return this.tabBuild.buildProgressPanel.getProgressBarTile();
    }

    protected JProgressBar getProgressBarIndex() {
        return this.tabBuild.buildProgressPanel.getProgressBarIndex();
    }

    private void createPanel() {
        this.pTab = new JTabbedPane();
        this.tabBuild = new TabBuild(this);
        this.tabJpg = new TabJpg(this);
        this.tabPub = new TabPub(this.aladin, this);
        this.tabRgb = new TabRgb(this.aladin, this);
        this.tabDesc = new TabDesc(this.aladin, this);
        this.tabDesc.inputField.addActionListener(this);
        this.pTab.addTab(this.getString("MDESC"), null, this.tabDesc, null);
        this.pTab.addTab(this.getString("MBUILD"), null, this.tabBuild, this.getString("MTIPBUILD"));
        this.pTab.addTab(this.getString("MDISPLAY"), null, this.tabJpg, null);
        this.pTab.addTab(this.getString("MPUBLISH"), null, this.tabPub, this.getString("MTIPPUBLISH"));
        this.pTab.addTab(this.getString("MRGBA"), null, this.tabRgb, this.getString("MTIPRGB"));
        this.pTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MainPanel.this.pTab.getSelectedComponent() == MainPanel.this.tabRgb) {
                    MainPanel.this.tabRgb.init();
                }
            }
        });
        this.add((Component)this.pTab, "Center");
    }

    private String getString(String k) {
        MainPanel mainPanel = this;
        return mainPanel.aladin.getChaine().getString(k);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tabDesc.inputField) {
            this.init();
        }
    }

    public void init() {
        boolean flagIsMap = false;
        int order = 3;
        int bitpix = 16;
        String path = this.context.getInputPath();
        if (path.trim().length() == 0) {
            return;
        }
        if (this.lastPath == null || !this.lastPath.equals(path)) {
            this.lastPath = path;
            File f = new File(path);
            if (f.exists() && f.isFile()) {
                try {
                    BuilderMapTiles b = new BuilderMapTiles(this.context);
                    b.validateMap();
                    b.build(true);
                    flagIsMap = true;
                    order = b.maxOrder;
                    bitpix = b.bitpixOrig;
                }
                catch (Exception e) {
                    this.context.isInputFile = true;
                }
            }
            if (!f.isFile()) {
                this.context.isInputFile = false;
            }
            if (!flagIsMap) {
                boolean found = this.context.findImgEtalon(path);
                if (!found) {
                    this.context.warning("There is no available images in source directory !\n" + path);
                    return;
                }
                String filename = this.context.getImgEtalon();
                Fits file = new Fits();
                try {
                    file.loadHeaderFITS(filename, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                bitpix = file.bitpix;
                long nside = BuilderIndex.calculateNSide(file.getCalib().GetResol()[0] * 3600.0);
                order = Util.order((int)nside) - this.context.getTileOrder();
            }
            this.context.setMap(flagIsMap);
            this.tabBuild.setOriginalBitpixField(bitpix);
            this.tabBuild.setSelectedOrder(order);
        }
        this.newAllskyDir();
    }

    public void updateCurrentCM() {
        this.tabJpg.updateCurrentCM();
    }

    public void showDescTab() {
        this.pTab.setSelectedComponent(this.tabDesc);
    }

    public void showBuildTab() {
        this.pTab.setSelectedComponent(this.tabBuild);
    }

    public void showJpgTab() {
        this.pTab.setSelectedComponent(this.tabJpg);
    }

    public void showPubTab() {
        this.pTab.setSelectedComponent(this.tabPub);
    }

    public void showRgbTab() {
        this.pTab.setSelectedComponent(this.tabRgb);
    }

    protected void newAllskyDir() {
        this.tabPub.newAllskyDir(Constante.SURVEY);
        try {
            this.context.loadMocIndex();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        this.tabDesc.resumeWidgets();
        this.tabBuild.resumeWidgets();
        this.tabJpg.resumeWidgets();
        this.tabRgb.resumeWidgets();
    }

    public void close() {
        this.aladin.frameAllsky.close();
    }

    protected void clearForms() {
        Constante.SURVEY = "HiPS";
        this.context.reset();
        this.tabDesc.clearForms();
        this.tabBuild.clearForms();
        this.tabJpg.clearForms();
        this.tabPub.clearForms();
    }

    protected void export(String path) {
        if (this.planPreview == null) {
            this.context.updateHipsPreview(true);
        }
        this.aladin.frameAllsky.export(this.planPreview, path);
    }

    public boolean hasJpg() {
        try {
            return cds.tools.Util.find(this.context.getOutputPath(), ".jpg");
        }
        catch (Exception e) {
            return false;
        }
    }
}

