/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.hipsgen.BuilderLint;
import cds.hipsgen.Context;
import cds.mocmulti.MultiMoc;
import cds.tools.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HipsLint {
    static boolean flagColor = false;
    static boolean flagTileTest = true;
    static boolean flagMirrorTest = false;
    private static boolean TERM = false;
    public static SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String hipsListUrl) throws Exception {
        byte[] buf;
        boolean mocServerReading = true;
        Context context = new Context();
        boolean flagError = false;
        boolean flagWarning = false;
        boolean flagException = false;
        boolean mirror = false;
        context.info("Starting HipsLint " + SDF.format(new Date()) + " (based on Aladin " + "v12.646" + ")...");
        context.info(Context.getTitle("CHECKING HiPSserver [" + hipsListUrl + "]", '='));
        try (MyInputStream mis = null;){
            mis = Util.openAnyStream(hipsListUrl, false, false, BuilderLint.TIMEOUT);
            buf = mis.readFully();
            mis.close();
            mis = null;
        }
        InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(buf), "UTF-8");
        while (mocServerReading) {
            try {
                context = new Context();
                if (flagColor) {
                    context.setTerm(TERM);
                }
                MyProperties prop = new MyProperties();
                mocServerReading = prop.loadRecord(in);
                String id = MultiMoc.getID(prop);
                if (prop.size() == 0 || id == null) continue;
                context.run(Context.getTitle("Checking HiPSList record [" + id + "]"));
                String s = prop.get("creator_did");
                if (s == null) {
                    context.error("Lint[5.2] HiPSList \"creator_did\" keyword is mandatory");
                    flagError = true;
                }
                if ((s = prop.get("hips_release_date")) == null) {
                    context.error("Lint[5.2] HiPSList \"hips_release_date\" keyword is mandatory");
                    flagError = true;
                } else {
                    context.info("Lint: \"hips_release_date\" [" + s + "]");
                    if (!BuilderLint.checkDate(s)) {
                        context.error("Lint[4.4.1] HiPSList not ISO 8601 date [" + s + "]");
                        flagError = true;
                    }
                }
                s = prop.get("hips_status");
                if (s == null) {
                    context.error("Lint[5.2] HiPSList \"hips_status\" keyword is mandatory");
                    flagError = true;
                } else {
                    context.info("Lint: \"hips_status\" [" + s + "]");
                    StringBuilder statusUnref = null;
                    boolean flagPub = false;
                    boolean flagMirror = false;
                    boolean flagClone = false;
                    mirror = false;
                    StringTokenizer tok = new StringTokenizer(s, " ");
                    while (tok.hasMoreTokens()) {
                        String s1 = tok.nextToken();
                        int i = Util.indexInArrayOf(s1, BuilderLint.STATUS_PUB);
                        if (i >= 0) {
                            if (flagPub) {
                                context.error("Lint[4.4.1] hips_status error redundant definition [private/public]");
                                flagError = true;
                            } else {
                                flagPub = true;
                            }
                        } else {
                            i = Util.indexInArrayOf(s1, BuilderLint.STATUS_MIRROR);
                            if (i == 1) {
                                mirror = true;
                            }
                            if (i >= 0) {
                                if (flagMirror) {
                                    context.error("Lint[4.4.1] hips_status error redundant definition [master/mirror/partial]");
                                    flagError = true;
                                } else {
                                    flagMirror = true;
                                }
                            } else {
                                i = Util.indexInArrayOf(s1, BuilderLint.STATUS_CLONE);
                                if (i >= 0) {
                                    if (flagClone) {
                                        context.error("Lint[4.4.1] hips_status error redundant definition [clonable/unclonable/clonableOnce]");
                                        flagError = true;
                                    } else {
                                        flagClone = true;
                                    }
                                } else if (s1.indexOf(",") > 0) {
                                    context.error("Lint[4.4.1] hips_status comma separator error [" + s1 + "]");
                                    flagError = true;
                                } else if (statusUnref == null) {
                                    statusUnref = new StringBuilder(s1);
                                } else {
                                    statusUnref.append("," + s1);
                                }
                            }
                        }
                        if (statusUnref == null) continue;
                        context.warning("Lint: unreferenced hips_status keywords [" + statusUnref + "]");
                    }
                }
                String u = s = prop.get("hips_service_url");
                if (s == null) {
                    context.error("Lint[5.2] HiPSList \"hips_service_url\" keyword is mandatory");
                    flagError = true;
                }
                if (mirror && !flagMirrorTest) {
                    context.info("Lint: HiPS mirror skipped [" + id + "]");
                    continue;
                }
                context.info(Context.getTitle("Checking HiPS [" + id + "]"));
                context.hipslintTileTest = flagTileTest;
                if (!flagTileTest) {
                    context.info("Lint: lite test => no random tile test");
                }
                context.setOutputPath(u);
                BuilderLint builderLint = new BuilderLint(context);
                try {
                    int rep = builderLint.lint();
                    if (rep == 0) {
                        flagError = true;
                    } else if (rep == -1) {
                        flagWarning = true;
                    }
                    if (this.checkHipslistProp(context, prop, builderLint.getProperties())) continue;
                    flagError = true;
                }
                catch (Exception e) {
                    flagException = true;
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        in.close();
        if (flagException) {
            context.info("!!! [" + hipsListUrl + "] has not been fully checked => partial validation");
        }
        if (flagError) {
            context.info("*** [" + hipsListUrl + "] is not IVOA HiPS 1.0 compatible");
        } else if (flagWarning) {
            context.info("!!! [" + hipsListUrl + "] is IVOA HiPS 1.0 compatible but with warnings !");
        } else {
            context.info("*** [" + hipsListUrl + "] is fully IVOA HiPS 1.0 compatible");
        }
    }

    private boolean checkHipslistProp(Context context, MyProperties propHipslist, MyProperties p) {
        boolean flagError = false;
        for (String key : propHipslist.getKeys()) {
            String val = propHipslist.get(key);
            String v = p.get(key);
            if (key.equals("hips_service_url")) {
                if (val != null && val.endsWith("/")) {
                    val = val.substring(0, val.length() - 1);
                }
                if (v != null && v.endsWith("/")) {
                    v = v.substring(0, v.length() - 1);
                }
            }
            if (v == null || v.equals(val)) continue;
            context.error("Lint[5.2] HiPSList incoherency: said \"" + key + "=" + val + "\", found \"" + v + "\"");
            flagError = true;
        }
        return flagError;
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("-h")) {
            System.out.println("Usage: java -jar Hipslint [-color] [-mirrortest] [-notiletest] http://hips.server/hipslist [hipslisturl2 ...]");
            System.out.println("       HiPS server compatibility checker (IVOA HiPS 1.0 standard)");
            System.out.println("       -color: colourized console messages");
            System.out.println("       -mirrortest: also tests mirrored HiPS (by default discarded)");
            System.out.println("       -notiletest: basic testing only by avoiding random tile checks (faster)");
            System.exit(0);
        }
        Util.setUserAgent("Hipslint Aladin/" + "v12.646".substring(1));
        ArrayList<String> args1 = new ArrayList<String>();
        for (String s : args) {
            if (s.equalsIgnoreCase("-color")) {
                TERM = true;
                flagColor = true;
                continue;
            }
            if (s.equalsIgnoreCase("-nocolor")) {
                TERM = false;
                flagColor = true;
                continue;
            }
            if (s.equalsIgnoreCase("-notiletest")) {
                flagTileTest = false;
                continue;
            }
            if (s.equalsIgnoreCase("-mirrortest")) {
                flagMirrorTest = false;
                continue;
            }
            args1.add(s);
        }
        try {
            HipsLint lint = new HipsLint();
            for (String hipsListUrl : args1) {
                lint.check(hipsListUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SDF.setTimeZone(TimeZone.getDefault());
    }
}

