/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ModeTree;
import cds.hipsgen.MyInputStreamCached;
import cds.hipsgen.Param;
import cds.hipsgen.ParamObsolete;
import cds.hipsgen.ParamOption;
import cds.hipsgen.Task;
import cds.moc.Moc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class HipsGen {
    private File file;
    private boolean trim = Builder.TRIM;
    private boolean gzip = false;
    private boolean flagMode = false;
    private boolean flagConcat = false;
    private boolean flagPack = false;
    private boolean flagMirror = false;
    private boolean flagUpdate = false;
    private boolean flagLint = false;
    private boolean flagTMoc = false;
    private boolean flagTIndex = false;
    private boolean flagProp = false;
    private boolean flagModeTree = false;
    private boolean flagRGB = false;
    private boolean flagTileWidth = false;
    private boolean flagGunzip = false;
    private boolean flagMapFits = false;
    private boolean flagCrc = false;
    private boolean flagAbort = false;
    private boolean flagPause = false;
    private boolean flagResume = false;
    private boolean flagValidator = false;
    private boolean flagHtml = false;
    private boolean flagTrim = false;
    public Context context;
    private boolean flagHHHcar = false;
    public boolean endOfWork = true;
    private String cache = null;
    private long cacheSize = -1L;
    private boolean cacheRemoveOnExit = true;
    public String launcher = "Aladin.jar -hipsgen";
    private Vector<Action> actions;
    private ArrayList<Param> listParam;
    private MyProperties paramHist = new MyProperties();
    public static SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
    public static final int FULL = 1;
    public static final int HTML = 2;

    public HipsGen() {
        this.context = new Context();
        this.actions = new Vector();
        this.listParam = new ArrayList();
    }

    private MyProperties parseConfig() throws Exception {
        MyProperties properties = new MyProperties();
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(this.file)));
        properties.load(reader);
        for (String opt : properties.getKeys()) {
            if (opt.startsWith("#") || opt.trim().length() == 0) continue;
            String val = properties.getProperty(opt);
            try {
                this.setContextFromOptions(opt, val);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        reader.close();
        return properties;
    }

    private void setContextFromOptions(String p, String v) throws Exception {
        this.setContextFromOptions(p + (v == null ? "" : "=" + v));
    }

    private void setContextFromOptions(String param) throws Exception {
        String opt;
        if ((param = ParamObsolete.getLastSyntax(this.context, param)) == null) {
            return;
        }
        String val = null;
        int i = param.indexOf(61);
        if (i < 0) {
            opt = param;
        } else {
            opt = param.substring(0, i).trim();
            val = Tok.unQuote(param.substring(i + 1).trim());
        }
        String info = null;
        try {
            Param pa = Param.get(opt);
            this.listParam.add(pa);
            opt = pa.toString();
            info = pa.info();
        }
        catch (Exception pa) {
            // empty catch block
        }
        this.context.param(opt + "=" + (val == null ? "null" : val) + (info == null ? "" : " => " + info));
        this.paramHist.setProperty(opt, val);
        if (Param.cache.equals(opt)) {
            this.cache = val;
        } else if (Param.cacheSize.equals(opt)) {
            this.cacheSize = Long.parseLong(val);
        } else if (Param.cacheRemoveOnExit.equals(opt)) {
            this.cacheRemoveOnExit = Boolean.parseBoolean(val);
        } else if (Param.mirrorSplit.equals(opt)) {
            this.context.setSplit(val);
        } else if (Param.verbose.equals(opt)) {
            Context.setVerbose(Integer.parseInt(val));
        } else if (Param.pilot.equals(opt)) {
            this.context.setPilot(Integer.parseInt(val));
        } else if (Param.cunit.equals(opt)) {
            this.context.setCunit(val);
        } else if (Param.restfreq.equals(opt)) {
            this.context.setDefaultRestFreq(Double.parseDouble(val));
        } else if (Param.blank.equals(opt)) {
            try {
                this.context.setBlankOrig(Double.parseDouble(val));
            }
            catch (Exception e) {
                this.context.setBlankOrig(val);
            }
        } else if (Param.order.equals(opt)) {
            this.context.setOrder(Integer.parseInt(val));
        } else if (Param.orderFreq.equals(opt)) {
            this.context.setOrderFreq(Integer.parseInt(val));
        } else if (Param.mocOrder.equals(opt)) {
            this.context.setMocOrder(val);
        } else if (Param.mapNside.equals(opt)) {
            this.context.setMapNside(Integer.parseInt(val));
        } else if (Param.tileWidth.equals(opt)) {
            this.context.setTileWidth(Integer.parseInt(val));
            this.flagTileWidth = true;
        } else if ("tileDepth".equalsIgnoreCase(opt)) {
            this.context.setTileDepth(Integer.parseInt(val));
        } else if (Param.bitpix.equals(opt)) {
            this.context.setBitpix(Integer.parseInt(val));
        } else if (Param.frame.equals(opt)) {
            this.context.setFrameName(val);
        } else if (Param.maxThread.equals(opt)) {
            this.context.setMaxNbThread(Integer.parseInt(val));
        } else if (Param.skyVal.equals(opt)) {
            this.context.setSkyval(val);
        } else if (Param.skyvalues.equals(opt)) {
            this.context.setSkyValues(val);
        } else if (Param.expTime.equals(opt)) {
            this.context.setExpTime(val);
        } else if (Param.color.equals(opt)) {
            this.context.setColor(val);
        } else if (Param.inRed.equals(opt)) {
            this.context.setRgbInput(val, 0);
            this.flagRGB = true;
        } else if (Param.inGreen.equals(opt)) {
            this.context.setRgbInput(val, 1);
            this.flagRGB = true;
        } else if (Param.inBlue.equals(opt)) {
            this.context.setRgbInput(val, 2);
            this.flagRGB = true;
        } else if (Param.cmRed.equals(opt)) {
            this.context.setRgbCmParam(val, 0);
        } else if (Param.cmGreen.equals(opt)) {
            this.context.setRgbCmParam(val, 1);
        } else if (Param.cmBlue.equals(opt)) {
            this.context.setRgbCmParam(val, 2);
        } else if (Param.luptonQ.equals(opt)) {
            this.context.setRgbLuptonQ(val);
        } else if (Param.luptonM.equals(opt)) {
            this.context.setRgbLuptonM(val);
        } else if (Param.luptonS.equals(opt)) {
            this.context.setRgbLuptonS(val);
        } else if (Param.img.equals(opt)) {
            this.context.setImgEtalon(val);
        } else if (Param.fitsKeys.equals(opt)) {
            this.context.setIndexFitskey(val);
        } else if (Param.status.equals(opt)) {
            this.context.setStatus(val);
        } else if (Param.target.equals(opt)) {
            this.context.setTarget(val);
        } else if (Param.title.equals(opt)) {
            this.context.setTitle(val);
        } else if (Param.hdu.equals(opt)) {
            this.context.setHDU(val);
        } else if (Param.creator.equals(opt)) {
            this.context.setCreator(val);
        } else if (Param.id.equals(opt)) {
            this.context.setHipsId(val);
        } else if (Param.in.equals(opt)) {
            this.context.setInputPath(val);
        } else if (Param.out.equals(opt)) {
            this.context.setOutputPath(val);
        } else if (Param.incremental.equals(opt)) {
            this.context.setLive(Boolean.parseBoolean(val));
        } else if (Param.mode.equals(opt)) {
            this.context.setMode(val);
            this.flagMode = true;
        } else if (Param.partitioning.equals(opt)) {
            this.context.setPartitioning(val);
        } else if (Param.format.equals(opt)) {
            this.context.setTileFormat(val);
        } else if (Param.shape.equals(opt)) {
            this.context.setShape(val);
        } else if (Param.validRange.equals(opt)) {
            this.context.setPixelGood(val);
        } else if (Param.pixelCut.equals(opt)) {
            this.context.setPixelCut(val);
        } else if (Param.dataRange.equals(opt)) {
            this.context.setDataRange(val);
        } else if (Param.minOrder.equals(opt)) {
            this.context.setMinOrder(Integer.parseInt(val));
        } else if (Param.fastCheck.equals(opt)) {
            this.context.setfastCheck(Boolean.parseBoolean(val));
        } else if (Param.region.equals(opt)) {
            if (val.endsWith("fits")) {
                Moc moc = Moc.createMoc(new FileInputStream(val));
                this.context.setMocArea(moc);
            } else {
                this.context.setMocArea(val);
            }
        } else if (Param.maxRatio.equals(opt)) {
            try {
                this.context.setMaxRatio(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (Param.fov.equals(opt)) {
            try {
                this.context.setFov(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (Param.border.equals(opt)) {
            try {
                this.context.setBorderSize(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else {
            throw new Exception("Unknown parameter [" + opt + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHHHcar(String file, int frame) throws Exception {
        String prefLon;
        if (new File(file).isDirectory()) {
            throw new Exception("hhh generation failed");
        }
        Fits f = new Fits();
        f.loadPreview(file);
        int w = f.width;
        int h = f.height;
        this.context.info("Creating hhh file (assuming full sky CAR projection) for " + file);
        String string = frame == 0 ? "RA---" : (prefLon = frame == 3 ? "GLON--" : "ELON--");
        String prefLat = frame == 0 ? "DE---" : (frame == 3 ? "GLAT--" : "ELAT--");
        String filehhh = Fits.getHHHName(file);
        this.context.setInputPath(filehhh);
        double cd = 360.0 / (double)w;
        int crpix1 = w / 2;
        int crpix2 = h / 2;
        double crval1 = cd / 2.0;
        double crval2 = -cd / 2.0;
        if (crval1 <= -180.0) {
            crval1 += 360.0;
        }
        if (crval1 > 180.0) {
            crval1 -= 360.0;
        }
        try (BufferedWriter t = null;){
            t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filehhh)));
            t.write("NAXIS1  = " + w);
            t.newLine();
            t.write("NAXIS2  = " + h);
            t.newLine();
            t.write("CRPIX1  = " + crpix1);
            t.newLine();
            t.write("CRPIX2  = " + crpix2);
            t.newLine();
            t.write("CRVAL1  = " + crval1);
            t.newLine();
            t.write("CRVAL2  = " + crval2);
            t.newLine();
            t.write("CTYPE1  = " + prefLon + "CAR");
            t.newLine();
            t.write("CTYPE2  = " + prefLat + "CAR");
            t.newLine();
            t.write("CD1_1   = " + -cd);
            t.newLine();
            t.write("CD1_2   = 0");
            t.newLine();
            t.write("CD2_1   = 0");
            t.newLine();
            t.write("CD2_2   = " + cd);
            t.newLine();
        }
        this.context.setInputPath(filehhh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHHH(String s1) throws Exception {
        int origLon = -1;
        boolean flagLonInverse = true;
        Tok tok = new Tok(s1);
        String s = tok.nextToken();
        int i = s.lastIndexOf(File.separator);
        String path = i == -1 ? "" : s.substring(0, i + 1);
        int j = s.lastIndexOf(46);
        if (j == -1) {
            j = s.length();
        }
        String name = s.substring(i + 1, j);
        String ext = s.substring(j);
        s = tok.nextToken();
        i = s.indexOf(120);
        if (i > 0) {
            int ncol;
            int nlig;
            int hCell;
            int wCell;
            int width = Integer.parseInt(s.substring(0, i));
            int height = Integer.parseInt(s.substring(i + 1));
            if (tok.hasMoreTokens()) {
                s = tok.nextToken();
                i = s.indexOf(120);
                wCell = Integer.parseInt(s.substring(0, i));
                hCell = Integer.parseInt(s.substring(i + 1));
                if (tok.hasMoreTokens()) {
                    s = tok.nextToken();
                    origLon = Integer.parseInt(s);
                }
            } else {
                wCell = width;
                hCell = height;
            }
            boolean flagUniq = false;
            if (width == wCell && height == hCell) {
                flagUniq = true;
                nlig = 1;
                ncol = 1;
            } else {
                ncol = (int)Math.ceil((double)width / (double)wCell);
                nlig = (int)Math.ceil((double)height / (double)hCell);
            }
            double cd = 360.0 / (double)width;
            this.context.info("Generation of .hhh files for CAR " + ncol + "x" + nlig + " image(s) orig=" + origLon);
            int index = 0;
            for (int lig = 0; lig < nlig; ++lig) {
                int col = 0;
                while (col < ncol) {
                    String suffix = flagUniq ? "" : "-" + index;
                    String filename = path + name + suffix + ext;
                    File f = new File(filename);
                    if (!f.exists()) {
                        this.context.warning("Missing file => " + filename);
                    }
                    String filehhh = path + name + suffix + ".hhh";
                    int w = col == ncol - 1 ? width - col * wCell : wCell;
                    int h = lig == nlig - 1 ? height - lig * hCell : hCell;
                    int crpix1 = w / 2;
                    int crpix2 = h / 2;
                    int xc = col * wCell + crpix1;
                    int yc = lig * hCell + crpix2;
                    int deltaX = (origLon == -1 ? width / 2 : origLon) - xc;
                    int deltaY = height / 2 - yc;
                    double crval1 = (double)(-deltaX) * cd + (flagLonInverse ? -cd / 2.0 : cd / 2.0);
                    double crval2 = (double)deltaY * cd - cd / 2.0;
                    if (crval1 <= -180.0) {
                        crval1 += 360.0;
                    }
                    if (crval1 > 180.0) {
                        crval1 -= 360.0;
                    }
                    try (BufferedWriter t = null;){
                        t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filehhh)));
                        t.write("NAXIS1  = " + w);
                        t.newLine();
                        t.write("NAXIS2  = " + h);
                        t.newLine();
                        t.write("CRPIX1  = " + crpix1);
                        t.newLine();
                        t.write("CRPIX2  = " + crpix2);
                        t.newLine();
                        t.write("CRVAL1  = " + crval1);
                        t.newLine();
                        t.write("CRVAL2  = " + crval2);
                        t.newLine();
                        t.write("CTYPE1  = RA---CAR");
                        t.newLine();
                        t.write("CTYPE2  = DEC--CAR");
                        t.newLine();
                        t.write("CD1_1   = " + (flagLonInverse ? cd : -cd));
                        t.newLine();
                        t.write("CD1_2   = 0");
                        t.newLine();
                        t.write("CD2_1   = 0");
                        t.newLine();
                        t.write("CD2_2   = " + cd);
                        t.newLine();
                    }
                    ++col;
                    ++index;
                }
            }
        } else {
            int width = Integer.parseInt(s);
            double radius = Double.parseDouble(tok.nextToken());
            double cd = 2.0 * Math.tan(Math.toRadians((90.0 - radius) / 2.0)) * 114.59155902616465 / (double)width;
            double crval1 = flagLonInverse ? -cd / 2.0 : cd / 2.0;
            for (int k = 0; k < 2; ++k) {
                double crval2 = (double)(k == 0 ? 90 : -90) - cd / 2.0;
                String suffix = k == 0 ? "-N" : "-S";
                String filename = path + name + suffix + ext;
                File f = new File(filename);
                if (!f.exists()) {
                    this.context.warning("Missing file => " + filename);
                }
                String filehhh = path + name + suffix + ".hhh";
                try (BufferedWriter t = null;){
                    t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filehhh)));
                    t.write("NAXIS1  = " + width);
                    t.newLine();
                    t.write("NAXIS2  = " + width);
                    t.newLine();
                    t.write("CRPIX1  = " + width / 2);
                    t.newLine();
                    t.write("CRPIX2  = " + width / 2);
                    t.newLine();
                    t.write("CRVAL1  = " + crval1);
                    t.newLine();
                    t.write("CRVAL2  = " + crval2);
                    t.newLine();
                    t.write("CTYPE1  = RA---STG");
                    t.newLine();
                    t.write("CTYPE2  = DEC--STG");
                    t.newLine();
                    t.write("CD1_1   = " + (flagLonInverse ? cd : -cd));
                    t.newLine();
                    t.write("CD1_2   = 0");
                    t.newLine();
                    t.write("CD2_1   = 0");
                    t.newLine();
                    t.write("CD2_2   = " + cd);
                    t.newLine();
                }
                String filefov = path + name + suffix + ".fov";
                try {
                    t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filefov)));
                    double xc = (double)width / 2.0;
                    double yc = (double)width / 2.0;
                    double r = (double)width / 2.0;
                    t.write(xc + " " + yc + " " + r);
                    t.newLine();
                    continue;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            this.context.info("Generation of .hhh & .fov files for STG North and South image");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args) {
        String id2;
        boolean all;
        block145: {
            int length = args.length;
            boolean first = true;
            if (length == 0) {
                HipsGen.usage(this.launcher);
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ((arg = ParamObsolete.getLastSyntax(this.context, arg)) == null) continue;
                String param = "-param=";
                if (arg.startsWith(param)) {
                    try {
                        MyProperties hist = this.setConfigFile(arg.substring(param.length()));
                        for (String key : hist.getKeys()) {
                            String p1;
                            if (key.trim().length() == 0 || key.charAt(0) == '#' || (p1 = ParamObsolete.getLastSyntax(this.context, key + "=" + hist.get(key))) == null) continue;
                            String q = Tok.quote(p1);
                            if (this.context.scriptCommand == null) {
                                this.context.scriptCommand = q;
                                continue;
                            }
                            this.context.scriptCommand = this.context.scriptCommand + " " + q;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (arg.equalsIgnoreCase("-skygen") || arg.equalsIgnoreCase("-hipsgen")) continue;
                if (ParamOption.html.equals(arg)) {
                    this.flagHtml = true;
                    continue;
                }
                if (ParamOption.man.equals(arg)) {
                    if (i < args.length - 1) {
                        this.help(this.launcher, args[i + 1]);
                    } else {
                        HipsGen.usage(this.launcher, 1 | (this.flagHtml ? 2 : 0));
                    }
                    return;
                }
                if (ParamOption.h.equals(arg)) {
                    if (i < args.length - 1) {
                        this.help(this.launcher, args[i + 1]);
                    } else {
                        HipsGen.usage(this.launcher, this.flagHtml ? 2 : 0);
                    }
                    return;
                }
                if (first) {
                    first = false;
                    this.context.info("Starting HipsGen " + SDF.format(new Date()) + " (based on Aladin " + "v12.646" + ")...");
                }
                String q = Tok.quote(arg);
                this.context.scriptCommand = this.context.scriptCommand == null ? q : this.context.scriptCommand + " " + q;
                ParamOption po = null;
                if (ParamOption.d.equals(arg)) {
                    Context.setVerbose(4);
                    po = ParamOption.d;
                } else if (ParamOption.clean.equals(arg)) {
                    this.context.force = true;
                    po = ParamOption.clean;
                } else if (ParamOption.notrim.equals(arg)) {
                    this.trim = false;
                    this.flagTrim = true;
                    po = ParamOption.notrim;
                } else if (ParamOption.trim.equals(arg)) {
                    this.trim = true;
                    this.flagTrim = true;
                    po = ParamOption.trim;
                } else if (ParamOption.gzip.equals(arg)) {
                    this.gzip = true;
                    po = ParamOption.gzip;
                } else if (ParamOption.hhhcar.equals(arg)) {
                    this.flagHHHcar = true;
                    po = ParamOption.hhhcar;
                } else if (ParamOption.nice.equals(arg)) {
                    this.context.mirrorDelay = 500;
                    po = ParamOption.nice;
                } else if (ParamOption.notouch.equals(arg)) {
                    this.context.notouch = true;
                    po = ParamOption.notouch;
                } else if (ParamOption.nocolor.equals(arg)) {
                    this.context.setTerm(false);
                    po = ParamOption.nocolor;
                } else if (ParamOption.color.equals(arg)) {
                    this.context.setTerm(true);
                    po = ParamOption.color;
                } else if (ParamOption.clone.equals(arg)) {
                    this.context.testClonable = false;
                    po = ParamOption.clone;
                } else if (ParamOption.n.equals(arg)) {
                    this.context.fake = true;
                    po = ParamOption.n;
                } else if (ParamOption.cds.equals(arg)) {
                    this.context.cdsLint = true;
                    po = ParamOption.cds;
                } else if (ParamOption.hips3d.equals(arg)) {
                    this.context.isHips3D = true;
                    if (!this.flagTrim) {
                        this.trim = true;
                    }
                    po = ParamOption.hips3d;
                }
                if (po != null) {
                    this.context.param(po.info());
                    continue;
                }
                if (arg.contains("=")) {
                    String[] opts = arg.split("=");
                    try {
                        opts[0] = opts[0].substring(opts[0].indexOf(45) + 1);
                        this.setContextFromOptions(opts[0], opts[1]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.context.error(e.getMessage());
                        return;
                    }
                }
                try {
                    Action a = Action.valueOf(arg.toUpperCase());
                    if (a == Action.FINDER) {
                        a = Action.INDEX;
                    }
                    if (a == Action.PROGEN) {
                        a = Action.DETAILS;
                    }
                    if (a == Action.MIRROR) {
                        this.flagMirror = true;
                    }
                    if (a == Action.UPDATE) {
                        this.flagUpdate = true;
                    }
                    if (a == Action.GUNZIP) {
                        this.flagGunzip = true;
                    }
                    if (a == Action.CHECKCODE) {
                        this.flagCrc = true;
                    }
                    if (a == Action.CHECK) {
                        this.flagCrc = true;
                    }
                    if (a == Action.CHECKFAST) {
                        this.flagCrc = true;
                    }
                    if (a == Action.CHECKDATASUM) {
                        this.flagCrc = true;
                    }
                    if (a == Action.LINT) {
                        this.flagLint = true;
                    }
                    if (a == Action.TMOC) {
                        this.flagTMoc = true;
                    }
                    if (a == Action.TINDEX) {
                        this.flagTIndex = true;
                    }
                    if (a == Action.PROP) {
                        this.flagProp = true;
                    }
                    if (a == Action.VALIDATOR) {
                        this.flagValidator = true;
                    }
                    if (a == Action.CONCAT) {
                        this.flagConcat = true;
                    }
                    if (a == Action.PACK) {
                        this.flagPack = true;
                    }
                    if (a == Action.UNPACK) {
                        this.flagPack = true;
                    }
                    if (a == Action.ABORT) {
                        this.flagAbort = true;
                    }
                    if (a == Action.PAUSE) {
                        this.flagPause = true;
                    }
                    if (a == Action.RESUME) {
                        this.flagResume = true;
                    }
                    this.actions.add(a);
                    continue;
                }
                catch (Exception e) {
                    this.context.error("Unknown action/parameter [" + arg + "] !");
                    return;
                }
            }
            if (this.flagAbort) {
                try {
                    this.context.taskAbort();
                }
                catch (Exception e) {
                    this.context.error(e.getMessage());
                }
                return;
            }
            if (this.flagPause) {
                try {
                    this.context.setTaskPause(true);
                }
                catch (Exception e) {
                    this.context.error(e.getMessage());
                }
                return;
            }
            if (this.flagResume) {
                try {
                    this.context.setTaskPause(false);
                }
                catch (Exception e) {
                    this.context.error(e.getMessage());
                }
                return;
            }
            if (this.flagHHHcar) {
                try {
                    this.generateHHHcar(this.context.getInputPath(), this.context.getFrame());
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    this.context.error("hhh file generation failed for " + this.context.getInputPath());
                    return;
                }
            }
            all = false;
            if (this.actions.size() == 0 && this.context.getInputPath() != null) {
                all = true;
                if (this.flagRGB) {
                    this.actions.add(Action.RGB);
                } else {
                    this.flagMapFits = false;
                    File f = new File(this.context.getInputPath());
                    if (!f.isDirectory() && f.exists()) {
                        try {
                            MyInputStream in = new MyInputStream(new FileInputStream(f));
                            in = in.startRead();
                            this.flagMapFits = (in.getType() & 0x100000000L) != 0L;
                            in.close();
                            this.context.setMap(this.flagMapFits);
                        }
                        catch (Exception in) {
                            // empty catch block
                        }
                    }
                    if (this.flagMapFits) {
                        this.actions.add(Action.MAPTILES);
                    } else {
                        this.actions.add(Action.INDEX);
                        this.actions.add(Action.TILES);
                    }
                    if (!this.context.isColor()) {
                        this.actions.add(Action.PNG);
                    }
                    this.actions.add(Action.CHECKCODE);
                    if (!this.context.isHips3D) {
                        this.actions.add(Action.PACKINDEX);
                    }
                }
            }
            try {
                MyProperties prop;
                if (this.context.hipsId == null && this.context.getOutputPath() != null) {
                    try {
                        String propFile = this.context.getOutputPath() + Util.FS + "properties";
                        prop = new MyProperties();
                        File f = new File(propFile);
                        if (f.exists()) {
                            InputStreamReader in = new InputStreamReader(new BufferedInputStream(new FileInputStream(propFile)));
                            prop.load(in);
                            in.close();
                            String s = prop.getProperty("creator_did");
                            if (s != null) {
                                this.context.setHipsId(s);
                            }
                        }
                    }
                    catch (Exception propFile) {
                        // empty catch block
                    }
                }
                if (!(this.flagConcat || this.flagMirror || this.flagUpdate || this.flagLint || this.flagGunzip || this.flagCrc || this.flagProp || this.flagTMoc || this.flagTIndex || this.flagValidator || this.flagConcat || this.flagPack)) {
                    String s = this.context.checkHipsId(this.context.hipsId, true);
                    this.context.setHipsId(s);
                    break block145;
                }
                if (!this.flagMirror) break block145;
                try (InputStreamReader in1 = null;){
                    prop = new MyProperties();
                    in1 = new InputStreamReader((InputStream)Util.openAnyStream(this.context.getInputPath() + "/properties"), "UTF-8");
                    prop.load(in1);
                    this.context.setHipsId(this.context.getIdFromProp(prop));
                }
            }
            catch (Exception e) {
                this.context.error(e.getMessage());
                return;
            }
        }
        if (!(this.flagMirror || this.flagLint || this.flagCrc || this.flagValidator || (id2 = this.context.getHipsId()) != null && (this.flagUpdate || !id2.startsWith("ivo://UNK.AUT")))) {
            this.context.warning("Missing HiPS IVOID identifier (see " + (Object)((Object)Param.id) + " parameter)" + (id2 == null ? "" : " => in the meantime, assuming " + id2));
        }
        this.context.trim = this.trim;
        if (this.gzip) {
            this.context.gzip = true;
        }
        if (this.flagRGB && !this.flagMode) {
            this.context.setModeMerge(ModeMerge.mergeOverwriteTile);
        }
        if (this.context.isColor() && !this.context.isSetModeTree()) {
            this.context.setModeTree(ModeTree.treeMedian);
        }
        if (!this.flagTileWidth && this.context.isHips3D) {
            this.context.setTileWidth((int)CDSHealpix.pow2(this.context.getTileOrder() - 1));
        }
        if (this.context.getModeOverlay() == ModeOverlay.overlayAdd) {
            this.context.setFading(false);
            this.context.setLive(false);
            try {
                this.context.setPartitioning("false");
            }
            catch (Exception id2) {
                // empty catch block
            }
            this.context.info("Pixel coadd mode=" + (Object)((Object)ModeOverlay.overlayAdd) + " => fading, partitioning, no-mixing and live parameter ignored");
        }
        if (this.context.force) {
            this.context.setIgnoreStamp(true);
            if (all) {
                this.actions.add(0, Action.CLEAN);
            } else {
                for (int i = 0; i < this.actions.size(); ++i) {
                    Action a = this.actions.get(i);
                    if (a == Action.INDEX) {
                        this.actions.add(i, Action.CLEANINDEX);
                        ++i;
                        continue;
                    }
                    if (a == Action.TINDEX) {
                        this.actions.add(i, Action.CLEANTINDEX);
                        ++i;
                        continue;
                    }
                    if (a == Action.COUNT) {
                        this.actions.add(i, Action.CLEANCOUNT);
                        ++i;
                        continue;
                    }
                    if (a == Action.MIRROR) {
                        this.actions.add(i, Action.CLEANALL);
                        ++i;
                        continue;
                    }
                    if (a == Action.DETAILS) {
                        this.actions.add(i, Action.CLEANDETAILS);
                        ++i;
                        continue;
                    }
                    if (a == Action.TILES) {
                        this.actions.add(i, Action.CLEANTILES);
                        ++i;
                        continue;
                    }
                    if (a == Action.MAPTILES) {
                        this.actions.add(i, Action.CLEANTILES);
                        ++i;
                        continue;
                    }
                    if (a == Action.JPEG) {
                        this.actions.add(i, Action.CLEANJPEG);
                        ++i;
                        continue;
                    }
                    if (a == Action.PNG) {
                        this.actions.add(i, Action.CLEANPNG);
                        ++i;
                        continue;
                    }
                    if (a == Action.RGB) {
                        this.actions.add(i, Action.CLEAN);
                        ++i;
                        continue;
                    }
                    if (a == Action.CUBE) {
                        this.actions.add(i, Action.CLEAN);
                        ++i;
                        continue;
                    }
                    if (a != Action.CHECKCODE) continue;
                    this.context.setCheckForce(true);
                }
            }
        }
        if (this.context.fake) {
            this.context.warning("NO RUN MODE (option -n), JUST INFORMATION PRINT !!!");
        }
        for (Action a : this.actions) {
            this.context.param("Action => " + (Object)((Object)a) + ": " + a.info());
            if (this.flagMapFits || a != Action.MAPTILES) continue;
            this.flagMapFits = true;
        }
        for (Param p : this.listParam) {
            if (p.checkActions(this.actions)) continue;
            this.context.info((Object)((Object)p) + " not use for these actions");
        }
        if (!this.flagRGB && !this.flagMapFits) {
            this.setDefaultFrame();
        }
        try {
            this.endOfWork = false;
            MyInputStreamCached.context = this.context;
            if (!(this.context.fake || this.cache == null && this.cacheSize == -1L)) {
                MyInputStreamCached.setCache(this.cache == null ? null : new File(this.cache), this.cacheSize);
            }
            long t = System.currentTimeMillis();
            new Task(this.context, this.actions, true);
            if (this.context.isTaskAborting()) {
                this.context.abort(Context.getTitle("(aborted after " + Util.getTemps((System.currentTimeMillis() - t) * 1000L), '='));
            } else {
                if (this.cacheRemoveOnExit) {
                    MyInputStreamCached.removeCache();
                }
                if (this.context.nbPilot > 0) {
                    this.context.warning("Pilot test limited to " + this.context.nbPilot + " images => partial HiPS");
                }
                this.context.removeListReport();
                this.context.done(Context.getTitle("THE END (done in " + Util.getTemps((System.currentTimeMillis() - t) * 1000L) + ")", '='));
            }
        }
        catch (Exception e) {
            HipsGen hipsGen = this;
            if (hipsGen.context.getVerbose() > 0) {
                e.printStackTrace();
            }
            if (this.cacheRemoveOnExit && this.cache != null) {
                MyInputStreamCached.removeCache();
            }
            this.context.error(e.getMessage());
            this.context.removeListReport();
        }
        finally {
            this.endOfWork = true;
        }
    }

    private void setDefaultFrame() {
        if (this.context.hasFrame()) {
            return;
        }
        String path = this.context.getOutputPath();
        String frame = null;
        try {
            String propFile = path + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                InputStreamReader in = new InputStreamReader(new BufferedInputStream(new FileInputStream(propFile)));
                prop.load(in);
                in.close();
                String s = prop.getProperty("hips_frame");
                if (s == null) {
                    s = prop.getProperty("coordsys");
                }
                frame = s != null && s.length() > 0 ? s : "equatorial";
            } else {
                frame = "equatorial";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setFrameName(frame);
    }

    public void executeAsync(String[] args) {
        new ExecuteAsyncThread(args);
    }

    private static void usage(String launcher) {
        HipsGen.usage(launcher, 0);
    }

    private static void usage(String launcher, int mode) {
        boolean flagHtml;
        boolean bl = flagHtml = (mode & 2) != 0;
        if (flagHtml) {
            System.out.println("<HTML><H1>Hipsgen reference manual<BR><FONT SIZE=-1>related to Hipsgen/Aladin v12.646</FONT></H1>\n<PRE>\n");
        }
        System.out.println("Usage: java -jar " + launcher + " in=dir [otherParams ...ACTIONs...]");
        System.out.println("       java -jar " + launcher + " -param=configfile [...ACTIONs...]\n");
        System.out.println("       java -jar " + launcher + " -h");
        System.out.println("       java -jar " + launcher + " -man [param|ACTION]\n");
        System.out.println("HiPS generator from a set of source images. Provides additional\nHiPS manipulation utilities (duplication, concatenation, checking, etc).");
        System.out.println("The parameters are provided in the configfile, or directly on the command line.");
        System.out.println("Default actions: " + Action.defaultList() + "\n");
        System.out.println("Available options:");
        System.out.println(ParamOption.help());
        System.out.println("Ex: java -jar " + launcher + " in=/MyImg " + (Object)((Object)Param.id) + "=AUT/P/myhips    => Do all the job\n    java -jar " + launcher + " in=/MyImg " + (Object)((Object)Param.id) + "=AUT/P/myhips INDEX TILES\n           => Generate the spatial index and the FITS tiles only\n    java -jar " + launcher + " in=HiPS1 out=HiPS2 CONCAT    => Concatenate HiPS1 to HiPS2\n    java -jar " + launcher + " in=http://remote/hips MIRROR => copy the remote HiPS locally");
        System.out.println("\n(c) Universit\u00e9 de Strasbourg/CNRS 2018-2023 - " + launcher + " based on Aladin " + "v12.646" + " from CDS\n");
        if (flagHtml) {
            System.out.println("</PRE>\n<BR><BR<BR><H2>Available actions</H2>");
            System.out.println(Action.help(launcher, mode));
            System.out.println("<BR><BR<BR><H2>Available parameters</H2>");
            System.out.println(Param.help(launcher, mode));
            System.out.println("</HTML>\n");
        } else {
            System.out.println("Available actions:");
            System.out.println(Action.help(launcher, mode));
            System.out.println("Available parameters:");
            System.out.println(Param.help(launcher, mode));
        }
    }

    private void help(String launcher, String opt) {
        if ((opt = ParamObsolete.getLastSyntax(this.context, opt)) == null) {
            return;
        }
        try {
            Param p = Param.get(opt);
            System.out.println(p.fullHelp(launcher, 0));
            return;
        }
        catch (Exception p) {
            try {
                Action p2 = Action.get(opt);
                System.out.println(p2.fullHelp(launcher, 0));
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private MyProperties setConfigFile(String configfile) throws Exception {
        this.file = new File(configfile);
        return this.parseConfig();
    }

    public static void main(String[] args) {
        HipsGen generator = new HipsGen();
        generator.launcher = "Hipsgen";
        generator.execute(args);
    }

    static {
        SDF.setTimeZone(TimeZone.getDefault());
    }

    class ExecuteAsyncThread
    extends Thread {
        String[] args;

        public ExecuteAsyncThread(String[] args) {
            this.args = args;
            this.start();
        }

        @Override
        public void run() {
            HipsGen.this.execute(this.args);
        }
    }
}

