/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.BuilderLint;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Constante;
import cds.hipsgen.HipsGen;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ModeTree;
import cds.hipsgen.MyInputStreamCached;
import cds.hipsgen.MyInputStreamCachedException;
import cds.hipsgen.Param;
import cds.hipsgen.TransfertFct;
import cds.moc.FMoc;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.tools.Astrodate;
import cds.tools.hpxwcs.Tile2HPX;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JProgressBar;

public class Context {
    private boolean TERM = false;
    public static final String FORCOMPATIBILITY = "#____FOR_COMPATIBILITY_WITH_OLD_HIPS_CLIENTS____";
    private static String[] FITSKEYS = new String[]{"DATE", "MJD_OBS", "UTC", "LST", "DATE-OBS", "MJD-OBS", "MJD-END", "OBS-DATE", "DATE-END", "DATEOBS1", "DATEOBS2", "MIDOBS", "ORDATE", "TIMESYS", "MJDREF", "JD", "EXPTIME", "TEXPTIME", "OBSTIME", "TIME-OBS", "WAVELMIN", "WAVELMAX", "WAVELEN", "TELESCOP", "TELNAME"};
    private static boolean verbose = false;
    protected boolean force = false;
    protected String hipsId = null;
    protected String title;
    protected String inputPath;
    protected String outputPath;
    protected String split;
    protected String hpxFinderPath;
    protected String timeFinderPath;
    protected String imgEtalon;
    protected HeaderFits header = null;
    protected boolean isInputFile = false;
    public int depth = 1;
    protected boolean depthInit = false;
    public double crpix3 = 0.0;
    public double crval3 = 0.0;
    public double cdelt3 = 0.0;
    public String cunit3 = null;
    public double restFreq = Double.NaN;
    protected int[] hdu = null;
    public int bitpixOrig = -1;
    protected double blankOrig = Double.NaN;
    public String blankKey = null;
    public String cunit = null;
    public double defaultRestFreq = Double.NaN;
    protected boolean hasAlternateBlank = false;
    public double bZeroOrig = 0.0;
    public double bScaleOrig = 1.0;
    protected boolean bscaleBzeroOrigSet = false;
    protected boolean flagInitEtalon = true;
    protected double[] cutOrig;
    protected double[] pixelRangeCut;
    protected boolean pixelCutPourcent;
    public double[] pixelGood = null;
    public double[] good = null;
    public int[] borderSize = new int[]{0, 0, 0, 0};
    public Shape globalShape = null;
    public boolean scanFov = false;
    public int dataArea = 0;
    public double maxRatio = 3.0;
    protected boolean fake = false;
    protected boolean cdsLint = false;
    protected int partitioning = Constante.ORIGCELLWIDTH;
    protected int partitioningDepth = Constante.ORIGCELLDEPTH;
    public String skyvalName;
    public double skyvalRef = 0.0;
    public double pourcentMin = -1.0;
    public double pourcentMax = -1.0;
    public String expTimeName;
    protected double coef;
    protected ArrayList<String> defaultFitsKey;
    private ArrayList<String> fitsKeys = null;
    protected int typicalImgWidth = -1;
    protected int mirrorDelay = 0;
    protected boolean notouch = false;
    protected boolean fastCheck = true;
    protected boolean hipslintTileTest = true;
    protected boolean flagFirstPropertiesLoad = true;
    protected int bitpix = -1;
    protected double blank = Double.NaN;
    protected double bzero = 0.0;
    protected double bscale = 1.0;
    protected double dataMin = Double.NaN;
    protected double dataMax = Double.NaN;
    protected double[] cut;
    protected TransfertFct fct = TransfertFct.LINEAR;
    protected boolean cutByRegion;
    protected int byRegionSize = 0x100000;
    public boolean cutByImage;
    private ModeTree modeTree = null;
    protected ModeOverlay modeOverlay = ModeOverlay.getDefault();
    protected ModeMerge modeMerge = null;
    protected int maxNbThread = -1;
    protected String creator = null;
    protected String status = null;
    protected String hipsCheckCode = null;
    protected boolean hipsCheckForce = false;
    protected String redInfo;
    protected String greenInfo;
    protected String blueInfo;
    protected int nbPilot = -1;
    protected boolean flagLupton = false;
    protected double luptonQ = Double.NaN;
    protected double[] luptonM = new double[]{Double.NaN, Double.NaN, Double.NaN};
    protected double[] luptonS = new double[]{Double.NaN, Double.NaN, Double.NaN};
    protected int order = -1;
    public int minOrder = -1;
    private int frame = -1;
    protected Moc mocArea = null;
    protected Moc mocIndex = null;
    protected Moc moc = null;
    protected int mocOrder = -1;
    protected int mocTimeOrder = -1;
    protected long mocMaxSize = -1L;
    protected String mocRuleSize = null;
    protected int nside = 1024;
    protected int tileOrder = -1;
    protected boolean isCube = false;
    protected int orderFreq = -1;
    protected int tileOrderFreq = -1;
    protected CacheFits cacheFits;
    protected Vector<String> keyAddProp = null;
    protected Vector<String> valueAddProp = null;
    protected String target = null;
    protected String resolution = null;
    protected String scriptCommand;
    protected int targetColorMode = 0;
    protected double tmin = Double.NaN;
    protected double tmax = Double.NaN;
    protected ArrayList<String> tileFormat = null;
    protected boolean testClonable = true;
    protected boolean live = false;
    protected long bytes = 0L;
    protected boolean flagGlobalDataSum = false;
    protected int progenMaxWidth = 0;
    protected int progenMaxHeight = 0;
    protected int progenMaxDepth = 0;
    protected int progenMaxOverlays = 1;
    protected long statPixelIn = 0L;
    protected long statPixelOut = 0L;
    protected int statMaxWidth = -1;
    protected int statMaxHeight = -1;
    protected int statMaxDepth = -1;
    protected int statMaxNbyte = -1;
    protected long trimMem = 0L;
    protected boolean trim = Builder.TRIM;
    protected boolean gzip = false;
    public boolean isHips3D = false;
    private String addendum_id = null;
    public static final int CUTMIN = 0;
    public static final int CUTMAX = 1;
    public static final int RANGEMIN = 2;
    public static final int RANGEMAX = 3;
    public static final int PROPBLANK = 4;
    public static final int POURCMIN = 5;
    public static final int POURCMAX = 6;
    private String lastImgEtalon = null;
    private static int nbFiles;
    protected String outputRGB;
    protected ModeTree hierarchyAlgo;
    protected String[] plansRGB = new String[3];
    protected String[] cmsRGB = new String[3];
    protected int lastNorder3 = -2;
    protected Action action = null;
    protected double progress = -1.0;
    protected double progressMax = Double.MAX_VALUE;
    protected JProgressBar progressBar = null;
    protected MyProperties prop = null;
    private boolean isMap = false;
    protected boolean ignoreStamp;
    private boolean taskRunning = false;
    private boolean taskPause = false;
    protected boolean taskAborting = false;
    private static SimpleDateFormat DATEFORMAT;
    private boolean flagNL = false;
    private static final int MAXREMOVEDFILE = 100;
    private HashSet<String> removeList = null;
    public boolean validateOutputDone = false;
    private boolean validateInputDone = false;
    private boolean validateCutDone = false;
    private boolean validateRegion = false;
    private static final Astrocoo COO_GAL;
    private static final Astrocoo COO_EQU;
    private static Astroframe AF_GAL1;
    private static Astroframe AF_ICRS1;
    private static final String INDEX_TEMPLATE = "https://aladin.cds.unistra.fr/hips-templates/hips-landing-page-template.html";
    private static final String INDEX_LOCAL = "/index-template.html";
    private static final int TILE_WIDTH = 0;
    private static final int TILE_DEPTH = 1;
    private transient boolean lock;
    private final Object lockObj = new Object();
    public int[] xy2hpx = null;
    public int[] hpx2xy = null;
    private Tile2HPX tile2Hpx = null;

    public Context() {
        this.setTerm(false);
    }

    public void reset() {
        this.flagFirstPropertiesLoad = true;
        this.bitpix = -1;
        this.partitioning = Constante.ORIGCELLWIDTH;
        this.partitioningDepth = Constante.ORIGCELLDEPTH;
        this.moc = null;
        this.mocIndex = null;
        this.mocArea = null;
        this.modeMerge = ModeMerge.getDefault(this.bitpix);
        this.modeOverlay = ModeOverlay.getDefault();
        this.modeTree = ModeTree.getDefault(this.bitpix);
        this.hasAlternateBlank = false;
        this.blankOrig = Double.NaN;
        this.bscaleBzeroOrigSet = false;
        this.blankKey = null;
        this.cunit = null;
        this.defaultRestFreq = Double.NaN;
        this.outputPath = null;
        this.inputPath = null;
        this.hpxFinderPath = null;
        this.imgEtalon = null;
        this.isMap = false;
        this.prop = null;
        this.pixelGood = null;
        this.good = null;
        this.pixelRangeCut = null;
        this.depth = 1;
        this.isCube = false;
        this.depthInit = false;
        this.cdelt3 = 0.0;
        this.crval3 = 0.0;
        this.crpix3 = 0.0;
        this.cunit3 = null;
        this.tileFormat = null;
        this.outputRGB = null;
        this.greenInfo = null;
        this.blueInfo = null;
        this.redInfo = null;
        this.live = false;
        this.plansRGB = new String[3];
        this.cmsRGB = new String[3];
        this.flagInitEtalon = true;
        this.tile2Hpx = null;
        this.flagLupton = false;
        this.luptonQ = Double.NaN;
        this.luptonM = new double[]{Double.NaN, Double.NaN, Double.NaN};
        this.luptonS = new double[]{Double.NaN, Double.NaN, Double.NaN};
        this.bytes = 0L;
        this.resetCounter();
        this.resetProgressParam();
        this.dataMax = Double.NaN;
        this.dataMin = Double.NaN;
    }

    public void resetCounter() {
        this.statPixelOut = 0L;
        this.trimMem = 0L;
    }

    protected void addPixelIn(long t) {
        this.statPixelIn += t;
    }

    protected void addPixelOut(long t) {
        this.statPixelOut += t;
    }

    protected void addMaxImgSize(int statMaxWidth, int statMaxHeight, int statMaxDepth, int statMaxNbyte) {
        this.statMaxWidth = statMaxWidth;
        this.statMaxHeight = statMaxHeight;
        this.statMaxDepth = statMaxDepth;
        this.statMaxNbyte = statMaxNbyte;
    }

    public void resetProgressParam() {
        this.lastNorder3 = -2;
        this.validateRegion = false;
        this.validateCutDone = false;
        this.validateInputDone = false;
        this.validateOutputDone = false;
        this.live = false;
    }

    public void incrBytes(long bytes) {
        this.bytes += bytes;
    }

    public long getBytes() {
        return this.bytes;
    }

    public static String getFrameName(int frame) {
        return frame == 3 ? "galactic" : (frame == 2 ? "ecliptic" : (frame == -1 ? "?" : "equatorial"));
    }

    public static String getFrameCode(int frame) {
        return frame == 3 ? "G" : (frame == 2 ? "E" : (frame == -1 ? "?" : "C"));
    }

    public static int getFrameVal(String frame) {
        return (frame = frame.toUpperCase()).equals("G") || frame.startsWith("GAL") ? 3 : (frame.equals("E") || frame.startsWith("ECL") ? 2 : 0);
    }

    public static String getCanonicalFrameName(String s) {
        return Context.getFrameName(Context.getFrameVal(s));
    }

    public String getTitle() {
        if (this.title == null) {
            return this.getLabelFromHipsId();
        }
        return this.title;
    }

    public String getHipsId() {
        return this.hipsId;
    }

    public boolean getFading() {
        return this.getModeOverlay().equals((Object)ModeOverlay.overlayFading);
    }

    public int[] getBorderSize() {
        int[] nArray;
        if (this.dataArea == 0) {
            nArray = this.borderSize;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray = nArray2;
            nArray2[3] = 0;
        }
        return nArray;
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }

    public int getOrder() {
        return this.order;
    }

    public int getOrderFreq() {
        return this.orderFreq;
    }

    public boolean hasFrame() {
        return this.frame >= 0;
    }

    public int getFrame() {
        return this.hasFrame() ? this.frame : 0;
    }

    public String getFrameName() {
        return Context.getFrameName(this.getFrame());
    }

    public String getFrameCode() {
        return Context.getFrameCode(this.getFrame());
    }

    public CacheFits getCache() {
        return this.cacheFits;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public boolean getFastCheck() {
        return this.fastCheck;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getSplit() {
        return this.split;
    }

    public String getHpxFinderPath() {
        return this.hpxFinderPath != null ? this.hpxFinderPath : cds.tools.Util.concatDir(this.getOutputPath(), "HpxFinder");
    }

    public String getHpxCounterPath() {
        return cds.tools.Util.concatDir(this.getOutputPath(), "HpxCounter");
    }

    public String getTimeFinderPath() {
        return this.timeFinderPath != null ? this.hpxFinderPath : cds.tools.Util.concatDir(this.getOutputPath(), "TimeFinder");
    }

    public String getImgEtalon() {
        return this.imgEtalon;
    }

    public int getBitpixOrig() {
        return this.bitpixOrig;
    }

    public int getBitpix() {
        return this.isColor() ? this.bitpixOrig : this.bitpix;
    }

    public int getNpix() {
        return this.isColor() || this.bitpix == -1 ? 4 : Math.abs(this.bitpix) / 8;
    }

    public int getNpixOrig() {
        return this.isColor() || this.bitpixOrig == -1 ? 4 : Math.abs(this.bitpixOrig) / 8;
    }

    public double getBScaleOrig() {
        return this.bScaleOrig;
    }

    public double getBZeroOrig() {
        return this.bZeroOrig;
    }

    public double getBZero() {
        return this.bzero;
    }

    public double getBScale() {
        return this.bscale;
    }

    public double getBlank() {
        return this.blank;
    }

    public double getBlankOrig() {
        return this.blankOrig;
    }

    public String getBlankKey() {
        return this.blankKey;
    }

    public String getCUnit() {
        return this.cunit;
    }

    public double getDefaultRestFreq() {
        return this.defaultRestFreq;
    }

    public boolean hasAlternateBlank() {
        return this.hasAlternateBlank;
    }

    public Moc getArea() {
        if (this.mocArea != null) {
            this.mocArea.setSpaceSys(this.getFrameCode());
        }
        return this.mocArea;
    }

    public void setModeMerge() {
        this.setModeMerge(null);
    }

    public void setModeMerge(ModeMerge mode) {
        this.modeMerge = mode;
    }

    public ModeMerge getModeMerge() {
        if (this.modeMerge == null) {
            return ModeMerge.getDefault(this.bitpix);
        }
        return this.modeMerge;
    }

    public boolean isSetModeMerge() {
        return this.modeMerge != null;
    }

    public int[] getProgenMaxCell() {
        int[] nArray;
        if (this.progenMaxWidth <= 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = this.progenMaxWidth;
            nArray2[1] = this.progenMaxHeight;
            nArray2[2] = this.progenMaxDepth;
            nArray = nArray2;
            nArray2[3] = this.progenMaxOverlays;
        }
        return nArray;
    }

    public void setProgenMaxCell(int w, int h, int d, int mo) {
        this.progenMaxWidth = w;
        this.progenMaxHeight = h;
        this.progenMaxDepth = d;
        this.progenMaxOverlays = mo;
    }

    public ModeOverlay getModeOverlay() {
        return this.modeOverlay;
    }

    public double[] getCut() throws Exception {
        return this.cut;
    }

    public double[] getCutOrig() throws Exception {
        return this.cutOrig;
    }

    public String getSkyval() {
        return this.skyvalName;
    }

    public boolean isColor() {
        return this.bitpixOrig == 0;
    }

    public boolean isCube() {
        return this.isCube || this.depth > 1;
    }

    public boolean isCubeFreq() {
        return this.orderFreq != -1 || this.isHiPS3D();
    }

    public boolean isCubeCanal() {
        return this.crpix3 != 0.0 || this.crval3 != 0.0 || this.cdelt3 != 0.0;
    }

    public boolean isInMocTree(Moc m) throws Exception {
        return this.moc == null || this.moc.isIntersecting(m);
    }

    public boolean isInMocTree(int order, long npix) throws Exception {
        return this.moc == null || this.moc.getSpaceMoc().isIntersecting(order, npix);
    }

    public boolean isMocDescendant(Moc m) throws Exception {
        return this.moc == null || this.moc.isIncluding(m);
    }

    public boolean isMocDescendant(int order, long npix) throws Exception {
        return this.moc == null || this.moc.getSpaceMoc().isIncluding(order, npix);
    }

    public int getMaxNbThread() {
        return this.maxNbThread;
    }

    public int getMocOrder() {
        return this.mocOrder;
    }

    public int getTMocOrder() {
        return this.mocTimeOrder;
    }

    public long getMocMaxSize() {
        return this.mocMaxSize;
    }

    public String getMocRuleSize() {
        return this.mocRuleSize;
    }

    public long getMapNside() {
        return this.nside;
    }

    public int getMinOrder() {
        if (this.minOrder == -1) {
            return 0;
        }
        return this.minOrder;
    }

    public int getTileOrder() {
        return this.tileOrder == -1 ? 9 : this.tileOrder;
    }

    public int getTileSide() {
        return (int)CDSHealpix.pow2(this.getTileOrder());
    }

    public int getDepth() {
        return this.depth;
    }

    public int getTileOrderFreq() {
        return this.tileOrderFreq == -1 ? (!this.isHips3D ? 0 : 4) : this.tileOrderFreq;
    }

    public int getTileDepth() {
        return !this.isCube() && !this.isHips3D ? 1 : (int)CDSHealpix.pow2(this.getTileOrderFreq());
    }

    public boolean isCDSLint() {
        return this.cdsLint;
    }

    public boolean isPartitioning() {
        return this.isColor() ? false : this.partitioning > 0 || this.partitioningDepth > 0;
    }

    public int getPartitioning() {
        return this.partitioning;
    }

    public int getPartitioningDepth() {
        return this.partitioningDepth;
    }

    public void setfastCheck(boolean flag) {
        this.fastCheck = flag;
    }

    public void setLive(boolean flag) {
        this.live = flag;
    }

    public void setFlagInputFile(boolean flag) {
        this.isInputFile = flag;
    }

    public void setHeader(HeaderFits h) {
        this.header = h;
    }

    public void setCreator(String s) {
        this.creator = s;
    }

    public void setStatus(String s) {
        this.status = s;
    }

    public void setHipsId(String s) {
        this.hipsId = this.canonHipsId(s);
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void setMaxNbThread(int max) {
        this.maxNbThread = max;
    }

    public void setFading(boolean fading) {
        try {
            this.setMode(!fading ? "overlay_mean" : "overlay_fading");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFading(String s) {
        this.setFading(!s.equalsIgnoreCase("false"));
    }

    public void setMixing(String s) {
        this.setModeOverlay(s.equalsIgnoreCase("false") ? ModeOverlay.overlayNone : ModeOverlay.getDefault());
    }

    public void setPartitioning(String s) throws Exception {
        if (s == null) {
            s = Constante.ORIGCELLWIDTH + "x" + Constante.ORIGCELLWIDTH + "x" + Constante.ORIGCELLDEPTH;
        } else if (s.equals("false")) {
            s = "0x0x0";
        }
        try {
            Tok tok = new Tok(s, "x ,;");
            this.partitioning = Integer.parseInt(tok.nextToken());
            if (tok.hasMoreTokens()) {
                this.partitioningDepth = Integer.parseInt(tok.nextToken());
                if (tok.hasMoreTokens()) {
                    int h = this.partitioningDepth;
                    if (h != this.partitioning) {
                        this.warning("Only square cells allowed for partitioning => assuming " + this.partitioning + "x" + this.partitioning);
                    }
                    this.partitioningDepth = Integer.parseInt(tok.nextToken());
                }
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace > 0) {
                e.printStackTrace();
            }
            throw new Exception("Partitioning param syntax error [" + s + "]");
        }
    }

    public void setMaxRatio(String r) throws Exception {
        this.maxRatio = Double.parseDouble(r);
    }

    public void setBorderSize(String borderSize) throws ParseException {
        this.borderSize = this.parseBorderSize(borderSize);
    }

    public void setBorderSize(int[] borderSize) {
        this.borderSize = borderSize;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setOrderFreq(int orderFreq) {
        this.orderFreq = orderFreq;
    }

    public void setMinOrder(int minOrder) {
        this.minOrder = minOrder;
    }

    public void setMocOrder(int mocOrder) {
        this.mocOrder = mocOrder;
    }

    public void setMocOrder(String s) {
        boolean inf;
        int slash = s.indexOf(47);
        int end = s.length();
        int min = s.indexOf(60);
        boolean bl = inf = min >= 0;
        if (min == -1) {
            min = end;
        }
        if (slash >= 0) {
            try {
                this.mocOrder = Integer.parseInt(s.substring(0, slash));
            }
            catch (Exception e) {
                this.mocOrder = -1;
            }
            this.mocTimeOrder = Integer.parseInt(s.substring(slash + 1, min));
            slash = min;
        } else if (!inf) {
            this.mocOrder = Integer.parseInt(s.substring(0, min).trim());
        }
        if (min < end) {
            int point = s.indexOf(58);
            if (point == -1) {
                point = end;
            }
            while (s.charAt(min) == ' ' && min < end) {
                ++min;
            }
            String s1 = s.substring(min, point);
            double fact = 1.0;
            int unit = s1.indexOf("KB");
            if (unit > 0) {
                fact = 1024.0;
            } else {
                unit = s1.indexOf("MB");
                if (unit > 0) {
                    fact = 1048576.0;
                } else {
                    unit = s1.indexOf("GB");
                    if (unit > 0) {
                        fact = 1.073741824E9;
                    }
                }
            }
            if (unit > 0) {
                this.mocMaxSize = (long)(Double.parseDouble(s1.substring(1, unit).trim()) * fact);
            }
            if (point < end) {
                this.mocRuleSize = s.substring(point + 1, end);
            }
        }
    }

    public void setMapNside(int nside) throws Exception {
        this.checkPow2(nside);
        this.nside = nside;
    }

    public void setTileOrder(int tileOrder) throws Exception {
        this.tileOrder = tileOrder;
    }

    public void setTileWidth(int width) {
        this.tileOrder = (int)CDSHealpix.log2(width);
    }

    public void setTileDepth(int tileDepth) throws Exception {
        this.checkPow2(tileDepth);
        this.tileOrderFreq = (int)CDSHealpix.log2(tileDepth);
    }

    private void checkPow2(int n) throws Exception {
        if ((long)n != CDSHealpix.pow2((int)CDSHealpix.log2(n))) {
            throw new Exception("Must be power of 2 [" + n + "]");
        }
    }

    public void setIsCube(boolean flag) {
        this.isCube = flag;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void setFrameName(String frame) {
        this.frame = Context.getFrameVal(frame);
    }

    public void setSkyValName(String s) {
        this.skyvalName = s;
        if (s == null) {
            return;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("auto")) {
            this.skyvalName = "auto";
            this.info("Skyval automatical adjustement activated...");
        } else {
            this.info("Skyval adjustement based on the FITS keyword [" + s + "]");
        }
    }

    public int[] getHDU() {
        return this.hdu;
    }

    public void setHDU(String s) throws Exception {
        this.hdu = Context.parseHDU(s);
    }

    public void setShape(String s) throws Exception {
        if (cds.tools.Util.indexOfIgnoreCase(s, "circle") >= 0 || cds.tools.Util.indexOfIgnoreCase(s, "ellipse") >= 0) {
            this.dataArea = 1;
            this.info("Shape fov autodetection => ellipse");
        } else if (cds.tools.Util.indexOfIgnoreCase(s, "square") >= 0 || cds.tools.Util.indexOfIgnoreCase(s, "rectangle") >= 0 || cds.tools.Util.indexOfIgnoreCase(s, "rectangular") >= 0) {
            this.dataArea = 2;
            this.info("Shape fov autodetection => rectangular");
        } else {
            this.dataArea = 0;
            throw new Exception("Unknown observation shape [" + s + "] (=> ellipse|rectangle)");
        }
    }

    public void setAddendum(String addId) {
        this.addendum_id = addId;
    }

    public void addAddendum(String addId) throws Exception {
        if (addId.equals(this.hipsId)) {
            throw new Exception("Addendum_id identical to the original HiPS ID [" + this.hipsId + "]");
        }
        if (this.addendum_id == null) {
            this.addendum_id = addId;
        } else {
            Tok tok = new Tok(this.addendum_id, "\t");
            while (tok.hasMoreTokens()) {
                if (tok.nextToken().equals(addId)) {
                    this.warning("Addendum_id duplicated [" + this.addendum_id + "] => assuming temporary reused ID");
                    continue;
                }
                this.addendum_id = this.addendum_id + "\t" + addId;
            }
        }
    }

    public String getRgbOutput() {
        return this.getOutputPath();
    }

    public ModeTree getHierarchyAlgo() {
        return this.getModeTree();
    }

    public int getRgbFormat() {
        return this.targetColorMode;
    }

    public void setRgbFormat(int targetColorMode) {
        this.targetColorMode = targetColorMode;
    }

    public void setFov(String r) throws Exception {
        boolean bl = this.scanFov = r.equalsIgnoreCase("true") || (this.globalShape = Context.createFov(r)) != null;
        if (this.scanFov) {
            this.info("FoV files associated to the original images");
        }
    }

    public String getIdFromProp(MyProperties prop) {
        if (prop == null) {
            return null;
        }
        String s = prop.getProperty("creator_did");
        if (s != null) {
            return s;
        }
        s = prop.getProperty("publisher_did");
        if (s != null) {
            return s;
        }
        s = prop.getProperty("obs_id");
        if (s == null) {
            return null;
        }
        String creator = prop.getProperty("creator_id");
        if (creator == null) {
            creator = prop.getProperty("publisher_id");
        }
        if (creator == null) {
            creator = "ivo://UNK.AUT";
        }
        return creator + "?" + s;
    }

    public String canonHipsId(String s) {
        try {
            s = this.checkHipsId(s, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public String checkHipsId(String s) throws Exception {
        return this.checkHipsId(s, true);
    }

    public String checkHipsId(String s, boolean withException) throws Exception {
        String id;
        boolean bug;
        StringBuilder a;
        String auth;
        boolean flagQuestion = false;
        if (s == null && this.prop != null) {
            s = this.getIdFromProp(this.prop);
        }
        if (s == null || s.trim().length() == 0) {
            verbose = false;
            String string = s = this.getTitle() != null ? this.getTitle() : "";
            if (withException) {
                throw new Exception("Missing HiPS id (ex: " + (Object)((Object)Param.id) + "=CDS/P/DSS2/color)");
            }
        }
        if (s.startsWith("ivo://")) {
            s = s.substring(6);
        }
        int offset = s.indexOf(47);
        int offset1 = s.indexOf(63);
        if (offset >= 0 || offset1 >= 0) {
            if (offset == -1) {
                offset = s.length();
            }
            if (offset1 == -1) {
                offset1 = s.length();
            }
            if (offset1 < offset) {
                offset = offset1;
                flagQuestion = true;
            } else {
                flagQuestion = false;
            }
        }
        if (offset == -1) {
            auth = "UNK.AUTH";
            if (withException) {
                throw new Exception("ID error => missing authority (ex: " + (Object)((Object)Param.id) + "=CDS/P/DSS2/color)");
            }
        } else {
            auth = s.substring(0, offset);
            s = s.substring(offset + 1);
            if (auth.length() < 3) {
                while (auth.length() < 3) {
                    auth = auth + "_";
                }
                if (withException) {
                    throw new Exception("ID error => at least 3 authority characters are required (ex: " + (Object)((Object)Param.id) + "=CDS/P/DSS2/color)");
                }
            }
            a = new StringBuilder();
            bug = false;
            for (int n : auth.toCharArray()) {
                if (!Character.isLetterOrDigit((char)n) && n != 46 && n != 45) {
                    n = 46;
                    bug = true;
                }
                a.append((char)n);
            }
            if (bug) {
                auth = a.toString();
                if (withException) {
                    throw new Exception("ID error => some characters are not allowed (ex: " + (Object)((Object)Param.id) + "=CDS/P/DSS2/color)");
                }
            }
        }
        if ((id = s.trim()).startsWith("P/") || id.startsWith("C/")) {
            id = id.substring(2);
        }
        if (id.length() == 0) {
            id = "ID" + System.currentTimeMillis() / 1000L;
            if (withException) {
                throw new Exception("ID error: suffix Id missing (ex: " + (Object)((Object)Param.id) + "=CDS/P/DSS2/color)");
            }
        } else {
            a = new StringBuilder();
            bug = false;
            for (char c : id.toCharArray()) {
                if (Character.isSpaceChar(c)) {
                    c = '-';
                    bug = true;
                }
                a.append(c);
            }
            if (bug) {
                id = a.toString();
                if (withException) {
                    throw new Exception("ID suffix error: some characters are not allowed (ex: " + (Object)((Object)Param.id) + "==CDS/P/DSS2/color)");
                }
            }
        }
        String mode = this.isCube() ? "C" : "P";
        return "ivo://" + auth + (flagQuestion ? "?" : "/") + mode + "/" + id;
    }

    public String getLabelFromHipsId() {
        return this.getLabelFromHipsId(this.hipsId);
    }

    public String getLabelFromHipsId(String hipsId) {
        String s1;
        if (hipsId == null) {
            return null;
        }
        String s = hipsId;
        if (s.startsWith("ivo://")) {
            s = s.substring(6);
        }
        int offset = s.indexOf(47);
        int offset1 = s.indexOf(63);
        if (offset == -1 && offset1 == -1) {
            return null;
        }
        if (offset == -1) {
            offset = s.length();
        }
        if (offset1 == -1) {
            offset1 = s.length();
        }
        if ((s1 = s.substring((offset = Math.min(offset1, offset)) + 1)).startsWith("P/")) {
            s1 = s1.substring(2);
        }
        s1 = s1.replace('/', ' ');
        return s1;
    }

    public static Shape createFov(String s) throws Exception {
        Tok tok = new Tok(s, " ,;\t");
        if (tok.countTokens() == 3) {
            double x = Double.parseDouble(tok.nextToken());
            double y = Double.parseDouble(tok.nextToken());
            double r = Double.parseDouble(tok.nextToken());
            return new Ellipse2D.Double(x - r, y - r, r * 2.0, r * 2.0);
        }
        Polygon p = new Polygon();
        while (tok.hasMoreTokens()) {
            int x = (int)(Double.parseDouble(tok.nextToken()) + 0.5);
            int y = (int)(Double.parseDouble(tok.nextToken()) + 0.5);
            p.addPoint(x, y);
        }
        return p;
    }

    protected void setTileFormat(String s) {
        Tok tok = new Tok(s, ", ;");
        while (tok.hasMoreTokens()) {
            this.addTileFormat(tok.nextToken());
        }
    }

    protected void addTileFormat(String s) {
        if (s.equalsIgnoreCase("jpeg")) {
            s = "jpg";
        }
        if (this.tileFormat == null) {
            this.tileFormat = new ArrayList();
        }
        this.tileFormat.add(s.length() == 0 ? s : "." + s.toLowerCase());
    }

    protected String getTileFormat() {
        return this.getTileFormat(this.tileFormat);
    }

    protected String getTileFormat(ArrayList<String> tileFormat) {
        if (tileFormat == null) {
            return null;
        }
        StringBuilder format = new StringBuilder();
        for (String s : tileFormat) {
            if (s.length() == 0) continue;
            if (format.length() > 0) {
                format.append(' ');
            }
            if (s.equals(".jpg")) {
                format.append("jpeg");
                continue;
            }
            format.append(s.substring(1));
        }
        return format.toString();
    }

    public static int[] parseHDU(String s) throws Exception {
        int[] hdu = null;
        if (s.length() == 0 || s.equals("0")) {
            return hdu;
        }
        if (s.equalsIgnoreCase("all")) {
            return new int[]{-1};
        }
        StringTokenizer st = new StringTokenizer(s, " ,;-", true);
        ArrayList<Integer> a = new ArrayList<Integer>();
        boolean flagRange = false;
        int previousN = -1;
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.equals("-")) {
                flagRange = true;
                continue;
            }
            if (!Character.isDigit(s1.charAt(0))) continue;
            int n = Integer.parseInt(s1);
            if (flagRange) {
                for (int i = previousN + 1; i <= n && i < 1000; ++i) {
                    a.add(i);
                }
                flagRange = false;
            } else {
                a.add(n);
            }
            previousN = n;
        }
        hdu = new int[a.size()];
        for (int i = 0; i < hdu.length; ++i) {
            hdu[i] = (Integer)a.get(i);
        }
        return hdu;
    }

    public void setInputPath(String path) {
        this.inputPath = path;
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    public void setSplit(String split) {
        this.split = split;
    }

    public void setImgEtalon(String filename) throws Exception {
        this.imgEtalon = filename;
        this.initFromImgEtalon();
    }

    public void setIndexFitskey(String list) {
        Tok st = new Tok(list, " ,;");
        this.fitsKeys = new ArrayList(st.countTokens());
        while (st.hasMoreTokens()) {
            this.fitsKeys.add(st.nextToken());
        }
    }

    public void setMode(String mode1) throws Exception {
        boolean setModeOverlay = false;
        boolean setModeMerge = false;
        boolean setModeTree = false;
        Tok tok = new Tok(mode1, " ,;");
        while (tok.hasMoreTokens()) {
            String mode = tok.nextToken();
            String m1 = ModeOverlay.contains(mode = this.modeOverlayMeanMax(mode));
            if (m1 != null) {
                this.setModeOverlay(ModeOverlay.valueOf(m1));
                setModeOverlay = true;
            }
            if ((m1 = ModeMerge.contains(mode)) != null) {
                this.setModeMerge(ModeMerge.valueOf(m1));
                setModeMerge = true;
            }
            if ((m1 = ModeTree.contains(mode)) != null) {
                this.setModeTree(ModeTree.valueOf(m1));
                setModeTree = true;
            }
            if (setModeOverlay || setModeMerge || setModeTree) continue;
            throw new Exception("Unmatching mode [" + mode1 + "]");
        }
    }

    private String modeOverlayMeanMax(String mode) {
        String key = "mean";
        int n = key.length();
        int offset = mode.toLowerCase().indexOf(key);
        if (offset == -1 || offset == mode.length() - n) {
            return mode;
        }
        try {
            int max;
            ModeOverlay.OVERLAYMEAN_MAX = max = Integer.parseInt(mode.substring(offset + n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.info("Max progenitors used by pixel is => " + ModeOverlay.OVERLAYMEAN_MAX);
        return ModeOverlay.overlayMeanMax.toString();
    }

    public void setModeOverlay(ModeOverlay modeOverlay) {
        this.modeOverlay = modeOverlay;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setBScaleOrig(double x) {
        this.bScaleOrig = x;
        this.bscaleBzeroOrigSet = true;
    }

    public void setBZeroOrig(double x) {
        this.bZeroOrig = x;
        this.bscaleBzeroOrigSet = true;
    }

    public void setBitpixOrig(int bitpixO) {
        this.bitpixOrig = bitpixO;
        if (this.bitpix == -1) {
            this.bitpix = bitpixO;
        }
    }

    public void setBitpix(int bitpix) {
        this.bitpix = bitpix;
    }

    public void setBlankOrig(double x) {
        this.blankOrig = x;
        this.hasAlternateBlank = true;
    }

    public void setBlankOrig(String key) {
        this.blankKey = key;
        this.hasAlternateBlank = false;
    }

    public void setCunit(String unit) {
        this.cunit = unit;
    }

    public void setDefaultRestFreq(double defaultRestFreq) {
        this.defaultRestFreq = defaultRestFreq;
    }

    public void setColor(String colorMode) {
        if (colorMode.equalsIgnoreCase("false")) {
            return;
        }
        this.bitpixOrig = 0;
        this.targetColorMode = colorMode.equalsIgnoreCase("png") ? 0 : 1;
    }

    public void setCut(double[] cut) {
        this.cut = cut;
    }

    public void setPixelCut(String scut) throws Exception {
        if (this.pixelRangeCut == null) {
            this.pixelRangeCut = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        int i = 0;
        int ind = 0;
        boolean pixelCutPourcent = false;
        if (scut.indexOf(37) >= 0) {
            scut = scut.replace('%', ' ');
            pixelCutPourcent = true;
            ind = 5;
        }
        Tok st = new Tok(scut, " ,;");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                this.pixelRangeCut[ind] = Double.parseDouble(s);
                if (pixelCutPourcent) {
                    int n = ind;
                    this.pixelRangeCut[n] = this.pixelRangeCut[n] / 100.0;
                }
                ++ind;
                ++i;
            }
            catch (Exception e) {
                if (s.equalsIgnoreCase("byImage")) {
                    this.cutByImage = true;
                    continue;
                }
                if (s.toLowerCase().indexOf("byregion") >= 0) {
                    this.cutByRegion = true;
                    int j = s.indexOf(47);
                    if (j <= 0) continue;
                    try {
                        long x = cds.tools.Util.getUnitDiskByte(s.substring(j + 1));
                        this.byRegionSize = (int)x;
                    }
                    catch (Exception e1) {
                        this.warning("byRegion evaluation size error (" + e1.getMessage() + ") => assuming default value");
                    }
                    continue;
                }
                this.setTransfertFct(s);
            }
        }
        if (i == 1 || i > 2) {
            throw new Exception("pixelCut parameter error");
        }
    }

    public void setPilot(int nbPilot) {
        this.nbPilot = nbPilot;
    }

    public void setCheckCode(String hipscrc) {
        this.hipsCheckCode = hipscrc;
    }

    public String getCheckCode() {
        return this.hipsCheckCode;
    }

    public String getCheckCodeFromProp() {
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.prop == null) {
            return null;
        }
        String s = this.prop.getProperty("hips_check_code");
        return s;
    }

    public void setCheckForce(boolean flag) {
        this.hipsCheckForce = flag;
    }

    public boolean getCheckForce() {
        return this.hipsCheckForce;
    }

    public void setPixelGood(String sGood) throws Exception {
        StringTokenizer st = new StringTokenizer(sGood, " ");
        if (this.pixelGood == null) {
            this.pixelGood = new double[]{Double.NaN, Double.NaN};
        }
        try {
            this.pixelGood[0] = Double.parseDouble(st.nextToken());
            this.pixelGood[1] = st.hasMoreTokens() ? Double.parseDouble(st.nextToken()) : this.pixelGood[0];
        }
        catch (Exception e) {
            throw new Exception("pixelGood parameter error");
        }
    }

    public void setHistoPercent(String sHist) throws Exception {
        Tok st = new Tok(sHist, " ,;");
        int n = st.countTokens();
        try {
            if (n > 2) {
                throw new Exception();
            }
            this.pourcentMin = Double.parseDouble(st.nextToken()) / 100.0;
            if (n == 1) {
                this.pourcentMin = (1.0 - this.pourcentMin) / 2.0;
                this.pourcentMax = 1.0 - this.pourcentMin;
            } else {
                this.pourcentMax = Double.parseDouble(st.nextToken()) / 100.0;
            }
        }
        catch (Exception e) {
            throw new Exception("histoPercent parameter error");
        }
    }

    public double[] getPixelRangeCut() throws Exception {
        return this.pixelRangeCut;
    }

    public static boolean hasCut(double[] pixelRangeCut) {
        return pixelRangeCut != null && pixelRangeCut[0] < pixelRangeCut[1];
    }

    public static boolean hasRange(double[] pixelRangeCut) {
        return pixelRangeCut != null && !Double.isNaN(pixelRangeCut[2]) && pixelRangeCut[2] < pixelRangeCut[3];
    }

    public static boolean hasPourcentCut(double[] pixelRangeCut) {
        return pixelRangeCut != null && !Double.isNaN(pixelRangeCut[5]) && !Double.isNaN(pixelRangeCut[6]) && pixelRangeCut[5] < pixelRangeCut[6];
    }

    public TransfertFct getFct() throws Exception {
        return this.fct;
    }

    public String getTransfertFct() throws Exception {
        return this.getFct().toString().toLowerCase();
    }

    public void setTransfertFct(String txt) {
        this.fct = TransfertFct.valueOf(txt.toUpperCase());
    }

    public String getTileExt() {
        return this.isColor() ? Constante.TILE_EXTENSION[this.targetColorMode] : ".fits";
    }

    public void setModeTree() {
        this.setModeTree(null);
    }

    public void setModeTree(ModeTree mode) {
        this.modeTree = mode;
    }

    public ModeTree getModeTree() {
        if (this.modeTree == null) {
            return ModeTree.getDefault(this.bitpix);
        }
        return this.modeTree;
    }

    public boolean isSetModeTree() {
        return this.modeTree != null;
    }

    public void setDataRange(String scut) throws Exception {
        StringTokenizer st = new StringTokenizer(scut, " ");
        int i = 2;
        if (this.pixelRangeCut == null) {
            this.pixelRangeCut = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        while (st.hasMoreTokens() && i < 4) {
            String s = st.nextToken();
            this.pixelRangeCut[i] = Double.parseDouble(s);
            ++i;
        }
        if (i < 4) {
            throw new Exception("Missing dataCut parameter");
        }
    }

    public void setCutOrig(double[] cutOrig) {
        this.cutOrig = cutOrig;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.depthInit = true;
        if (depth > 1) {
            this.setIsCube(true);
        }
    }

    protected void initFromImgEtalon() throws Exception {
        if (this.lastImgEtalon != null && this.lastImgEtalon.equals(this.imgEtalon)) {
            return;
        }
        Fits fitsfile = new Fits();
        String path = this.imgEtalon;
        int code = fitsfile.loadHeaderFITS(path, true);
        if ((code & 0x40) != 0) {
            this.info("Lutpon BOFFSET/BSOFTEN detected => default output bitpix -32");
            this.setBitpixOrig(-32);
        } else {
            this.setBitpixOrig(fitsfile.bitpix);
            if (!this.isColor()) {
                this.setBZeroOrig(fitsfile.bzero);
                this.setBScaleOrig(fitsfile.bscale);
                if (!Double.isNaN(fitsfile.blank)) {
                    this.setBlankOrig(fitsfile.blank);
                }
            }
        }
        this.typicalImgWidth = Math.max(fitsfile.width, fitsfile.height);
        try {
            if (fitsfile.headerFits.getIntFromHeader("NAXIS") > 2) {
                this.setDepth(fitsfile.headerFits.getIntFromHeader("NAXIS3"));
                try {
                    this.crpix3 = fitsfile.headerFits.getDoubleFromHeader("CRPIX3");
                    this.crval3 = fitsfile.headerFits.getDoubleFromHeader("CRVAL3");
                    this.cdelt3 = fitsfile.headerFits.getDoubleFromHeader("CDELT3");
                    this.cunit3 = fitsfile.headerFits.getStringFromHeader("CUNIT3");
                }
                catch (Exception e) {
                    this.cdelt3 = 0.0;
                    this.crval3 = 0.0;
                    this.crpix3 = 0.0;
                    this.cunit3 = null;
                }
            }
            try {
                CalibFreq cf = new CalibFreq(fitsfile.headerFits, this.cunit, this.defaultRestFreq, true);
                if (cf != null) {
                    this.restFreq = cf.getRestFreq();
                }
            }
            catch (Exception cf) {}
        }
        catch (Exception e) {
            this.setDepth(1);
        }
        try {
            this.initCut(fitsfile);
        }
        catch (Exception e) {
            Aladin.trace(4, "initFromImgEtalon :" + e.getMessage());
        }
        if (this.target == null) {
            Coord c = fitsfile.getCalib().getImgCenter();
            double r = Math.max(fitsfile.getCalib().getImgHeight(), fitsfile.getCalib().getImgWidth());
            String s = cds.tools.Util.round(c.al, 5) + " " + (c.del >= 0.0 ? "+" : "") + cds.tools.Util.round(c.del, 5) + " " + cds.tools.Util.round(r, 5);
            this.setTarget(s);
        }
        double[] res = fitsfile.getCalib().GetResol();
        this.resolution = cds.tools.Util.myRound(Math.min(res[0], res[1]));
        this.lastImgEtalon = this.imgEtalon;
    }

    protected ArrayList<String> scanDefaultFitsKey(HeaderFits h) {
        ArrayList<String> a = new ArrayList<String>();
        Enumeration<String> e = h.getKeys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (cds.tools.Util.indexInArrayOf(s, FITSKEYS) < 0) continue;
            a.add(s);
        }
        return a.size() > 0 ? a : null;
    }

    protected void initCut(Fits file) throws Exception {
        int w = file.width;
        int h = file.height;
        int d = file.depth;
        int x = 0;
        int y = 0;
        int z = 0;
        if (w > 1024) {
            w = 1024;
            x = file.width / 2 - 512;
        }
        if (h > 1024) {
            h = 1024;
            y = file.height / 2 - 512;
        }
        if (d > 1) {
            d = 1;
            z = file.depth / 2 - 0;
        }
        if (file.getFilename() != null) {
            file.loadFITS(file.getFilename(), file.getExt(), x, y, z, w, h, d);
        }
        if (this.flagInitEtalon) {
            double rangeData;
            double[] cutOrig;
            double centerRange;
            double pourcentMin = -1.0;
            double pourcentMax = -1.0;
            if (Context.hasPourcentCut(this.pixelRangeCut)) {
                pourcentMin = this.pixelRangeCut[5];
                pourcentMax = this.pixelRangeCut[6];
            }
            if (!Double.isInfinite((centerRange = (cutOrig = file.findAutocutRange(pourcentMin, pourcentMax))[2] / 2.0 + cutOrig[3] / 2.0) - (rangeData = cutOrig[3] - cutOrig[2]))) {
                cutOrig[2] = centerRange - rangeData;
            }
            if (!Double.isInfinite(centerRange + rangeData)) {
                cutOrig[3] = centerRange + rangeData;
            }
            double max = Fits.getMax(file.bitpix);
            double min = Fits.getMin(file.bitpix);
            if (cutOrig[2] < min) {
                cutOrig[2] = min;
            }
            if (cutOrig[3] > max) {
                cutOrig[3] = max;
            }
            this.setCutOrig(cutOrig);
            if (this.skyvalName != null) {
                try {
                    this.skyvalRef = file.headerFits.getDoubleFromHeader("SKYLEVEL");
                }
                catch (Exception e) {
                    this.warning("Reference image has no SKYLEVEL keyword : assuming zero");
                }
            }
        }
    }

    public double getSkyvalRef() {
        return this.skyvalRef;
    }

    boolean findImgEtalon(String rootPath) {
        if (this.isInputFile) {
            try {
                this.setImgEtalon(rootPath);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        nbFiles = 0;
        return this.findImgEtalon1(rootPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean findImgEtalon1(String rootPath) {
        File main = new File(rootPath);
        String[] list = main.list();
        if (list == null) {
            return false;
        }
        String path = rootPath;
        ArrayList<String> dir = new ArrayList<String>();
        for (int f = 0; f < list.length; ++f) {
            if (!rootPath.endsWith(cds.tools.Util.FS)) {
                rootPath = rootPath + cds.tools.Util.FS;
            }
            if (new File(path = rootPath + list[f]).isDirectory()) {
                if (list[f].equals(Constante.SURVEY)) continue;
                dir.add(path);
                continue;
            }
            if (++nbFiles > 100) {
                Aladin.trace(4, "Context.findImgEtalon: too many files - ignored this step...");
                return false;
            }
            MyInputStream in = null;
            try {
                in = new MyInputStream(new FileInputStream(path)).startRead();
                if ((in.getType() & 1L) != 1L && !in.hasCommentCalib() || (in.getType() & 0x3C001000000000L) != 0L) continue;
                Aladin.trace(4, "Context.findImgEtalon: " + path + "...");
                this.setImgEtalon(path);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                Aladin.trace(4, "findImgEtalon : " + e.getMessage());
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (String s : dir) {
            if (!this.findImgEtalon1(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String justFindImgEtalon(String rootPath) throws MyInputStreamCachedException {
        MyInputStream in = null;
        if (this.isInputFile) {
            return rootPath;
        }
        File main = new File(rootPath);
        String[] list = main.list();
        if (list == null) {
            return null;
        }
        String path = rootPath;
        ArrayList<String> dir = new ArrayList<String>();
        for (int f = 0; f < list.length; ++f) {
            String string;
            if (!rootPath.endsWith(cds.tools.Util.FS)) {
                rootPath = rootPath + cds.tools.Util.FS;
            }
            if (new File(path = rootPath + list[f]).isDirectory()) {
                if (list[f].equals(Constante.SURVEY)) continue;
                dir.add(path);
                continue;
            }
            try {
                if (path.endsWith(".hhh")) {
                    String string2 = path;
                    return string2;
                }
                in = new MyInputStreamCached(path, this.getHDU()).startRead();
                long type = in.getType();
                if ((type & 1L) != 1L && !in.hasCommentCalib() || (in.getType() & 0x3C001000000000L) != 0L) continue;
                string = path + (this.hdu == null || this.hdu.length > 0 && this.hdu[0] == -1 ? "" : "[" + this.hdu[0] + "]");
            }
            catch (MyInputStreamCachedException e) {
                this.taskAbort();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                Aladin.trace(4, "justFindImgEtalon : " + e.getMessage());
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string;
        }
        for (String s : dir) {
            String rep = this.justFindImgEtalon(s);
            if (rep == null) continue;
            return rep;
        }
        return null;
    }

    public void setRgbInput(String path, int c) {
        this.plansRGB[c] = path;
    }

    public void setRgbCmParam(String cmParam, int c) {
        this.cmsRGB[c] = cmParam;
    }

    public void setRgbLuptonQ(String s) throws Exception {
        this.setRgbLuptonParam(s, 0);
    }

    public void setRgbLuptonM(String s) throws Exception {
        this.setRgbLuptonParam(s, 1);
    }

    public void setRgbLuptonS(String s) throws Exception {
        this.setRgbLuptonParam(s, 2);
    }

    private void setRgbLuptonParam(String s, int param) throws Exception {
        this.flagLupton = true;
        try {
            if (param == 0) {
                try {
                    this.luptonQ = Double.parseDouble(s);
                }
                catch (Exception e) {
                    this.luptonQ = Double.NaN;
                }
                return;
            }
            double[] lup = param == 1 ? this.luptonM : this.luptonS;
            Tok tok = new Tok(s, "/");
            double lastVal = Double.NaN;
            for (int i = 0; i < 3; ++i) {
                String s1;
                lup[i] = tok.hasMoreTokens() ? ((s1 = tok.nextToken()).equals("auto") || s1.length() == 0 ? Double.NaN : Double.parseDouble(s1)) : lastVal;
                lastVal = lup[i];
            }
        }
        catch (Exception e) {
            throw new Exception("lupton param error [" + s + "] (ex: luptonQ=20 luptonS=auto luptonM=0.02/0.03/0.01)");
        }
    }

    public void setSkyval(String fieldName) throws Exception {
        boolean flagNum = false;
        fieldName = fieldName.replace('%', ' ');
        try {
            Tok st = new Tok(fieldName, " ,;");
            Double.parseDouble(st.nextToken());
            flagNum = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (flagNum) {
            this.skyvalName = "auto";
            this.setHistoPercent(fieldName);
        } else {
            this.skyvalName = fieldName.toUpperCase();
        }
    }

    public void setSkyValues(String s) throws Exception {
        Tok tok = new Tok(s);
        this.cutOrig = new double[4];
        int i = 0;
        while (tok.hasMoreTokens()) {
            try {
                this.cutOrig[i] = Double.parseDouble(tok.nextToken());
            }
            catch (Exception e) {
                throw new Exception("hips_skyval_values parsing error [" + s + "]");
            }
            ++i;
        }
        this.flagInitEtalon = false;
    }

    public void setExpTime(String expTime) {
        this.expTimeName = expTime.toUpperCase();
    }

    public void setTmin(double tmin) {
        this.tmin = tmin;
    }

    public void setTmax(double tmax) {
        this.tmax = tmax;
    }

    public void setCache(CacheFits cache) {
        this.cacheFits = cache;
        if (cache != null) {
            cache.setContext(this);
        }
    }

    protected void setMocArea(String s) throws Exception {
        if (s.length() == 0) {
            return;
        }
        this.mocArea = Moc.createMoc(s);
        if (this.mocArea.isEmpty()) {
            throw new Exception("MOC sky area syntax error");
        }
    }

    public void setMocArea(Moc area) throws Exception {
        this.mocArea = area;
    }

    public double getSkyArea() {
        if (this.moc == null) {
            return 1.0;
        }
        return this.moc.getCoverage();
    }

    public ArrayList<String> getFitsKeys() {
        if (this.fitsKeys != null) {
            return this.fitsKeys;
        }
        return this.defaultFitsKey;
    }

    public double getIndexSkyArea() {
        if (this.mocIndex == null) {
            return 1.0;
        }
        return this.mocIndex.getCoverage();
    }

    public void initParameters() throws Exception {
        if (!this.isColor()) {
            boolean flagBothFloat;
            this.bitpix = this.getBitpix();
            this.bitpixOrig = this.getBitpixOrig();
            this.cutOrig = this.getCutOrig();
            this.blankOrig = this.getBlankOrig();
            this.blank = this.getDefaultBlankFromBitpix(this.bitpix);
            this.cut = new double[7];
            if (this.cutOrig == null) {
                this.cutOrig = new double[7];
            }
            System.arraycopy(this.cutOrig, 0, this.cut, 0, this.cutOrig.length);
            if (this.cutOrig[2] >= this.cutOrig[3]) {
                double d = this.bitpixOrig == -64 ? -1.7976931348623157E308 : (this.bitpixOrig == -32 ? -3.4028234663852886E38 : (this.bitpixOrig == 64 ? -9.223372036854776E18 : (this.bitpixOrig == 32 ? -2.147483647E9 : (this.cutOrig[2] = this.bitpixOrig == 16 ? -32767.0 : 1.0))));
                this.cutOrig[3] = this.bitpixOrig == -64 ? Double.MAX_VALUE : (this.bitpixOrig == -32 ? 3.4028234663852886E38 : (this.bitpixOrig == 64 ? 9.223372036854776E18 : (this.bitpixOrig == 32 ? 2.147483647E9 : (this.bitpixOrig == 16 ? 32767.0 : 255.0))));
            }
            boolean bl = flagBothFloat = !(this.bitpix != -64 && this.bitpix != -32 || this.bitpixOrig != -64 && this.bitpixOrig != -32);
            if (this.bitpixOrig != -1 && this.bitpix != this.bitpixOrig && !flagBothFloat) {
                double d = this.bitpix == -64 ? -1.7976931348623157E308 : (this.bitpix == -32 ? -3.4028234663852886E38 : (this.bitpix == 64 ? -9.223372036854776E18 : (this.bitpix == 32 ? -2.147483647E9 : (this.cut[2] = this.bitpix == 16 ? -32767.0 : 1.0))));
                double d2 = this.bitpix == -64 ? Double.MAX_VALUE : (this.bitpix == -32 ? 3.4028234663852886E38 : (this.bitpix == 64 ? 9.223372036854776E18 : (this.bitpix == 32 ? 2.147483647E9 : (this.cut[3] = this.bitpix == 16 ? 32767.0 : 255.0))));
                if (this.bitpix > 0) {
                    this.coef = (this.cut[3] - this.cut[2]) / (this.cutOrig[3] - this.cutOrig[2]);
                    this.cut[0] = (this.cutOrig[0] - this.cutOrig[2]) * this.coef + this.cut[2];
                    this.cut[1] = (this.cutOrig[1] - this.cutOrig[2]) * this.coef + this.cut[2];
                    this.bzero = this.bZeroOrig + this.bScaleOrig * (this.cutOrig[2] - this.cut[2] / this.coef);
                    this.bscale = this.bScaleOrig / this.coef;
                } else {
                    this.bzero = 0.0;
                    this.bscale = 1.0;
                    this.coef = this.bScaleOrig;
                    this.cut[0] = this.cutOrig[0] * this.bScaleOrig + this.bZeroOrig;
                    this.cut[1] = this.cutOrig[1] * this.bScaleOrig + this.bZeroOrig;
                }
                this.info("Change BITPIX from " + this.bitpixOrig + " to " + this.bitpix);
                if (this.cutByImage) {
                    this.info("Map cut pixel range for each imageto [" + this.cut[2] + " .. " + this.cut[3] + "]");
                } else if (this.cutOrig[2] != this.cut[2] || this.cutOrig[3] != this.cut[3]) {
                    this.info("Map original pixel range [" + this.cutOrig[2] + " .. " + this.cutOrig[3] + "] to [" + this.cut[2] + " .. " + this.cut[3] + "]");
                }
                if (this.bZeroOrig != this.bzero || this.bScaleOrig != this.bscale || this.blankOrig != this.blank && !Double.isNaN(this.blankOrig) && !Double.isNaN(this.blank)) {
                    this.info("Change BZERO,BSCALE,BLANK=" + this.bZeroOrig + "," + this.bScaleOrig + "," + this.blankOrig + " to " + this.bzero + "," + this.bscale + "," + this.blank);
                }
                if (Double.isInfinite(this.bzero) || Double.isInfinite(this.bscale)) {
                    throw new Exception("pixelRange parameter required !");
                }
            } else {
                this.bzero = this.bZeroOrig;
                this.bscale = this.bScaleOrig;
                Aladin.trace(3, "BITPIX kept " + this.bitpix + " BZERO,BSCALE,BLANK=" + this.bzero + "," + this.bscale + "," + this.blank);
            }
            if (this.pixelGood != null) {
                this.good = new double[2];
                this.good[0] = (this.pixelGood[0] - this.bZeroOrig) / this.bScaleOrig;
                this.good[1] = (this.pixelGood[1] - this.bZeroOrig) / this.bScaleOrig;
            }
        }
        this.initRegion();
    }

    protected void initRegion() throws Exception {
        if (this.isValidateRegion()) {
            return;
        }
        try {
            if (this.mocIndex == null) {
                if (this.isMap()) {
                    this.mocIndex = new SMoc("0/0-11");
                } else {
                    try {
                        this.loadMocIndex();
                    }
                    catch (Exception e) {
                        this.loadMoc();
                    }
                }
            }
        }
        catch (Exception e) {
            this.mocIndex = new SMoc("0/0-11");
        }
        Moc mocArea = this.getArea();
        this.moc = mocArea == null ? this.mocIndex : this.mocIndex.intersection(mocArea);
        this.setValidateRegion(true);
    }

    protected Moc getRegion() {
        return this.moc;
    }

    protected void loadMocIndex() throws Exception {
        Moc mocIndex;
        this.mocIndex = mocIndex = Moc.createMoc(new FileInputStream(this.getHpxFinderPath() + cds.tools.Util.FS + "Moc.fits"));
    }

    protected void loadMoc() throws Exception {
        Moc mocIndex;
        this.mocIndex = mocIndex = Moc.createMoc(new FileInputStream(this.getOutputPath() + cds.tools.Util.FS + "Moc.fits"));
    }

    protected Moc getMocIndex() {
        return this.mocIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifTileOrder() {
        InputStreamReader in = null;
        boolean flagTileOrderFound = false;
        try {
            String propFile = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
            MyProperties prop = new MyProperties();
            in = new InputStreamReader(new FileInputStream(propFile));
            prop.load(in);
            String s = prop.getProperty("hips_tile_width");
            int o = s != null ? (int)CDSHealpix.log2(Integer.parseInt(s)) : Integer.parseInt(prop.getProperty("tileOrder"));
            if (o != this.getTileOrder()) {
                if (this.tileOrder != -1 && o != this.tileOrder) {
                    this.warning("Uncompatible tileOrder=" + this.tileOrder + " compared to pre-existing survey tileOrder=" + o);
                    boolean bl = false;
                    return bl;
                }
                this.setTileOrder(o);
                int w = this.getTileSide();
                this.info("Specifical tileOrder=" + o + " tileSize=" + w + "x" + w);
            }
            flagTileOrderFound = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!flagTileOrderFound && this.getTileOrder() != 9) {
            this.warning("Uncompatible tileOrder=" + this.getTileOrder() + " compared to default pre-existing survey tileOrder=" + 9);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifFrame() {
        InputStreamReader in = null;
        boolean flagFrameFound = false;
        try {
            String propFile = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
            MyProperties prop = new MyProperties();
            in = new InputStreamReader(new FileInputStream(propFile));
            prop.load(in);
            int o = 0;
            String s = prop.getProperty("hips_frame");
            if (s != null) {
                flagFrameFound = true;
                o = Context.getFrameVal(s);
            }
            if (flagFrameFound) {
                if (this.hasFrame()) {
                    if (o != this.getFrame()) {
                        this.warning("Uncompatible coordinate frame=" + this.getFrameName() + " compared to pre-existing survey frame=" + Context.getFrameName(o));
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.setFrame(o);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public boolean verifCoherence() {
        int or;
        if (!this.verifFrame()) {
            return false;
        }
        if (!this.verifTileOrder()) {
            return false;
        }
        if (this.modeMerge == ModeMerge.mergeOverwriteTile) {
            return true;
        }
        if (!this.isColor()) {
            String fileName = Context.findOneNpixFile(this.getOutputPath());
            if (fileName == null) {
                return true;
            }
            Fits fits = new Fits();
            try {
                fits.loadHeaderFITS(fileName);
            }
            catch (Exception e) {
                return true;
            }
            if (fits.bitpix != this.bitpix) {
                this.warning("Uncompatible BITPIX=" + this.bitpix + " compared to pre-existing survey BITPIX=" + fits.bitpix);
                return false;
            }
            boolean nanO = Double.isNaN(fits.blank);
            boolean nan = Double.isNaN(this.blank);
            if (this.bitpix > 0 && nanO) {
                boolean bl = nan = !Double.isNaN(this.getBlankOrig());
            }
            if (nanO != nan || !nan && fits.blank != this.blank) {
                this.warning("Uncompatible BLANK=" + this.blank + " compared to pre-existing survey BLANK=" + fits.blank);
                return false;
            }
        }
        if ((or = Util.getMaxOrderByPath(this.getOutputPath())) != -1 && or != this.getOrder()) {
            this.warning("Uncompatible order=" + this.getOrder() + " compared to pre-existing survey order=" + or);
            return false;
        }
        return true;
    }

    private double getDefaultBlankFromBitpix(int bitpix) {
        return bitpix < 0 ? Double.NaN : (bitpix == 32 ? -2.147483648E9 : (bitpix == 16 ? -32768.0 : 0.0));
    }

    private int[] parseBorderSize(String s) throws ParseException {
        int[] border = new int[]{0, 0, 0, 0};
        try {
            StringTokenizer st = new StringTokenizer(s, " ,;-");
            for (int i = 0; i < 4 && st.hasMoreTokens(); ++i) {
                String s1 = st.nextToken();
                border[i] = Integer.parseInt(s1);
                if (i != 0) continue;
                border[2] = border[1] = border[0];
                border[3] = border[1];
            }
            int x = border[0];
            border[0] = border[2];
            border[2] = x;
        }
        catch (Exception e) {
            throw new ParseException("Border error => assume 0", 0);
        }
        return border;
    }

    protected boolean isExistingDir() {
        String path = this.getInputPath();
        if (path == null) {
            return false;
        }
        return new File(path).isDirectory();
    }

    protected boolean isExistingHips() {
        return this.isExistingHips(this.getOutputPath());
    }

    protected boolean isExistingHips(String path) {
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.exists()) {
            return false;
        }
        int order = Util.getMaxOrderByPath(path);
        return order != -1;
    }

    protected int getTileWidthByNpixFile(String path) throws Exception {
        try {
            return this.findTileNSide(path);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected int getTileDepthByNpixFile(String path) throws Exception {
        try {
            return this.findTileDepth(path);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected boolean isExistingTiles() {
        return this.isExistingTiles(this.getOutputPath());
    }

    protected boolean isExistingTiles(String path) {
        String npixFile = Context.findOneNpixFile(path);
        return npixFile != null;
    }

    public static String findOneNpixFile(String path) {
        return Context.findOneNpixFile(path, null);
    }

    public static String findOneNpixFile(String path, String ext) {
        return Context.findOneNpixFile(path, ext, false);
    }

    public static String findOneNpixFile(String path, String ext, boolean flagMaxOrder) {
        int end;
        File root = new File(path);
        File norder = null;
        int maxOrder = -1;
        int order = -1;
        String[] list = root.list();
        if (list == null) {
            return null;
        }
        for (String s : list) {
            if (!s.startsWith("Norder")) continue;
            int end2 = s.indexOf(95);
            if (end2 < 0) {
                end2 = s.length();
            }
            try {
                order = Integer.parseInt(s.substring(6, end2));
            }
            catch (Exception e) {
                continue;
            }
            if (flagMaxOrder) {
                if (order <= maxOrder) continue;
                maxOrder = order;
            }
            norder = new File(path + "/" + s);
            if (!flagMaxOrder) break;
        }
        if (norder == null) {
            return null;
        }
        String[] norderList = norder.list();
        if (norderList != null) {
            for (String s : norderList) {
                if (!s.startsWith("Dir") || !s.endsWith(".bin")) continue;
                int start = s.lastIndexOf(45);
                end = s.lastIndexOf(46);
                if (start == -1 || start >= end) continue;
                String ext1 = s.substring(start + 1, end);
                if (ext != null && !ext1.equals(ext)) continue;
                try {
                    long ndir = Long.parseLong(s.substring(3, start));
                    for (int i = 0; i < 10000; ++i) {
                        long npix = ndir + (long)i;
                        if (Util.hipsUnpack(path, order, npix, ext1, 0).length <= 0) continue;
                        return Util.getFilePath(path, order, npix) + "." + ext1;
                    }
                    break;
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break;
                    e.printStackTrace();
                    break;
                }
            }
        }
        File dir = null;
        for (String s : norderList) {
            if (!s.startsWith("Dir")) continue;
            end = s.indexOf(95);
            if (end == -1) {
                end = s.length();
            }
            try {
                Long.parseLong(s.substring(3, end));
            }
            catch (Exception e) {
                continue;
            }
            dir = new File(norder.getAbsolutePath() + "/" + s);
            break;
        }
        if (dir == null) {
            return null;
        }
        String pathNpix = null;
        for (String s : dir.list()) {
            String x;
            int j;
            if (!s.startsWith("Npix") || (j = s.lastIndexOf(46)) < 0 || ext != null && !ext.equals(x = s.substring(j + 1))) continue;
            try {
                int j1 = s.lastIndexOf(95, j);
                if (j1 > 0) {
                    j = j1;
                }
                Long.parseLong(s.substring(4, j));
            }
            catch (Exception e) {
                continue;
            }
            pathNpix = dir.getAbsolutePath() + "/" + s;
            break;
        }
        return pathNpix;
    }

    protected boolean hasPropertyFile(String path) {
        File f = new File(path + cds.tools.Util.FS + "properties");
        return f.exists();
    }

    protected boolean isExistingIndexDir() {
        String path = this.getHpxFinderPath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.exists()) {
            return false;
        }
        for (File fc : f.listFiles()) {
            if (!fc.isDirectory() || !fc.getName().startsWith("Norder")) continue;
            return true;
        }
        return false;
    }

    protected void setMocIndex(Moc m) throws Exception {
        this.mocIndex = m;
    }

    protected long getNbLowCells() {
        long res;
        int of;
        Moc m;
        int o = this.getOrder();
        if (this.moc == null && this.mocIndex == null || o == -1) {
            return -1L;
        }
        Moc moc = m = this.moc != null ? this.moc : this.mocIndex;
        if (o != m.getSpaceOrder()) {
            try {
                m = m.clone();
                m.setSpaceOrder(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((of = this.getOrderFreq()) != -1 && of != m.getFreqOrder()) {
            try {
                m = m.clone();
                m.setFreqOrder(of);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isHips3D || !this.isCube()) {
            res = m.getNbValues();
        } else {
            int d = this.depth;
            int tileDepth = this.getTileDepth();
            d = this.depth / tileDepth + (this.depth % tileDepth > 0 ? 1 : 0);
            res = m.getNbValues() * (long)d;
        }
        return res;
    }

    protected long getDiskMem() {
        long nbLowCells = this.getNbLowCells();
        if (nbLowCells == -1L || this.bitpix == 0) {
            return -1L;
        }
        long mem = nbLowCells * (long)this.getTileSide() * (long)this.getTileSide() * (long)(Math.abs(this.bitpix) / 8);
        return mem;
    }

    protected void setProgressLastNorder3(int lastNorder3) {
        this.lastNorder3 = lastNorder3;
    }

    protected void showIndexStat(int statNbFile, int statBlocFile, int statNbZipFile, long statMemFile, long statPixSize, long statMaxSize, int statMaxWidth, int statMaxHeight, int statMaxDepth, int statMaxNbyte, long statDuree) {
        String s;
        if (statNbFile == -1) {
            s = "";
        } else {
            String nbPerSec = statDuree > 1000L ? "" + cds.tools.Util.round((double)statNbFile / ((double)statDuree / 1000.0), 1) : "";
            s = statNbFile + " file" + (statNbFile > 1 ? "s" : "") + " in " + cds.tools.Util.getTemps(statDuree * 1000L) + (nbPerSec.length() == 0 ? "" : " => " + nbPerSec + "/s") + (statNbFile > 0 && statNbZipFile == statNbFile ? " - all gzipped" : (statNbZipFile > 0 ? " (" + statNbZipFile + " gzipped)" : "")) + " => " + cds.tools.Util.getUnitDisk(statPixSize).replace("B", "pix") + " using " + cds.tools.Util.getUnitDisk(statMemFile) + (statNbFile > 1 && statMaxSize < 0L ? "" : " => biggest: [" + statMaxWidth + "x" + statMaxHeight + (statMaxDepth > 1 ? "x" + statMaxDepth : "") + " x" + statMaxNbyte + "]");
        }
        this.stat(s);
    }

    protected void showTilesStat(int statNbThreadRunning, int statNbThread, long totalTime, int statNbTile, int statNbEmptyTile, int statNodeTile, long statMinTime, long statMaxTime, long statAvgTime, long statNodeAvgTime, long usedMem, long deltaTime, long deltaNbTile) {
        String pourcentNbCells;
        String sNbCells;
        if (statNbTile == 0) {
            return;
        }
        long nbCells = this.getNbLowCells();
        long nbLowTile = statNbTile + statNbEmptyTile;
        String string = sNbCells = nbCells == -1L ? "" : "/" + nbCells;
        String string2 = nbCells == -1L ? "" : (pourcentNbCells = nbCells == 0L ? "-" : (double)Math.round((double)nbLowTile / (double)nbCells * 1000.0) / 10.0 + "%");
        long tempsTotalEstime = nbLowTile == 0L ? 0L : (nbCells == 0L ? 0L : nbCells * totalTime / nbLowTile - totalTime);
        long nbTilesPerMin = deltaNbTile * 60000L / deltaTime;
        int width = this.getTileSide();
        int depth = this.getTileDepth();
        String pixPerSec = cds.tools.Util.getUnitDisk(deltaNbTile * 1000L * (long)width * (long)width * (long)depth / deltaTime).replace("B", "pix");
        String s = statNbTile + (statNbEmptyTile == 0 ? "" : "+" + statNbEmptyTile) + sNbCells + " tiles + " + statNodeTile + " nodes in " + cds.tools.Util.getTemps(totalTime * 1000L) + " (" + pourcentNbCells + (nbTilesPerMin <= 0L ? "" : " " + nbTilesPerMin + " tiles/mn(=" + pixPerSec + "/s) EndsIn:" + cds.tools.Util.getTemps(tempsTotalEstime * 1000L)) + ") " + (statNbThread == 0 ? "" : "by " + statNbThreadRunning + "/" + statNbThread + " threads");
        this.stat(s);
        if (this.cacheFits != null && this.cacheFits.getStatNbOpen() > 0) {
            this.stat(this.cacheFits + "");
        }
        try {
            String cacheDisk = MyInputStreamCached.getCacheInfo(1);
            if (cacheDisk != null) {
                this.stat("Disk cache: " + cacheDisk);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setProgress(statNbTile + statNbEmptyTile, nbCells);
    }

    protected void showCutStat(long nRegions, long nbRegions, long nFiles, long nbFiles, long cTime) {
        double pourcent = (double)nFiles / (double)nbFiles;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        this.stat(cds.tools.Util.round(pourcent * 100.0, 1) + "% in " + cds.tools.Util.getTemps(cTime * 1000L) + " endsIn:" + cds.tools.Util.getTemps(endsIn * 1000L) + " (regions=" + nRegions + "/" + nbRegions + ")");
        this.setProgress(nFiles, nbFiles);
    }

    protected void showMapStat(long cRecord, long nbRecord, long cTime, CacheFits cache, String info) {
        double pourcent = (double)cRecord / (double)nbRecord;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        this.stat(cds.tools.Util.round(pourcent * 100.0, 1) + "% in " + cds.tools.Util.getTemps(cTime * 1000L) + " endsIn:" + cds.tools.Util.getTemps(endsIn * 1000L) + " (record=" + (cRecord + 1L) + "/" + nbRecord + ")");
        if (cache != null && cache.getStatNbOpen() > 0) {
            this.stat(cache + "");
        }
        this.setProgress(cRecord, nbRecord);
    }

    protected void showJpgStat(int statNbFile, long cTime, int statNbThread, int statNbThreadRunning) {
        String pourcentNbCells;
        long nbLowCells = this.getNbLowCells();
        double pourcent = nbLowCells <= 0L ? 0.0 : (double)statNbFile / (double)nbLowCells;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        String string = pourcentNbCells = nbLowCells == -1L ? "" : (double)Math.round((double)statNbFile / (double)nbLowCells * 1000.0) / 10.0 + "%) ";
        String s = nbLowCells <= 0L ? statNbFile + " tiles in " + cds.tools.Util.getTemps(cTime * 1000L) : statNbFile + "/" + nbLowCells + " tiles in " + cds.tools.Util.getTemps(cTime * 1000L) + " (" + pourcentNbCells + " endsIn:" + cds.tools.Util.getTemps(endsIn * 1000L) + (statNbThread == 0 ? "" : " by " + statNbThreadRunning + "/" + statNbThread + " threads");
        this.stat(s);
        this.setProgress(statNbFile, nbLowCells);
    }

    protected void showMirrorStat(int statNbFile, long cumul, long lastCumulPerSec, long cTime, int statNbThread, int statNbThreadRunning, long timeIP) {
        String s;
        long nbLowCells = this.getNbLowCells();
        double pourcent = nbLowCells <= 0L ? 0.0 : (double)statNbFile / (double)nbLowCells;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        String pourcentNbCells = nbLowCells == -1L ? "" : (double)Math.round((double)statNbFile / (double)nbLowCells * 1000.0) / 10.0 + "%) ";
        String debit = cTime > 1000L ? cds.tools.Util.getUnitDisk(cumul / (cTime / 1000L)) + "/s" : "OB/s";
        String debitI = cds.tools.Util.getUnitDisk(lastCumulPerSec) + "/s";
        if (nbLowCells <= 0L) {
            s = statNbFile + " tiles in " + cds.tools.Util.getTemps(cTime * 1000L);
        } else {
            String s1 = pourcent == 1.0 ? " avg:" + debit + " for " + cds.tools.Util.getUnitDisk(cumul) : "endsIn:" + cds.tools.Util.getTemps(endsIn * 1000L) + " speed:" + debitI + " avg:" + debit + " for " + cds.tools.Util.getUnitDisk(cumul) + (statNbThread == 0 ? "" : " by " + statNbThreadRunning + "/" + statNbThread + " threads") + (timeIP == 0L ? "" : " IPTime:" + timeIP + "ms");
            s = statNbFile + "/" + nbLowCells + " tiles in " + cds.tools.Util.getTemps(cTime * 1000L) + " (" + pourcentNbCells + s1;
        }
        this.stat(s);
        this.setProgress(statNbFile, nbLowCells);
    }

    protected void showRGBStat(int statNbFile, long cTime, int statNbThread, int statNbThreadRunning) {
        String pourcentNbCells;
        long nbLowCells = this.getNbLowCells();
        double pourcent = nbLowCells <= 0L ? 0.0 : (double)statNbFile / (double)nbLowCells;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        String string = pourcentNbCells = nbLowCells == -1L ? "" : (double)Math.round((double)statNbFile / (double)nbLowCells * 1000.0) / 10.0 + "%) ";
        String s = nbLowCells <= 0L ? statNbFile + " tiles in " + cds.tools.Util.getTemps(cTime * 1000L) : statNbFile + "/" + nbLowCells + " tiles in " + cds.tools.Util.getTemps(cTime * 1000L) + " (" + pourcentNbCells + " endsIn:" + cds.tools.Util.getTemps(endsIn * 1000L) + (statNbThread == 0 ? "" : " by " + statNbThreadRunning + "/" + statNbThread + " threads");
        this.stat(s);
        this.setProgress(statNbFile, nbLowCells);
    }

    protected boolean isMap() {
        return this.isMap;
    }

    protected void setMap(boolean flag) {
        this.isMap = flag;
    }

    public void setIgnoreStamp(boolean flag) {
        this.ignoreStamp = true;
    }

    public boolean isTaskRunning() {
        return this.taskRunning;
    }

    public void setTaskRunning(boolean flag) {
        if (flag) {
            this.taskAborting = false;
        } else {
            this.progressBar = null;
        }
        this.taskRunning = flag;
        this.resumeWidgets();
    }

    public boolean isTaskPause() {
        return this.taskPause;
    }

    public void setTaskPause(boolean flag) {
        this.taskPause = flag;
        this.resumeWidgets();
    }

    public void taskAbort() {
        this.taskAborting = true;
        this.taskPause = false;
    }

    public boolean isTaskAborting() {
        if (this.taskAborting) {
            return true;
        }
        while (this.taskPause) {
            cds.tools.Util.pause(500);
        }
        return false;
    }

    protected static String getNow() {
        return Constante.getDate();
    }

    static long getTime(String date) throws Exception {
        return DATEFORMAT.parse(date).getTime();
    }

    private static String getKeyActionStart(Action a) {
        return "Processing." + (Object)((Object)a) + ".start";
    }

    private static String getKeyActionEnd(Action a) {
        return "Processing." + (Object)((Object)a) + ".end";
    }

    public void startAction(Action a) throws Exception {
        this.action = a;
        this.action.startTime();
        this.setProgress(0.0, -1.0);
    }

    public void endAction() throws Exception {
        if (this.action == null) {
            return;
        }
        if (this.isTaskAborting()) {
            this.abort((Object)((Object)this.action) + " abort (after " + cds.tools.Util.getTemps(this.action.getDuration() * 1000L) + ")");
        } else {
            this.done((Object)((Object)this.action) + " done (in " + cds.tools.Util.getTemps(this.action.getDuration() * 1000L) + ")");
        }
        this.action = null;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean actionAlreadyDone(Action a) {
        if (this.ignoreStamp) {
            return false;
        }
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
            if (this.prop == null) {
                return false;
            }
            String end = this.prop.getProperty(Context.getKeyActionEnd(a));
            if (end == null) {
                return false;
            }
            String start = this.prop.getProperty(Context.getKeyActionStart(a));
            if (start == null) {
                return false;
            }
            if (Context.getTime(end) < Context.getTime(start)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean actionPrecedeAction(Action avant, Action apres) {
        if (this.ignoreStamp) {
            return false;
        }
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
            if (this.prop == null) {
                return false;
            }
            if (!this.actionAlreadyDone(avant) || !this.actionAlreadyDone(apres)) {
                return false;
            }
            String endAvant = this.prop.getProperty(Context.getKeyActionEnd(avant));
            String endApres = this.prop.getProperty(Context.getKeyActionEnd(apres));
            if (Context.getTime(endApres) < Context.getTime(endAvant)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setProgress(double progress, double progressMax) {
        this.setProgress(progress);
        this.setProgressMax(progressMax);
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setProgressMax(double progressMax) {
        this.progressMax = progressMax;
    }

    public void progressStatus() {
        System.out.print('.');
        this.flagNL = true;
    }

    public void enableProgress(boolean flag) {
        System.out.println("progress [" + (Object)((Object)this.action) + "] enable=" + flag);
    }

    public void setProgressBar(JProgressBar bar) {
    }

    public void resumeWidgets() {
    }

    public void trace(int i, String string) {
        if (Aladin.levelTrace >= i) {
            System.out.println(string);
        }
    }

    public void setTrace(int trace) {
        Aladin.levelTrace = trace;
    }

    public static void setVerbose(boolean verbose) {
        Context.verbose = verbose;
        BuilderRunner.DEBUG = true;
    }

    public static int getVerbose() {
        return Aladin.levelTrace;
    }

    public static void setVerbose(int level) {
        if (level >= 0) {
            verbose = true;
            Aladin.levelTrace = level;
        } else {
            verbose = false;
            Aladin.levelTrace = 0;
        }
    }

    private void nl() {
        if (this.flagNL) {
            System.out.println();
        }
        this.flagNL = false;
    }

    public static String getTitle(String s) {
        return Context.getTitle(s, '-');
    }

    public static String getTitle(String s, char c) {
        return Context.getTitle(s, c, 102);
    }

    public static String getTitle(String s, char c, int len) {
        int m = (len - 2 - s.length()) / 2;
        StringBuilder s1 = new StringBuilder();
        for (int i = 0; i < m; ++i) {
            s1.append(c);
        }
        return s1 + " " + s + " " + (s.length() % 2 == 0 ? "" : " ") + s1;
    }

    protected void setTerm(boolean isTermCompliant) {
        this.TERM = isTermCompliant;
    }

    private String rouge() {
        return this.TERM ? "\u001b[31m" : "";
    }

    private String vert() {
        return this.TERM ? "\u001b[32m" : "";
    }

    private String brun() {
        return this.TERM ? "\u001b[33m" : "";
    }

    private String blue() {
        return this.TERM ? "\u001b[34m" : "";
    }

    private String violet() {
        return this.TERM ? "\u001b[35m" : "";
    }

    private String bluec() {
        return this.TERM ? "\u001b[36m" : "";
    }

    private String cyan() {
        return this.TERM ? "\u001b[37m" : "";
    }

    private String end() {
        return this.TERM ? "\u001b[0m" : "";
    }

    public void valid(String s) {
        this.nl();
        System.out.println("\n" + this.rouge() + "VALID : " + Context.getTitle(s, '=') + this.end());
    }

    public void running(String s) {
        this.nl();
        System.out.println(this.blue() + "RUN   : " + Context.getTitle(s, '=') + this.end());
    }

    public void done(String r) {
        this.nl();
        System.out.println(this.blue() + "DONE  : " + r + this.end());
    }

    public void abort(String r) {
        this.nl();
        System.out.println(this.rouge() + "ABORT : " + r + this.end());
    }

    public void info(String s) {
        this.nl();
        System.out.println("INFO  : " + s);
    }

    public void run(String s) {
        this.nl();
        System.out.println(this.blue() + "RUN   : " + s + this.end());
    }

    public void warning(String s) {
        this.nl();
        System.out.println(this.violet() + "*WARN*: " + s + this.end());
    }

    public void error(String s) {
        this.nl();
        System.out.println(this.rouge() + "*ERROR: " + s + this.end());
    }

    public void action(String s) {
        this.nl();
        System.out.println(this.blue() + "ACTION: " + s + this.end());
    }

    public void stat(String s) {
        this.nl();
        System.out.println(this.bluec() + "STAT  : " + s + this.end());
    }

    public void param(String s) {
        this.nl();
        System.out.println(this.cyan() + "PARAM : " + s + this.end());
    }

    public String addFileRemoveList(String file) {
        int i;
        if (this.removeList == null) {
            this.removeList = new HashSet();
        }
        if (this.removeList.size() > 100) {
            this.abort("Too many ignored original files (>100)");
            this.taskAbort();
        }
        if (file.endsWith("]") && (i = file.lastIndexOf(91)) > 0) {
            file = file.substring(0, i);
        }
        this.removeList.add(file);
        return file;
    }

    public boolean isFileRemovedList(String file) {
        int i;
        if (this.removeList == null) {
            return false;
        }
        if (file.endsWith("]") && (i = file.lastIndexOf(91)) > 0) {
            file = file.substring(0, i);
        }
        return this.removeList.contains(file);
    }

    public void removeListReport() {
        if (this.removeList == null || this.removeList.size() == 0) {
            return;
        }
        this.warning("Report on ignored files:");
        for (String s : this.removeList) {
            this.nl();
            System.out.println(this.violet() + "  " + s + this.end());
        }
    }

    public boolean isValidateOutput() {
        return this.validateOutputDone;
    }

    public void setValidateOutput(boolean flag) {
        this.validateOutputDone = flag;
    }

    public boolean isValidateInput() {
        return this.validateInputDone;
    }

    public void setValidateInput(boolean flag) {
        this.validateInputDone = flag;
    }

    public boolean isValidateCut() {
        return this.validateCutDone;
    }

    public void setValidateCut(boolean flag) {
        this.validateCutDone = flag;
    }

    public boolean isValidateRegion() {
        return this.validateRegion;
    }

    public void setValidateRegion(boolean flag) {
        this.validateRegion = flag;
    }

    protected void setComment(String comment) {
        this.setPropriete1("#", "#" + comment, false);
    }

    protected void insertPropriete(String key, String value) {
        this.setPropriete1(key, value, true);
    }

    protected void setPropriete(String key, String value) {
        this.setPropriete1(key, value, false);
    }

    private void setPropriete1(String key, String value, boolean flagInsert) {
        int i;
        if (this.keyAddProp == null) {
            this.keyAddProp = new Vector();
            this.valueAddProp = new Vector();
        }
        if (value == null && (i = this.keyAddProp.indexOf(key)) != -1) {
            this.keyAddProp.remove(i);
            this.valueAddProp.remove(i);
        }
        if (flagInsert) {
            this.keyAddProp.insertElementAt(key, 0);
            this.valueAddProp.insertElementAt(value, 0);
        } else {
            this.keyAddProp.addElement(key);
            this.valueAddProp.addElement(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIndexHtml() throws Exception {
        byte[] buf;
        MyInputStream is = null;
        try {
            is = cds.tools.Util.openStream(INDEX_TEMPLATE);
            if (is == null) {
                throw new Exception();
            }
            buf = is.readFully();
            if (buf.length < 10) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.warning("Remote index.html template not available => https://aladin.cds.unistra.fr/hips-templates/hips-landing-page-template.html");
            this.warning("Assuming internal default template => retry later to get the last template release");
            is = new MyInputStream(Aladin.class.getResourceAsStream(INDEX_LOCAL));
            buf = is.readFully();
        }
        FileOutputStream out = null;
        try {
            String tmp = this.getOutputPath() + cds.tools.Util.FS + "index.html";
            File ftmp = new File(tmp);
            if (ftmp.exists()) {
                ftmp.delete();
            }
            out = new FileOutputStream(ftmp);
            out.write(buf);
            is.close();
            is = null;
            out.close();
            out = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void writeMetadataFits() throws Exception {
        Context.writeMetadataFits(this.getOutputPath(), this.header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetadataFits(String path, HeaderFits header) throws Exception {
        if (header == null) {
            return;
        }
        String tmp = path + cds.tools.Util.FS + "metadata.txt";
        File ftmp = new File(tmp);
        if (ftmp.exists()) {
            ftmp.delete();
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(ftmp);
            out.write(header.getOriginalHeaderFits().getBytes());
        }
    }

    protected void createPropForVisu() {
        try {
            File f = new File(this.outputPath + cds.tools.Util.FS + "properties");
            if (!f.exists()) {
                this.writePropertiesFile(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getLastModifiedFromProp() {
        try {
            MyProperties prop = new MyProperties();
            this.loadProperties(prop, this.outputPath);
            String date = prop.getProperty("hips_release_date");
            return Astrodate.JDToUnix(Astrodate.dateToJD(date));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    protected void writeMetaFile() throws Exception {
        File fprop = new File(this.getOutputPath() + cds.tools.Util.FS + "properties");
        long dateProp = fprop.exists() ? fprop.lastModified() / 1000L : 0L;
        long dateLastRelease = this.getLastModifiedFromProp();
        File find = new File(this.getOutputPath() + cds.tools.Util.FS + "index.html");
        long dateIndex = find.exists() ? find.lastModified() / 1000L : 0L;
        this.info("properties file " + (dateLastRelease == 0L ? "created" : "updated"));
        this.writePropertiesFile();
        long dateP = Math.abs(dateIndex - dateLastRelease) < 120L ? dateProp : dateLastRelease;
        boolean flagManual = dateIndex != 0L && dateP != 0L && Math.abs(dateIndex - dateP) > 2L;
        this.info("index.html file " + (dateIndex == 0L ? "created" : (flagManual ? "kept as is (probably modified manually)" : "updated")));
        if (!flagManual) {
            this.writeIndexHtml();
        }
        this.writeMetadataFits();
        this.warningHipsVersion();
    }

    private String getHipsVersion() {
        if (this.getTileDepth() > 1 || this.isHips3D) {
            return "1.5-proto2";
        }
        return "1.4";
    }

    private void warningHipsVersion() {
        String v = this.getHipsVersion();
        if ("1.4".equals(v)) {
            return;
        }
        this.warning("THIS IS A PROTOTYPE HIPS - NOT COMPATIBLE WITH IVOA HiPS 1.0 STANDARD");
    }

    protected void writePropertiesFile() throws Exception {
        this.writePropertiesFile(null, this.notouch);
    }

    protected void writePropertiesFile(boolean notouch) throws Exception {
        this.writePropertiesFile(null, notouch);
    }

    protected void writePropertiesFile(OutputStreamWriter stream) throws Exception {
        this.writePropertiesFile(stream, this.notouch);
    }

    protected void writePropertiesFile(OutputStreamWriter stream, boolean notouch) throws Exception {
        String s;
        String titre;
        if (this.hipsId == null) {
            this.setHipsId(null);
        }
        int min = this.getMinOrder();
        int max = this.getOrder();
        int[] minMaxOrder = new int[]{min, max};
        if (min == -1 || max == -1) {
            int[] mm = this.findMinMaxOrder();
            if (min == -1) {
                minMaxOrder[0] = mm[0];
            }
            if (max <= 0) {
                minMaxOrder[1] = mm[1];
            }
        }
        long nSide = this.tileOrder == -1 ? (long)this.findTileNSide() : CDSHealpix.pow2(this.tileOrder);
        this.insertPropriete("creator_did", this.hipsId);
        if (this.creator != null) {
            this.setPropriete("hips_creator", this.creator);
        } else {
            this.setPropriete("#hips_creator", "HiPS creator (institute or person)");
        }
        this.setPropriete("#hips_copyright", "Copyright mention of the HiPS");
        if (this.addendum_id != null) {
            this.setPropriete("addendum_id", this.addendum_id);
        }
        if ((titre = this.title) == null && this.prop != null) {
            titre = this.prop.get("obs_title");
        }
        if (titre == null) {
            titre = this.getTitle();
        }
        this.setPropriete("obs_title", titre);
        this.setPropriete("#obs_collection", "Dataset collection name");
        this.setPropriete("#obs_description", "Dataset text description");
        this.setPropriete("#obs_ack", "Acknowledgement mention");
        this.setPropriete("#prov_progenitor", "Provenance of the original data (free text)");
        this.setPropriete("#bib_reference", "Bibcode for bibliographic reference");
        this.setPropriete("#bib_reference_url", "URL to bibliographic reference");
        this.setPropriete("#obs_copyright", "Copyright mention of the original data");
        this.setPropriete("#obs_copyright_url", "URL to copyright page of the original data");
        if (!Double.isNaN(this.tmin) && !Double.isNaN(this.tmax)) {
            this.setPropriete("t_min", this.tmin + "");
            this.setPropriete("t_max", this.tmax + "");
        } else {
            this.setPropriete("#t_min", "Start time in MJD ( =(Unixtime/86400)+40587  or https://heasarc.gsfc.nasa.gov/cgi-bin/Tools/xTime/xTime.pl)");
            this.setPropriete("#t_max", "Stop time in MJD");
        }
        boolean flagEm = false;
        try {
            FMoc fmoc;
            Moc m = Moc.createMoc(new FileInputStream(this.getOutputPath() + cds.tools.Util.FS + "Moc.fits"));
            double skyFraction = m.getSpaceMoc().getCoverage();
            s = skyFraction > 0.0 ? cds.tools.Util.myRound(skyFraction) : null;
            this.setPropriete("moc_sky_fraction", s);
            if (m.isFreq() && (fmoc = m.getFreqMoc()) != null) {
                double emmax = CalibFreq.freq2Wave(fmoc.getFreqMax());
                this.setPropriete("em_min", emmax + "");
                double emmin = CalibFreq.freq2Wave(fmoc.getFreqMin());
                this.setPropriete("em_max", emmin + "");
                flagEm = true;
            }
        }
        catch (Exception m) {
            // empty catch block
        }
        if (!flagEm) {
            this.setPropriete("#em_min", "Start in spectral coordinates in meters ( =2.998E8/freq in Hz, or =1.2398841929E-12*energy in MeV )");
            this.setPropriete("#em_max", "Stop in spectral coordinates in meters");
        }
        this.setPropriete("#obs_regime", "Waveband keyword (Radio Infrared Optical UV X-ray Gamma-ray)");
        this.setPropriete("hips_builder", "Aladin/HipsGen v12.646");
        this.setPropriete("hips_version", this.getHipsVersion());
        if (!notouch) {
            String date = Context.getNow();
            this.setPropriete("hips_release_date", date);
        }
        this.setPropriete("hips_frame", this.getFrameName());
        this.setPropriete("hips_order", minMaxOrder[1] + "");
        if (this.getOrderFreq() >= 0) {
            this.setPropriete("hips_order_freq", this.getOrderFreq() + "");
        } else {
            this.setPropriete("hips_order_freq", null);
        }
        this.setPropriete("hips_order_min", minMaxOrder[0] + "");
        this.setPropriete("hips_tile_width", nSide + "");
        if (this.getTileDepth() > 1) {
            this.setPropriete("hips_tile_depth", this.getTileDepth() + "");
        } else {
            this.setPropriete("hips_tile_depth", null);
        }
        this.setPropriete("#hips_service_url", "ex: http://yourHipsServer/" + this.getLabelFromHipsId() + "");
        String pub = "public";
        String clone = " clonableOnce";
        if (this.status != null) {
            Tok tok = new Tok(this.status);
            while (tok.hasMoreTokens()) {
                s = tok.nextToken().toLowerCase();
                if (s.equals("private")) {
                    pub = "private";
                }
                if (s.equals("unclonable")) {
                    clone = " unclonable";
                    continue;
                }
                if (!s.equals("clonable")) continue;
                clone = " clonable";
            }
        }
        this.setPropriete("hips_status", pub + " " + "master" + clone);
        String fmt = this.getAvailableTileFormats();
        if (fmt.length() > 0) {
            this.setPropriete("hips_tile_format", fmt);
        }
        if ((fmt.indexOf("fits") >= 0 || this.isMap()) && this.bitpix != -1) {
            this.setPropriete("hips_pixel_bitpix", this.bitpix + "");
        }
        if (fmt.indexOf("fits") >= 0 && this.cut != null) {
            if (Context.hasCut(this.cut)) {
                this.setPropriete("hips_pixel_cut", cds.tools.Util.myRound(this.bscale * this.cut[0] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[1] + this.bzero));
            }
            if (Context.hasRange(this.cut)) {
                this.setPropriete("hips_data_range", cds.tools.Util.myRound(this.bscale * this.cut[2] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[3] + this.bzero));
            }
        }
        if (fmt.indexOf("fits") >= 0 && !Double.isNaN(this.dataMin) && !Double.isNaN(this.dataMax)) {
            this.setPropriete("hips_data_minmax", cds.tools.Util.myRound(this.dataMin) + " " + cds.tools.Util.myRound(this.dataMax));
        }
        if (this.target != null) {
            try {
                Tok tok = new Tok(this.target, " ;,");
                double ra = Double.parseDouble(tok.nextToken());
                double de = Double.parseDouble(tok.nextToken());
                this.setPropriete("hips_initial_ra", ra + "");
                this.setPropriete("hips_initial_dec", de + "");
                if (tok.hasMoreTokens()) {
                    double rad = Double.parseDouble(tok.nextToken());
                    this.setPropriete("hips_initial_fov", rad + "");
                    if (this.isHips3D && tok.hasMoreTokens()) {
                        double frq = Double.parseDouble(tok.nextToken());
                        this.setPropriete("hips_initial_freq", frq + "");
                    }
                }
            }
            catch (Exception e) {
                this.warning("HiPS initial target syntaxe error [" + this.target + "] => ignored");
            }
        }
        double res = CDSHealpix.pixRes(this.order + this.getTileOrder());
        this.setPropriete("hips_pixel_scale", cds.tools.Util.myRound(res / 3600.0));
        if (this.resolution != null) {
            this.setPropriete("s_pixel_scale", this.resolution);
        }
        if (this.isCubeFreq()) {
            if (!Double.isNaN(this.restFreq)) {
                this.setPropriete("obs_restfreq", this.restFreq + "");
            }
            this.setPropriete("dataproduct_type", "spectral-cube");
        } else if (this.isCube()) {
            this.setPropriete("dataproduct_type", "cube");
            if (!this.isHips3D) {
                this.setPropriete("hips_cube_depth", this.depth + "");
                this.setPropriete("hips_cube_firstframe", this.depth / 2 + "");
                if (this.isCubeCanal()) {
                    this.setPropriete("data_cube_crpix3", this.crpix3 + "");
                    this.setPropriete("data_cube_crval3", this.crval3 + "");
                    this.setPropriete("data_cube_cdelt3", this.cdelt3 + "");
                    if (this.cunit3 != null) {
                        this.setPropriete("data_cube_cunit3", this.cunit3 + "");
                    }
                }
            }
        } else {
            this.setPropriete("dataproduct_type", "image");
        }
        if (this.live && !this.isColor()) {
            this.setPropriete("dataproduct_subtype", "live");
        }
        if (this.isColor()) {
            this.setPropriete("dataproduct_subtype", this.live ? "color live" : "color");
            if (this.redInfo != null) {
                this.setPropriete("hips_rgb_red", this.redInfo);
            }
            if (this.greenInfo != null) {
                this.setPropriete("hips_rgb_green", this.greenInfo);
            }
            if (this.blueInfo != null) {
                this.setPropriete("hips_rgb_blue", this.blueInfo);
            }
        }
        if (this.hipsCheckCode != null) {
            this.setPropriete("hips_check_code", this.hipsCheckCode);
        }
        String[] k = new String[this.keyAddProp == null ? 0 : this.keyAddProp.size()];
        String[] v = new String[k.length];
        for (int i = 0; i < k.length; ++i) {
            k[i] = this.keyAddProp.get(i);
            v[i] = this.valueAddProp.get(i);
        }
        this.updateProperties(k, v, true, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHpxFinderProperties() throws Exception {
        if (this.hipsId == null) {
            this.setHipsId(null);
        }
        MyProperties prop = new MyProperties();
        String titre = this.getTitle() + "-meta";
        String finderHipxId = this.getHipsId() + "/meta";
        prop.setProperty("creator_did", finderHipxId);
        prop.setProperty("obs_title", titre);
        prop.setProperty("dataproduct_type", "meta");
        prop.setProperty("hips_frame", this.getFrameName());
        prop.setProperty("hips_order", this.getOrder() + "");
        if (this.getOrderFreq() >= 0) {
            prop.setProperty("hips_order_freq", this.getOrderFreq() + "");
        }
        if (this.tileOrder != 9) {
            prop.setProperty("hips_tile_width", this.getTileSide() + "");
        }
        if (this.getTileDepth() > 1) {
            prop.setProperty("hips_tile_depth", this.getTileDepth() + "");
        }
        if (this.minOrder != -1) {
            prop.setProperty("hips_order_min", this.minOrder + "");
        }
        if (!this.notouch) {
            prop.setProperty("hips_release_date", Context.getNow());
        }
        if (this.progenMaxWidth > 0) {
            prop.setProperty("progen_max_cell", this.progenMaxWidth + "x" + this.progenMaxHeight + (this.progenMaxDepth > 1 ? "x" + this.progenMaxDepth + ":" + this.progenMaxOverlays : ""));
        }
        prop.setProperty("hips_version", "1.4");
        prop.setProperty("hips_builder", "Aladin/HipsGen v12.646");
        while (prop.removeComment(FORCOMPATIBILITY)) {
        }
        String propFile = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
        File f = new File(propFile);
        if (f.exists()) {
            f.delete();
        }
        try (OutputStreamWriter out = null;){
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            prop.store(out, null);
        }
    }

    protected boolean isHiPS3D() {
        return this.isHiPS3D(this.getOutputPath());
    }

    protected boolean isHiPS3D(String path) {
        File root = new File(path);
        if (!root.exists()) {
            return false;
        }
        String[] rootList = root.list();
        if (rootList != null) {
            for (String s : rootList) {
                if (!s.startsWith("Norder")) continue;
                try {
                    int end = s.indexOf(95);
                    if (end < 0) continue;
                    Integer.parseInt(s.substring(6, end));
                    Long.parseLong(s.substring(end + 1));
                }
                catch (Exception e) {
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    protected boolean isPacked() {
        return this.isPacked(this.getOutputPath());
    }

    protected boolean isPacked(String path) {
        File root = new File(path);
        if (!root.exists()) {
            return false;
        }
        File norder = null;
        String[] rootList = root.list();
        if (rootList != null) {
            for (String s : rootList) {
                if (!s.startsWith("Norder")) continue;
                try {
                    int end = s.indexOf(95);
                    if (end < 0) {
                        end = s.length();
                    }
                    Integer.parseInt(s.substring(6, end));
                }
                catch (Exception e) {
                    continue;
                }
                norder = new File(path + "/" + s);
                break;
            }
        }
        if (norder == null) {
            return false;
        }
        String[] norderList = norder.list();
        if (norderList != null) {
            for (String s : norderList) {
                if (!s.startsWith("Dir") || !s.endsWith(".bin")) continue;
                int start = s.lastIndexOf(45);
                int end = s.lastIndexOf(46);
                if (start == -1 || start >= end) continue;
                return true;
            }
        }
        return false;
    }

    protected String getAvailableTileFormats() {
        return this.getAvailableTileFormats(this.getOutputPath());
    }

    protected String getAvailableTileFormats(String path) {
        File root = new File(path);
        StringBuilder res = new StringBuilder();
        File norder = null;
        Object[] rootList = root.list();
        if (rootList != null) {
            Arrays.sort(rootList);
            for (Object s : rootList) {
                if (!((String)s).startsWith("Norder")) continue;
                try {
                    int end = ((String)s).indexOf(95);
                    if (end < 0) {
                        end = ((String)s).length();
                    }
                    Integer.parseInt(((String)s).substring(6, end));
                }
                catch (Exception e) {
                    continue;
                }
                norder = new File(path + "/" + (String)s);
                break;
            }
        }
        if (norder == null) {
            return "";
        }
        File dir = null;
        String[] norderList = norder.list();
        if (norderList != null) {
            String[] stringArray = norderList;
            int s = stringArray.length;
            block7: for (int e = 0; e < s; ++e) {
                String s2 = stringArray[e];
                if (!s2.startsWith("Dir") || !s2.endsWith(".bin")) continue;
                int start = s2.lastIndexOf(45);
                int end = s2.lastIndexOf(46);
                if (start == -1 || start >= end) continue;
                String ext = "." + s2.substring(start + 1, end);
                for (int i = 0; i < Constante.TILE_EXTENSION.length; ++i) {
                    if (!ext.equals(Constante.TILE_EXTENSION[i])) continue;
                    if (res.length() > 0) {
                        res.append(' ');
                    }
                    res.append(Constante.TILE_MODE[i]);
                    continue block7;
                }
            }
        }
        if (norderList != null) {
            for (String s2 : norderList) {
                if (!s2.startsWith("Dir")) continue;
                int end = s2.indexOf(95);
                if (end == -1) {
                    end = s2.length();
                }
                try {
                    Long.parseLong(s2.substring(3, end));
                }
                catch (Exception e) {
                    continue;
                }
                dir = new File(norder.getAbsolutePath() + "/" + s2);
                break;
            }
        }
        if (dir == null) {
            return "";
        }
        String npix = null;
        String[] dirList = dir.list();
        if (dirList != null) {
            for (String s : dirList) {
                int j;
                if (!s.startsWith("Npix") || (j = s.lastIndexOf(46)) < 0) continue;
                try {
                    int j1 = s.lastIndexOf(95, j);
                    if (j1 < 0) {
                        j1 = j;
                    }
                    Long.parseLong(s.substring(4, j1));
                }
                catch (Exception e) {
                    continue;
                }
                npix = dir.getAbsolutePath() + "/" + s.substring(0, j);
                break;
            }
        }
        if (npix == null) {
            return "";
        }
        for (int i = 0; i < Constante.TILE_EXTENSION.length; ++i) {
            File f = new File(npix + Constante.TILE_EXTENSION[i]);
            if (!f.exists()) continue;
            if (res.length() > 0) {
                res.append(' ');
            }
            if (res.indexOf(Constante.TILE_MODE[i]) != -1) continue;
            res.append(Constante.TILE_MODE[i]);
        }
        return res.toString();
    }

    protected int findMaxOrder(String path) {
        return this.findMinMaxOrder(path)[1];
    }

    protected int[] findMinMaxOrder() {
        return this.findMinMaxOrder(this.getOutputPath());
    }

    protected int[] findMinMaxOrder(String path) {
        File root = new File(path);
        int min = -1;
        int max = -1;
        String[] lists = root.list();
        if (lists == null) {
            lists = new String[]{};
        }
        for (String s : lists) {
            if (!s.startsWith("Norder")) continue;
            try {
                int end = s.indexOf(95);
                if (end < 0) {
                    end = s.length();
                }
                int n = Integer.parseInt(s.substring(6, end));
                if (min == -1 || n < min) {
                    min = n;
                }
                if (max != -1 && n <= max) continue;
                max = n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[]{min, max};
    }

    private int findTileNSide() throws Exception {
        return this.findTileNSide(this.getOutputPath());
    }

    private int findTileNSide(String path) throws Exception {
        return this.findTileParam(path, 0);
    }

    private int findTileDepth() throws Exception {
        return this.findTileDepth(this.getOutputPath());
    }

    private int findTileDepth(String path) throws Exception {
        return this.findTileParam(path, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findTileParam(String path, int param) throws Exception {
        String pathNpix = Context.findOneNpixFile(path, "fits");
        if (pathNpix == null) {
            if (this.isHiPS3D(path)) {
                try {
                    if (param == 0) {
                        return Integer.parseInt(Builder.loadProperty(path, "hips_tile_width"));
                    }
                    if (param == 1) {
                        String s = Builder.loadProperty(path, "hips_tile_depth");
                        return s == null ? 1 : Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    return -1;
                }
            }
            pathNpix = Context.findOneNpixFile(path);
        }
        if (pathNpix == null) {
            throw new Exception();
        }
        MyInputStream in = null;
        if (!new File(pathNpix).exists()) {
            int order = Util.getOrderFromPath(pathNpix);
            long npix = Util.getNpixFromPath(pathNpix);
            String ext = Util.getExtFromPath(pathNpix);
            int z = Util.getDepthFromPath(pathNpix);
            byte[] buf = Util.hipsUnpack(path, order, npix, ext, z);
            MyByteArrayStream bas = new MyByteArrayStream();
            bas.write(buf);
            in = new MyInputStream(bas.getInputStream());
        } else {
            in = cds.tools.Util.openAnyStream(pathNpix);
        }
        try {
            Fits fits = new Fits();
            if ((in.getType() & 1L) != 0L) {
                fits.loadFITS(in);
            } else {
                fits.loadPreview(in);
            }
            int n = param == 0 ? fits.width : (param == 1 ? fits.depth : -1);
            return n;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void replaceKey(MyProperties prop, String oldKey, String key) {
        String s = prop.getProperty(key);
        if (s == null && prop.getProperty(oldKey) != null) {
            this.info("Replace properties key " + oldKey + " by " + key + " [" + s + "]");
            prop.replaceKey(oldKey, key);
        }
    }

    private void replaceKeys(MyProperties prop) {
        String v2;
        String s;
        this.replaceKey(prop, "hips_publisher", "hips_creator");
        this.replaceKey(prop, "HiPSBuilder", "hips_builder");
        this.replaceKey(prop, "label", "obs_title");
        this.replaceKey(prop, "description", "obs_title");
        this.replaceKey(prop, "verboseDescription", "obs_description");
        this.replaceKey(prop, "descriptionVerbose", "obs_description");
        this.replaceKey(prop, "acknowledgement", "obs_ack");
        this.replaceKey(prop, "copyright", "obs_copyright");
        this.replaceKey(prop, "copyrightUrl", "obs_copyright_url");
        this.replaceKey(prop, "cubeDepth", "hips_cube_depth");
        this.replaceKey(prop, "cubeFirstFrame", "hips_cube_firstframe");
        this.replaceKey(prop, "processingDate", "hips_release_date");
        this.replaceKey(prop, "pixelRange", "hips_data_range");
        this.replaceKey(prop, "pixelCut", "hips_pixel_cut");
        this.replaceKey(prop, "maxOrder", "hips_order");
        this.replaceKey(prop, "minOrder", "hips_order_min");
        this.replaceKey(prop, "format", "hips_tile_format");
        this.replaceKey(prop, "nside", "hips_tile_width");
        this.replaceKey(prop, "nbPixGeneratedImage", "hips_tile_width");
        this.replaceKey(prop, "category", "client_category");
        this.replaceKey(prop, "red", "hips_rgb_red");
        this.replaceKey(prop, "green", "hips_rgb_green");
        this.replaceKey(prop, "blue", "hips_rgb_blue");
        if (prop.getProperty("creator_did") == null) {
            s = prop.getProperty("publisher_did");
            if (s != null) {
                prop.insert("creator_did", s);
            } else {
                String obs_id;
                s = prop.getProperty("creator_id");
                if (s == null) {
                    s = prop.getProperty("publisher_id");
                }
                if (s == null) {
                    s = "ivo://UNK.AUT";
                }
                if ((obs_id = prop.getProperty("obs_id")) != null) {
                    String creator_did = s + "?" + obs_id;
                    prop.insert("creator_did", creator_did);
                }
            }
        }
        prop.remove("publisher_did");
        prop.remove("publisher_id");
        s = prop.getProperty("firstProcessingDate");
        if (s != null && prop.getProperty("hips_creation_date") == null) {
            try {
                v2 = Constante.sdf.format(HipsGen.SDF.parse(s)) + "Z";
                prop.replaceKey("firstProcessingDate", "hips_creation_date");
                prop.replaceValue("hips_creation_date", v2);
            }
            catch (ParseException v2) {
                // empty catch block
            }
        }
        if ((s = prop.getProperty("processingDate")) != null && prop.getProperty("hips_release_date") == null) {
            try {
                v2 = Constante.sdf.format(HipsGen.SDF.parse(s)) + "Z";
                prop.replaceKey("processingDate", "hips_release_date");
                if (!this.notouch) {
                    prop.replaceValue("hips_release_date", v2);
                }
            }
            catch (ParseException v3) {
                // empty catch block
            }
        }
        if ((s = prop.getProperty("coordsys")) != null && prop.getProperty("hips_frame") == null) {
            v2 = Context.getCanonicalFrameName(s);
            prop.setProperty("hips_frame", v2);
        }
        if ((s = prop.getProperty("target")) != null) {
            int i = s.indexOf(32);
            prop.setProperty("hips_initial_ra", s.substring(0, i));
            prop.setProperty("hips_initial_dec", s.substring(i + 1));
            prop.remove("target");
        }
        if ((s = prop.getProperty("targetRadius")) != null) {
            prop.replaceKey("targetRadius", "hips_initial_fov");
        }
        if ((s = prop.getProperty("isColor")) == null) {
            s = prop.getProperty("isColor");
        }
        if (s != null && s.equals("true") && prop.getProperty("dataproduct_subtype") == null) {
            prop.setProperty("dataproduct_subtype", "color");
        }
        if ((s = prop.getProperty("isCatalog")) != null && s.equals("true") && prop.getProperty("dataproduct_type") == null) {
            prop.setProperty("dataproduct_type", "catalog");
        }
        if ((s = prop.getProperty("isCube")) != null && s.equals("true") && prop.getProperty("dataproduct_type") == null) {
            prop.setProperty("dataproduct_type", "cube");
        }
        prop.remove("aladinVersion");
        prop.remove("lastModified");
        prop.remove("curTFormBitpix");
        prop.remove("nbPixGeneratedImage");
        prop.remove("ordering");
        prop.remove("isPartial");
        prop.remove("isColored");
        prop.remove("IAU");
        prop.remove("ARGB");
        prop.remove("typehpx");
        prop.remove("lenhpx");
        prop.remove("ttypes");
        prop.remove("tfields");
        prop.remove("tileOrder");
        prop.remove("nsideFile");
        prop.remove("nsidePixel");
        prop.remove("isMeta");
        prop.remove("isCatalog");
        prop.remove("sizeRecord");
        prop.remove("offset");
        prop.remove("gzipped");
        prop.remove("localData");
        prop.remove("dataPath");
        prop.remove("hips_glu_tag");
        prop.remove("imageSourcePath");
        prop.remove("orderGeneratedImgs");
        prop.remove("label");
        prop.remove("label");
        prop.remove("format");
        prop.remove("coordsys");
        prop.remove("maxOrder");
        prop.remove("pixelCut");
        prop.remove("pixelRange");
        prop.remove("isColor");
        prop.remove("isCube");
        prop.remove("cubeDepth");
        prop.remove("isColor");
    }

    protected void updateProperties(String[] key, String[] value, boolean overwrite) throws Exception {
        this.updateProperties(key, value, overwrite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperties(String[] key, String[] value, boolean overwrite, OutputStreamWriter stream) throws Exception {
        block39: {
            this.waitingPropertieFile();
            try {
                File dir;
                String propFile = this.getOutputPath() + cds.tools.Util.FS + "properties";
                this.prop = new MyProperties();
                File f = new File(propFile);
                if (f.exists()) {
                    if (!f.canRead()) {
                        throw new Exception("Propertie file not available ! [" + propFile + "]");
                    }
                    InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(propFile), "UTF-8");
                    this.prop.load(in);
                    in.close();
                }
                this.replaceKeys(this.prop);
                double[] coo = null;
                if (this.target == null) {
                    String ra = this.prop.get("hips_initial_ra");
                    String dec = this.prop.get("hips_initial_dec");
                    String fov = this.prop.get("hips_initial_fov");
                    if (ra == null || dec == null || fov == null) {
                        if (fov == null) {
                            block38: {
                                try {
                                    int n = Integer.parseInt(this.prop.get("moc_order"));
                                    SMoc mm = new SMoc();
                                    mm.setMocOrder(n);
                                    fov = mm.getAngularRes() + "";
                                }
                                catch (Exception e) {
                                    if (this.moc == null) break block38;
                                    fov = this.moc.getSpaceMoc().getAngularRes() + "";
                                }
                            }
                            this.prop.replaceValue("hips_initial_fov", fov);
                        }
                        if (ra == null || dec == null) {
                            if (this.moc != null) {
                                Healpix hpx = new Healpix();
                                if (this.moc.isFull()) {
                                    ra = "0";
                                    dec = "+0";
                                } else {
                                    try {
                                        int o = this.moc.getSpaceOrder();
                                        long pix = this.moc.getSpaceMoc().valIterator().next();
                                        coo = hpx.pix2ang(o, pix);
                                        ra = coo[0] + "";
                                        dec = coo[1] + "";
                                    }
                                    catch (Exception o) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.prop.replaceValue("hips_initial_ra", ra);
                            this.prop.replaceValue("hips_initial_dec", dec);
                        }
                    }
                }
                for (int i = 0; i < key.length; ++i) {
                    String v;
                    if (!this.notouch && key[i].equals("hips_release_date") && this.prop.getProperty("hips_creation_date") == null && (v = this.prop.getProperty("hips_release_date")) != null) {
                        this.prop.setProperty("hips_creation_date", v);
                    }
                    if (key[i].charAt(0) == '#' && this.prop.getProperty(key[i].substring(1)) != null) continue;
                    if (overwrite) {
                        if (value[i] == null) {
                            this.prop.remove(key[i]);
                        } else if (value[i] != null) {
                            this.prop.setProperty(key[i], value[i]);
                        }
                    } else {
                        v = this.prop.getProperty(key[i]);
                        if (v == null && value[i] != null) {
                            this.prop.setProperty(key[i], value[i]);
                        } else if (key[i].equals("hips_data_minmax") && value[i] != null) {
                            this.prop.replaceValue(key[i], value[i]);
                        }
                    }
                    if (value[i] == null || key[i].charAt(0) == '#' || this.prop.getProperty("#" + key[i]) == null) continue;
                    this.prop.remove("#" + key[i]);
                }
                if (this.scriptCommand != null) {
                    int n = 0;
                    while (this.prop.getProperty("hipsgen_params" + (n == 0 ? "" : "_" + n)) != null) {
                        ++n;
                    }
                    this.prop.add("hipsgen_date" + (n == 0 ? "" : "_" + n), Context.getNow());
                    this.prop.add("hipsgen_params" + (n == 0 ? "" : "_" + n), this.scriptCommand);
                    this.scriptCommand = null;
                }
                while (this.prop.removeComment(FORCOMPATIBILITY)) {
                }
                if (stream != null) {
                    this.prop.store(stream, null);
                    break block39;
                }
                String tmp = this.getOutputPath() + cds.tools.Util.FS + "properties" + ".tmp";
                File ftmp = new File(tmp);
                if (ftmp.exists()) {
                    ftmp.delete();
                }
                if (!(dir = new File(this.getOutputPath())).exists() && !dir.mkdir()) {
                    throw new Exception("Cannot create output directory");
                }
                try (OutputStreamWriter out = null;){
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(ftmp), "UTF-8");
                    this.prop.store(out, null);
                }
                if (f.exists() && !f.delete()) {
                    throw new Exception("Propertie file locked ! (cannot delete)");
                }
                if (!ftmp.renameTo(new File(propFile))) {
                    throw new Exception("Propertie file locked ! (cannot rename)");
                }
            }
            finally {
                this.releasePropertieFile();
            }
        }
    }

    protected void loadProperties() throws Exception {
        this.loadProperties(this.getOutputPath());
    }

    protected void loadProperties(String path) throws Exception {
        this.prop = new MyProperties();
        this.loadProperties(this.prop, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(MyProperties prop, String path) throws Exception {
        this.waitingPropertieFile();
        try {
            String propFile = path + cds.tools.Util.FS + "properties";
            File f = new File(propFile);
            if (f.exists()) {
                if (!f.canRead()) {
                    throw new Exception("Propertie file not available ! [" + propFile + "]");
                }
                InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
                prop.load(in, this.flagFirstPropertiesLoad, false);
                in.close();
                this.replaceKeys(prop);
                if (this.flagFirstPropertiesLoad) {
                    this.flagFirstPropertiesLoad = false;
                    if (!BuilderLint.checkPropertiesSyntax(prop, true, this)) {
                        this.warning("Probably corrupted original properties fields (split lines ?) => check it manually");
                    }
                }
            }
        }
        finally {
            this.releasePropertieFile();
        }
    }

    private void waitingPropertieFile() {
        while (!this.getLock()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void releasePropertieFile() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    protected double[] gal2ICRSIfRequired(double al, double del) {
        return this.gal2ICRSIfRequired(new double[]{al, del});
    }

    protected double[] gal2ICRSIfRequired(double[] aldel) {
        if (this.getFrame() == 0) {
            return aldel;
        }
        Astrocoo coo = (Astrocoo)COO_GAL.clone();
        coo.set(aldel[0], aldel[1]);
        coo.convertTo(AF_ICRS1);
        aldel[0] = coo.getLon();
        aldel[1] = coo.getLat();
        return aldel;
    }

    protected double[] ICRS2galIfRequired(double al, double del) {
        return this.ICRS2galIfRequired(new double[]{al, del});
    }

    protected double[] ICRS2galIfRequired(double[] aldel) {
        if (this.getFrame() == 0) {
            return aldel;
        }
        Astrocoo coo = (Astrocoo)COO_EQU.clone();
        coo.set(aldel[0], aldel[1]);
        coo.convertTo(AF_GAL1);
        aldel[0] = coo.getLon();
        aldel[1] = coo.getLat();
        return aldel;
    }

    private void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                this.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    public void createHealpixOrder(int order) {
        int nside = (int)CDSHealpix.pow2(order);
        if (this.xy2hpx != null && this.xy2hpx.length == nside * nside) {
            return;
        }
        this.xy2hpx = new int[nside * nside];
        this.hpx2xy = new int[nside * nside];
        this.fillUp(this.xy2hpx, nside, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int hpxOffset) {
        return this.xy2hpx[hpxOffset];
    }

    public final int hpx2xy(int xyOffset) {
        return this.hpx2xy[xyOffset];
    }

    public long getMem() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    protected void updateHeader(Fits fits, BuilderRunner.AddrThread addr) {
        if (fits.headerFits == null) {
            return;
        }
        if (this.creator != null) {
            fits.headerFits.setKeyValue("ORIGIN", this.creator);
        }
        fits.headerFits.setKeyValue("CPYRIGHT", "See HiPS properties file");
        fits.headerFits.setKeyValue("COMMENT", "HiPS FITS tile generated by Aladin/Hipsgen v12.646");
        fits.headerFits.setKeyValue("ORDER", "" + addr.order);
        fits.headerFits.setKeyValue("NPIX", "" + addr.npix);
        if (addr.orderZ != -1) {
            fits.headerFits.setKeyValue("FORDER", "" + addr.orderZ);
            fits.headerFits.setKeyValue("FPIX", "" + addr.npixZ);
        }
        try {
            this.tile2Hpx = new Tile2HPX(addr.order, fits.width, this.frame == 0 ? Tile2HPX.WCSFrame.EQU : (this.frame == 2 ? Tile2HPX.WCSFrame.ECL : Tile2HPX.WCSFrame.GAL));
            Map<String, String> map = this.tile2Hpx.toFitsHeader(addr.npix);
            for (Map.Entry<String, String> e : map.entrySet()) {
                String key = e.getKey().trim();
                if (key.equals("NAXIS")) continue;
                String val = e.getValue();
                int i = val.indexOf(47);
                if (i > 0) {
                    val = val.substring(0, i).trim();
                }
                fits.headerFits.setKeyValue(key, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isHips3D) {
            try {
                int orderZTile = this.getTileOrderFreq();
                fits.headerFits.setKeyValue("CTYPE3", "FREQ-LOG");
                fits.headerFits.setKeyValue("CUNIT3", "Hz");
                long npixFullFrequence = addr.npixZ * CDSHealpix.pow2(orderZTile);
                long crpix = 1L - npixFullFrequence;
                fits.headerFits.setKeyValue("CRPIX3", "" + crpix);
                double crval = 1.0E-18;
                fits.headerFits.setKeyValue("CRVAL3", "" + crval);
                double cdelt = crval * (Math.log(9.999999999999999E55) / Math.pow(2.0, addr.orderZ + orderZTile));
                if (fits.headerFits.hasKey("CD1_1")) {
                    fits.headerFits.setKeyValue("CD1_3", "0");
                    fits.headerFits.setKeyValue("CD2_3", "0");
                    fits.headerFits.setKeyValue("CD3_1", "0");
                    fits.headerFits.setKeyValue("CD3_2", "0");
                    fits.headerFits.setKeyValue("CD3_3", "" + cdelt);
                } else {
                    fits.headerFits.setKeyValue("CDELT3", "" + cdelt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resetMetrics() {
        this.setPropriete("hips_check_code", null);
        this.setPropriete("hips_estsize", null);
        this.setPropriete("hips_nb_tiles", null);
    }

    public void resetCheckCode() {
        this.hipsCheckCode = null;
        this.resetMetrics();
    }

    public void resetCheckCode(String fmt) {
        this.hipsCheckCode = Context.resetCheckCode(fmt, this.hipsCheckCode);
        this.resetMetrics();
    }

    public void addCheckCode(String fmt, int checkCode) {
        this.hipsCheckCode = Context.addCheckCode(fmt, checkCode, this.hipsCheckCode);
    }

    public static String getCheckCode(String fmt, String hipsCheckCode) {
        if (hipsCheckCode == null) {
            return null;
        }
        Tok tok = new Tok(hipsCheckCode, " ,");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (!s.startsWith(fmt + ":")) continue;
            return s.substring(fmt.length() + 1);
        }
        return null;
    }

    public static ArrayList<String> getCheckCodeFmt(String hipsCheckCode) {
        ArrayList<String> res = new ArrayList<String>(10);
        if (hipsCheckCode == null) {
            return res;
        }
        Tok tok = new Tok(hipsCheckCode, " ,");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            int o = s.indexOf(58);
            if (o == -1) continue;
            res.add(s.substring(0, o));
        }
        return res;
    }

    public static String resetCheckCode(String fmt, String hipsCheckCode) {
        if (hipsCheckCode == null) {
            return null;
        }
        StringBuilder r = null;
        Tok tok = new Tok(hipsCheckCode, " ,");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.startsWith(fmt + ":")) continue;
            if (r == null) {
                r = new StringBuilder();
            } else {
                r.append(' ');
            }
            r.append(s);
        }
        return r.toString();
    }

    public static String addCheckCode(String fmt, int checkCode, String hipsCheckCode) {
        hipsCheckCode = Context.resetCheckCode(fmt, hipsCheckCode);
        return (hipsCheckCode == null ? "" : hipsCheckCode + " ") + fmt + ":" + checkCode;
    }

    static {
        DATEFORMAT = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        COO_GAL = new Astrocoo(Astroframe.create("GALACTIC"));
        COO_EQU = new Astrocoo(Astroframe.create("ICRS"));
        AF_GAL1 = Astroframe.create("GALACTIC");
        AF_ICRS1 = Astroframe.create("ICRS");
    }
}

