/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.BuilderCheckDataSum;
import cds.hipsgen.Context;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.Task;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class BuilderValidator
extends Builder {
    private static int SUFFIXE = 0;
    private static boolean ALLTEST = true;
    private static int OUTPUTBITPIX = -32;
    private static int INPUTBITPIX = -32;
    private static double BLANK = 0.0;
    private static double RA = 90.0;
    private static double DEC = 41.0;
    private static double FREQ = 1.4E9;
    private static long GLOBALDATASUMARITHM = 3199876792L;
    private static long GLOBALDATASUM = 2002421326L;
    private static long TIMETILEREF = 154158L;
    String path;
    String input;
    String output;
    long globalDatasum = -1L;
    long timeFitsTiles = -1L;
    long timePngTiles = -1L;

    public BuilderValidator(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.VALIDATOR;
    }

    private Builder execute(Action a) throws Exception {
        Builder b = Task.factoryRunner(this.context, a);
        if (this.context.isTaskAborting()) {
            throw new Exception("Aborting");
        }
        return b;
    }

    @Override
    public void run() throws Exception {
        this.path = this.context.getOutputPath();
        this.validate("fits");
        if (ALLTEST) {
            this.context.valid("FINAL REPORT");
            if (this.globalDatasum != GLOBALDATASUM) {
                this.context.error("Global DATASUM not matching => Hips modifications");
            } else {
                this.context.info("The HiPS is conformed");
            }
            this.context.info("TimeFitsTile:" + this.timeFitsTiles + " (ref=" + TIMETILEREF + ")");
            if (this.timeFitsTiles - TIMETILEREF > 0L && (double)(this.timeFitsTiles - TIMETILEREF) > 0.5 * (double)TIMETILEREF) {
                this.context.warning("Fits tile generation seems to be slower than before (" + this.getFct(this.timeFitsTiles, TIMETILEREF) + ")");
            } else if (TIMETILEREF - this.timeFitsTiles > 0L && (double)(TIMETILEREF - this.timeFitsTiles) > 0.5 * (double)TIMETILEREF) {
                this.context.info("Fits tile generation seems to be faster than before (" + this.getFct(TIMETILEREF, this.timeFitsTiles) + ")");
            }
        }
    }

    public void validateTrim() throws Exception {
        this.input = this.path + Util.FS + "DataTrim";
        cds.tools.Util.deleteDir(new File(this.input));
        cds.tools.Util.createPath(this.input);
        Fits f = new Fits(512, 512, -32);
        f.initBlank();
        for (int y = 100; y < 200; ++y) {
            for (int x = 150; x < 250; ++x) {
                f.setPixelDouble(x, y, x + y);
            }
        }
        String filename = this.input + Util.FS + "file1.fits";
        String datasum = f.addDataSum();
        f.writeFITS(filename);
        Fits trim = f.trimFactory();
        String filetrim = this.input + Util.FS + "trim1.fits";
        trim.writeFITS(filetrim);
        Fits f1 = new Fits(filetrim);
        String filename2 = this.input + Util.FS + "file2.fits";
        f1.writeFITS(filename2);
        String datasum1 = f1.addDataSum();
        if (!datasum.equals(datasum1)) {
            System.out.println("Les pixels ne sont pas identiques");
        }
    }

    public void validateArith() throws Exception {
        this.context.valid("Arithmetic HiPS generation...");
        String fmt = "fits";
        this.context.reset();
        this.output = this.path + Util.FS + "HipsA";
        this.context.valid("Generation HipsADD in " + this.output + "....");
        this.input = this.path + Util.FS + "DataAdd";
        this.context.setInputPath(this.input);
        cds.tools.Util.deleteDir(new File(this.input));
        cds.tools.Util.createPath(this.input);
        this.createImg(this.input, fmt, 1000, 500, RA, DEC, 100.0, false);
        this.createImg(this.input, fmt, 1000, 500, RA + 0.2, DEC + 0.2, 200.0, false);
        this.context.setOutputPath(this.output);
        cds.tools.Util.deleteDir(new File(this.output));
        this.context.setPixelCut("0 300");
        this.context.setMode("add");
        this.execute(Action.INDEX);
        this.context.setBitpix(OUTPUTBITPIX);
        this.execute(Action.TILES);
        this.context.reset();
        this.output = this.path + Util.FS + "HipsTime";
        this.context.valid("Generation HipsTime in " + this.output + "....");
        this.input = this.path + Util.FS + "DataTime";
        this.context.setInputPath(this.input);
        cds.tools.Util.deleteDir(new File(this.input));
        cds.tools.Util.createPath(this.input);
        this.createImg(this.input, fmt, 1000, 1000, RA - 0.5, DEC, 3.0, false);
        this.createImg(this.input, fmt, 1000, 1000, RA - 0.5 + 0.1, DEC + 0.1, 2.0, false);
        this.context.setOutputPath(this.output);
        cds.tools.Util.deleteDir(new File(this.output));
        this.context.setMode("add");
        this.context.setPixelCut("0 5");
        this.execute(Action.INDEX);
        this.context.setBitpix(OUTPUTBITPIX);
        this.execute(Action.TILES);
        this.context.reset();
        this.input = this.path + Util.FS + "HipsTime";
        this.context.setInputPath(this.input);
        this.output = this.path + Util.FS + "HipsA";
        this.context.setOutputPath(this.output);
        this.context.valid("Concat " + this.input + " in " + this.output + " by division....");
        this.context.setMode("div");
        this.execute(Action.CONCAT);
        this.context.flagGlobalDataSum = true;
        BuilderCheckDataSum b = (BuilderCheckDataSum)this.execute(Action.CHECKDATASUM);
        this.globalDatasum = b.getDataGlobalDataSum();
        if (GLOBALDATASUMARITHM != this.globalDatasum) {
            this.context.error("Global DATASUM not matching !");
            throw new Exception("Global DATASUM not matching !");
        }
        this.context.valid("Arithmetic HiPS OK");
    }

    public void validateCube() throws Exception {
        this.context.reset();
        this.createProgenitorsCube();
        this.output = this.path + Util.FS + "HipsCube";
        this.context.setOutputPath(this.output);
    }

    public void validate(String fmt) throws Exception {
        boolean flagColor = !fmt.equals("fits");
        this.context.reset();
        this.createProgenitors(fmt);
        this.output = this.path + Util.FS + "Hips" + fmt;
        this.context.setOutputPath(this.output);
        cds.tools.Util.deleteDir(new File(this.output));
        if (!flagColor) {
            this.context.setFov("true");
            this.context.setDataRange("0 1000");
            this.context.setPixelCut("5 256");
            this.context.setLive(true);
        }
        this.context.valid("INDEX (HpxFinder) in " + this.output + "....");
        this.execute(Action.INDEX);
        this.context.valid("TILES in " + this.output + "....");
        this.context.setBitpix(flagColor ? 0 : OUTPUTBITPIX);
        Builder b1 = this.execute(Action.TILES);
        this.timeFitsTiles = b1.getExecTime();
        this.context.valid("TILES redo (KEEPTILE) after deleting Norder0 in " + this.output + "....");
        cds.tools.Util.deleteDir(new File(this.output + Util.FS + "Norder0"));
        this.context.setModeMerge(ModeMerge.mergeKeepTile);
        Builder b2 = this.execute(Action.TILES);
        this.context.info("time1=" + this.timeFitsTiles + " time2=" + b2.getExecTime());
        this.context.valid("TILES again (OVERWRITE, KEEP, ADD, MEAN) in " + this.output + "....");
        double dd = -0.7;
        double a = 0.22;
        this.validateUpdate(fmt, "overwrite", dd);
        this.validateUpdate(fmt, "keep", dd -= a);
        this.validateUpdate(fmt, "add", dd -= a);
        this.validateUpdate(fmt, "mergeAdd,overlayMean", dd -= a);
        this.validateUpdate(fmt, "mean", dd -= a);
        this.validateUpdate(fmt, "mean,fading", dd -= a);
        dd -= a;
        this.context.valid("APPEND (OVERWRITE,KEEP,ADD,MEAN,MUL) in " + this.output + "....");
        dd = 0.7;
        this.validateAppend(fmt, "overwrite", dd);
        this.validateAppend(fmt, "keep", dd += a);
        this.validateAppend(fmt, "add", dd += a);
        this.validateAppend(fmt, "mergeAdd,overlayMean", dd += a);
        this.validateAppend(fmt, "mean", dd += a);
        dd += a;
        if (!flagColor) {
            this.validateAppend(fmt, "mul,first", dd);
        }
        dd += a;
        this.context.valid("DETAILS in " + this.output + "....");
        this.execute(Action.DETAILS);
        if (!flagColor) {
            this.context.valid("PNG in " + this.output + "....");
            this.execute(Action.PNG);
        }
        this.context.valid("LINT " + this.output + "....");
        this.execute(Action.LINT);
        this.context.valid("CHECKCODE and DATASUM in " + this.output + "....");
        this.execute(Action.CHECKCODE);
        this.execute(Action.CHECK);
        if (!flagColor) {
            this.context.flagGlobalDataSum = true;
            BuilderCheckDataSum b = (BuilderCheckDataSum)this.execute(Action.CHECKDATASUM);
            this.globalDatasum = b.getDataGlobalDataSum();
        }
    }

    private String getFct(double v1, double v2) {
        return "x" + (double)((int)(v1 / v2 * 100.0)) / 100.0;
    }

    private void validateUpdate(String fmt, String mode, double shiftDec) throws Exception {
        this.context.reset();
        this.context.setOutputPath(this.output);
        this.context.setPartitioning("300");
        this.context.setBitpix(fmt.equals("fits") ? OUTPUTBITPIX : 0);
        this.execute(Action.CLEANINDEX);
        this.createProgenitorBis(fmt, shiftDec);
        this.context.setMode(mode);
        this.execute(Action.INDEX);
        this.execute(Action.TILES);
    }

    private void validateAppend(String fmt, String mode, double shiftDec) throws Exception {
        this.createProgenitorBis(fmt, shiftDec);
        this.context.setMode(mode);
        this.execute(Action.APPEND);
    }

    private void createProgenitorsCube() throws Exception {
        this.input = this.path + Util.FS + "DataCube";
        this.context.setInputPath(this.input);
        this.context.info("(Re)creating cube fits data (progenitors) in " + this.input + "....");
        cds.tools.Util.deleteDir(new File(this.input));
        cds.tools.Util.createPath(this.input);
        this.createCube(this.input, 800, 500, 300, RA, DEC, FREQ, 255.0);
        this.createCube(this.input, 800, 500, 300, RA - 1.0, DEC - 0.5, FREQ, 100.0);
    }

    private void createProgenitors(String fmt) throws Exception {
        int i;
        this.input = this.path + Util.FS + "Data" + fmt;
        this.context.setInputPath(this.input);
        this.context.info("(Re)creating " + fmt + " data (progenitors) in " + this.input + "....");
        cds.tools.Util.deleteDir(new File(this.input));
        cds.tools.Util.createPath(this.input);
        String s = this.createImg(this.input, fmt, 1500, 500, RA, DEC, 255.0, true);
        this.createFov(s, 1500, 500);
        for (i = 0; i < 12; ++i) {
            this.createImg(this.input, fmt, 800, 2800, RA + 0.02, DEC + 0.02, 145.0, true);
        }
        if (ALLTEST) {
            for (i = 0; i < 50; ++i) {
                this.createImg(this.input, fmt, 100, 100, RA - 0.85, DEC + 0.42, 80.0, false);
            }
            for (i = 0; i < 200; ++i) {
                this.createImg(this.input, fmt, 100, 100, RA + 0.85, DEC - 0.42, 50.0, false);
            }
            for (i = 0; i < 1440; i += 5) {
                this.createImg(this.input, fmt, 300, 300, RA + ((double)i / 50.0 + 3.0) * Math.cos(Math.PI * (double)i / 180.0), DEC + ((double)i / 100.0 + 3.0) * Math.sin(Math.PI * (double)i / 180.0), i / 10, false);
            }
        }
    }

    private void createProgenitorBis(String fmt, double deltaDec) throws Exception {
        this.input = this.path + Util.FS + "Data" + fmt + "bis";
        this.context.setInputPath(this.input);
        this.context.info("(Re)creating " + fmt + " (progenitors) in " + this.input + "....");
        cds.tools.Util.deleteDir(new File(this.input));
        cds.tools.Util.createPath(this.input);
        this.createImg(this.input, fmt, 3000, 100, RA, DEC - deltaDec, 45.0, true);
        this.createImg(this.input, fmt, 75, 75, RA - 3.2, DEC - deltaDec, 10.0, false);
    }

    private void createFov(String filename, int width, int height) throws Exception {
        filename = filename.substring(0, filename.lastIndexOf(46)) + ".fov";
        FileOutputStream os = null;
        os = new FileOutputStream(filename);
        ((OutputStream)os).write("10 10\n".getBytes());
        ((OutputStream)os).write((width - 30 + " 30\n").getBytes());
        ((OutputStream)os).write((width - 10 + " " + (height - 8) + "\n").getBytes());
        ((OutputStream)os).write(("50 " + (height - 40) + "\n").getBytes());
        ((OutputStream)os).write(("100 " + height / 2 + "\n").getBytes());
        ((OutputStream)os).close();
    }

    private String createImg(String input, String fmt, int width, int height, double ra, double dec, double value, boolean flagAdvanced) throws Exception {
        boolean flagColor = !fmt.equals("fits");
        int bitpix = flagColor ? 0 : INPUTBITPIX;
        Fits f = new Fits(width, height, bitpix);
        f.setBlank(flagColor ? 0.0 : BLANK);
        StringBuilder s = new StringBuilder();
        s.append("SIMPLE=T\n");
        s.append("BITPIX=" + bitpix + "\n");
        s.append("NAXIS=2\n");
        s.append("NAXIS1=" + f.width + "\n");
        s.append("NAXIS2=" + f.height + "\n");
        s.append("CRPIX1=" + f.width / 2 + "\n");
        s.append("CRPIX2=" + f.height / 2 + "\n");
        s.append("CRVAL1=" + ra + "\n");
        s.append("CRVAL2=" + dec + "\n");
        s.append("CTYPE1=RA---SIN\n");
        s.append("CTYPE2=DEC--SIN\n");
        s.append("RADECSYS=FK5\n");
        s.append("CD1_1=-0.0016667\n");
        s.append("CD1_2=0\n");
        s.append("CD2_1=0\n");
        s.append("CD2_2=0.0016667\n");
        f.headerFits = new HeaderFits(s.toString());
        f.headerFits.setOriginalHeaderFits(s.toString());
        for (int y = 0; y < f.height; ++y) {
            for (int x = 0; x < f.width; ++x) {
                if (flagColor) {
                    int v = (int)value;
                    int p = !flagAdvanced ? v : (x < f.width / 3 ? v : (x < 2 * f.width / 3 ? v << 8 : v << 16));
                    int rgb = 0xFF000000 | p;
                    f.setPixelRGB(x, y, rgb);
                    continue;
                }
                double p = !flagAdvanced ? value : (x < f.width / 3 ? value / 3.0 : (x < 2 * f.width / 3 ? 2.0 * value / 3.0 : value));
                f.setPixelDouble(x, y, p);
            }
        }
        if (flagAdvanced) {
            int x;
            int y;
            int c = 30;
            int ymid = f.height / 2 - 1;
            int xmid = f.width / 2 - 1;
            for (y = ymid - c; y <= ymid + c; ++y) {
                for (x = xmid - c * 3; x < xmid + c * 3; ++x) {
                    if (y == ymid && x == xmid) continue;
                    if (flagColor) {
                        f.setPixelRGB(x, y, 0);
                        continue;
                    }
                    f.setPixelDouble(x, y, BLANK);
                }
            }
            for (y = 0; y < c; ++y) {
                for (x = 0; x < c; ++x) {
                    if (flagColor) {
                        int p = x * y / 3;
                        if (p > 255) {
                            p = 255;
                        }
                        int p1 = 0xFF000000 | (0xFF & 255 - p) << 8 | 0xFF & p;
                        f.setPixelRGB(10 + c + x, 10 + c + y, p1);
                        f.setPixelRGB(f.width - c - 10 - x, f.height - c - 10 - y, p1);
                        continue;
                    }
                    double p = x * y / 3;
                    if (p > 255.0) {
                        p = 255.0;
                    }
                    f.setPixelDouble(10 + c + x, 10 + c + y, p);
                    f.setPixelDouble(f.width - c - 10 - x, f.height - c - 10 - y, p);
                }
            }
        }
        String filename = input + Util.FS + "Image" + ++SUFFIXE + "." + fmt;
        if (fmt.equals("fits")) {
            f.writeFITS(filename);
        } else if (fmt.equals("png")) {
            f.writePng(filename);
        } else {
            f.writeJpg(filename);
        }
        return filename;
    }

    private String createCube(String input, int width, int height, int depth, double ra, double dec, double freq, double value) throws Exception {
        int bitpix = INPUTBITPIX;
        Fits f = new Fits(width, height, depth, bitpix);
        f.setBlank(BLANK);
        StringBuilder s = new StringBuilder();
        s.append("SIMPLE=T\n");
        s.append("BITPIX=" + bitpix + "\n");
        s.append("NAXIS=3\n");
        s.append("NAXIS1=" + f.width + "\n");
        s.append("NAXIS2=" + f.height + "\n");
        s.append("NAXIS3=" + f.depth + "\n");
        s.append("CRPIX1=" + f.width / 2 + "\n");
        s.append("CRPIX2=" + f.height / 2 + "\n");
        s.append("CRPIX3=" + f.depth / 2 + "\n");
        s.append("CRVAL1=" + ra + "\n");
        s.append("CRVAL2=" + dec + "\n");
        s.append("CRVAL3=" + freq + "\n");
        s.append("CTYPE1=RA---SIN\n");
        s.append("CTYPE2=DEC--SIN\n");
        s.append("CTYPE3=FREQ\n");
        s.append("UNIT3=FREQ\n");
        s.append("CDELT3=1.22070312500E+04\n");
        s.append("RADECSYS=FK5\n");
        s.append("CD1_1=-0.0016667\n");
        s.append("CD1_2=0\n");
        s.append("CD1_3=0\n");
        s.append("CD2_1=0\n");
        s.append("CD2_2=0.0016667\n");
        s.append("CD2_3=0\n");
        s.append("CD3_1=0\n");
        s.append("CD3_2=0\n");
        s.append("CD3_3=1.22070312500E+04\n");
        f.headerFits = new HeaderFits(s.toString());
        f.headerFits.setOriginalHeaderFits(s.toString());
        for (int y = 0; y < f.height; ++y) {
            for (int x = 0; x < f.width; ++x) {
                for (int z = 0; z < f.depth; ++z) {
                    double p = x % 20 == 3 && y % 30 == 3 ? value * (double)(z + 10) : (x > 10 && x < 25 && y > 20 && y < 30 && z > 5 && z < 25 ? value * 5.0 : (x > f.width / 2 && y > f.height / 2 ? (double)((z + x + y) % 3000) : value));
                    f.setPixelDouble(x, y, z, p);
                }
            }
        }
        String filename = input + Util.FS + "Cube" + ++SUFFIXE + ".fits";
        f.writeFITS(filename);
        return filename;
    }

    private void checkFits(String filename, double[][] xyv) throws Exception {
        boolean rep = true;
        Fits f = new Fits(filename);
        for (double[] xyv1 : xyv) {
            boolean ok;
            int x = (int)(xyv1[0] - 0.5);
            int y = (int)(xyv1[1] - 0.5);
            double p = f.getPixelFull(x, y);
            boolean bl = ok = f.isBlankPixel(p) && Double.isNaN(xyv1[2]) || p == xyv1[2];
            if (rep &= ok) continue;
            this.context.error("checkFits on " + filename + " (" + x + "," + y + ")=" + p + (ok ? " ok" : " error (should be " + xyv1[2] + ")"));
        }
        if (!rep) {
            throw new Exception("The generated HiPS does not match!");
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }
}

