/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderCheckCode;
import cds.hipsgen.Context;
import java.io.File;

public class BuilderUpdateDataSum
extends BuilderCheckCode {
    public BuilderUpdateDataSum(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.UPDATEDATASUM;
    }

    @Override
    protected void validateContextMore() throws Exception {
        String s = this.context.prop.getProperty("hips_status");
        if (s.indexOf("master") <= 0) {
            throw new Exception((Object)((Object)this.getAction()) + " only authorized on HiPS master");
        }
        if (this.format.indexOf("fits") < 0) {
            throw new Exception("No Fits tiles for this HiPS!");
        }
    }

    @Override
    public void run() throws Exception {
        this.context.loadProperties();
        this.scanDir(new File(this.context.getOutputPath()), "fits");
        this.context.writePropertiesFile();
        this.context.info("All DATASUM generated/updated");
    }

    @Override
    protected void updateInfo(File f, BuilderCheckCode.Info info) throws Exception {
        super.updateInfo(f, info);
        String filename = f.getAbsolutePath();
        Fits fits = new Fits();
        fits.loadFITS(filename);
        fits.addDataSum();
        fits.writeFITS(filename);
    }
}

