/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.MyInputStream;
import cds.aladin.Tok;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.BuilderGunzip;
import cds.hipsgen.BuilderMirror;
import cds.hipsgen.BuilderMoc;
import cds.hipsgen.BuilderMocIndex;
import cds.hipsgen.BuilderTree;
import cds.hipsgen.BuilderUpdateDataSum;
import cds.hipsgen.Context;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.Task;
import cds.moc.Moc;
import cds.moc.SFMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;
import java.io.FileInputStream;

public class BuilderUpdate
extends Builder {
    private Builder b = null;
    private String[] OLD = new String[]{"properties", "index.html"};

    public BuilderUpdate(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.UPDATE;
    }

    @Override
    public void supportHiPS3D() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.fillupContext();
        if (!this.context.isTaskAborting()) {
            this.builderMoc();
        }
        if (!this.context.isTaskAborting()) {
            this.builderDataSum();
        }
        if (!this.context.isTaskAborting()) {
            this.builderLowOrder();
        }
        if (!this.context.isTaskAborting()) {
            this.builderCheck();
        }
        if (!this.context.isTaskAborting()) {
            this.context.writeMetaFile();
        }
    }

    private void fillupContext() throws Exception {
        int[] minmax;
        boolean live;
        boolean color;
        this.context.loadProperties();
        String s = this.context.prop.getProperty("dataproduct_subtype");
        boolean bl = color = s != null && s.indexOf("color") >= 0;
        if (color) {
            this.context.setColor("true");
        }
        boolean bl2 = live = s != null && s.indexOf("live") >= 0;
        if (live) {
            this.context.setLive(live);
        }
        if ((minmax = this.context.findMinMaxOrder())[0] == -1) {
            throw new Exception("No HiPS found in target dir [" + this.context.getOutputPath() + "] !");
        }
        this.context.setOrder(minmax[1]);
        if (this.context.isHips3D) {
            int tiledepthByNpixFile = this.context.getTileDepthByNpixFile(this.context.getOutputPath());
            this.context.setTileDepth(tiledepthByNpixFile);
        } else {
            int depth = 1;
            s = this.context.prop.getProperty("hips_cube_depth");
            try {
                depth = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.context.setDepth(depth);
        }
        s = this.context.prop.getProperty("hips_frame");
        try {
            int frame = Context.getFrameVal(s);
            if (frame >= 0) {
                this.context.setFrame(frame);
            }
        }
        catch (Exception frame) {
            // empty catch block
        }
        s = this.context.prop.getProperty("hips_status");
        if (s != null) {
            this.context.setStatus(s);
        }
        int tileSideByNpixFile = this.context.getTileWidthByNpixFile(this.context.getOutputPath());
        this.context.setTileOrder((int)CDSHealpix.log2(tileSideByNpixFile));
        this.context.initRegion();
    }

    private void keepOldCopy() throws Exception {
        String path = this.context.getOutputPath();
        for (String f : this.OLD) {
            this.keepOldCopy(path + Util.FS + f);
        }
    }

    private void keepOldCopy(String f) throws Exception {
        if (!new File(f).exists()) {
            return;
        }
        File max = new File(f + ".9");
        if (max.exists()) {
            max.delete();
        }
        for (int i = 9; i > 1; --i) {
            File fo = new File(f + (i == 1 ? "" : "." + (i - 1)));
            if (!fo.exists()) continue;
            fo.renameTo(new File(f + "." + i));
        }
        BuilderMirror.copyLocal(f, f + ".1");
    }

    private void builderDataSum() throws Exception {
        Fits f = new Fits();
        try {
            f.loadFITS(Context.findOneNpixFile(this.context.getOutputPath()));
        }
        catch (Exception e) {
            return;
        }
        if (f.headerFits.hasKey("DATASUM")) {
            this.context.info("DATASUM seems to be already present in tiles (to update them use \"UPDATEDATASUM\" action)");
            return;
        }
        this.context.info("Scanning and adding DATASUM on FITS tiles...");
        this.b = new BuilderUpdateDataSum(this.context);
        this.b.run();
        this.context.done("Datasum done");
        this.b = null;
    }

    private void builderCheck() throws Exception {
        if (this.context.getCheckCodeFromProp() != null) {
            this.context.info("Checkcodes already present (to update them use \"CHECKCODE\" action)");
            return;
        }
        this.context.info("Adding check codes...");
        Task.factoryRunner(this.context, Action.CHECKCODE);
        this.context.writePropertiesFile();
        this.context.done("Check code done");
        this.b = null;
    }

    private void builderGunzip() throws Exception {
        boolean isGZ = false;
        try (MyInputStream in = null;){
            in = new MyInputStream(new FileInputStream(Context.findOneNpixFile(this.context.getOutputPath())));
            isGZ = in.isGZ();
        }
        if (!isGZ) {
            this.context.info("Tiles seem to be already gunzipped (use \"GUNZIP\" to be sure)");
            return;
        }
        this.context.info("Scanning and gunzipping required tiles (order<=5) if required...");
        this.b = new BuilderGunzip(this.context);
        this.b.run();
        if (((BuilderGunzip)this.b).nbFile == 0) {
            this.context.info("Nothing gzipped");
        } else {
            this.context.done("Gunzip done");
        }
        this.b = null;
    }

    private void builderMoc() throws Exception {
        Moc moc;
        String mocPath;
        try {
            mocPath = this.context.getOutputPath() + Util.FS + "Moc.fits";
            moc = Moc.createMoc(new FileInputStream(mocPath));
            if (moc.getSpaceOrder() == 29) {
                this.context.info("Suspicious MOC order (29) !");
                throw new Exception();
            }
            if (moc instanceof SFMoc && moc.getProperty("MOCTOOL").indexOf("CDSjavaAPI-7.3") >= 0) {
                this.context.info("Deprecated MOC (SFMOC proto 7.3)");
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
        }
        if (this.context.isExistingIndexDir()) {
            try {
                mocPath = this.context.getHpxFinderPath() + Util.FS + "Moc.fits";
                moc = Moc.createMoc(new FileInputStream(mocPath));
                if (moc.getSpaceOrder() == 29) {
                    this.context.info("Suspicious hpxFinder MOC order (29) !");
                    throw new Exception();
                }
                if (moc instanceof SFMoc && moc.getProperty("MOCTOOL").indexOf("CDSjavaAPI-7.3") >= 0) {
                    this.context.info("Deprecated hpxFinder MOC (SFMOC proto 7.3)");
                    throw new Exception();
                }
            }
            catch (Exception e) {
                this.b = new BuilderMocIndex(this.context);
                this.b.run();
                this.b = null;
            }
        }
        this.context.loadMoc();
    }

    private void builderLowOrder() throws Exception {
        if (this.context.isHips3D) {
            return;
        }
        int[] minmax = this.context.findMinMaxOrder();
        if (minmax[0] == 0) {
            return;
        }
        if (this.context.getMinOrder() == minmax[0]) {
            return;
        }
        boolean flagFits = false;
        int bitpixOrig = this.context.getBitpixOrig();
        this.context.setModeMerge(ModeMerge.mergeKeepTile);
        int order = this.context.getOrder();
        this.context.setOrder(3);
        this.context.info("Building missing HiPS low orders (Norder0,1 and 2)...");
        String s = this.context.prop.getProperty("hips_tile_format");
        Tok tok = new Tok(s);
        while (tok.hasMoreTokens()) {
            String fmt = tok.nextToken();
            if (fmt.equals("fits")) {
                flagFits = true;
                continue;
            }
            this.context.info("- building Norder0,1 and 2 for " + fmt + " tiles...");
            this.context.setColor(fmt);
            this.b = new BuilderTree(this.context);
            this.b.build();
        }
        this.context.bitpixOrig = bitpixOrig;
        this.context.order = order;
        if (flagFits && bitpixOrig != 0) {
            this.context.info("- building Norder0, 1 and 2 for fits tiles...");
            this.b = new BuilderTree(this.context);
            this.b.build();
        }
        this.context.setMinOrder(0);
        this.context.done("Norder0,1 and 2 successfully built");
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        String path = this.context.getOutputPath();
        if (this.context.hipsId != null) {
            this.context.setHipsId(this.context.hipsId);
        } else {
            this.context.loadProperties();
            this.context.setHipsId(null);
        }
        this.validateHips3D(path);
        if (this.context.isHips3D) {
            this.context.info("Updating an HiPS3D...");
        }
        this.validateOrder(path);
    }
}

