/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.hipsgen.Action;
import cds.hipsgen.BuilderPack;
import cds.hipsgen.Context;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;

public class BuilderUnpack
extends BuilderPack {
    public BuilderUnpack(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.UNPACK;
    }

    @Override
    protected String getTileFormat() {
        return this.context.getTileFormat();
    }

    @Override
    protected ArrayList<String> getTileFormatAsArray() {
        return this.context.tileFormat;
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        this.context.info("Unpacking " + this.totalTiles + " tiles (fmt=\"" + this.getTileFormat() + "\") [estimation]");
        for (String fmt : this.getTileFormatAsArray()) {
            String output = this.context.getOutputPath();
            if (fmt.startsWith(".")) {
                fmt = fmt.substring(1);
            }
            if (fmt.equals("index")) {
                output = this.context.getHpxFinderPath();
                fmt = "";
            }
            for (int order = this.context.getOrder(); order >= 0; --order) {
                String pathOrder = output + FS + "Norder" + order;
                Path fpath = new File(pathOrder).toPath();
                if (!fpath.toFile().exists()) continue;
                DirectoryStream<Path> stream = Files.newDirectoryStream(fpath, "Dir*" + (fmt.length() > 0 ? "-" : "") + fmt + ".bin");
                for (Path entry : stream) {
                    File bin = entry.toFile();
                    int z = this.getDepth(bin.getName());
                    this.unpackDir(bin, fmt, z);
                }
            }
        }
    }

    private int getDepth(String f) {
        int lim = f.lastIndexOf("Dir");
        int start = f.lastIndexOf(95);
        if (start <= lim) {
            return 0;
        }
        int stop = f.indexOf(45, start + 1);
        if (stop != -1) {
            try {
                return Integer.parseInt(f.substring(start + 1, stop));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackDir(File bin, String fmt, int z) throws Exception {
        File fp = bin.getParentFile();
        try (RandomAccessFile target = null;){
            target = new RandomAccessFile(bin, "r");
            long[] index = this.readIndex(target);
            int ndir = (int)Util.getNDirFromPath(bin + "");
            File fdir = new File(fp + FS + "Dir" + ndir);
            if (!fdir.isDirectory()) {
                fdir.mkdir();
            }
            long pos = 0L;
            for (int i = 0; i < index.length; ++i) {
                long size = index[i] - pos;
                if (size <= 0L) continue;
                long offset = index[i] - size;
                int npix = ndir + i;
                String tile = fdir + FS + "Npix" + npix + (z > 0 ? "_" + z : "") + "." + fmt;
                this.restore(target, offset, (int)size, tile);
                pos = index[i];
                this.updateStat();
            }
        }
        bin.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(RandomAccessFile target, long offset, int size, String tile) throws Exception {
        byte[] buf = new byte[size];
        File ff = new File(tile);
        if (ff.exists()) {
            ff.delete();
        }
        target.seek(offset);
        try (RandomAccessFile ftile = new RandomAccessFile(tile, "rw");){
            target.read(buf);
            ftile.write(buf);
        }
    }

    private long[] readIndex(RandomAccessFile target) throws Exception {
        long sizeFile = target.length();
        byte[] t = new byte[8];
        target.seek(sizeFile - 8L);
        target.read(t);
        if (t[4] != MC[0] || t[5] != MC[1] || t[6] != MC[2] || t[7] != MC[3]) {
            throw new Exception("Binary packed file not supported!");
        }
        int first = BuilderUnpack.getLeShort(t, 0);
        int last = BuilderUnpack.getLeShort(t, 2);
        int sizeIndex = (last + 1 - first) * 8;
        long posIndex = sizeFile - 8L - (long)sizeIndex;
        byte[] buf = new byte[sizeIndex];
        target.seek(posIndex);
        target.read(buf);
        long[] index = new long[10000];
        int i = first;
        int off = 0;
        while (i <= last) {
            index[i] = BuilderUnpack.getLeLong(buf, off);
            ++i;
            off += 8;
        }
        return index;
    }
}

