/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderGzip;
import cds.hipsgen.Context;
import java.io.File;

public class BuilderTrim
extends BuilderGzip {
    public BuilderTrim(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TRIM;
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, Action.GZIP)) {
            return false;
        }
        if (this.context.actionAlreadyDone(Action.UNTRIM) && !this.context.actionPrecedeAction(Action.TRIM, Action.UNTRIM)) {
            return false;
        }
        this.context.info("TRIM seems to be already done");
        return true;
    }

    @Override
    protected long process(String filename) throws Exception {
        if (!new File(filename).isFile()) {
            return 0L;
        }
        long t = System.currentTimeMillis();
        this.trim(filename, this.compress);
        return System.currentTimeMillis() - t;
    }

    private void trim(String file, boolean compress) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        Fits f = new Fits();
        Fits out = null;
        f.loadFITS(file, false);
        Fits fits = out = compress ? f.trimFactory() : f.untrimFactory();
        if (out != null) {
            out.writeFITS(file);
        }
    }
}

