/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.HpxFinderItem;
import cds.aladin.HpxFinderTile;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.moc.SMoc;
import cds.moc.TMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;

public final class BuilderTIndex
extends Builder {
    public static final int TIMEORDER = 14;
    private int hpxOrder;
    private int statNbFile;
    private long startTime;
    private long totalTime;
    private static final String METADATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- VOTable HiPS hpxfinder mapping file.\n     Use to map and build from a HpxFinder JSON tile a classical VOTable HiPS tile.\n     Adapt it according to your own (see examples below in the comments)\n-->\n\n<VOTABLE version=\"1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xmlns=\"http://www.ivoa.net/xml/VOTable/v1.2\"\n  xsi:schemaLocation=\"http://www.ivoa.net/xml/VOTable/v1.2 http://www.ivoa.net/xml/VOTable/v1.2\">\n \n<RESOURCE>\n  <COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n  <TABLE name=\"YOUR_SURVEY_LABEL\">\n    <FIELD name=\"RAJ2000\" ucd=\"pos.eq.ra\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Right ascension</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"DEJ2000\" ucd=\"pos.eq.dec\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Declination</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"id\" ucd=\"meta.id;meta.dataset\" datatype=\"char\" arraysize=\"13*\">\n      <DESCRIPTION>Dataset name, uniquely identifies the data for a given exposure.</DESCRIPTION>\n       <!-- Simple HTTP link description (Aladin will open it in a Web navigator)\n         <LINK href=\"http://your.server.edu/info?param=${id}&amp;otherparam=foo\"/>\n       -->\n     </FIELD>\n    <FIELD name=\"access\" datatype=\"char\" arraysize=\"9*\">\n      <DESCRIPTION>Display original image</DESCRIPTION>\n       <LINK content-type=\"image/fits\" href=\"${access}\"/>\n       <!--  Image HTTP link description (Aladin will load it)\n          <LINK content-type=\"image/fits\" href=\"http://your.server.edu/getdata?param=${id}&amp;otherparam=foo\" title=\"remote img\"/>\n        -->\n    </FIELD>\n    <FIELD name=\"FoV\" datatype=\"char\" utype=\"stc:ObservationLocation.AstroCoordArea.Region\" arraysize=\"12*\">\n       <DESCRIPTION>Field of View (STC description)</DESCRIPTION>\n    </FIELD>\n    <!-- Additional Field for extracting Instrument name from original filepath\n         see also associated TD example below\n       <FIELD name=\"Instrument\" datatype=\"char\" arraysize=\"12*\">\n          <DESCRIPTION>Instrument</DESCRIPTION>\n       </FIELD \n     -->\n<DATA>\n   <TABLEDATA> \n      <TR>\n      <TD>$[ra]</TD>\n      <TD>$[dec]</TD>\n      <TD>$[name]</TD>\n      <TD>$[path:([^\\[]*).*]</TD>\n      <TD>$[stc]</TD>\n      <!-- Extended example via prefix and regular expression mapping\n           (here, the instrument name is coded in the original path after \"data\" directory)\n           <TD>Instrument: $[path:.*/data/(.+)/.*]</TD> \n        -->\n      </TR>\n   </TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n\n";

    public BuilderTIndex(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TINDEX;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateIndex();
        this.hpxOrder = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
        if (this.hpxOrder == -1) {
            throw new Exception("HpxFinder seems to be not yet ready ! (order=-1)");
        }
        this.context.info("Order retrieved from HpxFinder => " + this.hpxOrder);
        this.context.setOrder(this.hpxOrder);
        this.context.mocIndex = null;
        this.context.initRegion();
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 0, 0);
    }

    @Override
    public void build() throws Exception {
        String hpxPath = this.context.getHpxFinderPath();
        String timePath = this.context.getTimeFinderPath();
        SMoc mocRegion = this.context.getRegion().getSpaceMoc();
        if (mocRegion.getMocOrder() != this.hpxOrder) {
            mocRegion = mocRegion.clone();
            mocRegion.setMocOrder(this.hpxOrder);
        }
        this.initStat(mocRegion.getNbValues());
        TMoc tmoc = new TMoc(14);
        int i = 0;
        Iterator<Long> it = mocRegion.valIterator();
        while (it.hasNext()) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            long npix = it.next();
            String fileIn = Util.getFilePath(hpxPath, this.hpxOrder, npix);
            HpxFinderTile tileIn = this.createLeave(fileIn);
            this.updateTimeFinder(timePath, tmoc, tileIn);
            this.context.setProgress(++i);
            this.updateStat();
        }
        tmoc.write(timePath + Util.FS + "TMoc.fits");
    }

    private void initStat(long size) {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
        this.context.setProgressMax(size);
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeFinder(String timePath, TMoc tmoc, HpxFinderTile tileIn) {
        for (String key : tileIn) {
            HpxFinderItem item = (HpxFinderItem)tileIn.get(key);
            String json = item.getJson();
            try {
                String s = cds.tools.Util.extractJSON("T_MIN", json);
                if (s == null) continue;
                double tmin = Double.parseDouble(s);
                s = cds.tools.Util.extractJSON("T_MAX", json);
                if (s == null) continue;
                double tmax = Double.parseDouble(s);
                double jdtmin = tmin + 2400000.5;
                double jdtmax = tmax + 2400000.5;
                tmoc.add(jdtmin, jdtmax);
                TMoc a = new TMoc(14);
                a.add(jdtmin, jdtmax);
                Iterator<Long> it = a.valIterator();
                while (it.hasNext()) {
                    long npix = it.next();
                    String fileOut = Util.getFilePath(timePath, 14, npix);
                    HpxFinderTile tileOut = this.createLeave(fileOut);
                    if (tileOut != null && tileOut.containsKey(key)) continue;
                    RandomAccessFile out = null;
                    try {
                        out = this.openFile(fileOut);
                        out.seek(out.length());
                        out.write((json + "\n").getBytes());
                        out.close();
                        out = null;
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
            }
            catch (Exception e) {
                this.context.warning("parsing error => " + json);
            }
        }
    }

    private RandomAccessFile openFile(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) {
            cds.tools.Util.createPath(filename);
        }
        return new RandomAccessFile(f, "rw");
    }

    private HpxFinderTile createLeave(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HpxFinderTile hp = new HpxFinderTile();
        hp.loadStream(new FileInputStream(f));
        return hp;
    }

    private void generateMedataFile() throws Exception {
        String metadata = cds.tools.Util.concatDir(this.context.getHpxFinderPath(), "metadata.xml");
        if (new File(metadata).exists()) {
            this.context.info("Pre-existing metadata.xml file => keep it");
        } else {
            RandomAccessFile f = new RandomAccessFile(metadata, "rw");
            String s = METADATA.replace("YOUR_SURVEY_LABEL", this.context.getTitle() + " details");
            f.write(s.getBytes());
            f.close();
            this.context.info("Mapping hpxFinder/metadata.xml file has been generated");
        }
        this.context.writeHpxFinderProperties();
        this.context.writeIndexHtml();
    }
}

