/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.BuilderAllsky;
import cds.hipsgen.BuilderJpg;
import cds.hipsgen.BuilderMirror;
import cds.hipsgen.BuilderMoc;
import cds.hipsgen.BuilderTiles;
import cds.hipsgen.Constante;
import cds.hipsgen.Context;
import cds.hipsgen.ContextGui;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ModeTree;
import cds.hipsgen.Param;
import cds.hipsgen.ThreadBuilderTile;
import cds.hipsgen.ThreadBuilderTile3D;
import cds.hipsgen.ThreadBuilderTileColor;
import cds.hipsgen.ThreadBuilderTileCube;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.MocCell;
import cds.moc.SFMoc;
import cds.moc.SMoc;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class BuilderRunner
extends Builder {
    protected int nbThread;
    private boolean isColor;
    protected int bitpix;
    protected double bzero;
    protected double bscale;
    protected double blank;
    protected ArrayList<ThreadBuilder> threadList = new ArrayList();
    private ModeMerge modeMerge;
    private ModeTree modeTree;
    protected int ordermin = 3;
    protected int ordermax;
    protected int orderZmax;
    protected long nummin = 0L;
    protected long nummax = 0L;
    protected LinkedList<AddrThread> fifo;
    protected double automin = 0.0;
    protected double automax = 0.0;
    public static boolean DEBUG = true;
    protected int statNbTile;
    protected long statMinTime;
    protected long statMaxTime;
    protected long statTotalTime;
    protected long statAvgTime;
    protected int statEmptyTile;
    protected int statNodeTile;
    protected long statNodeTotalTime;
    protected long statNodeAvgTime;
    protected long startTime;
    protected long totalTime;
    long lastTime = 0L;
    long lastNbTile = 0L;
    Hashtable<Thread, ArrayList<Fits>> memPerThread;
    private static final long MAXCHECKTIME = 180000L;
    private long lastCheckTime = -1L;
    private double lastProgress = -1.0;
    static final String[] MODE = new String[]{"START", "WAIT", "EXEC", "DIED", "SUSPEND"};
    protected Object lockStop = new Object();
    private Object lockObj = new Object();
    private int threadId = 0;

    public BuilderRunner(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return null;
    }

    @Override
    public void supportHiPS3D() throws Exception {
        if (this.context.isHips3D) {
            throw new Exception((Object)((Object)this.getAction()) + " action not implemented for HiPS3D!");
        }
    }

    protected void message() {
        if (this.context.isHips3D) {
            this.context.info("COMPUTING A HiPS3D...");
        } else if (this.context.isCube) {
            this.context.info("COMPUTING A HiPS CUBE...");
        } else if (this.context.isColor()) {
            this.context.info("COMPUTING A HiPS COLOR...");
        } else {
            this.context.info("COMPUTING A REGULAR HiPS...");
        }
    }

    @Override
    public void run() throws Exception {
        long t0 = System.currentTimeMillis();
        String ext = this.getTileExt().replace('.', ' ');
        int tileWidth = this.context.getTileSide();
        int tileDepth = this.context.getTileDepth();
        this.context.info("Creating " + this.context.getNbLowCells() + ext + " " + tileWidth + "x" + tileWidth + (tileDepth > 1 ? "x" + tileDepth : "") + " tiles...");
        if (this.context.live) {
            this.context.info("Will store pixel weights in " + this.context.getNbLowCells() + " fits " + tileWidth + "x" + tileWidth + " weighted tiles...");
        }
        this.context.resetCheckCode(this.context.getTileExt());
        if (!this.context.isColor()) {
            int b1;
            int b0 = this.context.getBitpixOrig();
            if (b0 != (b1 = this.context.getBitpix())) {
                this.context.info("BITPIX conversion from " + this.context.getBitpixOrig() + " to " + this.context.getBitpix());
                double[] cutOrig = this.context.getCutOrig();
                double[] cut = this.context.getCut();
                if (this.context.cutByImage) {
                    this.context.info("Map original cut pixel range to [" + cut[2] + " .. " + cut[3] + "]");
                } else if (cutOrig[2] != cut[2] || cutOrig[3] != cut[3]) {
                    this.context.info("Map original raw pixel range [" + cutOrig[2] + " .. " + cutOrig[3] + "] to [" + cut[2] + " .. " + cut[3] + "]");
                }
            } else {
                this.context.info("BITPIX=" + b1 + " (no conversion)");
            }
            double bs = this.context.getBScale();
            double bz = this.context.getBZero();
            if (bs != 1.0 || bz != 0.0) {
                this.context.info("BSCALE=" + bs + " BZERO=" + bz);
            }
            double bl0 = this.context.getBlankOrig();
            double bl1 = this.context.getBlank();
            String bkey = this.context.getBlankKey();
            if (this.context.hasAlternateBlank()) {
                this.context.info("BLANK conversion from " + (Double.isNaN(bl0) ? "NaN" : Double.valueOf(bl0)) + " to " + (Double.isNaN(bl1) ? "NaN" : Double.valueOf(bl1)));
            } else {
                this.context.info("BLANK=" + (bkey != null ? bkey : (Double.isNaN(bl1) ? "NaN" : Double.valueOf(bl1))));
            }
            if (this.context.skyvalRef != 0.0) {
                this.context.info("Reference SKYLEVEL=" + this.context.skyvalRef);
            }
            if (this.context.good != null) {
                this.context.info("Good pixel values [" + this.ip(this.context.good[0], bz, bs) + " .. " + this.ip(this.context.good[1], bz, bs) + "] => other values are ignored");
            }
            if (this.context.live) {
                this.context.info("Incremental HiPS => Weight tiles saved for potential future additions");
            }
        }
        this.build();
        this.execTime = System.currentTimeMillis() - t0;
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarTile());
        }
        this.validateInput();
        this.validateOutput();
        try {
            this.validateOrder(this.context.getHpxFinderPath());
            this.validateTileDepth(this.context.getHpxFinderPath());
            if (this instanceof BuilderTiles) {
                this.validateProgenMaxCell(this.context.getHpxFinderPath());
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.context.info("HpxFinder directory not found -> exploring tile directory");
            this.validateOrder(this.context.getOutputPath());
            this.validateTileDepth(this.context.getOutputPath());
        }
        String img = this.context.getImgEtalon();
        if (img == null) {
            img = this.context.justFindImgEtalon(this.context.getInputPath());
        }
        double[] memoCutOrig = this.context.getCutOrig();
        boolean hasAlternateBlank = this.context.hasAlternateBlank();
        double blankOrig = this.context.getBlankOrig();
        int bitpixOrig = this.context.getBitpixOrig();
        if (img == null) {
            throw new Exception("No source image found in " + this.context.getInputPath());
        }
        try {
            this.context.setImgEtalon(img);
        }
        catch (Exception e) {
            this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
        }
        this.message();
        this.context.info("Output directory: " + this.context.getOutputPath());
        this.context.info("Reference image: " + img);
        if (!this.context.isColor()) {
            if (bitpixOrig == -1) {
                this.context.info("BITPIX found in the reference image => " + this.context.getBitpixOrig());
            } else if (bitpixOrig != this.context.getBitpixOrig()) {
                this.context.warning("The provided BITPIX (" + bitpixOrig + ") is different than the original one (" + this.context.getBitpixOrig() + ") => bitpix conversion will be applied");
                this.context.setBitpixOrig(bitpixOrig);
            }
            double[] cutOrigBefore = this.context.getPixelRangeCut();
            if (cutOrigBefore != null) {
                memoCutOrig = new double[7];
                for (int i = 0; i < 4; ++i) {
                    if (Double.isNaN(cutOrigBefore[i])) continue;
                    memoCutOrig[i] = (cutOrigBefore[i] - this.context.bZeroOrig) / this.context.bScaleOrig;
                }
            }
            double[] cutOrig = this.context.getCutOrig();
            double bs = this.context.bScaleOrig;
            double bz = this.context.bZeroOrig;
            if (memoCutOrig != null) {
                if (cutOrig == null) {
                    cutOrig = new double[memoCutOrig.length];
                }
                if (Context.hasCut(memoCutOrig)) {
                    cutOrig[0] = memoCutOrig[0];
                    cutOrig[1] = memoCutOrig[1];
                }
                if (Context.hasRange(memoCutOrig)) {
                    cutOrig[2] = memoCutOrig[2];
                    cutOrig[3] = memoCutOrig[3];
                    if (cutOrig[0] == 0.0 && cutOrig[1] == 0.0) {
                        cutOrig[0] = cutOrig[2];
                        cutOrig[1] = cutOrig[3];
                    }
                }
                this.context.setCutOrig(cutOrig);
            }
            if (cutOrig != null && cutOrig[0] == cutOrig[1]) {
                this.context.warning("Suspicious pixel cut: [" + this.ip(cutOrig[0], bz, bs) + " .. " + this.ip(cutOrig[1], bz, bs) + "] => YOU WILL PROBABLY HAVE TO CHANGE/EDIT THE properties FILE VALUES");
            }
            this.context.setValidateCut(true);
            if (hasAlternateBlank) {
                this.context.setBlankOrig(blankOrig);
            }
            this.context.initParameters();
            if (this instanceof BuilderJpg) {
                this.context.info("Generating 8-bit tiles (PNG or JPEG) directly from the original images...");
            } else if (cutOrig != null) {
                this.context.info("Data range [" + this.ip(cutOrig[2], bz, bs) + " .. " + this.ip(cutOrig[3], bz, bs) + "] (estimation), pixel cut [" + this.ip(cutOrig[0], bz, bs) + " .. " + this.ip(cutOrig[1], bz, bs) + "]");
            }
        } else {
            this.context.initParameters();
        }
        if (!this.context.verifCoherence()) {
            throw new Exception("Uncompatible pre-existing HiPS survey");
        }
        if (!this.context.isColor() && this.context.getBScale() == 0.0) {
            throw new Exception("Big bug => BSCALE=0 !! please contact CDS");
        }
        this.context.info("Overlay mode (progenitors): " + ModeOverlay.getExplanation(this.context.getModeOverlay()));
        if (!this.context.isExistingHips()) {
            this.context.setModeMerge(ModeMerge.mergeOverwriteTile);
        } else {
            this.context.info("Merge mode (tiles): " + ModeMerge.getExplanation(this.context.getModeMerge()));
        }
        this.context.info("Hierarchy mode (tree): " + ModeTree.getExplanation(this.context.getModeTree()));
        this.context.info("Frame (HiPS coordinate reference frame) => " + this.context.getFrameName());
        this.validateSplit();
    }

    private void validateSplit() throws Exception {
        String splitCmd = this.context.getSplit();
        if (splitCmd == null) {
            return;
        }
        if (this.context.isCube()) {
            this.context.warning("HiPS 3D does not support Split param => ignored");
            this.context.setSplit(null);
            return;
        }
        String outputPath = this.context.getOutputPath();
        int bitpix = this.context.getBitpix();
        int tileWidth = this.context.getTileSide();
        int order = this.context.getOrder();
        int depth = this.context.getDepth();
        String format = this.context.isColor() ? "jpeg" : "fits png";
        SMoc moc = this.context.mocIndex.getSpaceMoc().clone();
        if (moc == null) {
            throw new Exception("No MOC available => splitting action not possible");
        }
        if (!this.outputIsFree(outputPath, order)) {
            this.context.warning("HiPS output dir not empty => split function ignored");
            return;
        }
        this.validateSplit(outputPath, splitCmd, moc, order, bitpix, tileWidth, depth, format);
    }

    private boolean outputIsFree(String outputPath, int order) {
        String path = cds.tools.Util.concatDir(outputPath, "Norder" + order);
        File dir = new File(path);
        File[] fs = dir.listFiles();
        if (fs == null) {
            return true;
        }
        for (File f : fs) {
            if (!f.isDirectory() || !f.getName().startsWith("Dir")) continue;
            try {
                Integer.parseInt(f.getName().substring(3));
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void showStatistics() {
        if (this.b != null) {
            this.b.showStatistics();
            return;
        }
        int statNbThreadRunning = this.getNbThreadRunning();
        int statNbThread = this.getNbThreads();
        if (statNbThreadRunning == 0 || this.statNbTile == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        this.totalTime = now - this.startTime;
        long deltaTime = now - this.lastTime;
        long deltaNbTile = (long)this.statNbTile - this.lastNbTile;
        this.lastTime = now;
        this.lastNbTile = this.statNbTile;
        this.context.showTilesStat(statNbThreadRunning, statNbThread, this.totalTime, this.statNbTile, this.statEmptyTile, this.statNodeTile, this.statMinTime, this.statMaxTime, this.statAvgTime, this.statNodeAvgTime, 0L, deltaTime, deltaNbTile);
        if (Aladin.levelTrace >= 3) {
            String s = this.showMem();
            if (s.length() > 0) {
                this.context.stat(s);
            }
            this.showDebugInfo();
        }
    }

    private void initStat(int nbThread) {
        this.statNodeTile = 0;
        this.statNbTile = 0;
        this.statNodeTotalTime = 0L;
        this.statTotalTime = 0L;
        this.startTime = System.currentTimeMillis();
        this.totalTime = 0L;
        this.memPerThread = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmThread(Thread t) {
        Long key = new Long(t.hashCode());
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            ArrayList<Fits> m = this.memPerThread.get(key);
            if (m != null) {
                for (Fits f : m) {
                    f.free();
                }
            }
            this.memPerThread.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFits(Thread t, Fits f) {
        if (f == null) {
            return;
        }
        if (f.width == 0) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            ArrayList<Fits> m = this.memPerThread.get(t);
            if (m == null) {
                m = new ArrayList();
                this.memPerThread.put(t, m);
            }
            m.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rmFits(Thread t, Fits f) {
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            ArrayList<Fits> m = this.memPerThread.get(t);
            if (m == null) {
                return;
            }
            m.remove(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long releaseBitmap() {
        long size = 0L;
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            for (Thread t : this.memPerThread.keySet()) {
                ArrayList<Fits> m = this.memPerThread.get(t);
                for (Fits f : m) {
                    try {
                        if (!f.isReleasable()) continue;
                        size += f.releaseBitmap();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String showMem() {
        try {
            StringBuilder s = new StringBuilder();
            Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
            synchronized (hashtable) {
                for (Thread t : this.memPerThread.keySet()) {
                    ArrayList<Fits> m = this.memPerThread.get(t);
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append(t.getName() + ":" + m.size() + "tiles/" + cds.tools.Util.getUnitDisk(this.getUsedMem(m)));
                }
            }
            return s.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private long getUsedMem(ArrayList<Fits> m) {
        if (m == null) {
            return 0L;
        }
        long mem = 0L;
        try {
            for (Fits f : m) {
                mem += f.getMem();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mem;
    }

    protected void updateStat(int deltaNbThread, int deltaTile, int deltaEmptyTile, long timeTile, int deltaNodeTile, long timeNodeTile) {
        this.statNbTile += deltaTile;
        this.statNodeTile += deltaNodeTile;
        this.statEmptyTile += deltaEmptyTile;
        if (timeTile > 0L) {
            if (this.statNbTile == 1 || timeTile < this.statMinTime) {
                this.statMinTime = timeTile;
            }
            if (this.statNbTile == 1 || timeTile > this.statMaxTime) {
                this.statMaxTime = timeTile;
            }
            if (deltaTile == 1) {
                this.statTotalTime += timeTile;
                this.statAvgTime = this.statTotalTime / (long)this.statNbTile;
            }
        }
        if (timeNodeTile > 0L && deltaNodeTile == 1) {
            this.statNodeTotalTime += timeNodeTile;
            this.statNodeAvgTime = this.statNodeTotalTime / (long)this.statNodeTile;
        }
    }

    protected String getHpxFinderPath() {
        return this.context.getHpxFinderPath();
    }

    protected ModeOverlay getModeOverlay() {
        return this.context.getModeOverlay();
    }

    protected int getBitpix() {
        return this.context.getBitpix();
    }

    protected boolean getFading() {
        return this.context.getFading();
    }

    @Override
    protected void build() throws Exception {
        Moc moc;
        this.ordermax = this.context.getOrder();
        this.orderZmax = this.context.getOrderFreq();
        this.context.resetCounter();
        long t = System.currentTimeMillis();
        this.fifo = new LinkedList();
        if (this.context.isHips3D && this.context.getOrderFreq() != -1) {
            moc = this.context.getRegion().clone();
            if (moc == null) {
                moc = new SFMoc("f0/0 s0/0-11");
            }
            int minOrder = this.context.getMinOrder();
            moc.setSpaceOrder(minOrder);
            int minFOrder = this.context.getOrderFreq() - (this.context.getOrder() - minOrder);
            if (minFOrder < 0) {
                minFOrder = 0;
                this.context.info("Unbalanced HiPS3D  (spatial hierarchy far superior to frequency hierarchy)");
            }
            moc.setFreqOrder(minFOrder);
            for (MocCell mc : moc) {
                Iterator<Long> it1 = ((Moc1D)mc.moc).valIterator();
                while (it1.hasNext()) {
                    long npix = it1.next();
                    for (long fpix = mc.start; fpix < mc.end; ++fpix) {
                        this.fifo.add(new AddrThread(minOrder, npix, mc.order, fpix, null, true));
                    }
                }
            }
        } else {
            moc = new SMoc();
            SMoc m = this.context.getRegion().getSpaceMoc();
            if (m == null) {
                m = new SMoc("0/0-11");
            }
            ((SMoc)moc).add(m);
            int minOrder = this.context.getMinOrder();
            ((Moc1D)moc).setMocOrder(minOrder);
            int depth = 1;
            int tileDepth = 1;
            depth = this.context.getDepth();
            tileDepth = this.context.getTileDepth();
            for (int z = 0; z < depth; z += tileDepth) {
                Iterator<Long> it = ((Moc1D)moc).valIterator();
                while (it.hasNext()) {
                    long npix = it.next();
                    this.fifo.add(new AddrThread(minOrder, npix, z, null, true));
                }
            }
        }
        this.isColor = this.context.isColor();
        this.bitpix = this.getBitpix();
        this.modeMerge = this.context.getModeMerge();
        this.modeTree = this.context.getModeTree();
        if (!this.isColor) {
            this.bzero = this.context.getBZero();
            this.bscale = this.context.getBScale();
            this.blank = this.context.getBlank();
        }
        int nbProc = Runtime.getRuntime().availableProcessors();
        long size = this.context.getMem();
        if (!(this instanceof BuilderJpg)) {
            long x;
            int[] maxProgenCell;
            int npixOrig = this.context.getNpixOrig();
            if (npixOrig <= 0) {
                npixOrig = 4;
            }
            if ((maxProgenCell = this.context.getProgenMaxCell()) == null) {
                maxProgenCell = new int[]{Constante.ORIGCELLWIDTH, Constante.ORIGCELLWIDTH, this.context.depth > 1 ? Constante.ORIGCELLDEPTH : 1, 8};
            }
            if ((x = (long)(maxProgenCell[0] * maxProgenCell[1] * maxProgenCell[2] * npixOrig)) >= Integer.MAX_VALUE || x < 0L) {
                throw new Exception("Array overflow (" + maxProgenCell[0] + "x" + maxProgenCell[1] + "x" + maxProgenCell[2] + "x" + npixOrig + ">2^31) => increase the partitioning!");
            }
            long bufMem = (long)Math.min(8, maxProgenCell[3]) * x;
            long oneRhomb = this.context.getTileSide() * this.context.getTileSide() * this.context.getTileDepth() * this.context.getNpix();
            long maxMemPerThread = 4L * oneRhomb + bufMem;
            if (this.isColor) {
                maxMemPerThread += oneRhomb * (long)(this.ordermax - this.ordermin);
            }
            this.context.info("Minimal RAM required per thread (upper estimation): " + cds.tools.Util.getUnitDisk(maxMemPerThread));
            if (maxMemPerThread > size) {
                throw new Exception("Not enough RAM memory. Increase it or adjust the " + (Object)((Object)Param.partitioning) + " parameter values");
            }
            this.nbThread = this instanceof BuilderMirror ? 16 : (int)(size / maxMemPerThread);
        } else {
            this.nbThread = nbProc;
        }
        int maxNbThread = this.context.getMaxNbThread();
        if (maxNbThread > 0 && this.nbThread > maxNbThread) {
            this.nbThread = maxNbThread;
        }
        if (!(this.nbThread > 0 && this.nbThread <= nbProc || this instanceof BuilderMirror)) {
            this.nbThread = nbProc;
        }
        Aladin.trace(4, "BuildController.build(): Found " + nbProc + " processor(s) for " + size / 0x100000L + "MB RAM => Launch " + this.nbThread + " thread(s)");
        this.context.info("Building tiles thanks to " + this.nbThread + " thread" + (this.nbThread > 1 ? "s" : ""));
        this.context.createPropForVisu();
        this.buildPre();
        this.launchThreadBuilderHpx(this.nbThread);
        while (!this.fifoEmpty() || this.stillWorking()) {
            cds.tools.Util.pause(1000);
            this.infoInCaseOfProblem();
        }
        this.destroyThreadBuilderHpx();
        if (this.context.cacheFits != null) {
            this.context.cacheFits.reset();
        }
        long duree = System.currentTimeMillis() - t;
        if (!this.context.isTaskAborting()) {
            Aladin.trace(3, "Hips survey build in " + cds.tools.Util.getTemps(duree * 1000L));
        }
        this.buildPost(duree);
    }

    protected void buildPre() throws Exception {
        long maxMem;
        int maxFile;
        long size = this.context.getMem();
        int npixOrig = this.context.getNpixOrig();
        long limitMem = 2L * size / 3L;
        int limitFile = 5000;
        if (this.context.isColor() || !this.context.isPartitioning()) {
            maxFile = limitFile;
            maxMem = limitMem;
        } else {
            int[] maxProgenCell = this.context.getProgenMaxCell();
            if (maxProgenCell == null) {
                maxProgenCell = new int[]{Constante.ORIGCELLWIDTH, Constante.ORIGCELLWIDTH, this.context.depth > 1 ? Constante.ORIGCELLDEPTH : 1, 8};
            }
            if ((maxFile = this.nbThread * Math.min(8, maxProgenCell[3])) < 2000) {
                maxFile = 2000;
            }
            maxMem = (long)maxFile * (long)maxProgenCell[0] * (long)maxProgenCell[1] * (long)maxProgenCell[2] * (long)npixOrig;
        }
        CacheFits cache = new CacheFits(maxMem, maxFile, limitMem, limitFile);
        this.context.setCache(cache);
        this.context.info("Available RAM: " + cds.tools.Util.getUnitDisk(size) + " => RAM cache size: " + cache.getMaxFile() + " items / " + cds.tools.Util.getUnitDisk(cache.getMaxMem()));
    }

    protected void buildPost(long duree) throws Exception {
        if (!this.context.isColor()) {
            if (this.context.bitpix != -1) {
                this.context.setPropriete("hips_pixel_bitpix", this.context.bitpix + "");
            }
            if (this.context.bitpixOrig != -1) {
                this.context.setPropriete("data_pixel_bitpix", this.context.bitpixOrig + "");
            }
            this.context.setPropriete("hips_sampling", this.context.isMap() ? "none" : "bilinear");
            if (this.context.skyvalName != null) {
                this.context.setPropriete("hips_skyval_method", this.context.skyvalName);
                StringBuilder s1 = null;
                double[] cutOrig = this.context.getCutOrig();
                for (int i = 0; i < 4; ++i) {
                    double x = cutOrig[i];
                    if (s1 == null) {
                        s1 = new StringBuilder("" + x);
                        continue;
                    }
                    s1.append(" " + x);
                }
                this.context.setPropriete("hips_skyval_value", s1.toString());
            }
        }
        this.context.setPropriete("hips_overlay", this.context.isMap() ? "none" : this.context.getModeOverlay().toString() + " " + this.context.getModeMerge().toString() + " " + this.context.getModeTree().toString());
        if (!Double.isNaN(this.context.dataMin) && !Double.isNaN(this.context.dataMax)) {
            this.context.info("HiPS effective values: " + cds.tools.Util.myRound(this.context.dataMin) + " .. " + cds.tools.Util.myRound(this.context.dataMax));
        }
        if (!this.context.isTaskAborting()) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
        }
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
        }
        if (ThreadBuilderTile.statMaxOverlays > 0) {
            this.context.stat("Tile overlay stats : max overlays=" + ThreadBuilderTile.statMaxOverlays + ", " + ThreadBuilderTile.statOnePass + " in one step, " + ThreadBuilderTile.statMultiPass + " in multi steps");
        }
        if (this.context.cacheFits != null) {
            Aladin.trace(4, "Cache FITS status: " + this.context.cacheFits);
            this.context.cacheFits.reset();
            this.context.setCache(null);
        }
        if (this.context.trimMem > 0L) {
            this.context.stat("Tiles trim method saved " + cds.tools.Util.getUnitDisk(this.context.trimMem, 1, 2));
        }
        this.infoCounter(duree);
    }

    private void infoCounter(long duree) {
        if (duree > 1000L && (this.context.statPixelIn > 0L || this.context.statPixelOut > 0L)) {
            long d = duree / 1000L;
            this.context.stat("Pixel times: " + (this.context.statPixelIn == 0L ? "" : "Original =" + cds.tools.Util.getUnitDisk(this.context.statPixelIn).replace("B", "pix") + " => " + cds.tools.Util.getUnitDisk(this.context.statPixelIn / d).replace("B", "pix") + "/s") + (this.context.statPixelOut == 0L ? "" : "  Low tiles=" + cds.tools.Util.getUnitDisk(this.context.statPixelOut).replace("B", "pix") + (this.context.statPixelIn == 0L ? "" : " (x" + cds.tools.Util.myRound((double)this.context.statPixelOut / (double)this.context.statPixelIn) + ")") + " => " + cds.tools.Util.getUnitDisk(this.context.statPixelOut / d).replace("B", "pix") + "/s"));
        }
    }

    private void infoInCaseOfProblem() {
        long t;
        block7: {
            block6: {
                t = System.currentTimeMillis();
                if (this.lastCheckTime == -1L) {
                    this.lastCheckTime = t;
                    return;
                }
                if (t - this.lastCheckTime < 180000L) break block6;
                BuilderRunner builderRunner = this;
                if (builderRunner.context.getVerbose() < 3 || t - this.lastCheckTime >= 20000L) break block7;
            }
            return;
        }
        this.lastCheckTime = t;
        if (this.lastProgress == -1.0) {
            this.lastProgress = this.context.progress;
            return;
        }
        if (this.context.progress != this.lastProgress) {
            this.lastProgress = this.context.progress;
            return;
        }
        this.context.warning("Nothing done since a while. Here a short report to understand the problem:");
        this.showDebugInfo();
    }

    protected void showDebugInfo() {
        CacheFits cache;
        this.context.warning("DEBUG REPORT !!! (fifosize=" + this.fifo.size() + ")");
        int nbDied = 0;
        for (ThreadBuilder tb : this.threadList) {
            String info = tb.getInfo();
            if (tb.isDied()) {
                ++nbDied;
            }
            this.context.warning(".thread " + tb.getName() + ": " + tb.getModeString() + (info != null ? " => " + info : ""));
        }
        if (nbDied > 0) {
            this.context.warning(".and " + nbDied + " threads DIED");
        }
        if ((cache = this.context.getCache()) != null) {
            this.context.warning(cache.toString());
        } else {
            this.context.warning("No cache. FreeRAM=" + cds.tools.Util.getUnitDisk(CacheFits.getFreeMem()));
        }
    }

    protected Fits findLeaf(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        return this.findLeaf(file);
    }

    protected String getFilePath(String survey, AddrThread item) {
        if (this.context.isHips3D) {
            return Util.getFilePath(survey, item.order, item.npix, item.orderZ, item.npixZ);
        }
        return Util.getFilePath(survey, item.order, item.npix, item.z);
    }

    protected boolean isInMocTree(AddrThread item) throws Exception {
        if (this.context.isHips3D) {
            SFMoc m = new SFMoc(item.orderZ, item.order);
            m.setSpaceSys(this.context.getFrameCode());
            m.add(item.orderZ, item.npixZ, item.order, item.npix);
            return this.context.isInMocTree(m);
        }
        return this.context.isInMocTree(item.order, item.npix);
    }

    protected boolean isMocDescendant(AddrThread item) throws Exception {
        if (this.context.isHips3D) {
            SFMoc m = new SFMoc(item.orderZ, item.order);
            m.setSpaceSys(this.context.getFrameCode());
            m.add(item.orderZ, item.npixZ, item.order, item.npix);
            return this.context.isMocDescendant(m);
        }
        return this.context.isMocDescendant(item.order, item.npix);
    }

    private Fits createHpx(ThreadBuilderTile hpx, String path, AddrThread addr) throws Exception {
        int i;
        Fits oldOut;
        String file = this.getFilePath(path, addr);
        if (!this.isInMocTree(addr)) {
            return this.findLeaf(file);
        }
        if (this.modeMerge == ModeMerge.mergeKeepTile && (oldOut = this.findLeaf(file)) != null) {
            SMoc moc = this.context.getRegion().getSpaceMoc();
            SMoc a = new SMoc(addr.order + "/" + addr.npix);
            a.setSys(this.context.getFrameCode());
            moc = moc.intersection(a);
            moc.setMocOrder(this.ordermax);
            int nbTiles = (int)moc.getNbValues();
            this.updateStat(0, 0, nbTiles, 0L, nbTiles / 4, 0L);
            return oldOut;
        }
        Fits f = null;
        if (addr.order == this.ordermax) {
            hpx.threadBuilder.setInfo("createLeavveHpx " + file + "...");
            try {
                f = this.createLeafHpx(hpx, file, path, addr);
            }
            catch (Exception e) {
                hpx.threadBuilder.setInfo("createLeavveHpx error " + file + "...");
                System.err.println("BuilderTiles.createLeave error: " + file);
                e.printStackTrace();
                return null;
            }
        }
        AddrThread[] addrf = new AddrThread[this.context.isHips3D ? 8 : 4];
        Fits[] fils = new Fits[addrf.length];
        int nbDelegate = 0;
        for (i = 0; i < addrf.length; ++i) {
            addrf[i] = new AddrThread();
        }
        for (i = 0; i < addrf.length; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (this.context.isHips3D) {
                int orderZ = addr.orderZ + 1;
                long npixZ = addr.npixZ * 2L + (long)(i / 4);
                if (this.orderZmax - addr.orderZ < this.ordermax - addr.order) {
                    orderZ = addr.orderZ;
                    npixZ = addr.npixZ;
                }
                if (nbDelegate < addrf.length - 1 && this.fifo.isEmpty() && this.oneWaiting()) {
                    addrf[i] = this.addAddr(addr.order + 1, addr.npix * 4L + (long)(i % 4), orderZ, npixZ, Thread.currentThread());
                    ++nbDelegate;
                    this.wakeUp();
                    continue;
                }
                AddrThread c = new AddrThread(addr.order + 1, addr.npix * 4L + (long)(i % 4), orderZ, npixZ, Thread.currentThread(), false);
                hpx.threadBuilder.setInfo("CreateHpx go to next order => " + c + "...");
                fils[i] = this.createHpx(hpx, path, c);
                continue;
            }
            if (nbDelegate < addrf.length - 1 && this.fifo.isEmpty() && this.oneWaiting()) {
                addrf[i] = this.addAddr(addr.order + 1, addr.npix * 4L + (long)i, addr.z, Thread.currentThread());
                ++nbDelegate;
                this.wakeUp();
                continue;
            }
            AddrThread c = new AddrThread(addr.order + 1, addr.npix * 4L + (long)i, addr.z, Thread.currentThread(), false);
            hpx.threadBuilder.setInfo("CreateHpx go to next order => " + c + "...");
            fils[i] = this.createHpx(hpx, path, c);
        }
        if (nbDelegate > 0) {
            while (!this.allAddrfReady(addrf)) {
                hpx.threadBuilder.setWaitingChildren(true);
                StringBuilder t = new StringBuilder();
                for (int i2 = 0; i2 < addrf.length; ++i2) {
                    t.append(!addrf[i2].hasBeenUsed() ? "o" : (addrf[i2].isReady() ? "." : "o"));
                }
                hpx.threadBuilder.setInfo("CreateHpx still waiting children of " + addr + " [" + t + "]...");
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.context.isTaskAborting()) continue;
                throw new Exception("Task abort !");
            }
        }
        hpx.threadBuilder.setWaitingChildren(false);
        for (i = 0; i < addrf.length; ++i) {
            if (!addrf[i].hasBeenUsed()) continue;
            fils[i] = addrf[i].getFits();
        }
        hpx.threadBuilder.setInfo("createNodeHpx " + file + "...");
        try {
            f = this.createNodeHpx(file, path, fils, addr);
        }
        catch (Exception e) {
            System.err.println("BuilderTiles.createNodeHpx error: " + file);
            e.printStackTrace();
            return null;
        }
        this.updateMinMax(f);
        return f;
    }

    private boolean allAddrfReady(AddrThread[] cellc) {
        for (AddrThread c : cellc) {
            if (c.isReady()) continue;
            return false;
        }
        return true;
    }

    protected void setProgressBar(int npix) {
        this.context.setProgressLastNorder3(npix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddrThread getNextAddr() {
        AddrThread pix = null;
        Object object = this.lockObj;
        synchronized (object) {
            if (this.fifo.isEmpty()) {
                return null;
            }
            pix = this.fifo.removeLast();
        }
        return pix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddrThread addAddr(int order, long npix, int forder, long fpix, Thread th) {
        AddrThread item = new AddrThread(order, npix, forder, fpix, th, false);
        Object object = this.lockObj;
        synchronized (object) {
            this.fifo.add(item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddrThread addAddr(int order, long npix, int z, Thread th) {
        AddrThread item = new AddrThread(order, npix, z, th, false);
        Object object = this.lockObj;
        synchronized (object) {
            this.fifo.add(item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fifoEmpty() {
        if (!this.fifo.isEmpty()) {
            return false;
        }
        Object object = this.lockObj;
        synchronized (object) {
            return this.fifo.isEmpty();
        }
    }

    private void launchThreadBuilderHpx(int nbThreads) throws Exception {
        this.initStat(nbThreads);
        this.context.createHealpixOrder(this.context.getTileOrder());
        ThreadBuilderTile.hasShape = new HashMap();
        for (int i = 0; i < nbThreads; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            ThreadBuilderTile threadBuilderTile = this.createThreadBuilderTile(this.context, this);
            ThreadBuilder t = new ThreadBuilder("Builder" + this.threadId++, threadBuilderTile);
            this.threadList.add(t);
            t.start();
            if (i != 0) continue;
            cds.tools.Util.pause(100);
        }
    }

    protected ThreadBuilderTile createThreadBuilderTile(Context context, BuilderRunner builder) {
        if (context.isHips3D) {
            return new ThreadBuilderTile3D(context, builder);
        }
        if (context.isCube) {
            return new ThreadBuilderTileCube(context, builder);
        }
        if (context.isColor()) {
            return new ThreadBuilderTileColor(context, builder);
        }
        return new ThreadBuilderTile(context, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addThreadBuilderHpx(int nbThreads) throws Exception {
        if (ThreadBuilderTile.nbThreadsToStop > 0) {
            return false;
        }
        this.context.info("Probably not enough threads => ask to launch " + nbThreads + " thread(s) asap...");
        Object object = this.lockObj;
        synchronized (object) {
            int i;
            for (i = 0; nbThreads > 0 && i < this.threadList.size(); ++i) {
                ThreadBuilder tb = this.threadList.get(i);
                if (!tb.isDied()) continue;
                ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
                ThreadBuilder t = new ThreadBuilder(tb.getName(), threadBuilderTile);
                this.threadList.set(i, t);
                t.start();
                --nbThreads;
            }
            if (nbThreads == 0) {
                return true;
            }
            for (i = 0; i < nbThreads; ++i) {
                if (this.context.isTaskAborting()) {
                    throw new Exception("Task abort !");
                }
                ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
                ThreadBuilder t = new ThreadBuilder("Builder" + this.threadId++, threadBuilderTile);
                this.threadList.add(t);
                t.start();
            }
        }
        return true;
    }

    protected int getNbThreads() {
        int nb = 0;
        try {
            for (ThreadBuilder tb : this.threadList) {
                if (tb.isDied()) continue;
                ++nb;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeThreadBuilderHpx(int nbThreads) {
        if (ThreadBuilderTile.nbThreadsToStop > 0) {
            return false;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ThreadBuilderTile.nbThreadsToStop = nbThreads;
            this.context.info("Probably too many threads => ask to stop " + nbThreads + " thread(s) asap...");
        }
        return true;
    }

    void destroyThreadBuilderHpx() {
        for (ThreadBuilder tb : this.threadList) {
            tb.tue();
        }
    }

    boolean arret(ThreadBuilderTile tbt, String info) {
        for (ThreadBuilder tb : this.threadList) {
            if (tb.threadBuilderTile != tbt) continue;
            return tb.arret(info);
        }
        return false;
    }

    boolean reprise(ThreadBuilderTile tbt) {
        for (ThreadBuilder tb : this.threadList) {
            if (tb.threadBuilderTile != tbt) continue;
            return tb.reprise();
        }
        return false;
    }

    int getNbThreadRunning() {
        int n = 0;
        for (ThreadBuilder tb : this.threadList) {
            if (!tb.isExec()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stillWorking() {
        if (this.stillWorking1()) {
            return true;
        }
        Object object = this.lockObj;
        synchronized (object) {
            return this.stillWorking1();
        }
    }

    boolean stillWorking1() {
        for (ThreadBuilder tb : this.threadList) {
            if (!tb.isExec() && !tb.isSuspend()) continue;
            return true;
        }
        return false;
    }

    boolean oneWaiting() {
        try {
            Iterator<ThreadBuilder> it = this.threadList.iterator();
            while (it.hasNext()) {
                if (!it.next().isWaitingAndUsable(true)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void wakeUp() {
        try {
            for (ThreadBuilder tb : this.threadList) {
                if (!tb.isWaitingAndUsable(false)) continue;
                tb.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean allFilsNull(Fits[] fils) {
        for (Fits f : fils) {
            if (f == null) continue;
            return false;
        }
        return true;
    }

    protected Fits createNodeHpx(String file, String path, Fits[] fils, AddrThread cell) throws Exception {
        Fits oldOut;
        int width = this.context.getTileSide();
        int nbFils = fils.length;
        double dataMin = Double.NaN;
        double dataMax = Double.NaN;
        if (!this.isInMocTree(cell) || this.allFilsNull(fils)) {
            if (this.isColor) {
                return null;
            }
            Fits f = this.findLeaf(file);
            this.addFits(Thread.currentThread(), f);
            return f;
        }
        long t = System.currentTimeMillis();
        for (Fits f : fils) {
            if (f == null) continue;
            f.reloadBitmap();
        }
        int tileDepth = 1;
        for (Fits f : fils) {
            if (f == null) continue;
            tileDepth = f.depth;
            break;
        }
        double[] pixd = new double[nbFils];
        int[] pixi = new int[nbFils];
        int[] buf = new int[nbFils];
        Fits out = new Fits(width, width, tileDepth, this.bitpix);
        if (!this.isColor) {
            out.setBlank(this.blank);
            out.setBzero(this.bzero);
            out.setBscale(this.bscale);
        }
        int xa = out.width;
        int ya = out.height;
        int za = out.depth;
        int xb = -1;
        int yb = -1;
        int zb = -1;
        int nStack = this.context.isHips3D ? 2 : 1;
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int offX = dg * width >>> 1;
                int offY = (1 - hb) * width >>> 1;
                for (int zg = 0; zg < nStack; ++zg) {
                    int quad = (dg << 1 | hb) + zg * 4;
                    int offZ = zg * tileDepth >>> 1;
                    Fits in = fils[quad];
                    for (int z = 0; z < tileDepth; z += nStack) {
                        for (int y = 0; y < width; y += 2) {
                            for (int x = 0; x < width; x += 2) {
                                if (this.isColor) {
                                    int pix = 0;
                                    int nbPix = 0;
                                    if (in != null) {
                                        for (int i = 0; i < 4; ++i) {
                                            int gx = i == 1 || i == 3 ? 1 : 0;
                                            int gy = i > 1 ? 1 : 0;
                                            pixi[nbPix] = in.getPixelRGBJPG(x + gx, y + gy);
                                            if ((pixi[nbPix] & 0xFF000000) == 0) continue;
                                            ++nbPix;
                                            if (this.modeTree == ModeTree.treeFirst) break;
                                        }
                                        pix = nbPix == 0 ? 0 : (this.modeTree == ModeTree.treeMean ? 0xFF000000 | this.getMean(pixi, nbPix, 16) | this.getMean(pixi, nbPix, 8) | this.getMean(pixi, nbPix, 0) : (this.modeTree == ModeTree.treeMedian ? 0xFF000000 | this.getMedian(pixi, buf, nbPix, 16) | this.getMedian(pixi, buf, nbPix, 8) | this.getMedian(pixi, buf, nbPix, 0) : (this.modeTree == ModeTree.treeMiddle ? 0xFF000000 | this.getMiddle(pixi, buf, nbPix, 16) | this.getMiddle(pixi, buf, nbPix, 8) | this.getMiddle(pixi, buf, nbPix, 0) : pixi[0])));
                                    }
                                    out.setPixelRGBJPG(offX + (x >>> 1), offY + (y >>> 1), pix);
                                    continue;
                                }
                                double pix = this.blank;
                                int nbPix = 0;
                                if (in != null) {
                                    block9: for (int gz = 0; gz < nStack; ++gz) {
                                        for (int i = 0; i < 4; ++i) {
                                            int gx = i == 1 || i == 3 ? 1 : 0;
                                            int gy = i > 1 ? 1 : 0;
                                            pixd[nbPix] = in.getPixelDouble(x + gx, y + gy, z + gz);
                                            if (in.isBlankPixel(pixd[nbPix])) continue;
                                            ++nbPix;
                                            if (this.modeTree == ModeTree.treeFirst) break block9;
                                        }
                                    }
                                    pix = nbPix == 0 ? this.blank : (this.modeTree == ModeTree.treeMean ? this.getMean(pixd, nbPix) : (this.modeTree == ModeTree.treeMedian ? this.getMedian(pixd, nbPix) : pixd[0]));
                                }
                                int xt = offX + (x >>> 1);
                                int yt = offY + (y >>> 1);
                                int zt = offZ + (z >>> (this.context.isHips3D ? 1 : 0));
                                if (this.context.trim && !out.isBlankPixel(pix)) {
                                    if (xt < xa) {
                                        xa = xt;
                                    }
                                    if (xt > xb) {
                                        xb = xt;
                                    }
                                    if (yt < ya) {
                                        ya = yt;
                                    }
                                    if (yt > yb) {
                                        yb = yt;
                                    }
                                    if (zt < za) {
                                        za = zt;
                                    }
                                    if (zt > zb) {
                                        zb = zt;
                                    }
                                }
                                out.setPixelDouble(xt, yt, zt, pix);
                                if (Double.isNaN(dataMin) || pix < dataMin) {
                                    dataMin = pix;
                                }
                                if (!Double.isNaN(dataMax) && !(pix > dataMax)) continue;
                                dataMax = pix;
                            }
                        }
                    }
                }
            }
        }
        boolean flagMerge = false;
        if (!this.isColor && this.modeMerge != ModeMerge.mergeOverwriteTile && this.modeMerge != ModeMerge.mergeKeepTile && (oldOut = this.findLeaf(file)) != null) {
            out.mergeOnNaN(oldOut);
            flagMerge = true;
        }
        if (this.context.trim && !flagMerge) {
            out.setBorder(new int[]{xa, xb, ya, yb, za, zb});
        }
        if (!Double.isNaN(dataMin)) {
            out.setDataMinMax(dataMin * out.bscale + out.bzero, dataMax * out.bscale + out.bzero);
        }
        this.context.updateHeader(out, cell);
        this.write(file, out);
        long duree = System.currentTimeMillis() - t;
        if (cell.npix % 10L == 0L || DEBUG) {
            Aladin.trace(5, Thread.currentThread().getName() + ".createNodeHpx(" + cell + ") " + (Object)((Object)this.modeMerge) + " in " + duree + "ms");
        }
        this.updateStat(0, 0, 0, 0L, 1, duree);
        for (int i = 0; i < fils.length; ++i) {
            if (fils[i] == null) continue;
            this.rmFits(Thread.currentThread(), fils[i]);
            fils[i].free();
            fils[i] = null;
        }
        this.addFits(Thread.currentThread(), out);
        return out;
    }

    protected final double getMiddle(double[] px, int nbpix) {
        Arrays.sort(px, 0, nbpix);
        return nbpix >= 3 ? px[1] : px[0];
    }

    protected final double getMedian(double[] px, int nbpix) {
        Arrays.sort(px, 0, nbpix);
        int middle = nbpix / 2;
        return nbpix % 2 == 1 ? px[middle] : px[middle - 1] / 2.0 + px[middle] / 2.0;
    }

    protected final double getMean(double[] px, int nbpix) {
        double pix = 0.0;
        for (int i = 0; i < nbpix; ++i) {
            pix += px[i] / (double)nbpix;
        }
        return pix;
    }

    private final int getMedian(int[] p, int[] buf, int nbpix, int shiftRgb) {
        for (int i = 0; i < nbpix; ++i) {
            buf[i] = p[i] >> shiftRgb & 0xFF;
        }
        Arrays.sort(buf, 0, nbpix);
        return (nbpix == 4 ? (buf[1] + buf[2]) / 2 : (nbpix == 3 ? buf[1] : (nbpix == 2 ? (buf[0] + buf[1]) / 2 : buf[0]))) << shiftRgb;
    }

    private final int getMiddle(int[] p, int[] buf, int nbpix, int shiftRgb) {
        for (int i = 0; i < nbpix; ++i) {
            buf[i] = p[i] >> shiftRgb & 0xFF;
        }
        Arrays.sort(buf, 0, nbpix);
        return (nbpix >= 4 ? buf[1] : buf[0]) << shiftRgb;
    }

    private final int getMean(int[] px, int nbpix, int shiftRgb) {
        int pix = 0;
        for (int i = 0; i < nbpix; ++i) {
            pix += px[i] >> shiftRgb & 0xFF;
        }
        return pix / nbpix << shiftRgb;
    }

    protected void write(String file, Fits out) throws Exception {
        String filename = file + this.context.getTileExt();
        if (this.isColor) {
            out.writeCompressed(filename, 0.0, 0.0, null, Constante.TILE_MODE[this.context.targetColorMode]);
        } else {
            if (this.context.trim) {
                long mem = out.getMem();
                Fits nout = out.trimFactory();
                if (nout != null) {
                    out.setReleasable(false);
                    long mem1 = nout.getMem();
                    this.context.trimMem += (mem - mem1) / 1024L;
                    out = nout;
                }
            }
            out.addDataSum();
            out.writeFITS(filename, this.context.gzip);
        }
    }

    protected Fits createLeafHpx(ThreadBuilderTile hpx, String file, String path, AddrThread addr) throws Exception {
        long t = System.currentTimeMillis();
        Fits oldOut = null;
        if (!(this.isInMocTree(addr) || this.modeMerge == ModeMerge.mergeOverwriteTile || (oldOut = this.findLeaf(file)) == null && this.isMocDescendant(addr))) {
            this.addFits(Thread.currentThread(), oldOut);
            return oldOut;
        }
        Fits out = hpx.buildHealpix(this, path, addr);
        if (out != null && this.modeMerge != ModeMerge.mergeOverwriteTile) {
            if (oldOut == null) {
                oldOut = this.findLeaf(file);
            }
            if (oldOut != null && this.modeMerge == ModeMerge.mergeKeepTile) {
                out = null;
                this.addFits(Thread.currentThread(), oldOut);
                return oldOut;
            }
            if (oldOut != null) {
                if (oldOut.bitpix > 0 && Double.isNaN(oldOut.blank)) {
                    oldOut.setBlank(this.blank);
                }
                if (this.modeMerge == ModeMerge.mergeMean) {
                    out.coadd(oldOut, 0);
                } else if (this.modeMerge == ModeMerge.mergeAdd) {
                    out.coadd(oldOut, 1);
                } else if (this.modeMerge == ModeMerge.mergeOverwrite) {
                    out.mergeOnNaN(oldOut);
                } else if (this.modeMerge == ModeMerge.mergeKeep) {
                    oldOut.mergeOnNaN(out);
                    out = oldOut;
                    oldOut = null;
                }
            }
        }
        if (out != null) {
            this.writeLeaf(out, file, addr);
            hpx.threadBuilder.setInfo("createLeavveHpx write done " + file + "...");
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 1, 0, duree, 0, 0L);
            this.addFits(Thread.currentThread(), out);
        } else {
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 0, 1, duree, 0, 0L);
        }
        return out;
    }

    protected void updateMinMax(Fits fits) {
        if (fits == null) {
            return;
        }
        if (!Double.isNaN(fits.dataMin) && (Double.isNaN(this.context.dataMin) || fits.dataMin < this.context.dataMin)) {
            this.context.dataMin = fits.dataMin;
        }
        if (!Double.isNaN(fits.dataMax) && (Double.isNaN(this.context.dataMax) || fits.dataMax > this.context.dataMax)) {
            this.context.dataMax = fits.dataMax;
        }
    }

    protected void writeLeaf(Fits out, String file, AddrThread cell) throws Exception {
        this.context.updateHeader(out, cell);
        this.write(file, out);
        this.context.addPixelOut(out.getNbPix());
    }

    protected String getTileExt() {
        return this.context.getTileExt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fits findLeaf(String file) throws Exception {
        String filename = file + this.getTileExt();
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        Fits out = new Fits();
        try (MyInputStream is = null;){
            is = new MyInputStream(new FileInputStream(f));
            this.loadLeaf(out, is);
            out.setFilename(filename);
        }
        return out;
    }

    protected void loadLeaf(Fits out, MyInputStream is) throws Exception {
        if (this.isColor) {
            out.loadPreview(is, true);
        } else {
            out.loadFITS(is);
        }
    }

    class AddrThread
    extends Addr {
        Fits fits;
        boolean ready;
        Thread th;
        boolean suspendable;

        AddrThread() {
            this.ready = true;
            this.order = -1;
            this.orderZ = -1;
        }

        AddrThread(int order, long npix, int forder, long fpix, Thread th, boolean suspendable) {
            this.order = order;
            this.npix = npix;
            this.orderZ = forder;
            this.npixZ = fpix;
            this.z = -1;
            this.th = th;
            this.ready = false;
            this.suspendable = suspendable;
        }

        AddrThread(int order, long npix, int z, Thread th, boolean suspendable) {
            this.order = order;
            this.npix = npix;
            this.orderZ = -1;
            this.z = z;
            this.th = th;
            this.ready = false;
            this.suspendable = suspendable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasBeenUsed() {
            LinkedList<AddrThread> linkedList = BuilderRunner.this.fifo;
            synchronized (linkedList) {
                return this.order != -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            LinkedList<AddrThread> linkedList = BuilderRunner.this.fifo;
            synchronized (linkedList) {
                return this.ready;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Fits getFits() {
            LinkedList<AddrThread> linkedList = BuilderRunner.this.fifo;
            synchronized (linkedList) {
                return this.fits;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFits(Fits fits) throws Exception {
            LinkedList<AddrThread> linkedList = BuilderRunner.this.fifo;
            synchronized (linkedList) {
                this.ready = true;
                this.fits = fits;
            }
            if (this.th == null) {
                return;
            }
            this.th.interrupt();
        }

        @Override
        public String toString() {
            return super.toString() + (this.isReady() ? "R" : "") + (this.suspendable ? "s" : "");
        }
    }

    public class ThreadBuilder
    extends Thread {
        static final int START = 0;
        static final int WAIT = 1;
        static final int EXEC = 2;
        static final int DIED = 3;
        static final int SUSPEND = 4;
        ThreadBuilderTile threadBuilderTile;
        private int mode;
        private String info;
        private boolean encore;
        protected AddrThread addr;
        private boolean waitingChildren;
        private boolean suspendable;

        public ThreadBuilder(String name, ThreadBuilderTile threadBuilderTile) {
            super(name);
            this.mode = 0;
            this.encore = true;
            this.addr = null;
            this.waitingChildren = false;
            this.suspendable = true;
            this.threadBuilderTile = threadBuilderTile;
            threadBuilderTile.threadBuilder = this;
            Aladin.trace(3, "Creating " + this.getName());
        }

        public String getInfo() {
            return this.info;
        }

        public String getModeString() {
            return MODE[this.getMode()];
        }

        public synchronized int getMode() {
            return this.mode;
        }

        public synchronized void setMode(int mode) {
            this.mode = mode;
        }

        public boolean isDied() {
            return this.getMode() == 3;
        }

        public boolean isExec() {
            return this.getMode() == 2;
        }

        public boolean isSuspend() {
            return this.getMode() == 4;
        }

        public synchronized void setWaitingChildren(boolean flag) {
            this.waitingChildren = flag;
        }

        public synchronized boolean isWaitingChildren() {
            return this.waitingChildren;
        }

        public boolean isWait() {
            return this.getMode() == 1;
        }

        public boolean isWaitingAndUsable(boolean checkMem) {
            if (this.getMode() != 1) {
                return false;
            }
            if (checkMem) {
                try {
                    return !this.threadBuilderTile.requiredMem(BuilderRunner.this.context.progenMaxOverlays, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public boolean arret(String info) {
            if (!this.suspendable) {
                return false;
            }
            this.setMode(4);
            this.info = info;
            return true;
        }

        public boolean reprise() {
            if (this.getMode() != 4) {
                return false;
            }
            this.setMode(2);
            this.info = null;
            BuilderRunner.this.wakeUp();
            return true;
        }

        public void tue() {
            this.encore = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.encore) {
                this.addr = null;
                if (ThreadBuilderTile.nbThreadsToStop > 0) {
                    Object object = BuilderRunner.this.lockStop;
                    synchronized (object) {
                        if (ThreadBuilderTile.nbThreadsToStop > 0) {
                            --ThreadBuilderTile.nbThreadsToStop;
                            break;
                        }
                    }
                }
                while (this.encore && this.getMode() == 4) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                while (this.encore && (this.addr = BuilderRunner.this.getNextAddr()) == null) {
                    this.setMode(1);
                    this.info = "No more HiPS branch to compute => thread by waiting another task";
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!BuilderRunner.this.context.isTaskAborting()) continue;
                    this.encore = false;
                    break;
                }
                if (!this.encore) continue;
                this.suspendable = this.addr.suspendable;
                this.setMode(2);
                this.info = null;
                try {
                    Aladin.trace(5, Thread.currentThread().getName() + " process HiPS branch " + this.addr + "...");
                    if (BuilderRunner.this.context.isTaskAborting()) break;
                    Fits fits = BuilderRunner.this.createHpx(this.threadBuilderTile, BuilderRunner.this.context.getOutputPath(), this.addr);
                    this.setInfo("Tile ready");
                    this.addr.setFits(fits);
                    BuilderRunner.this.rmFits(Thread.currentThread(), fits);
                    if (this.addr.order != 3 || this.addr.z != 0) continue;
                    BuilderRunner.this.setProgressBar((int)this.addr.npix);
                }
                catch (Throwable e) {
                    try {
                        this.addr.setFits(null);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    Aladin.trace(1, "*** " + Thread.currentThread().getName() + " exception !!! (" + e.getMessage() + ")");
                    e.printStackTrace();
                    BuilderRunner.this.context.taskAbort();
                }
            }
            this.setMode(3);
            this.info = "Thread died";
            BuilderRunner.this.rmThread(Thread.currentThread());
        }
    }
}

