/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Tok;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;

public class BuilderPack
extends Builder {
    public static final byte[] MC = new byte[]{80, 67, 75, 50};
    static final int NB_NPIX = 10000;
    static final int INDEX_LEN = 8;
    static final int INDEX_SIZE = 80000;
    public static final int TAILSIZE = 8;
    long startTime = 0L;
    int nbTiles = -1;
    int totalTiles;

    public BuilderPack(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.PACK;
    }

    @Override
    public void supportPack() throws Exception {
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.context.loadProperties(this.context.getOutputPath());
        this.validateFormat();
        String s = this.context.prop.getProperty("hips_cube_depth");
        if (s != null) {
            this.context.setDepth(Integer.parseInt(s));
        }
        if (this.context.getOrder() == -1) {
            this.context.setOrder(this.context.findMaxOrder(this.context.getOutputPath()));
        }
        if (this.context.mocIndex == null) {
            this.context.loadMoc();
        }
    }

    protected void validateFormat() throws Exception {
        String s = this.context.prop.getProperty("hips_tile_format");
        if (s == null) {
            s = this.context.prop.getProperty("format");
        }
        if (this.getTileFormatAsArray() == null) {
            if (s == null) {
                throw new Exception("tile format unknown");
            }
            Tok tok = new Tok(s);
            while (tok.hasMoreTokens()) {
                this.context.addTileFormat(tok.nextToken());
            }
        }
    }

    @Override
    public void run() throws Exception {
        this.build();
        if (this.nbTiles == 0) {
            this.context.warning("No packed tiles to be processed");
        } else {
            this.context.stat(this.nbTiles + " really processed");
            if (!this.context.isTaskAborting()) {
                this.context.writeMetaFile();
            }
        }
    }

    protected String getTileFormat() {
        return this.context.getTileFormat();
    }

    protected ArrayList<String> getTileFormatAsArray() {
        return this.context.tileFormat;
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        this.context.info("Packing " + this.totalTiles + " tiles (fmt=\"" + this.getTileFormat() + "\") [estimation]");
        String pathDir = null;
        RandomAccessFile fbin = null;
        long[] index = new long[10000];
        ArrayList<File> toBeDel = new ArrayList<File>();
        for (String fmt : this.getTileFormatAsArray()) {
            String output = this.context.getOutputPath();
            int depth = this.context.getDepth();
            int tileDepth = this.context.getTileDepth();
            if (fmt.startsWith(".")) {
                fmt = fmt.substring(1);
            }
            if (fmt.equals("index")) {
                output = this.context.getHpxFinderPath();
                fmt = "";
                depth = 1;
            }
            SMoc moc = Moc.createMoc(new FileInputStream(output + Util.FS + "Moc.fits")).getSpaceMoc();
            for (int order = this.context.getOrder(); order >= 0; --order) {
                moc.setMocOrder(order);
                for (int z = 0; z < depth; z += tileDepth) {
                    long odir = -1L;
                    Iterator<Long> it = moc.valIterator();
                    while (it.hasNext()) {
                        long pos;
                        File f;
                        long npix = it.next();
                        int ndir = (int)(npix / 10000L) * 10000;
                        if ((long)ndir != odir) {
                            fbin = this.flush(pathDir, fbin, index, toBeDel);
                            pathDir = output + Util.FS + "Norder" + order + Util.FS + "Dir" + ndir;
                            odir = ndir;
                        }
                        if (!(f = new File(pathDir + Util.FS + "Npix" + npix + (z > 0 ? "_" + z : "") + (fmt.length() > 0 ? "." + fmt : fmt))).exists()) continue;
                        if (fbin == null) {
                            String bin = this.getTargetName(pathDir, fmt, z);
                            File b = new File(bin);
                            if (b.exists()) {
                                b.delete();
                            }
                            fbin = new RandomAccessFile(b, "rw");
                        }
                        index[(int)(npix - (long)ndir)] = pos = this.agregate(fbin, f);
                        toBeDel.add(f);
                        this.updateStat();
                    }
                    fbin = this.flush(pathDir, fbin, index, toBeDel);
                }
            }
        }
    }

    private RandomAccessFile flush(String pathDir, RandomAccessFile fbin, long[] index, ArrayList<File> toBeDel) throws Exception {
        if (fbin != null) {
            this.writeIndex(fbin, index);
            for (int i = 0; i < index.length; ++i) {
                index[i] = 0L;
            }
            fbin.close();
            for (File f : toBeDel) {
                f.delete();
            }
            toBeDel.clear();
            new File(pathDir).delete();
        }
        return null;
    }

    private String getTargetName(String pathDir, String fmt, int z) {
        return pathDir + (z > 0 ? "_" + z : "") + "-" + fmt + ".bin";
    }

    private void writeIndex(RandomAccessFile fbin, long[] index) throws Exception {
        int last;
        int first;
        for (first = 0; first < index.length && index[first] == 0L; ++first) {
        }
        for (last = index.length - 1; last >= first && index[last] == 0L; --last) {
        }
        byte[] t = new byte[(last + 1 - first) * 8];
        long pos = 0L;
        int i = first;
        int off = 0;
        while (i <= last) {
            long c1 = index[i];
            if (c1 == 0L) {
                c1 = pos;
            } else {
                if (pos > c1) {
                    throw new Exception("Pack index corrupted");
                }
                pos = c1;
            }
            BuilderPack.setLeLong(t, off, c1);
            ++i;
            off += 8;
        }
        fbin.seek(fbin.length());
        fbin.write(t);
        this.writeTail(fbin, first, last);
    }

    private void writeTail(RandomAccessFile fbin, int first, int last) throws Exception {
        byte[] t = new byte[8];
        int off = 0;
        BuilderPack.setLeShort(t, off, first);
        BuilderPack.setLeShort(t, off += 2, last);
        off += 2;
        t[off++] = MC[0];
        t[off++] = MC[1];
        t[off++] = MC[2];
        t[off++] = MC[3];
        fbin.seek(fbin.length());
        fbin.write(t);
    }

    public static int getLeShort(byte[] t, int i) {
        return t[i + 1] << 8 | t[i] & 0xFF;
    }

    public static int getLeInt(byte[] t, int i) {
        return t[i + 3] << 24 | (t[i + 2] & 0xFF) << 16 | (t[i + 1] & 0xFF) << 8 | t[i] & 0xFF;
    }

    public static long getLeLong(byte[] t, int i) {
        return (long)BuilderPack.getLeInt(t, i + 4) << 32 | (long)BuilderPack.getLeInt(t, i) & 0xFFFFFFFFL;
    }

    public static void setLeShort(byte[] t, int i, int val) {
        t[i + 1] = (byte)(val >>> 8 & 0xFF);
        t[i] = (byte)(val & 0xFF);
    }

    public static void setLeInt(byte[] t, int i, int val) {
        t[i + 3] = (byte)(0xFF & val >>> 24);
        t[i + 2] = (byte)(0xFF & val >>> 16);
        t[i + 1] = (byte)(0xFF & val >>> 8);
        t[i] = (byte)(0xFF & val);
    }

    public static void setLeLong(byte[] t, int i, long val) {
        int c = (int)(0xFFFFFFFFL & val >>> 32);
        BuilderPack.setLeInt(t, i + 4, c);
        c = (int)(0xFFFFFFFFL & val);
        BuilderPack.setLeInt(t, i, c);
    }

    private long agregate(RandomAccessFile fbin, File ftile) throws Exception {
        byte[] buf = new byte[(int)ftile.length()];
        RandomAccessFile src = new RandomAccessFile(ftile, "r");
        src.read(buf);
        fbin.write(buf, 0, buf.length);
        src.close();
        return fbin.length();
    }

    protected void initStat() throws Exception {
        this.startTime = System.currentTimeMillis();
        this.nbTiles = 0;
        this.totalTiles = 0;
        String output = this.context.getOutputPath();
        if (this.getTileFormat().equals("index")) {
            output = this.context.getHpxFinderPath();
        }
        SMoc moc = Moc.createMoc(new FileInputStream(output + Util.FS + "Moc.fits")).getSpaceMoc();
        for (int o = this.context.getOrder(); o >= 0; --o) {
            moc.setMocOrder(o);
            for (String fmt : this.getTileFormatAsArray()) {
                int d = fmt.endsWith("index") ? 1 : this.context.getDepth();
                this.totalTiles = (int)((long)this.totalTiles + moc.getNbValues() * (long)d);
            }
        }
        int tileDepth = this.context.getTileDepth();
        this.totalTiles /= tileDepth;
    }

    protected void updateStat() {
        ++this.nbTiles;
    }

    @Override
    public void showStatistics() {
        long now = System.currentTimeMillis();
        long cTime = now - this.startTime;
        if (cTime < 2000L) {
            return;
        }
        this.context.stat(this.nbTiles + "/" + this.totalTiles + " tile" + (this.nbTiles > 1 ? "s" : "") + " processed in " + cds.tools.Util.getTemps(cTime * 1000L));
    }
}

