/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.hipsgen.Action;
import cds.hipsgen.BuilderMoc;
import cds.hipsgen.Context;
import cds.moc.SFMoc;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;

public class BuilderMocIndex
extends BuilderMoc {
    public BuilderMocIndex(Context context) {
        super(context);
    }

    @Override
    public void run() throws Exception {
        long t = System.currentTimeMillis();
        String path = this.context.getHpxFinderPath();
        this.flagICRS = this.context.getFrame() == 0;
        this.mocOrderFreq = Util.getMaxOrderFreqByPath(path);
        if (this.mocOrderFreq == -1) {
            this.moc = new SMoc();
        } else {
            this.moc = new SFMoc();
            this.moc.setFreqOrder(this.mocOrderFreq);
        }
        this.mocOrder = Util.getMaxOrderByPath(path);
        this.moc.setSpaceOrder(this.mocOrder);
        String outputFile = path + FS + "Moc.fits";
        String frame = this.getFrame();
        this.moc.setSpaceSys(frame);
        this.generateMoc(this.moc, this.mocOrder, this.mocOrderFreq, path);
        this.moc.write(outputFile);
        long time = System.currentTimeMillis() - t;
        this.context.info("MOC Index done in " + cds.tools.Util.getTemps(time * 1000L) + ": mocOrder=" + this.moc.getSpaceOrder() + (this.mocOrderFreq >= 0 ? "_" + this.moc.getFreqOrder() : "") + "  frame=" + frame + " size=" + cds.tools.Util.getUnitDisk(this.moc.getMem()));
    }

    @Override
    public Action getAction() {
        return Action.MOCINDEX;
    }
}

