/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class BuilderMap
extends Builder {
    private int bitpix;
    private double blank;
    private String output;
    private String input;
    private String outputmap;
    private int frame;
    private int losangeWidth;
    private long nside;

    public BuilderMap(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MAP;
    }

    @Override
    public void validateContext() throws Exception {
        this.input = this.context.getInputPath();
        this.output = this.context.getOutputPath();
        File f1 = new File(this.output);
        if (f1.isDirectory()) {
            if (this.context.isExistingHips(this.output) && !this.context.isExistingHips(this.input)) {
                this.context.warning("There is no HiPS in input directory => assuming swapped in/out parameters !");
                this.input = this.output;
            }
            this.outputmap = this.output + Util.FS + "Map.fits";
            this.context.info("The output HEALPix map will be here => " + this.outputmap);
        } else {
            cds.tools.Util.createPath(this.output);
            this.outputmap = this.output;
        }
        if (!this.context.isExistingHips(this.input)) {
            throw new Exception("There is no HiPS in input directory [" + this.input + "]");
        }
        this.nside = this.context.getMapNside();
        this.bitpix = this.context.getBitpix();
        this.blank = this.context.getBlank();
        if (this.bitpix == -1) {
            this.context.loadProperties(this.input);
            try {
                this.frame = this.context.prop.getProperty("hips_frame").startsWith("G") ? 3 : 0;
            }
            catch (Exception e) {
                this.frame = 3;
            }
            try {
                this.bitpix = Integer.parseInt(this.context.prop.getProperty("hips_pixel_bitpix"));
                this.losangeWidth = Integer.parseInt(this.context.prop.getProperty("hips_tile_width"));
            }
            catch (NumberFormatException e) {
                Fits f = new Fits();
                f.loadFITS(Context.findOneNpixFile(this.input, "fits"));
                this.bitpix = f.bitpix;
                this.losangeWidth = f.width;
            }
        } else {
            this.frame = this.context.getFrame();
            this.losangeWidth = this.context.getTileSide();
        }
        int hipsOrder = Integer.parseInt(this.context.prop.getProperty("hips_order"));
        int minNside = this.losangeWidth;
        int maxNside = (int)((double)this.losangeWidth * Math.pow(2.0, hipsOrder));
        if (this.nside < (long)minNside) {
            this.context.warning("nside requested value is too small, setting it to " + minNside);
            this.nside = minNside;
        }
        if (this.nside > (long)maxNside) {
            this.context.warning("nside requested value is too large, setting it to " + maxNside);
            this.nside = maxNside;
        }
        if (this.bitpix > 0 && (this.context.getBZero() != 0.0 || this.context.getBScale() != 1.0)) {
            this.bitpix = -32;
            this.context.warning("Coding in real values due to BZERO/BSCALE factors");
        }
    }

    @Override
    public void run() throws Exception {
        this.exportHpx();
        String tForm = this.bitpix == 8 ? "I" : (this.bitpix == 16 ? "I" : (this.bitpix == 32 ? "J" : (this.bitpix == -32 ? "E" : "D")));
        this.context.info("HEALPix map generation in progress: NSIDE=" + this.nside + " frame=" + this.context.getFrameCode() + " TFORM=1" + tForm + " in " + this.output + Util.FS + "Map.fits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportHpx() throws Exception {
        try (FileOutputStream f = null;){
            f = new FileOutputStream(this.outputmap);
            int size = 0;
            int orderLosange = (int)CDSHealpix.log2(this.losangeWidth);
            int orderMap = (int)CDSHealpix.log2(this.nside);
            int nbits = Math.abs(this.bitpix) / 8;
            int orderTile = (int)CDSHealpix.log2(this.nside / (long)this.losangeWidth);
            long nbHpxPix = (long)(12.0 * Math.pow(4.0, orderTile));
            boolean ring = false;
            int lenLine = 1024;
            Vector v = Save.generateHealpixHDU0(false);
            size = Save.writeFitsLines(f, v, size);
            byte[] end = Save.getEndBourrage(size);
            ((OutputStream)f).write(end);
            size += end.length;
            double badData = Double.NaN;
            if (this.bitpix > 0 && !Double.isNaN(this.blank)) {
                badData = this.blank;
            }
            v = Save.generateHealpixHDU1(orderMap, this.bitpix, ring, lenLine, this.frame, badData);
            size = Save.writeFitsLines(f, v, size);
            end = Save.getEndBourrage(size);
            ((OutputStream)f).write(end);
            size += end.length;
            byte[] buf = new byte[lenLine * nbits];
            int pos = 0;
            int nbPix = this.losangeWidth * this.losangeWidth;
            byte[] nan = new byte[nbPix * nbits];
            for (int i = 0; i < nbPix; ++i) {
                PlanImage.setPixVal(nan, this.bitpix, i, Double.NaN);
            }
            int[] hpx2xy = Util.createHpx2xy(orderLosange);
            int i = 0;
            while ((long)i < nbHpxPix) {
                boolean found = true;
                String filename = Util.getFilePath(this.input, orderTile, (long)i);
                Fits los = new Fits();
                try {
                    los.loadFITS(filename + ".fits");
                }
                catch (FileNotFoundException e) {
                    found = false;
                }
                if (!found) {
                    if (pos != 0) {
                        ((OutputStream)f).write(buf, 0, pos);
                        size += pos;
                        pos = 0;
                    }
                    ((OutputStream)f).write(nan);
                    pos = 0;
                    size += nan.length;
                    if ((double)size > Math.pow(2.0, 30.0)) {
                        size -= 929741760;
                    }
                } else {
                    for (int ipix = 0; ipix < nbPix; ++ipix) {
                        int idx = hpx2xy[ipix];
                        int yy = idx / this.losangeWidth;
                        int xx = idx - yy * this.losangeWidth;
                        double val = los.getPixelFull(xx, yy);
                        if (this.bitpix < 0 && los.isBlankPixel(val)) {
                            val = Double.NaN;
                        }
                        PlanImage.setPixVal(buf, this.bitpix, pos++, val);
                        if (pos != lenLine) continue;
                        ((OutputStream)f).write(buf);
                        pos = 0;
                        size += buf.length;
                        if (!((double)size > Math.pow(2.0, 30.0))) continue;
                        size -= 929741760;
                    }
                }
                ++i;
            }
            if (pos > 0) {
                ((OutputStream)f).write(buf, 0, pos);
                size += pos;
                if ((double)size > Math.pow(2.0, 30.0)) {
                    size -= 929741760;
                }
            }
            end = Save.getEndBourrage(size);
            ((OutputStream)f).write(end);
            int n = size + end.length;
        }
    }
}

