/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.moc.SMoc;
import cds.mocmulti.MultiMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public class BuilderLint
extends Builder {
    public static int TIMEOUT = 60000;
    private String path;
    private boolean flagRemote;
    private String FS;
    private MyProperties prop = null;
    private String id;
    private boolean flagImage;
    private boolean flagCatalog;
    private boolean flagCube;
    private boolean flagICRS;
    private boolean flagCDS;
    private double skyFraction;
    private int order;
    private int minOrder;
    private int version;
    private int tileWidth;
    private int frame;
    private int depth;
    private int bitpix;
    private SMoc moc;
    private ArrayList<String> extensions;
    private boolean flagMinOrderSet = false;
    private boolean flagError;
    private boolean flagWarning;
    private static String[] PROP_REQ = new String[]{"creator_did", "obs_title", "hips_version", "hips_release_date", "hips_status", "hips_frame", "hips_order", "hips_tile_format", "dataproduct_type", "hips_cube_depth"};
    private static String[] PROP_SHOULD = new String[]{"obs_description", "prov_progenitor", "obs_regime", "hips_creation_date", "hips_cat_nrows", "hips_initial_ra", "hips_initial_dec", "hips_initial_fov", "t_min", "t_max", "em_min", "em_max"};
    private static String[] PROP_OTHERS = new String[]{"publisher_id", "obs_collection", "obs_ack", "bib_reference", "bib_reference_url", "obs_copyright", "obs_copyright_url", "data_ucd", "hips_builder", "hips_creator", "hips_service_url", "hips_estsize", "hips_tile_width", "hips_pixel_cut", "hips_data_range", "hips_sampling", "hips_overlay", "hips_skyval", "hips_pixel_bitpix", "data_pixel_bitpix", "hips_progenitor_url", "hips_cube_firstframe", "data_cube_crpix3", "data_cube_crval3", "data_cube_cdelt3", "hips_pixel_scale", "s_pixel_scale", "client_category", "client_sort_key", "addendum_did", "moc_sky_fraction", "dataproduct_subtype"};
    private static String[] PROP_NUMBERS = new String[]{"hips_cube_depth", "hips_cat_nrows", "hips_initial_ra", "hips_initial_dec", "hips_initial_fov", "t_min", "t_max", "em_min", "em_max", "hips_estsize", "hips_tile_width", "hips_pixel_bitpix", "data_pixel_bitpix", "hips_cube_firstframe", "data_cube_crpix3", "data_cube_crval3", "data_cube_cdelt3", "hips_pixel_scale", "s_pixel_scale", "moc_sky_fraction"};
    private static String[] PROP_2NUMBERS = new String[]{"hips_pixel_cut", "hips_data_range"};
    private static String[] PROP_BITPIX = new String[]{"hips_pixel_bitpix", "data_pixel_bitpix"};
    protected static String[] STATUS_PUB = new String[]{"private", "public"};
    protected static String[] STATUS_MIRROR = new String[]{"master", "mirror", "partial"};
    protected static String[] STATUS_CLONE = new String[]{"clonable", "unclonable", "clonableOnce"};
    private static String[] TILE_FORMAT = new String[]{"fits", "jpeg", "png", "tsv"};
    private static String[] OBS_REGIME = new String[]{"Radio", "Millimeter", "Infrared", "Optical", "UV", "EUV", "X-ray", "Gamma-ray"};

    protected BuilderLint(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.LINT;
    }

    @Override
    public void validateContext() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.lint();
    }

    protected MyProperties getProperties() throws Exception {
        if (this.prop == null) {
            throw new Exception("Properties not loaded yet. Use lint() before !");
        }
        return this.prop;
    }

    protected int lint() throws Exception {
        this.flagError = false;
        this.flagWarning = false;
        this.flagCube = false;
        this.flagCatalog = false;
        this.flagImage = false;
        this.flagICRS = false;
        this.minOrder = 3;
        this.order = -1;
        this.bitpix = -1;
        this.tileWidth = -1;
        this.skyFraction = -1.0;
        this.depth = 1;
        this.id = "null";
        this.flagCDS = this.context.isCDSLint();
        this.extensions = new ArrayList();
        this.path = this.context.getOutputPath();
        if (this.path == null) {
            throw new Exception("filepath or URL required");
        }
        if (this.path.startsWith("http:") || this.path.startsWith("https:")) {
            this.context.info("Lint remote HiPS: " + this.path);
            this.flagRemote = true;
            this.FS = "/";
        } else {
            this.context.info("Lint local HiPS: " + this.path);
            this.flagRemote = false;
            this.FS = Util.FS;
        }
        this.lintProperties();
        this.lintMoc();
        if (this.context.hipslintTileTest) {
            this.lintTile(3);
        }
        this.lintAllsky();
        if (this.flagCatalog) {
            this.lintMetadata();
        }
        this.lintMiscFiles();
        if (this.flagError) {
            this.context.info("*** HiPS " + this.id + " is not IVOA HiPS 1.0 compatible");
        } else if (this.flagWarning) {
            this.context.info("!!! HiPS " + this.id + " is IVOA HiPS 1.0 compatible but with warnings");
        } else {
            this.context.info("HiPS " + this.id + " is fully IVOA HiPS 1.0 compatible");
        }
        return this.flagError ? 0 : (this.flagWarning ? -1 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintMetadata() throws Exception {
        boolean flagError = false;
        boolean flagWarning = false;
        String f = this.path + this.FS + "metadata.xml";
        MyInputStream in = null;
        try {
            in = Util.openAnyStream(f, false, false, TIMEOUT);
            long type = in.getType();
            if ((type & 0x100L) == 0L) {
                this.context.error("Lint[4.4.3] \"metadata.xml\" format error (expecting \"votable\", found [" + MyInputStream.decodeType(type) + "])");
                flagError = true;
            }
            in.close();
        }
        catch (Exception e) {
            this.context.error("Lint[4.4.3] \"metadata.xml\" is missing");
            flagError = true;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!flagError) {
            this.context.info("Lint: \"metadata.xml\" ok");
        }
        this.flagError |= flagError;
        this.flagWarning |= flagWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintMiscFiles() throws Exception {
        String f = this.path + this.FS + "preview.jpg";
        MyInputStream in = null;
        try {
            try {
                in = Util.openAnyStream(f, false, false, TIMEOUT);
                long type = in.getType();
                if (type != 2L) {
                    this.context.error("Lint[4.4.4] \"preview.jpg\" format error (expecting \"jpeg\", found [" + MyInputStream.decodeType(type) + "])");
                    this.flagError = true;
                }
                in.close();
                in = null;
            }
            catch (Exception e) {
                this.context.info("Lint[4.4.4] no \"preview.jpg\" file");
            }
            f = this.path + this.FS + "index.html";
            try {
                in = Util.openAnyStream(f, false, false, TIMEOUT);
                in.close();
                in = null;
            }
            catch (Exception e) {
                this.context.info("Lint[4.4.5] no \"index.html\" file");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintAllsky() throws Exception {
        MyInputStream in = null;
        try {
            for (String ext : this.extensions) {
                boolean found = false;
                for (int o = 0; o <= 3; ++o) {
                    String suffix = "Norder" + o + this.FS + "Allsky" + ext;
                    String f = this.path + this.FS + suffix;
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        in = Util.openAnyStream(f, false, false, TIMEOUT);
                        long type = in.getType();
                        if (ext.equals(".jpg") && type != 2L || ext.equals(".png") && type != 65536L || ext.equals(".fits") && (type & 1L) != 1L || ext.equals(".tsv") && (type & 0x2000L) != 8192L) {
                            this.context.error("Lint[4.2.1.3] Allsky format error (expecting \"" + ext + "\", found [" + MyInputStream.decodeType(type) + "])");
                            this.flagError = true;
                        }
                        if (ext.equals(".fits") && (type & 0x20L) != 0L) {
                            this.context.warning("Lint[4.2.1.3] Allsky.fits gzipped (deprecated method)");
                        }
                        Fits fits = null;
                        if (!this.flagRemote) {
                            if (ext.equals(".fits")) {
                                fits = new Fits();
                                fits.loadFITS(in);
                            } else if (ext.equals(".jpg") || ext.equals(".png")) {
                                fits = new Fits();
                                fits.loadPreview(in);
                            }
                        }
                        this.context.info("Lint: Allsky found [" + suffix + "] ok");
                        found = true;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (found) continue;
                this.context.info("Lint[4.3.2] Allsky not found (order 0 to 3)");
            }
            if (in != null) {
                in.close();
            }
            in = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private long getOneNpix() throws Exception {
        if (this.moc != null && !this.moc.isEmpty()) {
            int shift;
            int nb = this.moc.getNbRanges();
            int i = (int)(Math.random() * (double)nb);
            long npix = (this.moc.seeRangeList().begins(i) + (this.moc.seeRangeList().ends(i) - 1L)) / 2L;
            int orderMoc = this.moc.getMocOrder();
            if (orderMoc < this.order) {
                shift = (this.order - orderMoc) * 2;
                long npix1 = npix << shift;
                long npix2 = npix + 1L << shift;
                npix = (npix1 + npix2) / 2L;
            } else if (orderMoc > this.order) {
                shift = (orderMoc - this.order) * 2;
                npix >>= shift;
            }
            int frameMoc = Context.getFrameVal(this.moc.getSpaceSys());
            if (this.frame != frameMoc) {
                double[] radec = CDSHealpix.pix2ang_nest(this.order, npix);
                radec = CDSHealpix.polarToRadec(new double[]{radec[0], radec[1]});
                Coord co = new Coord(radec[0], radec[1]);
                co = Localisation.frameToFrame(co, this.frame, frameMoc);
                radec = CDSHealpix.radecToPolar(new double[]{co.al, co.del});
                npix = CDSHealpix.ang2pix_nest(this.order, radec[0], radec[1]);
            }
            return npix;
        }
        if (!this.flagRemote) {
            File npix;
            String name;
            File f = new File(this.path + this.FS + "Norder" + this.order);
            File[] dirs = f.listFiles();
            int i = (int)(Math.random() * (double)dirs.length);
            if (i >= dirs.length) {
                i = dirs.length - 1;
            }
            File dir = dirs[i];
            dirs = dir.listFiles();
            i = (int)(Math.random() * (double)dirs.length);
            if (i >= dirs.length) {
                i = dirs.length - 1;
            }
            if ((i = (name = (npix = dirs[i]).getName()).lastIndexOf(46)) == -1) {
                i = name.length();
            }
            String s = name.substring(4, i);
            return Long.parseLong(s);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintTile(int n) throws Exception {
        boolean flagError = false;
        boolean flagWarning = false;
        int lowOrder = -1;
        HashSet<String> dejaTeste = new HashSet<String>();
        MyInputStream in = null;
        try {
            for (int j = 0; j < n; ++j) {
                long npix1 = this.getOneNpix();
                if (npix1 == -1L) {
                    this.context.info("Lint: tile test cancelled");
                    return;
                }
                int z = 0;
                if (j > 0 && (z = (int)(Math.random() * (double)this.depth)) >= this.depth) {
                    z = this.depth - 1;
                }
                for (String ext : this.extensions) {
                    boolean found = false;
                    long npix = npix1;
                    String first = null;
                    String last = null;
                    lowOrder = -1;
                    int o = this.order;
                    while (o >= 0) {
                        block47: {
                            String suffix = BuilderLint.getFilePath(o, npix, z, this.FS) + ext;
                            String f = this.path + this.FS + suffix;
                            if (lowOrder == -1 || o < lowOrder) {
                                first = suffix;
                            }
                            if (dejaTeste.contains(f)) {
                                if (lowOrder == -1 || o < lowOrder) {
                                    lowOrder = o;
                                }
                            } else {
                                dejaTeste.add(f);
                                try {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    in = Util.openAnyStream(f, false, false, TIMEOUT);
                                    long type = in.getType();
                                    if (ext.equals(".jpg") && type != 2L || ext.equals(".png") && type != 65536L || ext.equals(".fits") && (type & 1L) != 1L || ext.equals(".tsv") && (type & 0x2000L) != 8192L) {
                                        this.context.error("Lint[4.2.1.3] tile format error (expecting \"" + ext + "\", found [" + MyInputStream.decodeType(type) + "])");
                                        flagError = true;
                                    }
                                    if (ext.equals(".fits") && (type & 0x20L) != 0L) {
                                        this.context.warning("Lint[4.2.1.3] fits tile gzipped (deprecated method) [" + suffix + "]");
                                    }
                                    Fits fits = null;
                                    if (!this.flagRemote) {
                                        if (ext.equals(".fits")) {
                                            fits = new Fits();
                                            fits.loadFITS(in);
                                        } else if (ext.equals(".jpg") || ext.equals(".png")) {
                                            fits = new Fits();
                                            fits.loadPreview(in);
                                        }
                                    }
                                    found = true;
                                    if (last == null) {
                                        last = suffix;
                                    }
                                    if (lowOrder == -1 || o < lowOrder) {
                                        lowOrder = o;
                                    }
                                    boolean ok = true;
                                    if (fits != null) {
                                        double o1;
                                        if (fits.width != fits.height) {
                                            this.context.error("Lint[4.2.1] not square tile [" + fits.width + "x" + fits.height + "]");
                                            flagError = true;
                                        }
                                        if ((o1 = Math.log10(fits.width) / Math.log10(2.0)) != (double)((long)o1)) {
                                            this.context.error("Lint[4.2.1] tile width error [" + fits.width + "x" + fits.height + "]");
                                            ok = false;
                                        }
                                        if (this.tileWidth != -1 && this.tileWidth != fits.width) {
                                            this.context.error("Lint[4.2.1] tile width not conform to hips_tile_width [" + fits.width + "!=" + this.tileWidth + "]");
                                            ok = false;
                                        }
                                        if (ext.equals(".fits") && this.bitpix != -1 && this.bitpix != fits.bitpix) {
                                            this.context.error("Lint[4.2.1] tile bitpix not conform to hips_pixel_bitpix [" + fits.bitpix + "!=" + this.bitpix + "]");
                                            ok = false;
                                        }
                                    }
                                    if (!ok) {
                                        flagError = true;
                                    }
                                }
                                catch (Exception e1) {
                                    String s1;
                                    if (!found) break block47;
                                    String string = s1 = e1.getMessage() != null ? " (" + e1.getMessage() + ")" : "";
                                    if (!this.flagMinOrderSet || o < this.minOrder) break block47;
                                    this.context.error("Lint[4.1] tile missing [" + o + "/" + npix + " => " + f + "]" + s1);
                                    flagError = true;
                                }
                            }
                        }
                        --o;
                        npix /= 4L;
                    }
                    if (!found) {
                        if (!this.flagMinOrderSet || lowOrder <= this.minOrder) continue;
                        this.context.error("Lint[4.1] tile hierarchy missing [" + first + " ... " + last + "] claiming to start at order " + this.minOrder);
                        flagError = true;
                        continue;
                    }
                    if (!found) continue;
                    this.context.info("Lint: tile test hierarchy [" + first + " ... " + last + "] ok");
                }
                if (flagError) {
                    n = j;
                }
                if (in != null) {
                    in.close();
                }
                in = null;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.flagMinOrderSet && lowOrder != -1 && lowOrder != this.minOrder) {
            this.context.error("Lint[4.1] min order found in the tile hierarchy [" + lowOrder + "] not conform [hips_min_order=" + this.minOrder + "]");
        } else if (lowOrder > 0) {
            this.context.info("Lint: not all low tile hierarchy is provided [realMinOrder=" + lowOrder + " (greater than 0)]");
        } else if (lowOrder == 0) {
            this.context.info("Lint: Low orders provided [0..2]");
        }
        this.flagError |= flagError;
        this.flagWarning |= flagWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintMoc() throws Exception {
        boolean flagError = false;
        boolean flagWarning = false;
        if (!this.flagICRS && this.skyFraction < 1.0 && this.skyFraction >= 0.0) {
            return;
        }
        MyInputStream in = null;
        try {
            try {
                String f = this.path + this.FS + "Moc.fits";
                in = Util.openAnyStream(f, false, false, TIMEOUT);
            }
            catch (Exception e) {
                if (this.flagICRS) {
                    this.context.warning("lint[4.4.2] \"Moc.fits\" file missing");
                    flagWarning = true;
                }
                this.context.warning("lint[4.4.2] no \"Moc.fits\" file");
            }
            try {
                this.moc = new SMoc();
                this.moc.read(in);
                in.close();
                in = null;
                String frame = this.moc.getSpaceSys();
                if (!frame.equals("C")) {
                    this.context.warning("Lint[4.4.2] \"Moc.fits\" coordinate system error, ICRS expecting, found [" + frame + "]");
                    flagWarning = true;
                }
            }
            catch (Exception e) {
                this.context.error("Lint[4.4.2] \"Moc.fits\" error");
                flagError = true;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!flagError) {
            this.context.info("Lint: \"Moc.fits\" ok");
        }
        this.flagError |= flagError;
        this.flagWarning |= flagWarning;
    }

    public static boolean checkPropertiesSyntax(MyProperties prop, boolean v, Context context) {
        boolean res = true;
        int i = 0;
        Tok tok = new Tok(prop.getPropOriginal(), "\n\r");
        while (tok.hasMoreTokens()) {
            int n;
            ++i;
            String s = tok.nextToken();
            if (s.trim().length() == 0 || s.charAt(0) == '#') continue;
            int a = s.indexOf(61);
            if (a < 0) {
                res = false;
                if (s.trim().charAt(0) == '#') {
                    BuilderLint.warning("Lint: erroneous comment in \"properties\" file [" + BuilderLint.trunc(s) + "]", v, context);
                    continue;
                }
                context.warning("Lint: split field line " + i + " in \"properties\" file [" + BuilderLint.trunc(s) + "]");
                continue;
            }
            String w = s.substring(0, a - 1).trim();
            if (w.charAt(0) == '#') {
                res = false;
                BuilderLint.warning("Lint: erroneous comment in \"properties\" file line " + i + " [" + BuilderLint.trunc(s) + "]", v, context);
            }
            if ((n = w.indexOf(32)) < 0) {
                w.indexOf(9);
            }
            if (n > 0) {
                res = false;
                BuilderLint.warning("Lint: suspicious multiwords key in \"properties\" file line " + i + " [" + w + "]", v, context);
            }
            if ((n = (w = s.substring(a + 1)).indexOf(9)) <= 0) continue;
            res = false;
            BuilderLint.warning("Lint: erroneous field with TAB in \"properties\" file line " + i + " [" + BuilderLint.trunc(s) + "]", v, context);
        }
        return res;
    }

    private static void warning(String s, boolean verbose, Context context) {
        if (!verbose) {
            return;
        }
        context.warning(s);
    }

    private static String trunc(String s) {
        if (s.length() < 30) {
            return s;
        }
        return s.substring(0, 28) + "...";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintProperties() throws Exception {
        int i;
        boolean flagError = false;
        boolean flagWarning = false;
        MyInputStream in = null;
        try {
            String f = this.path + this.FS + "properties";
            in = Util.openAnyStream(f, false, false, TIMEOUT);
            InputStreamReader isr = new InputStreamReader((InputStream)in, "UTF-8");
            this.prop = new MyProperties();
            this.prop.load(isr, true, false);
            in.close();
            in = null;
        }
        catch (Exception e1) {
            this.context.error("Lint[4.4] \"properties\" file missing");
            flagError = true;
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception isr) {}
            }
        }
        BuilderLint.checkPropertiesSyntax(this.prop, true, this.context);
        boolean[] propReq = new boolean[PROP_REQ.length];
        boolean[] propShould = new boolean[PROP_SHOULD.length];
        StringBuilder propUnref = null;
        ArrayList<String> propUnrefArray = new ArrayList<String>();
        String s = this.prop.get("hips_version");
        this.version = BuilderLint.getVersion(s);
        if (this.version == -1) {
            this.context.error("Lint[4.4.1] hips_version missing or syntax error [" + s + "]");
            flagError = true;
        } else if (this.version < 140) {
            this.context.info("Lint: hips_version precedes the IVOA HiPS 1.0 standard (hips_version 1.4) [" + s + "]");
        } else if (this.version > 140) {
            this.context.warning("Lint: hips_version supersedes the IVOA HiPS 1.0 standard (hips_version 1.4)  [" + s + "]");
        }
        for (String key : this.prop.getKeys()) {
            if (key.startsWith("#") || key.trim().length() == 0) continue;
            boolean flagMult = false;
            String s1 = this.prop.get(key);
            if (s1 == null || s1.length() == 0) {
                this.context.warning("Lint: No associated value for keyword [" + key + "]");
            } else if (s1.indexOf("\t") >= 0) {
                flagMult = true;
            }
            i = Util.indexInArrayOf(key, PROP_REQ);
            if (i >= 0) {
                propReq[i] = true;
                if (!flagMult) continue;
                this.context.error("Lint[4.4.1] redundant value for keyword [" + key + "] not allowed");
                flagError = true;
                continue;
            }
            i = Util.indexInArrayOf(key, PROP_SHOULD);
            if (i >= 0) {
                propShould[i] = true;
                continue;
            }
            String keyx = BuilderLint.withoutNumSuffix(key);
            i = Util.indexInArrayOf(keyx, PROP_OTHERS);
            if (i >= 0 || propUnrefArray.contains(keyx)) continue;
            propUnrefArray.add(keyx);
            if (propUnref == null) {
                propUnref = new StringBuilder(keyx);
                continue;
            }
            propUnref.append("," + keyx);
        }
        if (propUnref != null) {
            this.context.info("Lint: unreferenced properties keyword [" + propUnref + "]");
        }
        if ((s = this.prop.get("dataproduct_type")) != null && !s.equals("cube")) {
            propReq[Util.indexInArrayOf((String)"hips_cube_depth", (String[])BuilderLint.PROP_REQ)] = true;
        }
        for (i = 0; i < propReq.length; ++i) {
            if (propReq[i]) continue;
            this.context.error("Lint[4.4.1] mandatory keyword missing [" + PROP_REQ[i] + "]");
            flagError = true;
        }
        s = this.prop.get("dataproduct_type");
        if (s != null && !s.equals("catalog")) {
            propShould[Util.indexInArrayOf((String)"hips_cat_nrows", (String[])BuilderLint.PROP_SHOULD)] = true;
        }
        for (i = 0; i < propShould.length; ++i) {
            if (propShould[i]) continue;
            this.context.warning("Lint[4.4.1] recommended keyword missing [" + PROP_SHOULD[i] + "]");
            flagWarning = true;
        }
        for (String key : this.prop.getKeys()) {
            if (key.startsWith("#")) continue;
            String s1 = this.prop.get(key);
            if (s1 == null) {
                s1 = "";
            }
            if ((i = Util.indexInArrayOf(key, PROP_NUMBERS)) >= 0) {
                try {
                    Double.parseDouble(s1);
                }
                catch (Exception e) {
                    this.context.warning("Lint[4.4.1] numeric value required for keyword " + key + " [" + s1 + "]");
                    flagWarning = true;
                }
            }
            if ((i = Util.indexInArrayOf(key, PROP_2NUMBERS)) >= 0) {
                StringTokenizer tok = new StringTokenizer(s1, " ");
                try {
                    double deb = Double.parseDouble(tok.nextToken());
                    double fin = Double.parseDouble(tok.nextToken());
                    if (deb >= fin) {
                        this.context.warning("Lint[4.4.1] range syntax error for keyword " + key + " [" + s1 + "]");
                        flagWarning = true;
                    }
                }
                catch (Exception e) {
                    this.context.error("Lint[4.4.1] numeric range required for keyword " + key + " [" + s1 + "]");
                    flagError = true;
                }
            }
            if ((i = Util.indexInArrayOf(key, PROP_BITPIX)) >= 0) {
                try {
                    int bitpix = Integer.parseInt(s1);
                    if (bitpix != 8 && bitpix != 16 && bitpix != 32 && bitpix != 64 && bitpix != -32 && bitpix != -64) {
                        throw new Exception();
                    }
                    if (key.equals("hips_pixel_bitpix")) {
                        this.bitpix = bitpix;
                    }
                }
                catch (Exception e) {
                    this.context.warning("Lint[4.4.1] erroneous BITPIX value for keyword " + key + " [" + s1 + "]");
                    flagWarning = true;
                }
            }
            if (!key.endsWith("_url") || s1.startsWith("http://") || s1.startsWith("https://") || s1.startsWith("ftp://")) continue;
            this.context.warning("Lint[4.4.1] url value required for keyword " + key + " [" + s1 + "]");
            flagWarning = true;
        }
        s = this.prop.get("creator_did");
        if (!(s == null || s.startsWith("ivo://") && s.indexOf(32) < 0)) {
            this.context.error("Lint[4.4.1] creator_did must be an IVOID [" + s + "]");
            flagError = true;
        }
        if ((s = this.prop.get("obs_title")) != null && s.length() > 130) {
            this.context.warning("Lint[4.4.1] too long obs_title [" + s + "]");
            flagWarning = true;
        }
        if ((s = this.prop.get("dataproduct_type")) != null) {
            if (s.equals("image")) {
                this.flagImage = true;
            } else if (s.equals("catalog")) {
                this.flagCatalog = true;
            } else if (s.equals("cube")) {
                this.flagCube = true;
            } else {
                this.context.warning("Lint[4.4.1] unreferenced dataproduct_type [" + s + "]");
                flagWarning = true;
            }
        }
        if (!(this.flagImage || this.flagCatalog || this.flagCube)) {
            this.context.warning("Lint: unreferenced HiPS type (no image, nor catalog, nor cube)");
        }
        if ((s = this.prop.get("hips_release_date")) != null && !BuilderLint.checkDate(s)) {
            this.context.error("Lint[4.4.1] not ISO 8601 date [" + s + "]");
            flagError = true;
        }
        if ((s = this.prop.get("hips_status")) != null) {
            StringBuilder statusUnref = null;
            boolean flagPub = false;
            boolean flagMirror = false;
            boolean flagClone = false;
            StringTokenizer tok = new StringTokenizer(s, " ");
            while (tok.hasMoreTokens()) {
                String s1 = tok.nextToken();
                i = Util.indexInArrayOf(s1, STATUS_PUB);
                if (i >= 0) {
                    if (flagPub) {
                        this.context.error("Lint[4.4.1] hips_status error redundant definition [private/public]");
                        flagError = true;
                        continue;
                    }
                    flagPub = true;
                    continue;
                }
                i = Util.indexInArrayOf(s1, STATUS_MIRROR);
                if (i >= 0) {
                    if (flagMirror) {
                        this.context.error("Lint[4.4.1] hips_status error redundant definition [master/mirror/partial]");
                        flagError = true;
                        continue;
                    }
                    flagMirror = true;
                    continue;
                }
                i = Util.indexInArrayOf(s1, STATUS_CLONE);
                if (i >= 0) {
                    if (flagClone) {
                        this.context.error("Lint[4.4.1] hips_status error redundant definition [clonable/unclonable/clonableOnce]");
                        flagError = true;
                        continue;
                    }
                    flagClone = true;
                    continue;
                }
                if (s1.indexOf(",") > 0) {
                    this.context.error("Lint[4.4.1] hips_status comma separator error [" + s1 + "]");
                    flagError = true;
                    continue;
                }
                if (statusUnref == null) {
                    statusUnref = new StringBuilder(s1);
                    continue;
                }
                statusUnref.append("," + s1);
            }
            if (statusUnref != null) {
                this.context.warning("Lint: unreferenced hips_status keywords [" + statusUnref + "]");
            }
        }
        if ((s = this.prop.get("hips_tile_format")) != null) {
            StringBuilder formatUnref = null;
            boolean flagCat = false;
            StringTokenizer tok = new StringTokenizer(s, " ");
            while (tok.hasMoreTokens()) {
                String s1 = tok.nextToken();
                i = Util.indexInArrayOf(s1, TILE_FORMAT);
                if (i < 0) {
                    if (s1.indexOf(",") > 0) {
                        this.context.error("Lint[4.4.1] hips_tile_format comma separator error [" + s1 + "]");
                        flagError = true;
                    } else if (formatUnref == null) {
                        formatUnref = new StringBuilder(s1);
                    } else {
                        formatUnref.append("," + s1);
                    }
                } else if (s1.equals("tsv")) {
                    flagCat = true;
                }
                if (s1.equals("jpeg")) {
                    this.extensions.add(".jpg");
                    continue;
                }
                this.extensions.add("." + s1);
            }
            if (this.flagCatalog && !flagCat) {
                this.context.warning("Lint[4.4.1] HiPS catalog without [tsv] hips_tile_format");
                flagWarning = true;
            }
            if (formatUnref != null) {
                this.context.warning("Lint: unreferenced hips_status keywords [" + formatUnref + "]");
            }
        }
        if ((s = this.prop.get("hips_order")) != null) {
            try {
                this.order = Integer.parseInt(s);
            }
            catch (Exception formatUnref) {
                // empty catch block
            }
            if (this.order < 0 || this.order > 29) {
                this.context.error("Lint[4.4.1] hips_order error [" + s + "]");
                flagError = true;
            }
        }
        if ((s = this.prop.get("hips_order_min")) != null) {
            try {
                this.minOrder = Integer.parseInt(s);
                this.flagMinOrderSet = true;
            }
            catch (Exception formatUnref) {
                // empty catch block
            }
            if (this.minOrder < 0 || this.minOrder > 29) {
                this.context.error("Lint[4.4.1] hips_order_min error [" + s + "]");
                flagError = true;
            }
        } else if (this.flagCatalog) {
            this.minOrder = 0;
        }
        if ((s = this.prop.get("hips_tile_width")) != null) {
            try {
                this.tileWidth = Integer.parseInt(s);
            }
            catch (Exception formatUnref) {
                // empty catch block
            }
            double x = Math.log10(this.tileWidth) / Math.log10(2.0);
            if (x < 0.0 || x != (double)((int)x)) {
                this.context.error("Lint[4.2.1] hips_tile_width error [" + s + "]");
                flagError = true;
            }
        }
        if ((s = this.prop.get("hips_frame")) != null) {
            this.flagICRS = s.equals("equatorial");
            if (!(this.flagICRS || s.equals("galactic") || s.equals("ecliptic"))) {
                this.context.warning("Lint[4.4.1] unreferenced hips_frame [" + s + "]");
                flagWarning = true;
            }
            this.frame = Context.getFrameVal(s);
        }
        if ((s = this.prop.get("moc_sky_fraction")) != null) {
            try {
                this.skyFraction = Double.parseDouble(s);
            }
            catch (Exception x) {
                // empty catch block
            }
            if (this.skyFraction < 0.0 || this.skyFraction > 1.0) {
                this.context.warning("Lint[4.4.1] moc_sky_fraction value error [" + s + "]");
                flagWarning = true;
            }
        }
        if ((s = this.prop.get("hips_cube_depth")) != null) {
            try {
                this.depth = Integer.parseInt(s);
            }
            catch (Exception x) {
                // empty catch block
            }
            if (this.depth <= 0) {
                this.context.error("Lint[4.4.1] hips_cube_depth value error [" + s + "]");
                flagError = true;
            }
        }
        StringBuilder unrefObsRegime = null;
        s = this.prop.get("obs_regime");
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, "\t");
            while (tok.hasMoreTokens()) {
                String s1 = tok.nextToken();
                i = Util.indexInArrayOf(s1, OBS_REGIME);
                if (i >= 0) continue;
                if (s1.indexOf(",") > 0 || s1.indexOf(" ") > 0) {
                    this.context.warning("Lint[4.4.1] obs_regime comma or space separator not allowed [" + s1 + "]");
                    flagWarning = true;
                    continue;
                }
                if (unrefObsRegime == null) {
                    unrefObsRegime = new StringBuilder(s1);
                    continue;
                }
                unrefObsRegime.append("," + s1);
            }
            if (unrefObsRegime != null) {
                this.context.warning("Lint[4.4.1] unreferenced obs_regime [" + unrefObsRegime + "]");
                flagWarning = true;
            }
        }
        if (this.flagCDS && (s = this.prop.get("client_category")) == null) {
            this.context.warning("Lint[CDS] client_category missing");
        }
        this.id = MultiMoc.getID(this.prop);
        if (!flagError) {
            this.context.info("Lint: \"properties\" file ok");
        } else if (!flagError) {
            this.context.info("Lint: \"properties\" file warning");
        }
        this.flagError |= flagError;
        this.flagWarning |= flagWarning;
    }

    private static int getVersion(String s) {
        try {
            return (int)(Double.parseDouble(s) * 100.0);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean checkDate(String s) {
        int mode = 0;
        int n = s.length();
        if (s.endsWith("Z")) {
            --n;
        }
        block9: for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            switch (mode) {
                case 0: {
                    if (ch == '-') {
                        mode = 1;
                        continue block9;
                    }
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
                case 1: {
                    if (ch == '-') {
                        mode = 2;
                        continue block9;
                    }
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
                case 2: {
                    if (ch == 'T') {
                        mode = 3;
                        continue block9;
                    }
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
                case 3: {
                    if (ch == ':') {
                        mode = 4;
                        continue block9;
                    }
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
                case 4: {
                    if (ch == ':') {
                        mode = 5;
                        continue block9;
                    }
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
                case 5: {
                    if (ch == '.' || ch == ',') {
                        mode = 6;
                        continue block9;
                    }
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
                case 6: {
                    if (Character.isDigit(ch)) continue block9;
                    return false;
                }
            }
        }
        return mode == 2 || mode == 4 || mode == 5 || mode == 6;
    }

    private static String withoutNumSuffix(String s) {
        int i = s.lastIndexOf(95);
        if (i < 0) {
            return s;
        }
        try {
            Integer.parseInt(s.substring(i + 1));
            return s.substring(0, i);
        }
        catch (Exception exception) {
            return s;
        }
    }

    private static String getFilePath(int order, long npix, int z, String FS) {
        return "Norder" + order + FS + "Dir" + npix / 10000L * 10000L + FS + "Npix" + npix + (z <= 0 ? "" : "_" + z);
    }
}

