/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.MyInputStream;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderAllsky;
import cds.hipsgen.BuilderCut;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Context;
import cds.hipsgen.ContextGui;
import cds.hipsgen.ModeTree;
import cds.hipsgen.ThreadBuilderTile;
import cds.tools.Util;
import java.awt.image.IndexColorModel;

public class BuilderJpg
extends BuilderRunner {
    private double[] cut;
    protected byte[] tcm;
    private int bitpix;
    private int width;
    private int depth;
    private double blank;
    private double bscale;
    private double bzero;
    protected ModeTree modeHierarchy = null;
    private int statNbFile;
    protected String fmt;
    protected String ext;
    private boolean first = true;

    public BuilderJpg(Context context) {
        super(context);
        this.init();
    }

    @Override
    protected void message() {
        this.context.info("COMPUTING ADDITIONAL JPEG HiPS TILES...");
    }

    protected void init() {
        this.fmt = "jpeg";
        this.ext = ".jpg";
    }

    @Override
    public Action getAction() {
        return Action.JPEG;
    }

    @Override
    public void supportHiPS3D() throws Exception {
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context.cutByImage) {
            super.validateContext();
        } else {
            this.validateOutput();
            if (!this.context.isExistingHips()) {
                throw new Exception("No Fits tile found");
            }
            this.validateHips3D(this.context.getOutputPath());
            this.validateOrder(this.context.getOutputPath());
            this.validateDepth();
            if (!this.context.isColor()) {
                this.validateCut();
            }
            if (this.context.cutByRegion) {
                this.doCutIfRequired();
            }
            this.modeHierarchy = this.context.getModeTree();
            this.context.info("Hierarchy mode (tree): " + ModeTree.getExplanation(this.modeHierarchy));
            try {
                this.context.loadMoc();
            }
            catch (Exception e) {
                this.context.warning("Tile MOC not found => use index MOC");
            }
            if (!this.context.hasFrame()) {
                this.context.setFrameName(this.getFrame());
            }
            this.context.initRegion();
        }
    }

    @Override
    protected String getTileExt() {
        return this.ext;
    }

    protected int getMinCM() {
        return 0;
    }

    @Override
    public void run() throws Exception {
        this.context.resetCheckCode(this.fmt);
        this.build();
    }

    private void doCutIfRequired() throws Exception {
        try {
            String file = Context.findOneNpixFile(this.context.getOutputPath(), "fits", true);
            Fits fits = new Fits(file);
            fits.headerFits.getDoubleFromHeader("CUTMIN");
        }
        catch (Exception e) {
            this.b = new BuilderCut(this.context);
            this.b.run();
            this.b = null;
        }
    }

    @Override
    public boolean isAlreadyDone() {
        if (this.context.isColor()) {
            this.context.info(this.fmt + " conversion not required for Healpix colored survey");
            return true;
        }
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, this.getAction())) {
            return false;
        }
        this.context.info("Pre-existing HEALPix " + this.fmt + " survey seems to be ready");
        return true;
    }

    @Override
    public void showStatistics() {
        if (this.context.cutByImage) {
            super.showStatistics();
        } else {
            if (this.statNbFile > 0) {
                this.context.showJpgStat(this.statNbFile, this.totalTime, this.getNbThreads(), this.getNbThreadRunning());
            }
            if (!(this.context instanceof ContextGui)) {
                super.showStatistics();
            }
        }
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        super.build();
    }

    @Override
    protected void buildPre() throws Exception {
        if (this.context.cutByImage) {
            super.buildPre();
        } else {
            IndexColorModel cm = this.context.getFct() == null ? null : CanvasColorMap.getCM(0, 128, 255, false, 0, this.context.getFct().code(), this.getMinCM() == 1);
            this.tcm = cm == null ? null : Util.getTableCM(cm, 2);
            this.cut = this.context.getCut();
            double bz = this.context.bzero;
            double bs = this.context.bscale;
            if (!this.context.cutByImage) {
                this.context.info("Map pixel cut [" + (this.context.cutByRegion ? "by region" : this.ip(this.cut[0], bz, bs) + " .. " + this.ip(this.cut[1], bz, bs)) + "] to [" + this.getMinCM() + "..255] (" + this.context.getTransfertFct() + ")");
            }
        }
    }

    @Override
    protected void buildPost(long duree) throws Exception {
        if (this.context.cutByImage) {
            super.buildPost(duree);
        } else {
            new BuilderAllsky(this.context).runJpegOrPngOnly(this.fmt);
            if (this.context instanceof ContextGui && ((ContextGui)this.context).mainPanel.planPreview != null) {
                if (this.fmt.equals("jpeg")) {
                    ((ContextGui)this.context).mainPanel.planPreview.inJPEG = true;
                } else {
                    ((ContextGui)this.context).mainPanel.planPreview.inPNG = true;
                }
            }
        }
    }

    protected void activateCache(long size, long sizeCache) {
    }

    @Override
    protected Fits createLeafHpx(ThreadBuilderTile hpx, String file, String path, BuilderRunner.AddrThread item) throws Exception {
        double cutmax;
        double cutmin;
        Fits out = null;
        if (this.context.cutByImage) {
            out = super.createLeafHpx(hpx, file, path, item);
            if (out != null && this.first) {
                this.first = false;
                this.setConstantes(out);
            }
        } else {
            out = this.createLeafJpg(file);
        }
        if (out == null) {
            return null;
        }
        if (this.context.cutByRegion || this.context.cutByImage) {
            cutmin = 1.0;
            cutmax = 255.0;
        } else {
            cutmin = this.cut[0];
            cutmax = this.cut[1];
        }
        out.writeCompressed(file + this.ext, cutmin, cutmax, this.tcm, this.fmt);
        Aladin.trace(4, "Writing " + file + this.ext);
        this.updateStat();
        return out;
    }

    protected void writeLeaf(Fits out, String file, int order, long npix) throws Exception {
    }

    @Override
    protected Fits createNodeHpx(String file, String path, Fits[] fils, BuilderRunner.AddrThread item) throws Exception {
        double cutmax;
        double cutmin;
        Fits out = this.createNodePreview(fils, this.modeHierarchy);
        if (out == null) {
            return null;
        }
        if (this.context.cutByRegion || this.context.cutByImage) {
            cutmin = 1.0;
            cutmax = 255.0;
        } else {
            cutmin = this.cut[0];
            cutmax = this.cut[1];
        }
        out.writeCompressed(file + this.ext, cutmin, cutmax, this.tcm, this.fmt);
        Aladin.trace(4, "Writing " + file + this.ext);
        return out;
    }

    @Override
    protected void setProgressBar(int npix) {
        this.context.setProgress(npix);
    }

    private void initStat() {
        this.context.setProgressMax(768.0);
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    protected void loadLeaf(Fits out, MyInputStream is) throws Exception {
        out.loadPreview(is, true);
    }

    private Fits createLeafJpg(String file) throws Exception {
        Fits out;
        block6: {
            out = null;
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            try {
                out = new Fits();
                out.loadFITS(file + ".fits");
                if (this.first) {
                    this.first = false;
                    this.setConstantes(out);
                }
                if (!this.context.cutByRegion) break block6;
                Fits f8 = new Fits(out.width, out.height, out.depth, 8);
                f8.setBlank(0.0);
                try {
                    double cutmin = out.headerFits.getDoubleFromHeader("CUTMIN");
                    double cutmax = out.headerFits.getDoubleFromHeader("CUTMAX");
                    byte[] buf = out.toPix8(cutmin, cutmax, null, 2);
                    Fits.invImageLine(f8.width, f8.height, f8.depth, buf);
                    f8.pixels = buf;
                    out = f8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("Cut by region error [missing CUTMIN,CUTMAX FITS header values] => launch CUT action before");
                }
            }
            catch (Exception e) {
                out = null;
            }
        }
        return out;
    }

    private void setConstantes(Fits f) {
        this.bitpix = f.bitpix;
        this.blank = f.blank;
        this.bscale = f.bscale;
        this.bzero = f.bzero;
        this.width = f.width;
        this.depth = f.depth;
    }

    private void heriteCutValues(Fits out, Fits[] fils) {
        for (Fits f : fils) {
            if (f == null) continue;
            try {
                out.headerFits.setKeyValue("CUTMIN", f.headerFits.getStringFromHeader("CUTMIN"));
                out.headerFits.setKeyValue("CUTMAX", f.headerFits.getStringFromHeader("CUTMAX"));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean allFilsNull(Fits[] fils) {
        for (Fits f : fils) {
            if (f == null) continue;
            return false;
        }
        return true;
    }

    private Fits createNodePreview(Fits[] fils, ModeTree modeTree) throws Exception {
        if (this.width == 0 || this.allFilsNull(fils)) {
            return null;
        }
        Fits out = new Fits(this.width, this.width, this.depth, this.bitpix);
        out.setBlank(this.blank);
        out.setBscale(this.bscale);
        out.setBzero(this.bzero);
        if (this.context.cutByRegion) {
            this.heriteCutValues(out, fils);
        }
        int nbFils = fils.length;
        int tileDepth = this.depth;
        double[] pixd = new double[nbFils];
        int nStack = this.context.isHips3D ? 2 : 1;
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int offX = dg * this.width >>> 1;
                int offY = (1 - hb) * this.width >>> 1;
                for (int zg = 0; zg < nStack; ++zg) {
                    int quad = (dg << 1 | hb) + zg * 4;
                    int offZ = zg * tileDepth >>> 1;
                    Fits in = fils[quad];
                    for (int z = 0; z < tileDepth; z += nStack) {
                        for (int y = 0; y < this.width; y += 2) {
                            for (int x = 0; x < this.width; x += 2) {
                                double pix = this.blank;
                                int nbPix = 0;
                                if (in != null) {
                                    block6: for (int gz = 0; gz < nStack; ++gz) {
                                        for (int i = 0; i < 4; ++i) {
                                            int gx = i == 1 || i == 3 ? 1 : 0;
                                            int gy = i > 1 ? 1 : 0;
                                            pixd[nbPix] = in.getPixelDouble(x + gx, y + gy, z + gz);
                                            if (in.isBlankPixel(pixd[nbPix])) continue;
                                            ++nbPix;
                                            if (modeTree == ModeTree.treeFirst) break block6;
                                        }
                                    }
                                    pix = nbPix == 0 ? this.blank : (modeTree == ModeTree.treeMean ? this.getMean(pixd, nbPix) : (modeTree == ModeTree.treeMedian ? this.getMedian(pixd, nbPix) : (modeTree == ModeTree.treeMiddle ? this.getMiddle(pixd, nbPix) : pixd[0])));
                                }
                                int xt = offX + (x >>> 1);
                                int yt = offY + (y >>> 1);
                                int zt = offZ + (z >>> (this.context.isHips3D ? 1 : 0));
                                out.setPixelDouble(xt, yt, zt, pix);
                            }
                        }
                    }
                }
            }
        }
        for (int i = 0; i < nbFils; ++i) {
            if (fils[i] == null) continue;
            fils[i].free();
        }
        return out;
    }
}

