/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.aladin.SED;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.BuilderMocIndex;
import cds.hipsgen.BuilderUnpackIndex;
import cds.hipsgen.Context;
import cds.hipsgen.ContextGui;
import cds.hipsgen.MyInputStreamCachedException;
import cds.hipsgen.Param;
import cds.moc.Moc;
import cds.moc.SFMoc;
import cds.moc.SMoc;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;

public class BuilderIndex
extends Builder {
    private int[] borderSize = new int[]{0, 0, 0, 0};
    private String currentfile = null;
    private HashSet<Integer> memoWarning = new HashSet();
    private boolean partitioning;
    private double maxRatio;
    private int[] hdu = null;
    private Moc area;
    private boolean flagAppend;
    private int maxOverlays;
    private int statNbFile;
    private int statNbZipFile;
    private int statBlocFile;
    private long statMemFile;
    private long statPixSize;
    private long statMaxSize;
    private long statTime;
    private int statMaxWidth;
    private int statMaxHeight;
    private int statMaxDepth;
    private int statMaxNbyte;
    private int progenMaxWidth;
    private int progenMaxheight;
    private int progenMaxDepth;
    boolean stopped = false;
    private ArrayList<String> badFiles = null;

    public BuilderIndex(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.INDEX;
    }

    @Override
    public void supportHiPS3D() throws Exception {
    }

    @Override
    public void supportPack() throws Exception {
    }

    private void unpackIfRequired() throws Exception {
        if (!this.context.isPacked(this.context.getHpxFinderPath())) {
            return;
        }
        this.context.info("HiPS index packed found");
        new BuilderUnpackIndex(this.context).run();
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.report();
        this.context.writeHpxFinderProperties();
        BuilderMocIndex builderMocIndex = new BuilderMocIndex(this.context);
        builderMocIndex.run();
        this.context.setMocIndex(builderMocIndex.getMoc());
    }

    private void addBadFile(String file, String error) {
        if (this.badFiles == null) {
            this.badFiles = new ArrayList();
        }
        this.badFiles.add(file + (error != null && error.length() > 0 ? " => " + error : ""));
    }

    private void report() throws Exception {
        if (this.badFiles != null) {
            int n = this.badFiles.size();
            this.context.warning("Index report: " + n + " input file" + (n > 1 ? "s" : "") + " not incorporated:");
            for (String s : this.badFiles) {
                this.context.warning("   " + s);
            }
        }
        if (this.statNbFile == 0) {
            throw new Exception("No available image found ! => Aborted");
        }
        int cellWidth = this.context.getPartitioning();
        int cellDepth = this.context.getPartitioningDepth();
        this.progenMaxWidth = cellWidth > 0 ? Math.min(cellWidth, this.statMaxWidth) : this.statMaxWidth;
        this.progenMaxheight = cellWidth > 0 ? Math.min(cellWidth, this.statMaxHeight) : this.statMaxHeight;
        this.progenMaxDepth = cellDepth > 0 ? Math.min(cellDepth, this.statMaxDepth) : this.statMaxDepth;
        this.context.setProgenMaxCell(this.progenMaxWidth, this.progenMaxheight, this.progenMaxDepth, this.maxOverlays);
        long val = this.progenMaxWidth * this.progenMaxheight * this.progenMaxDepth;
        val *= (long)this.statMaxNbyte;
        String progenMaxs = " [" + this.progenMaxWidth + "x" + this.progenMaxheight + (this.progenMaxDepth > 1 ? "x" + this.progenMaxDepth : "") + "]";
        this.context.info("Max original image overlay estimation: " + this.maxOverlays + progenMaxs + " => may required " + cds.tools.Util.getUnitDisk(val *= (long)this.maxOverlays) + " per thread");
        if (this.maxOverlays > 20) {
            this.context.warning("Suspected high level of overlays (" + this.maxOverlays + ") => PLEASE CHECK YOUR INPUT IMAGES");
        }
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.isExistingIndexDir()) {
            return false;
        }
        if (!this.context.actionAlreadyDone(Action.INDEX)) {
            return false;
        }
        if (this.context.getMocIndex() == null) {
            try {
                this.context.loadMocIndex();
            }
            catch (Exception e) {
                return false;
            }
        }
        this.context.info("Pre-existing HEALPix index seems to be ready");
        return true;
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarIndex());
        }
        this.partitioning = this.context.isPartitioning();
        if (this.partitioning) {
            int bloc = this.context.getPartitioning();
            int d = this.context.getPartitioningDepth();
            if (d <= 1) {
                this.context.info("Partitioning large original image files in blocks of " + bloc + "x" + bloc + " pixels");
            } else {
                String s = bloc == 0 ? " in original img. size " : " in blocks of " + bloc + "x" + bloc;
                this.context.info("Partitioning large original cube files" + s + "x" + d + " channels");
            }
        }
        this.validateInput();
        this.validateOutput();
        this.context.info("Output directory: " + this.context.getHpxFinderPath());
        this.validateLabel();
        boolean bl = this.flagAppend = !this.context.isExistingIndexDir();
        if (!this.flagAppend) {
            this.context.info("Pre-existing HpxFinder index => will add new images only...");
        }
        int order = this.context.getOrder();
        int orderFreq = this.context.getOrderFreq();
        double originalPixelRes = -1.0;
        double originalFreqRes = -1.0;
        double originalFreqChannel0 = 0.0;
        double originalFreqChannelMax = 0.0;
        boolean isCube = false;
        Fits file = null;
        if (order == -1 || this.context.getFitsKeys() == null) {
            String img = this.context.getImgEtalon();
            if (img == null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Reference image/cube => " + img);
            }
            if (img == null) {
                throw new Exception("No source image/cube found in " + this.context.getInputPath());
            }
            try {
                file = new Fits(this.context.getHDU());
                file.setCunit(this.context.getCUnit());
                file.setDefaultRestFreq(this.context.getDefaultRestFreq());
                file.loadHeaderFITS(img, true);
                isCube = file.isCube();
                this.context.defaultFitsKey = this.context.scanDefaultFitsKey(file.headerFits);
                if (file.getCalib() == null) {
                    throw new Exception("Spatial calibration unknown");
                }
                originalPixelRes = file.getCalib().GetResol()[0];
                if (order == -1) {
                    long nside = BuilderIndex.calculateNSide(originalPixelRes * 3600.0);
                    order = Util.order((int)nside) - this.context.getTileOrder();
                    if (order < 0 && this.context.tileOrder == -1) {
                        int tileOrder = this.context.getTileOrder();
                        --tileOrder;
                        while (tileOrder >= 4 && (order = Util.order((int)nside) - tileOrder) < 0) {
                            --tileOrder;
                        }
                        this.context.setTileOrder(tileOrder);
                    }
                    if (order < 0) {
                        order = 0;
                    }
                }
                this.context.setOrder(order);
                if (isCube) {
                    if (this.context.isHips3D) {
                        CalibFreq cf = file.getCalibFreq();
                        if (cf == null) {
                            throw new Exception("Frequential calibration error");
                        }
                        String warning = cf.getLastWarning();
                        if (warning != null) {
                            this.context.warning(warning);
                        }
                        originalFreqRes = Math.abs(cf.getFreq(0.0) - cf.getFreq(1.0));
                        double originalFreqResMax = Math.abs(cf.getFreq(file.depth - 1) - cf.getFreq(file.depth));
                        originalFreqRes = (originalFreqRes + originalFreqResMax) / 2.0;
                        originalFreqChannel0 = cf.getFreq(0.0);
                        originalFreqChannelMax = cf.getFreq(file.depth);
                        if (orderFreq == -1) {
                            int orderFreq0 = cf.getAdequateOrder(0) - this.context.getTileOrderFreq();
                            int orderFreqMax = cf.getAdequateOrder(file.depth) - this.context.getTileOrderFreq();
                            orderFreq = (orderFreq0 + orderFreqMax) / 2;
                        }
                        this.context.setOrderFreq(orderFreq);
                    } else if (file.getCalibFreq() != null) {
                        this.context.info("*** THIS CUBIC SURVEY SEEMS ELIGIBLE FOR THE HIPS3D METHOD. ***");
                        this.context.info("*** FOR INFORMATION, SEE https://aladin.cds.unistra.fr/java/TutoHiPS3Den.pdf ***");
                        this.context.info("*** TO TAKE ADVANTAGE OF THIS NEW METHOD, RESTART THE GENERATION WITH THE -hips3d OPTION. ***");
                    }
                }
                this.context.setIsCube(isCube);
                this.context.setDepth(file.depth);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.context.warning("Missing calibration (" + e.getMessage() + ") for the reference image [" + img + "] => HiPS order(s) can not be computed");
            }
        }
        if (order == -1) {
            throw new Exception("Argument \"order\" is required");
        }
        if (order < this.context.getOrder()) {
            this.context.warning("The provided order [" + order + "] is less than the optimal order [" + this.context.getOrder() + "] => OVER-sample will be applied");
        } else if (order > this.context.getOrder()) {
            this.context.warning("The provided order [" + order + "] is greater than the optimal order [" + this.context.getOrder() + "] => SUB-sample will be applied");
        } else {
            double hipsPixelRes = CDSHealpix.pixRes(this.context.getOrder() + this.context.getTileOrder()) / 3600.0;
            this.context.info("HiPS order " + this.context.getOrder() + " (pixel ang.res" + (originalPixelRes != -1.0 ? " orig:" + Coord.getUnit(originalPixelRes) : "") + " hips:" + Coord.getUnit(hipsPixelRes) + (originalPixelRes != -1.0 ? " x" + cds.tools.Util.round(originalPixelRes / hipsPixelRes, 2) : "") + ")");
        }
        if (this.context.isHips3D && isCube) {
            if (orderFreq == -1) {
                CalibFreq cf = null;
                cf = new CalibFreq(file.headerFits, this.context.getCUnit(), this.context.getDefaultRestFreq(), false);
                String error = cf.getLastWarning();
                if (error != null) {
                    throw new Exception(error);
                }
                throw new Exception("Argument \"orderFreq\" is required");
            }
            if (orderFreq < this.context.getOrderFreq()) {
                this.context.warning("The provided orderFreq [" + orderFreq + "] is less than the optimal order [" + this.context.getOrderFreq() + "] => frequential OVER-sample will be applied");
            } else if (orderFreq > this.context.getOrderFreq()) {
                this.context.warning("The provided orderFreq [" + order + "] is greater than the optimal order [" + this.context.getOrderFreq() + "] => frequential SUB-sample will be applied");
            } else {
                double hipsFreqRes0 = CalibFreq.getOrderFreqRes(this.context.getOrderFreq() + this.context.getTileOrderFreq(), originalFreqChannel0);
                double hipsFreqResMax = CalibFreq.getOrderFreqRes(this.context.getOrderFreq() + this.context.getTileOrderFreq(), originalFreqChannelMax);
                double hipsFreqRes = (hipsFreqRes0 + hipsFreqResMax) / 2.0;
                this.context.info("HiPS frequential order " + this.context.getOrderFreq() + " (freq res" + (originalFreqRes != -1.0 ? " orig:" + SED.getUnitFreq(originalFreqRes) + "(" + SED.getUnitWave(SED.freq2Wave(originalFreqRes)) : "") + ") -> hips:" + SED.getUnitFreq(hipsFreqRes) + "(" + SED.getUnitWave(SED.freq2Wave(hipsFreqRes)) + ")" + (originalFreqRes != -1.0 ? " x" + cds.tools.Util.round(originalFreqRes / hipsFreqRes, 2) : "") + ")");
            }
        }
        int w = this.context.getTileSide();
        int d = this.context.getTileDepth();
        if (this.context.isCube()) {
            this.context.info("Tile orders " + this.context.getTileOrder() + "_" + this.context.getTileOrderFreq() + " => tile size = " + w + "x" + w + "x" + d + " pixels");
        } else {
            this.context.info("Tile order " + this.context.getTileOrder() + " => tile size: " + w + "x" + w + " pixels");
        }
        this.hdu = this.context.getHDU();
        if (this.hdu == null) {
            if (!this.context.isColor()) {
                this.context.info("MEF strategy => extension 0, otherwise 1");
            }
        } else if (this.hdu.length > 0 && this.hdu[0] == -1) {
            this.context.info("MEF strategy => all images found in the MEF");
        } else {
            StringBuilder s = new StringBuilder("MEF stategy: extensions ");
            for (int i = 0; i < this.hdu.length; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append(this.hdu[i] + "");
            }
            this.context.info(s + "");
        }
        if (this.context.getFitsKeys() != null) {
            StringBuilder res = null;
            for (String key : this.context.getFitsKeys()) {
                if (res == null) {
                    res = new StringBuilder();
                } else {
                    res.append(", ");
                }
                res.append(key);
            }
            this.context.info("Extended metadata extraction based on FITS keys: " + res);
        }
        this.area = this.context.getArea();
        this.context.info("HiPS coordinate frame => " + this.context.getFrameName());
        this.unpackIfRequired();
    }

    public static int calculateNSide(double pixsize) {
        double arcsec2rad = 4.84813681109536E-6;
        double nsd = Math.sqrt(1.0471975511965976) / (arcsec2rad * pixsize);
        int order_req = Math.max(0, Math.min(29, 1 + (int)CDSHealpix.log2((long)nsd)));
        return 1 << order_req;
    }

    @Override
    public void showStatistics() {
        if (this.statNbFile <= 0) {
            return;
        }
        long statDuree = System.currentTimeMillis() - this.statTime;
        this.context.showIndexStat(this.statNbFile, this.statBlocFile, this.statNbZipFile, this.statMemFile, this.statPixSize, this.statMaxSize, this.statMaxWidth, this.statMaxHeight, this.statMaxDepth, this.statMaxNbyte, statDuree);
    }

    @Override
    protected void build() throws Exception {
        this.initStat();
        String input = this.context.getInputPath();
        String output = this.context.getOutputPath();
        int order = this.context.getOrder();
        int orderFreq = this.context.getOrderFreq();
        this.borderSize = this.context.getBorderSize();
        this.maxRatio = this.context.getMaxRatio();
        this.maxOverlays = 0;
        File f = new File(output);
        if (!f.exists()) {
            f.mkdir();
        }
        String pathDest = this.context.getHpxFinderPath();
        this.create(input, pathDest, order, orderFreq);
        this.context.addPixelIn(this.statPixSize);
        this.context.addMaxImgSize(this.statMaxWidth, this.statMaxHeight, this.statMaxDepth, this.statMaxNbyte);
    }

    private void initStat() {
        this.statBlocFile = 0;
        this.statNbZipFile = 0;
        this.statNbFile = 0;
        this.statMemFile = 0L;
        this.statPixSize = 0L;
        this.statMaxSize = -1L;
        this.statTime = System.currentTimeMillis();
    }

    private void updateStat(File f, int code, int width, int height, int depth, int nbyte, int deltaBlocFile) {
        ++this.statNbFile;
        this.statBlocFile += deltaBlocFile;
        if ((code & 1) != 0) {
            ++this.statNbZipFile;
        }
        long size = f.length();
        this.statPixSize += (long)width * (long)height * (long)depth;
        this.statMemFile += size;
        if (this.statMaxSize < size) {
            this.statMaxSize = size;
            this.statMaxWidth = width;
            this.statMaxHeight = height;
            this.statMaxDepth = depth;
            this.statMaxNbyte = nbyte;
        }
    }

    private RandomAccessFile openFile(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) {
            cds.tools.Util.createPath(filename);
        }
        return new RandomAccessFile(f, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAFile(RandomAccessFile out, String filename, Coord center, long cellMem, String stc, String fitsVal) throws IOException {
        try {
            int o2;
            int o1 = filename.lastIndexOf(47);
            int o1b = filename.lastIndexOf(92);
            if (o1b > o1) {
                o1 = o1b;
            }
            if ((o2 = filename.lastIndexOf(46)) == -1 || o2 <= o1) {
                int o3;
                int n = o3 = filename.charAt(filename.length() - 1) == ']' ? filename.lastIndexOf(91) : -1;
                if (o3 > o2) {
                    o2 = o3;
                }
            }
            if (o2 == -1 || o2 <= o1) {
                o2 = filename.length();
            }
            String name = filename.substring(o1 + 1, o2);
            if (fitsVal == null) {
                fitsVal = "";
            }
            String line = "{ \"name\": \"" + name + "\", \"path\": \"" + filename + "\", \"ra\": \"" + center.al + "\", \"dec\": \"" + center.del + "\", \"cellmem\": \"" + cellMem + "\", \"stc\": \"" + stc + "\"" + fitsVal + " }\n";
            int nbEntries = (int)(out.length() / (long)line.length()) + 1;
            if (this.maxOverlays < nbEntries) {
                this.maxOverlays = nbEntries;
            }
            if (this.flagAppend) {
                out.seek(out.length());
            } else if (this.checkIn(out, line)) {
                return;
            }
            out.write(line.getBytes());
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private boolean checkIn(RandomAccessFile out, String line) throws IOException {
        long size = out.length();
        byte[] buf = new byte[(int)size];
        out.readFully(buf);
        int start = 0;
        for (int i = 0; i < buf.length; ++i) {
            if ((char)buf[i] != '\n') continue;
            if (new String(buf, start, i - start + 1).equals(line)) {
                return true;
            }
            start = i + 1;
        }
        return false;
    }

    private boolean create(String pathSource, String pathDest, int order, int orderF) throws Exception {
        File[] list;
        File[] fileArray;
        File main = new File(pathSource);
        ArrayList<File> dir = new ArrayList<File>();
        if (this.context.isInputFile) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = main;
        } else {
            fileArray = list = main.listFiles();
        }
        if (list == null) {
            return true;
        }
        int nbPilot = this.context.nbPilot;
        int i = 0;
        int nbFiles = 0;
        this.context.setProgress(0.0, list.length - 1);
        block7: for (File file : list) {
            int cellSizeDepth;
            int cellSize;
            if (nbPilot >= 0 && nbFiles > nbPilot) {
                this.context.warning("Test Pilot limited to " + nbPilot + " images => partial HiPS");
                return false;
            }
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            this.context.setProgress(i++);
            if (!this.context.isInputFile && file.isDirectory()) {
                dir.add(file);
                continue;
            }
            this.currentfile = file.getPath();
            Fits fitsfile = new Fits();
            fitsfile.setCunit(this.context.getCUnit());
            fitsfile.setDefaultRestFreq(this.context.getDefaultRestFreq());
            boolean flagDefaultHDU = this.hdu == null;
            boolean flagAllHDU = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
            int cellWidth = cellSize = this.context.getPartitioning();
            int cellHeight = cellSize;
            int cellDepth = cellSizeDepth = this.context.getPartitioningDepth();
            int firstDepth = 0;
            for (int j = 0; flagAllHDU || flagDefaultHDU || j < this.hdu.length; ++j) {
                int ext = flagDefaultHDU ? 0 : (flagAllHDU ? j : this.hdu[j]);
                try {
                    int code = fitsfile.loadHeaderFITS(this.currentfile + (ext == 0 ? "" : "[" + ext + "]"));
                    if (flagAllHDU && (code & 0x10) != 0) continue;
                    if (fitsfile.getCalib() == null) {
                        if (!flagDefaultHDU) continue;
                        continue block7;
                    }
                    ++nbFiles;
                    if (firstDepth == 0) {
                        firstDepth = fitsfile.depth;
                    } else if (!this.context.isHips3D && fitsfile.depth != firstDepth) {
                        new Exception("No homogeneous original cube depth");
                    }
                    Aladin.trace(4, "HiPS indexing " + this.currentfile + (ext == 0 ? "" : "[" + ext + "]..."));
                    try {
                        if (!this.partitioning) {
                            String exts = ext > 0 ? "[" + ext + "]" : null;
                            this.testAndInsert(fitsfile, pathDest, this.currentfile, exts, order, orderF);
                            this.updateStat(file, code, fitsfile.width, fitsfile.height, fitsfile.depth, fitsfile.bitpix == 0 ? 4 : Math.abs(fitsfile.bitpix) / 8, 0);
                        } else {
                            if (cellSize == 0) {
                                cellWidth = fitsfile.width;
                                cellHeight = fitsfile.height;
                            }
                            if (cellSizeDepth == 0) {
                                cellDepth = fitsfile.depth;
                            }
                            int width = fitsfile.width - this.borderSize[3];
                            int height = fitsfile.height - this.borderSize[2];
                            int depth = fitsfile.depth;
                            for (int z = 0; z < depth; z += cellDepth) {
                                for (int x = this.borderSize[1]; x < width; x += fitsfile.widthCell) {
                                    for (int y = this.borderSize[0]; y < height; y += fitsfile.heightCell) {
                                        fitsfile.widthCell = x + cellWidth > width ? width - x : cellWidth;
                                        fitsfile.heightCell = y + cellHeight > height ? height - y : cellHeight;
                                        fitsfile.zCell = z;
                                        fitsfile.depthCell = fitsfile.zCell + cellDepth + 1 > depth ? depth - fitsfile.zCell : cellDepth + 1;
                                        fitsfile.xCell = x;
                                        fitsfile.yCell = y;
                                        fitsfile.ext = ext;
                                        String currentCell = fitsfile.getCellSuffix();
                                        this.testAndInsert(fitsfile, pathDest, this.currentfile, currentCell, order, orderF);
                                    }
                                }
                            }
                            this.updateStat(file, code, width, height, depth, fitsfile.bitpix == 0 ? 4 : Math.abs(fitsfile.bitpix) / 8, 1);
                        }
                    }
                    catch (Exception e1) {
                        this.addBadFile(this.currentfile, e1.getMessage());
                        continue block7;
                    }
                }
                catch (MyInputStreamCachedException e) {
                    this.context.taskAbort();
                }
                catch (Exception e) {
                    Aladin.trace(3, e.getMessage() + " " + this.currentfile);
                    continue block7;
                }
                if (flagDefaultHDU) continue block7;
            }
        }
        list = null;
        if (dir.size() > 0) {
            for (File f1 : dir) {
                if (!f1.isDirectory()) continue;
                this.currentfile = f1.getPath();
                try {
                    if (this.create(this.currentfile, pathDest, order, orderF)) continue;
                    return false;
                }
                catch (Exception e) {
                    Aladin.trace(3, e.getMessage() + " " + this.currentfile);
                }
            }
        }
        return true;
    }

    private void testAndInsert(Fits fitsfile, String pathDest, String currentFile, String suffix, int order, int orderF) throws Exception {
        int i;
        int nBytes;
        long cellMem;
        int getCoordErr;
        boolean hasCell;
        StringBuilder stc;
        Coord[] cornerCell;
        Coord[] corner;
        ArrayList<double[]> cooList;
        boolean hasRectPixel;
        Calib c;
        String fitsVal;
        Coord center;
        block36: {
            center = new Coord();
            fitsVal = null;
            c = fitsfile.getCalib();
            int pj = c.getProj();
            hasRectPixel = pj == 7 || pj == 17 || pj == 4 || pj == 11;
            cooList = new ArrayList<double[]>(4);
            Coord coo = new Coord();
            corner = new Coord[4];
            cornerCell = new Coord[4];
            stc = new StringBuilder("POLYGON J2000");
            hasCell = fitsfile.hasCell();
            getCoordErr = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                coo.x = i2 == 0 || i2 == 3 ? fitsfile.xCell : fitsfile.xCell + fitsfile.widthCell;
                coo.y = i2 < 2 ? fitsfile.yCell : fitsfile.yCell + fitsfile.heightCell;
                coo.y = (double)fitsfile.height - coo.y;
                try {
                    c.GetCoord(coo);
                }
                catch (Exception e) {
                    ++getCoordErr;
                    continue;
                }
                cooList.add(this.context.ICRS2galIfRequired(coo.al, coo.del));
                cornerCell[i2] = new Coord(coo.al, coo.del);
                if (hasCell) {
                    coo.x = i2 == 0 || i2 == 3 ? 0 : fitsfile.width;
                    coo.y = i2 < 2 ? 0 : fitsfile.height;
                    coo.y = (double)fitsfile.height - coo.y;
                    c.GetCoord(coo);
                }
                stc.append(" " + coo.al + " " + coo.del);
                corner[i2] = new Coord(coo.al, coo.del);
            }
            if (!hasRectPixel && this.maxRatio > 0.0 && this.statNbFile > 0) {
                double w = Coord.getDist(corner[0], corner[1]) / (double)fitsfile.width;
                double h = Coord.getDist(corner[1], corner[2]) / (double)fitsfile.height;
                if (h > w * this.maxRatio || w > h * this.maxRatio) {
                    throw new Exception("Suspicious image calibration (pixel size=" + Coord.getUnit(w) + "x" + Coord.getUnit(h) + ") => see -maxRatio=xx parameter");
                }
            }
            center.x = (double)fitsfile.width / 2.0;
            center.y = (double)fitsfile.height / 2.0;
            center.y = (double)fitsfile.height - center.y;
            try {
                c.GetCoord(center);
            }
            catch (Exception e1) {
                if (getCoordErr <= 0) break block36;
                throw e1;
            }
        }
        if (this.context.getFitsKeys() != null) {
            StringBuilder res = null;
            for (String key : this.context.getFitsKeys()) {
                String val = fitsfile.headerFits.getStringFromHeader(key);
                if (val == null && (fitsfile.headerFits0 == null || fitsfile.headerFits0 != null && (val = fitsfile.headerFits0.getStringFromHeader(key)) == null)) continue;
                if (res == null) {
                    res = new StringBuilder();
                }
                res.append(", \"" + key + "\": \"" + val.replace("\"", "\\\"") + "\"");
            }
            if (res != null) {
                fitsVal = res.toString();
            }
        }
        if ((cellMem = (long)(fitsfile.widthCell * fitsfile.heightCell * fitsfile.depthCell * (nBytes = fitsfile.bitpix == 0 ? 32 : Math.abs(fitsfile.bitpix) / 8))) <= 0L || cellMem > CDSHealpix.pow2(31L)) {
            throw new Exception("Too big input cells [" + fitsfile.widthCell + "x" + fitsfile.heightCell + "x" + fitsfile.depthCell + " x" + nBytes + "]>2^31. Adjust " + (Object)((Object)Param.partitioning) + " param");
        }
        long[] npixs = null;
        if (getCoordErr == 4 && hasRectPixel && order <= 3) {
            int n = (int)(12L * CDSHealpix.pow2(order) * CDSHealpix.pow2(order));
            npixs = new long[n];
            for (i = 0; i < npixs.length; ++i) {
                npixs[i] = i;
            }
        } else {
            double maxRadius = 0.0;
            for (Coord c2 : corner) {
                double dist = Coord.getDist(center, c2);
                if (!(dist > maxRadius)) continue;
                maxRadius = dist;
            }
            double radius = maxRadius;
            if (radius < 30.0 && !hasRectPixel) {
                try {
                    npixs = CDSHealpix.query_polygon(order, cooList, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (npixs == null) {
                try {
                    if (hasCell || hasRectPixel) {
                        center.x = (double)fitsfile.xCell + (double)fitsfile.widthCell / 2.0;
                        center.y = (double)fitsfile.yCell + (double)fitsfile.heightCell / 2.0;
                        center.y = (double)fitsfile.height - center.y;
                        c.GetCoord(center);
                        maxRadius = 0.0;
                        for (Coord c2 : cornerCell) {
                            double dist = Coord.getDist(center, c2);
                            if (!(dist > maxRadius)) continue;
                            maxRadius = dist;
                        }
                        if (hasRectPixel) {
                            Coord c2 = new Coord();
                            c2.x = fitsfile.xCell;
                            c2.y = center.y;
                            c.GetCoord(c2);
                            double dist = Coord.getDist(center, c2);
                            if (dist > maxRadius) {
                                maxRadius = dist;
                            }
                        }
                        radius = maxRadius;
                    }
                    double[] cent = this.context.ICRS2galIfRequired(center.al, center.del);
                    npixs = CDSHealpix.query_disc(order, cent[0], cent[1], Math.toRadians(radius), true);
                }
                catch (Exception e) {
                    throw new Exception("BuilderIndex error in CDSHealpix.query_disc() order=" + order + " center=" + center + " radius=" + radius + "deg file=" + fitsfile.getFilename() + " => ignored");
                }
            }
        }
        long[] fpixRange = null;
        if (orderF >= 0) {
            CalibFreq cf = fitsfile.getCalibFreq();
            if (cf == null) {
                throw new Exception("Cube frequential calibration unknown");
            }
            if (cf.getLastWarning() != null && !this.memoWarning.contains(currentFile.hashCode())) {
                BuilderIndex builderIndex = this;
                if (builderIndex.context.getVerbose() >= 3) {
                    this.context.warning(cf.getLastWarning() + " for " + currentFile);
                }
                this.memoWarning.add(currentFile.hashCode());
            }
            double freqMin = cf.getFreq(fitsfile.zCell);
            double freqMax = cf.getFreq(fitsfile.zCell + fitsfile.depthCell);
            fpixRange = CalibFreq.queryRange(orderF, freqMin, freqMax);
        }
        for (i = 0; i < npixs.length; ++i) {
            RandomAccessFile out;
            String hpxname;
            long npix = npixs[i];
            if (!this.isInImage(fitsfile, Util.getCorners(order, npix), hasRectPixel)) continue;
            String filename = currentFile + (suffix == null ? "" : suffix);
            if (orderF <= 0) {
                if (this.area != null) {
                    SMoc m = new SMoc();
                    m.add(order, npix);
                    if (!this.area.isIntersecting(m)) continue;
                }
                hpxname = cds.tools.Util.concatDir(pathDest, Util.getFilePath("", order, npix));
                out = this.openFile(hpxname);
                this.createAFile(out, filename, center, cellMem, stc.toString(), fitsVal);
                out.close();
                continue;
            }
            for (long npixF = fpixRange[0]; npixF <= fpixRange[1]; ++npixF) {
                if (this.area != null) {
                    SFMoc m = new SFMoc();
                    m.add(orderF, npixF, order, npix);
                    if (!this.area.isIntersecting(m)) continue;
                }
                Addr addr = new Addr(order, npix, orderF, npixF);
                hpxname = cds.tools.Util.concatDir(pathDest, Util.getFilePath("", addr));
                out = this.openFile(hpxname);
                this.createAFile(out, filename, center, cellMem, stc.toString(), fitsVal);
                out.close();
            }
        }
    }

    private boolean isInImage(Fits f, Coord[] corners, boolean isCAR) {
        int signeX = 0;
        int signeY = 0;
        try {
            int marge = 2;
            for (int i = 0; i < corners.length; ++i) {
                Coord coo = corners[i];
                if (isCAR && coo.al == 180.0) {
                    return true;
                }
                if (this.context.getFrame() != 0) {
                    double[] radec = this.context.gal2ICRSIfRequired(coo.al, coo.del);
                    coo.al = radec[0];
                    coo.del = radec[1];
                }
                f.getCalib().GetXY(coo);
                if (Double.isNaN(coo.x)) continue;
                coo.y = (double)f.height - coo.y;
                int width = f.widthCell + marge;
                int height = f.heightCell + marge;
                if (coo.x >= (double)(f.xCell - marge / 2) && coo.x <= (double)(f.xCell + width) && coo.y >= (double)(f.yCell - marge / 2) && coo.y <= (double)(f.yCell + height)) {
                    return true;
                }
                signeX += coo.x > (double)(f.xCell + width) ? 1 : (coo.x < (double)(f.xCell - marge / 2) ? -1 : 0);
                signeY += coo.y > (double)(f.yCell + height) ? 1 : (coo.y < (double)(f.yCell - marge / 2) ? -1 : 0);
            }
        }
        catch (Exception e) {
            return false;
        }
        return Math.abs(signeX) != 4 && Math.abs(signeY) != 4;
    }
}

