/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.HpxFinderTile;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.BuilderAllsky;
import cds.hipsgen.BuilderUnpackIndex;
import cds.hipsgen.Context;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class BuilderDetails
extends Builder {
    public static final int MINORDER = 3;
    private int detailOrder;
    private int maxOrder;
    private int maxOrderF;
    private boolean isHips3D;
    private long[] nbItemPerOrder;
    private int statNbFile;
    private long startTime;
    private long totalTime;
    private static final String METADATA1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- VOTable HiPS hpxfinder mapping file.\n     Use to map and build from a HpxFinder JSON tile a classical VOTable HiPS tile.\n     Adapt it according to your own (see examples below in the comments)\n-->\n\n<VOTABLE version=\"1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xmlns=\"http://www.ivoa.net/xml/VOTable/v1.2\"\n  xsi:schemaLocation=\"http://www.ivoa.net/xml/VOTable/v1.2 http://www.ivoa.net/xml/VOTable/v1.2\">\n \n<RESOURCE>\n  <COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n  <TABLE name=\"YOUR_SURVEY_LABEL\">\n    <FIELD name=\"RAJ2000\" ucd=\"pos.eq.ra\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Right ascension</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"DEJ2000\" ucd=\"pos.eq.dec\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Declination</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"id\" ucd=\"meta.id;meta.dataset\" datatype=\"char\" arraysize=\"13*\">\n      <DESCRIPTION>Dataset name, uniquely identifies the data for a given exposure.</DESCRIPTION>\n       <!-- Simple HTTP link description (Aladin will open it in a Web navigator)\n         <LINK href=\"http://your.server.edu/info?param=${id}&amp;otherparam=foo\"/>\n       -->\n     </FIELD>\n    <FIELD name=\"access\" datatype=\"char\" arraysize=\"9*\">\n      <DESCRIPTION>Display original image</DESCRIPTION>\n       <LINK content-type=\"image/fits\" href=\"${access}\"/>\n       <!--  Image HTTP link description (Aladin will load it)\n          <LINK content-type=\"image/fits\" href=\"http://your.server.edu/getdata?param=${id}&amp;otherparam=foo\" title=\"remote img\"/>\n        -->\n    </FIELD>\n    <FIELD name=\"FoV\" datatype=\"char\" utype=\"stc:ObservationLocation.AstroCoordArea.Region\" arraysize=\"12*\">\n       <DESCRIPTION>Field of View (STC description)</DESCRIPTION>\n    </FIELD>\n    <!-- Additional Field for extracting Instrument name from original filepath\n         see also associated TD example below\n       <FIELD name=\"Instrument\" datatype=\"char\" arraysize=\"12*\">\n          <DESCRIPTION>Instrument</DESCRIPTION>\n       </FIELD \n     -->\n";
    private static final String METADATA2 = "<DATA>\n   <TABLEDATA> \n      <TR>\n      <TD>$[ra]</TD>\n      <TD>$[dec]</TD>\n      <TD>$[name]</TD>\n      <TD>$[path:([^\\[]*).*]</TD>\n      <TD>$[stc]</TD>\n";
    private static final String METADATA3 = "      <!-- Extended example via prefix and regular expression mapping\n           (here, the instrument name is coded in the original path after \"data\" directory)\n           <TD>Instrument: $[path:.*/data/(.+)/.*]</TD> \n        -->\n      </TR>\n   </TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n\n";

    public BuilderDetails(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.DETAILS;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void supportPack() throws Exception {
    }

    @Override
    public void supportHiPS3D() throws Exception {
    }

    private void unpackIfRequired() throws Exception {
        if (!this.context.isPacked(this.context.getHpxFinderPath())) {
            return;
        }
        this.context.info("HiPS index packed found");
        new BuilderUnpackIndex(this.context).run();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateIndex();
        this.maxOrder = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
        if (this.maxOrder == -1) {
            throw new Exception("HpxFinder seems to be not yet ready ! (order=-1)");
        }
        this.context.info("Order retrieved from HpxFinder => " + this.maxOrder);
        this.isHips3D = this.context.isHiPS3D(this.context.getHpxFinderPath());
        if (this.isHips3D) {
            this.maxOrderF = Util.getMaxOrderFreqByPath(this.context.getHpxFinderPath());
            if (this.maxOrderF == -1) {
                throw new Exception("Erroneous HiPS3D HpxFinder!");
            }
        }
        if (this.context.getOrder() < this.maxOrder) {
            this.context.setMinOrder(this.context.getOrder());
        }
        this.context.setOrder(this.maxOrder);
        this.detailOrder = this.context.getMinOrder();
        if (this.detailOrder != -1) {
            this.context.info("Detail table min order determined by \"minOrder\" parameter => " + this.detailOrder);
        } else {
            this.validateImg();
            if (this.context.typicalImgWidth == -1) {
                this.detailOrder = this.maxOrder - 5;
                this.context.warning("Detail table min order determined in function of max order => " + this.detailOrder);
            } else {
                this.detailOrder = this.maxOrder - this.context.typicalImgWidth / this.context.getTileSide() - 2;
                this.context.info("Detail table min order determined by original image resolution => " + this.detailOrder);
            }
        }
        if (this.detailOrder < 3) {
            this.detailOrder = 3;
        }
        if (this.detailOrder > this.maxOrder) {
            this.context.warning("The target Order (" + this.detailOrder + ") is greater than the index order (" + this.maxOrder + ") => assuming " + this.maxOrder + "...");
            this.detailOrder = this.maxOrder;
        }
        this.context.mocIndex = null;
        this.context.initRegion();
        this.unpackIfRequired();
    }

    private void validateImg() throws Exception {
        String img = this.context.getImgEtalon();
        if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
            this.context.info("Reference image => " + img);
        }
        if (img != null) {
            try {
                this.context.setImgEtalon(img);
            }
            catch (Exception e) {
                this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
            }
        }
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 0, 0);
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        this.context.setProgressMax(768.0);
        String output = this.context.getHpxFinderPath();
        HpxFinderTile allsky = null;
        this.nbItemPerOrder = new long[this.maxOrder + 1];
        for (int i = 0; i < 768; ++i) {
            HpxFinderTile hi = this.createTree(output, 3, i);
            if (hi != null) {
                if (allsky == null) {
                    allsky = new HpxFinderTile();
                }
                if (!allsky.hasTooMany()) {
                    allsky.merge(hi);
                    if (allsky.size() > HpxFinderTile.TOOMANY) {
                        allsky.setTooMany(true);
                    }
                }
            }
            this.context.setProgress(i);
        }
        if (this.detailOrder > 3) {
            long size = 768L;
            int o = 3;
            while (o < this.detailOrder && this.nbItemPerOrder[o] > (long)HpxFinderTile.TOOMANY * size) {
                String file = cds.tools.Util.concatDir(output, "Norder" + o);
                this.context.info("Removing HpxFinder detail order " + o + " (too many entries [" + this.nbItemPerOrder[o] + "])...");
                cds.tools.Util.deleteDir(new File(file));
                if (o == 3) {
                    allsky = null;
                }
                ++o;
                size *= 4L;
            }
            this.detailOrder = o;
        }
        if (allsky != null && !allsky.hasTooMany()) {
            String file = BuilderAllsky.getFileName(this.context.getHpxFinderPath(), 3, 0);
            this.writeIndexFile(file, allsky);
        }
        this.generateMedataFile();
    }

    private void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        this.updateStat(1);
    }

    private void updateStat(int n) {
        this.statNbFile += n;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    private HpxFinderTile createTree(String path, int order, long npix) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (!this.context.isInMocTree(order - 1, npix / 4L)) {
            return null;
        }
        String file = Util.getFilePath(path, order, npix);
        HpxFinderTile out = null;
        if (order == this.maxOrder) {
            out = this.isHips3D ? this.createLeave4Hips3D(path, npix) : this.createLeave(file);
        } else {
            HpxFinderTile[] fils = new HpxFinderTile[4];
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                fils[i] = this.createTree(path, order + 1, npix * 4L + (long)i);
                if (fils[i] == null || found) continue;
                found = true;
            }
            if (found) {
                out = this.createNode(fils);
            }
        }
        if (order < this.detailOrder && out != null && out.size() > HpxFinderTile.TOOMANY) {
            out.setTooMany(true);
        }
        if (out != null && this.context.isInMocTree(order, npix)) {
            int n = order;
            this.nbItemPerOrder[n] = this.nbItemPerOrder[n] + (long)out.size();
            if (!out.hasTooMany()) {
                this.writeIndexFile(file, out);
            }
        }
        if (out != null && out.hasTooMany()) {
            out = null;
        }
        return out;
    }

    private void writeIndexFile(String file, HpxFinderTile map) throws Exception {
        cds.tools.Util.createPath(file);
        map.writeStream(new FileOutputStream(file));
    }

    private HpxFinderTile createLeave4Hips3D(String path, long npix) throws Exception {
        HpxFinderTile out = null;
        String glob1 = "Npix" + npix + "_*";
        Addr addr = new Addr(this.maxOrder, npix, this.maxOrderF, 0L);
        String file = Util.getFilePath(path, addr);
        int offset0 = file.lastIndexOf(FS);
        int offset = file.lastIndexOf(FS, offset0 - 1);
        Path dir = new File(file.substring(0, offset)).toPath();
        String glob = file.substring(offset + 1, offset0 - 1) + "*";
        DirectoryStream<Path> stream = Files.newDirectoryStream(dir, glob);
        int n = 0;
        for (Path d : stream) {
            DirectoryStream<Path> stream1 = Files.newDirectoryStream(d, glob1);
            for (Path entry : stream1) {
                File f = entry.toFile();
                HpxFinderTile in = new HpxFinderTile();
                in.loadStream(new FileInputStream(f));
                if (out == null) {
                    out = in;
                } else {
                    out.merge(in);
                }
                ++n;
            }
        }
        if (out != null) {
            file = Util.getFilePath(path, this.maxOrder, npix);
            this.writeIndexFile(file, out);
        }
        this.updateStat(n);
        return out;
    }

    private HpxFinderTile createLeave(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HpxFinderTile out = new HpxFinderTile();
        out.loadStream(new FileInputStream(f));
        this.updateStat();
        return out;
    }

    private HpxFinderTile createNode(HpxFinderTile[] fils) throws Exception {
        HpxFinderTile out = new HpxFinderTile();
        for (int i = 0; i < 4; ++i) {
            if (fils[i] == null) continue;
            if (fils[i].hasTooMany()) {
                out.setTooMany(true);
                break;
            }
            out.merge(fils[i]);
            fils[i] = null;
        }
        return out;
    }

    private void generateMedataFile() throws Exception {
        String metadata = cds.tools.Util.concatDir(this.context.getHpxFinderPath(), "metadata.xml");
        if (new File(metadata).exists()) {
            this.context.info("Pre-existing metadata.xml file => keep it");
        } else {
            RandomAccessFile f = new RandomAccessFile(metadata, "rw");
            String s = METADATA1.replace("YOUR_SURVEY_LABEL", this.context.getTitle() + " details");
            f.write(s.getBytes());
            f.write(this.getAdditionalMetaFileFields().getBytes());
            f.write(METADATA2.getBytes());
            f.write(this.getAdditionalMetaFileData().getBytes());
            f.write(METADATA3.getBytes());
            f.close();
            this.context.info("Mapping hpxFinder/metadata.xml file has been generated");
        }
        this.context.writeHpxFinderProperties();
        this.context.writeIndexHtml();
    }

    private String getAdditionalMetaFileFields() {
        if (this.context.getFitsKeys() == null) {
            return "";
        }
        Fits fits = null;
        String path = null;
        try {
            path = this.context.getImgEtalon();
            fits = new Fits();
            fits.loadHeaderFITS(path);
        }
        catch (Exception e) {
            this.context.warning("Reference image not available [" + path + "] => no metafile.xml FIELD description");
            fits = null;
        }
        StringBuilder s = new StringBuilder();
        for (String k : this.context.getFitsKeys()) {
            boolean flagNumeric = false;
            try {
                fits.headerFits.getDoubleFromHeader(k);
                flagNumeric = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            String type = flagNumeric ? "datatype=\"double\"" : "datatype=\"char\" arraysize=\"*\"";
            String desc = fits == null ? null : fits.headerFits.getDescriptionFromHeader(k);
            desc = desc == null ? "/>\n" : ">\n      <DESCRIPTION>" + desc + "</DESCRIPTION>\n   </FIELD>\n";
            s.append("   <FIELD name=\"" + k + "\" " + type + desc);
        }
        return s.toString();
    }

    private String getAdditionalMetaFileData() {
        if (this.context.getFitsKeys() == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (String k : this.context.getFitsKeys()) {
            s.append("      <TD>$[" + k + "]</TD>\n");
        }
        return s.toString();
    }
}

