/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.moc.FMoc;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.Util;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BuilderCut
extends Builder {
    private Moc moc;
    static int NB = 0;
    protected long startTime;
    private int statNbRegions;
    private int statNbFiles;
    private int statRegions;
    private int statFiles;

    public BuilderCut(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CUT;
    }

    @Override
    public void supportHiPS3D() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void build() throws Exception {
        int nbThread;
        this.context.loadMoc();
        final String path = this.context.getOutputPath();
        this.moc = Moc.createMoc(new FileInputStream(path + cds.tools.Util.FS + "Moc.fits"));
        SMoc smoc = this.moc.getSpaceMoc();
        final int order = Util.getMaxOrderByPath(path);
        final int orderF = Util.getMaxOrderFreqByPath(path);
        if (this.context.getOrder() == -1) {
            this.context.setOrder(order);
        }
        smoc.setMocOrder(order);
        SMoc[] mocs = smoc.split(new Healpix(), true);
        this.context.info(mocs.length + " independent regions found");
        this.initStat((int)smoc.getNbValues(), mocs.length);
        double pourcentMin = 0.003;
        double pourcentMax = 0.9995;
        if (Context.hasPourcentCut(this.context.pixelRangeCut)) {
            pourcentMin = this.context.pixelRangeCut[5];
            pourcentMax = this.context.pixelRangeCut[6];
        }
        String u = cds.tools.Util.getUnitDisk(this.getByRegionWidth() * this.getByRegionWidth());
        u = u.substring(0, u.length() - 1) + "pix";
        this.context.info("Adjusting cuts from " + cds.tools.Util.getPourcent(pourcentMin) + " to " + cds.tools.Util.getPourcent(pourcentMax) + " of the pixel distribution for each region (based on " + u + " sampling)");
        this.context.info("Updating FITS tile headers (deepest order only) with CUTMIN and CUTMAX values by region...");
        int nbProc = Runtime.getRuntime().availableProcessors();
        if (nbProc > 10) {
            nbProc = 10;
        }
        if ((nbThread = this.context.getMaxNbThread()) <= 0 || nbThread > nbProc) {
            nbThread = nbProc;
        }
        this.context.info("Working with " + nbThread + " thread" + (nbThread > 1 ? "s" : ""));
        ExecutorService executorService = Executors.newFixedThreadPool(nbThread);
        for (final SMoc m : mocs) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            BuilderCut.this.setCut(path, order, orderF, m);
                            BuilderCut.this.statRegion();
                        }
                        catch (Exception e) {
                            BuilderCut builderCut = BuilderCut.this;
                            if (builderCut.context.getVerbose() < 3) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            if (this.context.isTaskAborting()) {
                executorService.shutdownNow();
                throw new Exception("Task aborted!");
            }
            cds.tools.Util.pause(1000);
        }
    }

    private void setCut(String path, int order, int orderZ, SMoc m) throws Exception {
        double[] cut = this.evaluateCut(path, order, orderZ, m);
        if (cut == null) {
            return;
        }
        String cutmin = cut[0] + "";
        String cutmax = cut[1] + "";
        Iterator<Long> it = m.valIterator();
        while (it.hasNext()) {
            if (this.context.isTaskAborting()) {
                return;
            }
            long npix = it.next();
            ArrayList<Long> listPixZ = new ArrayList<Long>();
            if (orderZ != -1) {
                FMoc fmoc = this.moc.intersection(new SMoc(order + "/" + npix)).getFreqMoc();
                Iterator<Long> itf = fmoc.valIterator();
                while (itf.hasNext()) {
                    listPixZ.add(itf.next());
                }
            } else {
                listPixZ.add(-1L);
            }
            Iterator iterator = listPixZ.iterator();
            while (iterator.hasNext()) {
                int code;
                long npixZ = (Long)iterator.next();
                Addr addr = npixZ == -1L ? new Addr(order, npix, -1) : new Addr(order, npix, orderZ, npixZ);
                String file = Util.getFilePath(path, addr) + ".fits";
                Fits fits = new Fits();
                try {
                    code = fits.loadHeaderFITS(file);
                }
                catch (Exception e) {
                    continue;
                }
                if (code != 0) {
                    throw new Exception("FITS tile header update error (not a regular FITS tile))");
                }
                if (!this.context.force && fits.headerFits.hasKey("CUTMIN") && fits.headerFits.hasKey("CUTMAX")) continue;
                byte[] buf1 = fits.headerFits.makeHeaderBuf();
                fits.headerFits.setKeyword("CUTMIN", cutmin);
                fits.headerFits.setKeyword("CUTMAX", cutmax);
                byte[] buf2 = fits.headerFits.makeHeaderBuf();
                if (buf2.length != buf1.length) {
                    throw new Exception("FITS tile header update error (no enough space in header)");
                }
                RandomAccessFile f = new RandomAccessFile(file, "rw");
                f.write(buf2);
                f.close();
            }
            this.statFile();
        }
    }

    private int getByRegionWidth() {
        int w = (int)Math.sqrt(this.context.byRegionSize);
        if (w < 64) {
            w = 1024;
        }
        return w;
    }

    private double[] evaluateCut(String path, int order, int orderZ, SMoc m) throws Exception {
        int i = 0;
        Iterator<Long> it = m.valIterator();
        Fits test = null;
        int offset = 0;
        int testW = this.getByRegionWidth();
        block2: while (it.hasNext()) {
            if (this.context.isTaskAborting()) {
                return null;
            }
            long npix = it.next();
            ArrayList<Long> listPixZ = new ArrayList<Long>();
            if (orderZ != -1) {
                FMoc fmoc = this.moc.intersection(new SMoc(order + "/" + npix)).getFreqMoc();
                Iterator<Long> itf = fmoc.valIterator();
                while (itf.hasNext()) {
                    listPixZ.add(itf.next());
                }
                int n = listPixZ.size();
                if (n > 1) {
                    ArrayList<Long> listPixZ1 = new ArrayList<Long>();
                    listPixZ1.add((Long)listPixZ.get(n / 2));
                    listPixZ = listPixZ1;
                }
            } else {
                listPixZ.add(-1L);
            }
            Iterator iterator = listPixZ.iterator();
            while (iterator.hasNext()) {
                long npixZ = (Long)iterator.next();
                Addr addr = npixZ == -1L ? new Addr(order, npix, -1) : new Addr(order, npix, orderZ, npixZ);
                String file = Util.getFilePath(path, addr) + ".fits";
                try {
                    Fits fits = new Fits(file, true);
                    if (test == null) {
                        test = new Fits(testW, testW, fits.bitpix);
                        test.setBlank(fits.blank);
                        test.setBscale(fits.bscale);
                        test.setBzero(fits.bzero);
                    }
                    int size = fits.width * fits.height * fits.depth;
                    for (int j = 0; j < size && offset < testW * testW; ++j) {
                        double c = Fits.getPixValDouble(fits.pixels, fits.bitpix, j);
                        if (fits.isBlankPixel(c)) continue;
                        Fits.setPixValDouble(test.pixels, test.bitpix, offset++, c);
                    }
                    if (offset != testW * testW) continue;
                    break block2;
                }
                catch (Exception e) {
                    --i;
                }
            }
        }
        double cutMinPourcent = -1.0;
        double cutMaxPourcent = -1.0;
        if (Context.hasPourcentCut(this.context.pixelRangeCut)) {
            cutMinPourcent = this.context.pixelRangeCut[5];
            cutMaxPourcent = this.context.pixelRangeCut[6];
        }
        double[] cut = test.findAutocutRange(0.0, 0.0, cutMinPourcent, cutMaxPourcent, true);
        return cut;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }

    @Override
    public boolean isAlreadyDone() {
        return false;
    }

    private void initStat(int nbFiles, int nbRegions) {
        this.statNbRegions = nbRegions;
        this.statNbFiles = nbFiles;
        this.statRegions = 0;
        this.statFiles = 0;
        this.startTime = System.currentTimeMillis();
    }

    private synchronized void statRegion() {
        ++this.statRegions;
    }

    private synchronized void statFile() {
        ++this.statFiles;
    }

    @Override
    public void showStatistics() {
        if (this.statNbFiles <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long cTime = now - this.startTime;
        if (cTime < 2000L) {
            return;
        }
        this.context.showCutStat(this.statRegions, this.statNbRegions, this.statFiles, this.statNbFiles, cTime);
    }
}

