/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Aladin;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderAllsky;
import cds.hipsgen.BuilderMoc;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.BuilderTiles;
import cds.hipsgen.Context;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ThreadBuilderCount;
import cds.hipsgen.ThreadBuilderTile;
import cds.tools.Util;

public class BuilderCount
extends BuilderTiles {
    protected Context mc = null;

    public BuilderCount(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.COUNT;
    }

    @Override
    protected void message() {
        this.context.info("COMPUTING A COUNT HiPS...");
    }

    @Override
    public void run() throws Exception {
        long t0 = System.currentTimeMillis();
        String ext = this.getTileExt().replace('.', ' ');
        this.context.info("Creating " + this.context.getNbLowCells() + ext + " COUNTING tiles (order=" + this.context.getOrder() + ")...");
        this.build();
        this.execTime = System.currentTimeMillis() - t0;
    }

    @Override
    protected void buildPost(long duree) throws Exception {
        this.context.setPropriete("hips_pixel_bitpix", this.context.bitpix + "");
        this.context.setPropriete("hips_sampling", "none");
        this.context.setPropriete("hips_overlay", "counting");
        if (!Double.isNaN(this.context.dataMin) && !Double.isNaN(this.context.dataMax)) {
            this.context.info("HiPS effective values: " + Util.myRound(this.context.dataMin) + " .. " + Util.myRound(this.context.dataMax));
            double[] cut = new double[7];
            cut[2] = 0.0;
            cut[0] = 0.0;
            cut[1] = cut[3] = this.context.dataMax;
            this.context.setCut(cut);
        }
        if (!this.context.isTaskAborting()) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
        }
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).createAllSky(this.context.getOutputPath(), 3, 64, 0);
        }
        if (!this.context.isTaskAborting()) {
            this.context.writeMetaFile();
        }
        if (ThreadBuilderTile.statMaxOverlays > 0) {
            this.context.stat("Tile overlay stats : max overlays=" + ThreadBuilderTile.statMaxOverlays + ", " + ThreadBuilderTile.statOnePass + " in one step, " + ThreadBuilderTile.statMultiPass + " in multi steps");
        }
        if (this.context.cacheFits != null) {
            Aladin.trace(4, "Cache FITS status: " + this.context.cacheFits);
            this.context.cacheFits.reset();
            this.context.setCache(null);
        }
        this.restoreContext();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateInput();
        this.validateOrder(this.context.getHpxFinderPath());
        this.swichContext();
        this.validateOutput();
        this.context.info("Output directory: " + this.context.getOutputPath());
        this.context.initRegion();
    }

    @Override
    protected String getHpxFinderPath() {
        return this.mc.getHpxFinderPath();
    }

    @Override
    protected ModeOverlay getModeOverlay() {
        return this.context.getModeOverlay();
    }

    @Override
    protected int getBitpix() {
        return this.context.getBitpix();
    }

    @Override
    protected boolean getFading() {
        return false;
    }

    private void swichContext() {
        this.mc = new Context();
        this.mc.hipsId = this.context.hipsId;
        this.context.hipsId = this.context.hipsId + "/count";
        this.mc.outputPath = this.context.outputPath;
        this.context.outputPath = this.context.getHpxCounterPath();
        this.mc.bitpix = this.context.bitpix;
        this.context.bitpix = -32;
        this.mc.bitpixOrig = this.context.bitpixOrig;
        this.context.bitpixOrig = -1;
        this.mc.modeOverlay = this.context.modeOverlay;
        this.context.modeOverlay = ModeOverlay.overlayAdd;
        this.mc.validateOutputDone = this.context.validateOutputDone;
    }

    private void restoreContext() {
        this.context.hipsId = this.mc.hipsId;
        this.context.outputPath = this.mc.outputPath;
        this.context.bitpix = this.mc.bitpix;
        this.context.modeOverlay = this.mc.modeOverlay;
        this.context.validateOutputDone = this.mc.validateOutputDone;
        this.context.cut = this.mc.cut;
        this.context.bitpixOrig = this.mc.bitpixOrig;
    }

    @Override
    protected ThreadBuilderTile createThreadBuilderTile(Context context, BuilderRunner builder) {
        return new ThreadBuilderCount(context, builder);
    }
}

