/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.HpxFinderTile;
import cds.aladin.MyProperties;
import cds.aladin.PlanHips;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderDetails;
import cds.hipsgen.BuilderJpg;
import cds.hipsgen.BuilderMoc;
import cds.hipsgen.BuilderMocIndex;
import cds.hipsgen.BuilderPng;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.BuilderTree;
import cds.hipsgen.Context;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.ModeTree;
import cds.hipsgen.ThreadBuilderTile;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BuilderConcat
extends BuilderRunner {
    private SMoc inputMoc;
    private SMoc outputMoc;
    private String outputPath;
    private String inputPath;
    private String outputPathIndex;
    private String inputPathIndex;
    private ModeMerge mode;
    private boolean doHpxFinder;
    private int tileMode;
    private int tileSide;
    private int tileDepth;
    private boolean live = false;
    private boolean liveIn;
    private boolean liveOut;

    public BuilderConcat(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CONCAT;
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.context.resetCheckCode();
        new BuilderTree(this.context).run();
        this.context.info("Hips tree updated");
        boolean inJpg = false;
        boolean inPng = false;
        if (!this.context.isColor()) {
            boolean bl = inJpg = Context.findOneNpixFile(this.context.getOutputPath(), "jpg") != null;
            if (inJpg) {
                new BuilderJpg(this.context).run();
                this.context.info("JPEG tiles updated");
            }
            boolean bl2 = inPng = Context.findOneNpixFile(this.context.getOutputPath(), "png") != null;
            if (inPng) {
                this.context.info("Updating PNG tiles...");
                this.context.setModeMerge(ModeMerge.mergeOverwriteTile);
                new BuilderPng(this.context).run();
            }
        }
        String outputPath = this.context.getOutputPath();
        if (this.mode != ModeMerge.mergeMul && this.mode != ModeMerge.mergeDiv && this.mode != ModeMerge.mergeSub) {
            this.outputMoc = new SMoc();
            File f = new File(outputPath + Util.FS + "Moc.fits");
            if (f.exists()) {
                this.outputMoc.read(f.getCanonicalPath());
                this.outputMoc = this.outputMoc.union(this.inputMoc);
                this.outputMoc.write(this.context.getOutputPath() + Util.FS + "Moc.fits");
                this.context.info("MOC updated");
            } else {
                new BuilderMoc(this.context).run();
                this.context.info("MOC done");
            }
            if (!this.doHpxFinder) {
                f = new File(this.outputPathIndex);
                if (f.isDirectory()) {
                    f.renameTo(new File(this.outputPathIndex + "-partial"));
                    this.context.warning("Previous HpxFinder has been removed as HpxFinder-partial");
                }
            } else {
                new BuilderMocIndex(this.context).run();
                this.context.info("Index MOC updated");
                f = new File(this.outputPathIndex + Util.FS + "metadata.xml");
                if (f.exists()) {
                    BuilderDetails b = new BuilderDetails(this.context);
                    b.validateContext();
                    b.run();
                    this.context.info("PROGEN tiles updated");
                }
            }
        }
    }

    @Override
    protected void buildPost(long duree) throws Exception {
        if (!Double.isNaN(this.context.dataMin) && !Double.isNaN(this.context.dataMax)) {
            this.context.info("HiPS effective values: " + cds.tools.Util.myRound(this.context.dataMin) + " .. " + cds.tools.Util.myRound(this.context.dataMax));
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.outputPath = this.context.getOutputPath();
        this.inputPath = this.context.getInputPath();
        this.outputPathIndex = cds.tools.Util.concatDir(this.outputPath, "HpxFinder");
        this.inputPathIndex = cds.tools.Util.concatDir(this.inputPath, "HpxFinder");
        this.mode = this.context.getModeMerge();
        this.tileMode = 2;
        this.tileSide = this.context.getTileSide();
        this.tileDepth = this.context.getTileDepth();
        if (this.inputPath == null) {
            throw new Exception("\"in\" parameter required !");
        }
        File f = new File(this.inputPath);
        if (!(!f.exists() || f.isDirectory() && f.canRead())) {
            throw new Exception("\"inputPath\" directory not available [" + this.inputPath + "]");
        }
        this.addAddendum(this.context.getInputPath(), this.context.getOutputPath());
        int order = Util.getMaxOrderByPath(this.outputPath);
        if (order == -1) {
            throw new Exception("No HiPS found in ouput dir");
        }
        this.context.setOrder(order);
        int inputOrder = Util.getMaxOrderByPath(this.inputPath);
        if (inputOrder == -1) {
            throw new Exception("No HiPS found in input dir");
        }
        if (order != inputOrder) {
            throw new Exception("Uncompatible HiPS: out.order=" + order + " input.order=" + inputOrder);
        }
        this.context.info("Order retrieved from [" + this.inputPath + "] => " + order);
        String allsky = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits";
        if (new File(allsky).exists()) {
            this.setContextParamFromPreviousAllskyFile(allsky);
            String inputAllsky = this.inputPath + Util.FS + "Norder3" + Util.FS + "Allsky.fits";
            if (new File(inputAllsky).exists()) {
                this.validateParams(inputAllsky);
            }
        } else {
            allsky = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.png";
            if (new File(allsky).exists()) {
                this.context.setColor("png");
                this.tileMode = 0;
                this.context.info("Processing HiPS colored in " + this.context.getTileExt() + " tiles");
            } else {
                allsky = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.jpg";
                if (new File(allsky).exists()) {
                    this.context.setColor("jpg");
                    this.tileMode = 1;
                    this.context.info("Processing HiPS colored in " + this.context.getTileExt() + " tiles");
                }
            }
        }
        this.inputMoc = new SMoc();
        f = new File(this.inputPath + Util.FS + "Moc.fits");
        if (f.exists()) {
            this.inputMoc.read(f.getCanonicalPath());
        } else {
            this.context.info("No input MOC found => generate it...");
            this.context.setOutputPath(this.inputPath);
            new BuilderMoc(this.context).run();
            this.context.setOutputPath(this.outputPath);
            f = new File(this.inputPath + Util.FS + "Moc.fits");
            this.inputMoc.read(f.getCanonicalPath());
        }
        if (this.context.mocArea != null) {
            this.inputMoc = this.inputMoc.intersection(this.context.mocArea);
        }
        this.context.moc = this.inputMoc;
        double[] cut = this.context.getCut();
        cut = this.updateCutByProperties(cut);
        this.context.setCut(cut);
        this.context.setValidateCut(true);
        this.liveOut = this.checkLiveByProperties(this.context.getOutputPath());
        this.liveIn = this.checkLiveByProperties(this.context.getInputPath());
        this.live = this.liveIn && this.liveOut;
        boolean bl = this.doHpxFinder = new File(this.inputPathIndex).isDirectory() && new File(this.outputPathIndex).isDirectory();
        if (this.mode == ModeMerge.mergeMul || this.mode == ModeMerge.mergeDiv || this.mode == ModeMerge.mergeSub) {
            this.doHpxFinder = false;
            if (this.liveIn) {
                this.context.warning("Source HiPS does provide weight tiles => ignored");
            }
        }
        if (this.doHpxFinder) {
            this.context.info("HpxFinder will be also concatenated");
        }
        if (this.mode == ModeMerge.mergeMean) {
            if (!this.live) {
                this.context.warning("Both HiPS to merge do not provide weight tiles => assuming basic average");
            } else if (!this.liveOut) {
                this.context.warning("Target HiPS do not provide weight tiles => assuming weigth 1 for each output pixel");
            } else if (!this.liveIn) {
                this.context.warning("Source HiPS do not provide weight tiles => assuming weigth 1 for each input pixel");
            }
        }
        this.context.info("Merge mode (tiles): " + ModeMerge.getExplanation(this.context.getModeMerge()));
        this.context.info("Hierarchy mode (tree): " + ModeTree.getExplanation(this.context.getModeTree()));
        this.context.setLive(this.live);
    }

    protected boolean checkLiveByProperties(String path) {
        try {
            String s = BuilderConcat.loadProperty(path, "dataproduct_subtype");
            return s != null && s.indexOf("live") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void addAddendum(String sourcePath, String targetPath) throws Exception {
        String targetHipsId = this.getHipsIdFromProperty(targetPath);
        this.context.setHipsId(targetHipsId);
        String addendumId = BuilderConcat.loadProperty(targetPath, "addendum_id");
        this.context.setAddendum(addendumId);
        String sourceHipsId = this.getHipsIdFromProperty(sourcePath);
        this.context.addAddendum(sourceHipsId);
        this.context.info("Concat " + sourceHipsId + " into " + targetHipsId + "...");
    }

    protected String getHipsIdFromProperty(String path) throws Exception {
        MyProperties prop = BuilderConcat.loadProperties(path);
        return PlanHips.getHiPSID(prop);
    }

    protected void setContextParamFromPreviousAllskyFile(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadHeaderFITS(allskyFile);
        double[] cut = new double[4];
        try {
            cut[0] = f.headerFits.getDoubleFromHeader("PIXELMIN");
            cut[1] = f.headerFits.getDoubleFromHeader("PIXELMAX");
        }
        catch (Exception e) {
            cut[1] = 0.0;
            cut[0] = 0.0;
        }
        try {
            cut[2] = f.headerFits.getDoubleFromHeader("DATAMIN");
            cut[3] = f.headerFits.getDoubleFromHeader("DATAMAX");
        }
        catch (Exception e) {
            cut[3] = 0.0;
            cut[2] = 0.0;
        }
        this.context.setCut(cut);
        try {
            double blank;
            this.context.blank = blank = f.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception blank) {
            // empty catch block
        }
        try {
            double bscale;
            this.context.bscale = bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception bscale) {
            // empty catch block
        }
        try {
            double bzero;
            this.context.bzero = bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception bzero) {
            // empty catch block
        }
        try {
            int bitpix;
            this.context.bitpix = bitpix = f.headerFits.getIntFromHeader("BITPIX");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateParams(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadHeaderFITS(allskyFile);
        int bitpix = f.headerFits.getIntFromHeader("BITPIX");
        if (bitpix != this.context.bitpix) {
            throw new Exception("Uncompatible HiPS => input.BITPIX=" + bitpix + " output.BITPIX=" + this.context.bitpix);
        }
        double bscale = 1.0;
        try {
            bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        double bzero = 0.0;
        try {
            bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        double blank = Double.NaN;
        if (bscale != this.context.bscale || bzero != this.context.bzero) {
            this.context.info("BSCALE/BZERO modification => assuming input:" + bscale + "/" + bzero + " output:" + this.context.bscale + "/" + this.context.bzero);
        }
        try {
            blank = f.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Double.isNaN(blank) && blank != this.context.blank) {
            this.context.info("BLANK modification => assuming input:" + blank + " output:" + this.context.blank);
        }
    }

    @Override
    protected Fits createLeafHpx(ThreadBuilderTile hpx, String file, String path, BuilderRunner.AddrThread addr) throws Exception {
        int order = addr.order;
        long npix = addr.npix;
        int z = addr.z;
        long t = System.currentTimeMillis();
        Fits out = null;
        String inputFile = Util.getFilePath(this.inputPath, order, npix, z);
        Fits input = this.loadTile(inputFile);
        if (input == null) {
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 0, 1, duree, 0, 0L);
            return null;
        }
        double[] weightOut = null;
        double[] weightIn = null;
        String outFile = Util.getFilePath(this.outputPath, order, npix, z);
        if (this.mode != ModeMerge.mergeOverwriteTile && (out = this.loadTile(outFile)) != null && this.live) {
            weightOut = this.loadWeight(outFile, this.tileSide, this.tileDepth, 1.0);
        }
        if (this.live) {
            weightIn = this.loadWeight(inputFile, this.tileSide, this.tileDepth, 1.0);
        }
        switch (this.mode) {
            case mergeOverwriteTile: {
                input.adjustParams(this.bzero, this.bscale, this.blank);
                out = input;
                weightOut = weightIn;
                break;
            }
            case mergeKeepTile: {
                if (out != null) break;
                input.adjustParams(this.bzero, this.bscale, this.blank);
                out = input;
                weightOut = weightIn;
                break;
            }
            case mergeMean: {
                if (out != null) {
                    input.adjustParams(this.bzero, this.bscale, this.blank);
                    if (!this.live) {
                        input.coadd(out, 0);
                    } else {
                        input.coadd(out, weightIn, weightOut);
                    }
                }
                input.adjustParams(this.bzero, this.bscale, this.blank);
                out = input;
                weightOut = weightIn;
                break;
            }
            case mergeAdd: {
                if (out != null) {
                    out.coadd(input, 1);
                    if (!this.live) break;
                    for (int i = 0; i < weightOut.length; ++i) {
                        int n = i;
                        weightOut[n] = weightOut[n] + weightIn[i];
                    }
                    break;
                }
                input.adjustParams(this.bzero, this.bscale, this.blank);
                out = input;
                weightOut = weightIn;
                break;
            }
            case mergeKeep: {
                if (out != null) {
                    if (!this.live) {
                        out.mergeOnNaN(input);
                        break;
                    }
                    out.mergeOnNaN(input, weightOut, weightIn);
                    break;
                }
                input.adjustParams(this.bzero, this.bscale, this.blank);
                out = input;
                weightOut = weightIn;
                break;
            }
            case mergeOverwrite: {
                if (out != null) {
                    input.adjustParams(this.bzero, this.bscale, this.blank);
                    if (!this.live) {
                        input.mergeOnNaN(out);
                    } else {
                        input.mergeOnNaN(out, weightIn, weightOut);
                    }
                }
                input.adjustParams(this.bzero, this.bscale, this.blank);
                out = input;
                weightOut = weightIn;
                break;
            }
            case mergeSub: {
                if (out == null) break;
                out.coadd(input, 5);
                break;
            }
            case mergeMul: {
                if (out == null) break;
                out.coadd(input, 2);
                break;
            }
            case mergeDiv: {
                if (out == null) break;
                out.coadd(input, 3);
                break;
            }
            default: {
                throw new Exception("Coadd mode [" + (Object)((Object)this.mode) + "] not supported for CONCAT action");
            }
        }
        if (out != null) {
            out.setDataMinMax(out.dataMin, out.dataMax);
            this.context.updateHeader(out, addr);
            this.write(outFile, out);
            if (this.liveOut) {
                this.writeWeight(outFile, weightOut, this.tileSide, this.tileDepth, addr, out);
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (this.doHpxFinder) {
            String inputIndexFile = Util.getFilePath(this.inputPathIndex, order, npix, z);
            HpxFinderTile inputIndex = this.loadIndex(inputIndexFile);
            String outIndexFile = Util.getFilePath(this.outputPathIndex, order, npix, z);
            HpxFinderTile outIndex = this.loadIndex(outIndexFile);
            switch (this.mode) {
                case mergeOverwriteTile: {
                    outIndex = inputIndex;
                    break;
                }
                case mergeKeepTile: {
                    if (outIndex != null) break;
                    outIndex = inputIndex;
                    break;
                }
                case mergeMean: 
                case mergeAdd: 
                case mergeKeep: 
                case mergeOverwrite: {
                    if (outIndex != null) {
                        inputIndex.merge(outIndex);
                    }
                    outIndex = inputIndex;
                }
            }
            this.writeIndex(outIndexFile, outIndex);
        }
        long duree = System.currentTimeMillis() - t;
        this.updateStat(0, 1, 0, duree, 0, 0L);
        return out;
    }

    private Fits loadTile(String file) throws Exception {
        Fits f = new Fits();
        try {
            if (this.tileMode == 2) {
                f.loadFITS(file + ".fits");
            } else if (this.tileMode == 0) {
                f.loadPreview(file + ".png", true, false, 2);
            } else if (this.tileMode == 1) {
                f.loadPreview(file + ".jpg", true, false, 1);
            }
        }
        catch (Exception e) {
            f = null;
        }
        return f;
    }

    private void writeIndex(String file, HpxFinderTile map) throws Exception {
        cds.tools.Util.createPath(file);
        map.writeStream(new FileOutputStream(file));
    }

    private HpxFinderTile loadIndex(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HpxFinderTile out = new HpxFinderTile();
        out.loadStream(new FileInputStream(f));
        return out;
    }
}

