/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.hipsgen.ContextGui;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;

public class BuilderClean
extends Builder {
    private int nbFile = 0;

    public BuilderClean(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CLEAN;
    }

    @Override
    public void supportHiPS3D() throws Exception {
    }

    @Override
    public void supportPack() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.resetCheckCode();
        this.context.writePropertiesFile();
        this.deleteDir(new File(this.context.getOutputPath()));
    }

    public void resetCheckCode() {
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }

    @Override
    public boolean isAlreadyDone() {
        return !new File(this.context.getOutputPath()).exists();
    }

    @Override
    public void showStatistics() {
        if (this.context instanceof ContextGui) {
            return;
        }
        this.context.stat(this.nbFile + " file" + (this.nbFile > 1 ? "s" : "") + " deleted");
    }

    public boolean mustBeDeleted(File f) {
        String name = f.getName();
        return !name.equals("properties");
    }

    public void deleteDir(File dir) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                this.deleteDir(f);
            }
            if (Files.isSymbolicLink(dir.toPath())) {
                Path target = Files.readSymbolicLink(dir.toPath());
                if (target.toFile().delete()) {
                    dir.delete();
                }
            } else {
                dir.delete();
            }
        } else if (this.mustBeDeleted(dir)) {
            if (!dir.delete()) {
                // empty if block
            }
            ++this.nbFile;
            this.context.setProgress(this.nbFile);
        }
    }

    public void deleteDirExceptIndex(File dir) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        for (File f : dir.listFiles()) {
            if (f.getName().equals("HpxFinder") || f.getName().equals("TimeFinder") || f.getName().equals("HpxCounter")) continue;
            this.deleteDir(f);
        }
    }
}

