/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderCheck;
import cds.hipsgen.BuilderCheckCode;
import cds.hipsgen.Context;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;

public class BuilderCheckFast
extends BuilderCheck {
    static final int MAXCORRUPT = 99;
    static final int MAXMISSING = 10;
    static final int MAXCHECKED = 100;
    int missingDataSum = 0;
    int corruptDataSum = 0;

    public BuilderCheckFast(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CHECKFAST;
    }

    @Override
    protected void validateContextMore() throws Exception {
    }

    @Override
    public void run() throws Exception {
        boolean isHiPS3D = this.context.isHiPS3D(this.context.getOutputPath());
        String fmt = "fits";
        BuilderCheckCode.Info info = new BuilderCheckCode.Info(fmt);
        for (int i = 0; i <= 3; ++i) {
            String glob = isHiPS3D ? "Norder" + i + "_*" : "Norder" + i + "*";
            DirectoryStream<Path> stream = Files.newDirectoryStream(new File(this.context.getOutputPath()).toPath(), glob);
            Iterator<Path> it = stream.iterator();
            if (!it.hasNext()) continue;
            File dir = it.next().toFile();
            this.scanDir(dir, fmt, info);
        }
        if (this.missingDataSum > 10 && this.corruptDataSum == 0) {
            this.context.warning("This HiPS has not DATASUM in their FITS tiles => No DATASUM check");
        } else if (this.corruptDataSum == 0) {
            this.context.info("Tested" + (this.missingDataSum == 0 ? "" : " tested") + " HiPS Fits tiles DATASUM Ok");
        } else {
            if (this.missingDataSum > 0) {
                this.context.warning(this.missingDataSum + " HiPS Fits tile(s) without DATASUM => not tested");
            }
            this.context.error("HiPS is corrupted");
        }
    }

    @Override
    public void scanDir(File dir, String fmt, BuilderCheckCode.Info info) throws Exception {
        if (this.nbFile > 100 || this.corruptDataSum > 0) {
            return;
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (dir.isDirectory()) {
            File[] list;
            for (File f : list = dir.listFiles()) {
                this.scanDir(f, fmt, info);
            }
            if (Files.isSymbolicLink(dir.toPath())) {
                Path target = Files.readSymbolicLink(dir.toPath());
                this.updateInfo(target.toFile(), info);
            }
        } else if (this.mustBeScanned(dir, fmt)) {
            this.updateInfo(dir, info);
            ++this.nbFile;
            this.context.setProgress(this.nbFile);
        }
    }

    @Override
    protected void updateInfo(File f, BuilderCheckCode.Info info) throws Exception {
        super.updateInfo(f, info);
        Fits fits = new Fits();
        fits.loadFITS(f.getAbsolutePath(), false);
        int check = fits.checkDataSum();
        if (check == 0) {
            ++this.corruptDataSum;
            info.addCorruptedFile(f);
        } else if (check == -1) {
            ++this.missingDataSum;
        }
    }
}

