/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.BuilderCheckCode;
import cds.hipsgen.Context;
import java.io.File;

public class BuilderCheckDataSum
extends BuilderCheckCode {
    static final int MAXCORRUPT = 99;
    static final int MAXMISSING = 10;
    int missingDataSum = 0;
    int corruptDataSum = 0;
    boolean flagGlobalDataSum = false;
    long globalDataSum = 0L;

    public BuilderCheckDataSum(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CHECKDATASUM;
    }

    @Override
    protected void validateContextMore() throws Exception {
        if (this.format.indexOf("fits") < 0) {
            throw new Exception("No Fits tiles for this HiPS!");
        }
        this.activateGlobalDataSum(this.context.flagGlobalDataSum);
    }

    public long getDataGlobalDataSum() throws Exception {
        if (!this.flagGlobalDataSum) {
            throw new Exception("Global DATASUM not computed (use activateGlobalDataSum(true) before)");
        }
        return this.globalDataSum;
    }

    private void activateGlobalDataSum(boolean flag) {
        this.flagGlobalDataSum = flag;
    }

    @Override
    public void run() throws Exception {
        BuilderCheckCode.Info info = this.scanDir(new File(this.context.getOutputPath()), "fits");
        if (this.missingDataSum > 10 && this.corruptDataSum == 0) {
            this.context.warning("This HiPS has not DATASUM in their FITS tiles => No DATASUM check");
        } else if (this.corruptDataSum == 0) {
            this.context.info("All" + (this.missingDataSum == 0 ? "" : " tested") + " HiPS Fits tiles DATASUM Ok");
        } else {
            this.context.error(this.corruptDataSum + " HiPS Fits tile(s) corrupted (DATASUM not compliant)!");
            this.report(info);
            if (this.missingDataSum > 0) {
                this.context.warning(this.missingDataSum + " HiPS Fits tile(s) without DATASUM => not tested");
            }
            throw new Exception("HiPS is corrupted");
        }
        if (this.flagGlobalDataSum) {
            this.context.info("Global DATASUM: " + this.globalDataSum);
        }
    }

    private void report(BuilderCheckCode.Info info) {
        for (File f : info.corruptedFile) {
            this.context.info("   ." + f.getAbsolutePath());
        }
    }

    @Override
    protected void updateInfo(File f, BuilderCheckCode.Info info) throws Exception {
        super.updateInfo(f, info);
        if (this.missingDataSum > 10 && this.corruptDataSum == 0) {
            return;
        }
        Fits fits = new Fits();
        fits.loadFITS(f.getAbsolutePath(), false);
        int check = fits.checkDataSum();
        if (check == 0) {
            ++this.corruptDataSum;
            info.addCorruptedFile(f);
        } else if (check == -1) {
            ++this.missingDataSum;
        }
        if (this.flagGlobalDataSum) {
            this.globalDataSum = fits.computeDataSum(this.globalDataSum);
        }
        if (this.corruptDataSum > 99) {
            this.context.error("A lot of HiPS Fits tile(s) corrupted (DATASUM not compliant)!");
            this.report(info);
            this.context.info("   ...");
            throw new Exception("Too many corrupted Fits tiles (DATASUM not compliant))");
        }
    }
}

