/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Tok;
import cds.fits.Fits;
import cds.hipsgen.Action;
import cds.hipsgen.Builder;
import cds.hipsgen.Context;
import cds.hipsgen.HipsGen;
import cds.hipsgen.ModeMerge;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ModeTree;
import cds.hipsgen.Param;
import cds.tools.pixtools.Util;
import java.io.File;

public class BuilderAppend
extends Builder {
    private String outputPath;
    private String inputPath;
    private ModeMerge mode;
    private boolean live = false;
    private String color;
    private String addHipsPath;
    private int order;
    private String skyval;
    private String skyvalues;
    private String pixelCut = null;
    private String dataRange = null;
    private int bitpix = -1;
    private double bzero = 0.0;
    private double bscale = 1.0;
    private double blank = Double.NaN;
    private String addendumId;
    private String hipsName = null;

    public BuilderAppend(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.APPEND;
    }

    @Override
    public void run() throws Exception {
        this.createAddHips();
        this.concatHips();
        this.removeAddHips();
    }

    private String getAddHipsName() {
        if (this.hipsName == null) {
            this.hipsName = "AddsHips" + System.currentTimeMillis() / 1000L;
        }
        return this.hipsName;
    }

    private void createAddHips() throws Exception {
        ModeTree mt;
        ModeMerge mm;
        String sformat;
        HipsGen hi = new HipsGen();
        String spart = " " + (Object)((Object)Param.partitioning) + "=" + (this.context.isPartitioning() ? Integer.valueOf(this.context.getPartitioning()) : "false");
        String spixelCut = this.pixelCut == null ? "" : " \"" + (Object)((Object)Param.pixelCut) + "=" + this.pixelCut + "\"";
        String sdataRange = this.dataRange == null ? "" : " \"" + (Object)((Object)Param.dataRange) + "=" + this.dataRange + "\"";
        String sbitpix = "";
        String string = sformat = this.color != null ? " " + (Object)((Object)Param.color) + "=" + this.color : "";
        if (this.bitpix != -1) {
            sbitpix = " " + (Object)((Object)Param.bitpix) + "=" + this.bitpix;
        }
        String slive = this.live ? " " + (Object)((Object)Param.incremental) + "=true" : "";
        StringBuilder smode = new StringBuilder();
        ModeOverlay mo = this.context.getModeOverlay();
        if (!mo.equals((Object)ModeOverlay.getDefault())) {
            if (smode.length() > 0) {
                smode.append(',');
            } else {
                smode.append(" " + (Object)((Object)Param.mode) + "=");
            }
            smode.append((Object)mo);
        }
        if (!(mm = this.context.getModeMerge()).equals((Object)ModeMerge.getDefault(this.bitpix))) {
            if (smode.length() > 0) {
                smode.append(',');
            } else {
                smode.append(" " + (Object)((Object)Param.mode) + "=");
            }
            smode.append((Object)mm);
        }
        if (!(mt = this.context.getModeTree()).equals((Object)ModeTree.getDefault(this.bitpix))) {
            if (smode.length() > 0) {
                smode.append(',');
            } else {
                smode.append(" " + (Object)((Object)Param.mode) + "=");
            }
            smode.append((Object)mt);
        }
        String cmd = "in=\"" + this.context.getInputPath() + "\" out=\"" + this.addHipsPath + "\" " + (Object)((Object)Param.id) + "=" + this.addendumId + " " + (Object)((Object)Param.order) + "=" + this.order + slive + spart + smode + sformat + sbitpix + spixelCut + sdataRange + (this.skyvalues != null ? " \"" + (Object)((Object)Param.skyvalues) + "=" + this.skyvalues + "\"" : (this.skyval != null ? " " + (Object)((Object)Param.skyVal) + "=" + this.skyval : "")) + " INDEX TILES";
        BuilderAppend builderAppend = this;
        if (builderAppend.context.getVerbose() >= 3) {
            System.out.println("APPEND phase 1 => " + cmd);
        }
        Tok tok = new Tok(cmd);
        String[] param = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            param[i] = tok.nextToken();
            ++i;
        }
        hi.execute(param);
        if (hi.context.isTaskAborting()) {
            this.context.taskAbort();
            throw new Exception("Aborting");
        }
    }

    private void removeAddHips() throws Exception {
        this.context.info("Cleaning temporary HiPS " + this.addHipsPath + "...");
        cds.tools.Util.deleteDir(new File(this.addHipsPath));
    }

    private void concatHips() throws Exception {
        ModeTree mt;
        HipsGen hi = new HipsGen();
        StringBuilder smode = new StringBuilder();
        ModeMerge mm = this.context.getModeMerge();
        if (!mm.equals((Object)ModeMerge.getDefault(this.bitpix))) {
            if (smode.length() > 0) {
                smode.append(',');
            } else {
                smode.append(" mode=");
            }
            smode.append((Object)mm);
        }
        if (!(mt = this.context.getModeTree()).equals((Object)ModeTree.getDefault(this.bitpix))) {
            if (smode.length() > 0) {
                smode.append(',');
            } else {
                smode.append(" mode=");
            }
            smode.append((Object)mt);
        }
        String cmd = "out=\"" + this.context.getOutputPath() + "\" in=\"" + this.addHipsPath + "\"" + smode + " CONCAT";
        BuilderAppend builderAppend = this;
        if (builderAppend.context.getVerbose() >= 3) {
            System.out.println("APPEND phase 2 => " + cmd);
        }
        Tok tok = new Tok(cmd);
        String[] param = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            param[i] = tok.nextToken();
            ++i;
        }
        hi.execute(param);
        if (hi.context.isTaskAborting()) {
            this.context.taskAbort();
            throw new Exception("Aborting");
        }
    }

    @Override
    public void validateContext() throws Exception {
        block17: {
            this.outputPath = this.context.getOutputPath();
            this.inputPath = this.context.getInputPath();
            this.addHipsPath = cds.tools.Util.concatDir(this.outputPath, this.getAddHipsName());
            this.mode = this.context.getModeMerge();
            if (this.inputPath == null) {
                throw new Exception("\"in\" parameter required !");
            }
            File f = new File(this.inputPath);
            if (!f.exists() || !f.canRead()) {
                throw new Exception("Input directory or image not available [" + this.inputPath + "]");
            }
            this.skyval = this.getSkyVal(this.outputPath);
            if (this.skyval != null && this.skyval.toLowerCase().equals("auto")) {
                try {
                    this.skyvalues = BuilderAppend.loadProperty(this.outputPath, "hips_skyval_value");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.pixelCut = BuilderAppend.loadProperty(this.outputPath, "hips_pixel_cut");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dataRange = BuilderAppend.loadProperty(this.outputPath, "hips_data_range");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.order = -1;
            try {
                this.order = Util.getMaxOrderByPath(this.outputPath);
            }
            catch (Exception e) {
                BuilderAppend builderAppend = this;
                if (builderAppend.context.getVerbose() < 3) break block17;
                e.printStackTrace();
            }
        }
        if (this.order == -1) {
            throw new Exception("No HiPS found in ouput dir");
        }
        this.context.setOrder(this.order);
        int inputOrder = Util.getMaxOrderByPath(this.inputPath);
        if (inputOrder != -1) {
            throw new Exception("The input directory must contains original images/cubes. Use CONCAT if you want to merge two HiPS");
        }
        this.context.info("Order retrieved from [" + this.outputPath + "] => " + this.order);
        try {
            double[] v = this.getBitpixBzeroBscaleBlank(this.outputPath);
            this.bitpix = (int)v[0];
            this.bzero = v[1];
            this.bscale = v[2];
            this.blank = v[3];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mode == ModeMerge.copy || this.mode == ModeMerge.link) {
            throw new Exception("Merge mode [" + (Object)((Object)this.mode) + "] not supported for APPEND action");
        }
        this.context.info("Merge mode (tiles): " + ModeMerge.getExplanation(this.context.getModeMerge()));
        this.live = this.checkLiveByProperties(this.context.getOutputPath());
        if (this.mode == ModeMerge.mergeMean && !this.live) {
            this.context.warning("Target HiPS does not provide weight tiles => assuming weigth 1 for each output pixel");
        }
        this.color = this.getColorFormat(this.context.getOutputPath());
        this.addendumId = "APPEND/P/" + System.currentTimeMillis() / 1000L;
    }

    protected String getColorFormat(String path) {
        try {
            String s = BuilderAppend.loadProperty(path, "dataproduct_subtype");
            if (s == null || s.indexOf("color") < 0) {
                return null;
            }
            return BuilderAppend.loadProperty(path, "hips_tile_format");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean checkLiveByProperties(String path) {
        try {
            String s = BuilderAppend.loadProperty(path, "dataproduct_subtype");
            return s != null && s.indexOf("live") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getSkyVal(String path) {
        try {
            String s = BuilderAppend.loadProperty(path, "hips_skyval_method");
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected double[] getBitpixBzeroBscaleBlank(String path) throws Exception {
        String filename = Context.findOneNpixFile(path);
        Fits f = new Fits();
        f.loadFITS(filename);
        return new double[]{f.bitpix, f.bzero, f.bscale, f.blank};
    }
}

