/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.prop.PropPanel;
import cds.fits.CacheFits;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class BuildProgressPanel
extends JPanel {
    private JPanel p1Index = new JPanel();
    private JPanel p2Tess = new JPanel();
    private String string1 = "Healpix Indexation";
    private String string2 = "Sky tesselation";
    private JLabel labelIndex = new JLabel(this.string1);
    private JLabel labelTess = new JLabel(this.string2);
    private JProgressBar progressBarIndex = new JProgressBar(0, 100);
    private JProgressBar progressBarTile = new JProgressBar(0, 100);
    private JLabel srcFileStat;
    private JLabel memStat;
    private JLabel lowTileStat;
    private JLabel nodeTileStat;
    private JLabel timeStat;

    public BuildProgressPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createProgressPanel(), "North");
        this.add((Component)this.createStatPanel(), "Center");
    }

    protected void setSrcStat(int nbFile, int nbZipFile, long totalSize, long maxSize, int maxWidth, int maxHeight, int maxDepth, int maxNbyte) {
        String s = nbFile == -1 ? "--" : nbFile + " file" + (nbFile > 1 ? "s" : "") + (nbZipFile == nbFile ? " (all gzipped)" : (nbZipFile > 0 ? " (" + nbZipFile + " gzipped)" : "")) + " using " + Util.getUnitDisk(totalSize) + (nbFile > 1 && maxSize < 0L ? "" : " => biggest: [" + maxWidth + "x" + maxHeight + (maxDepth > 1 ? "x" + maxDepth : "") + " x" + maxNbyte + "]");
        this.srcFileStat.setText(s);
    }

    protected void srcFileStat(String s) {
        this.srcFileStat.setText(s);
    }

    protected void setMemStat(int nbRunningThread, int nbThread, CacheFits cacheFits) {
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        String s = (nbThread > 1 ? "thread: " + (nbRunningThread == -1 ? "" : nbRunningThread + " / " + nbThread) + " - " : "") + "RAM: " + Util.getUnitDisk(usedMem) + "/" + Util.getUnitDisk(maxMem) + " (FITS cache: " + Util.getUnitDisk(cacheFits.getMem()) + ")";
        this.setMemStat(s);
    }

    protected void setMemStat(String s) {
        this.memStat.setText(s);
    }

    protected void setLowTileStat(int nbTile, int nbEmptyTile, long nbCells, long sizeTile, long minTime, long maxTime, long avgTime) {
        String s = nbTile == -1 ? "" : nbTile + "+" + nbEmptyTile + "/" + nbCells + " tile" + (nbTile > 1 ? "s" : "") + " for " + Util.getUnitDisk(sizeTile * (long)nbTile) + " - avg.proc.time: " + Util.getTemps(avgTime * 1000L) + " [" + Util.getTemps(minTime * 1000L) + " .. " + Util.getTemps(maxTime * 1000L) + "]";
        this.setLowTileStat(s);
    }

    protected void setLowTileStat(String s) {
        this.lowTileStat.setText(s);
    }

    protected void setNodeTileStat(int nbTile, long sizeTile, long avgTime) {
        String s = nbTile == -1 ? "" : nbTile + " tile" + (nbTile > 1 ? "s" : "") + " for " + Util.getUnitDisk(sizeTile * (long)nbTile) + " - avg.proc.time: " + Util.getTemps(avgTime * 1000L);
        this.setNodeTileStat(s);
    }

    protected void setNodeTileStat(String s) {
        this.nodeTileStat.setText(s);
    }

    protected void setTimeStat(long time, long nbTilesPerMin, long tempsTotalEstime) {
        StringBuilder s = new StringBuilder();
        if (time != -1L) {
            s.append((tempsTotalEstime > 0L ? "running " : "") + Util.getTemps(time * 1000L));
        }
        if (time > 5000L && tempsTotalEstime > 0L) {
            s.append(" - " + nbTilesPerMin + " tiles/mn");
        }
        if (time > 20000L && tempsTotalEstime > 0L) {
            s.append(" - ends in " + Util.getTemps(tempsTotalEstime * 1000L));
        }
        this.setTimeStat(s + "");
    }

    protected void setTimeStat(String s) {
        this.timeStat.setText(s);
    }

    private JPanel createStatPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 10, 2, 2);
        JPanel p = new JPanel(g);
        this.srcFileStat = new JLabel("--");
        PropPanel.addCouple(p, ".Original images: ", this.srcFileStat, g, c);
        this.memStat = new JLabel("--");
        PropPanel.addCouple(p, ".Processing info: ", this.memStat, g, c);
        this.lowTileStat = new JLabel("--");
        PropPanel.addCouple(p, ".Low level tiles: ", this.lowTileStat, g, c);
        this.nodeTileStat = new JLabel("--");
        PropPanel.addCouple(p, ".Tree tiles: ", this.nodeTileStat, g, c);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(p, ".Time: ", this.timeStat, g, c);
        return p;
    }

    private JPanel createProgressPanel() {
        JPanel p = new JPanel(new GridLayout(1, 2, 5, 5));
        this.p1Index.setLayout(new BorderLayout());
        this.p2Tess.setLayout(new BorderLayout());
        this.select(true, 0);
        this.select(true, 1);
        this.p1Index.add((Component)this.labelIndex, "North");
        this.p2Tess.add((Component)this.labelTess, "North");
        this.progressBarIndex.setStringPainted(true);
        this.progressBarTile.setStringPainted(true);
        this.p1Index.add((Component)this.progressBarIndex, "South");
        this.p2Tess.add((Component)this.progressBarTile, "South");
        p.add(this.p1Index);
        p.add(this.p2Tess);
        return p;
    }

    protected void resetProgressBar() {
        for (JProgressBar bar : new JProgressBar[]{this.progressBarIndex, this.progressBarTile}) {
            bar.setIndeterminate(false);
            bar.setValue(0);
            bar.setMaximum(100);
            bar.setString(null);
        }
    }

    public void clearForms() {
        this.progressBarTile.setValue(0);
        this.progressBarIndex.setValue(0);
        this.labelIndex.setText(this.string1);
        this.select(true, 0);
        this.select(true, 1);
        this.resetProgressBar();
    }

    public void select(boolean enabled, int index) {
        JLabel label = null;
        switch (index) {
            case 0: {
                label = this.labelIndex;
                break;
            }
            case 1: {
                label = this.labelTess;
            }
        }
        if (!enabled) {
            label.setFont(this.getFont().deriveFont(2));
            label.setForeground(Color.LIGHT_GRAY);
        } else {
            label.setFont(this.getFont().deriveFont(0));
            label.setForeground(Color.BLACK);
        }
        this.repaint();
    }

    public JProgressBar getProgressBarTile() {
        return this.progressBarTile;
    }

    public JProgressBar getProgressBarIndex() {
        return this.progressBarIndex;
    }

    public void setProgressIndexDir(String txt) {
        this.labelIndex.setText(this.string1 + " " + txt);
        this.labelIndex.setPreferredSize(this.labelIndex.getSize());
    }
}

