/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.CompassPoint;
import cds.healpix.FlatHashList;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.NeighbourSelector;
import cds.healpix.NestedSmallCell;
import cds.healpix.SettableHashParts;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.Math;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.logging.Logger;

final class NestedSmallCellApproxedMethod
implements HealpixNestedFixedRadiusConeComputer {
    private static final EnumSet<CompassPoint.Cardinal> ALL_CARDINALS = EnumSet.allOf(CompassPoint.Cardinal.class);
    private final AngularDistanceComputer angDistComputer;
    private final int startingDepth;
    private final int deeperDepth;
    private final int deltaDepthMax;
    private final double rRad;
    private final HashComputer hComputerStartingDepth;
    private final VerticesAndPathComputer[] hcc;
    private final NeighbourSelector neigSelector;
    private final HealpixNested hnDeeperDepth;
    private final HashComputer hComputerDeeperDepth;
    private final FlatHashList neigList;
    private int baseCellHash;
    private int iInBaseCell;
    private int jInBaseCell;
    private final SettableHashParts hashPartsProxy = new SettableHashParts(){

        @Override
        public int baseCellHash() {
            return NestedSmallCellApproxedMethod.this.baseCellHash;
        }

        @Override
        public int iInBaseCell() {
            return NestedSmallCellApproxedMethod.this.iInBaseCell;
        }

        @Override
        public int jInBaseCell() {
            return NestedSmallCellApproxedMethod.this.jInBaseCell;
        }

        @Override
        public void setBaseCellHash(int baseCelHash) {
            NestedSmallCellApproxedMethod.this.baseCellHash = baseCelHash;
        }

        @Override
        public void setIInBaseCell(int iInBaseCel) {
            NestedSmallCellApproxedMethod.this.iInBaseCell = iInBaseCel;
        }

        @Override
        public void setJInBaseCell(int jInBaseCel) {
            NestedSmallCellApproxedMethod.this.jInBaseCell = jInBaseCel;
        }
    };

    public NestedSmallCellApproxedMethod(int startingDepth, int deeperDepth, double radiusRad) {
        assert (radiusRad > 0.0);
        this.startingDepth = startingDepth;
        this.deeperDepth = deeperDepth;
        this.deltaDepthMax = this.deeperDepth - this.startingDepth;
        this.rRad = radiusRad;
        this.hcc = new VerticesAndPathComputer[this.deltaDepthMax + 1];
        if (this.startingDepth == -1) {
            this.hcc[0] = null;
            this.hComputerStartingDepth = null;
            this.neigSelector = null;
        } else {
            HealpixNested hn = Healpix.getNested(this.startingDepth);
            this.hcc[0] = hn.newVerticesAndPathComputer();
            this.hComputerStartingDepth = hn.newHashComputer();
            this.neigSelector = hn.newNeighbourSelector();
        }
        this.hnDeeperDepth = Healpix.getNested(this.startingDepth + this.deltaDepthMax);
        this.hComputerDeeperDepth = this.hnDeeperDepth.newHashComputer();
        for (int i = 1; i <= this.deltaDepthMax; ++i) {
            this.hcc[i] = Healpix.getNested(this.startingDepth + i).newVerticesAndPathComputer();
        }
        this.angDistComputer = AngularDistanceComputer.getComputer(this.rRad);
        this.neigList = new FlatHashList(-1, 9);
    }

    @Override
    public double getRadius() {
        return this.rRad;
    }

    @Override
    public HealpixNestedFixedRadiusConeComputer newComputer() {
        return new NestedSmallCellApproxedMethod(this.startingDepth, this.deeperDepth, this.rRad);
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad) {
        return this.overlapping(coneCenterLonRad, coneCenterLatRad, Mode.OVERLAPPING_CELLS);
    }

    @Override
    public HealpixNestedBMOC overlappingCenters(double coneCenterLonRad, double coneCenterLatRad) {
        return this.overlapping(coneCenterLonRad, coneCenterLatRad, Mode.OVERLAPPING_CENTERS);
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad, HealpixNestedFixedRadiusConeComputer.ReturnedCells returnedCells) {
        switch (returnedCells) {
            case FULLY_IN: {
                return this.overlapping(coneCenterLonRad, coneCenterLatRad, Mode.FULLY_IN);
            }
            case OVERLAPPING: {
                return this.overlappingCells(coneCenterLonRad, coneCenterLatRad);
            }
            case CENTER_IN: {
                return this.overlappingCenters(coneCenterLonRad, coneCenterLatRad);
            }
        }
        throw new Error("Type " + (Object)((Object)returnedCells) + " not implemented!");
    }

    public HealpixNestedBMOC overlapping(double coneCenterLonRad, double coneCenterLatRad, Mode mode) {
        double cosConeCenterLat = Math.cos(coneCenterLatRad);
        coneCenterLonRad = NestedSmallCell.normalizeLon(coneCenterLonRad);
        assert (0.0 <= coneCenterLonRad && coneCenterLonRad <= java.lang.Math.PI * 2);
        int uppderBoundGuess = this.nMocCellInConeUpperBound() << 1;
        GrowableLongArray mocElems = new GrowableLongArray(uppderBoundGuess);
        if (this.startingDepth == -1) {
            for (int h = 0; h < 12; ++h) {
                this.buildMocRecursively(mocElems, 1, h, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, mode);
            }
        } else {
            long centerHash = this.hComputerStartingDepth.hash(coneCenterLonRad, coneCenterLatRad);
            assert (-1.5707963267948966 <= coneCenterLatRad && coneCenterLatRad <= 1.5707963267948966);
            this.neigSelector.neighbours(centerHash, this.neigList);
            this.neigList.put(centerHash);
            this.neigList.sortByHashAsc();
            for (int i = 0; i < this.neigList.size(); ++i) {
                this.buildMocRecursively(mocElems, 0, this.neigList.get(i), coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, mode);
            }
        }
        return HealpixNestedBMOC.createPacking(this.deeperDepth, mocElems.array, mocElems.cursor);
    }

    private final GrowableLongArray buildMocRecursively(GrowableLongArray moc, int deltaDepth, long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat, Mode mode) {
        int depth = this.startingDepth + deltaDepth;
        assert (this.hcc[deltaDepth].depth() == depth);
        VerticesAndPathComputer vpc = this.hcc[deltaDepth];
        double[] center = vpc.center(hash);
        double cellCenterLon = center[0];
        double cellCenterLat = center[1];
        double dConeCell = this.angDistComputer.haversineDistInRad(cellCenterLon - coneCenterLon, cellCenterLat - coneCenterLat, cosCenterLat, Math.cos(cellCenterLat));
        double rCircumCircle = Healpix.getLargestCenterToCellVertexDistance(cellCenterLon, cellCenterLat, depth);
        if (NestedSmallCellApproxedMethod.isCellFullyInCone(this.rRad, rCircumCircle, dConeCell)) {
            moc.add(HealpixNestedBMOC.buildValue(this.startingDepth + deltaDepth, hash, true, this.deeperDepth));
        } else if (NestedSmallCellApproxedMethod.isCellOverlapingCone(this.rRad, rCircumCircle, dConeCell)) {
            if (deltaDepth == this.deltaDepthMax) {
                if (mode.isOk(dConeCell, this.rRad, vpc, hash, coneCenterLon, coneCenterLat, cosCenterLat, this.angDistComputer)) {
                    moc.add(HealpixNestedBMOC.buildValue(this.deeperDepth, hash, false, this.deeperDepth));
                }
            } else {
                this.buildMocRecursively(moc, ++deltaDepth, hash <<= 2, coneCenterLon, coneCenterLat, cosCenterLat, mode);
                this.buildMocRecursively(moc, deltaDepth, ++hash, coneCenterLon, coneCenterLat, cosCenterLat, mode);
                this.buildMocRecursively(moc, deltaDepth, ++hash, coneCenterLon, coneCenterLat, cosCenterLat, mode);
                this.buildMocRecursively(moc, deltaDepth, ++hash, coneCenterLon, coneCenterLat, cosCenterLat, mode);
            }
        }
        return moc;
    }

    private final int nMocCellInConeUpperBound() {
        return 10 << this.deltaDepthMax;
    }

    private static final boolean isCellFullyInCone(double coneRadius, double cellCircumCircleRadius, double coneCenterToCellCenterDistance) {
        return coneCenterToCellCenterDistance <= coneRadius - cellCircumCircleRadius;
    }

    private static final boolean isCellOverlapingCone(double coneRadius, double cellCircumCircleRadius, double coneCenterToCellCenterDistance) {
        return coneCenterToCellCenterDistance < coneRadius + cellCircumCircleRadius;
    }

    private final int ringIndex(int deltaDepth, long hash) {
        this.hnDeeperDepth.decodeRegularHash(hash, this.hashPartsProxy);
        return NestedSmallCellApproxedMethod.ringIndex(this.hnDeeperDepth, this.baseCellHash, this.iInBaseCell, this.jInBaseCell);
    }

    private static final int ringIndex(HealpixNested hn, long baseCellHash, int iInBasePixel, int jInBasePixel) {
        int h = iInBasePixel + jInBasePixel;
        long jBasePixel = hn.dividedBy4Quotient(baseCellHash);
        return (int)(hn.nsideTime(jBasePixel + 2L) - (long)(h + 2));
    }

    private static enum Mode {
        OVERLAPPING_CELLS{

            @Override
            public boolean isOk(double dConeCell, double rRad, VerticesAndPathComputer vpc, long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat, AngularDistanceComputer angDistComputer) {
                return true;
            }
        }
        ,
        OVERLAPPING_CENTERS{

            @Override
            public boolean isOk(double dConeCell, double rRad, VerticesAndPathComputer vpc, long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat, AngularDistanceComputer angDistComputer) {
                return dConeCell <= rRad;
            }
        }
        ,
        FULLY_IN{

            @Override
            public boolean isOk(double dConeCell, double rRad, VerticesAndPathComputer vpc, long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat, AngularDistanceComputer angDistComputer) {
                return dConeCell <= rRad && this.allVerticesOk(rRad, vpc, hash, coneCenterLon, coneCenterLat, cosCenterLat, angDistComputer);
            }

            private boolean allVerticesOk(double rRad, VerticesAndPathComputer vpc, long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat, AngularDistanceComputer angDistComputer) {
                for (double[] vertex : vpc.vertices(hash, ALL_CARDINALS).values()) {
                    double vLat;
                    double vLon = vertex[0];
                    double dConeCell = angDistComputer.haversineDistInRad(vLon - coneCenterLon, (vLat = vertex[1]) - coneCenterLat, cosCenterLat, Math.cos(vLat));
                    if (!(dConeCell > rRad)) continue;
                    return false;
                }
                return true;
            }
        };


        public abstract boolean isOk(double var1, double var3, VerticesAndPathComputer var5, long var6, double var8, double var10, double var12, AngularDistanceComputer var14);
    }

    public static final class GrowableLongArray {
        public static final Logger LOGGER = Logger.getLogger(NestedSmallCellApproxedMethod.class.getPackage().getName());
        private long[] array;
        private int cursor;

        public GrowableLongArray(int capacity) {
            assert (capacity > 1);
            this.array = new long[capacity];
            this.cursor = 0;
        }

        public long[] getArray() {
            return this.array;
        }

        public int getCursor() {
            return this.cursor;
        }

        public final void add(long value) {
            if (this.cursor == this.array.length) {
                LOGGER.finer("Had to grow unpacked moc size!");
                this.array = Arrays.copyOf(this.array, this.array.length + (this.array.length >> 1));
            }
            this.array[this.cursor++] = value;
        }
    }
}

