/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AuxiliaryAxis;
import cds.healpix.CompassPoint;
import cds.healpix.FlatHashList;
import cds.healpix.HashBits;
import cds.healpix.HashComputer;
import cds.healpix.HashComputerWithAux;
import cds.healpix.HashParts;
import cds.healpix.HashPartsImpl;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedFixedRadiusCone4XMatch;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.HealpixNestedHashComputer;
import cds.healpix.HealpixNestedHashComputerWithAux;
import cds.healpix.HealpixNestedNeighbourSelector;
import cds.healpix.HealpixNestedPolygonComputer;
import cds.healpix.HealpixNestedVerticesAndPathComputer;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.NestedAllSky;
import cds.healpix.NestedEllipticalConeComputerApprox;
import cds.healpix.NestedLargeCell;
import cds.healpix.NestedLargeCellApproxedMethod;
import cds.healpix.NestedLargeCellSmallRadius;
import cds.healpix.NestedSmallCell;
import cds.healpix.NestedSmallCellApproxedMethod;
import cds.healpix.RegularConeOrdinalHashComputer;
import cds.healpix.SettableHashParts;
import cds.healpix.SmallConeOrdinalHashComputer;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.fillingcurve.FillingCurve2D;
import cds.healpix.fillingcurve.FillingCurve2DType;
import java.util.EnumMap;
import java.util.EnumSet;

public final class HealpixNested
implements HashComputer,
VerticesAndPathComputer,
NeighbourSelector {
    final int depth;
    final long nHash;
    final int twiceDepth;
    final int nside;
    final double oneOverNside;
    private final long halfNside4IEEEdouble;
    final int nsideRemainderMask;
    private final double xScale;
    private final double yScaleCEA;
    private final double yScaleCOL;
    final double xHalfScale;
    final double yHalfScaleCEA;
    final double yHalfScaleCOL;
    private final long d0Mask;
    final long xyMask;
    final long xMask;
    final long yMask;
    final FillingCurve2DType fillingCurveType;
    final FillingCurve2D fc;
    private HashComputer hashComputer;
    private VerticesAndPathComputer vpComputer;
    private HealpixNestedNeighbourSelector neigSelector;

    protected HealpixNested(int depth, FillingCurve2DType fillingCurveType) {
        this.depth = depth;
        this.nside = Healpix.nside(this.depth);
        this.halfNside4IEEEdouble = Healpix.halfNside4IEEEdouble(this.depth);
        this.oneOverNside = 1.0 / (double)this.nside;
        this.nHash = Healpix.nHash(this.depth);
        this.twiceDepth = this.depth << 1;
        assert (this.twiceDepth == this.depth * 2);
        this.d0Mask = 15L << this.twiceDepth;
        if (this.depth > 0) {
            this.xyMask = (1L << this.twiceDepth) - 1L;
            this.xMask = 0x5555555555555555L >>> 64 - this.twiceDepth;
            this.yMask = this.xMask << 1;
            assert (this.yMask == -6148914691236517206L >>> 64 - this.twiceDepth);
        } else {
            this.xyMask = 0L;
            this.xMask = 0L;
            this.yMask = 0L;
        }
        this.nsideRemainderMask = this.nside - 1;
        this.xScale = (double)this.nside * 1.2732395447351628;
        this.yScaleCEA = (double)this.nside * 1.5;
        this.yScaleCOL = this.nside;
        this.xHalfScale = 0.5 * this.xScale;
        this.yHalfScaleCEA = 0.5 * this.yScaleCEA;
        this.yHalfScaleCOL = 0.5 * this.yScaleCOL;
        this.fillingCurveType = fillingCurveType;
        this.fc = this.fillingCurveType.get(depth);
        this.neigSelector = new HealpixNestedNeighbourSelector(this);
    }

    @Override
    public int depth() {
        return this.depth;
    }

    public HashComputer newHashComputer() {
        return new HealpixNestedHashComputer(this);
    }

    public long getNHash() {
        return this.nHash;
    }

    public HashComputerWithAux newHashComputerWithAux(AuxiliaryAxis auxAxis) {
        return new HealpixNestedHashComputerWithAux(this, auxAxis);
    }

    @Override
    public long hash(double lonRad, double latRad) {
        if (this.hashComputer == null) {
            this.hashComputer = new HealpixNestedHashComputer(this);
        }
        return this.hashComputer.hash(lonRad, latRad);
    }

    public VerticesAndPathComputer newVerticesAndPathComputer() {
        return new HealpixNestedVerticesAndPathComputer(this);
    }

    @Override
    public double[] center(long hash) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        return this.vpComputer.center(hash);
    }

    @Override
    public void center(long hash, double[] resultLonLat) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        this.vpComputer.center(hash, resultLonLat);
    }

    @Override
    public double[] vertex(long hash, CompassPoint.Cardinal cardinalPoint) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        return this.vpComputer.vertex(hash, cardinalPoint);
    }

    @Override
    public void vertex(long hash, CompassPoint.Cardinal cardinalPoint, double[] resultLonLat) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        this.vpComputer.vertex(hash, cardinalPoint, resultLonLat);
    }

    @Override
    public EnumMap<CompassPoint.Cardinal, double[]> vertices(long hash, EnumSet<CompassPoint.Cardinal> cardinalPoints) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        return this.vpComputer.vertices(hash, cardinalPoints);
    }

    @Override
    public void vertices(long hash, EnumMap<CompassPoint.Cardinal, double[]> cardinalPoints) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        this.vpComputer.vertices(hash, cardinalPoints);
    }

    @Override
    public double[][] pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        return this.vpComputer.pathAlongCellSide(hash, fromVertex, toVertex, isToVertexIncluded, nSegments);
    }

    @Override
    public void pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        this.vpComputer.pathAlongCellSide(hash, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints);
    }

    @Override
    public double[][] pathAlongCellEdge(long hash, CompassPoint.Cardinal startingVertex, boolean clockwiseDirection, int nSegmentsBySide) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        return this.vpComputer.pathAlongCellEdge(hash, startingVertex, clockwiseDirection, nSegmentsBySide);
    }

    @Override
    public void pathAlongCellEdge(long hash, CompassPoint.Cardinal startingVertex, boolean clockwiseDirection, int nSegmentsBySide, double[][] pathPoints) {
        if (this.vpComputer == null) {
            this.vpComputer = new HealpixNestedVerticesAndPathComputer(this);
        }
        this.vpComputer.pathAlongCellEdge(hash, startingVertex, clockwiseDirection, nSegmentsBySide, pathPoints);
    }

    public NeighbourSelector newNeighbourSelector() {
        return this.neigSelector;
    }

    @Override
    public long neighbour(long hash, CompassPoint.MainWind direction) {
        return this.neigSelector.neighbour(hash, direction);
    }

    @Override
    public NeighbourList neighbours(long hash) {
        return this.neigSelector.neighbours(hash);
    }

    @Override
    public void neighbours(long hash, NeighbourList result) {
        this.neigSelector.neighbours(hash, result);
    }

    @Override
    public void neighbours(long hash, FlatHashList result) {
        this.neigSelector.neighbours(hash, result);
    }

    @Override
    public NeighbourList neighbours(long hash, EnumSet<CompassPoint.MainWind> directions) {
        return this.neigSelector.neighbours(hash, directions);
    }

    @Override
    public void neighbours(long hash, EnumSet<CompassPoint.MainWind> directions, NeighbourList result) {
        this.neigSelector.neighbours(hash, directions, result);
    }

    @Override
    public FlatHashList internalEdges(long hash, int deltaDepth) {
        return this.neigSelector.internalEdges(hash, deltaDepth);
    }

    @Override
    public void internalEdges(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.internalEdges(hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdges(long hash, int deltaDepth) {
        return this.neigSelector.sortedInternalEdges(hash, deltaDepth);
    }

    @Override
    public void sortedInternalEdges(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.sortedInternalEdges(hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdge(long hash, int deltaDepth, CompassPoint.Ordinal direction) {
        return this.neigSelector.sortedInternalEdge(hash, deltaDepth, direction);
    }

    @Override
    public void sortedInternalEdge(long hash, int deltaDepth, CompassPoint.Ordinal direction, FlatHashList result) {
        this.neigSelector.sortedInternalEdge(hash, deltaDepth, direction, result);
    }

    @Override
    public FlatHashList sortedInternalEdgeNE(long hash, int deltaDepth) {
        return this.neigSelector.sortedInternalEdgeNE(hash, deltaDepth);
    }

    @Override
    public void sortedInternalEdgeNE(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.sortedInternalEdgeNE(hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdgeNW(long hash, int deltaDepth) {
        return this.neigSelector.sortedInternalEdgeNW(hash, deltaDepth);
    }

    @Override
    public void sortedInternalEdgeNW(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.sortedInternalEdgeNW(hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdgeSE(long hash, int deltaDepth) {
        return this.neigSelector.sortedInternalEdgeSE(hash, deltaDepth);
    }

    @Override
    public void sortedInternalEdgeSE(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.sortedInternalEdgeSE(hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdgeSW(long hash, int deltaDepth) {
        return this.neigSelector.sortedInternalEdgeSW(hash, deltaDepth);
    }

    @Override
    public void sortedInternalEdgeSW(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.sortedInternalEdgeSW(hash, deltaDepth, result);
    }

    @Override
    public long internalCorner(long hash, int deltaDepth, CompassPoint.Cardinal direction) {
        return this.neigSelector.internalCorner(hash, deltaDepth, direction);
    }

    @Override
    public long internalCornerN(long hash, int deltaDepth) {
        return this.neigSelector.internalCornerN(hash, deltaDepth);
    }

    @Override
    public long internalCornerS(long hash, int deltaDepth) {
        return this.neigSelector.internalCornerS(hash, deltaDepth);
    }

    @Override
    public long internalCornerE(long hash, int deltaDepth) {
        return this.neigSelector.internalCornerE(hash, deltaDepth);
    }

    @Override
    public long internalCornerW(long hash, int deltaDepth) {
        return this.neigSelector.internalCornerW(hash, deltaDepth);
    }

    @Override
    public FlatHashList externalEdges(long hash, int deltaDepth) {
        return this.neigSelector.externalEdges(hash, deltaDepth);
    }

    @Override
    public void externalEdges(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.externalEdges(hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedExternalEdges(long hash, int deltaDepth) {
        return this.neigSelector.sortedExternalEdges(hash, deltaDepth);
    }

    @Override
    public void sortedExternalEdges(long hash, int deltaDepth, FlatHashList result) {
        this.neigSelector.sortedExternalEdges(hash, deltaDepth, result);
    }

    public HealpixNestedFixedRadiusConeComputer newConeComputer(double coneRadiusRad) {
        if (coneRadiusRad >= Math.PI) {
            return new NestedAllSky(coneRadiusRad, this.depth);
        }
        int optimalStartingDepth = Healpix.getBestStartingDepth(coneRadiusRad);
        if (optimalStartingDepth == -1) {
            return new NestedSmallCellApproxedMethod(optimalStartingDepth, this.depth, coneRadiusRad);
        }
        if (this.depth <= optimalStartingDepth) {
            if (coneRadiusRad < 1.0E-6) {
                return new NestedLargeCellSmallRadius(this, coneRadiusRad);
            }
            return new NestedLargeCell(this, coneRadiusRad);
        }
        if (coneRadiusRad < 1.0E-6) {
            return new NestedSmallCell(optimalStartingDepth, this.depth, coneRadiusRad, SmallConeOrdinalHashComputer.UI);
        }
        return new NestedSmallCell(optimalStartingDepth, this.depth, coneRadiusRad, RegularConeOrdinalHashComputer.UI);
    }

    public HealpixNestedFixedRadiusConeComputer newConeComputerApprox(double coneRadiusRad) {
        if (coneRadiusRad >= Math.PI) {
            return new NestedAllSky(coneRadiusRad, this.depth);
        }
        int optimalStartingDepth = Healpix.getBestStartingDepth(coneRadiusRad);
        if (optimalStartingDepth >= this.depth) {
            return new NestedLargeCellApproxedMethod(optimalStartingDepth, this.depth, coneRadiusRad);
        }
        return new NestedSmallCellApproxedMethod(optimalStartingDepth, this.depth, coneRadiusRad);
    }

    public HealpixNestedFixedRadiusCone4XMatch newConeComputer4Xmatch(double coneRadiusRad) {
        return new HealpixNestedFixedRadiusCone4XMatch(this.depth, coneRadiusRad);
    }

    public HealpixNestedPolygonComputer newPolygonComputer() {
        return new HealpixNestedPolygonComputer(this);
    }

    public NestedEllipticalConeComputerApprox newEllipticalConeComputer(double aRad, double bRad, double paRad) {
        return new NestedEllipticalConeComputerApprox(aRad, bRad, paRad, this);
    }

    public long toRing(long nestedHash) {
        HashParts hparts = this.decodeRegularHash(nestedHash);
        return this.regularRingEncode(hparts.baseCellHash(), hparts.iInBaseCell(), hparts.jInBaseCell());
    }

    public long regularRingEncode(long baseCellHash, int iInBasePixel, int jInBasePixel) {
        long h = iInBasePixel + jInBasePixel;
        long l = iInBasePixel - jInBasePixel;
        long jBasePixel = this.dividedBy4Quotient(baseCellHash);
        assert (0L <= jBasePixel && jBasePixel <= 2L);
        long iRing = this.nsideTime(jBasePixel + 2L) - (h + 2L);
        assert (0L <= iRing && iRing < (long)Healpix.nIsolatitudeRings(this.depth));
        long firstIsolatIndex = 0L;
        long iInRing = this.dividedBy2Quotient(l);
        if (iRing < (long)this.nside) {
            long ip1 = iRing + 1L;
            firstIsolatIndex = iRing * ip1 << 1;
            iInRing += this.dividedBy2Quotient(ip1);
            iInRing += ip1 * this.modulo4(baseCellHash);
        } else if (iRing >= (long)(this.nsideTime(3) - 1)) {
            long ip1 = h + 1L;
            firstIsolatIndex = this.nHash - this.twiceValTimeValPlusOne(ip1);
            iInRing += this.dividedBy2Quotient(ip1);
            iInRing += ip1 * this.modulo4(baseCellHash);
        } else {
            firstIsolatIndex = this.twiceNsideTimeNsidePlusOne() + this.minusNsideTimeFourNside(iRing);
            iInRing += this.nsideTime(this.modulo2(jBasePixel + 1L)) >> 1;
            iInRing += this.nsideTime(baseCellHash == 4L && l < 0L ? 4L : this.modulo4(baseCellHash));
        }
        return firstIsolatIndex + iInRing;
    }

    public long toNested(long ringHash) {
        HashParts hparts = this.decodeRegularRing(ringHash);
        return this.encodeRegularHash(hparts.baseCellHash(), hparts.iInBaseCell(), hparts.jInBaseCell());
    }

    HashParts decodeRegularRing(long hash) {
        long jInBaseCell;
        long iInBaseCell;
        int baseCellHash;
        long firstHashInEquatorialRegion = this.twiceNsideTimeNsidePlusOne();
        long firstHashInSouthPolarCap = this.nHash - firstHashInEquatorialRegion;
        long iRing = 0L;
        long iInRing = 0L;
        if (hash < firstHashInEquatorialRegion) {
            iRing = (long)Math.sqrt(1L + (hash << 1)) - 1L >>> 1;
            long nInRing = iRing + 1L;
            iInRing = hash - this.twiceValTimeValPlusOne(iRing);
            baseCellHash = (int)(iInRing / nInRing);
            long h = (long)((this.nside << 1) - 2) - iRing;
            long l = (iInRing - nInRing * (long)baseCellHash << 1) - iRing;
            iInBaseCell = h + l >>> 1;
            jInBaseCell = h - l >>> 1;
        } else if (hash >= firstHashInSouthPolarCap) {
            hash = this.nHash - 1L - hash;
            iRing = (long)Math.sqrt(1L + (hash << 1)) - 1L >> 1;
            long nInRing = iRing + 1L;
            iInRing = (nInRing << 2) - 1L - (hash - this.twiceValTimeValPlusOne(iRing));
            baseCellHash = (int)(iInRing / nInRing);
            long h = iRing;
            long l = (iInRing - nInRing * (long)baseCellHash << 1) - iRing;
            baseCellHash += 8;
            iInBaseCell = h + l >>> 1;
            jInBaseCell = h - l >>> 1;
        } else {
            iInRing = iRing = hash - firstHashInEquatorialRegion;
            long l = ((iInRing -= (iRing >>= this.depth + 2) << this.depth + 2) << 1) + this.modulo2(iRing);
            long h = (long)((this.nside << 1) - 2) - iRing;
            iInBaseCell = h + l >>> 1;
            jInBaseCell = h - l >>> 1;
            int iBaseCell = this.dividedByNsideQuotient(iInBaseCell);
            int jBaseCell = this.dividedByNsideQuotient(jInBaseCell += (long)(this.nside << 2));
            baseCellHash = HealpixNested.getBaseCellHash(iBaseCell, jBaseCell);
            iInBaseCell = this.moduloNside(iInBaseCell);
            jInBaseCell = this.moduloNside(jInBaseCell);
        }
        return new HashPartsImpl(baseCellHash, (int)iInBaseCell, (int)jInBaseCell);
    }

    private static int getBaseCellHash(int i, int j) {
        j = 4 - (j + i);
        return (i - (j >>> 63) & 3) + (++j << 2);
    }

    private long minusNsideTimeFourNside(long l) {
        return l - (long)this.nside << this.depth + 2;
    }

    private long twiceValTimeValPlusOne(long val) {
        return val * (val + 1L) << 1;
    }

    private long twiceNsideTimeNsidePlusOne() {
        return (1L << (this.depth << 1)) + (long)this.nside << 1;
    }

    double timeHalfNside(double v) {
        return HackersDelight.fromBits(HackersDelight.toBits(v) + this.halfNside4IEEEdouble);
    }

    int nsideTime(int i) {
        return i << this.depth;
    }

    long nsideTime(long i) {
        return i << this.depth;
    }

    private long dividedBy2Quotient(long d) {
        return d >> 1;
    }

    public long dividedBy4Quotient(long d) {
        return d >> 2;
    }

    private int dividedByNsideQuotient(int d) {
        return d >> this.depth;
    }

    int dividedByNsideQuotient(long d) {
        return (int)(d >> this.depth);
    }

    private int dividedByNsideRemainder(int d) {
        assert ((d & this.nsideRemainderMask) == d % this.nside);
        return d & this.nsideRemainderMask;
    }

    long modulo2(long d) {
        return d & 1L;
    }

    long modulo4(long d) {
        return d & 3L;
    }

    int moduloNside(int d) {
        return d & this.nsideRemainderMask;
    }

    int moduloNside(long d) {
        return (int)d & this.nsideRemainderMask;
    }

    static boolean isInEquatorialRegion(int basePixel) {
        assert (0 <= basePixel && basePixel < 12);
        return (basePixel | 4) == 4;
    }

    static boolean isInNorhtPolarCapRegion(int basePixel) {
        assert (0 <= basePixel && basePixel < 12);
        return (basePixel | 0xC) == 0;
    }

    static boolean isInSouthPolarCapRegion(int basePixel) {
        assert (0 <= basePixel && basePixel < 12);
        return (basePixel | 8) == 8;
    }

    long encodeRegularHash(long basePixel, int iInBasePixel, int jInBasePixel) {
        return basePixel << this.twiceDepth | this.fc.ij2hash(iInBasePixel, jInBasePixel);
    }

    static long bits2hash(long basePixelBits, long iInBasePixelBits, long jInBasePixelBits) {
        return basePixelBits | iInBasePixelBits | jInBasePixelBits;
    }

    HashParts decodeRegularHash(long hash) {
        int d0h = (int)(hash >> this.twiceDepth);
        hash = this.fc.hash2ij(hash & this.xyMask);
        return new HashPartsImpl(d0h, this.fc.ij2i(hash), this.fc.ij2j(hash));
    }

    void decodeRegularHash(long hash, SettableHashParts result) {
        result.setBaseCellHash((int)(hash >> this.twiceDepth));
        hash = this.fc.hash2ij(hash & this.xyMask);
        result.setIInBaseCell(this.fc.ij2i(hash));
        result.setJInBaseCell(this.fc.ij2j(hash));
    }

    HashBits pullBitsApart(long hash) {
        return new HashBits(hash & this.d0Mask, hash & this.xMask, hash & this.yMask);
    }
}

