/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.MyInputStream;
import cds.fits.HeaderFits;
import cds.image.Hdecomp;
import cds.tools.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;

public class UtilFits {
    static final int NOCOMPRESS = 0;
    static final int RICE1 = 1;
    static final int RICEONE = 2;
    static final int GZIP1 = 3;
    static final int GZIP2 = 4;
    static final int HCOMPRESS1 = 5;
    static final int PLIO1 = 6;
    static final String[] ZCMPTYPE = new String[]{"NOCOMPRESS", "RICE_1", "RICE_ONE", "GZIP_1", "GZIP_2", "HCOMPRESS_1", "PLIO_1"};
    private static String[] KEYIGNORE = new String[]{"TFIELDS", "TFIELDS", "TTYPE1", "TFORM1", "ZIMAGE", "ZTILE1", "ZTILE2", "ZTILE3", "ZCMPTYPE", "ZNAME1", "ZVAL1", "ZNAME2", "ZVAL2", "ZSIMPLE", "ZBITPIX", "ZNAXIS", "ZNAXIS1", "ZNAXIS2", "ZNAXIS3", "ZEXTEND", "ZPCOUNT", "ZGCOUNT", "ZTENSION", "ZDATASUM", "ZBLANK", "ZDITHER0", "ZQUANTIZ", "NAXIS1", "NAXIS2", "TTYPE1", "TTYPE2", "TTYPE3", "TFORM1", "TFORM2", "TFORM3", "EXTNAME"};
    private static String[] KEYIGNORELUPTON = new String[]{"BZERO", "BSCALE", "BLANK", "BOFFSET", "BSOFTEN"};
    static final int NO_DITHER = 0;
    static final int SUBTRACTIVE_DITHER_1 = 1;
    static final int SUBTRACTIVE_DITHER_2 = 2;
    static final int DITHER_BLANK = -2147483646;
    static final double ALPHA = 2.5 / Math.log(10.0);
    private static final long MASK = 0xFFFFFFFFL;
    private static final int[] nonzero_count = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static double DITHEROFF = 500.0;
    static final int N_RANDOM = 10000;
    static float[] RN = null;

    public static byte[] uncompress(HeaderFits headerFits, MyInputStream dis) throws Exception {
        return UtilFits.uncompress(null, headerFits, dis, false);
    }

    public static byte[] uncompress(HeaderFits outHeader, HeaderFits inHeader, MyInputStream dis, boolean flagSkip) throws Exception {
        int n;
        int bitpix;
        double zblank = Double.NaN;
        if (inHeader == null) {
            inHeader = new HeaderFits(dis);
        } else if (inHeader.isEmpty()) {
            inHeader.readHeader(dis);
        }
        int nnaxis1 = inHeader.getIntFromHeader("NAXIS1");
        int nnaxis2 = inHeader.getIntFromHeader("NAXIS2");
        int theap = nnaxis1 * nnaxis2;
        try {
            theap = inHeader.getIntFromHeader("THEAP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int pcount = inHeader.getIntFromHeader("PCOUNT");
        if (flagSkip) {
            dis.skip(theap + pcount);
            return new byte[0];
        }
        try {
            bitpix = inHeader.getIntFromHeader("ZBITPIX");
        }
        catch (Exception e) {
            System.err.println("Not a compressed image in this HDU => return as is");
            if (outHeader != null) {
                inHeader.copyTo(outHeader);
            }
            byte[] buf = new byte[theap + pcount];
            dis.readFully(buf);
            return buf;
        }
        int naxis = 2;
        try {
            naxis = inHeader.getIntFromHeader("ZNAXIS");
        }
        catch (Exception e) {
            // empty catch block
        }
        int naxis1 = inHeader.getIntFromHeader("ZNAXIS1");
        int naxis2 = inHeader.getIntFromHeader("ZNAXIS2");
        int naxis3 = 1;
        if (naxis > 2) {
            try {
                naxis3 = inHeader.getIntFromHeader("ZNAXIS3");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int npix = n = Math.abs(bitpix) / 8;
        int taille = naxis1 * naxis2 * naxis3 * n;
        try {
            zblank = inHeader.getDoubleFromHeader("ZBLANK");
        }
        catch (Exception e) {
            // empty catch block
        }
        String sCmp = inHeader.getStringFromHeader("ZCMPTYPE");
        int nCmp = Util.indexInArrayOf(sCmp, ZCMPTYPE);
        if (nCmp < 0) {
            throw new Exception("Unknown FITS compression method [" + sCmp + "]");
        }
        if (nCmp == 6) {
            throw new Exception("Unsupported FITS compression method [" + sCmp + "]");
        }
        if (nCmp == 5) {
            throw new Exception("Unsupported FITS compression method [" + sCmp + "]");
        }
        int tile1 = naxis1;
        try {
            tile1 = inHeader.getIntFromHeader("ZTILE1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int tile2 = 1;
        try {
            tile2 = inHeader.getIntFromHeader("ZTILE2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int tile3 = 1;
        if (naxis3 > 1) {
            try {
                tile3 = inHeader.getIntFromHeader("ZTILE3");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tile3 != 1) {
                throw new Exception("Compressed cube FITS using ZTILE3!=1 (" + tile3 + ") not yet supporte!");
            }
        }
        int val1 = 32;
        try {
            val1 = inHeader.getIntFromHeader("ZVAL1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int val2 = 4;
        try {
            val2 = inHeader.getIntFromHeader("ZVAL2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int zdither0 = 1;
        int zquantiz = 0;
        String quantiz = inHeader.getStringFromHeader("ZQUANTIZ");
        if (quantiz != null) {
            if ("SUBTRACTIVE_DITHER_1".equals(quantiz)) {
                zquantiz = 1;
            } else if ("SUBTRACTIVE_DITHER_2".equals(quantiz)) {
                zquantiz = 2;
            } else if ("NO_DITHER".equals(quantiz)) {
                zquantiz = 0;
            } else {
                System.err.println(sCmp + " FITS image problem (unsupported ZQUANTIZ [" + quantiz + "] => assuming NO_DITHER)");
            }
            if (zquantiz != 0) {
                try {
                    zdither0 = inHeader.getIntFromHeader("ZDITHER0");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UtilFits.randomGenerator();
            }
        }
        int posCompress = 0;
        int posgzipCompress = -1;
        int posUncompress = -1;
        int posZscale = -1;
        int posZzero = -1;
        int sForm = 32;
        int tfields = inHeader.getIntFromHeader("TFIELDS");
        int pos = 0;
        for (int i = 1; i <= tfields; ++i) {
            String type = inHeader.getStringFromHeader("TTYPE" + i);
            if (type.equals("COMPRESSED_DATA")) {
                posCompress = pos;
                sForm = 66;
            } else if (type.equals("GZIP_COMPRESSED_DATA")) {
                posgzipCompress = pos;
                sForm = 66;
            } else if (type.equals("UNCOMPRESSED_DATA")) {
                posUncompress = pos;
                sForm = 66;
            } else if (type.equals("ZSCALE")) {
                posZscale = pos;
                sForm = 68;
            } else if (type.equals("ZZERO")) {
                posZzero = pos;
                sForm = 68;
            }
            String form = inHeader.getStringFromHeader("TFORM" + i);
            pos += Util.binSizeOf(form);
        }
        if (posUncompress >= 0) {
            System.err.println(sCmp + " FITS image warning (deprecated UNCOMPRESSED_DATA field)");
        }
        byte[] pixelsOrigin = new byte[taille];
        byte[] table = new byte[nnaxis1 * nnaxis2];
        byte[] heap = new byte[pcount];
        try {
            dis.readFully(table);
            dis.skip(theap - nnaxis1 * nnaxis2);
            dis.readFully(heap);
            int nbTileInWidth = naxis1 / tile1;
            if (naxis1 % tile1 != 0) {
                ++nbTileInWidth;
            }
            int pixPos = 0;
            for (int numTile = 0; numTile < nnaxis2; ++numTile) {
                int offsetRec = numTile * nnaxis1;
                int size = UtilFits.getInt(table, offsetRec + posCompress);
                int pos2 = UtilFits.getInt(table, offsetRec + posCompress + 4);
                double bzero = posZzero < 0 ? 0.0 : UtilFits.getDouble(table, offsetRec + posZzero);
                double bscale = posZscale < 0 ? 1.0 : UtilFits.getDouble(table, offsetRec + posZscale);
                int nbRowOfTiles = numTile / nbTileInWidth;
                int nbTileInCurrentRow = numTile % nbTileInWidth;
                pixPos = nbRowOfTiles * tile2 * naxis1 + nbTileInCurrentRow * tile1;
                if (size == 0 && posgzipCompress >= 0) {
                    size = UtilFits.getInt(table, offsetRec + posgzipCompress);
                    pos2 = UtilFits.getInt(table, offsetRec + posgzipCompress + 4);
                    byte[] tile = UtilFits.gunzip(heap, pos2, size);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (size == 0 && posUncompress >= 0) {
                    size = UtilFits.getInt(table, offsetRec + posUncompress);
                    pos2 = UtilFits.getInt(table, offsetRec + posUncompress + 4);
                    byte[] tile = new byte[size];
                    System.arraycopy(heap, pos2, tile, 0, size);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 1 || nCmp == 2) {
                    int tileBitpix = 32;
                    byte[] tile = new byte[tile1 * tile2 * Math.abs(tileBitpix) / 8];
                    UtilFits.decompRice(heap, pos2, tile, 0, tile1 * tile2, val1, val2, tileBitpix);
                    UtilFits.unQuantiz(tile, tileBitpix, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, zblank, bzero, bscale, zquantiz, zdither0, numTile);
                    continue;
                }
                if (nCmp == 3) {
                    byte[] tile = UtilFits.decompGzip1(heap, pos2, size);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 4) {
                    byte[] tile = UtilFits.decompGzip2(heap, pos2, size, bitpix);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 5) {
                    byte[] tile = UtilFits.decompHcomp(heap, pos2, size, bitpix);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp != 0) continue;
                byte[] tile = new byte[tile1 * tile2 * npix];
                System.arraycopy(heap, pos2, tile, 0, tile.length);
                UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean flagLupton = false;
        if (inHeader.getStringFromHeader("BSOFTEN") != null) {
            try {
                double boffset = inHeader.getDoubleFromHeader("BOFFSET");
                double bsoften = inHeader.getDoubleFromHeader("BSOFTEN");
                double bzero = 0.0;
                double bscale = 1.0;
                double blank2 = Double.NaN;
                try {
                    bzero = inHeader.getDoubleFromHeader("BZERO");
                }
                catch (Exception nbTileInCurrentRow) {
                    // empty catch block
                }
                try {
                    bscale = inHeader.getDoubleFromHeader("BSCALE");
                }
                catch (Exception nbTileInCurrentRow) {
                    // empty catch block
                }
                try {
                    blank2 = inHeader.getDoubleFromHeader("BLANK");
                }
                catch (Exception nbTileInCurrentRow) {
                    // empty catch block
                }
                int bitpix2 = -32;
                int npix2 = Math.abs(bitpix2) / 8;
                int taille2 = naxis1 * naxis2 * npix2;
                byte[] pix2 = taille == taille2 ? pixelsOrigin : new byte[taille2];
                for (int y = 0; y < naxis2; ++y) {
                    for (int x = 0; x < naxis1; ++x) {
                        int pos3 = y * naxis1 + x;
                        double val = UtilFits.getPixVal1(pixelsOrigin, bitpix, pos3);
                        val = Double.isNaN(val) || val == blank2 ? Double.NaN : UtilFits.uncompressLupton(val, bzero, bscale, bsoften, boffset);
                        UtilFits.setPixVal(pix2, bitpix2, pos3, val);
                    }
                }
                pixelsOrigin = pix2;
                bitpix = bitpix2;
                flagLupton = true;
            }
            catch (Exception e) {
                throw new Exception("Lupton uncompress error");
            }
        }
        if (outHeader != null) {
            Hashtable<String, String> map = inHeader.getHashHeader();
            Enumeration<String> e = inHeader.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (Util.indexInArrayOf(key, KEYIGNORE) >= 0 || flagLupton && Util.indexInArrayOf(key, KEYIGNORELUPTON) >= 0) continue;
                if (key.equals("NAXIS")) {
                    outHeader.setKeyValue("NAXIS", naxis + "");
                    outHeader.setKeyValue("NAXIS1", naxis1 + "");
                    outHeader.setKeyValue("NAXIS2", naxis2 + "");
                    if (naxis <= 2) continue;
                    outHeader.setKeyValue("NAXIS3", naxis3 + "");
                    continue;
                }
                String val = key.equals("XTENSION") ? "IMAGE" : (key.equals("BITPIX") ? bitpix + "" : (key.equals("PCOUNT") ? "0" : (key.equals("GCOUNT") ? "1" : map.get(key))));
                outHeader.setKeyValue(key, val);
            }
        }
        return pixelsOrigin;
    }

    public static double uncompressLupton(double pixComp, double bzero, double bscale, double bsoften, double boffset) {
        pixComp = bzero + bscale * pixComp;
        double ca = pixComp / ALPHA;
        return boffset + bsoften * (Math.exp(ca) - Math.exp(-ca));
    }

    private static byte[] decompGzip1(byte[] buf, int pos, int size) throws Exception {
        return UtilFits.gunzip(buf, pos, size);
    }

    private static byte[] decompGzip2(byte[] buf, int pos, int size, int bitpix) throws Exception {
        byte[] b = UtilFits.gunzip(buf, pos, size);
        int nbyte = Math.abs(bitpix) / 8;
        int n = b.length / nbyte;
        byte[] c = new byte[b.length];
        int k = 0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < nbyte; ++i) {
                c[k++] = b[i * n + j];
            }
        }
        return c;
    }

    private static byte[] decompHcomp(byte[] buf, int pos, int size, int bitpix) throws Exception {
        ByteArrayInputStream bytein = new ByteArrayInputStream(buf, pos, size);
        return Hdecomp.decomp(bytein);
    }

    public static byte[] gunzip(byte[] buf, int pos, int size) throws Exception {
        ByteArrayInputStream bytein = new ByteArrayInputStream(buf, pos, size);
        GZIPInputStream gzin = new GZIPInputStream(bytein);
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        int res = 0;
        byte[] tmp = new byte[1024];
        while (res >= 0) {
            res = gzin.read(tmp, 0, tmp.length);
            if (res <= 0) continue;
            byteout.write(tmp, 0, res);
        }
        return byteout.toByteArray();
    }

    public static void decompRice(byte[] buf, int pos, byte[] array, int offset, int tileSize, int nblock, int bsize, int bitpix) throws Exception {
        int i;
        int fsmax;
        int fsbits;
        switch (bsize) {
            case 1: {
                fsbits = 3;
                fsmax = 6;
                break;
            }
            case 2: {
                fsbits = 4;
                fsmax = 14;
                break;
            }
            case 4: {
                fsbits = 5;
                fsmax = 25;
                break;
            }
            default: {
                throw new Exception("RICE FITS decompRice error: bitpix must be 8, 16 or 32");
            }
        }
        int bbits = 1 << fsbits;
        int lastpix = 0;
        for (i = 0; i < bsize; ++i) {
            int bytevalue = 0xFF & buf[pos++];
            lastpix = lastpix << 8 | bytevalue;
        }
        int b = 0xFF & buf[pos++];
        int nbits = 8;
        i = 0;
        while (i < tileSize) {
            int diff;
            nbits -= fsbits;
            while (nbits < 0) {
                b = b << 8 | 0xFF & buf[pos++];
                nbits += 8;
            }
            int fs = (b >>> nbits) - 1;
            b &= (1 << nbits) - 1;
            int imax = i + nblock;
            if (imax > tileSize) {
                imax = tileSize;
            }
            if (fs < 0) {
                while (i < imax) {
                    UtilFits.setPixVal(array, bitpix, i + offset, lastpix);
                    ++i;
                }
                continue;
            }
            if (fs == fsmax) {
                while (i < imax) {
                    int k = bbits - nbits;
                    diff = b << k;
                    k -= 8;
                    while (k >= 0) {
                        b = 0xFF & buf[pos++];
                        diff |= b << k;
                        k -= 8;
                    }
                    if (nbits > 0) {
                        b = 0xFF & buf[pos++];
                        diff |= b >>> -k;
                        b &= (1 << nbits) - 1;
                    } else {
                        b = 0;
                    }
                    diff = (diff & 1) == 0 ? (diff >>>= 1) : ~(diff >>> 1);
                    lastpix = diff + lastpix;
                    UtilFits.setPixVal(array, bitpix, i + offset, lastpix);
                    ++i;
                }
                continue;
            }
            while (i < imax) {
                while (b == 0) {
                    nbits += 8;
                    b = 0xFF & buf[pos++];
                }
                int nzero = nbits - nonzero_count[b];
                b ^= 1 << (nbits -= nzero + 1);
                nbits -= fs;
                while (nbits < 0) {
                    b = b << 8 | 0xFF & buf[pos++];
                    nbits += 8;
                }
                diff = nzero << fs | b >>> nbits;
                b &= (1 << nbits) - 1;
                diff = (diff & 1) == 0 ? (diff >>>= 1) : ~(diff >>> 1);
                lastpix = diff + lastpix;
                UtilFits.setPixVal(array, bitpix, i + offset, lastpix);
                ++i;
            }
        }
    }

    private static void unQuantiz(byte[] tile, int tileBitpix, int tileWidth, int tileHeight, byte[] out, int outPos, int outWidth, int outHeight, int bitpixOut, double zblank, double bzero, double bscale, int zquantiz, int zdither0, int row) throws Exception {
        int i0 = 0;
        int i1 = 0;
        if (zquantiz != 0) {
            i0 = (row - 1 + zdither0) % 10000;
            i1 = (int)((double)RN[i0] * DITHEROFF);
        }
        for (int y = 0; y < tileHeight; ++y) {
            for (int x = 0; x < tileWidth; ++x) {
                double pix;
                int val = UtilFits.getPixValAsInt(tile, tileBitpix, y * tileWidth + x);
                if (zquantiz != 0) {
                    double r = RN[i1];
                    if ((double)i1 >= DITHEROFF) {
                        if (++i0 == 10000) {
                            i0 = 0;
                        }
                        i1 = (int)((double)RN[i0] * DITHEROFF);
                    }
                    if ((double)(++i1) >= DITHEROFF) {
                        if (++i0 == 10000) {
                            i0 = 0;
                        }
                        i1 = (int)((double)RN[i0] * DITHEROFF);
                    }
                    pix = zquantiz == 2 && val == -2147483646 ? 0.0 : ((double)val == zblank ? Double.NaN : ((double)val - r + 0.5) * bscale + bzero);
                } else {
                    pix = (double)val * bscale + bzero;
                }
                UtilFits.setPixVal(out, bitpixOut, outPos + y * outWidth + x, pix);
            }
        }
    }

    private static void copyTile(byte[] tile, int tileWidth, int tileHeight, byte[] pix, int pixPos, int width, int height, int bitpix, double bzero, double bscale) throws Exception {
        boolean flagScale;
        boolean bl = flagScale = bscale != 1.0 || bzero != 0.0;
        if (!flagScale) {
            int npix = Math.abs(bitpix) / 8;
            if (tileWidth == width) {
                System.arraycopy(tile, 0, pix, pixPos * npix, tileWidth * tileHeight * npix);
                return;
            }
            for (int y = 0; y < tileHeight; ++y) {
                int src = y * tileWidth;
                int trg = (pixPos + y * width) * npix;
                System.arraycopy(tile, src, pix, trg, tileWidth * npix);
            }
            return;
        }
        for (int y = 0; y < tileHeight; ++y) {
            for (int x = 0; x < tileWidth; ++x) {
                double val = UtilFits.getPixVal1(tile, bitpix, y * tileWidth + x);
                val = val * bscale + bzero;
                UtilFits.setPixVal(pix, bitpix, pixPos + y * width + x, val);
            }
        }
    }

    private static void randomGenerator() {
        if (RN != null) {
            return;
        }
        RN = new float[10000];
        double a = 16807.0;
        double m = 2.147483647E9;
        double seed = 1.0;
        for (int ii = 0; ii < 10000; ++ii) {
            double temp = a * seed;
            seed = temp - m * (double)((int)(temp / m));
            UtilFits.RN[ii] = (float)(seed / m);
        }
    }

    public static final int getByte(byte[] t, int i) {
        return t[i] & 0xFF;
    }

    public static final int getShort(byte[] t, int i) {
        return t[i] << 8 | t[i + 1] & 0xFF;
    }

    public static final int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    public static final long getLong(byte[] t, int i) {
        return (long)(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final double getFloat(byte[] t, int i) {
        return Float.intBitsToFloat(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF);
    }

    public static final double getDouble(byte[] t, int i) {
        long a = (long)(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL;
        return Double.longBitsToDouble(a);
    }

    public static final double getPixVal1(byte[] t, int bitpix, int i) {
        try {
            switch (bitpix) {
                case 8: {
                    return UtilFits.getByte(t, i);
                }
                case 16: {
                    return UtilFits.getShort(t, i * 2);
                }
                case 32: {
                    return UtilFits.getInt(t, i * 4);
                }
                case 64: {
                    return UtilFits.getLong(t, i * 8);
                }
                case -32: {
                    return UtilFits.getFloat(t, i * 4);
                }
                case -64: {
                    return UtilFits.getDouble(t, i * 8);
                }
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static final int getPixValAsInt(byte[] t, int bitpix, int i) {
        try {
            switch (bitpix) {
                case 8: {
                    return UtilFits.getByte(t, i);
                }
                case 16: {
                    return UtilFits.getShort(t, i * 2);
                }
                case 32: {
                    return UtilFits.getInt(t, i * 4);
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static final void setInt(byte[] t, int i, int val) {
        t[i] = (byte)(0xFF & val >>> 24);
        t[i + 1] = (byte)(0xFF & val >>> 16);
        t[i + 2] = (byte)(0xFF & val >>> 8);
        t[i + 3] = (byte)(0xFF & val);
    }

    public static final void setPixVal(byte[] t, int bitpix, int i, double val) {
        switch (bitpix) {
            case 8: {
                t[i] = (byte)(0xFF & (int)val);
                break;
            }
            case 16: {
                int c = (int)val;
                t[i *= 2] = (byte)(0xFF & c >>> 8);
                t[i + 1] = (byte)(0xFF & c);
                break;
            }
            case 32: {
                UtilFits.setInt(t, i *= 4, (int)val);
                break;
            }
            case 64: {
                long c1 = (long)val;
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                UtilFits.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                UtilFits.setInt(t, i + 4, c);
                break;
            }
            case -32: {
                int c = Float.floatToIntBits((float)val);
                UtilFits.setInt(t, i *= 4, c);
                break;
            }
            case -64: {
                long c1 = Double.doubleToLongBits(val);
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                UtilFits.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                UtilFits.setInt(t, i + 4, c);
            }
        }
    }
}

