/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

public class Chomp {
    static byte[] MC = new byte[]{67, 72, 70, 49};
    static final int BLOC = 2880;
    static final int LINE = 80;
    static final int BLANK = 0;
    static final int DATA = 1;

    public static boolean isChomped(byte[] buf) {
        return buf.length >= 4 && buf[0] == MC[0] && buf[1] == MC[1] && buf[2] == MC[2] && buf[3] == MC[3];
    }

    private static int nextBloc(int x) {
        return (x / 2880 + (x % 2880 == 0 ? 0 : 1)) * 2880;
    }

    public static byte[] chomp(byte[] buf) throws Exception {
        int bitpix = Integer.parseInt(Chomp.fitsKey(buf, "BITPIX"));
        int nbyte = Math.abs(bitpix) / 8;
        short width = (short)Double.parseDouble(Chomp.fitsKey(buf, "NAXIS1"));
        short height = (short)Double.parseDouble(Chomp.fitsKey(buf, "NAXIS2"));
        String s = Chomp.fitsKey(buf, "NAXIS3");
        int depth = (short)(s == null ? 1 : (short)Double.parseDouble(s));
        int size = width * height * depth;
        s = Chomp.fitsKey(buf, "BLANK");
        double blank = s == null ? Double.NaN : Double.parseDouble(s);
        byte[] tmp = new byte[buf.length];
        int off = 0;
        tmp[off++] = MC[0];
        tmp[off++] = MC[1];
        tmp[off++] = MC[2];
        tmp[off++] = MC[3];
        int init = Chomp.fitsHeadSize(buf);
        tmp[off++] = (byte)(init >> 8 & 0xFF);
        tmp[off++] = (byte)(init & 0xFF);
        System.arraycopy(buf, 0, tmp, off, init);
        off += init;
        init = Chomp.nextBloc(init);
        int mode = 0;
        int omode = 0;
        int[] cpt = new int[2];
        for (int pos = 0; pos <= size; ++pos) {
            if (pos < size) {
                double pix = Chomp.getPix(buf, bitpix, init + nbyte * pos);
                if (!Double.isNaN(pix) && pix == blank) {
                    pix = Double.NaN;
                }
                int n = mode = Double.isNaN(pix) ? 0 : 1;
            }
            if (pos == size || mode == 0 && omode == 1) {
                int len = cpt[1] * nbyte;
                if (off + len + 8 > buf.length) {
                    return buf;
                }
                Chomp.setInt(tmp, off, cpt[0]);
                Chomp.setInt(tmp, off += 4, cpt[1]);
                System.arraycopy(buf, init + nbyte * (pos - cpt[1]), tmp, off += 4, len);
                off += len;
                cpt[1] = 0;
                cpt[0] = 0;
            }
            int n = mode;
            cpt[n] = cpt[n] + 1;
            omode = mode;
        }
        byte[] out = new byte[off];
        System.arraycopy(tmp, 0, out, 0, out.length);
        return out;
    }

    public static byte[] unchomp(byte[] in) throws Exception {
        if (!Chomp.isChomped(in)) {
            return in;
        }
        int offIn = MC.length;
        int headSize = Chomp.getShort(in, offIn);
        int headSizeBloc = Chomp.nextBloc(headSize);
        byte[] head = new byte[headSizeBloc];
        System.arraycopy(in, offIn += 2, head, 0, headSize);
        offIn += headSize;
        int bitpix = Integer.parseInt(Chomp.fitsKey(head, "BITPIX"));
        int nbyte = Math.abs(bitpix) / 8;
        short width = (short)Double.parseDouble(Chomp.fitsKey(head, "NAXIS1"));
        short height = (short)Double.parseDouble(Chomp.fitsKey(head, "NAXIS2"));
        String s = Chomp.fitsKey(head, "NAXIS3");
        int depth = (short)(s == null ? 1 : (short)Double.parseDouble(s));
        s = Chomp.fitsKey(head, "BLANK");
        double blank = s == null ? Double.NaN : Double.parseDouble(s);
        int imgSize = width * height * depth * nbyte;
        imgSize = Chomp.nextBloc(imgSize);
        byte[] out = new byte[head.length + imgSize];
        System.arraycopy(head, 0, out, 0, headSize);
        int offOut = headSizeBloc;
        while (offIn < in.length) {
            int nbBlanks = Chomp.getInt(in, offIn);
            int nbData = Chomp.getInt(in, offIn += 4);
            offIn += 4;
            for (int j = 0; j < nbBlanks; ++j) {
                Chomp.setPixValDouble(out, bitpix, offOut, blank);
                offOut += nbyte;
            }
            int len = nbData * nbyte;
            if (len <= 0) continue;
            System.arraycopy(in, offIn, out, offOut, len);
            offOut += len;
            offIn += len;
        }
        return out;
    }

    public static int getShort(byte[] t, int i) {
        return t[i] << 8 | t[i + 1] & 0xFF;
    }

    public static void setShort(byte[] t, int i, int val) {
        t[i] = (byte)(val >>> 8 & 0xFF);
        t[i + 1] = (byte)(val & 0xFF);
    }

    public static int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    public static void setInt(byte[] t, int i, int val) {
        t[i] = (byte)(0xFF & val >>> 24);
        t[i + 1] = (byte)(0xFF & val >>> 16);
        t[i + 2] = (byte)(0xFF & val >>> 8);
        t[i + 3] = (byte)(0xFF & val);
    }

    private static double getPix(byte[] t, int bitpix, int i) throws Exception {
        switch (bitpix) {
            case -32: {
                return Float.intBitsToFloat(Chomp.getInt(t, i));
            }
            case 16: {
                return t[i] << 8 | t[i + 1] & 0xFF;
            }
            case 32: {
                return Chomp.getInt(t, i);
            }
            case 8: {
                return t[i] & 0xFF;
            }
            case -64: {
                long a = (long)Chomp.getInt(t, i) << 32 | (long)Chomp.getInt(t, i + 4) & 0xFFFFFFFFL;
                return Double.longBitsToDouble(a);
            }
        }
        throw new Exception("Unknown bitpix");
    }

    private static void setPixValDouble(byte[] t, int bitpix, int i, double val) throws Exception {
        switch (bitpix) {
            case -32: {
                Chomp.setInt(t, i, Float.floatToIntBits((float)val));
                break;
            }
            case 16: {
                int c = (int)val;
                t[i] = (byte)(0xFF & c >> 8);
                t[i + 1] = (byte)(0xFF & c);
                break;
            }
            case 32: {
                Chomp.setInt(t, i, (int)val);
                break;
            }
            case 8: {
                t[i] = (byte)(0xFF & (int)val);
                break;
            }
            case -64: {
                long c1 = Double.doubleToLongBits(val);
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                Chomp.setInt(t, i, c);
                c = (int)(0xFFFFFFFFL & c1);
                Chomp.setInt(t, i + 4, c);
                break;
            }
            default: {
                throw new Exception("Unknown bitpix");
            }
        }
    }

    private static String fitsKey(byte[] buf, String key) {
        String k;
        String val = null;
        for (int offset = 0; offset <= buf.length && !(k = new String(buf, offset, 8).trim()).equals("END"); offset += 80) {
            int start;
            int stop;
            if (!key.equals(k)) continue;
            for (stop = start = offset + 9; stop < offset + 80 && buf[stop] != 47; ++stop) {
            }
            val = new String(buf, start, stop - start - 1).trim();
            if (val.length() <= 2 || val.charAt(0) != '\"' || val.charAt(val.length() - 1) != '\"') break;
            val = val.substring(1, val.length() - 1);
            break;
        }
        return val;
    }

    private static int fitsHeadSize(byte[] buf) throws Exception {
        for (int offset = 0; offset <= buf.length; offset += 80) {
            String k = new String(buf, offset, 8).trim();
            if (!k.equals("END")) continue;
            return offset + 3;
        }
        throw new Exception("END key not found");
    }
}

