/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrotime;
import cds.astro.Converter;
import cds.astro.Editing;
import cds.astro.Parsing;
import cds.astro.Udef;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Unit {
    public double value;
    public String symbol;
    private long mksa;
    protected double factor;
    protected double offset;
    static final char[] x = "0123456789abcdef".toCharArray();
    static boolean initialized = false;
    static boolean DEBUG = false;
    private static final byte _e0 = 48;
    private static final byte _m0 = 2;
    private static final long ___ = 0x230303030303030L;
    private static final long _LOG = -9151314442816847872L;
    private static final long _log = Long.MIN_VALUE;
    private static final long _mag = 0x100000000000000L;
    private static final long _MJD = 4769364993205350448L;
    private static final long _pic = 0x2000000000000000L;
    private static final long _sex = 0x1000000000000000L;
    private static final long _abs = 0x4000000000000000L;
    static final Editing editing = new Editing("-- ");
    private static Hashtable hUnit = new Hashtable(149);
    private static ArrayList aUnit = null;
    private static Hashtable hConv = new Hashtable(31);
    private static final String[] MKSA = new String[]{"mag", "kg", "m", "s", "A", "K", "cd", "mol"};
    private static final char[] MKSAdim = new char[]{'\u0000', 'M', 'L', 'T', 'A', 'K', '\u0000', '\u0000'};
    private static final String[] mul_symb = new String[]{"mu", "da", "k", "m", "c", "u", "M", "n", "G", "d", "h", "p", "T", "f", "P", "a", "E", "z", "Z", "y", "Y", "\u00b5"};
    private static final String[] mul_text = new String[]{"micro", "deca", "kilo", "milli", "centi", "micro", "mega", "nano", "giga", "deci", "hecto", "pico", "tera", "femto(10-15)", "peta(10+15)", "atto(10-18)", "exa(10+18)", "zepto(10-21)", "zetta(10+21)", "yocto(10-24)", "yotta(10+24)", "micro"};
    private static final int[] mul_fact = new int[]{-6, 1, 3, -3, -2, -6, 6, -9, 9, -1, 2, -12, 12, -15, 15, -18, 18, -21, 21, -24, 24, -6};
    private static final String[] op_symb = new String[]{"2", "3", "+", "-", "/", ".", "*", " "};
    private static final String[] op_text = new String[]{"square ", "cubic ", "power+", "power-", "per ", "times ", "times ", "times "};
    private static final String[] log_symb = new String[]{"log(", "log[", "[", "dex", "mag(", "mag["};
    private static final char[] log_end = new char[]{')', ']', ']', '\u0000', ')', ']'};
    private static final Udef[] uDef = new Udef[]{new Udef("---", "", 0x230303030303030L, 1.0), new Udef("%", "percent", 0x230303030303030L, 0.01), new Udef("h", "hour ", 157678974777962544L, 3600.0), new Udef("min", "minute ", 157678974777962544L, 60.0), new Udef("s", "second ", 157678974777962544L, 1.0), new Udef("mag", "magnitude ", 0x330303030303030L, 1.0), new Udef("Jy", "Jansky(10-26W/m2/Hz) ", 157960436869771312L, 1.0E-26), new Udef("deg", "degree ", 0x230303030303030L, 0.002777777777777778), new Udef("rad", "radian ", 0x230303030303030L, 0.15915494309189535), new Udef("sr", "steradian ", 0x230303030303030L, 0.07957747154594767), new Udef("arcmin", "minute of arc ", 0x230303030303030L, 4.6296296296296294E-5), new Udef("arcsec", "second of arc ", 0x230303030303030L, 7.71604938271605E-7), new Udef("mas", "milli-second of arc ", 0x230303030303030L, 7.716049382716049E-10), new Udef("uas", "micro-second of arc ", 0x230303030303030L, 7.71604938271605E-13), new Udef("Sun", "Solar unit ", 0x230303030303030L, 1.0), new Udef("Msun", "solar mass ", 157960445459705904L, 1.989E30), new Udef("solMass", "solar mass ", 157960445459705904L, 1.989E30), new Udef("Rsun", "solar radius ", 157680069994623024L, 6.9599E8), new Udef("solRad", "solar radius ", 157680069994623024L, 6.9599E8), new Udef("Lsun", "solar luminosity ", 157962631598059568L, 3.826E26), new Udef("solLum", "solar luminosity ", 157962631598059568L, 3.826E26), new Udef("Mgeo", "Earth mass ", 157960445459705904L, 5.976E24), new Udef("geoMass", "Earth mass ", 157960445459705904L, 5.976E24), new Udef("Mjup", "Jupiter mass ", 157960445459705904L, 1.902E27), new Udef("jovMass", "Jupiter mass ", 157960445459705904L, 1.902E27), new Udef("m", "metre ", 157680069994623024L, 1.0), new Udef("Hz", "Herz ", 157678966188027952L, 1.0), new Udef("kg", "kilogram ", 157960445459705904L, 1.0), new Udef("g", "gram ", 157960445459705904L, 0.001), new Udef("K", "Kelvin ", 157678970483060784L, 1.0), new Udef("Pa", "Pascal ", 157959337358143536L, 1.0), new Udef("T", "Tesla ", 157960436852994096L, 1.0), new Udef("V", "Volt ", 157962631581282352L, 1.0), new Udef("W", "Watt ", 157962631598059568L, 1.0), new Udef("J", "Joule ", 157962635893026864L, 1.0), new Udef("eV", "electron-Volt ", 157962635893026864L, 1.602177E-19), new Udef("Ry", "Rydberg(13.6eV) ", 157962635893026864L, 2.1798948E-18), new Udef("yr", "year ", 157678974777962544L, 3.15576E7), new Udef("a", "year ", 157678974777962544L, 3.15576E7), new Udef("d", "day ", 157678974777962544L, 86400.0), new Udef("AU", "astronomical unit ", 157680069994623024L, 1.49598E11), new Udef("au", "astronomical unit ", 157680069994623024L, 1.49598E11), new Udef("pc", "parsec ", 157680069994623024L, 3.0857E16), new Udef("al", "light-year ", 157680069994623024L, 9.46053E15), new Udef("JD", "Julian Date ", 4769364993205350448L, 86400.0, -2.073600432E11), new Udef("pix", "pixel ", 0x230303030303030L, 1.0), new Udef("ct", "count ", 0x230303030303030L, 1.0), new Udef("ph", "photon ", 0x230303030303030L, 1.0), new Udef("A", "Ampere ", 157678970499772464L, 1.0), new Udef("barn", "barn(10-28m2) ", 0x230323030303030L, 1.0E-28), new Udef("bit", "binary information unit ", 0x230303030303030L, 1.0), new Udef("byte", "byte(8bits) ", 0x230303030303030L, 1.0), new Udef("C", "Coulomb ", 157678974794739760L, 1.0), new Udef("D", "Debye (dipole)", 157680074306367536L, 3.333333333333333E-30), new Udef("cd", "candela(lumen/sr) ", 157678970482995504L, 1.0), new Udef("F", "Farad ", 157395313696452656L, 1.0), new Udef("H", "Henry ", 157962635859472432L, 1.0), new Udef("lm", "lumen ", 157678970482995504L, 0.07957747154594767), new Udef("lx", "lux(lm/m2) ", 157676771459739952L, 0.07957747154594767), new Udef("mol", "mole ", 157678970482995249L, 1.0), new Udef("N", "Newton ", 157961536381399088L, 1.0), new Udef("Ohm", "Ohm(V/A) ", 157962631564505136L, 1.0), new Udef("S", "Siemens(A/V) ", 157395309401485360L, 1.0), new Udef("Wb", "Weber(V.s) ", 157962635876249648L, 1.0), new Udef("u", "atomic mass unit ", 157960445459705904L, 1.6605387E-27), new Udef("\u00b5as", "micro-second of arc ", 0x230303030303030L, 7.71604938271605E-13), new Udef("\"d:m:s\"", "degree arcminute arcsecond (sexagesimal angle from degree)", 1310600475089842224L, 0.002777777777777778), new Udef("\"h:m:s\"", "hour minutes seconds (sexagesimal time from hours)", 1310600479384809520L, 3600.0), new Udef("\"h:m\"", "hour minutes (sexagesimal time from hours)", 2463521983991656496L, 3600.0), new Udef("\"m:s\"", "minutes seconds (sexagesimal time from minutes)", 2463521983991656496L, 60.0), new Udef("\"hhmmss\"", "hour minutes seconds (sexagesimal time without separator)", 2463521983991656496L, 3600.0), new Udef("\"ddmmss\"", "degree arcminute arcsecond (sexagesimal angle without separator)", 0x2230303030303030L, 0.002777777777777778), new Udef("\"date\"", "Fully qualified date", 4769364993205350448L, 86400.0), new Udef("\"datime\"", "Fully qualified date/time (ISO-8601)", 4769364993205350448L, 86400.0), new Udef("\"YYYYMMDD\"", "Fully qualified date (without separator)", 157678974777962544L, 86400.0), new Udef("\"month\"", "Month name or number (range 1..12)", 0x230303030303030L, 86400.0), new Udef("\"MM/YY\"", "Month/Year(from 1900)", 157678974777962544L, 86400.0), new Udef("\"MM/yy\"", "Month/Year(from 2000 when yy<50)", 157678974777962544L, 86400.0), new Udef("\"day\"", "Day of month number", 0x230303030303030L, 86400.0), new Udef("pi", "pi(=3.14...)", 0x230303030303030L, Math.PI), new Udef("\u03c0", "pi(=3.14...)", 0x230303030303030L, Math.PI), new Udef("c", "c(speed_of_light)", 157680065699655728L, 2.99792458E8), new Udef("G", "G(gravitation constant)", 157400785451233328L, 6.673E-11), new Udef("\\h", "hbar(Planck constant)", 157962640187994160L, 1.0545716E-34), new Udef("\u210f", "hbar(Planck constant)", 157962640187994160L, 1.0545716E-34), new Udef("e", "e(electron_charge) ", 157678974794739760L, 1.602177E-19), new Udef("k", "k(Boltzmann) ", 157962635892961328L, 1.38065E-23), new Udef("R", "R(gas_constant) ", 157962635892961327L, 8.3143), new Udef("mp", "mp(proton_mass) ", 157960445459705904L, 1.672661E-27), new Udef("me", "me(electron_mass) ", 157960445459705904L, 9.109382E-31), new Udef("a0", "(Bohr radius) ", 157680069994623024L, 5.29177208E-11), new Udef("eps0", "(electric constant) ", 157394214184824880L, 8.854187817620389E-12), new Udef("mu0", "(magnetic constant) ", 157961536347844656L, 1.2566370614359173E-6), new Udef("\u00b50", "(magnetic constant) ", 157961536347844656L, 1.2566370614359173E-6), new Udef("alpha", "(fine structure constant) ", 0x230303030303030L, 0.0072973525205055605), new Udef("muB", "(Bohr magneton) ", 157681169523028016L, 9.274009E-28), new Udef("degC", "Celsius ", 157678970483060784L, 1.0, 273.15), new Udef("\u00b0C", "Celsius ", 157678970483060784L, 1.0, 273.15), new Udef("MJD", "Modified Julian Date (JD-2400000.5) ", 4769364993205350448L, 86400.0), new Udef("atm", "atmosphere ", 157959337358143536L, 101325.0), new Udef("mmHg", "mercury_mm ", 157959337358143536L, 133.3224), new Udef("l", "litre ", 0x230333030303030L, 0.001), new Udef("hr", "hour(use 'h') ", 157678974777962544L, 3600.0), new Udef("sec", "second (use 's')", 157678974777962544L, 1.0), new Udef("inch", "inch ", 157680069994623024L, 0.0254), new Udef("t", "ton ", 157960445459705904L, 1000.0), new Udef("\"month\"", "month ", 0x230303030303030L, 1.0), new Udef("erg", "erg(10-7J) ", 157962635893026864L, 1.0E-7), new Udef("dyn", "dyne(10-5N) ", 157961536381399088L, 1.0E-5), new Udef("bar", "bar(10+5Pa) ", 157959337358143536L, 100000.0), new Udef("gauss", "Gauss(10-4T) ", 157960436852994096L, 1.0E-4), new Udef("cal", "calorie ", 157962635893026864L, 4.1854), new Udef("\u00c5", "Angstroem(0.1nm) ", 157680069994623024L, 1.0E-10), new Udef("Angstrom", "Angstroem(0.1nm) ", 157680069994623024L, 1.0E-10), new Udef("lyr", "light-year (c*yr) ", 157680069994623024L, 9.46053E15), new Udef("degF", "Fahrenheit ", 157678970483060784L, 0.5555555555555556, 255.3722222222222)};

    private static synchronized void init() {
        boolean bl = DEBUG;
        DEBUG = false;
        for (int i = 0; i < uDef.length; ++i) {
            hUnit.put(Unit.uDef[i].symb, new Integer(i));
        }
        initialized = true;
        Converter converter = new Converter("\"h:m:s\"", "\"d:m:s\"", 15.0);
        Converter converter2 = new Converter("\"d:m:s\"", "\"h:m:s\"", 0.06666666666666667);
        DEBUG = bl;
    }

    private static final Udef uLookup(String string) {
        Object v;
        if (!initialized) {
            Unit.init();
        }
        if ((v = hUnit.get(string)) instanceof String) {
            v = hUnit.get(v);
        }
        if (!(v instanceof Integer)) {
            return null;
        }
        int n = (Integer)v;
        if (n < uDef.length) {
            return uDef[n];
        }
        Udef udef = (Udef)aUnit.get(n -= uDef.length);
        return udef;
    }

    private static final Udef uLookup(long l) {
        int n;
        Udef udef = null;
        if (!initialized) {
            Unit.init();
        }
        for (n = 0; n < uDef.length; ++n) {
            if (Unit.uDef[n].mksa != l || Unit.uDef[n].orig != 0.0) continue;
            if (Unit.uDef[n].fact == 1.0) {
                return uDef[n];
            }
            if (udef != null) continue;
            udef = uDef[n];
        }
        if (udef != null) {
            return udef;
        }
        if (aUnit != null) {
            int n2 = aUnit.size();
            for (n = 0; n < n2; ++n) {
                udef = (Udef)aUnit.get(n);
                if (udef.mksa != l) continue;
                return udef;
            }
        }
        return udef;
    }

    private static final Udef uLookup(Parsing parsing, int n) {
        String string = new String(parsing.a, parsing.pos, n);
        Udef udef = Unit.uLookup(string);
        if (udef != null) {
            parsing.pos += n;
        }
        return udef;
    }

    public static final Enumeration symbols() {
        if (!initialized) {
            Unit.init();
        }
        return hUnit.keys();
    }

    public static synchronized Unit addSymbol(String string, String string2, String string3) throws ParseException {
        Udef udef = Unit.uLookup(string);
        Unit unit = udef == null ? null : new Unit(udef.symb);
        Unit unit2 = new Unit(string2);
        if (DEBUG) {
            System.out.println("----addSymbol(" + string + ") = " + string2 + " = " + unit2);
        }
        if (aUnit == null) {
            aUnit = new ArrayList(16);
        }
        if (!Double.isNaN(unit2.value)) {
            if ((unit2.mksa & 0x8100000000000000L) != 0L) {
                Unit unit3 = new Unit(unit2);
                unit3.dexp();
                unit2.factor = unit3.factor * unit3.value;
            } else {
                unit2.factor *= unit2.value;
            }
        }
        Udef udef2 = new Udef(string, string3, unit2.mksa, unit2.factor);
        int n = aUnit.size() + uDef.length;
        aUnit.add(udef2);
        hUnit.put(string, new Integer(n));
        if (DEBUG) {
            System.out.println("====Added units #" + n + " = " + udef2);
        }
        return unit;
    }

    public static synchronized Unit addSymbol(String string, String string2) throws ParseException {
        return Unit.addSymbol(string, string2, string2 + " ");
    }

    public static synchronized void registerConverter(String string, String string2, Converter converter) {
        String string3 = string + Converter.SEP + string2;
        hConv.put(string3, converter);
    }

    public static Converter getConverter(String string, String string2) {
        String string3 = string + Converter.SEP + string2;
        Converter converter = (Converter)hConv.get(string3);
        return converter;
    }

    public static boolean checkSymbol(String string) {
        return Unit.uLookup(string) != null;
    }

    public Unit() {
        this.set();
    }

    public Unit(Unit unit) {
        this.set(unit);
    }

    public Unit(String string) throws ParseException {
        this.set(string);
    }

    public double getValue() {
        return this.value;
    }

    public double getSIvalue() {
        return this.value * this.factor + this.offset;
    }

    public long getSIdim() {
        return this.mksa;
    }

    public static long unitless() {
        return 0x230303030303030L;
    }

    public String getUnit() {
        return this.symbol;
    }

    public String getSIunit() {
        StringBuffer stringBuffer = new StringBuffer(64);
        this.toSI(stringBuffer, 0);
        return "" + stringBuffer;
    }

    private static final String toExpr(String string) {
        int n;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length && Character.isLetter(cArray[n]); ++n) {
        }
        if (n < cArray.length) {
            return "(" + string + ")";
        }
        return string;
    }

    private static final int skipBrackets(StringBuffer stringBuffer) {
        int n = stringBuffer.length() - 1;
        int n2 = 0;
        if (n <= 0) {
            return 0;
        }
        while (stringBuffer.charAt(n2) == '(' && stringBuffer.charAt(n) == ')') {
            while (stringBuffer.charAt(--n) == ' ') {
            }
            while (stringBuffer.charAt(++n2) == ' ') {
            }
            stringBuffer.setLength(++n);
        }
        return n2;
    }

    private static final int getPower(Parsing parsing) {
        int n = 43;
        int n2 = 0;
        int n3 = 0;
        int n4 = parsing.pos;
        parsing.pos = parsing.length - 1;
        if (Character.isDigit(parsing.a[parsing.pos])) {
            while (Character.isDigit(parsing.a[parsing.pos])) {
                --parsing.pos;
            }
            n = parsing.a[parsing.pos];
            if (n != 43 && n != 45) {
                ++parsing.pos;
            }
            n3 = parsing.pos;
            n2 = parsing.parseInt();
        }
        if (n2 != 0) {
            if (parsing.a[0] == '(') {
                if (parsing.a[n3 - 1] != ')') {
                    n2 = 0;
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    if (Character.isLetter(parsing.a[i])) continue;
                    n2 = 0;
                }
            }
        }
        parsing.pos = n2 == 0 ? n4 : n3;
        return n2;
    }

    public final void log() throws ArithmeticException {
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: log(" + this.symbol + ")");
        }
        this.value = AstroMath.log(this.value);
        this.mksa |= Long.MIN_VALUE;
        if (this.symbol != null) {
            this.symbol = "[" + this.symbol + "]";
        }
    }

    public final void mag() throws ArithmeticException {
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: mag(" + this.symbol + ")");
        }
        this.value = -2.5 * AstroMath.log(this.value);
        if (this.mksa == 0x230303030303030L && this.factor == 1.0) {
            this.mksa |= 0x100000000000000L;
            if (this.symbol != null) {
                this.symbol = "mag";
            }
        } else {
            this.mksa |= 0x8100000000000000L;
            if (this.symbol != null) {
                this.symbol = "mag[" + this.symbol + "]";
            }
        }
    }

    public final void dexp() throws ArithmeticException {
        if ((this.mksa & Long.MIN_VALUE) == 0L) {
            throw new ArithmeticException("****Unit: dexp(" + this.symbol + ")");
        }
        double d = (this.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        this.value = AstroMath.dexp(this.value / d);
        this.mksa &= 0x7EFFFFFFFFFFFFFFL;
        if (this.symbol == null) {
            return;
        }
        int n = -1;
        int n2 = this.symbol.length() - 1;
        char c = this.symbol.charAt(n2);
        if (c == ']') {
            n = this.symbol.indexOf(91);
        } else if (c == ')') {
            n = this.symbol.indexOf(40);
        }
        if (n >= 0) {
            this.symbol = this.symbol.substring(n + 1, n2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(64);
            this.toSI(stringBuffer, 0);
            this.symbol = "" + stringBuffer;
        }
    }

    public final void power(int n) throws ArithmeticException {
        int n2;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        long l = 0x230303030303030L;
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: can't power log[unit]: " + this.symbol);
        }
        for (n2 = n; n2 > 0; --n2) {
            d2 *= this.factor;
            d3 *= this.value;
            l += this.mksa;
            if (((l -= 0x230303030303030L) & 0x8480808080808080L) == 0L) continue;
            d += 1.0;
        }
        while (n2 < 0) {
            d2 /= this.factor;
            d3 /= this.value;
            l += 0x230303030303030L;
            if (((l -= this.mksa) & 0x8480808080808080L) != 0L) {
                d += 1.0;
            }
            ++n2;
        }
        if (d > 0.0) {
            throw new ArithmeticException("****Unit: power too large: ()^" + n);
        }
        this.factor = d2;
        this.value = d3;
        this.mksa = l;
        if (n != 1 && this.symbol != null) {
            if (n == 0) {
                this.symbol = "";
            } else if (this.symbol.length() > 0) {
                Parsing parsing = new Parsing(this.symbol);
                int n3 = Unit.getPower(parsing);
                if (n3 == 0) {
                    this.symbol = Unit.toExpr(this.symbol) + n;
                } else {
                    n2 = 0;
                    n3 *= n;
                    if (parsing.a[0] == '(') {
                        n2 = 1;
                        parsing.advance(-1);
                    }
                    this.symbol = n == 1 ? this.symbol.substring(n2, parsing.pos) : Unit.toExpr(this.symbol.substring(n2, parsing.pos)) + n3;
                }
            }
        }
    }

    public final void sqrt() throws ArithmeticException {
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: log(" + this.symbol + ")");
        }
        if ((this.mksa & 0x101010101010101L) != 0L) {
            throw new ArithmeticException("****Unit: sqrt(" + this.symbol + ") is impossible");
        }
        this.value = Math.sqrt(this.value);
        this.factor = Math.sqrt(this.factor);
        this.mksa = this.mksa + 0x230303030303030L >> 1;
        if (this.symbol != null && this.symbol.length() > 1) {
            Parsing parsing = new Parsing(this.symbol);
            int n = 0;
            int n2 = 0;
            n2 = Unit.getPower(parsing);
            if ((n2 & 1) != 0) {
                n2 = 0;
            }
            if (parsing.a[0] == '(') {
                n = 1;
                parsing.advance(-1);
            }
            if (n2 == 2) {
                this.symbol = this.symbol.substring(n, parsing.pos);
            } else if (n2 != 0) {
                this.symbol = Unit.toExpr(this.symbol.substring(n, parsing.pos)) + (n2 /= 2);
            }
            if (n2 == 0 && parsing.length > 0) {
                this.symbol = "sqrt(" + this.symbol + ")";
            }
        }
    }

    public final boolean isUnitless() {
        return (this.mksa & Long.MAX_VALUE) == 0x230303030303030L;
    }

    public final boolean isCompatibleWith(Unit unit) {
        if (((unit.mksa | this.mksa) & 0x4000000000000000L) != 0L) {
            return (this.mksa ^ 0x4000000000000000L) == unit.mksa;
        }
        return (this.mksa & 0x7EFFFFFFFFFFFFFFL) == (unit.mksa & 0x7EFFFFFFFFFFFFFFL);
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Unit) {
            Unit unit = (Unit)object;
            if (unit.mksa == this.mksa) {
                bl = (this.mksa & Long.MIN_VALUE) != 0L ? this.factor == unit.factor && this.value == unit.value : this.factor * this.value == unit.factor * unit.value;
            }
        }
        return bl;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.factor);
        n = n * 123 + (int)(l ^ l >>> 32);
        n = n * 123 + (int)(this.mksa ^ this.mksa >>> 32);
        return n;
    }

    public static void convert(Unit unit, Unit unit2) throws ArithmeticException {
        String string = unit.symbol + Converter.SEP + unit2.symbol;
        Object v = hConv.get(string);
        if (v != null) {
            double d;
            Converter converter = (Converter)v;
            unit2.value = d = converter.convert(unit.value);
            return;
        }
        Unit.convertUnit(unit, unit2);
    }

    public static void convertUnit(Unit unit, Unit unit2) throws ArithmeticException {
        double d = unit.factor / unit2.factor;
        if (DEBUG) {
            unit.dump("...convert:source=");
            unit2.dump("...convert:target=");
        }
        if (unit2.mksa == unit.mksa) {
            unit2.value = d * unit.value + (unit.offset - unit2.offset) / unit2.factor;
            return;
        }
        if ((unit2.mksa & 0x7EFFFFFFFFFFFFFFL) != (unit.mksa & 0x7EFFFFFFFFFFFFFFL)) {
            throw new ArithmeticException("****Unit: can't convert " + unit.symbol + " into " + unit2.symbol);
        }
        if ((unit2.mksa & Long.MIN_VALUE) == 0L) {
            double d2 = (unit.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
            unit2.value = d * AstroMath.dexp(unit.value / d2);
            return;
        }
        if ((unit.mksa & Long.MIN_VALUE) != 0L) {
            unit2.value = (unit.mksa & 0x100000000000000L) != 0L ? -0.4 * unit.value : unit.value;
            unit2.value += AstroMath.log(d);
            if ((unit2.mksa & 0x100000000000000L) != 0L) {
                unit2.value *= -2.5;
            }
            return;
        }
        double d3 = (unit2.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        unit2.value = d3 * AstroMath.log(d * unit.value);
    }

    public void convertFrom(Unit unit) throws ArithmeticException {
        Unit.convert(unit, this);
    }

    public void convertTo(Unit unit) throws ArithmeticException {
        double d = this.factor / unit.factor;
        if (DEBUG) {
            this.dump("...convertTo:source= ");
            unit.dump("...convertTo:target= ");
        }
        if (this.mksa == unit.mksa && (this.mksa & Long.MIN_VALUE) == 0L) {
            this.value = (this.value * this.factor + this.offset - unit.offset) / unit.factor;
            this.factor = unit.factor;
            this.offset = unit.offset;
            this.symbol = unit.symbol;
            return;
        }
        Unit unit2 = new Unit(this);
        this.symbol = unit.symbol;
        this.mksa = unit.mksa;
        this.factor = unit.factor;
        this.offset = unit.offset;
        this.convertFrom(unit2);
    }

    public final void plus(Unit unit) throws ArithmeticException {
        boolean bl = false;
        if (((this.mksa | unit.mksa) & 0x4000000000000000L) != 0L) {
            if (this.mksa != (0x4000000000000000L ^ unit.mksa)) {
                bl = true;
            } else {
                this.mksa |= 0x4000000000000000L;
            }
        } else {
            boolean bl2 = bl = (this.mksa & 0xDFFFFFFFFFFFFFFFL) != (unit.mksa & 0xDFFFFFFFFFFFFFFFL);
        }
        if (bl) {
            throw new ArithmeticException("****Unit: can't combine: " + this.symbol + " + " + unit.symbol);
        }
        this.value += unit.value * unit.factor / this.factor;
    }

    public final void minus(Unit unit) throws ArithmeticException {
        boolean bl = false;
        if (((this.mksa | unit.mksa) & 0x4000000000000000L) != 0L) {
            if (this.mksa == unit.mksa) {
                this.mksa ^= 0x4000000000000000L;
            } else if ((unit.mksa & 0x4000000000000000L) != 0L) {
                bl = true;
            }
        } else {
            boolean bl2 = bl = (this.mksa & 0xDFFFFFFFFFFFFFFFL) != (unit.mksa & 0xDFFFFFFFFFFFFFFFL);
        }
        if (bl) {
            throw new ArithmeticException("****Unit: can't combine: " + this.symbol + " - " + unit.symbol);
        }
        this.value -= unit.value * unit.factor / this.factor;
    }

    public final void sum(Unit unit) throws ArithmeticException {
        boolean bl = false;
        if (((this.mksa | unit.mksa) & 0x8100000000000000L) == 0L) {
            this.plus(unit);
            return;
        }
        if (DEBUG) {
            this.dump("...sum:term1");
            unit.dump("...sum:term2");
        }
        if ((this.mksa & 0x7EFFFFFFFFFFFFFFL) != (unit.mksa & 0x7EFFFFFFFFFFFFFFL)) {
            throw new ArithmeticException("****Unit: can't sum: " + this.symbol + " + " + unit.symbol);
        }
        long l = this.mksa & 0x8100000000000000L;
        long l2 = unit.mksa & 0x8100000000000000L;
        if (l != l2) {
            Unit unit2 = new Unit(this);
            unit2.convertFrom(unit);
            this.sum(unit2);
            return;
        }
        double d = (l & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        double d2 = unit.value - this.value;
        this.value += d * AstroMath.log(1.0 + unit.factor / this.factor * Math.exp(d2 / d));
    }

    public final void mult(double d) throws ArithmeticException {
        if ((this.mksa & 0x4000000000000000L) != 0L && d != 1.0) {
            throw new ArithmeticException("****Unit.mult on a date!");
        }
        this.value *= d;
    }

    public final void mult(Unit unit) throws ArithmeticException {
        long l = this.mksa;
        double d = this.factor;
        double d2 = this.value;
        double d3 = this.offset;
        if ((this.mksa & 0x4000000000000000L) != 0L && unit.factor != 1.0) {
            throw new ArithmeticException("****Unit.mult on a date!");
        }
        if (!(((this.mksa | unit.mksa) & Long.MIN_VALUE) == 0L || this.mksa == 0x230303030303030L && this.factor == 1.0 || unit.mksa == 0x230303030303030L && unit.factor == 1.0)) {
            throw new ArithmeticException("****Unit: can't multiply logs: " + this.symbol + " x " + unit.symbol);
        }
        if (this.offset != 0.0 || unit.offset != 0.0) {
            if (this.mksa == 0x230303030303030L) {
                this.offset = unit.offset;
            } else if (unit.mksa != 0x230303030303030L) {
                this.offset = 0.0;
            }
        }
        d2 *= unit.value;
        d *= unit.factor;
        l += unit.mksa;
        if (((l -= 0x230303030303030L) & 0xC80808080808080L) != 0L) {
            throw new ArithmeticException("****too large powers in: " + this.symbol + " x " + unit.symbol);
        }
        this.mksa = l;
        this.factor = d;
        this.value = d2;
        if (this.symbol != null && unit.symbol != null) {
            if (unit.mksa == 0x230303030303030L && unit.factor == 1.0) {
                return;
            }
            this.symbol = this.mksa == 0x230303030303030L && this.factor == 1.0 ? unit.symbol : (this.symbol.equals(unit.symbol) && this.factor == unit.factor ? Unit.toExpr(this.symbol) + "2" : Unit.toExpr(this.symbol) + "." + Unit.toExpr(unit.symbol));
        }
    }

    public final void div(Unit unit) throws ArithmeticException {
        long l = this.mksa;
        double d = this.factor;
        double d2 = this.value;
        if ((this.mksa & 0x4000000000000000L) != 0L && unit.factor != 1.0) {
            throw new ArithmeticException("****Unit.div  on a date!");
        }
        if (!(((this.mksa | unit.mksa) & Long.MIN_VALUE) == 0L || this.mksa == 0x230303030303030L && this.factor == 1.0 || unit.mksa == 0x230303030303030L && unit.factor == 1.0)) {
            throw new ArithmeticException("****Unit: can't divide logs: " + this.symbol + " x " + unit.symbol);
        }
        if (this.offset != 0.0 || unit.offset != 0.0) {
            if (this.mksa == 0x230303030303030L) {
                this.offset = unit.offset;
            } else if (unit.mksa != 0x230303030303030L) {
                this.offset = 0.0;
            }
        }
        d2 /= unit.value;
        d /= unit.factor;
        l += 0x230303030303030L;
        if (((l -= unit.mksa) & 0x8C80808080808080L) != 0L) {
            throw new ArithmeticException("****too large powers in: " + this.symbol + " / " + unit.symbol);
        }
        this.mksa = l;
        this.factor = d;
        this.value = d2;
        if (this.symbol != null && unit.symbol != null) {
            if (unit.mksa == 0x230303030303030L && unit.factor == 1.0) {
                return;
            }
            this.symbol = this.mksa == 0x230303030303030L && this.factor == 1.0 ? Unit.toExpr(unit.symbol) + "-1" : (this.symbol.equals(unit.symbol) ? Unit.edf(this.factor) : Unit.toExpr(this.symbol) + "/" + Unit.toExpr(unit.symbol));
        }
    }

    public final void prod(Unit unit) throws ArithmeticException {
        if ((this.mksa & Long.MIN_VALUE) == 0L && (unit.mksa & Long.MIN_VALUE) == 0L) {
            this.mult(unit);
            return;
        }
        Unit unit2 = new Unit(this);
        Unit unit3 = new Unit(unit);
        if ((unit2.mksa & Long.MIN_VALUE) != 0L) {
            unit2.mksa &= 0x7EFFFFFFFFFFFFFFL;
            unit2.convertFrom(this);
        }
        if ((unit3.mksa & Long.MIN_VALUE) != 0L) {
            unit3.mksa &= 0x7EFFFFFFFFFFFFFFL;
            unit3.convertFrom(this);
        }
        unit2.mult(unit3);
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            if ((this.mksa & 0x100000000000000L) != 0L) {
                unit2.mag();
            } else {
                unit2.log();
            }
        }
        this.set(unit2);
    }

    private final int unit1(Parsing parsing, StringBuffer stringBuffer) throws ParseException {
        int n;
        int n2;
        int n3 = parsing.pos;
        Udef udef = uDef[0];
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        int n8 = -1;
        this.mksa = 0x230303030303030L;
        this.factor = 1.0;
        if (parsing.pos >= parsing.length) {
            return 0;
        }
        if (DEBUG) {
            System.out.println("....unit1(" + parsing + ")");
        }
        switch (parsing.a[parsing.pos]) {
            case '(': {
                udef = null;
                ++parsing.pos;
                boolean bl2 = bl = stringBuffer != null;
                if (bl) {
                    n8 = stringBuffer.length();
                    stringBuffer.append('(');
                }
                this.unitec(parsing, stringBuffer);
                if (parsing.pos < parsing.length && parsing.a[parsing.pos] == ')') {
                    ++parsing.pos;
                } else {
                    throw new ParseException("****Unit: Missing ) in '" + parsing + "'", parsing.pos);
                }
                if (!bl) break;
                n2 = stringBuffer.length();
                while (--n2 >= 0 && stringBuffer.charAt(n2) == ' ') {
                }
                stringBuffer.setLength(++n2);
                stringBuffer.append(')');
                bl = false;
                break;
            }
            case '\"': {
                n2 = parsing.matchingQuote();
                if (n2 < parsing.length) {
                    ++n2;
                }
                if ((udef = Unit.uLookup(parsing, n2 - parsing.pos)) != null) break;
                throw new ParseException("****Unit: quoted unit does not match", parsing.pos);
            }
            case '-': {
                n = parsing.pos++;
                if (parsing.pos >= parsing.length) break;
                if (Character.isDigit(parsing.a[parsing.pos])) {
                    parsing.pos = n;
                    break;
                }
                while (parsing.pos < parsing.length && parsing.a[parsing.pos] == '-') {
                    ++parsing.pos;
                }
                break;
            }
            case '%': {
                udef = Unit.uLookup(parsing, 1);
                break;
            }
            case '\\': {
                for (n2 = parsing.pos + 1; n2 < parsing.length && Character.isLetter(parsing.a[n2]); ++n2) {
                }
                udef = Unit.uLookup(parsing, n2 - parsing.pos);
                if (udef != null) break;
                ++n7;
                break;
            }
            default: {
                for (n2 = parsing.pos; n2 < parsing.length && Character.isLetter(parsing.a[n2]); ++n2) {
                }
                if (n2 < parsing.length && parsing.a[n2] == '0') {
                    ++n2;
                }
                if ((udef = Unit.uLookup(parsing, n2 - parsing.pos)) != null) break;
                n = parsing.pos;
                if (parsing.length - parsing.pos > 1) {
                    n4 = parsing.lookup(mul_symb);
                }
                if (n4 < 0 || (udef = Unit.uLookup(parsing, n2 - parsing.pos)) != null) break;
                parsing.pos = n;
            }
        }
        if (n7 == 0 && parsing.pos < parsing.length) {
            n6 = parsing.a[parsing.pos];
        }
        if (udef != null && (udef.mksa & 0x6000000000000000L) != 0L) {
            n6 = 0;
        }
        if (n6 == 43 || n6 == 45 || n6 == 94 || Character.isDigit((char)n6) && n6 != 48) {
            if (DEBUG) {
                System.out.print("    look for power with op=" + (char)n6);
            }
            if (n6 == 94) {
                ++parsing.pos;
            }
            if (parsing.pos < parsing.length) {
                n6 = parsing.a[parsing.pos];
                if (n6 == 43) {
                    ++parsing.pos;
                }
                if (n6 != 45) {
                    n6 = 43;
                }
                if ((n5 = parsing.parseInt()) == 0) {
                    ++n7;
                } else if (n5 > 0 && n5 < 10 && stringBuffer != null) {
                    --parsing.pos;
                    n2 = parsing.lookup(op_symb);
                    if (n2 >= 0) {
                        if (n8 >= 0) {
                            stringBuffer.insert(n8, op_text[n2]);
                        } else {
                            stringBuffer.append(op_text[n2]);
                        }
                        n6 = 32;
                    } else {
                        ++parsing.pos;
                    }
                }
                if (DEBUG) {
                    System.out.print(", power=" + n5);
                }
            } else {
                ++n7;
            }
            if (DEBUG) {
                System.out.println(", error=" + n7);
            }
        }
        if (n7 > 0) {
            throw new ParseException("****Unit: '" + parsing + "'+" + parsing.pos, parsing.pos);
        }
        if (n4 >= 0) {
            this.factor *= AstroMath.dexp(mul_fact[n4]);
            if (stringBuffer != null) {
                stringBuffer.append(mul_text[n4]);
            }
        }
        if (udef != null) {
            this.factor *= udef.fact;
            this.mksa = udef.mksa;
            this.offset = udef.orig;
            if (stringBuffer != null) {
                stringBuffer.append(udef.expl);
            }
        }
        if (n5 != 1) {
            this.power(n5);
            if (n6 != 32 && stringBuffer != null) {
                stringBuffer.append("power");
                if (n5 >= 0) {
                    stringBuffer.append((char)n6);
                }
                stringBuffer.append(n5);
            }
        }
        n = parsing.pos - n3;
        if (DEBUG) {
            System.out.println("  =>unit1: return=" + n + ", f=" + this.factor + ", val=" + this.value);
        }
        return n;
    }

    private final boolean unitec(Parsing parsing, StringBuffer stringBuffer) throws ParseException {
        int n;
        int n2 = parsing.pos;
        Unit unit = null;
        int n3 = -1;
        char c = '\u0000';
        char c2 = '\u0000';
        boolean bl = false;
        this.mksa = 0x230303030303030L;
        if (DEBUG) {
            System.out.print("....unitec(" + parsing + "): factor=");
        }
        parsing.gobbleSpaces();
        int n4 = parsing.pos;
        this.factor = parsing.parseFactor();
        if (DEBUG) {
            System.out.println(this.factor);
        }
        if (stringBuffer != null && n4 != parsing.pos) {
            stringBuffer.append(parsing.a, n4, parsing.pos - n4);
        }
        if ((n3 = parsing.lookup(log_symb)) >= 0) {
            c2 = log_end[n3];
            if (stringBuffer != null) {
                stringBuffer.append(log_symb[n3 & 0xFFFFFFFC]);
            }
            n4 = parsing.pos;
            double d = parsing.parseFactor();
            if (stringBuffer != null && n4 != parsing.pos) {
                stringBuffer.append(parsing.a, n4, parsing.pos - n4);
                this.offset = AstroMath.log(d);
            }
            if (DEBUG) {
                System.out.println(", offset=" + this.offset);
            }
        }
        n4 = -1;
        while (parsing.pos < parsing.length && parsing.a[parsing.pos] != c2) {
            if (c == '\u0000') {
                n = this.unit1(parsing, stringBuffer);
                if (DEBUG && unit != null) {
                    unit.dump("..unitec");
                }
                c = 'x';
            } else {
                if (unit == null) {
                    unit = new Unit();
                }
                n = unit.unit1(parsing, stringBuffer);
                if (DEBUG) {
                    unit.dump("..unitec");
                    System.out.println("    combining with op=" + c);
                    System.out.println("    this=" + this + " \tfactor=" + this.factor);
                    System.out.println("    temp=" + unit + " \tfactor=" + unit.factor);
                }
                if (c == '/') {
                    this.div(unit);
                } else {
                    this.mult(unit);
                }
            }
            if (parsing.match('#')) {
                int n5 = parsing.pos - 1;
                double d = parsing.parseFactor();
                if (parsing.pos <= n5 + 3) {
                    parsing.pos = n5;
                } else {
                    this.offset = d;
                }
                if (stringBuffer != null && this.offset != 0.0) {
                    stringBuffer.append("(offseted by ");
                    editing.editDouble(stringBuffer, this.offset, 16);
                    stringBuffer.append(')');
                }
            }
            if ((n4 = (this.mksa & 0x4000000000000000L) != 0L ? -1 : parsing.lookup(op_symb)) < 0) break;
            c = op_symb[n4].charAt(0);
            if (stringBuffer == null) continue;
            n = stringBuffer.length();
            while (--n >= 0 && stringBuffer.charAt(n) == ' ') {
            }
            stringBuffer.setLength(++n);
            stringBuffer.append(' ');
            stringBuffer.append(op_text[n4]);
        }
        if (n3 >= 0) {
            if (stringBuffer != null) {
                n = stringBuffer.length();
                while (--n >= 0 && stringBuffer.charAt(n) == ' ') {
                }
                stringBuffer.setLength(++n);
                stringBuffer.append(log_end[n3 & 0xFFFFFFFC]);
            }
            if (parsing.pos < parsing.length && c2 != '\u0000' && parsing.a[parsing.pos] == c2) {
                c2 = '\u0000';
                ++parsing.pos;
            }
            this.mksa |= Long.MIN_VALUE;
            if (this.factor != 1.0) {
                this.offset = AstroMath.log(this.factor);
                this.factor = 1.0;
            }
            if ((n3 & 4) != 0) {
                this.mksa |= 0x100000000000000L;
            }
        }
        if (n4 >= 0) {
            throw new ParseException("****Unit.text+" + parsing.pos + " (missing operand): " + parsing, parsing.pos);
        }
        if (c2 != '\u0000') {
            throw new ParseException("****Unit.text+" + parsing.pos + " (missing '" + c2 + "'): " + parsing, parsing.pos);
        }
        parsing.gobbleSpaces();
        if (DEBUG) {
            System.out.println("  =>unitec: return=" + (parsing.pos > n2) + "\tfactor=" + this.factor);
        }
        return parsing.pos > n2;
    }

    public final void set() {
        this.symbol = null;
        this.mksa = 0x230303030303030L;
        this.factor = 1.0;
        this.value = Double.NaN;
        this.offset = 0.0;
    }

    public final void set(Unit unit) {
        this.mksa = unit.mksa;
        this.symbol = unit.symbol;
        this.value = unit.value;
        this.factor = unit.factor;
        this.offset = unit.offset;
    }

    public boolean parse(Parsing parsing) {
        Object object;
        boolean bl;
        boolean bl2;
        double d;
        int n;
        int n2;
        block42: {
            n2 = parsing.pos;
            if (!initialized) {
                Unit.init();
            }
            parsing.gobbleSpaces();
            n = parsing.pos;
            if (DEBUG) {
                System.out.print("#...Unit.parse(" + parsing + "):");
            }
            d = parsing.parseFactor();
            if (DEBUG) {
                System.out.print(" val=" + d);
            }
            bl2 = parsing.pos > n;
            parsing.gobbleSpaces();
            if (parsing.lookup(op_symb) >= 0) {
                bl2 = false;
                parsing.pos = n;
                if (DEBUG) {
                    System.out.print("(FALSE!)");
                }
            }
            n = parsing.pos;
            this.offset = 0.0;
            this.symbol = null;
            if (DEBUG) {
                System.out.println("\n    Interpret '" + parsing + "'");
            }
            try {
                bl = this.unitec(parsing, null);
                this.symbol = String.copyValueOf(parsing.a, n, parsing.pos - n);
                object = hUnit.get(this.symbol);
                if (object instanceof String) {
                    this.symbol = (String)object;
                }
                if (!(bl2 & (this.mksa & 0x2000000000000000L) != 0L)) break block42;
                int n3 = parsing.pos;
                parsing.set(n2);
                parsing.gobbleSpaces();
                try {
                    parsing.parseComplex(this.symbol);
                    parsing.set(n3);
                }
                catch (Exception exception) {
                    parsing.set(n2);
                    return false;
                }
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("++++unitec catched: " + exception);
                    exception.printStackTrace();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                bl = false;
                parsing.pos = n;
            }
        }
        if (DEBUG) {
            System.out.println("\n    interpret '" + parsing + "', has_value=" + bl2);
        }
        if (!bl2 && parsing.pos < parsing.length) {
            int n4;
            n = parsing.pos;
            if (!bl && parsing.currentChar() == '\"' && (n4 = parsing.matchingQuote()) > 0) {
                if (DEBUG) {
                    System.out.println("#...Unit.parse: t.matchingQuote()=" + n4);
                }
                n4 -= n;
                this.symbol = parsing.toString(++n4);
                parsing.advance(n4);
                parsing.gobbleSpaces();
                n = parsing.pos;
                try {
                    d = parsing.parseComplex(this.symbol);
                }
                catch (ParseException parseException) {
                    String string = parseException.getMessage();
                    if (string.indexOf("parseComplex((") >= 0) {
                        System.err.println(parseException);
                    }
                    parsing.set(n2);
                    return false;
                }
                if (parsing.status() != 0) {
                    String string = parsing.error_message;
                    int n5 = string.indexOf(" interpreted as (");
                    if (n5 > 0) {
                        n5 = string.indexOf(40, n5);
                        int n6 = string.indexOf(41, n5);
                        String string2 = string.substring(n5 + 1, n6);
                        if (DEBUG) {
                            System.out.println("#...Unit.parse: adding Hash " + this.symbol + " => " + string2);
                        }
                        hUnit.put(this.symbol, string2);
                        this.symbol = string2;
                        parsing.pos = n;
                        try {
                            d = parsing.parseComplex(this.symbol);
                        }
                        catch (ParseException parseException) {
                            System.err.println(parseException);
                            parseException.printStackTrace();
                            parsing.set(n2);
                            return false;
                        }
                    } else {
                        System.err.println(string);
                        parsing.set(n2);
                        return false;
                    }
                }
                bl2 = true;
                object = parsing.isDate() ? Unit.uLookup("MJD") : (parsing.isDays() ? Unit.uLookup("d") : (parsing.isTime() ? Unit.uLookup("\"h:m:s\"") : Unit.uLookup("\"d:m:s\"")));
                try {
                    Unit.addSymbol(this.symbol, ((Udef)object).symb, Parsing.explainComplex(this.symbol));
                    object = Unit.uLookup(this.symbol);
                    ((Udef)object).mksa |= 0x2000000000000000L;
                }
                catch (ParseException parseException) {
                    System.err.println(parseException);
                    parseException.printStackTrace();
                }
                this.mksa = ((Udef)object).mksa;
                this.factor = ((Udef)object).fact;
            }
            if (bl && parsing.pos < parsing.length) {
                if (DEBUG) {
                    System.out.println("#...Unit.parse: symbol=" + this.symbol + ", interpret: " + parsing);
                }
                if (this.mksa == 4769364993205350448L) {
                    if (DEBUG) {
                        System.out.print("    parsing via Astrotime(");
                    }
                    object = new Astrotime();
                    if (Character.isLetter(this.symbol.charAt(0))) {
                        parsing.set(n2);
                    }
                    if (DEBUG) {
                        System.out.print(parsing + ") symbol=" + this.symbol);
                    }
                    if (bl2 = ((Astrotime)object).parse(parsing)) {
                        d = ((Astrotime)object).getMJD();
                    }
                    if (DEBUG) {
                        System.out.println(" has_value=" + bl2 + ", MJD=" + d);
                        ((Astrotime)object).dump("datime ");
                    }
                } else if ((this.mksa & 0x2000000000000000L) != 0L) {
                    try {
                        d = parsing.parseComplex(this.symbol);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        parsing.set(n2);
                        return false;
                    }
                }
            }
        }
        double d2 = this.value = bl2 ? d : Double.NaN;
        if (bl | bl2) {
            return true;
        }
        parsing.pos = n2;
        return false;
    }

    public void set(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        this.set();
        if (DEBUG) {
            this.dump("set(" + parsing + ")");
        }
        boolean bl = this.parse(parsing);
        parsing.gobbleSpaces();
        if (DEBUG) {
            System.out.println("....Unit.set(" + string + ")" + bl + " => " + this.toString());
        }
        if (parsing.pos < parsing.length) {
            throw new ParseException("****Unit: set '" + string + "'+" + parsing.pos, parsing.pos);
        }
    }

    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        this.parse(parsing);
        return parsing.pos;
    }

    public int parseUnit(String string, int n) {
        int n2 = this.parse(string, n);
        this.setUnit();
        return n2;
    }

    public int parseValue(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        parsing.gobbleSpaces();
        int n2 = parsing.pos;
        this.value = (this.mksa & 0x1000000000000000L) != 0L ? parsing.parseSexa() : parsing.parseFactor();
        if (parsing.pos == n2) {
            return n;
        }
        return parsing.pos;
    }

    public void setUnit() {
        if (Double.isNaN(this.factor)) {
            this.factor = 1.0;
        }
        double d = this.factor;
        if (Double.isNaN(this.value)) {
            this.value = 1.0;
        }
        this.factor *= this.value;
        this.value = 1.0;
        if (d != this.factor) {
            this.symbol = this.symbol == null ? Unit.edf(this.factor) : Unit.edf(this.factor) + Unit.toExpr(this.symbol);
        }
    }

    public void setUnit(String string) throws ParseException {
        this.set(string);
        this.setUnit();
    }

    public void setValue(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        parsing.gobbleSpaces();
        int n = parsing.pos;
        this.value = this.symbol.charAt(0) == '\"' && this.symbol.indexOf(58) > 0 ? parsing.parseSexa() : parsing.parseFactor();
        if (parsing.pos == n) {
            this.value = Double.NaN;
        }
        parsing.gobbleSpaces();
        if (parsing.pos < parsing.length) {
            throw new ParseException("****Unit: setValue '" + string + "'+" + parsing.pos, parsing.pos);
        }
    }

    public void setValue(double d) {
        this.value = d;
    }

    private static final StringBuffer edf(StringBuffer stringBuffer, double d) {
        return editing.editDouble(stringBuffer, d, 10);
    }

    private static final String edf(double d) {
        if (d == 1.0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        Unit.edf(stringBuffer, d);
        return "" + stringBuffer;
    }

    private static final int edu(StringBuffer stringBuffer, long l, int n) {
        int n2;
        int n3 = stringBuffer.length();
        int n4 = 0;
        boolean bl = false;
        if ((l & Long.MIN_VALUE) != 0L && ((l &= Long.MAX_VALUE) & 0x100000000000000L) != 0L) {
            l &= 0xFEFFFFFFFFFFFFFFL;
        }
        if (l == 0x230303030303030L) {
            return 0;
        }
        if (n > 0) {
            n4 = (l & 0x100000000000000L) == 0L ? 0 : 1;
            for (long i = l << 8 >> 8; i != 0L; i >>>= 8) {
                if ((i & 0xFFL) == 48L) continue;
                ++n4;
            }
            for (n2 = 0; n2 < uDef.length; ++n2) {
                if (Unit.uDef[n2].mksa != l || Unit.uDef[n2].fact != 1.0) continue;
                stringBuffer.append(Unit.uDef[n2].symb);
                break;
            }
            if (n4 == 1) {
                return stringBuffer.length() - n3;
            }
            if (stringBuffer.length() != n3) {
                stringBuffer.append(" [");
            } else {
                n4 = 0;
            }
        }
        int n5 = 2;
        int n6 = 7;
        for (n2 = 0; n2 < 8; ++n2) {
            int n7 = (int)(l >>> 56 - (n2 << 3) & (long)n6) - n5;
            n5 = 48;
            n6 = 255;
            if (n7 == 0) continue;
            if (bl) {
                stringBuffer.append(".");
            }
            bl = true;
            stringBuffer.append(MKSA[n2]);
            if (n7 == 1) continue;
            if (n7 > 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(n7);
        }
        if (n4 > 0) {
            stringBuffer.append("]");
        }
        return stringBuffer.length() - n3;
    }

    private void toSI(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            stringBuffer.append((this.mksa & 0x100000000000000L) != 0L ? "mag[" : "log[");
        }
        if (this.factor != 1.0) {
            Unit.edf(stringBuffer, this.factor);
            if (this.offset != 0.0) {
                stringBuffer.append('(');
                bl = true;
            }
        }
        Unit.edu(stringBuffer, this.mksa, n);
        if (this.offset != 0.0) {
            stringBuffer.append("#");
            Unit.edf(stringBuffer, -this.offset);
            if (bl) {
                stringBuffer.append(')');
            }
        }
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            stringBuffer.append("]");
        }
    }

    public void dump(String string) {
        char[] cArray = new char[24];
        long l = this.mksa;
        int n = 24;
        while (n > 0) {
            cArray[--n] = x[(int)(l & 0xFL)];
            cArray[--n] = x[(int)((l >>>= 4) & 0xFL)];
            l >>>= 4;
            cArray[--n] = 46;
        }
        cArray[n] = 120;
        System.out.println(string + ": symbol='" + this.symbol + "', value=" + this.value);
        System.out.print("        factor=" + this.factor + ", Dim0" + new String(cArray));
        if (this.offset != 0.0) {
            System.out.print(" offset=" + this.offset);
        }
        System.out.println("");
    }

    public final StringBuffer editDimension(StringBuffer stringBuffer) {
        for (int i = 1; i < MKSAdim.length; ++i) {
            int n;
            if (MKSAdim[i] == '\u0000' || (n = (int)(this.mksa >> (7 - i) * 8 & 0xFFL) - 48) == 0) continue;
            stringBuffer.append(MKSAdim[i]);
            if (n > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(n);
        }
        return stringBuffer;
    }

    public final String dimension() {
        StringBuffer stringBuffer = new StringBuffer(16);
        this.editDimension(stringBuffer);
        return stringBuffer.toString();
    }

    public final StringBuffer editValue(StringBuffer stringBuffer) {
        if (Double.isNaN(this.value)) {
            return Unit.edf(stringBuffer, this.value);
        }
        if (this.mksa == 4769364993205350448L) {
            if (this.symbol.startsWith("\"dat")) {
                double d = this.value + this.offset / this.factor;
                int n = (int)d;
                if (this.value < 0.0) {
                    --n;
                }
                double d2 = (d - (double)n) * 86400.0;
                editing.editDate(stringBuffer, n);
                if (this.symbol.startsWith("\"datim")) {
                    stringBuffer.append('T');
                    editing.editSexa(stringBuffer, d2 / 3600.0, 2, -10, 0x20 | 5);
                } else if (d2 >= 1.0E-6) {
                    editing.editDecimal(stringBuffer, d2 / 86400.0, 0, -11, 0);
                }
            } else if (this.symbol.charAt(0) == '\"') {
                editing.editComplex(stringBuffer, this.value, this.symbol);
            } else {
                int n = this.symbol.charAt(0) == 'J' ? -10 : -11;
                editing.editDecimal(stringBuffer, this.value, 0, n, 0);
            }
        } else if ((this.mksa & 0x2000000000000000L) != 0L) {
            editing.editComplex(stringBuffer, this.value, this.symbol);
        } else if ((this.mksa & 0x1000000000000000L) != 0L) {
            editing.editSexa(stringBuffer, this.value, 1, -9, 5);
        } else {
            Unit.edf(stringBuffer, this.value);
        }
        return stringBuffer;
    }

    public final StringBuffer edit(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = 0;
        if (DEBUG) {
            this.dump("unit.edit");
        }
        if (this.symbol != null) {
            n = this.symbol.length();
        }
        if ((this.mksa & 0x7000000000000000L) != 0L) {
            bl = true;
            stringBuffer.append(this.symbol);
        }
        if (!Double.isNaN(this.value) || n == 0) {
            this.editValue(stringBuffer);
        }
        if (!(this.mksa == 0x230303030303030L && this.factor == 1.0 || bl)) {
            if (n > 0) {
                boolean bl2 = Character.isDigit(this.symbol.charAt(0));
                if (bl2) {
                    stringBuffer.append('(');
                }
                stringBuffer.append(this.symbol);
                if (bl2) {
                    stringBuffer.append(')');
                }
            } else {
                stringBuffer.append('(');
                this.toSI(stringBuffer, 0);
                stringBuffer.append(')');
            }
        }
        return stringBuffer;
    }

    public static final String explainUnit(String string) {
        Parsing parsing = new Parsing(string);
        StringBuffer stringBuffer = new StringBuffer(120);
        Unit unit = new Unit();
        int n = 0;
        if (!initialized) {
            Unit.init();
        }
        try {
            unit.unitec(parsing, stringBuffer);
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("++++explainUnit: catched: " + exception);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (parsing.currentChar() == '\"') {
                stringBuffer.append(Parsing.explainComplex(parsing.toString()));
            }
            String string2 = "?***bad Unit <";
            stringBuffer.insert(0, string2);
            stringBuffer.insert(string2.length(), string);
            stringBuffer.insert(string2.length() + string.length(), "> ");
        }
        n = Unit.skipBrackets(stringBuffer);
        return stringBuffer.toString().substring(n);
    }

    public final String explainUnit() {
        StringBuffer stringBuffer = new StringBuffer(120);
        Parsing parsing = new Parsing(this.symbol);
        Unit unit = new Unit();
        int n = 0;
        try {
            unit.unitec(parsing, stringBuffer);
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("++++explainUnit: catched: " + exception);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (parsing.currentChar() == '\"') {
                stringBuffer.append(Parsing.explainComplex(parsing.toString()));
            }
            String string = "?***bad Unit <";
            stringBuffer.insert(0, string);
            stringBuffer.insert(string.length(), this.symbol);
            stringBuffer.insert(string.length() + this.symbol.length(), "> ");
        }
        n = Unit.skipBrackets(stringBuffer);
        stringBuffer.append(" (");
        this.toSI(stringBuffer, 1);
        stringBuffer.append(")");
        return stringBuffer.toString().substring(n);
    }

    public final String toStringInSI() {
        StringBuffer stringBuffer = new StringBuffer(64);
        Unit unit = new Unit(this);
        if ((unit.mksa & Long.MIN_VALUE) != 0L) {
            unit.mksa &= 0x7EFFFFFFFFFFFFFFL;
        }
        if (unit.offset != 0.0) {
            Udef udef = Unit.uLookup(unit.mksa);
            unit.symbol = udef.symb;
            unit.offset = udef.orig;
        }
        unit.factor = 1.0;
        unit.convertFrom(this);
        if (!Double.isNaN(this.value)) {
            Unit.edf(stringBuffer, unit.value);
            if (stringBuffer.length() == 0) {
                stringBuffer.append('1');
            }
        }
        unit.toSI(stringBuffer, 0);
        return "" + stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(120);
        boolean bl = false;
        if (DEBUG) {
            this.dump("unit.toString");
        }
        if ((this.mksa & 0x7000000000000000L) != 0L) {
            bl = true;
            stringBuffer.append(this.symbol);
        }
        if (!Double.isNaN(this.value)) {
            this.editValue(stringBuffer);
            if (stringBuffer.length() == 0) {
                stringBuffer.append((this.mksa & Long.MIN_VALUE) != 0L ? (char)'0' : '1');
            }
        }
        if (!(this.mksa == 0x230303030303030L && this.factor == 1.0 || bl)) {
            if (this.symbol != null) {
                boolean bl2 = Character.isDigit(this.symbol.charAt(0));
                if (bl2) {
                    stringBuffer.append('(');
                }
                stringBuffer.append(this.symbol);
                if (bl2) {
                    stringBuffer.append(')');
                }
            } else {
                stringBuffer.append('(');
                this.toSI(stringBuffer, 0);
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    public String editedValue() {
        StringBuffer stringBuffer = new StringBuffer(120);
        this.editValue(stringBuffer);
        return stringBuffer.toString();
    }
}

