/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AbstractRegion;
import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.CircularRegion;
import cds.astro.ConvexRegion;
import cds.astro.Coo;
import cds.astro.EllipticalRegion;
import cds.astro.Proj3;
import cds.astro.ZonalRegion;
import java.io.Serializable;

public class Region
extends AbstractRegion
implements Serializable {
    @Override
    public String toString() {
        return this.toString();
    }

    @Override
    public double area() {
        return this.area();
    }

    @Override
    public boolean checkCoo(Coo coo) {
        return this.checkCoo(coo);
    }

    @Override
    public int checkCircle(Coo coo, double d) {
        return this.checkCircle(coo, d);
    }

    Region() {
        this.centroid = null;
    }

    public static Region circle(Coo coo, double d) {
        CircularRegion circularRegion = new CircularRegion(coo, d);
        return circularRegion;
    }

    public static Region box(Astroframe astroframe, Coo coo, double d, double d2) {
        Coo[] cooArray = new Coo[4];
        Proj3 proj3 = new Proj3(coo);
        double d3 = AstroMath.tand(d / 2.0);
        double d4 = AstroMath.tand(d2 / 2.0);
        proj3.set(d3, d4);
        cooArray[0] = proj3.getCoo();
        proj3.set(d3, -d4);
        cooArray[1] = proj3.getCoo();
        proj3.set(-d3, -d4);
        cooArray[2] = proj3.getCoo();
        proj3.set(-d3, d4);
        cooArray[3] = proj3.getCoo();
        double d5 = 90.0;
        if (astroframe != null) {
            for (int i = 0; i < 4; ++i) {
                astroframe.toICRS(cooArray[i]);
            }
            Coo coo2 = new Coo(coo);
            astroframe.toICRS(coo2);
            proj3.set(d3, 0.0);
            Coo coo3 = proj3.getCoo();
            astroframe.toICRS(coo3);
            d5 = coo2.posAngle(coo3);
        }
        if (DEBUG) {
            System.out.print("#...Creating box(" + coo + " " + d + "x" + d2 + "deg)");
            if (astroframe != null) {
                System.out.print("[" + astroframe.toString() + "]");
            }
            System.out.println(" as convex:");
            for (int i = 0; i < 4; ++i) {
                cooArray[i].dump("#" + i + "#");
            }
        }
        ConvexRegion convexRegion = new ConvexRegion(cooArray);
        convexRegion.setBox(d, d2, d5);
        return convexRegion;
    }

    public static Region rotatedBox(Coo coo, double d, double d2, double d3) {
        Coo[] cooArray = new Coo[4];
        Proj3 proj3 = new Proj3(coo);
        double d4 = AstroMath.tand(d / 2.0);
        double d5 = AstroMath.tand(d2 / 2.0);
        double d6 = AstroMath.cosd(d3);
        double d7 = AstroMath.sind(d3);
        double d8 = d6 * d5 + d7 * d4;
        double d9 = -d7 * d5 + d6 * d4;
        proj3.set(d8, d9);
        cooArray[0] = proj3.getCoo();
        d5 = -d5;
        d8 = d6 * d5 + d7 * d4;
        d9 = -d7 * d5 + d6 * d4;
        proj3.set(d8, d9);
        cooArray[1] = proj3.getCoo();
        d4 = -d4;
        d8 = d6 * d5 + d7 * d4;
        d9 = -d7 * d5 + d6 * d4;
        proj3.set(d8, d9);
        cooArray[2] = proj3.getCoo();
        d5 = -d5;
        d8 = d6 * d5 + d7 * d4;
        d9 = -d7 * d5 + d6 * d4;
        proj3.set(d8, d9);
        cooArray[3] = proj3.getCoo();
        if (DEBUG) {
            System.out.println("#...Creating box(" + coo + " " + d + "x" + d2 + "deg, pa=" + d3 + ") as convex:");
            for (int i = 0; i < 4; ++i) {
                cooArray[i].dump("#" + i + "#");
            }
        }
        ConvexRegion convexRegion = new ConvexRegion(cooArray);
        convexRegion.setBox(d, d2, d3);
        return convexRegion;
    }

    public static Region polygon(Coo[] cooArray) {
        ConvexRegion convexRegion = new ConvexRegion(cooArray);
        return convexRegion;
    }

    public static Region zone(Astroframe astroframe, double d, double d2, double d3, double d4) {
        ZonalRegion zonalRegion = new ZonalRegion(astroframe, d, d2, d3, d4);
        return zonalRegion;
    }

    public static Region zone(Astroframe astroframe, Coo coo, double d, double d2) {
        ZonalRegion zonalRegion = new ZonalRegion(astroframe, coo, d, d2);
        return zonalRegion;
    }

    public static Region ellipse(Astroframe astroframe, Coo coo, double d, double d2) {
        EllipticalRegion ellipticalRegion = new EllipticalRegion(astroframe, coo, d, d2, 90.0);
        return ellipticalRegion;
    }

    public static Region ellipse(Coo coo, double d, double d2, double d3) {
        EllipticalRegion ellipticalRegion = new EllipticalRegion(null, coo, d, d2, d3);
        return ellipticalRegion;
    }
}

