/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Coo;
import java.text.ParseException;

public class Proj3 {
    protected byte type;
    private double[] R;
    protected double clon;
    protected double clat;
    protected double X;
    protected double Y;
    protected Coo point;
    public static final int NONE = 0;
    public static final int TAN = 1;
    public static final int TAN2 = 2;
    public static final int SIN = 3;
    public static final int SIN2 = 4;
    public static final int ARC = 5;
    public static final int AITOFF = 6;
    public static final int SANSON = 7;
    public static final int MERCATOR = 8;
    public static final int LAMBERT = 9;
    public static final String[] name = new String[]{"-", "Gnomonic (TAN)", "Stereographic (TAN2)", "Orthographic (SIN)", "Zenithal Equal-area (SIN2)", "Schmidt (ARC)", "Aitoff", "Sanson", "Mercator", "Lambert"};

    public Proj3(Coo coo) {
        this(1, coo);
    }

    public Proj3(int n, Coo coo) {
        this.type = (byte)n;
        this.point = new Coo(coo);
        this.clon = this.point.getLon();
        this.clat = this.point.getLat();
        if (this.clon != 0.0 || this.clat != 0.0) {
            this.R = this.point.localMatrix();
        }
    }

    public Proj3(int n, double d, double d2) {
        this(n, new Coo(d, d2));
    }

    public Proj3(int n, String string) throws ParseException {
        this.point = new Coo(string);
        this.type = (byte)n;
        this.clon = this.point.lon;
        this.clat = this.point.lat;
        if (this.clon != 0.0 || this.clat != 0.0) {
            this.R = Coo.localMatrix(this.clon, this.clat);
        }
    }

    public Proj3(int n) {
        this(n, 0.0, 0.0);
    }

    public Proj3(double d, double d2) {
        this(new Coo(d, d2));
    }

    public final double getX() {
        return this.X;
    }

    public final double getY() {
        return this.Y;
    }

    public final Coo getCoo() {
        return new Coo(this.point);
    }

    public final double getLon() {
        return this.point.lon;
    }

    public final double getLat() {
        return this.point.lat;
    }

    public String toString() {
        return name[this.type] + " projection centered at " + this.clon + " " + this.clat + ": " + this.X + " " + this.Y;
    }

    public boolean set(Coo coo) {
        double d;
        double d2;
        double d3;
        if (this.point.equals(coo)) {
            return !Double.isNaN(this.X);
        }
        this.X = Double.NaN;
        this.Y = Double.NaN;
        if (this.R == null) {
            d3 = coo.x;
            d2 = coo.y;
            d = coo.z;
        } else {
            d3 = this.R[0] * coo.x + this.R[1] * coo.y + this.R[2] * coo.z;
            d2 = this.R[3] * coo.x + this.R[4] * coo.y + this.R[5] * coo.z;
            d = this.R[6] * coo.x + this.R[7] * coo.y + this.R[8] * coo.z;
        }
        switch (this.type) {
            case 1: {
                if (d3 <= 0.0) {
                    return false;
                }
                this.X = d2 / d3;
                this.Y = d / d3;
                break;
            }
            case 2: {
                double d4 = (1.0 + d3) / 2.0;
                if (d4 <= 0.0) {
                    this.X = Double.NaN;
                    this.Y = Double.NaN;
                    return false;
                }
                this.X = d2 / d4;
                this.Y = d / d4;
                break;
            }
            case 3: {
                if (d3 <= 0.0) {
                    return false;
                }
                this.X = d2;
                this.Y = d;
                break;
            }
            case 4: {
                double d5 = Math.sqrt((1.0 + d3) / 2.0);
                if (d5 > 0.0) {
                    this.X = d2 / d5;
                    this.Y = d / d5;
                    break;
                }
                this.X = 2.0;
                this.Y = 0.0;
                break;
            }
            case 5: {
                if (d3 > -1.0) {
                    double d6 = Math.sqrt(d2 * d2 + d * d);
                    double d7 = d3 > 0.0 ? AstroMath.asinc(d6) : Math.acos(d3) / d6;
                    this.X = d2 * d7;
                    this.Y = d * d7;
                    break;
                }
                this.X = Math.PI;
                this.Y = 0.0;
                break;
            }
            case 6: {
                double d8 = Math.sqrt(d3 * d3 + d2 * d2);
                double d9 = Math.sqrt(d8 * (d8 + d3) / 2.0);
                d9 = Math.sqrt((1.0 + d9) / 2.0);
                this.X = Math.sqrt(2.0 * d8 * (d8 - d3)) / d9;
                this.Y = d / d9;
                if (!(d2 < 0.0)) break;
                this.X = -this.X;
                break;
            }
            case 7: {
                double d10 = Math.sqrt(d3 * d3 + d2 * d2);
                this.Y = Math.asin(d);
                if (d10 == 0.0) {
                    this.X = 0.0;
                    break;
                }
                this.X = Math.atan2(d2, d3) * d10;
                break;
            }
            case 8: {
                double d11 = Math.sqrt(d3 * d3 + d2 * d2);
                if (d11 == 0.0) {
                    return false;
                }
                this.X = Math.atan2(d2, d3);
                this.Y = AstroMath.atanh(d);
                break;
            }
            case 9: {
                double d12 = Math.sqrt(d3 * d3 + d2 * d2);
                this.Y = d;
                if (d12 == 0.0) {
                    this.X = 0.0;
                    break;
                }
                this.X = Math.atan2(d2, d3);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Proj3: Invalid Projection type #" + this.type);
            }
        }
        this.point.set(coo);
        return true;
    }

    public boolean set(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (d == this.X && d2 == this.Y) {
            return this.point.x != 0.0 || this.point.y != 0.0 || this.point.z != 0.0;
        }
        this.X = d;
        this.Y = d2;
        this.point.lat = Double.NaN;
        this.point.lon = Double.NaN;
        this.point.z = 0.0;
        this.point.y = 0.0;
        this.point.x = 0.0;
        switch (this.type) {
            case 1: {
                d5 = 1.0 / Math.sqrt(1.0 + this.X * this.X + this.Y * this.Y);
                d4 = this.X * d5;
                d3 = this.Y * d5;
                break;
            }
            case 2: {
                double d6 = (this.X * this.X + this.Y * this.Y) / 4.0;
                double d7 = 1.0 + d6;
                d5 = (1.0 - d6) / d7;
                d4 = this.X / d7;
                d3 = this.Y / d7;
                break;
            }
            case 3: {
                double d8 = 1.0 - this.X * this.X - this.Y * this.Y;
                if (d8 < 0.0) {
                    if (d8 > -2.0E-16) {
                        d8 = 0.0;
                    } else {
                        return false;
                    }
                }
                d5 = Math.sqrt(d8);
                d4 = this.X;
                d3 = this.Y;
                break;
            }
            case 4: {
                double d9 = (this.X * this.X + this.Y * this.Y) / 4.0;
                if (d9 > 1.0) {
                    return false;
                }
                double d10 = Math.sqrt(1.0 - d9);
                d5 = 1.0 - 2.0 * d9;
                d4 = d10 * this.X;
                d3 = d10 * this.Y;
                break;
            }
            case 5: {
                double d11 = Math.sqrt(this.X * this.X + this.Y * this.Y);
                if (d11 > Math.PI) {
                    return false;
                }
                double d12 = AstroMath.sinc(d11);
                d5 = Math.cos(d11);
                d4 = d12 * this.X;
                d3 = d12 * this.Y;
                break;
            }
            case 6: {
                double d13 = this.X * this.X / 8.0 + this.Y * this.Y / 2.0;
                if (d13 > 1.0) {
                    return false;
                }
                d5 = 1.0 - d13;
                double d14 = Math.sqrt(1.0 - d13 / 2.0);
                d4 = this.X * d14 / 2.0;
                d3 = this.Y * d14;
                d13 = Math.sqrt(d5 * d5 + d4 * d4);
                if (!(d13 > 0.0)) break;
                d14 = d5;
                d5 = (d14 * d14 - d4 * d4) / d13;
                d4 = 2.0 * d14 * d4 / d13;
                break;
            }
            case 7: {
                d3 = Math.sin(this.Y);
                double d15 = 1.0 - d3 * d3;
                if (d15 < 0.0) {
                    return false;
                }
                double d16 = (d15 = Math.sqrt(d15)) == 0.0 ? 0.0 : this.X / d15;
                d5 = d15 * Math.cos(d16);
                d4 = d15 * Math.sin(d16);
                break;
            }
            case 8: {
                double d17 = 1.0 / Math.cosh(this.Y);
                d3 = Math.tanh(this.Y);
                d5 = d17 * Math.cos(this.X);
                d4 = d17 * Math.sin(this.X);
                break;
            }
            case 9: {
                d3 = this.Y;
                double d18 = 1.0 - d3 * d3;
                if (d18 < 0.0) {
                    return false;
                }
                d18 = Math.sqrt(d18);
                d5 = d18 * Math.cos(this.X);
                d4 = d18 * Math.sin(this.X);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Proj3: Invalid Projection type #" + this.type);
            }
        }
        if (this.R != null) {
            this.point.set(this.R[0] * d5 + this.R[3] * d4 + this.R[6] * d3, this.R[1] * d5 + this.R[4] * d4 + this.R[7] * d3, this.R[2] * d5 + this.R[5] * d4 + this.R[8] * d3);
        } else {
            this.point.set(d5, d4, d3);
        }
        return true;
    }

    public boolean moveCenter(double d, double d2) {
        if (this.X == d && this.Y == d2) {
            return true;
        }
        double[] dArray = this.point.localMatrix();
        if (!this.set(d, d2)) {
            return false;
        }
        double[] dArray2 = this.point.localMatrix();
        dArray2 = AstroMath.m3p(dArray2, AstroMath.m3t(dArray));
        this.R = this.R == null ? dArray2 : AstroMath.m3p(this.R, dArray2);
        this.point.set(this.R[0], this.R[1], this.R[2]);
        this.clon = this.point.getLon();
        this.clat = this.point.getLat();
        this.set(d, d2);
        return true;
    }
}

