/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.Coo;

public class ICRS
extends Astroframe {
    static final char letterIAU = 'I';
    public static final double[] toICRSbase = AstroMath.U3matrix;

    public static ICRS scan(double d) {
        if (DEBUG) {
            System.out.println("#...ICRS.scan(" + d + ")");
        }
        if (fixedFrames == null) {
            return null;
        }
        boolean bl = Double.isNaN(d);
        for (Object e : fixedFrames) {
            if (!(e instanceof ICRS)) continue;
            ICRS iCRS = (ICRS)e;
            if ((iCRS.fixed & 0xF) != 0 || !bl && !(Math.abs(iCRS.epoch - d) <= 3.168808781402895E-8)) continue;
            return iCRS;
        }
        return null;
    }

    public static ICRS create(double d) {
        ICRS iCRS = ICRS.scan(d);
        if (iCRS == null) {
            iCRS = new ICRS(d);
            iCRS.fixFrame();
        }
        return iCRS;
    }

    public static ICRS create() {
        return ICRS.create(2000.0);
    }

    public ICRS(double d) {
        this.precision = (byte)9;
        this.epoch = Double.isNaN(d) ? 2000.0 : d;
        this.name = "ICRS";
        this.full_name = "ICRS(Ep=J" + d + ")";
        this.toICRSmatrix = toICRSbase;
        this.fromICRSmatrix = toICRSbase;
        this.hms = true;
        this.ed_lon = (byte)37;
        this.ed_lat = (byte)53;
    }

    @Override
    public void toICRS(Coo coo) {
    }

    @Override
    public void fromICRS(Coo coo) {
    }
}

