/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Equatorial;

public class FK5
extends Equatorial {
    static final char letterIAU = 'J';
    public static final double[] XYZrota = new double[]{-19.9, -9.1, 22.9};
    public static final double[] XYZspin = new double[]{-0.3, 0.6, 0.7};
    public static final double[] toICRSbase = new double[]{0.9999999999999929, 1.110223372305E-7, 4.41180342698E-8, -1.110223329741E-7, 0.9999999999999892, -9.64779274389E-8, -4.4118044981E-8, 9.64779225408E-8, 0.9999999999999943, -2.484418308E-16, 3.393695551290894E-9, -2.9088825755493596E-9, -3.3936957677667417E-9, -5.170974623E-16, -1.4544408701009027E-9, 2.908882086657213E-9, 1.454441043328612E-9, -1.19872596E-17};
    public static final double[] fromICRSbase = new double[]{0.9999999999999929, -1.110223329741E-7, -4.4118044981E-8, 1.110223372305E-7, 0.9999999999999892, 9.64779225408E-8, 4.41180342698E-8, -9.64779274389E-8, 0.9999999999999943, -2.484418308E-16, -3.3936957677667417E-9, 2.908882086657213E-9, 3.393695551290894E-9, -5.170974623E-16, 1.454441043328612E-9, -2.9088825755493596E-9, -1.4544408701009027E-9, -1.19872596E-17};

    public static FK5 scan(double d, double d2) {
        if (DEBUG) {
            System.out.println("#...FK5.scan(J" + d + ", Ep=J" + d2 + ")");
        }
        if (fixedFrames == null) {
            return null;
        }
        boolean bl = Double.isNaN(d2);
        for (Object e : fixedFrames) {
            if (!(e instanceof FK5)) continue;
            FK5 fK5 = (FK5)e;
            if ((fK5.fixed & 0xF) != 0 || fK5.equinox != d || !bl && !(Math.abs(fK5.epoch - d2) < 3.168808781402895E-8)) continue;
            return fK5;
        }
        return null;
    }

    public static final FK5 create(double d, double d2) {
        FK5 fK5 = FK5.scan(d, d2);
        if (fK5 == null) {
            fK5 = new FK5(d, d2);
            fK5.fixFrame();
        }
        return fK5;
    }

    public static FK5 create(double d) {
        return FK5.create(d, d);
    }

    public static FK5 create() {
        return FK5.create(2000.0, 2000.0);
    }

    public FK5(double d, double d2) {
        if (Double.isNaN(d2)) {
            d2 = d;
        }
        this.precision = (byte)7;
        this.equinox = d;
        this.epoch = d2;
        this.name = "FK5(J" + d + ")";
        this.full_name = this.name.substring(0, this.name.length() - 1) + ",Ep=J" + d2 + ")";
        if (Math.abs(d - 2000.0) > 3.0E-4) {
            this.toBaseEquinox = FK5.precessionMatrix(d, 2000.0);
            this.toICRSmatrix = AstroMath.m36p(toICRSbase, this.toBaseEquinox);
            this.fromICRSmatrix = AstroMath.rot_inv(this.toICRSmatrix);
        } else {
            this.toBaseEquinox = AstroMath.U3matrix;
            this.toICRSmatrix = toICRSbase;
            this.fromICRSmatrix = fromICRSbase;
        }
        FK5.compute_dotMatrix(this);
        if (DEBUG) {
            AstroMath.checkUnity("#---Verify to/fromICRSbase:", AstroMath.m36p(toICRSbase, fromICRSbase));
            System.out.println("#---Constructing Astroframe: " + this.full_name);
            AstroMath.printMatrix("#...fromICRSmatrix:\n", this.fromICRSmatrix);
            AstroMath.printMatrix("#...(recomputed)..:\n", AstroMath.m36p(AstroMath.rot_inv(this.toBaseEquinox), AstroMath.rot_inv(toICRSbase)));
            AstroMath.printMatrix("#.....toICRSmatrix:\n", this.toICRSmatrix);
            AstroMath.printMatrix("#..6x6toICRSmatrix:\n", AstroMath.m36p(AstroMath.m6(toICRSbase), AstroMath.m6(this.toBaseEquinox)));
            AstroMath.printMatrix("#.....Product=.....\n", AstroMath.m36p(this.fromICRSmatrix, this.toICRSmatrix));
            AstroMath.printMatrix("#....toBaseEquinox:\n", this.toBaseEquinox);
        }
    }

    static final double[] precessionMatrix(double d, double d2) {
        boolean bl = false;
        double d3 = (d - 2000.0) / 100.0;
        double d4 = (d2 - d) / 100.0;
        if (Math.abs(d3) > Math.abs(d3 + d4)) {
            bl = true;
            d3 += d4;
            d4 = -d4;
        }
        double d5 = 2306.2181 + (1.39656 - 1.39E-4 * d3) * d3;
        double d6 = (d5 + (0.30188 - 3.44E-4 * d3 + 0.017998 * d4) * d4) * d4 / 3600.0;
        double d7 = (d5 + (1.09468 + 6.6E-5 * d3 + 0.018203 * d4) * d4) * d4 / 3600.0;
        double d8 = (2004.3109 + (-0.8533 - 2.17E-4 * d3) * d3 + (-0.42665 - 2.17E-4 * d3 - 0.041833 * d4) * d4) * d4 / 3600.0;
        if (bl) {
            return AstroMath.rotation("zyz", -d6, d8, -d7);
        }
        return AstroMath.rotation("zyz", d7, -d8, d6);
    }
}

