/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Equatorial;

public class FK4
extends Equatorial {
    static final char letterIAU = 'B';
    private static double[] ev50 = FK4.eterm(1950.0);
    protected double[] toBaseEquinox;
    protected double[] ev_eq;
    public static final double FJB = 1.000021359027778;
    public static final double TJ = 50.0002095577002;
    public static final double[] X0 = new double[]{0.9999256794956877, -0.0111814832204662, -0.0048590038153592, 0.0111814832391717, 0.9999374848933135, -2.71625947142E-5, 0.0048590037723143, -2.7170293744E-5, 0.9999881946023742, -2.6455262E-11, -1.1539918689E-8, 2.111134619E-8, 1.1540628161E-8, -1.29042997E-10, 2.36021478E-10, -2.1112979048E-8, -5.6024448E-11, 1.02587734E-10};
    public static final double[] XYZrota = new double[]{5.584340790153, 1002.236538581694, -2306.398766625517};
    public static final double[] XYZspin = new double[]{-0.2817204053, -3.7515987371, -1.6789411256};
    public static final double[] toICRSbase = new double[]{0.9999256809514446, -0.011181372206268162, -0.004858959700861368, 0.011181371756303229, 0.9999374861373184, -2.72585320447865E-5, 0.0048589607363144416, -2.7073328547607E-5, 0.9999881948141177, -2.642881776994E-12, -8.146356274167222E-9, 1.8202405805118696E-8, 8.14011951444771E-9, -9.10561571313818E-11, -1.20191459490131E-9, -1.8188049228460452E-8, 1.3658005511963221E-9, 8.84130375706395E-11};
    public static final double[] fromICRSbase = new double[]{0.9999256809514446, 0.011181371756303229, 0.0048589607363144416, -0.011181372206268162, 0.9999374861373184, -2.7073328547607E-5, -0.004858959700861368, -2.72585320447865E-5, 0.9999881948141177, -2.642881776994E-12, 8.14011951444771E-9, -1.8188049228460452E-8, -8.146356274167222E-9, -9.10561571313818E-11, 1.365800551196322E-9, 1.8202405805118696E-8, -1.20191459490131E-9, 8.84130375706395E-11};

    public static FK4 scan(double d, double d2) {
        if (DEBUG) {
            System.out.println("#...FK4.scan(B" + d + ", Ep=B" + d2 + ")");
        }
        if (fixedFrames == null) {
            return null;
        }
        boolean bl = Double.isNaN(d2);
        double d3 = Astrotime.B2J(d2);
        for (Object e : fixedFrames) {
            if (!(e instanceof FK4)) continue;
            FK4 fK4 = (FK4)e;
            if ((fK4.fixed & 0xF) != 0 || fK4.equinox != d || !bl && !(Math.abs(fK4.epoch - d3) < 3.168808781402895E-8)) continue;
            return fK4;
        }
        return null;
    }

    public static FK4 create(double d, double d2) {
        FK4 fK4 = FK4.scan(d, d2);
        if (fK4 == null) {
            fK4 = new FK4(d, d2);
            fK4.fixFrame();
        }
        return fK4;
    }

    public static FK4 create(double d) {
        return FK4.create(d, d);
    }

    public static FK4 create() {
        return FK4.create(1950.0, 1950.0);
    }

    public FK4(double d, double d2) {
        if (Double.isNaN(d2)) {
            d2 = d;
        }
        this.precision = (byte)6;
        this.equinox = d;
        this.epoch = Astrotime.B2J(d2);
        this.name = "FK4(B" + d + ")";
        this.full_name = this.name.substring(0, this.name.length() - 1) + ",Ep=B" + d2 + ")";
        this.ed_lon = (byte)37;
        this.ed_lat = (byte)53;
        if (Math.abs(d - 1950.0) > 1.0E-4) {
            this.toBaseEquinox = FK4.precessionMatrix(d, 1950.0);
            this.toICRSmatrix = AstroMath.m36p(toICRSbase, this.toBaseEquinox);
            this.fromICRSmatrix = AstroMath.rot_inv(this.toICRSmatrix);
            this.ev_eq = FK4.eterm(d);
        } else {
            this.toBaseEquinox = AstroMath.U3matrix;
            this.toICRSmatrix = toICRSbase;
            this.fromICRSmatrix = fromICRSbase;
            this.ev_eq = ev50;
        }
        FK4.compute_dotMatrix(this);
        if (DEBUG) {
            AstroMath.checkUnity("#---Verify to/fromICRSbase:", AstroMath.m36p(toICRSbase, fromICRSbase));
            System.out.println("#---Constructing Astroframe: " + this.full_name);
            System.out.print(AstroMath.toString("#...fromICRSmatrix:\n", this.fromICRSmatrix));
            System.out.print(AstroMath.toString("#...(recomputed)..:\n", AstroMath.m36p(AstroMath.rot_inv(this.toBaseEquinox), AstroMath.rot_inv(toICRSbase))));
            System.out.print(AstroMath.toString("#.....toICRSmatrix:\n", this.toICRSmatrix));
            System.out.print(AstroMath.toString("#..6x6toICRSmatrix:\n", AstroMath.m36p(AstroMath.m6(toICRSbase), AstroMath.m6(this.toBaseEquinox))));
            System.out.print(AstroMath.toString("#.....Product=.....\n", AstroMath.m36p(this.fromICRSmatrix, this.toICRSmatrix)));
            System.out.print(AstroMath.toString("#....toBaseEquinox:\n", this.toBaseEquinox));
        }
    }

    public static double[] precessionMatrix(double d, double d2) {
        boolean bl = false;
        double d3 = d - 1900.0;
        double d4 = d2 - d;
        if (Math.abs(d3) > Math.abs(d3 + d4)) {
            bl = true;
            d3 += d4;
            d4 = -d4;
        }
        double d5 = (d4 /= 1000.0) * (23042.53 + (d3 /= 1000.0) * (139.73 + 0.06 * d3) + d4 * (30.23 + 18.0 * d4 - 0.27 * d3)) / 3600.0;
        double d6 = d5 + d4 * d4 * (79.27 + 0.66 * d3 + 0.32 * d4) / 3600.0;
        double d7 = d4 * (20046.85 - d3 * (85.33 + 0.37 * d3) - d4 * (42.67 + 0.37 * d3 + 41.8 * d4)) / 3600.0;
        if (bl) {
            return AstroMath.rotation("zyz", -d5, d7, -d6);
        }
        return AstroMath.rotation("zyz", d6, -d7, d5);
    }

    public static final double[] eterm(double d) {
        double[] dArray = new double[3];
        double d2 = (d - 1900.0) / 100.0;
        double d3 = 23.452 - 0.013 * d2;
        double d4 = 0.016751 - 4.2E-5 * d2;
        double d5 = 281.221 + 1.719 * d2;
        double d6 = AstroMath.cosd(d5);
        dArray[0] = (d4 *= 9.936741208021049E-5) * AstroMath.sind(d5);
        dArray[1] = -d4 * d6 * AstroMath.cosd(d3);
        dArray[2] = -d4 * d6 * AstroMath.sind(d3);
        if (DEBUG) {
            System.out.println("#...FK4.e-term(B" + d + "): " + AstroMath.toString(dArray));
        }
        return dArray;
    }

    public final void subEterm(double[] dArray) {
        Coo.sub(dArray, this.ev_eq);
    }

    public final void addEterm(double[] dArray) {
        Coo.add(dArray, this.ev_eq);
    }
}

