/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.Qbox;
import cds.astro.Region;

public class EllipticalRegion
extends Region {
    double a;
    double b;
    double pa;
    Coo f0;
    Coo f1;
    double sina;
    double cosa;
    double cos2a;
    double sin2_2a;
    double cosc;
    double e;

    EllipticalRegion(Astroframe astroframe, Coo coo, double d, double d2, double d3) {
        if (DEBUG) {
            System.out.println("#...new Ellipse(" + coo + ", a=" + d + ", b=" + d2 + ", pa=" + d3 + ")");
        }
        if (d >= 180.0 || d2 >= 180.0) {
            System.err.println("#+++Ellipse(" + coo + ", a=" + d + ", b=" + d2 + "): sem-axises too large!");
            return;
        }
        if (coo.x == 0.0 && coo.y == 0.0 && coo.z == 0.0) {
            this.centroid = null;
            return;
        }
        this.centroid = new Coo(coo);
        if (d < d2) {
            this.a = d2 / 2.0;
            this.b = d / 2.0;
            this.pa = d3 + 90.0;
        } else {
            this.a = d / 2.0;
            this.b = d2 / 2.0;
            this.pa = d3;
        }
        this.minrad = this.b;
        this.maxrad = this.a;
        this.cosa = AstroMath.cosd(this.a);
        this.sina = AstroMath.sind(this.a);
        double d4 = AstroMath.cosd(this.b);
        double d5 = AstroMath.sind(this.b);
        this.cosc = this.cosa / d4;
        double d6 = Math.sqrt((this.sina + d5) * (this.sina - d5)) / d4;
        double d7 = AstroMath.cosd(this.pa);
        double d8 = AstroMath.sind(this.pa);
        this.f0 = new Coo(this.cosc, d6 * d8, d6 * d7);
        this.f1 = new Coo(this.f0.x, -this.f0.y, -this.f0.z);
        if (DEBUG) {
            System.out.println("#...foci(0) " + this.f0 + " " + this.f1);
        }
        double[] dArray = this.centroid.localMatrix();
        this.f0.rotate_1(dArray);
        this.f1.rotate_1(dArray);
        if (DEBUG) {
            System.out.println("#...foci(1) " + this.f0 + " " + this.f1);
        }
        if (astroframe != null) {
            astroframe.toICRS(this.f0);
            astroframe.toICRS(this.f1);
            astroframe.toICRS(this.centroid);
        }
        this.cos2a = AstroMath.cosd(2.0 * this.a);
        this.sin2_2a = AstroMath.sind(2.0 * this.a);
        this.sin2_2a *= this.sin2_2a;
        this.e = d6 / this.sina;
        this.pa = this.centroid.posAngle(this.f0);
        while (this.pa >= 180.0) {
            this.pa -= 180.0;
        }
    }

    EllipticalRegion(Coo coo, double d, double d2) {
        this(null, coo, d, d2, 90.0);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.centroid == null) {
            stringBuffer.append("*INVALID*");
        }
        stringBuffer.append("Ellipse(");
        if (this.centroid != null) {
            stringBuffer.append(this.centroid.toString());
        }
        stringBuffer.append(", " + 2.0 * this.a + "x" + 2.0 * this.b);
        if (this.pa >= 0.0) {
            stringBuffer.append(", pa=" + this.pa);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public double area() {
        double d;
        double d2 = this.e * this.e;
        if (d2 < 1.0E-12 || this.a < 0.2) {
            double d3 = 2.0 * AstroMath.sind(this.a / 2.0);
            d = Math.PI * d3 * d3;
            if (d2 > 0.0) {
                d = d * Math.sqrt(1.0 - d2) * (1.0 + 0.375 * d2 * d3 * d3);
            }
        } else {
            d = Math.PI * 2 - 4.0 * this.cosa * Math.sqrt(1.0 - d2) * AstroMath.ell3(d2, d2 * this.sina * this.sina);
        }
        return 3282.806350011744 * d;
    }

    @Override
    public boolean checkCoo(Coo coo) {
        double d;
        if (this.centroid == null) {
            return false;
        }
        double d2 = coo.dotprod(this.f0);
        return d2 * d2 + (d = coo.dotprod(this.f1)) * d - 2.0 * this.cos2a * d2 * d >= this.sin2_2a;
    }

    private boolean intersects(double[] dArray, double[] dArray2) {
        double d;
        double d2 = Coo.dotprod(dArray, dArray2);
        double d3 = this.f0.dotprod(dArray);
        double d4 = this.f0.dotprod(dArray2);
        double d5 = this.f1.dotprod(dArray);
        double d6 = this.f1.dotprod(dArray2);
        double d7 = d4 * d4 + d6 * d6 - 2.0 * this.cos2a * d4 * d6 - this.sin2_2a;
        double d8 = d3 * d3 + d5 * d5 - 2.0 * this.cos2a * d3 * d5 - this.sin2_2a;
        double d9 = d3 * d4 + d5 * d6 - this.cos2a * (d3 * d6 + d4 * d5) - this.sin2_2a * d2;
        if (d7 == 0.0) {
            return d9 * d8 < 0.0;
        }
        d9 /= d7;
        d8 /= d7;
        if (DEBUG) {
            System.out.println("#...Einter: t^2 + 2.*" + d9 + "*t + " + d8 + ")");
        }
        if ((d = d9 * d9 - d8) <= 0.0) {
            return false;
        }
        if (d9 < 0.0) {
            return true;
        }
        return d8 < 0.0;
    }

    @Override
    public int checkCircle(Coo coo, double d) {
        if (this.centroid == null) {
            return 0;
        }
        if (DEBUG) {
            System.out.println("#...Ellipse.checkCoo(" + coo + ")");
        }
        Coo coo2 = new Coo(coo);
        double d2 = (coo.distance(this.f0) + coo.distance(this.f1)) / 2.0;
        if (d2 - d >= this.a) {
            return 0;
        }
        if (d2 + d <= this.a) {
            return -1;
        }
        return 1;
    }

    @Override
    public int checkQbox(int n) {
        if (this.centroid == null) {
            return 0;
        }
        Qbox qbox = new Qbox();
        qbox.set(n);
        int n2 = this.checkCircle(qbox.center(), Qbox.maxRadius(n));
        if (n2 < 1) {
            return n2;
        }
        double[][] dArray = new double[5][3];
        Qbox.ucorners(qbox.qbox, dArray);
        int n3 = 0;
        int n4 = 0;
        Coo coo = new Coo();
        for (n2 = 0; n2 < 4; ++n2) {
            coo.set(dArray[n2][0], dArray[n2][1], dArray[n2][2]);
            if (this.checkCoo(coo)) {
                ++n3;
                continue;
            }
            ++n4;
        }
        if (n3 == 4) {
            return -1;
        }
        if (n3 > 0) {
            return 1;
        }
        dArray[4][0] = dArray[0][0];
        dArray[4][1] = dArray[0][1];
        dArray[4][2] = dArray[0][2];
        for (n2 = 0; n2 < 4; ++n2) {
            if (!this.intersects(dArray[n2], dArray[n2 + 1])) continue;
            return 1;
        }
        return qbox.inside(this.centroid) ? 3 : 0;
    }
}

