/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.FK5;

public class Ecliptic
extends Astroframe {
    static final char letterIAU = 'E';
    protected double equinox;
    protected double[] toJ2000;
    static final double[] toJ2000rot = AstroMath.rotation("sx", 84381.448);
    static final double[] fromJ2000rot = AstroMath.rot_inv(toJ2000rot);

    public static double[] Jmatrix(double d) {
        double d2 = (d - 2000.0) / 100.0;
        double d3 = 84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * d2) * d2) * d2;
        double[] dArray = AstroMath.rotation("x", -(d3 /= 3600.0));
        if (d != 2000.0) {
            dArray = AstroMath.m3p(dArray, FK5.precessionMatrix(2000.0, d));
        }
        return dArray;
    }

    public static Ecliptic scan(double d, double d2) {
        if (DEBUG) {
            System.out.println("#...Ecliptic.scan(" + d + ", " + d2 + ")");
        }
        if (fixedFrames == null) {
            return null;
        }
        for (Object e : fixedFrames) {
            if (!(e instanceof Ecliptic)) continue;
            Ecliptic ecliptic = (Ecliptic)e;
            if ((ecliptic.fixed & 0xF) != 0 || ecliptic.equinox != d || !(Math.abs(ecliptic.epoch - d2) < 3.0E-8)) continue;
            return ecliptic;
        }
        return null;
    }

    public static Ecliptic create(double d, double d2) {
        Ecliptic ecliptic = Ecliptic.scan(d, d2);
        if (ecliptic == null) {
            ecliptic = new Ecliptic(d, d2);
            ecliptic.fixFrame();
        }
        return ecliptic;
    }

    public static Ecliptic create(double d) {
        return Ecliptic.create(d, d);
    }

    public static Ecliptic create() {
        return Ecliptic.create(2000.0, 2000.0);
    }

    public Ecliptic(double d, double d2) {
        if (Double.isNaN(d2)) {
            d2 = d;
        }
        this.precision = (byte)8;
        this.equinox = d;
        this.epoch = d2;
        this.name = "Ecl(J" + d + ")";
        this.full_name = this.name.substring(0, this.name.length() - 1) + ",Ep=J" + d2 + ")";
        this.toJ2000 = AstroMath.transposed(Ecliptic.Jmatrix(d));
        this.toICRSmatrix = AstroMath.m36p(FK5.toICRSbase, this.toJ2000);
        this.fromICRSmatrix = AstroMath.rot_inv(this.toICRSmatrix);
        Ecliptic.compute_dotMatrix(this);
    }

    public static Ecliptic Gaia2() {
        String string = "Ecliptic-Gaia2";
        Ecliptic ecliptic = (Ecliptic)Ecliptic.getFrame(string);
        if (ecliptic == null) {
            ecliptic = new Ecliptic(2000.0, 2015.5);
            ecliptic.toICRSmatrix = toJ2000rot;
            ecliptic.fromICRSmatrix = AstroMath.rot_inv(toJ2000rot);
            ecliptic.fixed = (byte)(ecliptic.fixed | 1);
            ecliptic.precision = (byte)9;
            ecliptic.name = ecliptic.full_name = string;
            ecliptic.fixFrame(string);
        }
        return ecliptic;
    }

    public static Ecliptic Hipparcos() {
        String string = "Ecliptic-Hip";
        Ecliptic ecliptic = (Ecliptic)Ecliptic.getFrame(string);
        if (ecliptic == null) {
            ecliptic = new Ecliptic(2000.0, 1991.25);
            ecliptic.toICRSmatrix = toJ2000rot;
            ecliptic.fromICRSmatrix = AstroMath.rot_inv(toJ2000rot);
            ecliptic.fixed = (byte)(ecliptic.fixed | 1);
            ecliptic.precision = (byte)9;
            ecliptic.name = ecliptic.full_name = string;
            ecliptic.fixFrame(string);
        }
        return ecliptic;
    }

    public double getEquinox() {
        return this.equinox;
    }
}

