/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Editing;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Coo
implements Serializable,
Cloneable {
    protected static boolean DEBUG = false;
    public double x;
    public double y;
    public double z;
    protected double lon;
    protected double lat;
    public static Editing ed = new Editing("--");
    public static int decimals = -10;
    public static final double[] U3matrix = AstroMath.U3matrix;

    public Coo() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.lon = Double.NaN;
        this.lat = Double.NaN;
    }

    public Coo(Coo coo) {
        this.x = coo.x;
        this.y = coo.y;
        this.z = coo.z;
        this.lon = Double.NaN;
        this.lat = Double.NaN;
    }

    public Coo(double d, double d2) {
        this.set(d, d2);
    }

    public Coo(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Coo(String string) throws ParseException {
        this.set(string);
    }

    public Object clone() {
        Coo coo;
        block2: {
            coo = null;
            try {
                coo = (Coo)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return coo;
    }

    protected void computeLonLat() {
        double d = this.x * this.x + this.y * this.y;
        this.lon = 0.0;
        if (d == 0.0) {
            if (this.z == 0.0) {
                this.lon = Double.NaN;
                this.lat = Double.NaN;
            } else {
                this.lat = this.z > 0.0 ? 90.0 : -90.0;
            }
        } else {
            this.lon = AstroMath.atan2d(this.y, this.x);
            this.lat = AstroMath.atan2d(this.z, Math.sqrt(d));
            if (this.lon < 0.0) {
                this.lon += 360.0;
            }
        }
    }

    public void set() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.lon = Double.NaN;
        this.lat = Double.NaN;
    }

    public void set(Coo coo) {
        this.x = coo.x;
        this.y = coo.y;
        this.z = coo.z;
        this.lon = coo.lon;
        this.lat = coo.lat;
    }

    public static final void setUvec(double d, double d2, double[] dArray) {
        dArray[0] = dArray[1] = AstroMath.cosd(d2);
        dArray[0] = dArray[0] * AstroMath.cosd(d);
        dArray[1] = dArray[1] * AstroMath.sind(d);
        dArray[2] = AstroMath.sind(d2);
        if (Double.isNaN(dArray[0])) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
    }

    public void set(double d, double d2) {
        double d3 = AstroMath.cosd(d2);
        this.lon = d;
        this.lat = d2;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            this.set();
            return;
        }
        this.x = d3 * AstroMath.cosd(d);
        this.y = d3 * AstroMath.sind(d);
        this.z = AstroMath.sind(d2);
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        }
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        this.computeLonLat();
    }

    public static Coo perpendicular(Coo coo, Coo coo2) {
        double[] dArray = new double[3];
        coo.vecprod(coo2, dArray);
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d < 1.0E-15) {
            return new Coo();
        }
        return new Coo(dArray[0] / d, dArray[1] / d, dArray[2] / d);
    }

    public boolean parsing(Parsing parsing) {
        boolean bl = false;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        parsing.gobbleSpaces();
        this.lon = parsing.parseSexa2();
        if (parsing.inError()) {
            return false;
        }
        if (parsing.isTime()) {
            bl = true;
        } else if (parsing.isAngle()) {
            bl = false;
        }
        if (bl) {
            this.lon *= 15.0;
        }
        parsing.gobbleSpaces();
        if (parsing.currentChar() == ',') {
            parsing.advance(1);
            parsing.gobbleSpaces();
        }
        this.lat = parsing.parseSexa();
        if (parsing.inError()) {
            return false;
        }
        this.set(this.lon, this.lat);
        return true;
    }

    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        return this.parsing(parsing) ? parsing.pos : n;
    }

    public void set(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        if (!this.parsing(parsing)) {
            throw new ParseException("[Coo.set]: component larger than 60 in: " + string, parsing.pos);
        }
        parsing.gobbleSpaces();
        if (parsing.pos < parsing.length) {
            throw new ParseException("[Coo.set]: '" + string + "'+" + parsing.pos, parsing.pos);
        }
        this.set(this.lon, this.lat);
    }

    public double getLon() {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        return this.lon;
    }

    public double getLat() {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        return this.lat;
    }

    public void copyAngles(double[] dArray) {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        dArray[0] = this.lon;
        dArray[1] = this.lat;
    }

    public void copyUvector(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
    }

    public static final double distance(double d, double d2, double d3, double d4) {
        double d5 = AstroMath.cosd(d2);
        double d6 = AstroMath.cosd(d4);
        double d7 = d5 * AstroMath.cosd(d) - d6 * AstroMath.cosd(d3);
        double d8 = d7 * d7;
        d7 = d5 * AstroMath.sind(d) - d6 * AstroMath.sind(d3);
        d8 += d7 * d7;
        d7 = AstroMath.sind(d2) - AstroMath.sind(d4);
        return 2.0 * AstroMath.asind(0.5 * Math.sqrt(d8 += d7 * d7));
    }

    public final double dist2(Coo coo) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        if (coo.x == 0.0 && coo.y == 0.0 && coo.z == 0.0) {
            return Double.NaN;
        }
        double d = coo.x - this.x;
        double d2 = d * d;
        d = coo.y - this.y;
        d2 += d * d;
        d = coo.z - this.z;
        return d2 += d * d;
    }

    public final double dist2(double[] dArray) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return Double.NaN;
        }
        double d = dArray[0] - this.x;
        double d2 = d * d;
        d = dArray[1] - this.y;
        d2 += d * d;
        d = dArray[2] - this.z;
        return d2 += d * d;
    }

    public static final double dist2(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = d * d;
        d = dArray[1] - dArray2[1];
        d2 += d * d;
        d = dArray[2] - dArray2[2];
        return d2 += d * d;
    }

    public final double distance(Coo coo) {
        if (coo.x == 0.0 && coo.y == 0.0 && coo.z == 0.0) {
            return Double.NaN;
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        return 2.0 * AstroMath.asind(0.5 * Math.sqrt(this.dist2(coo)));
    }

    public final double distc(Coo coo, Coo coo2) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        double[] dArray = new double[3];
        coo.vecprod(coo2, dArray);
        double d = Coo.normalize(dArray);
        if (d > 0.0) {
            return AstroMath.asind(Math.abs(this.dotprod(dArray)));
        }
        return Double.NaN;
    }

    public final double angle(Coo coo, Coo coo2) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        this.vecprod(coo, dArray);
        Coo.normalize(dArray);
        this.vecprod(coo2, dArray2);
        Coo.normalize(dArray2);
        return 90.0 - AstroMath.asind(Coo.dotprod(dArray, dArray2));
    }

    public final double posAngle(Coo coo) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        double d = coo.z * (this.x * this.x + this.y * this.y) - this.z * (this.x * coo.x + this.y * coo.y);
        double d2 = this.x * coo.y - this.y * coo.x;
        double d3 = 90.0 - AstroMath.atan2d(d, d2);
        if (d3 < 0.0) {
            d3 += 360.0;
        }
        return d3;
    }

    public static final double dotprod(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    public final double dotprod(double[] dArray) {
        return this.x * dArray[0] + this.y * dArray[1] + this.z * dArray[2];
    }

    public final double dotprod(Coo coo) {
        return this.x * coo.x + this.y * coo.y + this.z * coo.z;
    }

    public static final double norm2(double[] dArray) {
        return Coo.dotprod(dArray, dArray);
    }

    public static final void vecprod(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }

    public final void vecprod(double[] dArray, double[] dArray2) {
        dArray2[0] = this.y * dArray[2] - this.z * dArray[1];
        dArray2[1] = this.z * dArray[0] - this.x * dArray[2];
        dArray2[2] = this.x * dArray[1] - this.y * dArray[0];
    }

    public final void vecprod(Coo coo, double[] dArray) {
        dArray[0] = this.y * coo.z - this.z * coo.y;
        dArray[1] = this.z * coo.x - this.x * coo.z;
        dArray[2] = this.x * coo.y - this.y * coo.x;
    }

    static double det(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[3];
        Coo.vecprod(dArray, dArray2, dArray4);
        return Coo.dotprod(dArray4, dArray3);
    }

    public static final void rotateVector(double[] dArray, double[] dArray2) {
        if (dArray == AstroMath.U3matrix) {
            return;
        }
        for (int i = 0; i < dArray2.length; i += 3) {
            double d = dArray2[i];
            double d2 = dArray2[i + 1];
            double d3 = dArray2[i + 2];
            dArray2[i + 0] = dArray[0] * d + dArray[1] * d2 + dArray[2] * d3;
            dArray2[i + 1] = dArray[3] * d + dArray[4] * d2 + dArray[5] * d3;
            dArray2[i + 2] = dArray[6] * d + dArray[7] * d2 + dArray[8] * d3;
        }
    }

    public static final void rotateVector_1(double[] dArray, double[] dArray2) {
        if (dArray == AstroMath.U3matrix) {
            return;
        }
        for (int i = 0; i < dArray2.length; i += 3) {
            double d = dArray2[i];
            double d2 = dArray2[i + 1];
            double d3 = dArray2[i + 2];
            dArray2[i + 0] = dArray[0] * d + dArray[3] * d2 + dArray[6] * d3;
            dArray2[i + 1] = dArray[1] * d + dArray[4] * d2 + dArray[7] * d3;
            dArray2[i + 2] = dArray[2] * d + dArray[5] * d2 + dArray[8] * d3;
        }
    }

    public void rotate(double[] dArray) {
        if (dArray == AstroMath.U3matrix) {
            return;
        }
        double d = dArray[0] * this.x + dArray[1] * this.y + dArray[2] * this.z;
        double d2 = dArray[3] * this.x + dArray[4] * this.y + dArray[5] * this.z;
        double d3 = dArray[6] * this.x + dArray[7] * this.y + dArray[8] * this.z;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public void rotate_1(double[] dArray) {
        if (dArray == AstroMath.U3matrix) {
            return;
        }
        double d = dArray[0] * this.x + dArray[3] * this.y + dArray[6] * this.z;
        double d2 = dArray[1] * this.x + dArray[4] * this.y + dArray[7] * this.z;
        double d3 = dArray[2] * this.x + dArray[5] * this.y + dArray[8] * this.z;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public static double[] eulerMatrix(double d, double d2, double d3) {
        return AstroMath.rotation("zyz", d, -d2, d3);
    }

    public static final double[] localMatrix(double d, double d2) {
        double[] dArray = new double[9];
        dArray[8] = AstroMath.cosd(d2);
        dArray[2] = AstroMath.sind(d2);
        dArray[4] = AstroMath.cosd(d);
        dArray[3] = -AstroMath.sind(d);
        dArray[5] = 0.0;
        dArray[0] = dArray[8] * dArray[4];
        dArray[1] = -dArray[8] * dArray[3];
        dArray[6] = -dArray[2] * dArray[4];
        dArray[7] = dArray[2] * dArray[3];
        return dArray;
    }

    public final double localMatrix(double[] dArray) {
        double d = Math.hypot(this.x, this.y);
        double d2 = Math.hypot(d, this.z);
        if (d2 == 0.0) {
            System.arraycopy(AstroMath.U3matrix, 0, dArray, 0, 9);
        } else {
            dArray[0] = this.x / d2;
            dArray[1] = this.y / d2;
            dArray[2] = this.z / d2;
            dArray[3] = 0.0;
            dArray[4] = 1.0;
            dArray[5] = 0.0;
            dArray[8] = d / d2;
            if (dArray[8] != 0.0) {
                dArray[3] = -dArray[1] / dArray[8];
                dArray[4] = dArray[0] / dArray[8];
            }
            dArray[6] = -dArray[2] * dArray[4];
            dArray[7] = dArray[2] * dArray[3];
        }
        return d2;
    }

    public final double[] localMatrix() {
        double[] dArray = new double[9];
        this.localMatrix(dArray);
        return dArray;
    }

    public final double[] rotate2Matrix(Coo coo) {
        double[] dArray = new double[9];
        double[] dArray2 = this.localMatrix();
        double[] dArray3 = coo.localMatrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[3 * i + j] = dArray3[i + 0] * dArray2[j + 0] + dArray3[i + 3] * dArray2[j + 3] + dArray3[i + 6] * dArray2[j + 6];
            }
        }
        return dArray;
    }

    public static final double normalize(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d > 0.0) {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
        return d;
    }

    public double normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d > 0.0) {
            d = Math.sqrt(d);
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }
        return d;
    }

    public static final double add(double[] dArray, double[] dArray2) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d == 0.0) {
            return d;
        }
        double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2];
        double d3 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d4 = Math.sqrt(1.0 + (2.0 / d * d3 + d2));
        dArray[0] = (dArray[0] + d * dArray2[0]) / d4;
        dArray[1] = (dArray[1] + d * dArray2[1]) / d4;
        dArray[2] = (dArray[2] + d * dArray2[2]) / d4;
        return d;
    }

    public static final double sub(double[] dArray, double[] dArray2) {
        double d;
        if (DEBUG) {
            System.out.print(" [Coo.sub(Eterm)] ");
        }
        if ((d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2])) == 0.0) {
            return d;
        }
        double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2];
        double d3 = (dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2]) / d;
        double d4 = d3 + Math.sqrt(1.0 + (d3 * d3 - d2));
        dArray[0] = d4 * dArray[0] - d * dArray2[0];
        dArray[1] = d4 * dArray[1] - d * dArray2[1];
        dArray[2] = d4 * dArray[2] - d * dArray2[2];
        return d;
    }

    public final double add(double[] dArray) {
        if (DEBUG) {
            System.out.print(" [Coo.add(Eterm)] ");
        }
        double[] dArray2 = new double[]{this.x, this.y, this.z};
        double d = Coo.add(dArray2, dArray);
        this.x = dArray2[0];
        this.y = dArray2[1];
        this.z = dArray2[2];
        this.lon = Double.NaN;
        this.lat = Double.NaN;
        return d;
    }

    public final double sub(double[] dArray) {
        double[] dArray2 = new double[]{this.x, this.y, this.z};
        double d = Coo.sub(dArray2, dArray);
        this.x = dArray2[0];
        this.y = dArray2[1];
        this.z = dArray2[2];
        this.lon = Double.NaN;
        this.lat = Double.NaN;
        return d;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Coo) {
            Coo coo = (Coo)object;
            bl = coo.x == this.x && coo.y == this.y && coo.z == this.z;
        }
        return bl;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 123 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 123 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public final StringBuffer editCoo(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        ed.editDecimal(stringBuffer, this.lon, 3, n, 32);
        if (stringBuffer.charAt(n2) == '3' && stringBuffer.charAt(n2 + 1) == '6') {
            String string = stringBuffer.substring(n2 + 2);
            stringBuffer.setLength(n2);
            stringBuffer.append("00");
            stringBuffer.append(string);
        }
        ed.editDecimal(stringBuffer, this.lat, 3, n, 48);
        return stringBuffer;
    }

    public StringBuffer edit(StringBuffer stringBuffer, int n) {
        return this.editCoo(stringBuffer, n);
    }

    public static int setDecimals(int n) {
        int n2 = decimals;
        decimals = n;
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.editCoo(stringBuffer, decimals);
        return stringBuffer.toString();
    }

    private static final StringBuffer ed3(StringBuffer stringBuffer, double[] dArray, int n) {
        ed.editDecimal(stringBuffer, dArray[n + 0], 2, 15, 16);
        stringBuffer.append(' ');
        ed.editDecimal(stringBuffer, dArray[n + 1], 2, 15, 16);
        stringBuffer.append(' ');
        ed.editDecimal(stringBuffer, dArray[n + 2], 2, 15, 16);
        return stringBuffer;
    }

    protected static final String toString(double[] dArray) {
        return Coo.toString("", dArray);
    }

    protected static final String toString(String string, double[] dArray) {
        int n;
        int n2;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = null;
        boolean bl2 = string.endsWith("\n");
        boolean bl3 = bl = dArray.length == 18;
        if (dArray == null) {
            if (bl2) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append(" (null)");
            if (bl2) {
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        int n3 = dArray.length;
        if (bl2) {
            stringBuffer2 = new StringBuffer("    ");
            stringBuffer.append(stringBuffer2);
        } else if (n3 > 6) {
            bl2 = true;
            n2 = string.length();
            stringBuffer2 = new StringBuffer(n2);
            for (n = 0; n < n2; ++n) {
                stringBuffer2.append(' ');
            }
        }
        if (n3 == 9) {
            n3 = 3;
        } else if (n3 > 9) {
            n3 = n3 > 18 ? 6 : 3;
        }
        n2 = n3 > 3 ? 1 : 0;
        for (n = 0; !(n >= dArray.length || bl && n >= 9); n += n3) {
            int n4;
            if (n > 0) {
                n4 = stringBuffer.length() - 1;
                while (stringBuffer.charAt(n4) == ' ') {
                    stringBuffer.setLength(n4--);
                }
                stringBuffer.append('\n');
                stringBuffer.append(stringBuffer2);
            }
            int n5 = bl ? 9 : 0;
            for (int i = 0; i <= n5; i += 9) {
                if (i > 0) {
                    stringBuffer.append("; ");
                }
                for (int j = 0; j < n3; ++j) {
                    n4 = stringBuffer.length() + 23;
                    double d = dArray[i + n + j];
                    double d2 = Math.abs(d);
                    if (d >= 0.0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(d);
                    n4 -= stringBuffer.length();
                    while (n4 > 0) {
                        stringBuffer.append(' ');
                        --n4;
                    }
                    stringBuffer.append(' ');
                }
            }
        }
        if (bl2) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void dump(String string) {
        String string2 = string.charAt(0) == '#' ? "#   " : "    ";
        System.out.print(string);
        if (string.endsWith("\n")) {
            System.out.print(string2);
        }
        System.out.println("x=" + this.x + " y=" + this.y + " z=" + this.z + "\t; lon=" + this.lon + " lat=" + this.lat);
    }
}

