/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.Astroformat;
import cds.astro.Astroframe;
import cds.astro.FK4;
import cds.astro.ICRS;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;

public class Astropos
extends Astrocoo
implements Serializable {
    static boolean DEBUG = false;
    protected double xd;
    protected double yd;
    protected double zd;
    private double[] R;
    protected double mu0;
    protected double mu1;
    protected double mu2;
    protected double meanEp;
    public double plx;
    public double rv;
    public double e_plx;
    public double e_rv;
    private static final short HASpos = 1;
    private static final short HASpm = 2;
    private static final short HASplx = 4;
    private static final short HASrv = 8;
    private static final short HASepos = 16;
    private static final short HASepm = 32;
    private static final short HASeplx = 64;
    private static final short HAServ = 128;
    private static final short HAScorr = 256;
    private static final short HASep = 512;
    private static final short HASmep = 1024;
    private static final short HASerr = 112;
    private short permanent;
    private short specified;
    private short estimated;
    protected byte errorprec = 0;
    private byte ready = 0;
    private static String[] partnames = new String[]{"pos", "pm", "plx", "rv", "e_pos", "e_pm", "e_plx", "e_rv", "corr", "Ep", "mEp"};
    protected double[] cov = null;
    protected double[] sig5corr = null;
    private static double[] def_err = new double[]{6.48E8, 4320000.0, 540000.0, 126000.0, 12600.0, 2100.0, 210.0, 21.0, 2.1, 0.21000000000000002, 0.021, 0.0021000000000000003, 2.1E-4, 2.1000000000000002E-5, 2.1000000000000002E-6, 2.1E-7};
    static final int[] sym6index = new int[]{0, 6, 7, 6, 1, 11, 7, 11, 2, 8, 9, 10, 12, 13, 14, 15, 16, 17, 3, 18, 19, 18, 4, 20, 19, 20, 5};
    public static final double PMtoVEL = 4.740470446;
    public static final String[] unitsymb = new String[]{"mas", "arcsec", "\"", "uas", "km/s", "\u00b5as", "\u03bcas", "m/s", "nas"};
    public static final double[] unit2mas = new double[]{1.0, 1000.0, 1000.0, 0.001, 1.0, 0.001, 0.001, 0.001, 1.0E-6};
    public static final String[] datasymb = new String[]{"pm=", "\u00b5=", "\u03bc=", "plx=", "\u03d6=", "\u03c0=", "Vr=", "rv=", "RV=", "sigma=", "err=", "\u03c3=", "corr=", "cor=", "\u03c1=", "Ep=", "Epoch=", "epoch=", "meanEp=", "mean="};
    public static final short[] datatype = new short[]{2, 2, 2, 4, 4, 4, 8, 8, 8, 112, 112, 112, 256, 256, 256, 512, 512, 512, 1024, 1024};
    public static final double MAS2 = 4.25451702961522E16;

    private static final void tr3(double[] dArray) {
        double d = dArray[1];
        dArray[1] = dArray[3];
        dArray[3] = d;
        d = dArray[2];
        dArray[2] = dArray[6];
        dArray[6] = d;
        d = dArray[5];
        dArray[5] = dArray[7];
        dArray[7] = d;
    }

    private final void rot2local(double[] dArray, double[] dArray2) {
        dArray2[0] = this.R[0] * dArray[0] + this.R[1] * dArray[1] + this.R[2] * dArray[2];
        dArray2[1] = this.R[3] * dArray[0] + this.R[4] * dArray[1];
        dArray2[2] = this.R[6] * dArray[0] + this.R[7] * dArray[1] + this.R[8] * dArray[2];
    }

    private final void rot2fixed(double[] dArray, double[] dArray2) {
        dArray2[0] = this.R[0] * dArray[0] + this.R[3] * dArray[1] + this.R[6] * dArray[2];
        dArray2[1] = this.R[1] * dArray[0] + this.R[4] * dArray[1] + this.R[7] * dArray[2];
        dArray2[2] = this.R[2] * dArray[0] + this.R[8] * dArray[2];
    }

    private static final void rotate_cov(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray2 == null) {
            return;
        }
        double[] dArray4 = new double[9];
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2 = i * 9;
            for (n = 0; n < 9; ++n) {
                dArray4[n] = dArray2[sym6index[n2 + n]];
            }
            boolean bl = (i & 1) == 0;
            int n3 = 0;
            for (n = 0; n < 9; n += 3) {
                int n4 = 0;
                while (n4 < 9) {
                    if (!bl || n4 >= n) {
                        double d = 0.0;
                        int n5 = 0;
                        for (int j = 0; j < 3; ++j) {
                            for (int k = 0; k < 3; ++k) {
                                d += dArray[n + j] * dArray[n4 + k] * dArray4[n5++];
                            }
                        }
                        dArray3[Astropos.sym6index[n2 + n3]] = d;
                    }
                    n4 += 3;
                    ++n3;
                }
            }
        }
    }

    public final double getVariance(int n, int n2) {
        int n3;
        if (this.ready == 0 || this.R == null) {
            return Double.NaN;
        }
        if (this.cov == null) {
            return 0.0;
        }
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        int n4 = n;
        int n5 = n2;
        double d = 0.0;
        if ((this.ready & 0x20) != 0 && n > 0 && n2 > 0) {
            d = this.sig5corr[--n4] * this.sig5corr[--n5];
            if (n4 != n5) {
                d *= this.sig5corr[AstroMath.symIndex(5, n4, n5)];
                if (n4 == 2 || n5 == 2) {
                    d *= this.rv / 4.740470446;
                }
            } else if (n4 == 2) {
                double d2 = this.rv / 4.740470446;
                double d3 = this.e_rv / 4.740470446;
                d3 *= d3;
                d = d * (d3 + d2 * d2) + this.plx * this.plx * d3;
            }
            if (DEBUG && n == n2 && d < 0.0) {
                System.out.println("#+++Astropos.getVariance[loc](" + n + "," + n2 + ") => " + d);
            }
            return d;
        }
        if (n4 > n5) {
            n4 = n2;
            n5 = n;
        }
        if ((n3 = n4 / 3 << 1 | n5 / 3) >= 2) {
            --n3;
        }
        int n6 = 9 * n3;
        n4 = 3 * (n4 % 3);
        n5 = 3 * (n5 % 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                d += this.R[n4 + i] * this.R[n5 + j] * this.cov[sym6index[n6++]];
            }
        }
        d *= 4.25451702961522E16;
        if (DEBUG && n == n2 && d < 0.0) {
            System.out.println("#+++Astropos.getVariance[fix](" + n + "," + n2 + ") => " + d);
        }
        return d;
    }

    private static final void propagate_error(double[] dArray, double d) {
        int n;
        double[] dArray2 = null;
        if (DEBUG) {
            dArray2 = AstroMath.mpt(AstroMath.motionMatrix(d), dArray);
        }
        double d2 = 0.5 * d * d;
        for (n = 0; n < 9; ++n) {
            int n2 = sym6index[9 + n];
            dArray[n2] = dArray[n2] + d * dArray[sym6index[18 + n]];
        }
        for (n = 0; n < 9; ++n) {
            int n3 = sym6index[n];
            double d3 = d * dArray[sym6index[9 + n]] - d2 * dArray[sym6index[18 + n]];
            if (n3 < 3) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + 2.0 * d3;
                continue;
            }
            int n5 = n3;
            dArray[n5] = dArray[n5] + d3;
        }
    }

    private static final void rot6(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 3; ++i) {
            int n = 3 * i;
            dArray3[i] = dArray[n] * dArray2[0] + dArray[n + 1] * dArray2[1] + dArray[n + 2] * dArray2[2];
            dArray3[i + 3] = dArray[n] * dArray2[3] + dArray[n + 1] * dArray2[4] + dArray[n + 2] * dArray2[5];
        }
    }

    @Override
    public double normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d <= 0.0) {
            return d;
        }
        if (d == 1.0) {
            return d;
        }
        if (DEBUG) {
            System.out.print("#...calling normalize: r\u00b2=" + d);
        }
        if ((this.specified & 0x70) != 0) {
            int n = 0;
            while (n < this.cov.length) {
                int n2 = n++;
                this.cov[n2] = this.cov[n2] / d;
            }
        }
        d = Math.sqrt(d);
        if (DEBUG) {
            System.out.println(", r=" + d);
        }
        this.x /= d;
        this.y /= d;
        this.z /= d;
        this.xd /= d;
        this.yd /= d;
        this.zd /= d;
        this.plx /= d;
        this.e_plx /= d;
        return d;
    }

    public static final void varianceToErrorEllipse(double[] dArray, double[] dArray2) {
        double d = dArray[1] - dArray[0];
        double d2 = dArray[2] * dArray[2];
        if (d2 < 1.0E-12 * dArray[0] * dArray[1]) {
            if (d > 0.0) {
                dArray2[0] = dArray[1];
                dArray2[1] = dArray[0];
                dArray2[2] = 0.0;
            } else {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = 90.0;
            }
        } else {
            double d3 = Math.sqrt(d * d + 4.0 * d2);
            dArray2[0] = 0.5 * (dArray[0] + dArray[1] + d3);
            dArray2[1] = 0.5 * (dArray[0] + dArray[1] - d3);
            dArray2[2] = 0.5 * AstroMath.atan2d(2.0 * dArray[2], d);
            if (dArray2[2] < 0.0) {
                dArray2[2] = dArray2[2] + 180.0;
            }
        }
        dArray2[0] = dArray2[0] > 0.0 ? Math.sqrt(dArray2[0]) : 0.0;
        dArray2[1] = dArray2[1] > 0.0 ? Math.sqrt(dArray2[1]) : 0.0;
    }

    public static final void errorEllipseToVariance(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray[0];
        double d2 = dArray[1] * dArray[1];
        double d3 = AstroMath.cosd(dArray[2]);
        double d4 = AstroMath.sind(dArray[2]);
        dArray2[0] = d * d4 * d4 + d2 * d3 * d3;
        dArray2[1] = d * d3 * d3 + d2 * d4 * d4;
        dArray2[2] = d3 * d4 * (d - d2);
    }

    public static boolean parseErrorEllipse(Parsing parsing, double[] dArray) {
        dArray[1] = Double.NaN;
        dArray[0] = Double.NaN;
        dArray[2] = 90.0;
        boolean bl = parsing.match('[');
        parsing.gobbleSpaces();
        int n = parsing.parseArray(dArray);
        if (bl) {
            parsing.gobbleSpaces();
            if (!parsing.match(']')) {
                return false;
            }
        }
        if (n == 0) {
            return false;
        }
        if (Double.isNaN(dArray[2])) {
            dArray[2] = 90.0;
        }
        if (Double.isNaN(dArray[1])) {
            dArray[1] = dArray[0];
        }
        return true;
    }

    private final void compute_fix() {
        int n;
        int n2;
        if ((this.ready & 1) != 0) {
            return;
        }
        if (this.R == null) {
            this.R = new double[9];
        }
        if (Double.isNaN(this.epoch)) {
            this.epoch = this.frame.epoch;
        }
        if (Double.isNaN(this.meanEp)) {
            this.meanEp = this.epoch;
        }
        if (this.sig5corr == null) {
            this.sig5corr = new double[15];
        }
        if (DEBUG) {
            this.dump("<<compute_fix: ");
        }
        if ((this.specified & 4) == 0) {
            this.plx = 0.0;
            this.e_plx = 0.0;
            this.estimated = (short)(this.estimated | 0x44);
        } else if (this.plx < 0.0) {
            this.plx = 0.0;
        }
        if (Double.isNaN(this.e_plx)) {
            this.e_plx = 0.0;
            this.estimated = (short)(this.estimated | 0x40);
        }
        if ((this.specified & 8) == 0) {
            this.rv = 0.0;
            this.e_rv = 0.0;
            this.estimated = (short)(this.estimated | 0x88);
        }
        if ((this.specified & 0xC) == 12) {
            this.mu0 = this.plx * this.rv / 4.740470446;
            if (DEBUG) {
                System.out.println("#...compute_fix: \u00b50=" + this.mu0 + ", \u00b51=" + this.mu1 + ", \u00b52=" + this.mu2);
            }
        } else {
            this.mu0 = 0.0;
        }
        if ((this.specified & 2) != 0) {
            this.xd = (this.R[0] * this.mu0 + this.R[3] * this.mu1 + this.R[6] * this.mu2) / 2.0626480624709636E8;
            this.yd = (this.R[1] * this.mu0 + this.R[4] * this.mu1 + this.R[7] * this.mu2) / 2.0626480624709636E8;
            this.zd = (this.R[2] * this.mu0 + this.R[5] * this.mu1 + this.R[8] * this.mu2) / 2.0626480624709636E8;
        }
        if ((this.specified & 0x10) == 0 && this.dlon > 0 && this.dlat > 0) {
            n2 = this.dlon;
            if (n2 >= def_err.length) {
                n2 = def_err.length - 1;
            }
            if ((n = this.dlat) >= def_err.length) {
                n = def_err.length - 1;
            }
            this.estimated = (short)(this.estimated | 0x10);
            this.setErrorEllipse(def_err[n2] * this.R[8], def_err[n], 90.0, Double.NaN);
        }
        if ((this.specified & 0x70) != 0) {
            if (DEBUG) {
                AstroMath.printMatrix("#   sig5cov(local), specified=0x" + Integer.toHexString(this.specified) + ", estimated=" + Integer.toHexString(this.estimated) + "\n", this.sig5corr);
            }
            double d = this.sig5corr[2] = Double.isNaN(this.e_plx) ? 0.0 : this.e_plx;
            if (this.cov == null) {
                this.cov = new double[21];
            }
            this.cov[10] = 0.0;
            this.cov[9] = 0.0;
            this.cov[8] = 0.0;
            this.cov[7] = 0.0;
            this.cov[6] = 0.0;
            this.cov[0] = 0.0;
            int n3 = 5;
            for (n2 = 0; n2 < 5; ++n2) {
                this.cov[n2 + 1] = this.sig5corr[n2] * this.sig5corr[n2] / 4.25451702961522E16;
                n = n2 + 1;
                while (n < 5) {
                    this.cov[6 + n3] = this.sig5corr[n3] * this.sig5corr[n2] * this.sig5corr[n] / 4.25451702961522E16;
                    ++n;
                    ++n3;
                }
            }
            if (DEBUG) {
                System.out.print("#...Compute correlations: \u03d6=" + this.plx + "+/-" + this.e_plx + ", Vr=" + this.rv + "+/-" + this.e_rv);
            }
            double d2 = this.rv / 4.740470446;
            double d3 = Double.isNaN(this.e_rv) ? 0.0 : this.e_rv / 4.740470446;
            double d4 = this.sig5corr[2] * this.sig5corr[2];
            double d5 = d3 * d3;
            this.cov[3] = (d4 * d5 + d4 * d2 * d2 + d5 * this.plx * this.plx) / 4.25451702961522E16;
            if (DEBUG) {
                System.out.print(", \u03c3(\u00b50)=" + Math.sqrt(this.cov[3]));
            }
            if ((this.specified & 0x100) != 0) {
                this.cov[12] = this.cov[12] * d2;
                this.cov[15] = this.cov[15] * d2;
                this.cov[18] = this.cov[18] * d2;
                this.cov[19] = this.cov[19] * d2;
            }
            if (DEBUG) {
                AstroMath.printMatrix("#   cov6(0), rad\n", this.cov);
            }
            if (this.epoch != this.meanEp && (this.specified & 0x410) == 1040) {
                Astropos.propagate_error(this.cov, this.epoch - this.meanEp);
                if (DEBUG) {
                    AstroMath.printMatrix("#   cov6(t), rad\n", this.cov);
                }
            }
            Astropos.tr3(this.R);
            Astropos.rotate_cov(this.R, this.cov, this.cov);
            Astropos.tr3(this.R);
            if (DEBUG) {
                AstroMath.printMatrix("#   cov6(1), after rotate_cov:\n", this.cov);
            }
        }
        this.ready = 1;
        if (DEBUG) {
            this.dump(" >compute_fix: ");
        }
    }

    private final void compute_loc() {
        if ((this.ready & 0x10) != 0) {
            return;
        }
        if (this.ready == 0) {
            this.compute_fix();
        }
        if (DEBUG) {
            System.out.println("#...compute_loc: mu was " + this.mu0 + ", " + this.mu1 + ", " + this.mu2);
        }
        this.normalize();
        this.mu0 = 2.0626480624709636E8 * (this.R[0] * this.xd + this.R[1] * this.yd + this.R[2] * this.zd);
        this.mu1 = 2.0626480624709636E8 * (this.R[3] * this.xd + this.R[4] * this.yd + this.R[5] * this.zd);
        this.mu2 = 2.0626480624709636E8 * (this.R[6] * this.xd + this.R[7] * this.yd + this.R[8] * this.zd);
        this.ready = (byte)(this.ready | 0x10);
        if (DEBUG) {
            System.out.println("#...compute_loc: mu now " + this.mu0 + ", " + this.mu1 + ", " + this.mu2);
            AstroMath.printMatrix("#...compute_loc: cov is:\n", this.cov);
        }
    }

    private final void compute_cor() {
        if ((this.ready & 0x20) != 0) {
            return;
        }
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        if (this.sig5corr == null) {
            this.sig5corr = new double[15];
        }
        if ((this.specified & 0x100) == 0) {
            this.estimated = (short)(this.estimated | 0x100);
        }
        if (DEBUG) {
            AstroMath.printMatrix("#...compute_cor:  cov=\n", this.cov);
            AstroMath.printMatrix("#...original sig5corr:\n", this.sig5corr);
        }
        this.sig5corr[0] = Math.sqrt(this.getVariance(1, 1));
        this.sig5corr[1] = Math.sqrt(this.getVariance(2, 2));
        this.sig5corr[2] = this.e_plx;
        this.sig5corr[3] = Math.sqrt(this.getVariance(4, 4));
        this.sig5corr[4] = Math.sqrt(this.getVariance(5, 5));
        double d = this.sig5corr[0] * this.sig5corr[1];
        this.sig5corr[5] = d > 0.0 ? this.getVariance(1, 2) / d : 0.0;
        d = this.sig5corr[0] * this.sig5corr[3];
        this.sig5corr[7] = d > 0.0 ? this.getVariance(1, 4) / d : 0.0;
        d = this.sig5corr[0] * this.sig5corr[4];
        this.sig5corr[8] = d > 0.0 ? this.getVariance(1, 5) / d : 0.0;
        d = this.sig5corr[1] * this.sig5corr[3];
        this.sig5corr[10] = d > 0.0 ? this.getVariance(2, 4) / d : 0.0;
        d = this.sig5corr[1] * this.sig5corr[4];
        this.sig5corr[11] = d > 0.0 ? this.getVariance(2, 5) / d : 0.0;
        d = this.sig5corr[3] * this.sig5corr[4];
        double d2 = this.sig5corr[14] = d > 0.0 ? this.getVariance(4, 5) / d : 0.0;
        if (DEBUG) {
            AstroMath.printMatrix("#........now sig5corr:\n", this.sig5corr);
        }
        this.ready = (byte)(this.ready | 0x30);
    }

    public Astropos() {
        this(ICRS.create(2000.0));
    }

    public Astropos(Astroframe astroframe) {
        super(astroframe);
        this.cov = null;
        this.permanent = 0;
        this.reset();
    }

    public Astropos(Astroframe astroframe, double d, double d2) {
        super(astroframe);
        this.cov = null;
        this.permanent = 0;
        this.reset();
        this.set(d, d2);
    }

    public Astropos(Astrocoo astrocoo) {
        this(astrocoo.frame);
        if (astrocoo.x * astrocoo.x + astrocoo.y * astrocoo.y + astrocoo.z * astrocoo.z > 0.0) {
            this.x = astrocoo.x;
            this.y = astrocoo.y;
            this.z = astrocoo.z;
            this.specified = (short)(this.specified | 1);
            if (this.R == null) {
                this.R = super.localMatrix();
            } else {
                super.localMatrix(this.R);
            }
            this.specified = 1;
            this.estimated = 0;
            this.ready = 0;
        }
        this.precision = astrocoo.precision;
        this.editing = astrocoo.editing;
        this.dlon = astrocoo.dlon;
        this.dlat = astrocoo.dlat;
        if (!Double.isNaN(astrocoo.epoch)) {
            this.setEpoch(astrocoo.epoch);
        }
    }

    public Astropos(Astroframe astroframe, String string) throws ParseException {
        super(astroframe);
        this.set(string);
    }

    public Astropos(String string) throws ParseException {
        if (DEBUG) {
            System.out.println("#...Astropos <" + string + ">");
        }
        this.frame = null;
        Parsing parsing = new Parsing(string);
        parsing.gobbleSpaces();
        boolean bl = false;
        char c = parsing.currentChar();
        parsing.advance(1);
        if (Character.isLetter(c) && Character.isDigit(parsing.currentChar())) {
            while (parsing.advance(1) && (Character.isLetterOrDigit(c = parsing.currentChar()) || c == '.')) {
            }
            if (Parsing.isSign(c)) {
                parsing.set(0);
                bl = super.parseIAU(parsing);
            }
        }
        if (!bl) {
            parsing.set(0);
            this.frame = Astroframe.parse(parsing);
        }
        if (this.frame == null) {
            throw new ParseException("[Astropos] argument '" + string + "' (no frame)", parsing.pos);
        }
        if (DEBUG) {
            System.out.println("#...Astropos <" + string + ">: interpreted frame=" + this.frame + "; now: " + parsing);
        }
        bl = this.parse(parsing);
        parsing.gobbleSpaces();
        if (!bl || parsing.pos != parsing.length) {
            String string2 = "[Astropos, frame=" + this.frame + "] argument '" + string + "'";
            if (parsing.error_message != null) {
                string2 = string2 + " " + parsing.error_message;
            }
            throw new ParseException(string2 + "+" + parsing.pos, parsing.pos);
        }
    }

    @Override
    public Object clone() {
        Astropos astropos = (Astropos)super.clone();
        if (this.R != null) {
            astropos.R = (double[])this.R.clone();
        }
        if (this.cov != null) {
            astropos.cov = (double[])this.cov.clone();
        }
        if (this.sig5corr != null) {
            astropos.sig5corr = (double[])this.sig5corr.clone();
        }
        return astropos;
    }

    public Astropos(Astroframe astroframe, double d, double d2, double d3, double[] dArray, double d4, double d5, double d6, double[] dArray2, double[] dArray3, double[] dArray4) {
        super(astroframe);
        this.set(d, d2, d3, dArray, d4, d5, d6, dArray2, dArray3, dArray4);
    }

    @Override
    public void dump(String string) {
        String[] stringArray = new String[]{"NOT_ready", "fixed_ok", "mu's_ok", "full_ok"};
        int n = this.ready & 1;
        if ((this.ready & 0x10) != 0) {
            ++n;
        }
        if ((this.ready & 0x20) != 0) {
            ++n;
        }
        System.out.print("#...Astropos.dump (" + stringArray[n] + ") " + string);
        if (!string.endsWith("\n")) {
            System.out.print("\n");
        }
        boolean bl = string.indexOf("(R)") >= 0;
        String string2 = string.charAt(0) == '#' ? "#   " : "    ";
        System.out.println(string2 + "epoch=" + this.epoch + "; Astroframe=" + this.frame);
        System.out.println(string2 + "x=" + this.x + " y=" + this.y + " z=" + this.z + "\t; lon=" + this.lon + " lat=" + this.lat);
        System.out.println(string2 + "xd=" + this.xd + " yd=" + this.yd + " zd=" + this.zd + "; meanEp=J" + this.meanEp);
        System.out.println(string2 + "precision=" + this.precision + "; editing=0x" + Integer.toHexString(this.editing) + '(' + Astropos.explainEditing(this.editing) + ')');
        System.out.println(string2 + "errorprec=" + this.errorprec + "; inputprec: dlon=" + this.dlon + ", dlat=" + this.dlat + ", formRA=0x" + Integer.toHexString(this.formRA) + '(' + Astroformat.explain(this.formRA) + ')');
        System.out.println(string2 + "mu0=" + this.mu0 + " mu1=" + this.mu1 + " mu2=" + this.mu2 + " (mas/yr)" + ((this.ready & 0x10) == 0 ? " [NOT_COMPUTED]" : ""));
        System.out.println(string2 + "plx=" + this.plx + "[" + this.e_plx + "]; rv=" + this.rv + "[" + this.e_rv + "]");
        System.out.print(string2 + "specified=0x" + Integer.toHexString(this.specified));
        System.out.print('(' + Astropos.explain(this.specified, partnames) + ')');
        System.out.print(" estimated=0x" + Integer.toHexString(this.estimated));
        System.out.print('(' + Astropos.explain(this.estimated, partnames) + ')');
        System.out.print(" permanent=0x" + Integer.toHexString(this.permanent));
        System.out.print('(' + Astropos.explain(this.permanent, partnames) + ')');
        System.out.print(" ready=0x" + Integer.toHexString(this.ready));
        System.out.println('[' + stringArray[n] + ']');
        AstroMath.printMatrix(string2 + "R:", this.R);
        AstroMath.printMatrix(string2 + "cov (6x6 covariance matrix) in fixed frame" + ((this.ready & 1) == 0 ? " [NOT_COMPUTED]" : "") + ":\n", this.cov);
        AstroMath.printMatrix(string2 + "sig5corr (sigma + correlations)" + ((this.ready & 0x20) == 0 ? " [NOT_COMPUTED]" : "") + ":\n", this.sig5corr);
        if (bl) {
            this.frame.dump(string2 + "Details of frame: ");
        }
    }

    public void printDifferences(String string, Astropos astropos) {
        double[] dArray;
        double[] dArray2;
        System.out.println("#...Astropos.printDifferences: " + string);
        if (!this.frame.equals(astropos.frame)) {
            System.out.println("#   Frames: " + this.frame + " != " + astropos.frame);
        }
        if (this.dlon != astropos.dlon || this.dlat != astropos.dlat || this.precision != astropos.precision || this.editing != astropos.editing) {
            System.out.print("#     ....:");
            if (this.dlon != astropos.dlon) {
                System.out.print(" dlon=" + this.dlon + "/" + astropos.dlon);
            }
            if (this.dlat != astropos.dlat) {
                System.out.print(" dlat=" + this.dlat + "/" + astropos.dlat);
            }
            if (this.precision != astropos.precision) {
                System.out.print(" precision=" + this.precision + "/" + astropos.precision);
            }
            if (this.editing != astropos.editing) {
                System.out.print(" editing=" + this.editing + "/" + astropos.editing);
            }
            System.out.println("");
        }
        if (this.specified != astropos.specified || this.permanent != astropos.permanent || this.estimated != astropos.estimated || this.ready != astropos.ready) {
            System.out.print("#     ....:");
            if (this.specified != astropos.specified) {
                System.out.print(" specified=" + this.specified + "/" + astropos.specified);
            }
            if (this.permanent != astropos.permanent) {
                System.out.print(" permanent=" + this.permanent + "/" + astropos.permanent);
            }
            if (this.estimated != astropos.estimated) {
                System.out.print(" estimated=" + this.estimated + "/" + astropos.estimated);
            }
            if (this.ready != astropos.ready) {
                System.out.print(" ready=0x" + Integer.toHexString(this.ready) + "/" + Integer.toHexString(astropos.ready));
            }
            System.out.println("");
        }
        if (this.epoch != astropos.epoch) {
            System.out.println("#   Epochs: " + this.epoch + " != " + astropos.epoch);
        }
        if (this.meanEp != astropos.meanEp) {
            System.out.println("#  meanEps: " + this.meanEp + " != " + astropos.meanEp);
        }
        if (this.plx != astropos.plx || this.e_plx != astropos.e_plx) {
            System.out.println("#     plxs: " + this.plx + ":\u0394=" + (this.plx - astropos.plx) + " \u03c3=" + this.e_plx + ":\u0394=" + (this.e_plx - astropos.e_plx));
        }
        if (this.rv != astropos.rv || this.e_rv != astropos.e_rv) {
            System.out.println("#      rv: " + this.rv + ":\u0394=" + (this.rv - astropos.rv) + " \u03c3=" + this.e_rv + ":\u0394=" + (this.e_rv - astropos.e_rv));
        }
        if (this.x != astropos.x || this.y != astropos.y || this.z != astropos.z) {
            dArray2 = new double[]{this.x, this.y, this.z};
            dArray = new double[]{astropos.x, astropos.y, astropos.z};
            AstroMath.checkArray("#    x,y,z: ", dArray2, dArray, AstroMath.eps);
        }
        if (this.xd != astropos.xd || this.yd != astropos.yd || this.zd != astropos.zd) {
            dArray2 = new double[]{this.xd, this.yd, this.zd};
            dArray = new double[]{astropos.xd, astropos.yd, astropos.zd};
            AstroMath.checkArray("#  d.x,y,z: ", dArray2, dArray, AstroMath.eps * AstroMath.amax(dArray));
        }
        if (this.R != null && astropos.R != null && !this.R.equals(astropos.R)) {
            AstroMath.checkArray("#   Rmatrix:", this.R, astropos.R, AstroMath.eps);
        }
        if (this.cov != null && astropos.cov != null && !this.cov.equals(astropos.cov) && !AstroMath.checkArray("#   covar..:", this.cov, astropos.cov, 36.0 * AstroMath.eps * AstroMath.amax(this.cov))) {
            AstroMath.printMatrix("#   Covariances(this):\n", this.cov);
            AstroMath.printMatrix("#   Covariances(ref):\n", astropos.cov);
        }
        if ((this.ready & astropos.ready & 0x31) == 49 && this.sig5corr != null && astropos.sig5corr != null) {
            AstroMath.checkArray("#   sig5cor:", this.sig5corr, astropos.sig5corr, 36.0 * AstroMath.eps * AstroMath.amax(this.sig5corr));
            AstroMath.printMatrix("#   \u03c3+corr(this):\n", this.sig5corr);
            AstroMath.printMatrix("#   \u03c3+corr(ref):\n", astropos.sig5corr);
        }
    }

    @Override
    public boolean parse(Parsing parsing) {
        int n;
        double[] dArray = new double[3];
        double[] dArray2 = new double[2];
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = new double[]{this.epoch, this.meanEp};
        int n2 = 0;
        boolean bl = true;
        int n3 = parsing.pos;
        if (DEBUG) {
            System.out.println("#...Parsing(0): calling Astropos.parse: " + parsing);
        }
        double d = this.epoch;
        bl = this.dlon > 0 && this.dlat > 0 ? true : super.parse(parsing);
        dArray9[0] = this.epoch;
        this.epoch = d;
        if (DEBUG) {
            System.out.println("#...Parsing(1): ok=" + bl + " x=" + this.x + " y=" + this.y + " z=" + this.z + "; " + parsing);
        }
        if (!bl) {
            return false;
        }
        n2 = 1;
        if (!Double.isNaN(dArray9[0])) {
            n2 |= 0x200;
        }
        parsing.gobbleSpaces();
        if (parsing.match('[')) {
            parsing.gobbleSpaces();
            if (!Astropos.parseErrorEllipse(parsing, dArray)) {
                return false;
            }
            dArray3 = (double[])dArray.clone();
            dArray9[1] = Astropos.getEpoch(parsing);
            if (!Double.isNaN(dArray9[1])) {
                n2 |= 0x400;
            }
            parsing.gobbleSpaces();
            if (parsing.match(']')) {
                n2 |= 0x10;
            } else {
                return false;
            }
            n = parsing.lookup(unitsymb);
            if (n >= 0) {
                if (DEBUG) {
                    System.out.println("#.............. matched unit <" + unitsymb[n] + "> *" + unit2mas[n]);
                }
                dArray3[0] = dArray3[0] * unit2mas[n];
                dArray3[1] = dArray3[1] * unit2mas[n];
            }
        }
        if (DEBUG) {
            System.out.println("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1] + "\n#...Parsing(2): " + parsing);
        }
        while ((n2 & 0x600) != 1536) {
            parsing.gobbleSpaces();
            d = Astropos.getEpoch(parsing);
            if (Double.isNaN(d)) break;
            if ((n2 & 0x200) == 0) {
                dArray9[0] = d;
                n2 |= 0x200;
                continue;
            }
            dArray9[1] = d;
            n2 |= 0x400;
        }
        if (DEBUG) {
            System.out.println("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1] + "\n#...Parsing(3): " + parsing);
        }
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        block9: while (bl && parsing.pos < parsing.length) {
            n3 = parsing.pos;
            parsing.gobbleSpaces();
            int n4 = parsing.lookup(datasymb);
            if (n4 < 0) {
                if (parsing.pos >= parsing.length) continue;
                for (n4 = 0; n4 < datatype.length && (n2 & datatype[n4]) != 0; ++n4) {
                }
                if (n4 >= datatype.length) break;
            }
            int n5 = datatype[n4];
            if (DEBUG) {
                System.out.println("#...Astropos.parse <" + parsing + ">, ok=" + bl + ", type=0x" + Integer.toHexString(n5) + "=" + Astropos.explain(n5, partnames));
            }
            switch (n5) {
                case 2: {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n6 = 0;
                    if (DEBUG) {
                        System.out.println("#...Trying to match \u00b5 from: " + parsing);
                    }
                    int n7 = parsing.parseArray(dArray2);
                    if (DEBUG) {
                        System.out.println("#...returned number of values n=" + n7);
                    }
                    if (n7 < 0) {
                        n6 = parsing.matchingBracket();
                        if (n6 > 0 && parsing.indexOf('/') < n6) {
                            parsing.advance(1);
                            n7 = parsing.parseArray(dArray2);
                        } else {
                            n6 = 0;
                        }
                    }
                    if (n7 == 1) {
                        parsing.gobbleSpaces();
                        char c = parsing.currentChar();
                        boolean bl4 = bl2 = c == '/';
                        if (bl2 || c == ',') {
                            parsing.advance(1);
                            dArray2[1] = parsing.parseDouble();
                            if (!Double.isNaN(dArray2[1])) {
                                ++n7;
                            }
                        }
                    }
                    if (n7 != 2) {
                        d2 = Double.NaN;
                        d3 = Double.NaN;
                        parsing.setError("[Astropos.parse] single proper motion component");
                        bl = false;
                        continue block9;
                    }
                    d3 = bl2 ? dArray2[0] * AstroMath.sind(dArray2[1]) : dArray2[0];
                    d2 = bl2 ? dArray2[0] * AstroMath.cosd(dArray2[1]) : dArray2[1];
                    parsing.gobbleSpaces();
                    if (DEBUG) {
                        System.out.println("#...parsing \u00b5: mu1=" + d3 + ", mu2=" + d2);
                    }
                    if ((n2 & 0x400) == 0) {
                        dArray9[1] = Astropos.getEpoch(parsing);
                        if (!Double.isNaN(dArray9[1])) {
                            n2 |= 0x400;
                        }
                    }
                    if (n6 > 0) {
                        if (parsing.lookup(Parsing.brackets) > 0) {
                            parsing.set(n6);
                        } else {
                            parsing.setError("[Astropos.parse] non-closed brackets");
                            bl = false;
                        }
                    }
                    if (!bl) continue block9;
                    n = parsing.lookup(unitsymb);
                    if (n >= 0) {
                        bl3 = true;
                        d3 *= unit2mas[n];
                        d2 *= unit2mas[n];
                        parsing.match("/yr");
                    }
                    if (DEBUG) {
                        System.out.println("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1] + "\n#...Parsing(4): " + parsing);
                    }
                    parsing.gobbleSpaces();
                    n3 = parsing.pos;
                    boolean bl5 = parsing.match('[');
                    if (bl5) {
                        parsing.gobbleSpaces();
                        if (Astropos.parseErrorEllipse(parsing, dArray)) {
                            dArray4 = (double[])dArray.clone();
                        }
                        if (parsing.match(']')) {
                            n2 |= 0x20;
                        } else {
                            bl = false;
                        }
                        n = parsing.lookup(unitsymb);
                        if (n >= 0) {
                            dArray4[0] = dArray4[0] * unit2mas[n];
                            dArray4[1] = dArray4[1] * unit2mas[n];
                            if (!bl3) {
                                d3 *= unit2mas[n];
                                d2 *= unit2mas[n];
                            }
                        }
                    }
                    if ((n2 & 0x400) == 0) {
                        dArray9[1] = Astropos.getEpoch(parsing);
                        if (!Double.isNaN(dArray9[1])) {
                            n2 |= 0x400;
                        }
                    }
                    if (!DEBUG) break;
                    System.out.println("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1] + "\n#...Parsing(5): " + parsing);
                    break;
                }
                case 4: 
                case 8: {
                    int n7 = parsing.parseWithError(dArray2);
                    if (n7 > 0) {
                        parsing.gobbleSpaces();
                        n = parsing.lookup(unitsymb);
                        if (n >= 0) {
                            if (DEBUG) {
                                System.out.println("#...Parsing(v): u=" + n + ": " + unitsymb[n]);
                            }
                            dArray2[0] = dArray2[0] * unit2mas[n];
                            dArray2[1] = dArray2[1] * unit2mas[n];
                            if (unitsymb[n].indexOf("m/s") >= 0 && n5 == 4) {
                                if (DEBUG) {
                                    System.out.println("#...Parsing(v): mixed rv/plx => " + n5);
                                }
                                n5 = 8;
                            } else if (unitsymb[n].indexOf("m/s") < 0 && n5 == 8) {
                                if (DEBUG) {
                                    System.out.println("#...Parsing(v): mixed rv/plx => " + n5);
                                }
                                n5 = 4;
                            }
                        }
                        if (n5 == 4) {
                            dArray5 = (double[])dArray2.clone();
                        } else {
                            dArray6 = (double[])dArray2.clone();
                        }
                    }
                    if (!DEBUG) break;
                    System.out.println("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1] + "\n#...Parsing(pv), " + (dArray6 == null ? "rv=null " : "") + (dArray5 == null ? "plx=null " : "") + parsing);
                    break;
                }
                case 112: {
                    dArray7 = new double[5];
                    int n7 = parsing.parseArray(dArray7);
                    if (n7 != 5) {
                        parsing.setError("[Astropos.parse]: " + n7 + "/5 sigmas");
                        while (n7 < 5) {
                            dArray7[n7++] = 0.0;
                        }
                        bl = false;
                    }
                    if (!DEBUG) break;
                    System.out.println("#...Parsing(\u03c3): " + parsing + " => n=" + n7);
                    AstroMath.printMatrix("\u03c3\u00a0", dArray7);
                    System.out.println("");
                    break;
                }
                case 256: {
                    dArray8 = new double[10];
                    int n7 = parsing.parseArray(dArray8);
                    if (n7 == 10) break;
                    parsing.setError("[Astropos.parse]: " + n7 + "/10 correlations");
                    while (n7 < 10) {
                        dArray8[n7++] = 0.0;
                    }
                    bl = false;
                    break;
                }
                case 512: {
                    n2 |= 0x200;
                    dArray9[0] = Astropos.getEpoch(parsing);
                    break;
                }
                case 1024: {
                    n2 |= 0x400;
                    dArray9[1] = Astropos.getEpoch(parsing);
                }
            }
            if (bl) {
                n2 |= n5;
            } else {
                parsing.set(n3);
            }
            if (!DEBUG) continue;
            this.dump("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1]);
        }
        if (!bl) {
            return bl;
        }
        if (DEBUG) {
            System.out.println("#     specif=0x" + Integer.toHexString(n2) + "; epochs=" + dArray9[0] + ", " + dArray9[1] + " => ok=" + bl + "\n#...Parsing(p): " + parsing);
        }
        if (dArray8 != null && dArray7 == null && (n2 & 0x70) == 0) {
            System.err.println("#+++Astropos.parse: correlations without sigmas");
            dArray8 = null;
        }
        if (!bl) {
            return bl;
        }
        if ((n2 & 0x200) != 0) {
            if ((this.permanent & 0x200) == 0) {
                this.epoch = dArray9[0];
            } else if (Math.abs(dArray9[0] - this.epoch) > 3.168808781402895E-8) {
                System.err.println("#+++Astropos.parse: ignore epoch: " + dArray9[0]);
            }
        }
        if ((n2 & 0x200) != 0) {
            if ((this.permanent & 0x400) == 0) {
                this.epoch = dArray9[1];
            } else if (Math.abs(dArray9[1] - dArray9[1]) > 3.168808781402895E-8) {
                System.err.println("#+++Astropos.parse: ignore meanEp: " + dArray9[1]);
            }
        }
        if (DEBUG) {
            this.dump("#...before calling set...");
        }
        if ((n2 & 2) != 0) {
            bl &= this.setProperMotion(d3, d2);
        }
        if (DEBUG) {
            this.dump("#...after called this.set(lon, lat, " + d3 + ", " + d2 + ")");
        }
        if ((this.permanent & 0x200) == 0 && (n2 & 0x200) != 0) {
            bl &= this.setEpoch(dArray9[0]);
        }
        if ((this.permanent & 0x400) == 0 && (n2 & 0x400) != 0) {
            bl &= this.setMeanEpoch(dArray9[1]);
        }
        if ((n2 & 4) != 0) {
            bl &= this.setParallax((double)dArray5[0], (double)dArray5[1]);
        }
        if ((n2 & 8) != 0) {
            bl &= this.setRadialVelocity(dArray6[0], dArray6[1]);
        }
        if (dArray3 != null) {
            bl &= this.setErrorEllipse(dArray3[0], dArray3[1], dArray3[2]);
        }
        if (dArray4 != null) {
            bl &= this.setErrorProperMotion((double)dArray4[0], (double)dArray4[1], (double)dArray4[2]);
        }
        if (DEBUG) {
            this.dump("#...before calling setSigmas");
        }
        if (dArray7 != null) {
            bl &= this.setSigmas(dArray7);
        }
        if (DEBUG) {
            this.dump("#...before calling setCorrelations");
        }
        if (dArray8 != null) {
            bl &= this.setCorrelations(dArray8);
        }
        if (DEBUG) {
            this.dump("#...after  calling setCorrelations, ok=" + bl);
        }
        return bl;
    }

    @Override
    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        if (this.parse(parsing)) {
            return parsing.pos;
        }
        return n;
    }

    private final void reset() {
        int n;
        this.specified = this.permanent;
        this.estimated = 0;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.mu2 = 0.0;
        this.mu1 = 0.0;
        this.mu0 = 0.0;
        this.dlat = 0;
        this.dlon = 0;
        this.ready = 0;
        this.e_plx = 0.0;
        this.plx = 0.0;
        this.e_rv = 0.0;
        this.rv = 0.0;
        if ((this.permanent & 0x200) == 0) {
            this.epoch = Double.NaN;
        } else if (Double.isNaN(this.epoch)) {
            this.specified = (short)(this.specified & 0xFFFFFDFF);
        }
        if ((this.permanent & 0x400) == 0) {
            this.meanEp = this.frame.epoch;
        } else if (Double.isNaN(this.meanEp)) {
            this.specified = (short)(this.specified & 0xFFFFFBFF);
        }
        if (this.cov != null) {
            for (n = 0; n < this.cov.length; ++n) {
                this.cov[n] = 0.0;
            }
        }
        if (this.sig5corr != null) {
            for (n = 0; n < this.sig5corr.length; ++n) {
                this.sig5corr[n] = 0.0;
            }
        }
    }

    @Override
    public void set() {
        super.set();
        this.reset();
    }

    @Override
    public void set(double d, double d2) {
        this.reset();
        super.set(d, d2);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.specified = 1;
        this.estimated = 0;
        this.ready = 0;
    }

    public void set(double d, double d2, double d3, double d4) {
        this.set(d, d2);
        if (DEBUG) {
            System.out.println("#...Astropos.set(" + d + ", " + d2 + ", " + d3 + ", " + d4 + ")");
        }
        if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
            this.setProperMotion(d3, d4);
        }
    }

    public void set(double d, double d2, double d3, double[] dArray, double d4, double d5, double d6, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.set(d, d2, d4, d5);
        this.setEpoch(d3);
        if (dArray != null) {
            this.setErrorEllipse(dArray[0], dArray[1], dArray[2], d6);
        }
        if (dArray2 != null) {
            this.setErrorProperMotion(dArray2[0], dArray2[1], dArray2[2]);
        }
        if (dArray3 != null) {
            this.setParallax(dArray3[0], dArray3[1]);
        }
        if (dArray4 != null) {
            this.setRadialVelocity(dArray4[0], dArray4[1]);
        }
    }

    @Override
    public void set(String string) throws ParseException {
        if (DEBUG) {
            System.out.println("#...Astropos.set(String): " + string);
        }
        if (this.frame == null) {
            throw new ParseException("[Astropos.set, frame=null] argument=" + string, 0);
        }
        this.reset();
        Parsing parsing = new Parsing(string);
        boolean bl = this.parse(parsing);
        if (bl) {
            parsing.gobbleSpaces();
        }
        if (!bl || parsing.pos != parsing.length) {
            String string2 = "[Astropos.set, frame=" + this.frame + "] argument '" + string + "'";
            if (parsing.error_message != null) {
                string2 = string2 + " " + parsing.error_message;
            }
            throw new ParseException(string2 + "+" + parsing.pos, parsing.pos);
        }
    }

    public boolean setFrame(Astroframe astroframe) {
        this.reset();
        this.frame = astroframe;
        return true;
    }

    public boolean setDefaultEpoch(double d) {
        if (this.ready != 0) {
            return false;
        }
        if (Double.isNaN(d)) {
            this.permanent = (short)(this.permanent & 0xFFFFFDFF);
            this.specified = (short)(this.specified & 0xFFFFFDFF);
        } else {
            this.permanent = (short)(this.permanent | 0x200);
            this.specified = (short)(this.specified | 0x200);
        }
        this.epoch = d;
        return true;
    }

    public boolean setDefaultMeanEpoch(double d) {
        if (this.ready != 0) {
            return false;
        }
        if (Double.isNaN(d)) {
            this.permanent = (short)(this.permanent & 0xFFFFFBFF);
            this.specified = (short)(this.specified & 0xFFFFFBFF);
        } else {
            this.permanent = (short)(this.permanent | 0x400);
            this.specified = (short)(this.specified | 0x400);
        }
        this.meanEp = d;
        return true;
    }

    public void setErrorPrecision(int n) {
        this.errorprec = n > 7 ? (byte)7 : (n < 0 ? (byte)0 : (byte)n);
    }

    @Override
    public boolean setEpoch(double d) {
        if (this.ready != 0) {
            return false;
        }
        if ((this.permanent & 0x200) != 0) {
            return Math.abs(d - this.epoch) > 3.168808781402895E-8;
        }
        if (Double.isNaN(d)) {
            this.specified = (short)(this.specified & 0xFFFFFDFF);
        } else {
            this.epoch = d;
            this.specified = (short)(this.specified | 0x200);
        }
        return true;
    }

    public boolean setMeanEpoch(double d) {
        if (this.ready != 0) {
            return false;
        }
        if ((this.permanent & 0x400) != 0) {
            return Math.abs(d - this.meanEp) > 3.168808781402895E-8;
        }
        if (Double.isNaN(d)) {
            this.specified = (short)(this.specified & 0xFFFFFBFF);
        } else {
            this.meanEp = d;
            this.specified = (short)(this.specified | 0x400);
        }
        return true;
    }

    public boolean setErrorEllipse(double d, double d2, double d3) {
        return this.setErrorEllipse(d, d2, d3, Double.NaN);
    }

    public boolean setErrorEllipse(double d, double d2, double d3, double d4) {
        if (DEBUG) {
            System.out.println("ready: " + this.ready + "; (specified&HASepos): " + (this.specified & 0x10));
        }
        if (DEBUG) {
            System.out.println("#...Astropos.setErrorEllipse(" + d + ", " + d2 + ", " + d3 + ", meanEp=" + d4 + ")");
        }
        if (this.ready != 0) {
            return false;
        }
        if ((this.specified & 0x10) != 0) {
            return false;
        }
        if (Double.isNaN(d3)) {
            d3 = 90.0;
        }
        if (!Double.isNaN(d4)) {
            if ((this.specified & 0x400) != 0 && d4 != this.meanEp) {
                System.err.println("#+++Astropos.setErrorEllipse: can't change meanEp=" + this.meanEp + " to " + d4);
                return false;
            }
            this.meanEp = d4;
            this.specified = (short)(this.specified | 0x400);
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return false;
        }
        if (this.sig5corr == null) {
            this.sig5corr = new double[15];
        }
        this.sig5corr[2] = 0.0;
        if (d3 == 90.0 || d == d2) {
            this.sig5corr[0] = d;
            this.sig5corr[1] = d2;
        } else if (d3 == 0.0) {
            this.sig5corr[0] = d2;
            this.sig5corr[1] = d;
        } else {
            double[] dArray = new double[]{d, d2, d3};
            double[] dArray2 = new double[3];
            Astropos.errorEllipseToVariance(dArray, dArray2);
            this.sig5corr[0] = Math.sqrt(dArray2[0]);
            this.sig5corr[1] = Math.sqrt(dArray2[1]);
            this.sig5corr[5] = dArray2[2] / (this.sig5corr[0] * this.sig5corr[1]);
            if (DEBUG) {
                System.arraycopy(this.sig5corr, 0, dArray2, 0, 3);
                AstroMath.printMatrix("#...setErrorEllipse with: ", dArray);
                AstroMath.printMatrix("#...............sig5corr: ", dArray2);
            }
        }
        this.specified = (short)(this.specified | 0x10);
        return true;
    }

    public boolean setProperMotion(double d, double d2) {
        if (this.ready != 0) {
            return false;
        }
        if ((this.specified & 3) != 1) {
            return false;
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return false;
        }
        this.mu1 = d;
        this.mu2 = d2;
        if (this.frame instanceof FK4) {
            this.mu1 *= 1.000021359027778;
            this.mu2 *= 1.000021359027778;
        }
        this.specified = (short)(this.specified | 2);
        return true;
    }

    public boolean setErrorProperMotion(double d, double d2) {
        return this.setErrorProperMotion(d, d2, 90.0);
    }

    public boolean setErrorProperMotion(double d, double d2, double d3) {
        if (DEBUG) {
            System.out.println("#...Astropos.setErrorProperMotion(" + d + ", " + d2 + ", " + d3 + ")");
        }
        if (this.ready != 0) {
            return false;
        }
        if ((this.specified & 0x23) != 3) {
            return false;
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return false;
        }
        if (this.sig5corr == null) {
            this.sig5corr = new double[15];
        }
        this.sig5corr[14] = 0.0;
        if (d3 == 90.0 || d == d2) {
            this.sig5corr[3] = d;
            this.sig5corr[4] = d2;
        } else if (d3 == 0.0) {
            this.sig5corr[3] = d2;
            this.sig5corr[4] = d;
        } else {
            double[] dArray = new double[]{d, d2, d3};
            double[] dArray2 = new double[3];
            Astropos.errorEllipseToVariance(dArray, dArray2);
            this.sig5corr[3] = Math.sqrt(dArray2[0]);
            this.sig5corr[4] = Math.sqrt(dArray2[1]);
            this.sig5corr[14] = dArray2[2] / (this.sig5corr[3] * this.sig5corr[4]);
        }
        this.specified = (short)(this.specified | 0x20);
        return true;
    }

    public boolean setRadialVelocity(double d, double d2) {
        if (this.ready != 0) {
            return false;
        }
        if (DEBUG) {
            System.out.println("#...Astropos.setRadialVel(beg)(" + d + ", " + d2 + ";   specified=0x" + Integer.toHexString(this.specified));
        }
        if ((this.specified & 8) != 0) {
            return false;
        }
        if (Double.isNaN(d)) {
            return false;
        }
        this.rv = d;
        this.specified = (short)(this.specified | 8);
        this.e_rv = d2;
        if (!Double.isNaN(d2)) {
            this.specified = (short)(this.specified | 0x80);
        }
        if (DEBUG) {
            System.out.println("#...Astropos.setRadialVelocity(" + d + ", " + d2 + " => specified=0x" + Integer.toHexString(this.specified));
        }
        return true;
    }

    public boolean setParallax(double d, double d2) {
        if (DEBUG) {
            System.out.println("#...Astropos.setParallax(" + d + ", err=" + d2 + ")");
        }
        if (this.ready != 0) {
            return false;
        }
        if ((this.specified & 4) != 0) {
            return false;
        }
        if (Double.isNaN(d)) {
            return false;
        }
        this.plx = d;
        this.specified = (short)(this.specified | 4);
        this.e_plx = d2;
        if (!Double.isNaN(d2)) {
            this.specified = (short)(this.specified | 0x40);
        }
        return true;
    }

    public boolean setSigmas(double[] dArray) {
        if (this.ready != 0) {
            return false;
        }
        if (dArray.length != 5 && dArray.length != 15) {
            System.err.println("#+++Astropos.setSigmas: require RA/Dec/plx/pmRA/pmDec array, " + dArray.length + "-array supplied");
            return false;
        }
        if ((this.specified & 0x70) != 0) {
            int n = this.specified & 0x70;
            if ((n & 0x40) != 0 && this.e_plx == dArray[2]) {
                n &= 0xFFFFFFBF;
            }
            if ((n & 0x10) != 0 && dArray[0] == this.sig5corr[0] && dArray[1] == this.sig5corr[1]) {
                n &= 0xFFFFFFEF;
            }
            if ((n & 0x20) != 0 && dArray[3] == this.sig5corr[3] && dArray[4] == this.sig5corr[4]) {
                n &= 0xFFFFFFDF;
            }
            if (n != 0) {
                System.err.println("#+++Astropos.setSigmas: values of " + Astropos.explain(this.permanent, partnames) + " supersede previously assigned values");
            }
        }
        if (Double.isNaN(dArray[0] + dArray[1] + dArray[2] + dArray[3] + dArray[4])) {
            return false;
        }
        if (this.sig5corr == null) {
            this.sig5corr = new double[15];
        }
        System.arraycopy(dArray, 0, this.sig5corr, 0, 5);
        this.e_plx = this.sig5corr[2];
        this.specified = (short)(this.specified | 0x70);
        return true;
    }

    public boolean setCorrelations(double[] dArray) {
        int n;
        if (this.ready != 0) {
            return false;
        }
        if ((this.specified & 0x100) != 0) {
            return false;
        }
        int n2 = 0;
        if (dArray.length == 15) {
            n2 = 5;
        } else if (dArray.length != 10) {
            System.err.println("#+++Astropos.setCorrelations: require 10-correlations array, " + dArray.length + "-array supplied");
            return false;
        }
        if ((this.specified & 0x70) != 112) {
            System.err.println("#+++Astropos.setCorrelations: no sigmas?");
            return false;
        }
        if (this.sig5corr == null) {
            this.sig5corr = new double[15];
        }
        boolean bl = true;
        double d = 1.000001;
        System.arraycopy(dArray, n2, this.sig5corr, 5, 10);
        for (n = 5; bl && n < this.sig5corr.length; ++n) {
            double d2;
            if (Double.isNaN(this.sig5corr[n])) {
                bl = false;
            }
            if ((d2 = Math.abs(this.sig5corr[n])) <= 1.0) continue;
            if (d2 > d) {
                System.err.println("#***Astropos.setCorrelations: corr[" + n + "]=" + this.sig5corr[n]);
                bl = false;
                continue;
            }
            this.sig5corr[n] = this.sig5corr[n] < 0.0 ? -1.0 : 1.0;
        }
        if (bl) {
            this.specified = (short)(this.specified | 0x100);
        } else {
            for (n = 5; n < this.sig5corr.length; ++n) {
                this.sig5corr[n] = 0.0;
            }
        }
        if (DEBUG) {
            AstroMath.printMatrix("#...Installed correlations => sig5corr:\n", this.sig5corr);
        }
        return true;
    }

    public boolean copyErrorEllipse(double[] dArray) {
        if (this.ready != 49) {
            this.compute_cor();
        }
        double[] dArray2 = new double[]{this.sig5corr[0] * this.sig5corr[0], this.sig5corr[1] * this.sig5corr[1], this.sig5corr[1] * this.sig5corr[0] * this.sig5corr[5]};
        Astropos.varianceToErrorEllipse(dArray2, dArray);
        return (this.specified & ~this.estimated & 0x10) != 0;
    }

    @Override
    public double getLon() {
        if (this.ready == 0) {
            this.compute_fix();
        }
        return super.getLon();
    }

    @Override
    public double getLat() {
        if (this.ready == 0) {
            this.compute_fix();
        }
        return super.getLat();
    }

    public double sigmaLon() {
        if (this.ready == 49) {
            return this.sig5corr[0];
        }
        if (this.ready == 0) {
            this.compute_fix();
        }
        return Math.sqrt(this.getVariance(1, 1));
    }

    public double sigmaLat() {
        if (this.ready == 49) {
            return this.sig5corr[1];
        }
        if (this.ready == 0) {
            this.compute_fix();
        }
        return Math.sqrt(this.getVariance(2, 2));
    }

    public boolean copyProperMotion(double[] dArray) {
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        boolean bl = (this.specified & ~this.estimated & 2) != 0;
        dArray[0] = this.mu1;
        dArray[1] = this.mu2;
        if (this.frame instanceof FK4) {
            dArray[0] = dArray[0] / 1.000021359027778;
            dArray[1] = dArray[1] / 1.000021359027778;
        }
        return bl;
    }

    public double getProperMotionLon() {
        if ((this.specified & 2) == 0) {
            return Double.NaN;
        }
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        double d = this.mu1;
        if (this.frame instanceof FK4) {
            d /= 1.000021359027778;
        }
        return d;
    }

    public double getProperMotionLat() {
        if ((this.specified & 2) == 0) {
            return Double.NaN;
        }
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        double d = this.mu2;
        if (this.frame instanceof FK4) {
            d /= 1.000021359027778;
        }
        return d;
    }

    public double getTotalProperMotion() {
        if ((this.specified & 2) == 0) {
            return Double.NaN;
        }
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        double d = Math.hypot(this.mu1, this.mu2);
        if (this.frame instanceof FK4) {
            d /= 1.000021359027778;
        }
        return d;
    }

    public double getProperMotionPositionAngle() {
        if ((this.specified & 2) == 0) {
            return Double.NaN;
        }
        if ((this.ready & 0x10) == 0) {
            this.compute_loc();
        }
        return AstroMath.atan2d(this.mu1, this.mu2);
    }

    public boolean copyProperMotionErrorEllipse(double[] dArray) {
        boolean bl;
        boolean bl2 = bl = (this.specified & ~this.estimated & 0x20) != 0;
        if (this.ready != 49) {
            this.compute_cor();
        }
        double[] dArray2 = new double[]{this.sig5corr[3] * this.sig5corr[3], this.sig5corr[4] * this.sig5corr[4], this.sig5corr[3] * this.sig5corr[4] * this.sig5corr[14]};
        Astropos.varianceToErrorEllipse(dArray2, dArray);
        if (this.frame instanceof FK4) {
            dArray[0] = dArray[0] / 1.000021359027778;
            dArray[1] = dArray[1] / 1.000021359027778;
        }
        return bl;
    }

    public double sigmaProperMotionLon() {
        double d;
        if ((this.specified & 0x20) == 0) {
            return Double.NaN;
        }
        double d2 = d = this.frame instanceof FK4 ? 1.000021359027778 : 1.0;
        if (this.ready == 49) {
            return this.sig5corr[3] / d;
        }
        if (this.ready == 0) {
            this.compute_fix();
        }
        return Math.sqrt(this.getVariance(4, 4) / d);
    }

    public double sigmaProperMotionLat() {
        double d;
        if ((this.specified & 0x20) == 0) {
            return Double.NaN;
        }
        double d2 = d = this.frame instanceof FK4 ? 1.000021359027778 : 1.0;
        if (this.ready == 49) {
            return this.sig5corr[4] / d;
        }
        if (this.ready == 0) {
            this.compute_fix();
        }
        return Math.sqrt(this.getVariance(5, 5) / d);
    }

    public boolean copyParallax(double[] dArray) {
        if ((this.ready & 0x10) != 0) {
            this.compute_loc();
        }
        dArray[0] = this.plx;
        dArray[1] = this.e_plx;
        return (this.specified & ~this.estimated & 4) != 0;
    }

    public boolean copyVelocity(double[] dArray) {
        if ((this.ready & 0x10) != 0) {
            this.compute_loc();
        }
        dArray[0] = this.rv;
        dArray[1] = this.e_rv;
        return (this.specified & ~this.estimated & 8) != 0;
    }

    public boolean copySigmas(double[] dArray) {
        if (this.ready != 49) {
            this.compute_cor();
        }
        if (dArray.length >= 15) {
            System.arraycopy(this.sig5corr, 0, dArray, 0, 15);
        } else {
            System.arraycopy(this.sig5corr, 0, dArray, 0, 5);
        }
        return (this.specified & ~this.estimated & 0x70) == 112;
    }

    public boolean copyCorrelations(double[] dArray) {
        if (this.ready != 49) {
            this.compute_cor();
        }
        if (dArray.length >= 15) {
            System.arraycopy(this.sig5corr, 0, dArray, 0, 15);
        } else {
            System.arraycopy(this.sig5corr, 5, dArray, 0, 10);
        }
        return (this.specified & ~this.estimated & 0x100) == 256;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof Astropos)) {
            return bl;
        }
        Astropos astropos = (Astropos)object;
        if ((this.ready & astropos.ready ^ 0x11) != 0) {
            if ((this.ready & 0x10) == 0) {
                this.compute_loc();
            }
            if ((astropos.ready & 0x10) == 0) {
                astropos.compute_loc();
            }
        }
        if (!super.equals(object)) {
            return bl;
        }
        bl = this.xd == astropos.xd && this.yd == astropos.yd && this.zd == astropos.zd;
        return bl;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.xd);
        n = n * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.yd);
        n = n * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zd);
        n = n * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.meanEp);
        n = n * 123 + (int)(l ^ l >>> 32);
        return n;
    }

    private static void editErrorEllipse(StringBuffer stringBuffer, double[] dArray, boolean bl, int n) {
        if (n <= 0) {
            n = -1;
        }
        if (bl) {
            stringBuffer.append(dArray[0]);
        } else {
            ed.editDecimal(stringBuffer, dArray[0], 0, n, 0);
        }
        stringBuffer.append(' ');
        if (bl) {
            stringBuffer.append(dArray[1]);
        } else {
            ed.editDecimal(stringBuffer, dArray[1], 0, n, 0);
        }
        stringBuffer.append(' ');
        stringBuffer.append(' ');
        if (bl) {
            stringBuffer.append(dArray[2]);
        } else {
            int n2 = 0;
            for (double d = AstroMath.dexp(n) * (dArray[0] - dArray[1]); d > 100.0; d /= 10.0) {
                ++n2;
            }
            ed.editDecimal(stringBuffer, dArray[2], 0, n2, 0);
        }
    }

    @Override
    public String toString() {
        return this.toString(this.editing);
    }

    @Override
    public String toString(String string) {
        return this.toString(Astropos.editingOptions(string));
    }

    @Override
    public String toString(int n) {
        int n2;
        int n3;
        boolean bl;
        if (DEBUG) {
            System.out.println("#...Astropos.toString(" + Integer.toHexString(n) + ")");
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[2];
        int n4 = this.precision + this.errorprec - 8;
        int n5 = 32;
        if (this.ready != 49) {
            this.compute_cor();
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        int n6 = (this.precision & 0x80) != 0 ? 3 : 0;
        int n7 = this.editing | n;
        boolean bl2 = (n7 & 0x1000) != 0;
        boolean bl3 = (n7 & 0x4000) != 0;
        boolean bl4 = (n7 & 0x8000) != 0;
        boolean bl5 = bl = (n7 & 0x2000) != 0;
        if (!bl2 && this.errorprec > 0 && (this.specified & 0x70) != 0) {
            int n8;
            double d = 0.5 * AstroMath.dexp(this.errorprec);
            int n9 = 0;
            for (n8 = 0; n8 < 5; ++n8) {
                if (this.sig5corr[n8] < 1.0E-8) continue;
                while (this.sig5corr[n8] < d) {
                    ++n9;
                    d /= 10.0;
                }
            }
            n8 = this.precision;
            this.setPrecision(this.precision + n9);
            super.edit(stringBuffer, n6 | n);
            this.precision = (byte)n8;
            if (n9 > n4) {
                n4 = n9;
            }
        } else {
            super.edit(stringBuffer, n6 | n);
        }
        if (!bl && this.copyErrorEllipse(dArray)) {
            stringBuffer.append(" [");
            Astropos.editErrorEllipse(stringBuffer, dArray, bl2, n4);
            if ((n7 & 0x800) != 0 && (this.specified & 0x400) != 0 && this.meanEp != this.epoch) {
                stringBuffer.append(" (");
                this.editEpoch(stringBuffer, this.meanEp);
                stringBuffer.append(")");
            }
            stringBuffer.append(']');
            if (bl3) {
                stringBuffer.append("mas");
            }
        }
        if ((n3 = n4) < 1) {
            n3 = 1;
        }
        if (n3 > 6) {
            n3 = 6;
        }
        if (this.copyProperMotion(dArray2)) {
            stringBuffer.append(' ');
            if (bl3) {
                stringBuffer.append("\u00b5=(");
            }
            if (bl2) {
                stringBuffer.append(dArray2[0]);
            } else {
                ed.editDecimal(stringBuffer, dArray2[0], 0, n3, 16);
            }
            stringBuffer.append(' ');
            if (bl2) {
                stringBuffer.append(dArray2[1]);
            } else {
                ed.editDecimal(stringBuffer, dArray2[1], 0, n3, 16);
            }
            if (bl3) {
                stringBuffer.append(")");
            }
            if (!bl && this.copyProperMotionErrorEllipse(dArray)) {
                stringBuffer.append(" [");
                Astropos.editErrorEllipse(stringBuffer, dArray, bl2, n4);
                stringBuffer.append(']');
            }
            if (bl3) {
                stringBuffer.append("mas");
            }
        }
        if ((this.specified & 4) != 0) {
            stringBuffer.append(' ');
            if (bl3) {
                stringBuffer.append("\u03d6=");
            }
            if (bl2) {
                stringBuffer.append(this.plx);
            } else {
                ed.editDecimal(stringBuffer, this.plx, 0, n3, 0);
            }
            if (!bl && (this.specified & 0x40) != 0) {
                stringBuffer.append('[');
                if (bl2) {
                    stringBuffer.append(this.e_plx);
                } else {
                    ed.editDecimal(stringBuffer, this.e_plx, 0, n3, 0);
                }
                stringBuffer.append(']');
            }
            stringBuffer.append("mas");
        }
        if ((this.specified & 8) != 0) {
            int n10 = n2 = this.errorprec > 1 ? this.errorprec : 1;
            if (this.errorprec > 0 && (this.specified & 0x80) != 0) {
                for (double d = this.e_rv * AstroMath.dexp(this.errorprec); d < 1.0; d *= 10.0) {
                    ++n2;
                }
            }
            stringBuffer.append(' ');
            if (bl3) {
                stringBuffer.append("RV=");
            }
            if (bl2) {
                stringBuffer.append(this.rv);
            } else {
                ed.editDecimal(stringBuffer, this.rv, 0, n2, 16);
            }
            if ((this.specified & 0x80) != 0) {
                stringBuffer.append('[');
                if (bl2) {
                    stringBuffer.append(this.e_rv);
                } else {
                    ed.editDecimal(stringBuffer, this.e_rv, 0, n2, 0);
                }
                stringBuffer.append(']');
            }
            stringBuffer.append("km/s");
        }
        if (bl && (this.specified & 0x70) != 0) {
            stringBuffer.append(' ');
            if (bl3) {
                stringBuffer.append("\u03c3=");
            }
            n5 = 91;
            for (n2 = 0; n2 < 5; ++n2) {
                stringBuffer.append((char)n5);
                if (bl2) {
                    stringBuffer.append(this.sig5corr[n2]);
                } else {
                    ed.editDecimal(stringBuffer, this.sig5corr[n2], 0, n4, 0);
                }
                n5 = 44;
            }
            stringBuffer.append(']');
        }
        if (bl4 || (this.specified & 0x100) != 0) {
            stringBuffer.append(' ');
            if (bl3) {
                stringBuffer.append("\u03c1=");
            }
            n5 = 123;
            for (n2 = 5; n2 < 15; ++n2) {
                stringBuffer.append((char)n5);
                if (bl2) {
                    stringBuffer.append(this.sig5corr[n2]);
                } else {
                    ed.editDecimal(stringBuffer, this.sig5corr[n2], 0, -6, 0);
                }
                n5 = 44;
            }
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public boolean toEpoch(double d) {
        if (DEBUG) {
            this.dump("#...toEpoch(" + this.epoch + ") => " + d);
        }
        if (this.ready == 0) {
            this.compute_fix();
        }
        if (this.epoch == d) {
            return true;
        }
        if ((this.specified & 2) == 0) {
            return false;
        }
        if ((this.permanent & 0x200) != 0) {
            return false;
        }
        double d2 = d - this.epoch;
        if (this.frame.dotMatrix == Astroframe.Udot || Math.abs(this.frame.max_spin * d2) <= AstroMath.eps) {
            this.x += d2 * this.xd;
            this.y += d2 * this.yd;
            this.z += d2 * this.zd;
            if ((this.specified & 0x70) != 0) {
                Astropos.propagate_error(this.cov, d2);
            }
        } else {
            double[] dArray = (double[])this.frame.dotMatrix.clone();
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] * d2;
            }
            for (n = 0; n < dArray.length; n += 7) {
                int n3 = n;
                dArray[n3] = dArray[n3] + 1.0;
            }
            if (DEBUG) {
                AstroMath.printMatrix("#...change epoch from " + this.epoch + " to " + this.frame.epoch + " with:\n", dArray);
            }
            double[] dArray2 = new double[]{this.x, this.y, this.z, this.xd, this.yd, this.zd};
            AstroMath.m36v(dArray, dArray2, dArray2);
            this.x = dArray2[0];
            this.y = dArray2[1];
            this.z = dArray2[2];
            this.xd = dArray2[3];
            this.yd = dArray2[4];
            this.zd = dArray2[5];
            if ((this.specified & 0x70) != 0) {
                this.cov = AstroMath.mpt(dArray, this.cov);
            }
        }
        this.localMatrix(this.R);
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        this.epoch = d;
        this.ready = 1;
        return true;
    }

    @Override
    public boolean convertTo(Astroframe astroframe) {
        double[] dArray;
        if (this.ready == 0) {
            this.compute_fix();
        }
        if (DEBUG) {
            System.out.println("@@ COV: " + Arrays.toString(this.cov));
        }
        double d = astroframe.epoch;
        if (astroframe.equals(this.frame) && this.epoch == d) {
            return true;
        }
        if ((this.permanent & 0x200) != 0 && this.epoch != d) {
            System.err.println("#***Astroframe.convertTo(" + this.frame + "): epoch can't be changed, is: " + this.epoch);
            return false;
        }
        if (DEBUG) {
            System.out.println("#...Astropos.convert from " + this.getFrame() + ",Ep=" + this.epoch + " to " + astroframe + ",Ep=" + d);
        }
        double[] dArray2 = Astroframe.convertMatrix(this.frame, astroframe);
        if (DEBUG) {
            AstroMath.printMatrix("#...matrix used to convert from " + this.frame + " to " + astroframe + "\n", dArray2);
        }
        if ((this.specified & 2) != 0) {
            if (this.epoch != this.frame.epoch) {
                double d2 = this.frame.epoch - this.epoch;
                double[] dArray3 = (double[])this.frame.dotMatrix.clone();
                int n = 0;
                while (n < dArray3.length) {
                    int n2 = n++;
                    dArray3[n2] = dArray3[n2] * d2;
                }
                for (n = 0; n < dArray3.length; n += 7) {
                    int n3 = n;
                    dArray3[n3] = dArray3[n3] + 1.0;
                }
                if (DEBUG) {
                    AstroMath.printMatrix("#...change epoch from " + this.epoch + " to " + this.frame.epoch + " with:\n", dArray3);
                }
                dArray2 = AstroMath.mp(dArray2, dArray3);
                if (DEBUG) {
                    AstroMath.printMatrix("#... which results in the final conversion matrix:\n", dArray2);
                }
            }
            dArray = new double[6];
            dArray[3] = this.xd;
            dArray[4] = this.yd;
            dArray[5] = this.zd;
        } else {
            d = this.epoch;
            dArray = new double[]{this.x, this.y, this.z};
        }
        if (DEBUG) {
            AstroMath.printMatrix("#... u(in) = ", dArray);
        }
        AstroMath.m36v(dArray2, dArray, dArray);
        double[] dArray4 = null;
        if (((this.specified | this.estimated) & 0x170) != 0) {
            if (DEBUG) {
                System.out.println("#...Astropos.convertTo. HASerr: 112; HAScorr: 256");
            }
            if (DEBUG) {
                System.out.println("#...Astropos.convertTo: compute new covariance, length=" + dArray2.length);
            }
            if (this.cov != null) {
                if (dArray2.length == 9 && this.cov != null) {
                    Astropos.rotate_cov(dArray2, this.cov, this.cov);
                } else {
                    dArray4 = AstroMath.mpt(dArray2, this.cov);
                }
            }
        }
        if (DEBUG) {
            AstroMath.printMatrix("#... u(out)= ", dArray);
        }
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        if (dArray.length > 3) {
            this.xd = dArray[3];
            this.yd = dArray[4];
            this.zd = dArray[5];
        }
        this.epoch = d;
        this.frame = astroframe;
        this.meanEp = d;
        this.localMatrix(this.R);
        if (DEBUG) {
            AstroMath.printMatrix("\n#new_cov", dArray4);
        }
        if (dArray4 != null) {
            if (this.cov == null) {
                this.cov = dArray4;
            } else {
                System.arraycopy(dArray4, 0, this.cov, 0, this.cov.length);
            }
            if (DEBUG) {
                System.out.println("#...Astropos.convertTo: update covariance");
                AstroMath.printMatrix("#=>.cov ", this.cov);
                AstroMath.printMatrix("#thicov ", this.cov);
            }
        }
        this.ready = 1;
        return true;
    }

    public static boolean convert(Astropos astropos, Astropos astropos2) {
        double[] dArray;
        if (astropos.ready == 0) {
            astropos.compute_fix();
        }
        if (DEBUG) {
            System.out.println("#...Astropos.convert from " + astropos.getFrame() + ",Ep=" + astropos.epoch + " to " + astropos2.frame);
        }
        double d = astropos2.frame.epoch;
        astropos2.ready = 0;
        astropos2.permanent = 0;
        astropos2.specified = astropos.specified;
        astropos2.estimated = astropos.estimated;
        astropos2.epoch = astropos2.meanEp = d;
        astropos2.dlon = astropos.dlon;
        astropos2.dlat = astropos.dlat;
        astropos2.lat = Double.NaN;
        astropos2.lon = Double.NaN;
        astropos2.rv = astropos.rv;
        astropos2.e_rv = astropos.e_rv;
        astropos2.plx = astropos.plx;
        astropos2.e_plx = astropos.e_plx;
        if (astropos.sig5corr != null) {
            if (astropos2.sig5corr == null) {
                astropos2.sig5corr = (double[])astropos.sig5corr.clone();
            } else {
                System.arraycopy(astropos.sig5corr, 0, astropos2.sig5corr, 0, astropos.sig5corr.length);
            }
        }
        double[] dArray2 = Astroframe.convertMatrix(astropos.frame, astropos2.frame);
        if (DEBUG) {
            AstroMath.printMatrix("#...matrix used to convert from " + astropos.frame + " to " + astropos2.frame + "\n", dArray2);
        }
        if ((astropos.specified & 2) != 0) {
            if (astropos.epoch != astropos.frame.epoch) {
                double d2 = astropos.frame.epoch - astropos.epoch;
                double[] dArray3 = (double[])astropos.frame.dotMatrix.clone();
                int n = 0;
                while (n < dArray3.length) {
                    int n2 = n++;
                    dArray3[n2] = dArray3[n2] * d2;
                }
                for (n = 0; n < dArray3.length; n += 7) {
                    int n3 = n;
                    dArray3[n3] = dArray3[n3] + 1.0;
                }
                if (DEBUG) {
                    AstroMath.printMatrix("#...change epoch from " + astropos.epoch + " to " + astropos.frame.epoch + " with:\n", dArray3);
                }
                dArray2 = AstroMath.mp(dArray2, dArray3);
                if (DEBUG) {
                    AstroMath.printMatrix("#... which results in the final conversion matrix:\n", dArray2);
                }
            }
            dArray = new double[6];
            dArray[3] = astropos.xd;
            dArray[4] = astropos.yd;
            dArray[5] = astropos.zd;
        } else {
            d = astropos.epoch;
            dArray = new double[]{astropos.x, astropos.y, astropos.z};
        }
        if (DEBUG) {
            AstroMath.printMatrix("#... u(in) = ", dArray);
        }
        AstroMath.m36v(dArray2, dArray, dArray);
        if (((astropos.specified | astropos.estimated) & 0x170) != 0) {
            if (DEBUG) {
                System.out.println("#...Astropos.convert: compute new covariance, length=" + dArray2.length);
            }
            if (dArray2.length == 9) {
                if (astropos2.cov == null) {
                    astropos2.cov = new double[21];
                }
                Astropos.rotate_cov(dArray2, astropos.cov, astropos2.cov);
            } else {
                double[] dArray4 = AstroMath.mpt(dArray2, astropos.cov);
                if (astropos2.cov == null) {
                    astropos2.cov = dArray4;
                } else {
                    System.arraycopy(dArray4, 0, astropos2.cov, 0, dArray4.length);
                }
            }
        } else if (astropos2.cov != null) {
            for (int i = 0; i < astropos2.cov.length; ++i) {
                astropos2.cov[i] = 0.0;
            }
        }
        if (DEBUG) {
            AstroMath.printMatrix("#... u(out)= ", dArray);
        }
        astropos2.lat = Double.NaN;
        astropos2.lon = Double.NaN;
        astropos2.x = dArray[0];
        astropos2.y = dArray[1];
        astropos2.z = dArray[2];
        if (dArray.length > 3) {
            astropos2.xd = dArray[3];
            astropos2.yd = dArray[4];
            astropos2.zd = dArray[5];
        }
        astropos2.epoch = d;
        if (astropos2.R == null) {
            astropos2.R = astropos2.localMatrix();
        } else {
            astropos2.localMatrix(astropos2.R);
        }
        astropos2.specified = astropos.specified;
        astropos2.estimated = astropos.estimated;
        astropos2.ready = 1;
        return true;
    }
}

