/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroformat;
import cds.astro.Astroframe;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Editing;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Astrocoo
extends Coo
implements Serializable {
    public static boolean DEBUG = false;
    protected static double eps = AstroMath.eps;
    public Astroframe frame = null;
    public double epoch;
    protected byte dlon;
    protected byte dlat;
    protected byte precision;
    protected byte formRA;
    protected int editing;
    public static final byte NONE = 0;
    public static final byte DEG = 1;
    public static final byte ARCMIN = 3;
    public static final byte ARCSEC = 5;
    public static final byte MAS = 8;
    public static final int EDIT_FRAME = 256;
    public static final int EDIT_2NUMBERS = 512;
    public static final int EDIT_EPOCH = 1024;
    public static final int EDIT_MEAN_EPOCH = 2048;
    public static final int EDIT_FULL = 4096;
    public static final int EDIT_5SIGMAS = 8192;
    public static final int EDIT_NAMING = 16384;
    public static final int EDIT_CORRELATIONS = 32768;
    public static final int EDIT_DEFAULT = 3328;
    protected static final String[] explain_precision = new String[]{"unknown", "1degree", "0.1degree", "1arcmin", "0.1arcmin", "1arcsec", "0.1arcsec", "10mas", "1mas", "0.1mas", "10\u00b5as", "1\u00b5as", "0.1\u00b5as", "10nas", "1nas"};
    protected static final String[] explain_edition = new String[]{"frame", "2separate_components", "Epoch", "MeanEpoch", "Full_precision", "5sigmas", "=parameter_name", "correlations"};
    public static final char[] editing_options = new char[]{'s', 'd', ':', 'u', 'f', 'F', '2', 'E', 'M', '5', '=', 'c'};
    public static final String string_options = new String(editing_options);
    protected static final int[] Editing_options = new int[]{3, 0, 5, 9, 256, 4096, 512, 1024, 2048, 8192, 16384, 32768};

    public static final String explain(int n, String[] stringArray) {
        if (n == 0) {
            return "";
        }
        int n2 = n;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; n2 != 0 && i < stringArray.length; ++i, n2 >>>= 1) {
            if ((n2 & 1) == 0) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            if (i >= stringArray.length) break;
            stringBuilder.append(stringArray[i]);
        }
        if (n2 != 0) {
            stringBuilder.append("+0x" + Integer.toHexString(n2 << stringArray.length) + "??");
        }
        return stringBuilder.toString();
    }

    public static final String explainEditing(int n) {
        if (n == 0) {
            return "";
        }
        String string = Astroformat.explain(n);
        int n2 = n >>> 8;
        if (n2 == 0) {
            return string;
        }
        String string2 = Astrocoo.explain(n2, explain_edition);
        if (string.length() == 0) {
            return string2;
        }
        return string + ',' + string2;
    }

    @Override
    protected void computeLonLat() {
        if (this.frame instanceof FK4) {
            FK4 fK4 = (FK4)this.frame;
            double d = this.x;
            double d2 = this.y;
            double d3 = this.z;
            super.add(fK4.ev_eq);
            super.computeLonLat();
            this.x = d;
            this.y = d2;
            this.z = d3;
        } else {
            super.computeLonLat();
        }
    }

    public Astrocoo() {
        this(Astroframe.create("ICRS(2000)"));
        Astroframe astroframe = Astroframe.create("ICRS(2000)");
        if (!astroframe.isFixed()) {
            astroframe.fixFrame();
        }
    }

    public Astrocoo(Astroframe astroframe) {
        this.frame = astroframe;
        ++this.frame.usage;
        this.epoch = Double.NaN;
        this.precision = 0;
        this.dlat = 0;
        this.dlon = 0;
        this.setEditing();
    }

    public Astrocoo(Astroframe astroframe, double d, double d2) {
        this(astroframe, d, d2, Double.NaN);
    }

    public Astrocoo(Astroframe astroframe, double d, double d2, double d3) {
        this.frame = astroframe;
        ++this.frame.usage;
        this.setEditing();
        this.epoch = d3;
        this.precision = 0;
        this.dlat = 0;
        this.dlon = 0;
        super.set(d, d2);
        if (this.frame instanceof FK4) {
            FK4 fK4 = (FK4)this.frame;
            super.sub(fK4.ev_eq);
        }
    }

    public Astrocoo(Astroframe astroframe, String string) throws ParseException {
        this.frame = astroframe;
        ++this.frame.usage;
        this.set(string);
    }

    public Astrocoo(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        char c = parsing.currentChar();
        parsing.advance(1);
        if (Character.isLetter(c) && Character.isDigit(parsing.currentChar())) {
            this.frame = Astroframe.create(c);
            if (this.frame != null) {
                this.editing = this.frame.ed_lon | 0x100 | 0x400;
                while (parsing.pos < parsing.length) {
                    c = parsing.currentChar();
                    parsing.advance(1);
                    if (Character.isDigit(c) || c == '.') continue;
                }
                if (this.frame != null && Parsing.isSign(c)) {
                    this.setIAU(string);
                    return;
                }
            }
            parsing.set(0);
        }
        this.frame = Astroframe.parse(parsing);
        if (DEBUG) {
            System.out.println("#---Astrocoo(" + string + ") => frame=" + this.frame + ": usage=" + this.frame.usage);
        }
        if (this.frame == null) {
            throw new ParseException("[Astrocoo] argument '" + string + "' (no frame)", parsing.pos);
        }
        this.editing = this.frame.ed_lon | 0xD00;
        this.set(parsing.toString());
    }

    @Override
    public Object clone() {
        Astrocoo astrocoo = (Astrocoo)super.clone();
        return astrocoo;
    }

    public static double getEpoch(Parsing parsing) {
        int n = parsing.pos;
        double d = Double.NaN;
        parsing.gobbleSpaces();
        boolean bl = parsing.match('(');
        if (!Character.isLetter(parsing.currentChar()) && !bl) {
            parsing.set(n);
            return d;
        }
        Astrotime astrotime = new Astrotime();
        if (astrotime.parse(parsing)) {
            d = astrotime.getJyr();
            if (bl) {
                parsing.gobbleSpaces();
                if (!parsing.match(')')) {
                    d = Double.NaN;
                }
            }
        }
        if (Double.isNaN(d)) {
            parsing.set(n);
        }
        return d;
    }

    private boolean parse2(Parsing parsing, boolean bl) {
        double d;
        double d2;
        int n = parsing.pos;
        if (bl) {
            if (DEBUG) {
                System.out.println("#...Astrocoo.parse2(IAUform=true) <" + parsing + ">, frame=" + this.frame);
            }
            if (this.frame.equals(parsing.currentChar())) {
                parsing.advance(1);
            } else {
                return false;
            }
        }
        boolean bl2 = this.frame.hms;
        this.set();
        byte by = 0;
        byte by2 = 0;
        this.epoch = Double.NaN;
        if (DEBUG) {
            System.out.println("#...Astrocoo.parse2(IAUform=" + bl + "<" + parsing + ">), frame=" + this.frame + ", edit=(0x" + Integer.toHexString(this.frame.ed_lon) + ",0x" + Integer.toHexString(this.frame.ed_lat) + ")");
        }
        if (bl && bl2) {
            d2 = parsing.parseIAU();
            if (DEBUG) {
                System.out.println("#...Astrocoo.parse2[IAU]: lon=" + d2);
            }
        } else {
            parsing.gobbleSpaces();
            d2 = parsing.parseSexa2();
        }
        int n2 = 1 + parsing.decimals();
        if (parsing.inError() || n2 < 1) {
            if (DEBUG) {
                System.out.println(" prec(lon)=" + n2 + " **false**");
            }
            parsing.set(n);
            parsing.setError("[Astrocoo.parse] missing RA/longitude");
            return false;
        }
        if (bl && !Parsing.isSign(parsing.currentChar())) {
            parsing.setError("[Astrocoo.parse] missing sign in IAU name");
            return false;
        }
        boolean bl3 = parsing.isSexa();
        this.formRA = (byte)parsing.format();
        if (!bl) {
            if (parsing.isTime()) {
                bl2 = true;
            } else if (parsing.isAngle()) {
                bl2 = false;
            } else if (!bl3 && n2 > 0) {
                bl2 = false;
            }
        }
        if (bl2) {
            d2 *= 15.0;
            if (n2 > 0) {
                --n2;
            }
        }
        if (n2 > 15) {
            n2 = 15;
        }
        by2 = (byte)n2;
        if (DEBUG) {
            System.out.print(" dlon=" + by2);
        }
        if (bl && bl2) {
            d = parsing.parseIAU();
            if (DEBUG) {
                System.out.println("#...Astrocoo.parse2[IAU]: lat=" + d);
            }
        } else {
            parsing.gobbleSpaces();
            d = parsing.parseSexa();
        }
        if ((n2 = 1 + parsing.decimals()) > 15) {
            n2 = 15;
        }
        by = (byte)n2;
        if (DEBUG) {
            System.out.print(" dlat=" + by);
        }
        if (parsing.inError() || n2 < 1) {
            if (DEBUG) {
                System.out.println(" **false**");
            }
            parsing.setError("[Astrocoo.parse] missing Dec/latitude");
            parsing.set(n);
            return false;
        }
        bl3 |= parsing.isSexa();
        this.set(d2, d);
        this.dlon = by2;
        this.dlat = by;
        byte by3 = this.precision = by2 > by ? by2 : by;
        if (DEBUG) {
            System.out.println("; lon=" + d2 + " lat=" + d + " (ok), IAUform=" + bl);
        }
        int n3 = parsing.pos;
        parsing.gobbleSpaces();
        if (parsing.pos < parsing.length) {
            this.epoch = Astrocoo.getEpoch(parsing);
        }
        if (DEBUG) {
            System.out.println("#...Astrocoo.parse2: epoch=" + this.epoch);
        }
        return true;
    }

    public boolean parse(Parsing parsing) {
        return this.parse2(parsing, false);
    }

    public boolean parseIAU(Parsing parsing) {
        if (DEBUG) {
            System.out.println("#...Astrocoo.parseIAU <" + parsing + ">, frame=" + (this.frame == null ? "null" : this.frame.name));
        }
        if (this.frame == null) {
            this.frame = Astroframe.create(parsing.currentChar());
        }
        boolean bl = this.parse2(parsing, true);
        if (DEBUG) {
            System.out.println("#...Astrocoo.parseIAU: status=" + bl + "<" + parsing + ">");
        }
        return bl;
    }

    @Override
    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        if (this.parsing(parsing)) {
            return parsing.pos;
        }
        return n;
    }

    @Override
    public void set(double d, double d2) {
        super.set(d, d2);
        ++this.frame.usage;
        if (this.frame instanceof FK4) {
            FK4 fK4 = (FK4)this.frame;
            super.sub(fK4.ev_eq);
            d2 = Double.NaN;
            d = Double.NaN;
        }
    }

    @Override
    public void set(Coo coo) {
        this.x = coo.x;
        this.y = coo.y;
        this.z = coo.z;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        ++this.frame.usage;
    }

    @Override
    public void set(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        if (this.parse(parsing)) {
            parsing.gobbleSpaces();
        }
        ++this.frame.usage;
        if (parsing.pos != parsing.length) {
            String string2 = "[Astrocoo.set, frame=" + this.frame + "] argument '" + string + "'+" + parsing.pos;
            if (parsing.error_message != null) {
                string2 = string2 + ": " + parsing.error_message;
            }
            throw new ParseException(string2, parsing.pos);
        }
    }

    public void setIAU(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        char c = parsing.currentChar();
        if (!this.frame.equals(parsing.currentChar())) {
            throw new ParseException("[Astrocoo.setIAU, frame=" + this.frame + "] '" + string + "' (incompatible frames)", parsing.pos);
        }
        parsing.advance(1);
        if (DEBUG) {
            System.out.println("#...setIAU(" + string + "), editing=0x" + Integer.toHexString(this.editing));
        }
        if (this.parse2(parsing, true)) {
            parsing.gobbleSpaces();
        } else if (this.parse(parsing)) {
            parsing.gobbleSpaces();
        }
        if (parsing.pos != parsing.length) {
            String string2 = "[Astrocoo.setIAU, frame=" + this.frame + "] '" + string + "'+" + parsing.pos;
            if (parsing.error_message != null) {
                string2 = string2 + ": " + parsing.error_message;
            }
            throw new ParseException(string2, parsing.pos);
        }
    }

    public void set(Coo coo, double d) {
        this.epoch = d;
        this.set(coo);
        ++this.frame.usage;
    }

    public void setPrecision(int n) {
        if (n < 0 || n > 15) {
            n = 15;
        }
        this.precision = (byte)n;
    }

    public void setPrecision(int n, int n2) {
        if (n < 0 || n > 15) {
            n = 15;
        }
        if (n2 < 0 || n2 > 15) {
            n2 = 15;
        }
        this.dlon = (byte)n;
        this.dlat = (byte)n2;
        this.precision = this.dlon > this.dlat ? this.dlon : this.dlat;
    }

    public void setEditing(int n) {
        this.editing = n;
        if ((n & 0x1000) != 0) {
            this.setPrecision(15);
        }
    }

    public void setEditing(String string) {
        this.setEditing(Astrocoo.editingOptions(string));
    }

    public void setEditing() {
        int n = 3328;
        if (this.frame != null) {
            n |= this.frame.ed_lon;
        }
        this.setEditing(n);
    }

    public boolean setEpoch(double d) {
        this.epoch = d;
        return true;
    }

    public final Astroframe getFrame() {
        return this.frame;
    }

    @Override
    public double getLon() {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        return this.lon;
    }

    @Override
    public double getLat() {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        return this.lat;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public byte getLonPrec() {
        return this.dlon;
    }

    public byte getLatPrec() {
        return this.dlat;
    }

    public final int getEditing() {
        return this.editing;
    }

    @Override
    public void dump(String string) {
        boolean bl = string.indexOf("(R)") >= 0;
        System.out.print("#...Astrocoo.dump (" + this.getClass() + ") " + string);
        if (!string.endsWith("\n")) {
            System.out.print("\n");
        }
        String string2 = string.charAt(0) == '#' ? "#   " : "    ";
        super.dump(string2);
        System.out.println(string2 + "epoch=" + this.epoch + "; Astroframe=" + this.frame);
        if (bl) {
            this.frame.dump(string2 + "    ");
        }
        System.out.println(string2 + "precision=" + this.precision + "; editing=0x" + Integer.toHexString(this.editing) + '(' + Astrocoo.explainEditing(this.editing) + ')');
        System.out.println(string2 + "inputprec: dlon=" + this.dlon + ", dlat=" + this.dlat + ", formRA=0x" + Integer.toHexString(this.formRA) + '(' + Astroformat.explain(this.formRA) + ')');
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Astrocoo) {
            Astrocoo astrocoo = (Astrocoo)object;
            bl = this.frame.equals(astrocoo.frame) && super.equals(astrocoo);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        int n = this.frame.hashCode();
        n = n * 123 + super.hashCode();
        return n;
    }

    public static int editingOptions(String string) throws IllegalArgumentException {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n2;
            if (cArray[i] == '*') {
                n |= 0xD00;
                continue;
            }
            for (n2 = 0; n2 < editing_options.length && cArray[i] != editing_options[n2]; ++n2) {
            }
            if (n2 == editing_options.length) {
                throw new IllegalArgumentException("[Astrocoo.editingOptions] '" + string + "'; accepted=" + string_options);
            }
            if (Editing_options[n2] < 16) {
                n &= 0xFFFFFFF0;
            }
            n |= Editing_options[n2];
        }
        return n;
    }

    protected final StringBuffer editEpoch(StringBuffer stringBuffer, double d) {
        double d2 = this.epoch;
        if (Double.isNaN(d2)) {
            stringBuffer.append(' ');
        } else if (this.frame instanceof FK4) {
            stringBuffer.append('B');
            d2 = Astrotime.J2B(this.epoch);
        } else {
            stringBuffer.append('J');
        }
        ed.editDecimal(stringBuffer, d2, 4, -4, 32);
        return stringBuffer;
    }

    @Override
    public final StringBuffer edit(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        int n2 = this.precision & 0xF;
        if (n2 == 0) {
            n2 = this.frame.precision;
        }
        int n3 = n & 0xFFFFEEFF;
        if (DEBUG) {
            System.out.println("#...Astrocoo.edit(opt=0x" + Integer.toHexString(n) + "), epoch=" + this.epoch + ", precision=" + this.precision + ", dlon=" + this.dlon + ", dlat=" + this.dlat + ", lon=" + this.lon + ", lat=" + this.lat + " x=" + this.x + " y=" + this.y + " z=" + this.z);
        }
        if ((n & 0x1000) != 0) {
            n2 = 15;
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append(this.frame.toString());
            stringBuffer.append(' ');
        }
        double d = this.getLon();
        int n4 = 3;
        int n5 = n2;
        if (Astroformat.isSexa(n3)) {
            bl = this.frame.hms;
        }
        if (bl) {
            --n4;
            d /= 15.0;
            if (n5 > 0) {
                if (++n5 < 3) {
                    n5 = 3;
                }
            } else if (--n5 > -3) {
                n5 = -3;
            }
        }
        ed.editDecimal(stringBuffer, d, n4, n5 - 1, 0x20 | n3);
        if ((n & 0x200) != 0) {
            stringBuffer.append(' ');
        }
        if (Astroformat.isTime(n3)) {
            n3 = Astroformat.isSexa(n3) ? (n3 -= 2) : ++n3;
        }
        ed.editDecimal(stringBuffer, this.getLat(), 3, n2 - 1, 0x30 | n3);
        if ((n & 0x400) != 0 && !Double.isNaN(this.epoch)) {
            stringBuffer.append(" (");
            this.editEpoch(stringBuffer, this.epoch);
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.edit(stringBuffer, n);
        return stringBuffer.toString();
    }

    public String toString(String string) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.edit(stringBuffer, Astrocoo.editingOptions(string));
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.edit(stringBuffer, this.editing);
        return stringBuffer.toString();
    }

    public String toIAU(String string) throws ParseException {
        Object object;
        Astrocoo astrocoo = this;
        Editing editing = new Editing();
        Object object2 = string.charAt(0);
        Astroframe astroframe = null;
        if (object2 == 74) {
            if (this.frame instanceof ICRS) {
                astroframe = this.frame;
            } else if (this.frame instanceof FK5) {
                object = (FK5)this.frame;
                if (((FK5)object).equinox == 2000.0) {
                    astroframe = this.frame;
                }
            }
            if (astroframe == null) {
                astroframe = Astroframe.create("J2000");
            }
        } else if (object2 == 66) {
            if (this.frame instanceof FK4) {
                object = (FK4)this.frame;
                if (((FK4)object).equinox == 1950.0) {
                    astroframe = this.frame;
                }
            }
            if (astroframe == null) {
                astroframe = FK4.create();
            }
        } else if (object2 == 71) {
            if (this.frame instanceof Galactic) {
                astroframe = this.frame;
            }
            if (astroframe == null) {
                astroframe = Galactic.create();
            }
        } else {
            throw new ParseException("[Astrocoo.toIAU] template does not start with J|B|G: " + string, 0);
        }
        if (astroframe != this.frame) {
            astrocoo = new Astrocoo(astroframe);
            Astrocoo.convert(this, astrocoo);
        }
        object = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)object2);
        double d = astrocoo.lon;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 96;
        int n6 = 1;
        while (n6 < ((Object)object).length && n < 2) {
            int n7;
            if (object[n6] == 43) {
                n5 |= 0x10;
                ++n6;
                ++n4;
                continue;
            }
            object2 = object[n6];
            int n8 = Character.toUpperCase(object2);
            if (n8 == 72 && n == 0) {
                bl = !astroframe.hms;
                d /= 15.0;
            } else if (n8 == 76) {
                bl = astroframe.hms || n != 0;
            } else if (n8 == 66) {
                bl = astroframe.hms || n == 0;
            } else if (n8 != 68) {
                bl = true;
            }
            if (bl) {
                throw new ParseException("[Astrocoo.toIAU] '" + string + "': " + object2, n6);
            }
            bl2 = false;
            while (n6 < ((Object)object).length && object[n6] == object2) {
                ++n6;
                ++n4;
            }
            while (!(n6 >= ((Object)object).length || bl || object[n6] == 43 && n == 0)) {
                if (object[n6] == 46) {
                    bl2 = true;
                    ++n6;
                    continue;
                }
                n7 = Character.toUpperCase((char)object[n6]);
                if (n7 == n8 || object[n6] == 102) {
                    object2 = object[n6];
                    while (n6 < ((Object)object).length && object[n6] == object2) {
                        ++n6;
                        ++n3;
                    }
                    break;
                }
                if (n7 == 77 && (n8 == 68 || n8 == 72)) {
                    object2 = object[n6];
                    n8 = n7;
                    while (n6 < ((Object)object).length && object[n6] == object2) {
                        ++n6;
                        ++n3;
                    }
                    n2 = 2;
                    continue;
                }
                if (n7 == 83 && n8 == 77) {
                    object2 = object[n6];
                    n8 = n7;
                    while (n6 < ((Object)object).length && object[n6] == object2) {
                        ++n6;
                        ++n3;
                    }
                    n2 = 3;
                    continue;
                }
                bl = true;
            }
            if (bl) {
                throw new ParseException("[Astrocoo.toIAU] '" + string + "': " + (char)object[n6], n6);
            }
            n7 = stringBuffer.length();
            if (DEBUG) {
                System.out.print("# Edition(nint=" + n4 + ",nd=" + n3 + ",opt=0x" + Integer.toHexString(n5) + "): " + stringBuffer);
            }
            editing.editDecimal(stringBuffer, d, n4, n3, n5 | n2);
            if (n2 != 0 || !bl2) {
                while (n7 < stringBuffer.length()) {
                    object2 = stringBuffer.charAt(n7);
                    if (object2 == 32) {
                        stringBuffer.deleteCharAt(n7);
                        continue;
                    }
                    if (object2 == 46 && !bl2) {
                        stringBuffer.deleteCharAt(n7);
                        continue;
                    }
                    ++n7;
                }
            }
            if (DEBUG) {
                System.out.println(" => " + stringBuffer);
            }
            n2 = 0;
            n3 = 0;
            n4 = 0;
            bl = false;
            bl2 = false;
            n5 = 96;
            d = astrocoo.lat;
            ++n;
        }
        if (n6 < ((Object)object).length || n != 2) {
            throw new ParseException("[Astrocoo.toIAU] '" + string + "': " + (char)object[n6], n6);
        }
        return stringBuffer.toString();
    }

    public boolean convertTo(Astroframe astroframe) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return false;
        }
        if (this.frame.name.equals(astroframe.name)) {
            if (DEBUG) {
                System.out.println("#...Frame " + this.frame + "=" + astroframe);
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("#...Astrocoo.convert: via ICRS:  " + this.frame + " => ICRS => " + astroframe);
        }
        this.frame.toICRS(this);
        if (DEBUG) {
            this.dump("#ICRS: ");
        }
        astroframe.fromICRS(this);
        this.frame = astroframe;
        if (DEBUG) {
            this.dump("#NewF: ");
        }
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        return true;
    }

    public static boolean convert(Astrocoo astrocoo, Astrocoo astrocoo2) {
        if (astrocoo.x == 0.0 && astrocoo.y == 0.0 && astrocoo.z == 0.0) {
            return false;
        }
        Astrocoo astrocoo3 = astrocoo2;
        ((Coo)astrocoo3).set(astrocoo);
        if (DEBUG) {
            astrocoo2.dump("#source:");
        }
        astrocoo.frame.toICRS(astrocoo3);
        astrocoo2.frame.fromICRS(astrocoo3);
        astrocoo2.epoch = astrocoo.epoch;
        astrocoo2.dlon = astrocoo.dlon;
        astrocoo2.dlat = astrocoo.dlat;
        if (DEBUG) {
            astrocoo2.dump("#target:");
        }
        astrocoo2.lat = Double.NaN;
        astrocoo2.lon = Double.NaN;
        return true;
    }

    public static boolean test(int n, int n2) {
        int n3;
        System.out.print("#===Astrocoo.test: verbosity=" + n + ", level=" + n2 + "; \u03b5=" + eps);
        System.out.println("#===Get from IAU name:");
        try {
            Astrocoo astrocoo = new Astrocoo("B1234567-123456");
            astrocoo.dump("B1234567-123456");
        }
        catch (Exception exception) {
            System.err.println("#***" + exception);
        }
        ICRS iCRS = new ICRS(2015.5);
        Astrocoo astrocoo = new Astrocoo(iCRS, 318.20647269273, 41.39116740897);
        Astrocoo astrocoo2 = new Astrocoo(iCRS, 187.27791587249, 2.0523886103);
        astrocoo2.setEditing("fEMF");
        astrocoo.setEditing("fEMF");
        boolean bl = true;
        Astrocoo astrocoo3 = new Astrocoo(Astroframe.create('G'), 0.0, 90.0);
        astrocoo3.convertTo(Astroframe.create('I'));
        Astrocoo astrocoo4 = new Astrocoo(Astroframe.create('G'), 0.0, 0.0);
        astrocoo4.convertTo(Astroframe.create('I'));
        System.out.println("#---Position of Galactic North Pole in ICRS: " + astrocoo3.toString("F") + "; galactic centre: " + astrocoo4.toString("F"));
        Astroframe[] astroframeArray = new Astroframe[]{Astroframe.create("ICRS"), Astroframe.create("ICRS(2015.5)"), Astroframe.create("J2000"), Astroframe.create("FK5(B1950)"), Astroframe.create("B1950"), Astroframe.create("B1875"), Astroframe.create("Gal(B1950)"), Astroframe.create("SGal(B1950)"), Astroframe.create("Ecl(2015.5")};
        int n4 = astroframeArray.length;
        Astrocoo[] astrocooArray = new Astrocoo[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            astrocooArray[n3] = new Astrocoo(astroframeArray[n3]);
        }
        if (n > 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                astrocooArray[n3].setEditing("fEMF");
                System.out.println("\n#...Frame#" + n3 + ": " + astroframeArray[n3]);
                AstroMath.printMatrix("#.....toICRSmatrix:\n", astroframeArray[n3].toICRSmatrix);
                AstroMath.printMatrix("#...fromICRSmatrix:\n", astroframeArray[n3].fromICRSmatrix);
                double[] dArray = AstroMath.m36p(astroframeArray[n3].fromICRSmatrix, astroframeArray[n3].toICRSmatrix);
                AstroMath.checkUnity("#.....Product=.....\n", dArray);
                Astrocoo.convert(astrocoo2, astrocooArray[n3]);
                System.out.println("#====3C273 " + astrocooArray[n3]);
                Astrocoo.convert(astrocoo, astrocooArray[n3]);
                System.out.println("#=V1234Cyg " + astrocooArray[n3]);
            }
        }
        System.out.println("\n#---Example of 3C273: " + astrocoo2);
        for (n3 = 0; n3 < n4; ++n3) {
            Astrocoo.convert(astrocoo2, astrocooArray[n3]);
            System.out.println("#...Direct from Gaia-2: " + astrocooArray[n3]);
            if (n3 == 0) continue;
            Astrocoo.convert(astrocooArray[n3 - 1], astrocooArray[n3]);
            System.out.println("#...from preceding....: " + astrocooArray[n3]);
        }
        System.out.println("\n#---Example of V1234 Cyg: " + astrocoo);
        for (n3 = 0; n3 < n4; ++n3) {
            Astrocoo.convert(astrocoo, astrocooArray[n3]);
            System.out.println("#...Direct from Gaia-2: " + astrocooArray[n3]);
            if (n3 == 0) continue;
            Astrocoo.convert(astrocooArray[n3 - 1], astrocooArray[n3]);
            System.out.println("#...from preceding....: " + astrocooArray[n3]);
        }
        if (n == 0) {
            System.out.println(bl ? " (ok)" : " **problem(s)**");
        } else if (bl) {
            System.out.println("#---End of tests: ok");
        } else {
            System.out.println("#***Bad ** tests?");
        }
        return bl;
    }
}

