/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

public class AstroMath {
    public static final double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    public static final double DEG = 57.29577951308232;
    public static final double DEG2 = 3282.806350011744;
    public static final double ARCSEC = 206264.80624709636;
    public static final double MAS = 2.0626480624709636E8;
    public static final double ln10 = Math.log(10.0);
    public static double eps = Math.ulp(0.5);
    static final double ellEPS = 4.0E-16;
    public static final double[] U3matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    public static final double[] Urotspin = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public static final double[] U6matrix = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};

    public static final double cosd(double d) {
        return Math.cos(d / 57.29577951308232);
    }

    public static final double sind(double d) {
        return Math.sin(d / 57.29577951308232);
    }

    public static final double tand(double d) {
        return Math.tan(d / 57.29577951308232);
    }

    public static final double asind(double d) {
        return Math.asin(d) * 57.29577951308232;
    }

    public static final double atand(double d) {
        return Math.atan(d) * 57.29577951308232;
    }

    public static final double atan2d(double d, double d2) {
        return Math.atan2(d, d2) * 57.29577951308232;
    }

    public static final double atanh(double d) {
        return 0.5 * Math.log((1.0 + d) / (1.0 - d));
    }

    public static final double sinc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0E-4) {
            d3 *= d3;
            d2 = 1.0 - d3 * (1.0 - d3 / 20.0) / 6.0;
        } else {
            d2 = Math.sin(d3) / d3;
        }
        return d2;
    }

    public static final double asinc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0E-4) {
            d3 *= d3;
            d2 = 1.0 + d3 * (1.0 + d3 * 0.45) / 6.0;
        } else {
            d2 = Math.asin(d3) / d3;
        }
        return d2;
    }

    public static final double dexp(int n) {
        int n2 = n;
        int n3 = powers.length - 1;
        double d = 1.0;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n2 = -n;
        }
        while (n2 > n3) {
            d *= powers[n3];
            n2 -= n3;
        }
        d *= powers[n2];
        if (bl) {
            d = 1.0 / d;
        }
        return d;
    }

    public static final double dexp(double d) {
        return Math.exp(d * ln10);
    }

    public static final double log(double d) {
        return Math.log(d) / ln10;
    }

    public static final double ell1(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        if (d < d2) {
            d3 = d2;
            d4 = d;
        }
        int n = 50;
        while (--n >= 0 && d3 - d4 > 4.0E-16) {
            double d5 = (d3 + d4) / 2.0;
            double d6 = Math.sqrt(d3 * d4);
            d3 = d5;
            d4 = d6;
        }
        if (n < 0) {
            System.err.println("#+++AstroMath.ell1(" + d + "," + d2 + ") did not converge!");
        }
        return Math.PI / (d3 + d4);
    }

    public static final double ell1(double d) {
        return AstroMath.ell1(1.0, Math.sqrt(1.0 - d));
    }

    public static final double ell2(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        double d5 = 1.0;
        if (d < d2) {
            d3 = d2;
            d4 = d;
        }
        double d6 = (d3 * d3 + d4 * d4) / 2.0;
        int n = 50;
        while (--n >= 0 && d3 - d4 > 4.0E-16) {
            double d7 = (d3 - d4) / 2.0;
            d6 -= d5 * d7 * d7;
            d5 *= 2.0;
            double d8 = (d3 + d4) / 2.0;
            double d9 = Math.sqrt(d3 * d4);
            d3 = d8;
            d4 = d9;
        }
        if (n < 0) {
            System.err.println("#+++AstroMath.ell2(" + d + "," + d2 + ") did not converge!");
        }
        return Math.PI * d6 / (d3 + d4);
    }

    public static final double ell2(double d) {
        return AstroMath.ell2(1.0, Math.sqrt(1.0 - d));
    }

    public static final double ell3(double d, double d2) {
        double d3 = 1.0;
        double d4 = Math.sqrt(1.0 - d2);
        double d5 = (1.0 - d) / d4;
        double d6 = d / (1.0 - d);
        double d7 = 0.0;
        int n = 50;
        while (--n >= 0 && (d3 - d4 > 4.0E-16 || Math.abs(d5 - 1.0) > 4.0E-16)) {
            double d8 = (d5 * d6 + d7) / (1.0 + d5);
            d7 = (d6 + d7) / 2.0;
            double d9 = (d3 + d4) / 2.0;
            double d10 = Math.sqrt(d3 * d4);
            d5 = 0.25 * d10 / d9 * (2.0 + d5 + 1.0 / d5);
            d3 = d9;
            d4 = d10;
            d6 = d8;
        }
        if (n < 0) {
            System.err.println("#+++AstroMath.ell3(" + d + "," + d2 + ") did not converge!");
        }
        return Math.PI * (1.0 + d7) / (d3 + d4);
    }

    public static final double amax(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > d) {
                d = dArray[i];
                continue;
            }
            if (!(dArray[i] + d < 0.0)) continue;
            d = 0.0 - dArray[i];
        }
        return d;
    }

    public static final int dim(int n) {
        double d = Math.sqrt(n);
        if (d == Math.floor(d)) {
            return (int)d;
        }
        d = Math.sqrt(0.5 * (double)n);
        if (d == Math.floor(d)) {
            return (int)d;
        }
        d = 0.5 * (Math.sqrt(1.0 + 8.0 * (double)n) - 1.0);
        if (d != Math.floor(d)) {
            return 0;
        }
        d = -d;
        return (int)d;
    }

    public static final int symIndex(int n, int n2, int n3) {
        if (n2 == n3) {
            return n2;
        }
        return n2 < n3 ? (2 * n - n2) * (n2 + 1) / 2 + n3 - (n2 + 1) : (2 * n - n3) * (n3 + 1) / 2 + n2 - (n3 + 1);
    }

    public static final double[] msq(double[] dArray) {
        int n;
        int n2;
        int n3 = AstroMath.dim(dArray.length);
        if (n3 == 0) {
            return null;
        }
        if (n3 < 0) {
            n3 = -n3;
            double[] dArray2 = new double[n3 * n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                dArray2[n4] = dArray[n5];
                ++n5;
                n4 += n3 + 1;
            }
            n4 = n3;
            for (n5 = 0; n5 < n3; ++n5) {
                for (int i = n5 + 1; i < n3; ++i) {
                    double d = dArray[n4++];
                    dArray2[n3 * i + n5] = d;
                    dArray2[n3 * n5 + i] = d;
                }
            }
            return dArray2;
        }
        if (dArray.length == n3 * n3) {
            return dArray;
        }
        double[] dArray3 = new double[2 * dArray.length];
        int n6 = 0;
        for (n2 = 0; n2 < dArray.length; n2 += n3) {
            for (n = 0; n < n3; ++n) {
                dArray3[n6++] = dArray[n2 + n];
            }
            for (n = 0; n < n3; ++n) {
                dArray3[n6++] = 0.0;
            }
        }
        n2 = 0;
        for (n6 = n3 * (2 * n3 + 1); n6 < dArray3.length; n6 += n3) {
            for (n = 0; n < n3; ++n) {
                dArray3[n6++] = dArray[n2++];
            }
        }
        return dArray3;
    }

    public static final double[] m3t(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[3], dArray[6], dArray[1], dArray[4], dArray[7], dArray[2], dArray[5], dArray[8]};
        return dArray2;
    }

    public static final double[] transposed(double[] dArray) {
        int n = dArray.length;
        if (n == 9) {
            return AstroMath.m3t(dArray);
        }
        int n2 = AstroMath.dim(n);
        if (n2 < 0) {
            return dArray;
        }
        if (n2 == 0) {
            System.err.println("#***AstroMath.transposed: " + n + "-vector not a square matrix");
            return null;
        }
        double[] dArray2 = new double[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; j += n2) {
                dArray2[n3++] = dArray[i + j];
            }
        }
        return dArray2;
    }

    public static final double[] m6(double[] dArray) {
        if (dArray.length == 36) {
            return dArray;
        }
        if (dArray.length != 9 && dArray.length != 18) {
            return null;
        }
        double[] dArray2 = new double[36];
        if (dArray == U3matrix) {
            System.arraycopy(U6matrix, 0, dArray2, 0, 36);
        } else {
            for (int i = 0; i < 18; i += 6) {
                int n;
                int n2 = i / 2;
                for (n = 0; n < 3; ++n) {
                    dArray2[i + n] = dArray[n2 + n];
                    dArray2[i + n + 21] = dArray[n2 + n];
                    dArray2[i + n + 18] = 0.0;
                    dArray2[i + n + 3] = 0.0;
                }
                if (dArray.length != 18) continue;
                for (n = 0; n < 3; ++n) {
                    dArray2[i + n + 18] = dArray[n2 + n + 9];
                }
            }
        }
        return dArray2;
    }

    public static final double[] m3p(double[] dArray, double[] dArray2) {
        if (dArray == U3matrix) {
            return dArray2;
        }
        if (dArray2 == U3matrix) {
            return dArray;
        }
        if (dArray.length > 18 || dArray2.length > 18) {
            System.err.println("#***AstroMath.m3p(" + dArray.length + "x" + dArray2.length + ") not compatible with 3x3 matrices.");
            return null;
        }
        double[] dArray3 = new double[9];
        for (int i = 0; i < 9; i += 3) {
            for (int j = 0; j < 3; ++j) {
                dArray3[i + j] = dArray[i] * dArray2[j] + dArray[i + 1] * dArray2[j + 3] + dArray[i + 2] * dArray2[j + 6];
            }
        }
        return dArray3;
    }

    public static final double[] m3pm(double[] dArray, double[] ... dArray2) {
        if (dArray2.length < 1) {
            return dArray;
        }
        double[] dArray3 = AstroMath.m3p(dArray, dArray2[0]);
        double[] dArray4 = null;
        for (int i = 1; i < dArray2.length; ++i) {
            double[] dArray5 = dArray2[i];
            if (dArray5 == U3matrix) continue;
            if (dArray4 == null) {
                dArray4 = dArray3;
                dArray3 = new double[9];
            } else {
                System.arraycopy(dArray3, 0, dArray4, 0, 9);
            }
            for (int j = 0; j < 9; j += 3) {
                for (int k = 0; k < 3; ++k) {
                    dArray3[j + k] = dArray4[j] * dArray5[k] + dArray4[j + 1] * dArray5[k + 3] + dArray4[j + 2] * dArray5[k + 6];
                }
            }
        }
        return dArray3;
    }

    public static final double[] mp(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n == 3 && n2 == 3) {
            return AstroMath.m3p(dArray, dArray2);
        }
        int n3 = AstroMath.dim(dArray.length);
        if (n3 <= 0) {
            System.err.println("#***AstroMath.mp(" + dArray.length + " x " + dArray2.length + ") requires 2 square matrices of same dim.");
            return null;
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; i += n3) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n3; ++k) {
                    d += dArray[i + k] * dArray2[k * n3 + j];
                }
                dArray3[i + j] = d;
            }
        }
        return dArray3;
    }

    public static final double[] mpm(double[] dArray, double[] ... dArray2) {
        if (dArray2.length < 1) {
            return dArray;
        }
        int n = AstroMath.dim(dArray.length);
        if (n <= 0) {
            return null;
        }
        double[] dArray3 = AstroMath.mp(dArray, dArray2[0]);
        double[] dArray4 = null;
        for (int i = 1; i < dArray2.length && dArray3 != null; ++i) {
            double[] dArray5 = dArray2[i];
            if (dArray4 == null) {
                dArray4 = dArray3;
                dArray3 = new double[dArray.length];
            } else {
                System.arraycopy(dArray3, 0, dArray4, 0, dArray.length);
            }
            for (int j = 0; j < dArray.length; j += n) {
                for (int k = 0; k < n; ++k) {
                    double d = 0.0;
                    for (int i2 = 0; i2 < n; ++i2) {
                        d += dArray4[j + i2] * dArray5[i2 * n + k];
                    }
                    dArray3[j + k] = d;
                }
            }
        }
        return dArray3;
    }

    public static final boolean m36v(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4;
        int n;
        int n2 = dArray2.length;
        if (dArray == U3matrix) {
            if (dArray3 != dArray2) {
                System.arraycopy(dArray2, 0, dArray3, 0, n2);
            }
            return true;
        }
        if (dArray.length >= 36) {
            n = 6;
        } else if (dArray.length == 9 || dArray.length == 18) {
            n = 3;
        } else {
            return false;
        }
        if (dArray2 == dArray3) {
            dArray4 = new double[n2];
            System.arraycopy(dArray2, 0, dArray4, 0, n2);
        } else {
            dArray4 = dArray2;
        }
        if (n2 == 3) {
            for (int i = 0; i < 3; ++i) {
                int n3 = i * n;
                dArray3[i] = dArray[n3 + 0] * dArray4[0] + dArray[n3 + 1] * dArray4[1] + dArray[n3 + 2] * dArray4[2];
            }
        } else if (n == 6) {
            for (int i = 0; i < 6; ++i) {
                int n4 = i * n;
                dArray3[i] = dArray[n4 + 0] * dArray4[0] + dArray[n4 + 1] * dArray4[1] + dArray[n4 + 2] * dArray4[2] + dArray[n4 + 3] * dArray4[3] + dArray[n4 + 4] * dArray4[4] + dArray[n4 + 5] * dArray4[5];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                int n5 = 3 * i;
                dArray3[i] = dArray[n5] * dArray4[0] + dArray[n5 + 1] * dArray4[1] + dArray[n5 + 2] * dArray4[2];
                dArray3[i + 3] = dArray[n5] * dArray4[3] + dArray[n5 + 1] * dArray4[4] + dArray[n5 + 2] * dArray4[5];
                if (dArray.length == 9) continue;
                int n6 = i + 3;
                dArray3[n6] = dArray3[n6] + (dArray[n5 += 9] * dArray4[0] + dArray[n5 + 1] * dArray4[1] + dArray[n5 + 2] * dArray4[2]);
            }
        }
        return true;
    }

    public static final double[] m36v(double[] dArray, double[] dArray2) {
        if (dArray == U3matrix) {
            return dArray2;
        }
        double[] dArray3 = new double[dArray2.length];
        AstroMath.m36v(dArray, dArray2, dArray3);
        return dArray3;
    }

    public static final double[] m36p(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block23: {
            int n;
            int n2;
            block22: {
                if (dArray2.length <= 6) {
                    return AstroMath.m36v(dArray, dArray2);
                }
                n2 = dArray.length;
                n = dArray2.length;
                int n3 = n2 ^ n;
                int n4 = Math.max(n2, n);
                dArray3 = null;
                if (n3 == 0) {
                    if (n4 == 9) {
                        return AstroMath.m3p(dArray, dArray2);
                    }
                    if (n4 == 18) {
                        dArray3 = new double[n4];
                        for (int i = 0; i < 3; ++i) {
                            int n5 = i * 3;
                            int n6 = n5 + 9;
                            for (int j = 0; j < 3; ++j) {
                                dArray3[n5 + j] = dArray[n5 + 0] * dArray2[j + 0] + dArray[n5 + 1] * dArray2[j + 3] + dArray[n5 + 2] * dArray2[j + 6];
                                dArray3[n6 + j] = dArray[n6 + 0] * dArray2[j + 0] + dArray[n6 + 1] * dArray2[j + 3] + dArray[n6 + 2] * dArray2[j + 6] + dArray[n5 + 0] * dArray2[j + 9] + dArray[n5 + 1] * dArray2[j + 12] + dArray[n5 + 2] * dArray2[j + 15];
                            }
                        }
                        return dArray3;
                    }
                    if (n4 == 36) {
                        return AstroMath.mp(dArray, dArray2);
                    }
                } else {
                    if (n3 == 27) {
                        dArray3 = new double[n4];
                        for (int i = 0; i < 3; ++i) {
                            int n7;
                            int n8 = i * 3;
                            int n9 = n8 + 9;
                            for (n7 = 0; n7 < 3; ++n7) {
                                dArray3[n8 + n7] = dArray[n8 + 0] * dArray2[n7 + 0] + dArray[n8 + 1] * dArray2[n7 + 3] + dArray[n8 + 2] * dArray2[n7 + 6];
                            }
                            if (n2 > 9) {
                                for (n7 = 0; n7 < 3; ++n7) {
                                    dArray3[n9 + n7] = dArray[n9 + 0] * dArray2[n7 + 0] + dArray[n9 + 1] * dArray2[n7 + 3] + dArray[n9 + 2] * dArray2[n7 + 6];
                                }
                            }
                            if (n <= 9) continue;
                            for (n7 = 0; n7 < 3; ++n7) {
                                dArray3[n9 + n7] = dArray[n8 + 0] * dArray2[n7 + 9] + dArray[n8 + 1] * dArray2[n7 + 12] + dArray[n8 + 2] * dArray2[n7 + 15];
                            }
                        }
                        return dArray3;
                    }
                    if (n4 == 36) {
                        dArray3 = new double[n4];
                    }
                }
                if (dArray3 == null) {
                    System.err.println("#***AstroMath.m36p(" + n2 + "," + n + ") not valid: matrix product restricted to 3x3 or 6x6");
                    return null;
                }
                if (n2 != 36) break block22;
                for (int i = 0; i < 9; i += 3) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 36; k += (k & 1) == 0 ? 3 : 15) {
                            int n10 = k + 2 * i;
                            dArray3[n10 + j] = dArray[n10] * dArray2[j] + dArray[n10 + 1] * dArray2[j + 3] + dArray[n10 + 2] * dArray2[j + 6];
                            if (n == 9 || (k & 1) != 0) continue;
                            int n11 = n10 + j;
                            dArray3[n11] = dArray3[n11] + (dArray[n10 + 3] * dArray2[j + 9] + dArray[n10 + 4] * dArray2[j + 12] + dArray[n10 + 5] * dArray2[j + 15]);
                        }
                    }
                }
                break block23;
            }
            if (n != 36) break block23;
            for (int i = 0; i < 9; i += 3) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 36; k += (k & 1) == 0 ? 3 : 15) {
                        int n12 = k + j;
                        dArray3[n12 + 2 * i] = dArray[i] * dArray2[n12] + dArray[i + 1] * dArray2[n12 + 6] + dArray[i + 2] * dArray2[n12 + 12];
                        if (n2 == 9 || k < 18) continue;
                        int n13 = n12 + 2 * i;
                        dArray3[n13] = dArray3[n13] + (dArray[i + 9] * dArray2[n12 - 18] + dArray[i + 10] * dArray2[n12 - 12] + dArray[i + 11] * dArray2[n12 - 6]);
                    }
                }
            }
        }
        return dArray3;
    }

    public static final boolean mpt(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2;
        if (dArray2 == dArray3) {
            return false;
        }
        if (dArray2.length != dArray3.length) {
            return false;
        }
        int n3 = AstroMath.dim(dArray.length);
        int n4 = AstroMath.dim(dArray2.length);
        boolean bl = false;
        if (n4 < 0) {
            n4 = -n4;
            bl = true;
        }
        if (n3 != n4) {
            System.err.println("#***AstroMath.mpt(" + dArray.length + "," + dArray2.length + "): incompatible dim. for T and V.");
            return false;
        }
        int n5 = bl ? n4 : 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = n4 * n2;
            if (!bl) {
                n5 += n2;
            }
            for (n = n2; n < n4; ++n) {
                int n7;
                int n8;
                int n9 = n4 * n;
                int n10 = bl ? n4 : 0;
                double d = 0.0;
                if (bl) {
                    for (n8 = 0; n8 < n4; ++n8) {
                        d += dArray[n6 + n8] * dArray[n9 + n8] * dArray2[n8];
                        for (n7 = n8 + 1; n7 < n4; ++n7) {
                            d += (dArray[n6 + n8] * dArray[n9 + n7] + dArray[n6 + n7] * dArray[n9 + n8]) * dArray2[n10++];
                        }
                    }
                } else {
                    for (n8 = 0; n8 < n4; ++n8) {
                        for (n7 = 0; n7 < n4; ++n7) {
                            d += dArray[n6 + n8] * dArray[n9 + n7] * dArray2[n10++];
                        }
                    }
                }
                if (bl && n2 == n) {
                    dArray3[n2] = d;
                    continue;
                }
                dArray3[n5++] = d;
            }
        }
        if (bl) {
            return true;
        }
        for (n2 = 1; n2 < n4; ++n2) {
            for (n = 0; n < n2; ++n) {
                dArray3[n2 * n4 + n] = dArray3[n * n4 + n2];
            }
        }
        return true;
    }

    public static final double[] mpt(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        if (AstroMath.mpt(dArray, dArray2, dArray3)) {
            return dArray3;
        }
        return null;
    }

    public static double[] rotation(String string, double ... dArray) {
        if (string.length() < 1) {
            return U3matrix;
        }
        double[] dArray2 = new double[9];
        double d = 57.29577951308232;
        char[] cArray = string.toCharArray();
        int n = 0;
        System.arraycopy(U3matrix, 0, dArray2, 0, 9);
        block9: for (int i = 0; i < cArray.length; ++i) {
            int n2;
            int n3;
            int n4;
            char c = Character.toLowerCase(string.charAt(i));
            switch (Character.toLowerCase(cArray[i])) {
                case 'z': {
                    n4 = 2;
                    n3 = 0;
                    n2 = 1;
                    break;
                }
                case 'y': {
                    n4 = 1;
                    n3 = 2;
                    n2 = 0;
                    break;
                }
                case 'x': {
                    n4 = 0;
                    n3 = 1;
                    n2 = 2;
                    break;
                }
                case 'r': {
                    d = 1.0;
                    continue block9;
                }
                case '\"': 
                case 's': {
                    d = 206264.80624709636;
                    continue block9;
                }
                case 'm': {
                    d = 2.0626480624709636E8;
                    continue block9;
                }
                case 'd': 
                case '\u00b0': {
                    d = 57.29577951308232;
                    continue block9;
                }
                default: {
                    System.err.println("#+++AstroMath.rotation(" + string + "): char#" + i + " <" + cArray[i] + "> stops the computation.");
                    return dArray2;
                }
            }
            double d2 = dArray[n++] / d;
            if (d2 == 0.0) continue;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            int n5 = n4 * 3;
            int n6 = n3 * 3;
            int n7 = n2 * 3;
            double d5 = dArray2[n5 + n3];
            double d6 = dArray2[n6 + n3];
            double d7 = dArray2[n7 + n3];
            double d8 = dArray2[n5 + n2];
            double d9 = dArray2[n6 + n2];
            double d10 = dArray2[n7 + n2];
            dArray2[n5 + n3] = d5 * d3 + d8 * d4;
            dArray2[n6 + n3] = d6 * d3 + d9 * d4;
            dArray2[n7 + n3] = d7 * d3 + d10 * d4;
            dArray2[n5 + n2] = d8 * d3 - d5 * d4;
            dArray2[n6 + n2] = d9 * d3 - d6 * d4;
            dArray2[n7 + n2] = d10 * d3 - d7 * d4;
        }
        return dArray2;
    }

    public static double[] rotspin(String string, double ... dArray) {
        int n;
        double d;
        int n2;
        if (string.length() < 1) {
            return Urotspin;
        }
        char[] cArray = string.toCharArray();
        double[] dArray2 = new double[9 * (cArray.length + 1)];
        double d2 = 57.29577951308232;
        int n3 = 0;
        System.arraycopy(U3matrix, 0, dArray2, 0, 9);
        for (n2 = 9; n2 < 18; ++n2) {
            dArray2[n2] = 0.0;
        }
        block10: for (n2 = 0; n2 < string.length(); ++n2) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            int n4;
            int n5;
            int n6;
            switch (Character.toLowerCase(cArray[n2])) {
                case 'z': {
                    n6 = 2;
                    n5 = 0;
                    n4 = 1;
                    break;
                }
                case 'y': {
                    n6 = 1;
                    n5 = 2;
                    n4 = 0;
                    break;
                }
                case 'x': {
                    n6 = 0;
                    n5 = 1;
                    n4 = 2;
                    break;
                }
                case 'r': {
                    d2 = 1.0;
                    continue block10;
                }
                case '\"': 
                case 's': {
                    d2 = 206264.80624709636;
                    continue block10;
                }
                case 'm': {
                    d2 = 2.0626480624709636E8;
                    continue block10;
                }
                case 'd': 
                case '\u00b0': {
                    d2 = 57.29577951308232;
                    continue block10;
                }
                default: {
                    System.err.println("#***AstroMath.rotspin(" + string + "): char#" + n2 + " <" + cArray[n2] + "> not understood!");
                    return null;
                }
            }
            d = dArray[n3++] / d2;
            double d9 = Math.cos(d);
            double d10 = Math.sin(d);
            System.arraycopy(dArray2, 0, dArray2, n3 * 9, 9);
            int n7 = n6 * 3;
            int n8 = n5 * 3;
            int n9 = n4 * 3;
            if (d != 0.0) {
                for (int i = 0; i < n3; ++i) {
                    n = 9 * i;
                    d8 = dArray2[n + n7 + n5];
                    d7 = dArray2[n + n8 + n5];
                    d6 = dArray2[n + n9 + n5];
                    d5 = dArray2[n + n7 + n4];
                    d4 = dArray2[n + n8 + n4];
                    d3 = dArray2[n + n9 + n4];
                    dArray2[n + n7 + n5] = d8 * d9 + d5 * d10;
                    dArray2[n + n8 + n5] = d7 * d9 + d4 * d10;
                    dArray2[n + n9 + n5] = d6 * d9 + d3 * d10;
                    dArray2[n + n7 + n4] = d5 * d9 - d8 * d10;
                    dArray2[n + n8 + n4] = d4 * d9 - d7 * d10;
                    dArray2[n + n9 + n4] = d3 * d9 - d6 * d10;
                }
            }
            n = n3 * 9;
            d8 = dArray2[n + n7 + n5];
            d7 = dArray2[n + n8 + n5];
            d6 = dArray2[n + n9 + n5];
            d5 = dArray2[n + n7 + n4];
            d4 = dArray2[n + n8 + n4];
            d3 = dArray2[n + n9 + n4];
            dArray2[n + n7 + n6] = 0.0;
            dArray2[n + n8 + n6] = 0.0;
            dArray2[n + n9 + n6] = 0.0;
            dArray2[n + n7 + n5] = -d8 * d10 + d5 * d9;
            dArray2[n + n8 + n5] = -d7 * d10 + d4 * d9;
            dArray2[n + n9 + n5] = -d6 * d10 + d3 * d9;
            dArray2[n + n7 + n4] = -d5 * d10 - d8 * d9;
            dArray2[n + n8 + n4] = -d4 * d10 - d7 * d9;
            dArray2[n + n9 + n4] = -d3 * d10 - d6 * d9;
        }
        if (n3 == 0) {
            return U3matrix;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n10;
            d = dArray[n3 + n2] / d2;
            n = (n2 + 1) * 9;
            if (n2 == 0) {
                for (n10 = 0; n10 < 9; ++n10) {
                    int n11 = 9 + n10;
                    dArray2[n11] = dArray2[n11] * d;
                }
                continue;
            }
            if (d == 0.0) continue;
            for (n10 = 0; n10 < 9; ++n10) {
                int n12 = 9 + n10;
                dArray2[n12] = dArray2[n12] + d * dArray2[n + n10];
            }
        }
        double[] dArray3 = new double[18];
        System.arraycopy(dArray2, 0, dArray3, 0, 18);
        return dArray3;
    }

    public static final double[] rot_inv(double[] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        if (n3 == 9) {
            return AstroMath.m3t(dArray);
        }
        if (n3 != 18) {
            System.err.println("#***AstroMath.rot_inv: " + n3 + "-vector not rotation or rotspin matrix");
            return null;
        }
        double[] dArray2 = new double[n3];
        int n4 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 9; n += 3) {
                dArray2[n4++] = dArray[n2 + n];
            }
        }
        for (n2 = 0; n2 < 9; n2 += 3) {
            for (n = 0; n < 3; ++n) {
                double d = 0.0;
                n4 = n * 3;
                for (int i = 0; i < 3; ++i) {
                    d += dArray[n4 + i] * (dArray2[n2] * dArray[i + 9] + dArray2[n2 + 1] * dArray[i + 12] + dArray2[n2 + 2] * dArray[i + 15]);
                }
                dArray2[9 + n2 + n] = -d;
            }
        }
        return dArray2;
    }

    public static double[] motionMatrix(double d) {
        double[] dArray = new double[36];
        System.arraycopy(U6matrix, 0, dArray, 0, 36);
        dArray[3] = d;
        dArray[10] = d;
        dArray[17] = d;
        return dArray;
    }

    public static double[] motionMatrix(double d, double[] dArray) {
        double[] dArray2;
        if (d == 0.0 && (dArray.length == 9 || dArray.length == 36)) {
            return dArray;
        }
        if (dArray.length == 36) {
            dArray2 = new double[36];
            System.arraycopy(dArray, 0, dArray2, 0, 36);
        } else {
            dArray2 = AstroMath.m6(dArray);
        }
        for (int i = 0; i < 18; i += 6) {
            for (int j = 0; j < 6; ++j) {
                int n = i + j;
                dArray2[n] = dArray2[n] + d * dArray2[i + j + 18];
            }
        }
        return dArray2;
    }

    public static double[] motionMatrix(double[] dArray, double d) {
        double[] dArray2;
        if (d == 0.0 && (dArray.length == 9 || dArray.length == 36)) {
            return dArray;
        }
        if (dArray.length == 36) {
            dArray2 = new double[36];
            System.arraycopy(dArray, 0, dArray2, 0, 36);
        } else {
            dArray2 = AstroMath.m6(dArray);
        }
        for (int i = 0; i < 36; i += 6) {
            for (int j = 0; j < 3; ++j) {
                int n = i + j + 3;
                dArray2[n] = dArray2[n] + d * dArray2[i + j];
            }
        }
        return dArray2;
    }

    public static double[] motionMatrix(double[] dArray, double d, double[] dArray2) {
        if (d == 0.0) {
            return AstroMath.m36p(dArray, dArray2);
        }
        return AstroMath.m36p(dArray, AstroMath.motionMatrix(d, dArray2));
    }

    protected static final String toString(double[] dArray) {
        return AstroMath.toString("", dArray);
    }

    protected static final String toString(String string, double[] dArray) {
        int n;
        int n2;
        int n3;
        String string2 = "                        ";
        StringBuilder stringBuilder = new StringBuilder(string);
        StringBuilder stringBuilder2 = null;
        boolean bl = string.endsWith("\n");
        if (dArray == null) {
            if (bl) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(" (null)");
            if (bl) {
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
        boolean bl2 = dArray.length == 18;
        boolean bl3 = false;
        int n4 = dArray.length;
        if (bl) {
            stringBuilder2 = new StringBuilder("    ");
            stringBuilder.append((CharSequence)stringBuilder2);
        } else if (n4 > 6) {
            bl = true;
            n3 = string.length();
            stringBuilder2 = new StringBuilder(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuilder2.append(' ');
            }
        }
        if (n4 > 6) {
            n = AstroMath.dim(n4);
            if (n < 0) {
                bl3 = true;
                n4 = -n;
            } else {
                n4 = n4 > 18 ? 6 : 3;
            }
        }
        n3 = n4 > 3 ? 1 : 0;
        int n5 = dArray.length > 6 ? n4 : 1;
        block1: for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            int n7 = n6 = bl3 ? (n2 + 1) * (2 * n4 - n2) / 2 : n2 * n4;
            if (n2 > 0) {
                n = stringBuilder.length() - 1;
                while (stringBuilder.charAt(n) == ' ') {
                    stringBuilder.setLength(n--);
                }
                stringBuilder.append('\n');
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            boolean bl4 = bl2;
            while (true) {
                if (bl4 ^ bl2) {
                    stringBuilder.append("; ");
                }
                for (int i = 0; i < n4; ++i) {
                    double d;
                    if (bl3) {
                        if (i < n2) {
                            stringBuilder.append(string2);
                            continue;
                        }
                        d = i == n2 ? dArray[n2] : dArray[n6++];
                    } else {
                        d = dArray[n6 + i];
                    }
                    n = stringBuilder.length() + 23;
                    double d2 = Math.abs(d);
                    stringBuilder.append(d >= 0.0 ? (char)' ' : '-');
                    stringBuilder.append(Math.abs(d));
                    n -= stringBuilder.length();
                    while (n > 0) {
                        stringBuilder.append(' ');
                        --n;
                    }
                    stringBuilder.append(' ');
                }
                if (!bl4) continue block1;
                n6 += 9;
                bl4 ^= true;
            }
        }
        if (bl) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static final double diffArray(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray == null ? 0 : dArray.length;
        int n3 = n = dArray2 == null ? 0 : dArray2.length;
        if (n == 0 || n2 == 0 || n != n2) {
            return -1.0 / eps;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(dArray[i] - dArray2[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static boolean checkArray(String string, double[] dArray, double[] dArray2, double d) {
        double d2;
        int n;
        System.out.print(string + "(dmax=" + d + ")");
        int n2 = dArray == null ? 0 : dArray.length;
        int n3 = n = dArray2 == null ? 0 : dArray2.length;
        if (d < 0.0) {
            d = -d * eps;
        }
        if (d == 0.0) {
            d = eps;
        }
        if ((d2 = AstroMath.diffArray(dArray, dArray2)) < 0.0) {
            System.out.println("#+++checkArray: attempting to compare " + n2 + "- and " + n + "-arrays");
            return false;
        }
        boolean bl = true;
        if (d2 > d) {
            for (int i = 0; i < n; ++i) {
                double d3 = dArray[i] - dArray2[i];
                if (Math.abs(d3) <= d) continue;
                d3 = Math.rint(10.0 * d3 / d) / 10.0;
                System.out.print(" [" + i + (d3 > 0.0 ? "]+" : "]") + d3);
                if (!(Math.abs(d3) >= 4.0)) continue;
                System.out.print("**");
            }
            bl = false;
        }
        d2 = Math.rint(10.0 * d2 / d) / 10.0;
        String string2 = Double.toString(d);
        if (string2.length() > 8) {
            int n4 = string2.indexOf("E");
            if (n4 > 0) {
                double d4 = Double.valueOf(string2.substring(0, n4));
                string2 = Double.toString(Math.rint(1000.0 * d4) / 1000.0) + string2.substring(n4);
            } else {
                string2 = Double.toString(Math.rint(1000.0 * d) / 1000.0);
            }
        }
        double d5 = Math.log10(d);
        double d6 = Math.floor(d5);
        d = AstroMath.dexp(d6) * Math.rint(1000.0 * AstroMath.dexp(d5 - d6)) / 1000.0;
        System.out.print("; max=(" + string2 + ")*" + d2);
        if (bl) {
            System.out.println(" (ok)");
        } else {
            System.out.println(" (" + d2 + ")" + (d2 > 8.0 ? "**" : "++"));
        }
        return bl;
    }

    public static boolean checkArray(String string, double[] dArray, double[] dArray2) {
        return AstroMath.checkArray(string, dArray, dArray2, 4.0 * eps);
    }

    public static boolean checkUnity(String string, double[] dArray) {
        double[] dArray2 = U3matrix;
        if (dArray.length == 36) {
            dArray2 = U6matrix;
        }
        if (dArray.length == 18) {
            dArray2 = Urotspin;
        }
        return AstroMath.checkArray(string, dArray, dArray2, 4.0 * eps);
    }

    public static final void printMatrix(String string, double[] dArray) {
        System.out.print(AstroMath.toString(string, dArray));
        if (!string.endsWith("\n")) {
            System.out.println("");
        }
    }

    public static final void printArray(String string, double[] dArray) {
        System.out.print(AstroMath.toString(string, dArray));
    }

    public static boolean test(int n, int n2) {
        int n3;
        int n4;
        boolean bl = true;
        System.out.println("#===AstroMath.test: verbosity=" + n + ", level=" + n2 + "; \u03b5=" + eps);
        double[] dArray = AstroMath.rotation("x", 30.0);
        double[] dArray2 = AstroMath.rotation("y", 45.0);
        double[] dArray3 = AstroMath.rotation("z", 60.0);
        double[] dArray4 = AstroMath.m3pm(dArray, dArray2, dArray3);
        double[] dArray5 = AstroMath.rotation("xyz", 30.0, 45.0, 60.0);
        if (n > 0) {
            AstroMath.printMatrix("# Rx(30\u00b0): ", dArray);
            AstroMath.printMatrix("# Ry(45\u00b0): ", dArray2);
            AstroMath.printMatrix("# Rz(60\u00b0): ", dArray3);
            AstroMath.printMatrix("# Product: ", dArray4);
            AstroMath.printMatrix("# combin.: ", dArray5);
        }
        bl = n <= 0 ? (bl &= AstroMath.diffArray(dArray4, dArray5) > 2.0 * eps) : (bl &= AstroMath.checkArray("#---Combined rotation vs matrix product", dArray4, dArray5));
        if (!bl) {
            System.out.println("#+++ok=false (1)");
        }
        double[] dArray6 = AstroMath.rotspin("xyz", 10.0, -20.0, 30.0, -1.0, 2.0, -3.0);
        double[] dArray7 = AstroMath.rotspin("zyx", -30.0, 20.0, -10.0, 3.0, -2.0, 1.0);
        double[] dArray8 = AstroMath.rot_inv(dArray6);
        double[] dArray9 = AstroMath.m36p(dArray, dArray6);
        double[] dArray10 = AstroMath.m36p(AstroMath.rot_inv(dArray6), AstroMath.rot_inv(dArray));
        if (n > 0) {
            System.out.println("");
            AstroMath.printMatrix("#[0]zero rotspin matrix\n", Urotspin);
            AstroMath.printMatrix("#[1]rotspin(xyz, 10, -20, 30, -1, 2, -3)\n", dArray6);
            AstroMath.printMatrix("#[2]...Inverse of this rotspin matrix..:\n", dArray8);
            AstroMath.printMatrix("#[3]rotspin(zyx, -30, 20, -10, 3, -2, 1)\n", dArray7);
            AstroMath.printMatrix("#[4].....................Rx*rotspin.....\n", dArray9);
            AstroMath.printMatrix("#[5]................Reverse*Rx-1........\n", dArray10);
        }
        if (n > 0) {
            AstroMath.printMatrix("#---Use msq(rotspin):\n", AstroMath.msq(dArray6));
            AstroMath.printMatrix("#....or .m6(rotspin):\n", AstroMath.m6(dArray6));
            bl &= AstroMath.checkArray("#---check     [2]=[3]", dArray7, dArray8);
            bl &= AstroMath.checkArray("#---check [1]x[2]=[0]", AstroMath.m36p(dArray6, dArray8), Urotspin);
            bl &= AstroMath.checkArray("#---check inv.[4]=[5]", AstroMath.rot_inv(dArray9), dArray10);
            bl &= AstroMath.checkUnity("#---check [1]x[2]=.1.", AstroMath.m36p(dArray6, dArray8));
        } else {
            bl &= AstroMath.diffArray(dArray7, dArray8) > 2.5 * eps && AstroMath.diffArray(AstroMath.m36p(dArray6, dArray8), Urotspin) > 2.5 * eps && AstroMath.diffArray(AstroMath.rot_inv(dArray9), dArray10) > 2.5 * eps && AstroMath.diffArray(AstroMath.m36p(dArray6, dArray8), Urotspin) > 2.5 * eps;
        }
        if (!bl) {
            System.out.println("#+++ok=false (2)");
        }
        int n5 = n2 * 100;
        double[] dArray11 = (double[])dArray6.clone();
        System.out.print("#...Verify " + n5 + "x matrix product:");
        for (n4 = 0; n4 < n5; ++n4) {
            if (n4 < 5) {
                System.out.print(" " + n4);
            } else if (n4 == 5) {
                System.out.print(" ...");
            } else if (n4 > n5 - 3) {
                System.out.print(" " + n4);
            }
            dArray6 = AstroMath.mpm(dArray6, dArray8, dArray11);
        }
        AstroMath.checkArray("", dArray6, dArray11);
        bl &= AstroMath.diffArray(dArray6, dArray11) < (double)n5 * eps;
        dArray6 = dArray11;
        double[] dArray12 = new double[]{1.0, 2.0, 4.0, 1.0, 2.0, 3.0};
        double[] dArray13 = AstroMath.msq(dArray12);
        if (n > 0) {
            AstroMath.printMatrix("#===symmetric 3x3:\n", dArray12);
            AstroMath.printMatrix("#===full      3x3:\n", dArray13);
            AstroMath.printMatrix("#===Transorm  3x3:\n", dArray);
            AstroMath.printMatrix("#---Symmetric mpt:\n", AstroMath.mpt(dArray, dArray12));
            AstroMath.printMatrix("#---full      mpt:\n", AstroMath.mpt(dArray, dArray13));
        }
        if (n > 0) {
            System.out.println("#---Verify covariance matrix");
        }
        double[] dArray14 = AstroMath.motionMatrix(1.0, dArray6);
        double[] dArray15 = new double[21];
        n5 = 6;
        for (n4 = 0; n4 < 6; ++n4) {
            dArray15[n4] = Math.rint(100.0 * Math.random()) / 50.0;
            for (n3 = n4 + 1; n3 < 6; ++n3) {
                dArray15[n5++] = Math.rint(2000.0 * Math.random() - 1000.0) / 1000.0;
            }
        }
        double[] dArray16 = AstroMath.msq(dArray15);
        if (n > 0) {
            AstroMath.printMatrix("#---Error+Correlation Matrix:\n", dArray15);
            AstroMath.printMatrix("#---Error+Correlation Matrix [6x6]:\n", dArray16);
        }
        n5 = 6;
        for (n4 = 0; n4 < 6; ++n4) {
            for (n3 = n4 + 1; n3 < 6; ++n3) {
                int n6 = n5++;
                dArray15[n6] = dArray15[n6] * (dArray15[n4] * dArray15[n3]);
            }
        }
        for (n4 = 0; n4 < 6; ++n4) {
            int n7 = n4;
            dArray15[n7] = dArray15[n7] * dArray15[n4];
        }
        if (n > 0) {
            AstroMath.printMatrix("#---Covariance Matrix:\n", dArray15);
        }
        for (n4 = 0; n4 < 6; ++n4) {
            for (n3 = 0; n3 < 6; ++n3) {
                if (n4 == n3) continue;
                int n8 = n4 * 6 + n3;
                dArray16[n8] = dArray16[n8] * (dArray16[n4 * 7] * dArray16[n3 * 7]);
            }
        }
        for (n4 = 0; n4 < 6; ++n4) {
            int n9 = n5 = 7 * n4;
            dArray16[n9] = dArray16[n9] * dArray16[n5];
        }
        if (n > 0) {
            AstroMath.printMatrix("#---Covariance Matrix [6x6]:\n", dArray16);
        }
        double[] dArray17 = (double[])dArray15.clone();
        n5 = 0;
        for (n4 = 0; n4 < 6; ++n4) {
            n3 = 0;
            while (n3 < 6) {
                if (n4 != n3 && (n5 & 1) != 0) {
                    dArray14[n5] = 0.0;
                }
                ++n3;
                ++n5;
            }
        }
        double[] dArray18 = AstroMath.mpt(dArray14, dArray16);
        double[] dArray19 = AstroMath.mpm(dArray14, dArray16, AstroMath.transposed(dArray14));
        double[] dArray20 = AstroMath.mpt(AstroMath.m6(dArray3), dArray16);
        double[] dArray21 = AstroMath.mpt(AstroMath.m6(dArray3), dArray15);
        if (n > 0) {
            AstroMath.printMatrix("#---Linear T:\n", dArray14);
            AstroMath.printMatrix("#===Transformed Covariance [6x6]:\n", dArray18);
            AstroMath.printMatrix("#===computed via .mpm()... [6x6]:\n", dArray19);
            AstroMath.checkArray("#===Diff. for the above .. [6x6]:", dArray19, dArray18);
            AstroMath.printMatrix("#===Transformed Covariance as Symmetric:\n", AstroMath.mpt(dArray14, dArray15));
            AstroMath.printMatrix("#....................(as.6x6)...........\n", AstroMath.msq(AstroMath.mpt(dArray14, dArray15)));
            AstroMath.printMatrix("#===Linear 3x3 transformation with Rz:\n", dArray3);
            AstroMath.printMatrix("#         (6x6) .....................:\n", AstroMath.m6(dArray3));
            AstroMath.printMatrix("#...compute cov(Rz.V) via 6x6:\n", dArray20);
            System.out.println("#---With symmetric matrix:");
            AstroMath.printMatrix("#...Compute cov(Rz.Sym) via mpt(m6(Rz)):\n", dArray21);
            System.out.println("#===Compare the 36 covariances:   ");
        } else {
            bl &= AstroMath.diffArray(dArray19, dArray18) > 2.0 * eps && AstroMath.diffArray(AstroMath.mpt(dArray3, dArray15), dArray21) > 2.0 * eps;
        }
        if (!bl) {
            System.out.println("#+++ok=false (3)");
        }
        if (bl) {
            System.out.println("#---End of AstroMath.tests: ok");
        } else {
            System.out.println("#***Bad ** AstroMath.tests?");
        }
        return bl;
    }
}

